/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */



/* FTP related */
typedef struct
  {
    char hostname[255];
    char hostadress[20];
    char username[128];
    char userpass[128];
    char account[128];
    int port;

    char use_firewall;
    char firewall_login_type;
    char firewall_hostname[255];
    char firewall_username[128];
    char firewall_userpass[128];
    int firewall_port;

    char host_type;
    char transfert_type;
    char dmode;
    char tmode;
    char resolve_link;
    char use_RDC;

    char uploads_filename;
    char uploads_perm;
    char uploads_date;
    char downloads_filename;
    char downloads_perm;
    char downloads_date;

    char local_dir[255];
    char start_dir[255];
    char cwd_dir[255];
    char local_filter[128];
    char remote_filter[128];
    char local_filter_directories;
    char remote_filter_directories;

    time_t timeout;
  }
FTPsession;



/* CUSTOM */
typedef struct
  {
    char program_version[10];
    FTPsession default_session;
    char debuglog_path[MPLEN];
    char debuglog_on;
    char lastlog_path[MPLEN];
    char lastlog_on;
    int retry_count;
    int retry_delay;
    char idle;
    int idle_delay;
    int recv_buffer;
    int send_buffer;
    char view_toolbar;
    GtkToolbarStyle toolbar_style;
    char view_connectbar;
    char view_console;
    char view_queue;
    char view_3D_borders;
    char view_shell_prompt;
    char view_ftp_prompt;
    char view_host_welcome_message;
    char view_host_directory_message;
    char view_local_files_size;
    char view_local_files_date;
    char view_local_files_owner;
    char view_local_files_group;
    char view_local_files_perm;
    char dirlist_hide_hidden;
    char view_remote_files_size;
    char view_remote_files_date;
    char view_remote_files_owner;
    char view_remote_files_group;
    char view_remote_files_perm;
    char ftplist_hide_hidden;
    int RDC_max_days;
    int console_max_lines;
    char use_netscape;
    char navigator_command[MPLEN];
    char email_client_command[MPLEN];
    char email_editor_command[MPLEN];
    char news_client_command[MPLEN];
    char text_editor_command[MPLEN];
    char xterm_command[MPLEN];

    /* new */
    char queue_max_retries;
  }
USERrc;

typedef struct
  {
    char username[80];
    char userpass[80];
    char local_dir[255];
    int index;
  }
USERprof;




/* DIR PANEL */
typedef struct
  {
    long int filesize;
    char filedate[25];
  }
FILEINFO;



/* DIALOG */
typedef struct
  {
    GtkWidget *entry;
    GtkWidget *check_case;
  }
FINDwidgets;

typedef struct
  {
    GtkWidget *entry;
    GtkWidget *check_mask;
    GtkWidget *check_remove;
    char select;
  }
GRPSELECTwidgets;

typedef struct
  {
    GtkWidget *entry;
    GtkWidget *check_dir;
  }
FILTERwidgets;



/* SITE MANAGER */
typedef struct
  {
    int index;
    int parent;
    char is_open;
    char name[255];
    char comment[2048];
    GtkCTreeNode *node;
    GtkCTreeNode *parent_node;
  }
MANAGERgroup;

typedef struct
  {
    int parent;
    char name[256];
    char comment[2048];
    char USE_DEFAULT;
    FTPsession session;
    GtkCTreeNode *node;
    GtkCTreeNode *parent_node;
  }
MANAGERsite;



/* RDC */
typedef struct
  {
    char flags[32];
  }
RDCstatus;



/* QUEUE */
typedef struct
  {
    FTPsession session;
    char xfer_type;
    char is_a_dir;
    char filename[255];
    long filesize;
    char retry;
    char status;
  }
QUEUEfile;

/* EOF */
