/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

typedef struct
  {
    GtkWidget *entry;
    GtkWidget *clist;
  }
BMKsitedlg;

typedef struct
  {
    GtkWidget *check_remote;
    GtkWidget *check_local;
  }
BMKpathdlg;

#define SMAN_MAX_INI_LINE_LENGTH 2048

#define IS_BOOKMARK_ROOT(node) (gtk_ctree_node_get_row_data(sman_tree, node)==bookroot)
#define IS_BOOKMARK_GROUP(node) (gtk_ctree_node_get_row_data(sman_tree, node)==bookgroup)
#define IS_BOOKMARK_SITE(node) (gtk_ctree_node_get_row_data(sman_tree, node)==booksite)



static FILE *bookmarks_file;
static GList *SMAN_GRP_list = NULL;
static GList *SMAN_SITE_list = NULL;
static GtkCTree *sman_tree;
static GtkCTreeNode *sman_book_node = NULL;
static GtkWidget *smanager_box;
static GtkWidget *sman_text;
static GtkWidget *sman_popup_menu;
static char IS_SITE_EDITED;
static MANAGERsite *current_bookmark_site = NULL;
static char *booksite =
{"BS"};
static char *bookgroup =
{"BG"};
static char *bookroot =
{"BR"};




static void SMAN_bookmark_retrieve_current_local_dir (MANAGERsite * this_site);
static void SMAN_bookmark_path (GtkWidget * widget, BMKpathdlg * bmk_dlg);
static void SMAN_bookmark_site (GtkWidget * widget, BMKsitedlg * bmk_dlg);

static void SMAN_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time);
static void SMAN_bookmark_site_from_url (char *this_url);


static GtkCTreeNode *SMAN_add_group_to_tree (GtkCTreeNode * parent, char *groupname, char IS_OPEN, gpointer row_data, char ON_TOP);
static GtkCTreeNode *SMAN_add_site_to_tree (GtkCTreeNode * parent, MANAGERsite * this_site, gpointer row_data);
static void SMAN_build_tree (void);


static GtkCTreeNode *SMAN_return_selected_node (void);
static GtkCTreeNode *SMAN_return_selected_node_parent_group (void);
static gint SMAN_tree_event_handler (GtkWidget * widget, GdkEvent * event, gpointer data);
static void SMAN_tree_site_selected (GtkWidget * widget, gint row, gint column, GdkEventButton * bevent, gpointer data);
static void SMAN_tree_row_selected (GtkCTree * ctree, GtkCTreeNode * this_node, gint col, /*GdkEventButton *event, */ GtkWidget * label);
static void SMAN_tree_expand_or_collapse (GtkCTree * ctree, GtkCTreeNode * this_node, /*GdkEventButton *event, */ int IS_OPEN);
void SMAN_tree_node_move (GtkCTree * ctree, GtkCTreeNode * child, GtkCTreeNode * parent, GtkCTreeNode * sibling, gpointer data);

static void SMAN_site_delete (GtkWidget * widget, gpointer data);

static char SMAN_is_group_index_in_use (int this_index);
static int SMAN_return_free_group_index (void);
static GtkCTreeNode *SMAN_convert_bookmark_group_index_to_node (int index);
static int SMAN_convert_bookmark_group_node_to_index (GtkCTreeNode * node);
static MANAGERgroup *SMAN_return_MANAGERgroup_from_node (GtkCTreeNode * node);
static MANAGERsite *SMAN_return_MANAGERsite_from_node (GtkCTreeNode * node);
static void SMAN_CLISTS_free (void);

static MANAGERgroup *SMAN_allocate_group_struct (void);
static MANAGERsite *SMAN_allocate_site_struct (void);
static void SMAN_write_node_to_bookmarks_file (GtkCTree * ctree, GtkCTreeNode * node, gpointer data);

/* EOF */
