/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


/* REMOTE SELECTION FUNCTIONS */

/* PUBLIC :
 * remote_select_all 
 * remote_unselect_all
 * remote_undo_last_selection
 * remote_select_all_files
 * remote_invert_selection
 */

void
remote_select_all (GtkWidget * widget, gpointer data)
{
  gtk_clist_select_all (GTK_CLIST (clist));
}

void
remote_unselect_all (GtkWidget * widget, gpointer data)
{
  gtk_clist_unselect_all (GTK_CLIST (clist));
}

void
remote_undo_last_selection (GtkWidget * widget, gpointer data)
{
  gtk_clist_undo_selection (GTK_CLIST (clist));
}

void
remote_select_all_files (GtkWidget * widget, gpointer data)
{
  int f;
  for (f = 1; f < last_dir_row; f++)
    gtk_clist_unselect_row (GTK_CLIST (clist), f, 0);
  for (f = last_dir_row; f < last_file_row; f++)
    gtk_clist_select_row (GTK_CLIST (clist), f, 0);
}

void
remote_invert_selection (GtkWidget * widget, gpointer data)
{
  GtkCListRow *clist_row;
  register int f = 0;

  if (GTK_CLIST (clist)->row_list == NULL)
    return;

  gtk_clist_freeze (GTK_CLIST (clist));

  for (f = 1; f < last_file_row; f++)
    if ((clist_row = (g_list_nth (GTK_CLIST (clist)->row_list, f))->data) != NULL)
      clist_row->state == GTK_STATE_SELECTED ? gtk_clist_unselect_row (GTK_CLIST (clist), f, 0) : gtk_clist_select_row (GTK_CLIST (clist), f, 0);

  gtk_clist_thaw (GTK_CLIST (clist));
}






/* GROUP SELECT FUNCTIONS */

/* PUBLIC:
 * remote_find_dialog
 * remote_find_next_dialog
 * remote_group_select_dialog
 * remote_group_deselect_dialog
 * remote_filter_dialog 
 * remote_compare_directories
 * STATIC :
 * remote_find
 * remote_group_select_deselect
 * remote_filter 
 */

/* FIND */

static void
remote_find (GtkWidget * widget, FINDwidgets * find_widgets)
{
  char CASE_SENSITIVE = GTK_TOGGLE_BUTTON (find_widgets->check_case)->active;
  char search_buf[256];
  register int this_row;
  gchar *filename;
  gchar *trav_filename;

  strcpy (search_buf, gtk_entry_get_text (GTK_ENTRY (find_widgets->entry)));

  for (this_row = search_row; this_row < last_file_row; this_row++)
    {
      gtk_clist_get_text (GTK_CLIST (clist), this_row, 1, &filename);
      trav_filename = g_strdup (filename);

      if (!CASE_SENSITIVE)
	{
	  strupr (search_buf);
	  strupr (trav_filename);
	}

      if (strstr (trav_filename, search_buf) != NULL)
	{
	  search_row = this_row;
	  gtk_clist_freeze (GTK_CLIST (clist));
	  gtk_clist_unselect_all (GTK_CLIST (clist));
	  gtk_clist_select_row (GTK_CLIST (clist), search_row, 0);
	  gtk_clist_thaw (GTK_CLIST (clist));
	  gtk_clist_moveto (GTK_CLIST (clist), search_row++, 0, 0.5, 0);
	  g_free (trav_filename);
	  return;
	}
      g_free (trav_filename);
    }
  gtk_clist_unselect_all (GTK_CLIST (clist));
  search_row = 1;
  {
    char msg_buf[256];
    sprintf (msg_buf, "No more match for \"%s\"\nRestarting from top of directory ...  ", gtk_entry_get_text (GTK_ENTRY (find_widgets->entry)));
    alert_ok ("Search Failed", msg_buf, "Ok");
  }
}

void
remote_find_dialog (GtkWidget * widget, gpointer data)
{
  search_row = 1;
  MEM0 (directory_search_string);
  find_dialog ("Remote Directory Search", directory_search_string, GTK_SIGNAL_FUNC (remote_find));
}

void
remote_find_next_dialog (GtkWidget * widget, gpointer data)
{
  find_dialog ("Remote Directory Search", directory_search_string, GTK_SIGNAL_FUNC (remote_find));
}



/* GRP SELECT/DESELECT */

static void
remote_group_select_deselect (GtkWidget * widget, GRPSELECTwidgets * grp_widgets)
{
  list_share_group_select_deselect (widget, grp_widgets, clist, last_dir_row, last_file_row);
}

void
remote_group_select_dialog (GtkWidget * widget, gpointer data)
{
  group_select_dialog ("Remote Group Select", GTK_SIGNAL_FUNC (remote_group_select_deselect), TRUE);
}

void
remote_group_deselect_dialog (GtkWidget * widget, gpointer data)
{
  group_select_dialog ("Remote Group Unselect", GTK_SIGNAL_FUNC (remote_group_select_deselect), FALSE);
}


/* FILTER */

static void
remote_filter (GtkWidget * widget, FILTERwidgets * filter_widgets)
{
  this_session.remote_filter_directories = GTK_TOGGLE_BUTTON (filter_widgets->check_dir)->active;
  strncpy (this_session.remote_filter, gtk_entry_get_text (GTK_ENTRY (filter_widgets->entry)), sizeof (this_session.remote_filter));
  gtk_widget_destroy (gtk_widget_get_toplevel (widget));
  g_free (filter_widgets);

  filter_search_type = FILTER_determine_search_type (this_session.remote_filter, &filter_search_ptr);

  WANT_REFRESH = FALSE;
  update_ftplist (this_session.cwd_dir);
}

void
remote_filter_dialog (GtkWidget * widget, gpointer data)
{
  filter_dialog ("Define Remote Filter", "", GTK_SIGNAL_FUNC (remote_filter), FALSE);
}



/* DIR INFO */

void
remote_dir_info (GtkWidget * widget, gpointer data)
{
  int all_files = 0;
  int all_dirs = 0;
  int all_links = 0;
  long all_files_size = 0;
  int selected_files = 0;
  int selected_dirs = 0;
  int selected_links = 0;
  long selected_files_size = 0;
  register int this_row;
  GList *selection = GTK_CLIST (clist)->selection;
  gchar *fileperm;
  gchar *filesize;


  for (this_row = 1; this_row < last_file_row; this_row++)
    {
      gtk_clist_get_text (GTK_CLIST (clist), this_row, 4, &fileperm);
      switch (fileperm[0])
	{
	case 'd':
	  all_dirs++;
	  break;
	case 'l':
	  all_links++;
	  break;
	default:
	  all_files++;
	  gtk_clist_get_text (GTK_CLIST (clist), this_row, 2, &filesize);
	  all_files_size += atol (filesize);
	}
    }

  while (selection)
    {
      this_row = GPOINTER_TO_INT (selection->data);
      gtk_clist_get_text (GTK_CLIST (clist), this_row, 4, &fileperm);
      switch (fileperm[0])
	{
	case 'd':
	  selected_dirs++;
	  break;
	case 'l':
	  selected_links++;
	  break;
	default:
	  selected_files++;
	  gtk_clist_get_text (GTK_CLIST (clist), this_row, 2, &filesize);
	  selected_files_size += atol (filesize);
	}
      selection = selection->next;
    }

  dir_info_dialog (this_session.cwd_dir, FALSE, all_files, all_files_size, all_dirs, all_links, selected_files, selected_files_size, selected_dirs, selected_links);
}



/* COMPARE DIRECTORIES */

void
remote_compare_directories (GtkWidget * widget, gpointer data)
{
  FILEINFO local_file_info;
  register int this_row;
  gchar *filename;
  gchar *filesize;
  char *filedate;
  extern char *strptime __P ((__const char *__s, __const char *__fmt, struct tm * __tp));

  gtk_clist_freeze (GTK_CLIST (clist));
  gtk_clist_unselect_all (GTK_CLIST (clist));

  for (this_row = 1; this_row < last_file_row; this_row++)
    {
      char IS_FOUND = FALSE;
      gtk_clist_get_text (GTK_CLIST (clist), this_row, 1, &filename);
      if (local_get_fileinfo (filename, &local_file_info))
	{
	  gtk_clist_get_text (GTK_CLIST (clist), this_row, 2, &filesize);
	  gtk_clist_get_text (GTK_CLIST (clist), this_row, 3, &filedate);

	  if (atol (filesize) == local_file_info.filesize)
	    {
	      struct tm local_date;
	      struct tm remote_date;
	      const char *remote_format = REMOTE_DATE_FORMAT;
	      const char *local_format = LOCAL_DATE_FORMAT;

	      strptime (filedate, remote_format, &remote_date);
	      strptime (local_file_info.filedate, local_format, &local_date);

	      if (local_date.tm_mday == remote_date.tm_mday)
		if (local_date.tm_mon == remote_date.tm_mon)
		  if (local_date.tm_year == remote_date.tm_year)
		    IS_FOUND = TRUE;
	    }
	}
      if (!IS_FOUND)
	gtk_clist_select_row (GTK_CLIST (clist), this_row, 0);
    }
  gtk_clist_thaw (GTK_CLIST (clist));
}

/* EOF */
