/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

static void queue_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time);
static void QUEUE_add_file_from_url (char *this_url);


/* DRAG & DROP */
static void
queue_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time)
{

  if (info == DND_TARGET_STRING)
    {

      if ((data->length >= 0) && (data->format == 8))
	{
	  printf ("DND [QUEUE] Received \"%s\"\n", (gchar *) data->data);
	  QUEUE_add_file_from_url (g_strdup ((gchar *) data->data));
	  gtk_drag_finish (context, TRUE, FALSE, time);
	}
      else
	gtk_drag_finish (context, FALSE, FALSE, time);
    }
}




static void
QUEUE_add_file_from_url (char *this_url)
{
  GdkPixmap *pixmap, *filepix;
  GdkBitmap *mask, *filemsk;
  guint8 spacing = 5;
  gchar *col[] =
  {"", "", "", "", ""};
  gint row;

  char local_buf[1024];
  char remote_buf[1024];
  char filesize[128];
  char this_port[256];
  char this_file[256];
  char this_type[256];
  char VALID_URL = FALSE;
  char *filename_ptr = strstr (this_url, "file:");

  QUEUEfile *Qfile = QUEUE_allocate_Qfile_struct ();
  FTPsession that_session;

  MEM0 (this_port);
  MEM0 (this_file);
  MEM0 (this_type);
  IGLOO_init_session (&that_session);
  MEM0 (that_session.username);
  MEM0 (that_session.userpass);

  VALID_URL =
    parse_ftp_url (this_url, that_session.username, that_session.userpass, that_session.hostname, this_port, that_session.start_dir, this_file, this_type);

  if (!VALID_URL
      || !strlen (that_session.hostname))
    {

      filename_ptr = (filename_ptr == NULL) ? this_url : (char *) this_url + 5;

      if (!access (filename_ptr, F_OK))		/* existe */
	{

	  if (!this_connexion.is_connected)
	    {
	      alert_ok ("Error", "Can't add a file for Upload,\nwhen NOT connected ....", "Ok");
	      g_free (this_url);
	      return;
	    }

	  Qfile->xfer_type = QUEUE_UPLOAD;
	}
      else
	{
	  alert_ok ("Error", "Not a file or a valid FTP URL.", "Ok");
	  g_free (this_url);
	  return;
	}
    }
  else
    {
      if (!strlen (that_session.start_dir))
	{
	  alert_ok ("Error", "Not a file or a dir.", "Ok");
	  g_free (this_url);
	  return;
	}

      Qfile->xfer_type = QUEUE_DOWNLOAD;
    }


  Qfile->status = QSTATUS_WAITING;

  switch (Qfile->xfer_type)
    {

    case QUEUE_UPLOAD:
      {
	struct stat stat_buf;
	char *ptr;

	stat (filename_ptr, &stat_buf);
	Qfile->session = this_session;
	Qfile->is_a_dir = ((stat_buf.st_mode & S_IFMT) == S_IFDIR);
	Qfile->filesize = (size_t) stat_buf.st_size;

	strcpy (Qfile->session.start_dir, this_session.cwd_dir);

	/* determine rpertoire local */
	strcpy (Qfile->session.local_dir, filename_ptr);
	I_do_not_want_a_terminal_slash_here (Qfile->session.local_dir);
	if ((ptr = strrchr (Qfile->session.local_dir, '/')) != NULL)
	  *ptr = 0;
	strcpy (Qfile->filename, (char *) ++ptr);
	if (!strlen (Qfile->session.local_dir))
	  strcpy (Qfile->session.local_dir, "/");
      }
      break;

    default:
    case QUEUE_DOWNLOAD:
      {
	if (strlen (this_port))
	  that_session.port = atoi (this_port);

	getcwd (that_session.local_dir, sizeof (that_session.local_dir));
	Qfile->session = that_session;
	Qfile->filesize = -1;

	if (strlen (this_file))
	  {
	    Qfile->is_a_dir = FALSE;
	    strcpy (Qfile->filename, this_file);
	  }
	else
	  {
	    char *ptr;
	    Qfile->is_a_dir = TRUE;

	    /* determine rpertoire et rpertoire parent */
	    I_do_not_want_a_terminal_slash_here (Qfile->session.start_dir);

	    if ((ptr = strrchr (Qfile->session.start_dir, '/')) != NULL)
	      {
		*ptr = 0;
		strcpy (Qfile->filename, (char *) ++ptr);
	      }
	    else
	      {
		strcpy (Qfile->filename, Qfile->session.start_dir);
		Qfile->session.start_dir[0] = 0;
	      }
	    /* fin */

	  }

	strcpy (Qfile->session.cwd_dir, Qfile->session.start_dir);
      }
      break;
    }

  g_free (this_url);


  sprintf (local_buf, "%s/%s", Qfile->session.local_dir, Qfile->filename);
  col[0] = local_buf;

  if (Qfile->filesize == -1)
    strcpy (filesize, "unknown");
  else
    sprintf (filesize, "%ld", Qfile->filesize);
  col[1] = filesize;

  sprintf (remote_buf, "//%s/%s/%s", Qfile->session.hostname, Qfile->session.start_dir, Qfile->filename);
  I_want_only_one_slash_here ((char *) (remote_buf + 1));
  col[3] = remote_buf;

  row = gtk_clist_append (GTK_CLIST (clist), col);
  pixmap = (Qfile->xfer_type == QUEUE_UPLOAD) ? arrow_right_pixmap (&mask) : arrow_left_pixmap (&mask);
  gtk_clist_set_pixmap (GTK_CLIST (clist), row, 2, pixmap, mask);
  filepix = Qfile->is_a_dir ? folder_pixmap (&filemsk) : default_file_pixmap (&filemsk);
  gtk_clist_set_pixtext (GTK_CLIST (clist), row, 0, col[0], spacing, filepix, filemsk);
  gtk_clist_set_pixtext (GTK_CLIST (clist), row, 3, col[3], spacing, filepix, filemsk);

  gtk_clist_set_row_data (GTK_CLIST (clist), row, (QUEUEfile *) Qfile);
  gtk_clist_moveto (GTK_CLIST (clist), row, 0, 1, 0);

  if (++Qentries == 1)
    queue_popup_menu_set_sensitive ();

  QUEUE_SAVED = FALSE;

  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
  gdk_pixmap_unref (filepix);
  gdk_pixmap_unref (filemsk);
}


/* EOF */
