/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>

#include "protos.h"

#define FILTER_SEARCH_IN_STRING 0
#define FILTER_SEARCH_STRING_BEGIN 1
#define FILTER_SEARCH_STRING_END 2

char
FILTER_determine_search_type (char *search_buf, char **search_ptr)
{
  char last_char;
  char search_type = 0;

  last_char = search_buf[strlen (search_buf) - 1];
  *search_ptr = search_buf;

  if (strchr (search_buf, '*') == NULL)
    search_type = FILTER_SEARCH_IN_STRING;
  else
    {
      if (search_buf[0] == '*')
	{
	  search_type = FILTER_SEARCH_STRING_END;
	  if (strchr (search_buf + 1, '*') != NULL)
	    {
	      if (last_char == '*')
		{
		  search_buf[strlen (search_buf) - 1] = 0;
		  (*search_ptr)++;
		}
	      else
		*search_ptr = search_buf;
	      search_type = FILTER_SEARCH_IN_STRING;
	    }
	  else
	    (*search_ptr)++;
	}
      else if (last_char == '*')
	{
	  search_buf[strlen (search_buf) - 1] = 0;
	  search_type = FILTER_SEARCH_STRING_BEGIN;
	}
    }

  if (!strlen (*search_ptr))
    search_type = FILTER_SEARCH_IN_STRING;

  return search_type;
}



char
FILTER_is_string_match (char search_type, char *this_string, char *search_ptr)
{
  if (search_ptr == NULL)
    return TRUE;
  switch (search_type)
    {
    case FILTER_SEARCH_STRING_BEGIN:
      return (char) (strstr (this_string, search_ptr) == (char *) this_string);
    case FILTER_SEARCH_STRING_END:
      return (char) (strstr (this_string, search_ptr) == (char *) (this_string + strlen (this_string) - (strlen (search_ptr))));
    default:
      break;

    }
  return (char) (strstr (this_string, search_ptr) != NULL);
}


/* EOF */
