/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


static GtkWidget *file_extension_entry;
static GtkWidget *file_editor_entry;
static GtkWidget *file_viewer_entry;
static GtkWidget *file_assoc_delete_button;
static GtkWidget *file_assoc_clist;
static GtkWidget *file_assoc_clist_window;
static char file_assoc_selected_col;



static void file_assoc_clist_clear_entries (void);
static void file_assoc_clist_add_row (void);
static void file_assoc_clist_delete_row (void);
static void file_assoc_row_select_unselect (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data);
static void insert_file_assoc_clist_row (GdkPixmap * pixmap, GdkBitmap * mask, char *this_extension, char *this_viewer, char *this_editor);
static void fill_file_assoc_clist (void);
static void save_file_assoc_clist (void);

static char get_current_file_association (void);
static void set_current_file_association (GtkWidget * widget, gpointer data);





static void
file_assoc_clist_clear_entries (void)
{
  gtk_entry_set_text (GTK_ENTRY (file_extension_entry), "");
  gtk_entry_set_text (GTK_ENTRY (file_viewer_entry), "");
  gtk_entry_set_text (GTK_ENTRY (file_editor_entry), "");
}


static void
file_assoc_clist_add_row (void)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  gchar *this_extension = gtk_entry_get_text (GTK_ENTRY (file_extension_entry));
  gchar *this_viewer = gtk_entry_get_text (GTK_ENTRY (file_viewer_entry));
  gchar *this_editor = gtk_entry_get_text (GTK_ENTRY (file_editor_entry));

  if (this_extension == NULL || this_viewer == NULL || this_editor == NULL)
    return;

  pixmap = default_file_pixmap (&mask);
  insert_file_assoc_clist_row (pixmap, mask, this_extension, this_viewer, this_editor);

  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
}


static void
file_assoc_row_edit (void)
{
  gchar *this_extension;
  gchar *this_viewer;
  gchar *this_editor;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  guint8 spacing;
  GList *selection = GTK_CLIST (file_assoc_clist)->selection;
  int row;

  if (selection == NULL)
    return;
  row = GPOINTER_TO_INT (selection->data);
  gtk_clist_get_text (GTK_CLIST (file_assoc_clist), row, 1, &this_viewer);
  gtk_clist_get_text (GTK_CLIST (file_assoc_clist), row, 2, &this_editor);
  gtk_clist_get_pixtext (GTK_CLIST (file_assoc_clist), row, 0, &this_extension, &spacing, &pixmap, &mask);

  gtk_entry_set_text (GTK_ENTRY (file_extension_entry), this_extension);
  gtk_entry_set_text (GTK_ENTRY (file_viewer_entry), this_viewer);
  gtk_entry_set_text (GTK_ENTRY (file_editor_entry), this_editor);
}






static void
file_assoc_update_col (GtkWidget * widget, GtkWidget * entry)
{
  GtkWidget *alert_window = gtk_widget_get_toplevel (entry);
  GList *selection = GTK_CLIST (file_assoc_clist)->selection;
  char buf[256];

  strcpy (buf, gtk_entry_get_text (GTK_ENTRY (entry)));
  gtk_widget_destroy (alert_window);

  if (selection == NULL)
    return;

  if (!file_assoc_selected_col)
    {
      GdkPixmap *pixmap = NULL;
      GdkBitmap *mask = NULL;
      guint8 spacing;
      gchar *nowhere;
      gtk_clist_get_pixtext (GTK_CLIST (file_assoc_clist), (int) selection->data, 0, &nowhere, &spacing, &pixmap, &mask);
      gtk_clist_set_pixtext (GTK_CLIST (file_assoc_clist), (int) selection->data, 0, buf, spacing, pixmap, mask);
    }
  else
    gtk_clist_set_text (GTK_CLIST (file_assoc_clist), (int) selection->data, file_assoc_selected_col, buf);
}


static void
file_assoc_button_clicked (GtkCList * clist, gint column)
{
  GList *selection = GTK_CLIST (file_assoc_clist)->selection;
  gchar *buf;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  guint8 spacing;
  gchar *title[3] =
  {"Extension(s)", "Viewer", "Editor"};

  if (selection == NULL)
    return;
  if ((file_assoc_selected_col = column))
    gtk_clist_get_text (GTK_CLIST (file_assoc_clist), (int) selection->data, column, &buf);
  else
    gtk_clist_get_pixtext (GTK_CLIST (file_assoc_clist), (int) selection->data, 0, &buf, &spacing, &pixmap, &mask);

  entry_dialog (title[column], "", "Update", buf, GTK_SIGNAL_FUNC (file_assoc_update_col));
}








static void
file_assoc_clist_delete_row (void)
{
  GList *selection = GTK_CLIST (file_assoc_clist)->selection;
  if (selection != NULL)
    gtk_clist_remove (GTK_CLIST (file_assoc_clist), GPOINTER_TO_INT (selection->data));
}


static void
file_assoc_row_select_unselect (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data)
{
  gtk_widget_set_sensitive (file_assoc_delete_button, GPOINTER_TO_INT (data));
  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    file_assoc_row_edit ();
}


static void
insert_file_assoc_clist_row (GdkPixmap * pixmap, GdkBitmap * mask, char *this_extension, char *this_viewer, char *this_editor)
{
  gchar *col[3] =
  {"", "", ""};
  int row;

  col[0] = this_extension;
  col[1] = this_viewer;
  col[2] = this_editor;
  row = gtk_clist_append (GTK_CLIST (file_assoc_clist), col);
  gtk_clist_set_pixtext (GTK_CLIST (file_assoc_clist), row, 0, col[0], 7, pixmap, mask);
}


static void
fill_file_assoc_clist (void)
{
  FILE *assoc_file;
  char this_path[1024];
  char this_line[1024];
  char extension[128];
  char editor[256];
  char viewer[256];
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  int this_line_number = 0;

  files_assoc_path (this_path);
  if ((assoc_file = fopen (this_path, "r")) == NULL)
    {
      alert_ok ("Error", "Can't read files association ini file.", "Ok");
      return;
    }

  pixmap = default_file_pixmap (&mask);
  gtk_clist_freeze (GTK_CLIST (file_assoc_clist));
  gtk_clist_clear (GTK_CLIST (file_assoc_clist));

#define FIELD_STRING strchr(this_line,'=')+1

  MEM0 (editor);
  MEM0 (extension);
  MEM0 (viewer);

  while (fgets (this_line, sizeof (this_line), assoc_file) != NULL)
    {
      this_line_number++;

      if (this_line[strlen (this_line) - 1] == '\n')
	this_line[strlen (this_line) - 1] = 0;

      if (!strlen (this_line))
	continue;

      if (this_line[0] == '#')
	continue;

      if (this_line[0] == '[')
	{
	  if (extension[0])
	    {
	      insert_file_assoc_clist_row (pixmap, mask, extension, viewer, editor);
	      MEM0 (editor);
	      MEM0 (extension);
	      MEM0 (viewer);
	    }
	  strcpy (extension, this_line + 1);
	  *(strrchr (extension, ']')) = 0;
	  continue;
	}

      if (strstr (this_line, "EDIT="))
	{
	  strcpy (editor, FIELD_STRING);
	  continue;
	}

      if (strstr (this_line, "VIEW="))
	{
	  strcpy (viewer, FIELD_STRING);
	  continue;
	}

      printf ("IglooFTP : Syntax error in %s\n", this_path);
      printf ("Line %i : %s\n", this_line_number, this_line);
    }

  if (extension[0])
    insert_file_assoc_clist_row (pixmap, mask, extension, viewer, editor);
  gtk_clist_thaw (GTK_CLIST (file_assoc_clist));

  fclose (assoc_file);

  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
}


static void
save_file_assoc_clist (void)
{
  FILE *assoc_file;
  char this_path[1024];
  register int row = 0;
  gchar *this_extension;
  gchar *this_viewer;
  gchar *this_editor;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  guint8 spacing;

  files_assoc_path (this_path);

  if ((assoc_file = fopen (this_path, "w")) == NULL)
    {
      alert_ok ("Error", "Can't save files association configuration file.", "Ok");
      return;
    }

  fprintf (assoc_file, "# IglooFTP files association configuration file.\n\n");

  for (row = 0; row < (GTK_CLIST (file_assoc_clist)->rows); row++)
    {
      gtk_clist_get_text (GTK_CLIST (file_assoc_clist), row, 1, &this_viewer);
      gtk_clist_get_text (GTK_CLIST (file_assoc_clist), row, 2, &this_editor);
      gtk_clist_get_pixtext (GTK_CLIST (file_assoc_clist), row, 0, &this_extension, &spacing, &pixmap, &mask);
      fprintf (assoc_file, "[%s]\nEDIT=%s\nVIEW=%s\n\n", this_extension, this_editor, this_viewer);
    }

  fprintf (assoc_file, "# END OF IglooFTP files association configuration file.\n\n");

  fflush (assoc_file);
  fclose (assoc_file);
}



static char
get_current_file_association (void)
{
  char this_path[1024];
  char linked_path[1024];

  files_assoc_path (this_path);
  MEM0 (linked_path);
  readlink (this_path, linked_path, sizeof (linked_path) - 1);

  if (strstr (linked_path, "GNOME"))
    return GNOME_ASS;

  if (strstr (linked_path, "KDE"))
    return KDE_ASS;

  return DEFAULT_ASS;
}

static void
set_current_file_association (GtkWidget * widget, gpointer data)
{
  char this_path[1024];
  char linked_path[1024];

  files_assoc_path (this_path);
  files_assoc_path (linked_path);
  unlink (this_path);

  switch ((int) GPOINTER_TO_INT (data))
    {
    case GNOME_ASS:
      strcat (linked_path, ".GNOME");
      break;
    case KDE_ASS:
      strcat (linked_path, ".KDE");
      break;
    default:
      strcat (linked_path, ".default");
    }

  symlink (linked_path, this_path);
  fill_file_assoc_clist ();
}


/* EOF */
