/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

static GtkWidget *clist;
static GtkWidget *dir_panel_box;
static GtkWidget *sort_arrow[8];
static GtkWidget *combo;
static GtkWidget *label_info;
static GtkWidget *frame_info;
static GtkWidget *prompt_entry;
static GtkWidget *dirlist_browser_label;
static GtkWidget *button_browser_open;
static GtkWidget *button_browser_close;
static GtkWidget *button_cdup;
static GtkWidget *browser_window;
static GtkWidget *clist_window;
static GtkCTree *dirlist_browser;
static GList *combo_items;

#define DIR_COMBO_ENTRY GTK_ENTRY(GTK_COMBO (combo)->entry)
static char UPDATE_POPUP_MENU = TRUE;
static char UPDATE_POPUP_MENU_SORT = TRUE;
static char UPDATE_POPUP_MENU_SORT_TYPE = TRUE;
static char UPDATE_TOOLBAR = TRUE;
static char BROWSER_VISIBLE = FALSE;

static int last_dir_row;
static int last_file_row;
static int search_row;
static long total_size;
static char label_info_text[100];
static char directory_search_string[128];
static long int chmod_mode = 644;
static char clist_col_sort;

static char filter_search_type;
static char *filter_search_ptr = NULL;




static char local_dir_recurse_chmod (char *filename);
static char local_dir_recurse_delete_file (char *filename);
static char local_dir_recurse_delete_dir (char *filename);

static int local_scandir_select (struct dirent *file_info);
static void update_dirlist (char *pathname);
static void dirlist_cdup (GtkWidget * widget, gpointer data);
static gint dirlist_event_handler (GtkWidget * this_list, GdkEvent * event, gpointer data);
static void dirlist_selection_made (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data);
static void dirlist_button_clicked (GtkCList * clist, gint column);
static void sort_button_clicked (gint column);


static void update_combo (char *pathname);
static void dir_combo_new_selection (GtkWidget * entry);
static void dir_combo_new_char_entered (GtkWidget * widget);

static void browser_enable (void);
static void browser_disable (void);
static void browser_hide (GtkWidget * widget, gpointer data);
static void browser_show (GtkWidget * widget, gpointer data);
static gint browser_event_handler (GtkWidget * widget, GdkEvent * event, gpointer data);

static void execute_user_command (GtkWidget * entry, GdkEventKey * event, gpointer data);

static long local_selection_size (void);
static char local_selected_is_executable (void);

static void local_chmod (GtkWidget * widget, GtkWidget * entry);
static void local_rename (GtkWidget * widget, GtkWidget * entry);
static void local_move (GtkWidget * widget, GtkWidget * entry);
static void local_delete (GtkWidget * widget, GtkWidget * alert_button);
static void local_create_directory (GtkWidget * widget, GtkWidget * entry);
static void local_change_directory (GtkWidget * widget, GtkWidget * entry);

static char upload_selection_recursive (void);
/* EOF */
