/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

/* DEFINES - VERSIONS */
#define SITE_MANAGER_VERSION 2
#define QUEUE_VERSION 1
#define QUEUE_HEADER "FTQ001"
#define QUEUE_EXT ".ftq"


/* DEFINES - GTK  */

#define gtk_clist_set_border(x,y) gtk_clist_set_shadow_type (x, y)
#define gtk_ctree_show_stub(x,y)  gtk_ctree_set_show_stub (x,y)
#define LAST_RADIO(x) gtk_radio_button_group (GTK_RADIO_BUTTON (x))
#define LAST_MENU_RADIO(x)  gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (x))



#define PROCESS_EVENTS  while (gtk_events_pending ())	 gtk_main_iteration ()
#define PROCESS_EVENTS_WHILE_XFER if (gtk_events_pending ()) PROCESS_EVENTS

#define DND_TARGET_STRING 0
#define DND_TARGET_URI_LIST 1



/* DEFINES - PATH */

#define MPLEN 1024


#ifndef SHARE_PATH
#define SHARE_PATH "/usr/local/src/IglooFTP"
#endif


#define PREFERENCES_PATH ".IglooFTP"
#define USER_LAYOUT "user.layout"
#define USER_TEXT_EXT "ASCII_files.ext"
#define USER_PREFERENCES "user.preferences"
#define USER_FILES_ASSOC "app_ass"
#define USER_FILES_ASSOC_DIR  USER_FILES_ASSOC
#define USER_PROF ".user.profiles"
#define USER_LASTLOG "last_connexion.log"
#define USER_DEBUGLOG "debug.log"
#define HOST_HISTORY "history.hosts"
#define CACHE_DIR "cache"
#define BMK_DIR "bookmarks"
#define USER_BMK "IglooFTP.bmk"
#define DEFAULT_BMK "default.bmk"
#define RDC_DIR "RDC"
#define RDC_LIST "files.lst"
#define RDC_STATUS "/RDC.status"
#define RDC_LAST_CLEAN "last_clean"
#define QUEUE_DIR "FTQ"
#define SPAWN_TMP "spawn_session"

#define DATA_PERM S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH	//0666
#define RC_PERM S_IRUSR | S_IWUSR	//0600
#define RC_FOLDER_PERM S_IRWXU	//0700

#define ASCII_FILES_DEFAULT_EXTENSIONS ".C.CPP.DOC.H.HTM.HTML.JS.LSM.MAK.MSG.PHP3.TXT"

#define INTERNAL_APP_TXT "default"


/* DEFINES - ARG */
#define SPAWN_ARG "-spawn"

/* DEFINES - FONT */
#define CLIST_PROP_FONT "-b&h-lucidatypewriter-medium-r-normal-*-12-*-*-*-m-*-*-*"
#define FTP_BROWSER_BOLD_FONT "-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-*-*"



/* DEFINES - COLORS */
#define DIR_COLOR BLUE
#define LNK_COLOR LBLUE
#define FILE_COLOR BLACK
#define CONSOLE_BG WHITE
#define SELECT_BG LYELLOW
#define SELECT_FG BLACK
#define RDC_LAST_UPDATED GREYCYAN



/* DEFINES - PROGRAM  */
#define DEFAULT_PASSWORD "IglooFTP@littleigloo.org"

#define PASSWORD_USE_SAVED 0
#define PASSWORD_USE_DEFAULT 1
#define PASSWORD_ASK_ON_CONNECT 2


#define SITE_DEFAULT_PASSWORD_TEXT "DEFAULT"
#define SITE_ASK_PASSWORD_TEXT "ASK"

#define LOCAL_FOCUS 1
#define REMOTE_FOCUS 2

#define USE_RDC  this_session.use_RDC
#define USE_FIREWALL this_session.use_firewall && (this_session.firewall_login_type)
#define RDC_SITE_DIR USE_FIREWALL ? this_connexion.hostname : this_connexion.connect_address

#define UPLOAD_XPM 0
#define DOWNLOAD_XPM 1

#define MANAGER_BUTTON 2
#define MANAGER_BUTTON_CLOSE 3

#define DIRLIST_HIDE_HIDDEN FALSE

#define REMOTE_DATE_FORMAT  FTP_REMOTE_DATE_FORMAT
//#define LOCAL_DATE_FORMAT "%b %d %Y %H:%M"
#define LOCAL_DATE_FORMAT "%b %d %Y"

#define MAX_HOST_HISTORY_LINES 15


#define DUP_abort 0
#define DUP_overwrite 1
#define DUP_resume 2
#define DUP_append DUP_resume
#define DUP_skip 3
#define DUP_rename 4
#define DUP_overwrite_all 5
#define DUP_skip_all 6


#define XFER_FILENAME_PRESERVE 0
#define XFER_FILENAME_UPPER 1
#define XFER_FILENAME_LOWER 2

#define DIR_COL_SORT_BY_NAME 1
#define DIR_COL_SORT_BY_SIZE 2
#define DIR_COL_SORT_BY_DATE 3
#define DIR_COL_SORT_BY_PERM 4
#define DIR_COL_SORT_BY_UID 5
#define DIR_COL_SORT_BY_GID 6

#define FTP_COL_SORT_BY_NAME 1
#define FTP_COL_SORT_BY_SIZE 2
#define FTP_COL_SORT_BY_DATE 3
#define FTP_COL_SORT_BY_PERM 4
#define FTP_COL_SORT_BY_UID 5
#define FTP_COL_SORT_BY_GID 6

#define SORT_BY_NAME 1
#define SORT_BY_SIZE 2
#define SORT_BY_DATE 3
#define SORT_BY_PERM 4
#define SORT_BY_UID 5
#define SORT_BY_GID 6

#define SORT_DOWN TRUE
#define SORT_UP FALSE

#define DOC_COPYING 0
#define DOC_WELCOME_MSG 1
#define DOC_README 2
#define DOC_CHANGES 3

#define DEFAULT_ASS 0
#define GNOME_ASS 1
#define KDE_ASS 2

#define QUEUE_DOWNLOAD 1
#define QUEUE_UPLOAD 2






/* DEFINES - URL */
#define HOME_URL "http://www.littleigloo.org"
#define DEFAULT_URL HOME_URL
#define SUPPORT_URL HOME_URL
#define VERSION_URL HOME_URL



/* DEFINES - MACROS DIVERSES */
#define MEM0(x)  memset(x, 0, sizeof(x));
#define I_do_not_want_a_terminal_slash_here(x);  if (strlen(x)>1 && x[strlen (x) - 1] == '/') x[strlen (x) - 1] = 0;



/* EOF */
