/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */






/* CUSTOM USER PROFILES */

/* PUBLIC : (called by connect_bar)
 * count_total_number_of_profiles 
 * retrieve_local_dir_from_user_profile
 * read_prof 
 * STATIC :
 * write_prof 
 * add_prof 
 * edit_prof
 * delete_prof  
 * add_or_edit_user_prof_from_file
 * delete_user_prof_from_file
 * dialog_user_prof
 * update_proflist 
 * clear_user_prof 
 * update_button_prof 
 */


static void
write_prof (int profile_number, USERprof * this_prof)
{
  int file_handle;
  char prof_path[1024];
  sprintf (prof_path, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_PROF);
  file_handle = open (prof_path, O_CREAT | O_RDWR, RC_PERM);
  if (profile_number != -1)
    lseek (file_handle, (profile_number) * sizeof (*this_prof), SEEK_SET);
  else
    lseek (file_handle, 0L, SEEK_END);
  MemFrob (this_prof, sizeof (*this_prof));
  write (file_handle, this_prof, sizeof (*this_prof));
  close (file_handle);
}


void
read_prof (int profile_number, USERprof * this_prof)
{
  int file_handle;
  char prof_path[1024];
  sprintf (prof_path, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_PROF);
  file_handle = open (prof_path, O_RDONLY, RC_PERM);
  lseek (file_handle, (profile_number) * sizeof (*this_prof), SEEK_SET);
  read (file_handle, this_prof, sizeof (*this_prof));
  MemFrob (this_prof, sizeof (*this_prof));
  close (file_handle);
}


int
count_total_number_of_profiles (void)
{
  struct stat stat_buf;
  char prof_file[1024];
  sprintf (prof_file, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_PROF);
  if (access (prof_file, F_OK))
    return 0;
  stat (prof_file, &stat_buf);
  return ((off_t) stat_buf.st_size / sizeof (USERprof));
}


void
retrieve_local_dir_from_user_profile (void)
{
  const int index_total = count_total_number_of_profiles ();
  register int index = 0;
  USERprof this_prof;
  while (index < index_total)
    {
      read_prof (index++, &this_prof);
      if (!strcmp (this_session.username, this_prof.username))
	{
	  index = index_total;
	  strcpy (this_session.local_dir, this_prof.local_dir);
	}
    }
}




static void
add_prof (void)
{
  USERprof this_prof;
  memset (&this_prof, 0, sizeof (this_prof));
  strcpy (this_prof.local_dir, user_rc.default_session.local_dir);
  this_prof.index = -1;
  dialog_user_prof (&this_prof, "Add User Profile");
}


static void
edit_prof (void)
{
  USERprof this_prof;
  GList *selection = GTK_CLIST (clist)->selection;
  if (selection == NULL)
    return;
  memset (&this_prof, 0, sizeof (this_prof));
  this_prof.index = (int) selection->data;
  read_prof (this_prof.index, &this_prof);
  this_prof.index = (int) selection->data;
  dialog_user_prof (&this_prof, "Edit User Profile");
}


static void
delete_prof (void)
{
  USERprof this_prof;
  GList *selection = GTK_CLIST (clist)->selection;
  char msg_buf[256];

  if (selection == NULL)
    return;
  read_prof ((int) selection->data, &this_prof);

  sprintf (msg_buf, " Delete %s ?", this_prof.username);
  alert_ok_cancel ("Delete Profile", msg_buf, "Delete", GTK_SIGNAL_FUNC (delete_user_prof_from_file));
}


static void
add_or_edit_user_prof_from_file (GtkWidget * widget, int data)
{
  USERprof this_prof;

  strcpy (this_prof.username, gtk_entry_get_text (GTK_ENTRY (prof_username)));
  strcpy (this_prof.userpass, gtk_entry_get_text (GTK_ENTRY (prof_userpass)));
  strcpy (this_prof.local_dir, gtk_entry_get_text (GTK_ENTRY (prof_local_dir)));
  if (!strlen (this_prof.username) || !strlen (this_prof.userpass) || !strlen (this_prof.local_dir))
    {
      alert_ok ("Missing Information", "Please fill all field.", "Ok");
      return;
    }

  this_prof.index = data;
  write_prof (this_prof.index, &this_prof);
  gtk_widget_destroy (gtk_widget_get_toplevel (widget));
  update_proflist ();
}


static void
delete_user_prof_from_file (GtkWidget * widget, gpointer data)
{
  const int remove_this_one = (int) GTK_CLIST (clist)->selection->data;
  char tmp_filename[256];
  char prof_path[1024];
  const int index_total = count_total_number_of_profiles ();
  int index = 0;
  int tmp_index = 0;
  int file_handle;
  USERprof this_prof;

  gtk_widget_destroy (gtk_widget_get_toplevel (widget));
  sprintf (prof_path, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_PROF);
  tmpnam (tmp_filename);
  rename (prof_path, tmp_filename);
  file_handle = open (tmp_filename, O_RDONLY, RC_PERM);

  for (index = 0; index < index_total; index++)
    {
      read (file_handle, &this_prof, sizeof (this_prof));
      MemFrob (&this_prof, sizeof (this_prof));
      if (index != remove_this_one)
	write_prof (tmp_index++, &this_prof);
    }

  close (file_handle);
  unlink (tmp_filename);
  update_proflist ();
}


static void
dialog_user_prof (USERprof * this_prof, gchar * title)
{
  GtkWidget *prof_window;
  GtkWidget *prof_frame;
  GtkWidget *prof_fixed;
  GtkWidget *prof_separator;
  GtkWidget *prof_hbox;
  GtkWidget *prof_ok;
  GtkWidget *prof_clear;
  GtkWidget *prof_cancel;

  prof_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (prof_window), title);
  gtk_window_position (GTK_WINDOW (prof_window), GTK_WIN_POS_MOUSE);
  gtk_widget_realize (prof_window);
  gdk_window_set_decorations (prof_window->window, GDK_DECOR_BORDER | GDK_DECOR_TITLE);
  gtk_window_set_transient_for (GTK_WINDOW (prof_window), GTK_WINDOW (rc_window));

  prof_frame = gtk_frame_new (NULL);
  gtk_widget_show (prof_frame);
  gtk_container_add (GTK_CONTAINER (prof_window), prof_frame);
  gtk_frame_set_shadow_type (GTK_FRAME (prof_frame), GTK_SHADOW_OUT);


  prof_fixed = gtk_fixed_new ();
  gtk_container_add (GTK_CONTAINER (prof_frame), prof_fixed);
  gtk_widget_show (prof_fixed);
  gtk_widget_set_usize (prof_fixed, 365, 155);

  fixed_label (prof_fixed, 15, 20, "User Name :");
  prof_username = fixed_entry (prof_fixed, 120, 15, 232, 24, this_prof->username);
  fixed_label (prof_fixed, 15, 50, "User Password :");
  prof_userpass = fixed_entry (prof_fixed, 120, 45, 232, 24, this_prof->userpass);
  gtk_entry_set_visibility (GTK_ENTRY (prof_userpass), FALSE);
  fixed_label (prof_fixed, 15, 80, "Local Directory : ");
  prof_local_dir = fixed_dir_entry (prof_fixed, 120, 75, 232, 24, this_prof->local_dir);

  prof_separator = gtk_hseparator_new ();
  gtk_fixed_put (GTK_FIXED (prof_fixed), prof_separator, 0, 107);
  gtk_widget_set_usize (prof_separator, 370, -1);
  gtk_widget_show (prof_separator);

  prof_hbox = gtk_hbox_new (TRUE, 5);
  gtk_container_border_width (GTK_CONTAINER (prof_hbox), 5);
  gtk_fixed_put (GTK_FIXED (prof_fixed), prof_hbox, 0, 112);
  gtk_widget_set_usize (prof_hbox, 360, 40);
  gtk_widget_show (prof_hbox);

  custom_pixmap (prof_window, prof_hbox);
  prof_ok = fixed_button (prof_hbox, "Done");
  prof_clear = fixed_button (prof_hbox, "Clear");
  prof_cancel = fixed_button (prof_hbox, "Cancel");
  gtk_signal_connect (GTK_OBJECT (prof_ok), "clicked", GTK_SIGNAL_FUNC (add_or_edit_user_prof_from_file), GINT_TO_POINTER (this_prof->index));
  gtk_signal_connect (GTK_OBJECT (prof_clear), "clicked", GTK_SIGNAL_FUNC (clear_user_prof), NULL);
  gtk_signal_connect_object (GTK_OBJECT (prof_cancel), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (prof_window));

  gtk_widget_show (prof_window);
}


static void
clear_user_prof (GtkWidget * widget, gpointer data)
{
  gtk_entry_set_text (GTK_ENTRY (prof_username), "");
  gtk_entry_set_text (GTK_ENTRY (prof_userpass), "");
  gtk_entry_set_text (GTK_ENTRY (prof_local_dir), "");
}


static void
update_proflist (void)
{
  const int index_total = count_total_number_of_profiles ();
  register int index = 0;
  USERprof this_prof;
  gchar *col[2] =
  {"", ""};
  GdkBitmap *foldermsk;
  GdkPixmap *folderpix = folder_pixmap (&foldermsk);

  gtk_clist_freeze (GTK_CLIST (clist));
  gtk_clist_clear (GTK_CLIST (clist));

  if (index_total)
    for (index = 0; index < index_total; index++)
      {
	read_prof (index, &this_prof);
	col[0] = this_prof.username;
	col[1] = this_prof.local_dir;
	gtk_clist_append (GTK_CLIST (clist), col);
	gtk_clist_set_pixtext (GTK_CLIST (clist), index, 1, this_prof.local_dir, 5, folderpix, foldermsk);
	gtk_clist_set_foreground (GTK_CLIST (clist), index, &BLUE);

      }
  gtk_clist_thaw (GTK_CLIST (clist));
}


static void
update_button_prof (GtkWidget * this_list, gint row, gint column,
		    GdkEventButton * event, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  gtk_widget_set_sensitive (button_user_edit, selection != NULL);
  gtk_widget_set_sensitive (button_user_delete, selection != NULL);

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    edit_prof ();
}



/* EOF */
