/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

/* CUSTOM IO functions */

/* STATIC : 
 * create_rc
 * save_rc 
 * read_rc 
 */

static void
create_rc (void)
{
  struct utsname uname_buf;
  memset (&user_rc, 0, sizeof (user_rc));
  uname (&uname_buf);

  //version (user_rc.program_version);

  user_rc.default_session.port = 21;
  user_rc.default_session.timeout = 45;
  user_rc.default_session.dmode = PASV_MODE;
  user_rc.default_session.resolve_link = FALSE;
  user_rc.default_session.host_type = HOST_AUTODETECT;
  user_rc.default_session.tmode = TYPE_AUTODETECT;
  user_rc.default_session.use_RDC = TRUE;
  strcpy (user_rc.default_session.username, "anonymous");
  strcpy (user_rc.default_session.userpass, DEFAULT_PASSWORD);
  strcpy (user_rc.default_session.start_dir, "");
  strcpy (user_rc.default_session.cwd_dir, user_rc.default_session.start_dir);

  strcpy (user_rc.default_session.local_dir, home_path);

  sprintf (user_rc.lastlog_path, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_LASTLOG);
  user_rc.lastlog_on = TRUE;
  sprintf (user_rc.debuglog_path, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_DEBUGLOG);
  user_rc.debuglog_on = TRUE;


  user_rc.retry_count = 10;
  user_rc.retry_delay = 3;

  user_rc.idle = TRUE;
  user_rc.idle_delay = 45;
  user_rc.recv_buffer = 4096;
  user_rc.send_buffer = 4096;

  user_rc.queue_max_retries = 2;

  /* view */
  user_rc.view_toolbar = TRUE;
  user_rc.toolbar_style = GTK_TOOLBAR_ICONS;
  user_rc.view_connectbar = TRUE;
  user_rc.view_console = TRUE;
  user_rc.view_queue = TRUE;
  user_rc.view_shell_prompt = TRUE;
  user_rc.view_ftp_prompt = TRUE;
  user_rc.view_3D_borders = TRUE;

  user_rc.view_local_files_size = TRUE;
  user_rc.view_local_files_date = TRUE;
  user_rc.view_local_files_owner = TRUE;
  user_rc.view_local_files_group = TRUE;
  user_rc.view_local_files_perm = TRUE;

  user_rc.view_remote_files_size = TRUE;
  user_rc.view_remote_files_date = TRUE;
  user_rc.view_remote_files_owner = TRUE;
  user_rc.view_remote_files_group = TRUE;
  user_rc.view_remote_files_perm = TRUE;

  user_rc.dirlist_hide_hidden = TRUE;
  user_rc.ftplist_hide_hidden = FALSE;

  user_rc.view_host_welcome_message = TRUE;
  user_rc.view_host_directory_message = TRUE;

  /* tools */
  user_rc.use_netscape = TRUE;
  strcpy (user_rc.text_editor_command, INTERNAL_APP_TXT);
  strcpy (user_rc.xterm_command, "nxterm -fn -misc-fixed-medium-r-normal-*-14-*-100-100-*-*-*-*");

  /* cache */
  user_rc.RDC_max_days = 0;
  user_rc.console_max_lines = 500;

}










/* SAVE */

void
save_rc (void)
{
  FILE *preferences_file;
  char this_path[1024];

  preferences_path (this_path);
  if ((preferences_file = fopen (this_path, "w")) == NULL)
    {
      alert_ok ("Error", "Can't save preferences ini file.", "Ok");
      return;
    }
  fprintf (preferences_file, "# IglooFTP preferences configuration file.\n\n");

#define CUSTOM_SECTION(a)  fprintf (preferences_file, "\n\n[%s]\n", a)
#define CUSTOM_SAVE_INT(a,b)  fprintf (preferences_file, "%s=%i\n", a, (int) b)
#define CUSTOM_SAVE_BOOL(a,b)  fprintf (preferences_file, "%s=%i\n", a, b ? 1 : 0)
#define CUSTOM_SAVE_STRING(a,b)  fprintf (preferences_file, "%s=%s\n", a, b)



  /* VERSION */
  CUSTOM_SECTION ("VERSION");
  CUSTOM_SAVE_STRING ("PROGRAM_VERSION", user_rc.program_version);


  /* GENERAL */
  CUSTOM_SECTION ("GENERAL");
  CUSTOM_SAVE_STRING ("NAME", user_rc.default_session.username);
  CUSTOM_SAVE_STRING ("PASSWORD", user_rc.default_session.userpass);
  CUSTOM_SAVE_STRING ("LOCAL_DIR", user_rc.default_session.local_dir);
  CUSTOM_SAVE_STRING ("REMOTE_DIR", user_rc.default_session.start_dir);
  CUSTOM_SAVE_INT ("DEFAULT_PORT", user_rc.default_session.port);

  switch (user_rc.default_session.tmode)
    {
    case TYPE_ASCII:
      fprintf (preferences_file, "TRANSFERT_TYPE=ASCII\n");
      break;
    case TYPE_BIN:
      fprintf (preferences_file, "TRANSFERT_TYPE=BIN\n");
      break;
    case TYPE_LOCAL:
      fprintf (preferences_file, "TRANSFERT_TYPE=LOCAL\n");
      break;
    }

  fprintf (preferences_file, "HOST_TYPE=%s\n", host_type_name[(int) user_rc.default_session.host_type]);


  /* ADVANCED */
  CUSTOM_SECTION ("ADVANCED");
  CUSTOM_SAVE_INT ("RETRY_COUNT", user_rc.retry_count);
  CUSTOM_SAVE_INT ("RETRY_DELAY", user_rc.retry_delay);
  CUSTOM_SAVE_INT ("TIMEOUT", user_rc.default_session.timeout);
  CUSTOM_SAVE_INT ("RECV_BUF", user_rc.recv_buffer);
  CUSTOM_SAVE_INT ("SEND_BUF", user_rc.send_buffer);
  CUSTOM_SAVE_INT ("UPLOADS_FILENAME_CASE", user_rc.default_session.uploads_filename);
  CUSTOM_SAVE_BOOL ("UPLOADS_PRESERVE_PERM", user_rc.default_session.uploads_perm);
  CUSTOM_SAVE_BOOL ("UPLOADS_PRESERVE_DATE", user_rc.default_session.uploads_date);
  CUSTOM_SAVE_INT ("DOWNLOADS_FILENAME_CASE", user_rc.default_session.downloads_filename);
  CUSTOM_SAVE_BOOL ("DOWNLOADS_PRESERVE_PERM", user_rc.default_session.downloads_perm);
  CUSTOM_SAVE_BOOL ("DOWNLOADS_PRESERVE_DATE", user_rc.default_session.downloads_date);
  CUSTOM_SAVE_INT ("QUEUE_MAX_RETRIES", user_rc.queue_max_retries);
  CUSTOM_SAVE_BOOL ("ANTI_IDLE", user_rc.idle);
  CUSTOM_SAVE_INT ("ANTI_IDLE_DELAY", user_rc.idle_delay);
  CUSTOM_SAVE_BOOL ("RESOLVE_LINKS", user_rc.default_session.resolve_link);
  CUSTOM_SAVE_BOOL ("PASV", user_rc.default_session.dmode);



  /* FIREWALL */
  CUSTOM_SECTION ("FIREWALL");
  CUSTOM_SAVE_BOOL ("USE_FIREWALL", user_rc.default_session.use_firewall);
  CUSTOM_SAVE_STRING ("FIREWALL_HOST", user_rc.default_session.firewall_hostname);
  CUSTOM_SAVE_INT ("FIREWALL_PORT", user_rc.default_session.firewall_port);
  CUSTOM_SAVE_STRING ("FIREWALL_USER", user_rc.default_session.firewall_username);
  CUSTOM_SAVE_STRING ("FIREWALL_PASS", user_rc.default_session.firewall_userpass);
  CUSTOM_SAVE_INT ("FIREWALL_LOGIN_TYPE", (char) user_rc.default_session.firewall_login_type);


  /* VIEW */
  CUSTOM_SECTION ("VIEW");
  CUSTOM_SAVE_BOOL ("TOOLBAR", user_rc.view_toolbar);
  CUSTOM_SAVE_INT ("TOOLBAR_STYLE", user_rc.toolbar_style);
  CUSTOM_SAVE_BOOL ("CONNECTBAR", user_rc.view_connectbar);
  CUSTOM_SAVE_BOOL ("CONSOLE", user_rc.view_console);
  CUSTOM_SAVE_BOOL ("QUEUE", user_rc.view_queue);
  CUSTOM_SAVE_BOOL ("LOCAL_PROMPT", user_rc.view_shell_prompt);
  CUSTOM_SAVE_BOOL ("REMOTE_PROMPT", user_rc.view_ftp_prompt);
  CUSTOM_SAVE_BOOL ("3D_BORDERS", user_rc.view_3D_borders);

  CUSTOM_SAVE_BOOL ("HOST_WELCOME_MSG", user_rc.view_host_welcome_message);
  CUSTOM_SAVE_BOOL ("HOST_DIRECTORY_MSG", user_rc.view_host_directory_message);

  CUSTOM_SAVE_BOOL ("LOCAL_FILES_SIZE", user_rc.view_local_files_size);
  CUSTOM_SAVE_BOOL ("LOCAL_FILES_DATE", user_rc.view_local_files_date);
  CUSTOM_SAVE_BOOL ("LOCAL_FILES_OWNER", user_rc.view_local_files_owner);
  CUSTOM_SAVE_BOOL ("LOCAL_FILES_GROUP", user_rc.view_local_files_group);
  CUSTOM_SAVE_BOOL ("LOCAL_FILES_PERM", user_rc.view_local_files_perm);
  CUSTOM_SAVE_BOOL ("LOCAL_HIDDEN_FILES", user_rc.dirlist_hide_hidden);

  CUSTOM_SAVE_BOOL ("REMOTE_FILES_SIZE", user_rc.view_remote_files_size);
  CUSTOM_SAVE_BOOL ("REMOTE_FILES_DATE", user_rc.view_remote_files_date);
  CUSTOM_SAVE_BOOL ("REMOTE_FILES_OWNER", user_rc.view_remote_files_owner);
  CUSTOM_SAVE_BOOL ("REMOTE_FILES_GROUP", user_rc.view_remote_files_group);
  CUSTOM_SAVE_BOOL ("REMOTE_FILES_PERM", user_rc.view_remote_files_perm);
  CUSTOM_SAVE_BOOL ("REMOTE_HIDDEN_FILES", user_rc.ftplist_hide_hidden);


  /* APPLICATIONS */
  CUSTOM_SECTION ("APPLICATIONS");
  CUSTOM_SAVE_BOOL ("USE_NETSCAPE", user_rc.use_netscape);
  CUSTOM_SAVE_STRING ("NAVIGATOR", user_rc.navigator_command);
  CUSTOM_SAVE_STRING ("EMAIL_CLIENT", user_rc.email_client_command);
  CUSTOM_SAVE_STRING ("EMAIL_EDITOR", user_rc.email_editor_command);
  CUSTOM_SAVE_STRING ("NEWS_CLIENT", user_rc.news_client_command);
  CUSTOM_SAVE_STRING ("TEXT_EDITOR", user_rc.text_editor_command);
  CUSTOM_SAVE_STRING ("XTERM", user_rc.xterm_command);


  /* CACHE */
  CUSTOM_SECTION ("CACHE");
  CUSTOM_SAVE_BOOL ("RDC", user_rc.default_session.use_RDC);
  CUSTOM_SAVE_INT ("RDC_MAX_DAYS", user_rc.RDC_max_days);
  CUSTOM_SAVE_INT ("CONSOLE_MAX_LINES", user_rc.console_max_lines);


  fprintf (preferences_file, "\n\n# END OF IglooFTP preferences configuration file.");
  fflush (preferences_file);
  fclose (preferences_file);
}











/* READ */

static void
read_rc (void)
{
  FILE *preferences_file;
  char this_path[1024];
  char this_line[256];
  int this_line_number = 0;

  preferences_path (this_path);

  if (access (this_path, F_OK))
    return;

  if ((preferences_file = fopen (this_path, "r")) == NULL)
    return;

#define FIELD_INT (int) atoi(strchr(this_line,'=')+1)
#define FIELD_BOOL (FIELD_INT!=0)
#define FIELD_STRING strchr(this_line,'=')+1

#define CUSTOM_LOAD_INT(a,b);  if(strstr (this_line, a"=")){b = FIELD_INT;continue;}
#define CUSTOM_LOAD_BOOL(a,b);  if(strstr (this_line, a"=")){b = FIELD_BOOL;continue;}
#define CUSTOM_LOAD_STRING(a,b);  if(strstr (this_line, a"=")){strcpy(b, FIELD_STRING);continue;}



  while (fgets (this_line, sizeof (this_line), preferences_file) != NULL)
    {
      this_line_number++;

      if (this_line[strlen (this_line) - 1] == '\n')
	this_line[strlen (this_line) - 1] = 0;

      if (!strlen (this_line))
	continue;
      if (this_line[0] == '#')
	continue;
      if (this_line[0] == '[')
	continue;


      /* VERSION */
      CUSTOM_LOAD_STRING ("PROGRAM_VERSION", user_rc.program_version);


      /* GENERAL */
      CUSTOM_LOAD_STRING ("NAME", user_rc.default_session.username);
      CUSTOM_LOAD_STRING ("PASSWORD", user_rc.default_session.userpass);
      CUSTOM_LOAD_STRING ("LOCAL_DIR", user_rc.default_session.local_dir);
      CUSTOM_LOAD_STRING ("REMOTE_DIR", user_rc.default_session.start_dir);
      CUSTOM_LOAD_INT ("DEFAULT_PORT", user_rc.default_session.port);


      if (strstr (this_line, "HOST_TYPE="))
	{
	  char *ptr = FIELD_STRING;
	  register int f;
	  if (ptr != NULL)
	    {
	      for (f = 0; f < MAX_HOST_TYPE; f++)
		{
		  if (!strcmp (host_type_name[f], ptr))
		    user_rc.default_session.host_type = f;
		}
	      continue;
	    }
	}

      if (strstr (this_line, "TRANSFERT_TYPE="))
	{
	  char *ptr = FIELD_STRING;
	  if (ptr != NULL)
	    {
	      strupr (ptr);
	      if (strstr (ptr, "ASCII"))
		user_rc.default_session.host_type = TYPE_ASCII;
	      if (strstr (ptr, "BIN") || strstr (ptr, "IMAGE"))
		user_rc.default_session.host_type = TYPE_BIN;
	      if (strstr (ptr, "LOCAL"))
		user_rc.default_session.host_type = TYPE_LOCAL;
	      continue;
	    }
	}



      /* ADVANCED */
      CUSTOM_LOAD_INT ("RETRY_COUNT", user_rc.retry_count);
      CUSTOM_LOAD_INT ("RETRY_DELAY", user_rc.retry_delay);
      CUSTOM_LOAD_INT ("TIMEOUT", user_rc.default_session.timeout);
      CUSTOM_LOAD_INT ("RECV_BUF", user_rc.recv_buffer);
      CUSTOM_LOAD_INT ("SEND_BUF", user_rc.send_buffer);
      CUSTOM_LOAD_INT ("UPLOADS_FILENAME_CASE", user_rc.default_session.uploads_filename);
      CUSTOM_LOAD_BOOL ("UPLOADS_PRESERVE_PERM", user_rc.default_session.uploads_perm);
      CUSTOM_LOAD_BOOL ("UPLOADS_PRESERVE_DATE", user_rc.default_session.uploads_date);
      CUSTOM_LOAD_INT ("DOWNLOADS_FILENAME_CASE", user_rc.default_session.downloads_filename);
      CUSTOM_LOAD_BOOL ("DOWNLOADS_PRESERVE_PERM", user_rc.default_session.downloads_perm);
      CUSTOM_LOAD_BOOL ("DOWNLOADS_PRESERVE_DATE", user_rc.default_session.downloads_date);
      CUSTOM_LOAD_INT ("QUEUE_MAX_RETRIES", user_rc.queue_max_retries);
      CUSTOM_LOAD_BOOL ("ANTI_IDLE", user_rc.idle);
      CUSTOM_LOAD_INT ("ANTI_IDLE_DELAY", user_rc.idle_delay);
      CUSTOM_LOAD_BOOL ("RESOLVE_LINKS", user_rc.default_session.resolve_link);
      CUSTOM_LOAD_BOOL ("PASV", user_rc.default_session.dmode);


      /* FIREWALL */
      CUSTOM_LOAD_BOOL ("USE_FIREWALL", user_rc.default_session.use_firewall);
      CUSTOM_LOAD_STRING ("FIREWALL_HOST", user_rc.default_session.firewall_hostname);
      CUSTOM_LOAD_INT ("FIREWALL_PORT", user_rc.default_session.firewall_port);
      CUSTOM_LOAD_STRING ("FIREWALL_USER", user_rc.default_session.firewall_username);
      CUSTOM_LOAD_STRING ("FIREWALL_PASS", user_rc.default_session.firewall_userpass);
      CUSTOM_LOAD_INT ("FIREWALL_LOGIN_TYPE", (char) user_rc.default_session.firewall_login_type);


      /* VIEW */
      CUSTOM_LOAD_BOOL ("TOOLBAR", user_rc.view_toolbar);
      CUSTOM_LOAD_INT ("TOOLBAR_STYLE", user_rc.toolbar_style);
      CUSTOM_LOAD_BOOL ("CONNECTBAR", user_rc.view_connectbar);
      CUSTOM_LOAD_BOOL ("CONSOLE", user_rc.view_console);
      CUSTOM_LOAD_BOOL ("QUEUE", user_rc.view_queue);
      CUSTOM_LOAD_BOOL ("LOCAL_PROMPT", user_rc.view_shell_prompt);
      CUSTOM_LOAD_BOOL ("REMOTE_PROMPT", user_rc.view_ftp_prompt);
      CUSTOM_LOAD_BOOL ("3D_BORDERS", user_rc.view_3D_borders);

      CUSTOM_LOAD_BOOL ("HOST_WELCOME_MSG", user_rc.view_host_welcome_message);
      CUSTOM_LOAD_BOOL ("HOST_DIRECTORY_MSG", user_rc.view_host_directory_message);

      CUSTOM_LOAD_BOOL ("LOCAL_FILES_SIZE", user_rc.view_local_files_size);
      CUSTOM_LOAD_BOOL ("LOCAL_FILES_DATE", user_rc.view_local_files_date);
      CUSTOM_LOAD_BOOL ("LOCAL_FILES_OWNER", user_rc.view_local_files_owner);
      CUSTOM_LOAD_BOOL ("LOCAL_FILES_GROUP", user_rc.view_local_files_group);
      CUSTOM_LOAD_BOOL ("LOCAL_FILES_PERM", user_rc.view_local_files_perm);
      CUSTOM_LOAD_BOOL ("LOCAL_HIDDEN_FILES", user_rc.dirlist_hide_hidden);

      CUSTOM_LOAD_BOOL ("REMOTE_FILES_SIZE", user_rc.view_remote_files_size);
      CUSTOM_LOAD_BOOL ("REMOTE_FILES_DATE", user_rc.view_remote_files_date);
      CUSTOM_LOAD_BOOL ("REMOTE_FILES_OWNER", user_rc.view_remote_files_owner);
      CUSTOM_LOAD_BOOL ("REMOTE_FILES_GROUP", user_rc.view_remote_files_group);
      CUSTOM_LOAD_BOOL ("REMOTE_FILES_PERM", user_rc.view_remote_files_perm);
      CUSTOM_LOAD_BOOL ("REMOTE_HIDDEN_FILES", user_rc.ftplist_hide_hidden);


      /* APPLICATIONS */
      CUSTOM_LOAD_BOOL ("USE_NETSCAPE", user_rc.use_netscape);
      CUSTOM_LOAD_STRING ("NAVIGATOR", user_rc.navigator_command);
      CUSTOM_LOAD_STRING ("EMAIL_CLIENT", user_rc.email_client_command);
      CUSTOM_LOAD_STRING ("EMAIL_EDITOR", user_rc.email_editor_command);
      CUSTOM_LOAD_STRING ("NEWS_CLIENT", user_rc.news_client_command);
      CUSTOM_LOAD_STRING ("TEXT_EDITOR", user_rc.text_editor_command);
      CUSTOM_LOAD_STRING ("XTERM", user_rc.xterm_command);


      /* CACHE */
      CUSTOM_LOAD_BOOL ("RDC", user_rc.default_session.use_RDC);
      CUSTOM_LOAD_INT ("RDC_MAX_DAYS", user_rc.RDC_max_days);
      CUSTOM_LOAD_INT ("CONSOLE_MAX_LINES", user_rc.console_max_lines);


      printf ("IglooFTP : Syntax error in %s\n", this_path);
      printf ("Line %i : %s\n", this_line_number, this_line);
    }

  fclose (preferences_file);
}


/* EOF */
