/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <time.h>

#include "protos.h"
#include "version.h"
#include "custom.h"
#include "custom_io.h"
#include "custom_profiles.h"
#include "files_assoc.h"






/* INIT functions */

/* PUBLIC :
 * init_rc
 * check_new_prog_version
 */

void
init_rc (void)
{
  char this_path[1024];

  DEBUG ("IGLOOftp : INIT_RC() BEGIN");
  preferences_path (this_path);
  DEBUG (this_path);

  create_rc ();
  access (this_path, F_OK) ? save_rc () : read_rc ();
  DEBUG ("IGLOOftp : INIT_RC() END");
}

void
check_new_prog_version (void)
{
  if (!is_it_a_new_prog_version (user_rc.program_version))
    return;

  doc_show_text_file (DOC_WELCOME_MSG);
  version (user_rc.program_version);
  save_rc ();
}










/* NOTEBOOK functions */

/* PUBLIC :
 * custom_notebook ()
 * STATIC : 
 * user_rc_transfert_mode
 * user_rc_host_type 
 * user_rc_firewall_type
 * user_rc_uploads_filename
 * user_rc_downloads_filename
 * custom_quit 
 * custom_reset 
 * custom_cancel 
 * custom_ok
 * custom_pixmap
 */

static void
user_rc_firewall_type (GtkWidget * widget, gpointer data)
{
  user_rc.default_session.firewall_login_type = (int) GPOINTER_TO_INT (data);
}

static void
user_rc_uploads_filename (GtkWidget * widget, gpointer data)
{
  user_rc.default_session.uploads_filename = (int) GPOINTER_TO_INT (data);
}

static void
user_rc_downloads_filename (GtkWidget * widget, gpointer data)
{
  user_rc.default_session.downloads_filename = (int) GPOINTER_TO_INT (data);
}

static void
user_rc_transfert_mode (GtkWidget * widget, gpointer data)
{
  user_rc.default_session.tmode = (int) GPOINTER_TO_INT (data);
}

static void
user_rc_host_type (GtkWidget * widget, gpointer data)
{
  user_rc.default_session.host_type = (int) GPOINTER_TO_INT (data);
}

static void
custom_quit (void)
{
  gtk_widget_destroy (rc_window);
  rc_window = NULL;
  fill_combo_user ();
}

static void
custom_cancel (GtkWidget * widget)
{
  read_rc ();
  custom_quit ();
}

static void
custom_reset (GtkWidget * widget)
{
  custom_quit ();
  create_rc ();
  save_rc ();
  custom_notebook ();
}

static void
custom_ok (GtkWidget * widget)
{

  /* GENERAL */
  strcpy (user_rc.default_session.username, gtk_entry_get_text (GTK_ENTRY (entry_username)));
  strcpy (user_rc.default_session.userpass, gtk_entry_get_text (GTK_ENTRY (entry_userpass)));
  strcpy (user_rc.default_session.local_dir, gtk_entry_get_text (GTK_ENTRY (entry_local_dir)));
  strcpy (user_rc.default_session.start_dir, gtk_entry_get_text (GTK_ENTRY (entry_remote_dir)));
  strcpy (user_rc.default_session.cwd_dir, user_rc.default_session.start_dir);
  user_rc.default_session.port = atoi (gtk_entry_get_text (GTK_ENTRY (entry_port)));


  /* ADVANCED */
  user_rc.retry_count = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_Rcount));
  user_rc.retry_delay = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_Rdelay));
  user_rc.default_session.timeout = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_timeout));
  user_rc.idle_delay = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_Idelay));
  user_rc.send_buffer = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_Sbuf));
  user_rc.recv_buffer = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_Rbuf));

  user_rc.idle = GTK_TOGGLE_BUTTON (check_idle)->active;
  //user_rc.default_session.dmode = (GTK_TOGGLE_BUTTON (check_PASV)->active) ? PASV_MODE : SENDP_MODE;
  user_rc.default_session.resolve_link = GTK_TOGGLE_BUTTON (check_resolve_lnk)->active;


  /* TRANSFER */
  user_rc.default_session.uploads_perm = GTK_TOGGLE_BUTTON (check_uploads_preserve_perm)->active;
  user_rc.default_session.uploads_date = GTK_TOGGLE_BUTTON (check_uploads_preserve_date)->active;
  user_rc.default_session.downloads_perm = GTK_TOGGLE_BUTTON (check_downloads_preserve_perm)->active;
  user_rc.default_session.downloads_date = GTK_TOGGLE_BUTTON (check_downloads_preserve_date)->active;

  user_rc.queue_max_retries = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_queue_max_retries));


  /* FIREWALL */
  strcpy (user_rc.default_session.firewall_hostname, gtk_entry_get_text (GTK_ENTRY (entry_firewall_hostname)));
  strcpy (user_rc.default_session.firewall_username, gtk_entry_get_text (GTK_ENTRY (entry_firewall_username)));
  strcpy (user_rc.default_session.firewall_userpass, gtk_entry_get_text (GTK_ENTRY (entry_firewall_userpass)));
  user_rc.default_session.firewall_port = atoi (gtk_entry_get_text (GTK_ENTRY (entry_firewall_port)));

  user_rc.default_session.dmode = (GTK_TOGGLE_BUTTON (check_PASV)->active) ? PASV_MODE : SENDP_MODE;
  user_rc.default_session.use_firewall = (GTK_TOGGLE_BUTTON (check_use_firewall)->active);


  /* VIEW */
  user_rc.view_toolbar = GTK_TOGGLE_BUTTON (check_view_toolbar)->active;
  user_rc.view_connectbar = GTK_TOGGLE_BUTTON (check_view_connectbar)->active;
  user_rc.view_queue = GTK_TOGGLE_BUTTON (check_view_queue)->active;
  user_rc.view_console = GTK_TOGGLE_BUTTON (check_view_console)->active;

  user_rc.view_shell_prompt = GTK_TOGGLE_BUTTON (check_view_local_prompt)->active;
  user_rc.view_ftp_prompt = GTK_TOGGLE_BUTTON (check_view_remote_prompt)->active;
  user_rc.view_3D_borders = GTK_TOGGLE_BUTTON (check_view_3D_borders)->active;

  user_rc.view_host_welcome_message = GTK_TOGGLE_BUTTON (check_view_host_welc_msg)->active;
  user_rc.view_host_directory_message = GTK_TOGGLE_BUTTON (check_view_host_dir_msg)->active;

  user_rc.view_remote_files_size = GTK_TOGGLE_BUTTON (check_view_remote_file_size)->active;
  user_rc.view_remote_files_date = GTK_TOGGLE_BUTTON (check_view_remote_file_date)->active;
  user_rc.view_remote_files_owner = GTK_TOGGLE_BUTTON (check_view_remote_file_owner)->active;
  user_rc.view_remote_files_group = GTK_TOGGLE_BUTTON (check_view_remote_file_group)->active;
  user_rc.view_remote_files_perm = GTK_TOGGLE_BUTTON (check_view_remote_file_perm)->active;

  user_rc.ftplist_hide_hidden = GTK_TOGGLE_BUTTON (check_view_remote_hidden_file)->active;

  user_rc.view_local_files_size = GTK_TOGGLE_BUTTON (check_view_local_file_size)->active;
  user_rc.view_local_files_date = GTK_TOGGLE_BUTTON (check_view_local_file_date)->active;
  user_rc.view_local_files_owner = GTK_TOGGLE_BUTTON (check_view_local_file_owner)->active;
  user_rc.view_local_files_group = GTK_TOGGLE_BUTTON (check_view_local_file_group)->active;
  user_rc.view_local_files_perm = GTK_TOGGLE_BUTTON (check_view_local_file_perm)->active;

  user_rc.dirlist_hide_hidden = GTK_TOGGLE_BUTTON (check_view_local_hidden_file)->active;


  /* TOOLS */
  user_rc.use_netscape = GTK_TOGGLE_BUTTON (check_use_netscape)->active;
  strcpy (user_rc.navigator_command, gtk_entry_get_text (GTK_ENTRY (browser_entry)));
  strcpy (user_rc.email_client_command, gtk_entry_get_text (GTK_ENTRY (email_client_entry)));
  strcpy (user_rc.email_editor_command, gtk_entry_get_text (GTK_ENTRY (email_editor_entry)));
  strcpy (user_rc.news_client_command, gtk_entry_get_text (GTK_ENTRY (news_client_entry)));

  strcpy (user_rc.text_editor_command, gtk_entry_get_text (GTK_ENTRY (text_editor_entry)));
  strcpy (user_rc.xterm_command, gtk_entry_get_text (GTK_ENTRY (xterm_entry)));


  /* CACHE */
  user_rc.RDC_max_days = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_RDC_max_days));
  user_rc.console_max_lines = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_console_max_lines));
  user_rc.default_session.use_RDC = GTK_TOGGLE_BUTTON (check_RDC_enabled)->active;





  if (!this_connexion.is_connected)
    menu_set_check_idle ((anti_idle = user_rc.idle));

  if (!this_connexion.xfer_busy)
    {
      recv_buf_len = user_rc.recv_buffer;
      send_buf_len = user_rc.send_buffer;
    }

  this_session.resolve_link = user_rc.default_session.resolve_link;
  //this_session.dmode = this_connexion.dmode = user_rc.default_session.dmode;

  save_rc ();
  save_file_assoc_clist ();
  custom_quit ();
  toggle_local_columns_visibility ();
  toggle_remote_columns_visibility ();
}






/* PREFERENCES NOTEBOOK */

void
custom_notebook ()
{
  GtkWidget *vbox;
  GtkWidget *vbox1;
  GtkWidget *hbox;
  GtkWidget *hbbox;
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *fixed_top;
  GtkWidget *notebook;
  gchar *clist_titles[] =
  {" User Profile", " Local Directory"};
  gchar *file_assoc_clist_titles[] =
  {" Extension(s)", " Viewer", " Editor"};
  GtkWidget *optionmenu;
  GtkWidget *optionmenu_menu;
  GtkWidget *menuitem;
  GtkWidget *button_user_add;
  GtkWidget *button_help;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;
  GtkWidget *button_reset;
  GtkWidget *clist_window;
  GtkCTree *ctree;
  GtkWidget *scrolled_win;
  GdkBitmap *nodemsk;
  GdkPixmap *nodepix = preferences_node (&nodemsk);
  char port_buf[10];
  gint x, y;


  if (rc_window != NULL)
    {
      gdk_window_raise (rc_window->window);
      return;
    }

  read_rc ();

  rc_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, "IglooFTP - User preferences", &vbox);
  gtk_window_set_policy (GTK_WINDOW (rc_window), FALSE, FALSE, FALSE);
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (GTK_WIDGET (rc_window), x, y);
  gtk_signal_connect (GTK_OBJECT (rc_window), "delete_event", (GtkSignalFunc) custom_quit, NULL);


  gtk_box_set_spacing (GTK_BOX (vbox), 5);
  gtk_container_border_width (GTK_CONTAINER (vbox), 7);

  hbox = h_box (vbox, FALSE, 00, 0);


  /* CTREE */
  {
    gchar *ctree_titlle[] =
    {" "};
    GtkCTreeNode *node = NULL;
    GtkCTreeNode *general_node = NULL;
    GtkCTreeNode *advanced_node = NULL;
    GtkWidget *hbox1 = gtk_hbox_new (FALSE, 0);
    GtkWidget *label = gtk_label_new ("Category");
    GtkWidget *pixmap = gtk_pixmap_new (nodepix, nodemsk);


    ctree = GTK_CTREE (gtk_ctree_new_with_titles (1, 0, ctree_titlle));
    gtk_widget_show (GTK_WIDGET (ctree));
    gtk_widget_set_usize (GTK_WIDGET (ctree), 130, -1);
    gtk_ctree_set_line_style (ctree, GTK_CTREE_LINES_NONE);
    gtk_ctree_set_indent (ctree, 15);
    gtk_ctree_set_expander_style (ctree, GTK_CTREE_EXPANDER_TRIANGLE);

    gtk_box_pack_start (GTK_BOX (hbox1), pixmap, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox1), label, FALSE, FALSE, 4);
    gtk_clist_set_column_widget (GTK_CLIST (ctree), 0, hbox1);
    gtk_widget_show_all (hbox1);

    gtk_clist_set_hadjustment (GTK_CLIST (ctree), NULL);
    gtk_clist_set_vadjustment (GTK_CLIST (ctree), NULL);
    scrolled_win = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_widget_show (scrolled_win);
    gtk_container_add (GTK_CONTAINER (scrolled_win), GTK_WIDGET (ctree));
    gtk_box_pack_start (GTK_BOX (hbox), scrolled_win, TRUE, FALSE, 0);


#define ADD_CUSTOM_TREE_NODE(x,y,z)  x=gtk_ctree_insert_node (ctree, y, NULL, &tree_col[z], 5, NULL, NULL, NULL, NULL, FALSE, TRUE);
    ADD_CUSTOM_TREE_NODE (general_node, NULL, 0);
    ADD_CUSTOM_TREE_NODE (node, general_node, 1);
    ADD_CUSTOM_TREE_NODE (node, general_node, 2);

    ADD_CUSTOM_TREE_NODE (advanced_node, NULL, 3);
    ADD_CUSTOM_TREE_NODE (node, advanced_node, 4);
    ADD_CUSTOM_TREE_NODE (node, advanced_node, 5);
    ADD_CUSTOM_TREE_NODE (node, advanced_node, 6);
    ADD_CUSTOM_TREE_NODE (node, advanced_node, 7);
  }



  /* NOTEBOOK */
  notebook = gtk_notebook_new ();
  gtk_widget_show (notebook);
  gtk_box_pack_start (GTK_BOX (hbox), notebook, TRUE, TRUE, 0);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_popup_enable (GTK_NOTEBOOK (notebook));



  /* GENERAL TAB */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);
  gtk_widget_set_usize (fixed_top, 430, 360);


  fixed_frame (fixed_top, 10, 5, 410, 220, " Login :  ");

  fixed_label (fixed_top, 20, 30, "User Name :");
  entry_username = fixed_entry (fixed_top, 160, 26, 245, 24, user_rc.default_session.username);
  fixed_label (fixed_top, 20, 60, "E-Mail Address :");
  entry_userpass = fixed_entry (fixed_top, 160, 56, 245, 24, user_rc.default_session.userpass);
  fixed_label (fixed_top, 20, 90, "Start Directory : ");
  entry_local_dir = fixed_dir_entry (fixed_top, 160, 86, 245, 24, user_rc.default_session.local_dir);


  clist = gtk_clist_new_with_titles (2, clist_titles);
  gtk_widget_show (clist);

  gtk_clist_set_column_min_width (GTK_CLIST (clist), 0, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist), 0, TRUE);
  gtk_clist_column_titles_show (GTK_CLIST (clist));
  gtk_clist_set_row_height (GTK_CLIST (clist), 16);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist), 1, TRUE);
  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_SINGLE);

  clist_window = scroll_win ();
  gtk_container_add (GTK_CONTAINER (clist_window), clist);
  gtk_fixed_put (GTK_FIXED (fixed_top), clist_window, 160, 120);
  gtk_widget_set_usize (clist_window, 245, 88);


  update_proflist ();

  {
    GtkWidget *frame1 = fixed_frame (fixed_top, 20, 120, 120, 88, NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);
    vbox1 = v_box (frame1, FALSE, 0, 2);
  }

  button_user_add = fixed_button (vbox1, "Add");
  button_user_edit = fixed_button (vbox1, "Edit");
  button_user_delete = fixed_button (vbox1, "Delete");
  gtk_widget_set_sensitive (button_user_edit, FALSE);
  gtk_widget_set_sensitive (button_user_delete, FALSE);

  gtk_signal_connect (GTK_OBJECT (button_user_add), "clicked", GTK_SIGNAL_FUNC (add_prof), NULL);
  gtk_signal_connect (GTK_OBJECT (button_user_edit), "clicked", GTK_SIGNAL_FUNC (edit_prof), NULL);
  gtk_signal_connect (GTK_OBJECT (button_user_delete), "clicked", GTK_SIGNAL_FUNC (delete_prof), NULL);

  gtk_signal_connect (GTK_OBJECT (clist), "select_row", GTK_SIGNAL_FUNC (update_button_prof), NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "unselect_row", GTK_SIGNAL_FUNC (update_button_prof), NULL);




  frame = fixed_frame (fixed_top, 10, 230, 410, 120, " Remote :  ");

  fixed_label (fixed_top, 20, 255, "Start Directory : ");
  entry_remote_dir = fixed_entry (fixed_top, 160, 251, 245, 24, user_rc.default_session.start_dir);

  fixed_label (fixed_top, 20, 290, "Host Type : ");
  optionmenu = gtk_option_menu_new ();
  gtk_widget_show (optionmenu);
  gtk_fixed_put (GTK_FIXED (fixed_top), optionmenu, 20, 315);
  gtk_widget_set_usize (optionmenu, 115, 24);
  optionmenu_menu = gtk_menu_new ();
  menuitem = append_option_menu_item (optionmenu_menu, "Auto Detect");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_host_type), GINT_TO_POINTER (HOST_AUTODETECT));
  menuitem = append_option_menu_item (optionmenu_menu, "Unix");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_host_type), GINT_TO_POINTER (HOST_UNIX));
  menuitem = append_option_menu_item (optionmenu_menu, "SunOS");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_host_type), GINT_TO_POINTER (HOST_SUNOS));
  menuitem = append_option_menu_item (optionmenu_menu, "Windows NT");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_host_type), GINT_TO_POINTER (HOST_WIN_NT));
  menuitem = append_option_menu_item (optionmenu_menu, "VMS");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_host_type), GINT_TO_POINTER (HOST_VMS));
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), user_rc.default_session.host_type);



  fixed_label (fixed_top, 160, 290, "Transfer Type : ");
  optionmenu = gtk_option_menu_new ();
  gtk_widget_show (optionmenu);
  gtk_fixed_put (GTK_FIXED (fixed_top), optionmenu, 160, 315);
  gtk_widget_set_usize (optionmenu, 115, 24);
  optionmenu_menu = gtk_menu_new ();
  menuitem = append_option_menu_item (optionmenu_menu, "Auto Detect");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_transfert_mode), GINT_TO_POINTER (TYPE_AUTODETECT));
  menuitem = append_option_menu_item (optionmenu_menu, "ASCII");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_transfert_mode), GINT_TO_POINTER (TYPE_ASCII));
  menuitem = append_option_menu_item (optionmenu_menu, "Bin/Image");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_transfert_mode), GINT_TO_POINTER (TYPE_IMAGE));
  menuitem = append_option_menu_item (optionmenu_menu, "Local");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (user_rc_transfert_mode), GINT_TO_POINTER (TYPE_LOCAL));
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), user_rc.default_session.tmode);

  fixed_label (fixed_top, 300, 290, "Default Port : ");
  sprintf (port_buf, "%i", user_rc.default_session.port);
  entry_port = fixed_entry (fixed_top, 300, 315, 105, 24, port_buf);



  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("General settings  "));





  /* APPEARANCE TAB  */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);

  fixed_frame (fixed_top, 10, 5, 200, 225, " View :  ");
#define BLUE_CHECK(x)  gtk_widget_set_name ((x), "BlueCheck")



  BLUE_CHECK (check_view_toolbar = fixed_check (fixed_top, 20, 25, "*Toolbar", user_rc.view_toolbar));
#define RADIO_ARG(a)  toolbar_set_style, GINT_TO_POINTER (a), (user_rc.toolbar_style == a)
  {
    GtkWidget *radio = fixed_radio (fixed_top, NULL, "Icons AND  Text", 90, 25, RADIO_ARG (GTK_TOOLBAR_BOTH));
    radio = fixed_radio (fixed_top, radio, "Icons", 90, 45, RADIO_ARG (GTK_TOOLBAR_ICONS));
    radio = fixed_radio (fixed_top, radio, "Text", 159, 45, RADIO_ARG (GTK_TOOLBAR_TEXT));
  }
#undef RADIO_ARG


  BLUE_CHECK (check_view_connectbar = fixed_check (fixed_top, 20, 75, "*FastConnect Bar", user_rc.view_connectbar));
  BLUE_CHECK (check_view_console = fixed_check (fixed_top, 20, 100, "*Console Window", user_rc.view_console));
  BLUE_CHECK (check_view_queue = fixed_check (fixed_top, 20, 125, "*Queue Window", user_rc.view_queue));
  BLUE_CHECK (check_view_local_prompt = fixed_check (fixed_top, 20, 150, "*Shell Prompt", user_rc.view_shell_prompt));
  BLUE_CHECK (check_view_remote_prompt = fixed_check (fixed_top, 20, 175, "*Host Prompt", user_rc.view_ftp_prompt));

  check_view_3D_borders = fixed_check (fixed_top, 20, 200, "3D Borders", user_rc.view_3D_borders);

  fixed_frame (fixed_top, 10, 235, 200, 80, " Host Messages :  ");
  check_view_host_welc_msg = fixed_check (fixed_top, 20, 255, "Welcome message", user_rc.view_host_welcome_message);
  check_view_host_dir_msg = fixed_check (fixed_top, 20, 280, "Directory messages", user_rc.view_host_directory_message);


  fixed_frame (fixed_top, 220, 5, 200, 150, " Local Directory  :  ");
  check_view_local_file_size = fixed_check (fixed_top, 235, 25, "Size", user_rc.view_local_files_size);
  check_view_local_file_date = fixed_check (fixed_top, 235, 50, "Date", user_rc.view_local_files_date);
  check_view_local_file_owner = fixed_check (fixed_top, 330, 25, "Owner", user_rc.view_local_files_owner);
  check_view_local_file_group = fixed_check (fixed_top, 330, 50, "Group", user_rc.view_local_files_group);
  check_view_local_file_perm = fixed_check (fixed_top, 235, 75, "Permissions", user_rc.view_local_files_perm);
  fixed_hseparator (fixed_top, 230, 102, 180);
  check_view_local_hidden_file = fixed_check (fixed_top, 235, 105, "Hidden Files", user_rc.dirlist_hide_hidden);


  fixed_frame (fixed_top, 220, 160, 200, 155, " Remote Directory  :  ");
  check_view_remote_file_size = fixed_check (fixed_top, 235, 180, "Size", user_rc.view_remote_files_size);
  check_view_remote_file_date = fixed_check (fixed_top, 235, 205, "Date", user_rc.view_remote_files_date);
  check_view_remote_file_owner = fixed_check (fixed_top, 330, 180, "Owner", user_rc.view_remote_files_owner);
  check_view_remote_file_group = fixed_check (fixed_top, 330, 205, "Group", user_rc.view_remote_files_group);
  check_view_remote_file_perm = fixed_check (fixed_top, 235, 230, "Permissions", user_rc.view_remote_files_perm);
  fixed_hseparator (fixed_top, 230, 257, 180);
  check_view_remote_hidden_file = fixed_check (fixed_top, 235, 260, "Hidden Files", user_rc.ftplist_hide_hidden);


  BLUE_CHECK (label = fixed_label (fixed_top, 5, 323, "*Need to restart IglooFTP to apply any change"));
  label = fixed_label (fixed_top, 10, 338, "Options only applying to this session can be set in the \"View\" menu.");



  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Appearance  "));



  /* TOOLS TAB */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);


  fixed_frame (fixed_top, 10, 5, 410, 170, " Internet :  ");

  fixed_label (fixed_top, 20, 30, "Browser :");
  browser_entry = fixed_file_entry (fixed_top, 160, 26, 245, 24, user_rc.navigator_command);

  fixed_label (fixed_top, 20, 60, "Email Client :");
  email_client_entry = fixed_file_entry (fixed_top, 160, 56, 245, 24, user_rc.email_client_command);

  fixed_label (fixed_top, 20, 90, "Email Editor :");
  email_editor_entry = fixed_file_entry (fixed_top, 160, 86, 245, 24, user_rc.email_editor_command);

  fixed_label (fixed_top, 20, 120, "News Client :");
  news_client_entry = fixed_file_entry (fixed_top, 160, 116, 245, 24, user_rc.news_client_command);

  check_use_netscape = fixed_check (fixed_top, 158, 145, "Use NETSCAPE", user_rc.use_netscape);


  fixed_frame (fixed_top, 10, 180, 410, 170, " Others :  ");


  fixed_label (fixed_top, 20, 205, "Text Editor :");
  text_editor_entry = fixed_file_entry (fixed_top, 160, 201, 245, 24, user_rc.text_editor_command);

  fixed_label (fixed_top, 20, 235, "XTerm :");
  xterm_entry = fixed_file_entry (fixed_top, 160, 231, 245, 24, user_rc.xterm_command);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Applications  "));



  /* ADVANCED TAB */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);

  fixed_frame (fixed_top, 10, 5, 200, 115, " Connexion :  ");
  fixed_label (fixed_top, 20, 30, "Retry Count :");
  fixed_label (fixed_top, 20, 60, "Retry Delay :");
  fixed_label (fixed_top, 20, 90, "Timeout :");
  spin_Rcount = fixed_spin (fixed_top, 107, 26, (int) user_rc.retry_count, 100, 0, 1);
  spin_Rdelay = fixed_spin (fixed_top, 107, 56, (int) user_rc.retry_delay, 100, 0, 1);
  spin_timeout = fixed_spin (fixed_top, 107, 86, (time_t) user_rc.default_session.timeout, 100, 0, 1);


  fixed_frame (fixed_top, 10, 125, 200, 85, " Buffers :  ");
  fixed_label (fixed_top, 20, 150, "Send :");
  fixed_label (fixed_top, 20, 180, "Receive :");
  spin_Sbuf = fixed_spin (fixed_top, 107, 146, (int) user_rc.send_buffer, 10240, 256, 256);
  spin_Rbuf = fixed_spin (fixed_top, 107, 176, (int) user_rc.recv_buffer, 10240, 256, 256);


  fixed_frame (fixed_top, 220, 5, 200, 205, " Toggles  :  ");
  check_idle = fixed_check (fixed_top, 230, 30, "Anti-Idle :", user_rc.idle);
  spin_Idelay = fixed_spin (fixed_top, 317, 30, (int) user_rc.idle_delay, 100, 0, 1);
  check_resolve_lnk = fixed_check (fixed_top, 230, 60, "Resolve Links", user_rc.default_session.resolve_link);


  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Advanced  "));




  /* TRANSFER TAB */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);

  fixed_frame (fixed_top, 10, 5, 200, 170, " Uploads :  ");
#define RADIO_ARG(a)  user_rc_uploads_filename, GINT_TO_POINTER (a), (user_rc.default_session.uploads_filename== a)
  {
    GtkWidget *radio = fixed_radio (fixed_top, NULL, "Preserve Filename Case", 20, 26, RADIO_ARG (XFER_FILENAME_PRESERVE));
    radio = fixed_radio (fixed_top, radio, "Force Filename Uppercase", 20, 51, RADIO_ARG (XFER_FILENAME_UPPER));
    radio = fixed_radio (fixed_top, radio, "Force Filename Lowercase", 20, 76, RADIO_ARG (XFER_FILENAME_LOWER));
  }
#undef RADIO_ARG

  check_uploads_preserve_perm = fixed_check (fixed_top, 20, 111, "Preserve Permissions", user_rc.default_session.uploads_perm);
  check_uploads_preserve_date = fixed_check (fixed_top, 20, 136, "TimeStamp Local Files", user_rc.default_session.uploads_date);


  fixed_frame (fixed_top, 220, 5, 200, 170, " Downloads :  ");
#define RADIO_ARG(a)  user_rc_downloads_filename, GINT_TO_POINTER (a), (user_rc.default_session.downloads_filename== a)
  {
    GtkWidget *radio = fixed_radio (fixed_top, NULL, "Preserve Filename Case", 230, 26, RADIO_ARG (XFER_FILENAME_PRESERVE));
    radio = fixed_radio (fixed_top, radio, "Force Filename Uppercase", 230, 51, RADIO_ARG (XFER_FILENAME_UPPER));
    radio = fixed_radio (fixed_top, radio, "Force Filename Lowercase", 230, 76, RADIO_ARG (XFER_FILENAME_LOWER));
  }
#undef RADIO_ARG

  check_downloads_preserve_perm = fixed_check (fixed_top, 230, 111, "Preserve Permissions", user_rc.default_session.downloads_perm);
  check_downloads_preserve_date = fixed_check (fixed_top, 230, 136, "Preserve Date", user_rc.default_session.downloads_date);


  fixed_frame (fixed_top, 10, 180, 410, 80, " Queue :  ");
  fixed_label (fixed_top, 80, 205, "Maximum File Transfer Attempts :");
  spin_queue_max_retries = fixed_spin (fixed_top, 315, 199, (int) user_rc.queue_max_retries, 100, 1, 1);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Transfer  "));




/* FIREWALL TAB */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);


  fixed_frame (fixed_top, 10, 5, 410, 120, " Host :  ");

  fixed_label (fixed_top, 25, 30, "Address / Port :");
  entry_firewall_hostname = fixed_entry (fixed_top, 160, 26, 188, 24, user_rc.default_session.firewall_hostname);
  sprintf (port_buf, "%i", user_rc.default_session.firewall_port);
  entry_firewall_port = fixed_entry (fixed_top, 350, 26, 55, 24, user_rc.default_session.firewall_port ? port_buf : "");

  fixed_label (fixed_top, 25, 60, "User ID :");
  entry_firewall_username = fixed_entry (fixed_top, 160, 56, 245, 24, user_rc.default_session.firewall_username);
  fixed_label (fixed_top, 25, 90, "Password :");
  entry_firewall_userpass = fixed_entry (fixed_top, 160, 86, 245, 24, user_rc.default_session.firewall_userpass);


  fixed_frame (fixed_top, 10, 130, 410, 105, " Type :  ");
#define RADIO_ARG(a)  user_rc_firewall_type, GINT_TO_POINTER (a), (user_rc.default_session.firewall_login_type == a)
  {
    GtkWidget *radio = fixed_radio (fixed_top, NULL, "General ", 25, 150, RADIO_ARG (FIREWALL_TYPE_GENERAL));
    radio = fixed_radio (fixed_top, radio, "SOCKS Firewall", 25, 175, RADIO_ARG (FIREWALL_TYPE_SOCKSV5));
    radio = fixed_radio (fixed_top, radio, "SITE site", 160, 150, RADIO_ARG (FIREWALL_TYPE_SITE));
    radio = fixed_radio (fixed_top, radio, "OPEN site", 160, 175, RADIO_ARG (FIREWALL_TYPE_OPEN));
    radio = fixed_radio (fixed_top, radio, "USER user@site", 270, 150, RADIO_ARG (FIREWALL_TYPE_USER_AT_SITE));
    radio = fixed_radio (fixed_top, radio, "USER with logon", 270, 175, RADIO_ARG (FIREWALL_TYPE_LOGIN_USER_AT_SITE));
  }
#undef RADIO_ARG


  fixed_frame (fixed_top, 10, 240, 200, 110, " Options :  ");
  check_use_firewall = fixed_check (fixed_top, 25, 260, "Enable Firewall access", user_rc.default_session.use_firewall);
  check_PASV = fixed_check (fixed_top, 25, 290, "PASV mode", (user_rc.default_session.dmode == PASV_MODE));

  fixed_frame (fixed_top, 220, 240, 200, 110, "");


  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Firewall  "));



  /* CACHE TAB */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);


  fixed_frame (fixed_top, 10, 5, 410, 130, "  (RDC) Remote Directories Caching :  ");
  check_RDC_enabled = fixed_check (fixed_top, 20, 30, "Enable remote directories caching", user_rc.default_session.use_RDC);
  fixed_label (fixed_top, 37, 60, "Clean directories listing in cache after");
  fixed_label (fixed_top, 370, 60, "days. ");

  spin_RDC_max_days = fixed_spin (fixed_top, 270, 56, (int) user_rc.RDC_max_days, 365, 0, 1);

  frame = fixed_frame (fixed_top, 270, 91, 135, 32, NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  vbox1 = v_box (frame, FALSE, 0, 2);
  {
    GtkWidget *this_button = fixed_button (vbox1, "Clean Now");
    gtk_signal_connect (GTK_OBJECT (this_button), "clicked", GTK_SIGNAL_FUNC (RDC_clean_now), NULL);
  }

  fixed_frame (fixed_top, 10, 140, 410, 80, " Console log  :  ");
  fixed_label (fixed_top, 37, 165, "Memory buffer maximum size :");
  fixed_label (fixed_top, 370, 165, "lines. ");

  spin_console_max_lines = fixed_spin (fixed_top, 270, 159, (int) user_rc.console_max_lines, 10000, 100, 50);


  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Cache  "));



  /* FILE ASSOCIATION TAB  */
  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);


  fixed_frame (fixed_top, 10, 5, 410, 350, " Applications :  ");

  fixed_label (fixed_top, 25, 30, "Use :");
  optionmenu = gtk_option_menu_new ();
  gtk_widget_show (optionmenu);
  gtk_fixed_put (GTK_FIXED (fixed_top), optionmenu, 102, 26);
  gtk_widget_set_usize (optionmenu, 195, 24);
  optionmenu_menu = gtk_menu_new ();

  menuitem = append_option_menu_item (optionmenu_menu, " Default applications");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_current_file_association),
		      GINT_TO_POINTER (DEFAULT_ASS));
  menuitem = append_option_menu_item (optionmenu_menu, " GNOME applications");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_current_file_association),
		      GINT_TO_POINTER (GNOME_ASS));
  menuitem = append_option_menu_item (optionmenu_menu, " KDE applications");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_current_file_association),
		      GINT_TO_POINTER (KDE_ASS));
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), get_current_file_association ());



  fixed_label (fixed_top, 25, 60, "Extensions :");
  file_extension_entry = fixed_entry (fixed_top, 102, 56, 195, 24, "");

  fixed_label (fixed_top, 25, 90, "Viewer :");
  file_viewer_entry = fixed_file_entry (fixed_top, 102, 86, 195, 24, "");
  fixed_label (fixed_top, 25, 120, "Editor :");
  file_editor_entry = fixed_file_entry (fixed_top, 102, 116, 195, 24, "");

  frame = fixed_frame (fixed_top, 310, 26, 95, 115, NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  vbox1 = v_box (frame, FALSE, 0, 2);


  {
    GtkWidget *file_assoc_save_button;
    GtkWidget *file_assoc_add_button = fixed_button (vbox1, "Add");
    GtkWidget *file_assoc_clear_button = fixed_button (vbox1, "Clear");

    file_assoc_delete_button = fixed_button (vbox1, "Delete");
    file_assoc_save_button = fixed_button (vbox1, "Save");

    gtk_widget_set_sensitive (file_assoc_delete_button, FALSE);
    gtk_signal_connect_object (GTK_OBJECT (file_assoc_add_button), "clicked", GTK_SIGNAL_FUNC (file_assoc_clist_add_row), NULL);
    gtk_signal_connect_object (GTK_OBJECT (file_assoc_clear_button), "clicked", GTK_SIGNAL_FUNC (file_assoc_clist_clear_entries), NULL);
    gtk_signal_connect_object (GTK_OBJECT (file_assoc_delete_button), "clicked", GTK_SIGNAL_FUNC (file_assoc_clist_delete_row), NULL);
    gtk_signal_connect_object (GTK_OBJECT (file_assoc_save_button), "clicked", GTK_SIGNAL_FUNC (save_file_assoc_clist), NULL);
  }


  file_assoc_clist = gtk_clist_new_with_titles (3, file_assoc_clist_titles);
  gtk_widget_show (file_assoc_clist);
  gtk_clist_set_column_min_width (GTK_CLIST (file_assoc_clist), 0, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (file_assoc_clist), 0, TRUE);
  gtk_clist_set_column_min_width (GTK_CLIST (file_assoc_clist), 1, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (file_assoc_clist), 1, TRUE);
  gtk_clist_set_column_min_width (GTK_CLIST (file_assoc_clist), 2, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (file_assoc_clist), 2, TRUE);

  gtk_clist_column_titles_show (GTK_CLIST (file_assoc_clist));
  //gtk_clist_column_titles_passive (GTK_CLIST (file_assoc_clist));
  gtk_clist_set_row_height (GTK_CLIST (file_assoc_clist), 18);
  gtk_clist_set_selection_mode (GTK_CLIST (file_assoc_clist), GTK_SELECTION_SINGLE);
  gtk_clist_set_reorderable (GTK_CLIST (file_assoc_clist), TRUE);
  //use_default_drag_icon (GTK_WIDGET (file_assoc_clist));

  file_assoc_clist_window = scroll_win ();
  gtk_container_add (GTK_CONTAINER (file_assoc_clist_window), file_assoc_clist);
  gtk_fixed_put (GTK_FIXED (fixed_top), file_assoc_clist_window, 20, 155);
  gtk_widget_set_usize (file_assoc_clist_window, 385, 180);

  fill_file_assoc_clist ();

  gtk_signal_connect (GTK_OBJECT (file_assoc_clist), "select_row",
  GTK_SIGNAL_FUNC (file_assoc_row_select_unselect), GINT_TO_POINTER (TRUE));
  gtk_signal_connect (GTK_OBJECT (file_assoc_clist), "unselect_row",
  GTK_SIGNAL_FUNC (file_assoc_row_select_unselect), GINT_TO_POINTER (FALSE));
  gtk_signal_connect (GTK_OBJECT (file_assoc_clist), "click_column",
		      GTK_SIGNAL_FUNC (file_assoc_button_clicked), NULL);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, gtk_label_new ("Files association  "));



  /* NOTEBOOK BUTTONS */
  hbox = h_box (vbox, FALSE, 5, 0);

  custom_pixmap (rc_window, hbox);


  hbbox = hbutton_box (hbox);
  gtk_container_border_width (GTK_CONTAINER (hbbox), 0);

  button_ok = box_button (hbbox, "Done");
  button_cancel = box_button (hbbox, "Cancel");
  button_reset = box_button (hbbox, "Reset");
  button_help = box_button (hbbox, "Help");
  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked", GTK_SIGNAL_FUNC (custom_ok), NULL);
  gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked", GTK_SIGNAL_FUNC (custom_cancel), NULL);
  gtk_signal_connect (GTK_OBJECT (button_reset), "clicked", GTK_SIGNAL_FUNC (custom_reset), NULL);
  gtk_signal_connect (GTK_OBJECT (button_help), "clicked", GTK_SIGNAL_FUNC (nop), NULL);


  gtk_widget_show (rc_window);


  gtk_signal_connect (GTK_OBJECT (ctree), "tree_select_row",
		      GTK_SIGNAL_FUNC (CUSTOM_TREE_select_row), notebook);

}

static void
custom_pixmap (GtkWidget * this_window, GtkWidget * this_box)
{
  GtkWidget *pixmap = preferences_pixmap (this_window);
  gtk_box_pack_start (GTK_BOX (this_box), pixmap, FALSE, FALSE, 0);
  gtk_widget_show (pixmap);
}

static void
CUSTOM_TREE_select_row (GtkCTree * ctree, GtkCTreeNode * node, gint col, /*GdkEventButton *event, */ GtkWidget * notebook)
{
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  guint8 spacing;
  gchar *title;
  int f;
  char page = 0;
  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node, 0, &title, &spacing, &pixmap, &mask);

  for (f = 0; f < MAX_CUSTOM_TABS; f++)
    {
      if (!strcmp (tree_col[f], title))
	page = f;
    }
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), page);
}


/* EOF */
