/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <gtk/gtk.h>
#include "protos.h"



void
nop (void)
{
  alert_ok ("Sorry !", "Not Yet Implemented", "Ok");
}



void
show_hide_widget (GtkWidget * widget, char FLAG)
{
  FLAG ? gtk_widget_show (widget) : gtk_widget_hide (widget);
}



void
set_default_drag_icon (void)
{
#include "pixmaps/drag_multiple.xpm"
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], drag_multiple_xpm);
  gtk_drag_set_default_icon (gtk_widget_get_colormap (window), pixmap, mask, -4, -4);
  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
}



GtkWidget *
append_option_menu_item (GtkWidget * optionmenu, char *text)
{
  GtkWidget *menuitem = gtk_menu_item_new_with_label (text);
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu), menuitem);
  return menuitem;
}



GtkWidget *
fixed_entry (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text)
{
  GtkWidget *entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_fixed_put (GTK_FIXED (fixed), entry, x, y);
  gtk_widget_set_usize (entry, w, h);
  if (text != NULL)
    gtk_entry_set_text (GTK_ENTRY (entry), text);
  gtk_entry_set_position (GTK_ENTRY (entry), 0);
  return entry;
}



GtkWidget *
fixed_button_browser (GtkWidget * fixed, gint x, gint y)
{
  GtkWidget *button = browser_button (TRUE);
  GtkWidget *frame = fixed_frame (fixed, x, y, 30, 24, NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_container_add (GTK_CONTAINER (frame), button);
  return button;
}



GtkWidget *
fixed_dir_entry (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text)
{
  GtkWidget *entry = fixed_entry (fixed, x, y, w - 28, h, text);
  GtkWidget *button = fixed_button_browser (fixed, x + w - 29, y);
  gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (dir_browser), entry);
  return entry;
}





/* file_select */
static gboolean
file_select_destroy (GtkWidget * widget)
{
  gtk_main_quit ();
  return FALSE;
}

void
create_file_select (GtkWidget * parent_window, char *label, char *filename, GtkSignalFunc this_func, gpointer this_func_data)
{
  GtkWidget *fs = gtk_file_selection_new (label);
  gtk_window_set_modal (GTK_WINDOW (fs), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (fs), GTK_WINDOW (parent_window));
  gtk_signal_connect (GTK_OBJECT (fs), "destroy", GTK_SIGNAL_FUNC (file_select_destroy), NULL);

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (this_func), this_func_data);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button), "clicked",
		     GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (fs));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fs), filename);
  gtk_widget_show (fs);
  gtk_main ();
}





/* fixed_file_entry */

static void
fixed_file_select_ok (GtkWidget * widget, GtkWidget * entry)
{
  gtk_entry_set_text (GTK_ENTRY (entry), gtk_file_selection_get_filename (GTK_FILE_SELECTION (gtk_widget_get_toplevel (widget))));
  gtk_widget_destroy (GTK_WIDGET (gtk_widget_get_toplevel (widget)));
}

static void
fixed_file_select (GtkWidget * widget, GtkWidget * entry)
{
  create_file_select (gtk_widget_get_toplevel (entry),
		   "File Selection", gtk_entry_get_text (GTK_ENTRY (entry)),
		      fixed_file_select_ok, GTK_OBJECT (entry));
}

GtkWidget *
fixed_file_entry (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text)
{
  GtkWidget *entry = fixed_entry (fixed, x, y, w - 28, h, text);
  GtkWidget *button = fixed_button_browser (fixed, x + w - 29, y);
  gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (fixed_file_select), entry);
  return entry;
}






GtkWidget *
fixed_hseparator (GtkWidget * fixed, gint x, gint y, gint w)
{
  GtkWidget *widget = gtk_hseparator_new ();
  gtk_widget_show (widget);
  gtk_widget_set_usize (widget, w, -1);
  gtk_fixed_put (GTK_FIXED (fixed), widget, x, y);
  return widget;
}



GtkWidget *
fixed_label (GtkWidget * fixed, gint x, gint y, char *text)
{
  GtkWidget *label = gtk_label_new (text);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixed), label, x, y);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  return label;
}



GtkWidget *
fixed_check (GtkWidget * fixed, gint x, gint y, char *text, char this_state)
{
  GtkWidget *check = gtk_check_button_new_with_label (text);
  gtk_widget_show (check);
  gtk_fixed_put (GTK_FIXED (fixed), check, x, y);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (check), this_state);
  return check;
}




GtkWidget *
fixed_radio (GtkWidget * fixed, GtkWidget * last_radio, gchar * label, gint x, gint y,
	  GtkSignalFunc this_func, gpointer this_func_data, char this_state)
{
  GtkWidget *radio;
  if (last_radio == NULL)
    radio = gtk_radio_button_new_with_label (NULL, label);
  else
    radio = gtk_radio_button_new_with_label (LAST_RADIO (last_radio), label);
  gtk_fixed_put (GTK_FIXED (fixed), radio, x, y);
  gtk_widget_show (radio);

  gtk_signal_connect (GTK_OBJECT (radio), "clicked", GTK_SIGNAL_FUNC (this_func), this_func_data);
  if (this_state)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio), this_state);
  return radio;
}


GtkWidget *
fixed_button (GtkWidget * box, char *text)
{
  GtkWidget *button = gtk_button_new_with_label (text);
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);
  return button;
}






GtkWidget *
fixed_spin (GtkWidget * fixed, gint x, gint y, gfloat value, gfloat max_value, gfloat min_value, int increment)
{
  GtkObject *spin_adj;
  GtkWidget *spinbutton;
  spin_adj = gtk_adjustment_new (value, min_value, max_value, (int) increment, 10, 10);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (spin_adj), 1, 0);
  gtk_widget_show (spinbutton);
  gtk_fixed_put (GTK_FIXED (fixed), spinbutton, x, y);
  gtk_widget_set_usize (spinbutton, 93, 24);
  gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spinbutton), GTK_SHADOW_IN);
  return spinbutton;
}



GtkWidget *
fixed_frame (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text)
{
  GtkWidget *frame = gtk_frame_new (text);
  gtk_widget_set_usize (frame, w, h);
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.01, 0.5);
  gtk_widget_show (frame);
  gtk_fixed_put (GTK_FIXED (fixed), frame, x, y);
  return frame;
}


GtkWidget *
hbutton_box (GtkWidget * box)
{
  GtkWidget *buttonbox = gtk_hbutton_box_new ();
  gtk_widget_show (buttonbox);
  gtk_box_pack_end (GTK_BOX (box), buttonbox, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (buttonbox), 5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (buttonbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (buttonbox), 5);
  return buttonbox;
}



GtkWidget *
create_frame (GtkWidget * parent, char *title, char h_expand, char w_expand, GtkShadowType shadow_type)
{
  GtkWidget *frame = gtk_frame_new (title);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (parent), frame, h_expand, w_expand, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), shadow_type);
  return frame;
}


GtkWidget *
v_box (GtkWidget * parent, char homogene, gint spacing, gint border)
{
  GtkWidget *alert_box = gtk_vbox_new (homogene, spacing);
  gtk_container_add (GTK_CONTAINER (parent), alert_box);
  gtk_container_border_width (GTK_CONTAINER (alert_box), border);
  gtk_widget_show (alert_box);
  return alert_box;
}



GtkWidget *
h_box (GtkWidget * parent, char homogene, gint spacing, gint border)
{
  GtkWidget *alert_box = gtk_hbox_new (homogene, spacing);
  gtk_container_add (GTK_CONTAINER (parent), alert_box);
  gtk_container_border_width (GTK_CONTAINER (alert_box), border);
  gtk_widget_show (alert_box);
  return alert_box;
}


GtkWidget *
scroll_win ()
{
  GtkWidget *scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolled_win);
  return scrolled_win;
}


GtkWidget *
create_check_button (GtkWidget * box, char *label, char FLAG)
{
  GtkWidget *check_button = gtk_check_button_new_with_label (label);
  gtk_widget_show (check_button);
  gtk_box_pack_start (GTK_BOX (box), check_button, FALSE, FALSE, 0);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (check_button), FLAG);
  return check_button;
}


GtkWidget *
create_entry (GtkWidget * box, char *default_text)
{
  GtkWidget *entry = gtk_entry_new ();
  gtk_widget_show (entry);
  if (default_text != NULL)
    gtk_entry_set_text (GTK_ENTRY (entry), default_text);
  gtk_box_pack_start (GTK_BOX (box), entry, FALSE, TRUE, 0);
  return entry;
}


GtkWidget *
box_button (GtkWidget * box, char *label)
{
  GtkWidget *button = gtk_button_new_with_label (label);
  gtk_container_add (GTK_CONTAINER (box), button);
  gtk_widget_show (button);
  return button;
}



void
box_button_cancel_destroy_window (GtkWidget * this_box, GtkWidget * this_window)
{
  GtkWidget *alert_button = box_button (this_box, "Cancel");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (this_window));
  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);
}



void
hseparator (GtkWidget * box)
{
  GtkWidget *alert_separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box), alert_separator, FALSE, TRUE, 0);
  gtk_widget_show (alert_separator);
}


void
create_label (GtkWidget * box, char *label_text, GtkJustification jtype, int x_pad, int y_pad)
{
  GtkWidget *label;
  label = gtk_label_new (label_text);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label), jtype);
  gtk_misc_set_padding (GTK_MISC (label), x_pad, y_pad);
}



GtkWidget *
notebook_label (GtkWidget * pixmap, char *label_text)
{
  GtkWidget *hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (pixmap), 3, 1);
  gtk_widget_show (pixmap);
  create_label (hbox, label_text, GTK_JUSTIFY_LEFT, 0, 0);
  return hbox;
}


GtkWidget *
clist_title_with_arrow (GtkWidget * clist, char col, char *label_text)
{
  GtkWidget *hbox = gtk_hbox_new (FALSE, 0);
  GtkWidget *arrow = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_IN);
  GtkWidget *label = gtk_label_new (label_text);

  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), arrow, FALSE, TRUE, 0);
  gtk_widget_show (label);

  gtk_widget_show (hbox);
  gtk_clist_set_column_widget (GTK_CLIST (clist), col, hbox);
  return arrow;
}

void
clist_title_with_arrow_set_up_dow (GtkWidget * arrow, char IS_UP)
{
  gtk_arrow_set (GTK_ARROW (arrow), IS_UP ? GTK_ARROW_UP : GTK_ARROW_DOWN, GTK_SHADOW_IN);
}


GtkWidget *
browser_button (char button_type)
{
  GtkWidget *button = gtk_button_new ();
  GtkWidget *pixmap;
  GdkPixmap *browspix;
  GdkBitmap *browsmsk;

  switch (button_type)
    {
    default:
    case TRUE:
      browspix = browser_pixmap (&browsmsk);
      break;
    case FALSE:
      browspix = browser_close_pixmap (&browsmsk);
      break;
    case MANAGER_BUTTON:
      browspix = man_grp_open_pixmap (&browsmsk);
      break;
    case MANAGER_BUTTON_CLOSE:
      browspix = man_grp_pixmap (&browsmsk);
      break;
    }

  pixmap = gtk_pixmap_new (browspix, browsmsk);
  gtk_container_add (GTK_CONTAINER (button), pixmap);
  gtk_widget_show (pixmap);
  gtk_widget_show (button);
  gtk_widget_set_usize (button, 27, -1);

  gdk_pixmap_unref (browspix);
  gdk_pixmap_unref (browsmsk);
  return button;
}





GtkWidget *
cdup_button (void)
{
#include "pixmaps/cdup.xpm"
  GtkWidget *button = gtk_button_new ();
  GtkWidget *pixmap;
  GdkPixmap *parentpix;
  GdkBitmap *parentmsk;
  parentpix = gdk_pixmap_create_from_xpm_d (window->window, &parentmsk, &window->style->bg[GTK_STATE_NORMAL], cdup_xpm);
  pixmap = gtk_pixmap_new (parentpix, parentmsk);
  gtk_container_add (GTK_CONTAINER (button), pixmap);
  gtk_widget_show (pixmap);
  gtk_widget_show (button);

  gdk_pixmap_unref (parentpix);
  gdk_pixmap_unref (parentmsk);
  return button;
}


GtkWidget *
shell_button (void)
{
#include "pixmaps/shell.xpm"
  GtkWidget *button = gtk_button_new ();
  GtkWidget *pixmap;
  GdkPixmap *parentpix;
  GdkBitmap *parentmsk;
  parentpix = gdk_pixmap_create_from_xpm_d (window->window, &parentmsk, &window->style->bg[GTK_STATE_NORMAL], shell_xpm);

  pixmap = gtk_pixmap_new (parentpix, parentmsk);
  gtk_container_add (GTK_CONTAINER (button), pixmap);
  gtk_widget_show (pixmap);
  gtk_widget_show (button);

  gdk_pixmap_unref (parentpix);
  gdk_pixmap_unref (parentmsk);
  return button;
}

/* EOF */
