/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>


#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif



#define PASV_MODE 0
#define SENDP_MODE 1

#define TYPE_AUTODETECT 0
#define TYPE_ASCII 1
#define TYPE_IMAGE 2
#define TYPE_BIN TYPE_IMAGE
#define TYPE_LOCAL 3


#define HOST_AUTODETECT 0
#define HOST_UNIX 1
#define HOST_SUNOS 2
#define HOST_WIN_NT 3
#define HOST_VMS 4

#define MAX_HOST_TYPE 5


#define LIST_DOWNLOAD 0
#define FILE_DOWNLOAD 1
#define FILE_UPLOAD 2

#define SOCKET_READ 0
#define SOCKET_WRITE 1


/* Ne pas changer les num ici */
#define FIREWALL_TYPE_GENERAL 0
#define FIREWALL_TYPE_SITE 1
#define FIREWALL_TYPE_OPEN 2
#define FIREWALL_TYPE_USER_AT_SITE 3
#define FIREWALL_TYPE_LOGIN_USER_AT_SITE 4
#define FIREWALL_TYPE_SOCKSV5 5


#define FTP_REMOTE_DATE_FORMAT "%b %d %Y"
#define UC(x) (int) (((int) x) & 0xff)

extern char *host_type_name[];


typedef struct
  {
    char hostname[255];
    char connect_address[20];

    int port;
    int socket;
    struct sockaddr_in sock_in;
    int data_socket;

    char proxy;
    char host_type;
    char fs_type;
    char transfert_type;
    char dmode;
    char tmode;

    char is_connected;
    char command_busy;
    char xfer_busy;
    long xfered_bytes;
    char connexion_lost;
    char can_resume;
    char resolve_link;
    int retry_count;
    time_t timeout;
    time_t timer_start;

    char reply[256];
  }
FTP;

typedef struct
  {
    char name[100];
    char size[20];
    char date[15];
    char attrib[11];
    char uid[15];
    char gid[15];
  }
FTPfileinfo;







char FTP_resolve (FTP * FTPctrl);
char FTP_connect (FTP * FTPctrl);
char FTP_SOCKSV5_connect (FTP * FTPctrl, char *username, char *userpass);


char FTP_USER (FTP * FTPctrl, char *username);
char FTP_PASS (FTP * FTPctrl, char *password);
char FTP_SYST (FTP * FTPctrl);
char FTP_SET_TYPE (FTP * FTPctrl, char this_type, char *this_type_name);
#define FTP_TYPE_ASCII(x) FTP_SET_TYPE(x,'A',"ASCII.")
#define FTP_TYPE_IMAGE(x) FTP_SET_TYPE(x,'I',"Image.")
#define FTP_TYPE_LOCAL(x) FTP_SET_TYPE(x,'L',"Local.")

char FTP_CWD (FTP * FTPctrl, char *path);
char FTP_PWD (FTP * FTPctrl);
char FTP_MKD (FTP * FTPctrl, char *path);
char FTP_RMD (FTP * FTPctrl, char *path);

char FTP_DELETE (FTP * FTPctrl, char *filename);
char FTP_CHMOD (FTP * FTPctrl, char *filename, char *mode_string);
char FTP_RENAME (FTP * FTPctrl, char *old_name, char *new_name);

char FTP_REST (FTP * FTPctrl, long fpos);
long FTP_SIZE (FTP * FTPctrl, char *filename);
char FTP_LIST (FTP * FTPctrl, char *filename);
char FTP_DOWNLOAD (FTP * FTPctrl, char *remote_filename, FILE * local, long fpos);
char FTP_UPLOAD (FTP * FTPctrl, char *remote_filename, FILE * local, char append_to_file);
char FTP_QUIT (FTP * FTPctrl);


char FTP_QUOTE (FTP * FTPctrl, char *command);
#define FTP_USER_COMMAND FTP_QUOTE
#define FTP_NOOP(x) FTP_QUOTE (x, "NOOP")
#define FTP_STAT(x) FTP_QUOTE (x, "STAT")

char FTP_XFER_QUOTE (FTP * FTPctrl, char *this_command);
#define FTP_ABORT(x) FTP_XFER_QUOTE (x, "ABOR")
#define FTP_QUIT_WHILE_XFER(x) FTP_XFER_QUOTE (x, "QUIT")


char FTP_format_dir_list (char *inputfile, char *outputfile, char host_type);

/* EOF */
