#!/bin/bash
# Filename:	BuildBox.sh
# Mods:		2009-05-10 RSB	Adapted from similar Virtual AGC script. 

# This is a little script I use to build a GutenMark snapshot (source tarball
# plus binary installers) on my build box, which is set up for ssh passwordless
# access from the workstation I use to do code development.  It's of no earthly
# use to anyone who isn't maintaining the GutenMark website.  The script:
#
#   1.	Creates a source tarball on the coding workstation.
#   2.	Sends it to the build box.
#   3.	Builds it on the build box.
#   4.  Fetches the new snapshot files into my GutenMark website directory.  

BUILDBOX=192.168.254.4
TODAY=`date +%Y%m%d`
WEBSITE=sandroid.org/public_html/GutenMark/wasftp.GutenMark/SoftwareSnapshots

ssh $BUILDBOX mkdir -p ~/Projects/GutenMark
ssh $BUILDBOX mkdir -p ~/Projects/$WEBSITE
ssh $BUILDBOX rm Projects/GutenMark/GutenMark-source -rf
cat ~/Projects/$WEBSITE/GutenMark_source_dev-$TODAY.tar.gz | ssh $BUILDBOX tar -C Projects/GutenMark -xzvf -
ssh $BUILDBOX make -C Projects/GutenMark/GutenMark-source snapshot
scp -p $BUILDBOX:Projects/$WEBSITE/GutenMark_source_dev-$TODAY.tar.gz ~/Projects/$WEBSITE
scp -p $BUILDBOX:Projects/$WEBSITE/GUItenMark-Linux-Install ~/Projects/$WEBSITE
scp -p $BUILDBOX:Projects/$WEBSITE/GUItenMark-Win32-setup.exe ~/Projects/$WEBSITE
scp -p $BUILDBOX:Projects/$WEBSITE/GUItenMark.app.tar.gz ~/Projects/$WEBSITE
ls -ltr ~/Projects/$WEBSITE

