#include "cps.h"
#include "timekpr.h"

#define CPS1_68K_PROGRAM_BYTESWAP			1
#define CPS1_68K_PROGRAM_NO_BYTESWAP		2
#define CPS1_Z80_PROGRAM					3
#define CPS1_TILES							4
#define CPS1_OKIM6295_SAMPLES				5
#define CPS1_QSOUND_SAMPLES					6
#define CPS1_PIC							7
#define CPS1_EXTRA_TILES_SF2EBBL_400000		8
#define CPS1_EXTRA_TILES_400000				9
#define CPS1_EXTRA_TILES_SF2KORYU_400000	10
#define CPS1_EXTRA_TILES_SF2B_400000		11
#define CPS1_EXTRA_TILES_SF2MKOT_400000		12

typedef INT32 (*Cps1Callback)(INT32);
static Cps1Callback Cps1GfxLoadCallbackFunction = NULL;

static UINT8 Cps1QSDip   = 0; // Fake Dip

// Input Definitions

static struct BurnInputInfo NTFOInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(NTFO)

static struct BurnInputInfo ThreeWondersInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Button 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Button 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Button 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Button 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
	{"Dip D"            , BIT_DIPSWITCH, &fFakeDip  , "dip"       },
};

STDINPUTINFO(ThreeWonders)

static struct BurnInputInfo CaptcommInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"P4 Coin"          , BIT_DIGITAL  , CpsInp179+6, "p4 coin"   },
	{"P4 Start"         , BIT_DIGITAL  , CpsInp179+7, "p4 start"  },
	{"P4 Up"            , BIT_DIGITAL  , CpsInp179+3, "p4 up"     },
	{"P4 Down"          , BIT_DIGITAL  , CpsInp179+2, "p4 down"   },
	{"P4 Left"          , BIT_DIGITAL  , CpsInp179+1, "p4 left"   },
	{"P4 Right"         , BIT_DIGITAL  , CpsInp179+0, "p4 right"  },
	{"P4 Attack"        , BIT_DIGITAL  , CpsInp179+4, "p4 fire 1" },
	{"P4 Jump"          , BIT_DIGITAL  , CpsInp179+5, "p4 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Captcomm)

static struct BurnInputInfo CawingInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Cawing)

static struct BurnInputInfo Cworld2jInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Cworld2j)

static struct BurnInputInfo DinoInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0 , "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4 , "p1 start" },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3 , "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2 , "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1 , "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0 , "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4 , "p1 fire 1"},
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5 , "p1 fire 2"},

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1 , "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5 , "p2 start" },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3 , "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2 , "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1 , "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0 , "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4 , "p2 fire 1"},
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5 , "p2 fire 2"},

	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  },
	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},

	{"Reset"            , BIT_DIGITAL  , &CpsReset   ,  "reset"   },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 ,  "diag"    },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2 ,  "service" },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     ,  "dip"     },
};

STDINPUTINFO(Dino)

static struct BurnInputInfo DinohInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0 , "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4 , "p1 start" },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3 , "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2 , "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1 , "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0 , "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4 , "p1 fire 1"},
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5 , "p1 fire 2"},
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+6 , "p1 fire 3"},

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1 , "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5 , "p2 start" },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3 , "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2 , "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1 , "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0 , "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4 , "p2 fire 1"},
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5 , "p2 fire 2"},
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+6 , "p2 fire 3"},

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset   ,  "reset"   },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 ,  "diag"    },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2 ,  "service" },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     ,  "dip"     },
};

STDINPUTINFO(Dinoh)

static struct BurnInputInfo DynwarInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack Left"   , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Attack Right"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack Left"   , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Attack Right"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Dynwar)

static struct BurnInputInfo FfightInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Ffight)

static struct BurnInputInfo FfightaeInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start" },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1"},
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2"},
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3"},

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start" },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1"},
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2"},
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3"},

	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },
	{"P3 Special"       , BIT_DIGITAL  , CpsInp177+6, "p3 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"   },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Ffightae)

#define A(a, b, c, d) {a, b, (UINT8*)(c), d}

static struct BurnInputInfo ForgottnInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL,    CpsInp018+0, "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL,    CpsInp018+4, "p1 start" },
	{"P1 Up"            , BIT_DIGITAL,    CpsInp001+3, "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL,    CpsInp001+2, "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL,    CpsInp001+1, "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL,    CpsInp001+0, "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL,    CpsInp001+4, "p1 fire 1"},
	A("P1 Turn (analog)", BIT_ANALOG_REL, &CpsInp055,  "p1 z-axis"),
	{"P1 Turn - (digital)", BIT_DIGITAL,  CpsDigUD+0,  "p1 fire 2"},
	{"P1 Turn + (digital)", BIT_DIGITAL,  CpsDigUD+1,  "p1 fire 3"},

	{"P2 Coin"          , BIT_DIGITAL,    CpsInp018+1, "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL,    CpsInp018+5, "p2 start" },
	{"P2 Up"            , BIT_DIGITAL,    CpsInp000+3, "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL,    CpsInp000+2, "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL,    CpsInp000+1, "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL,    CpsInp000+0, "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL,    CpsInp000+4, "p2 fire 1"},
	A("P2 Turn (analog)", BIT_ANALOG_REL, &CpsInp05d,  "p2 z-axis"),
	{"P2 Turn - (digital)", BIT_DIGITAL,  CpsDigUD+2,  "p2 fire 2"},
	{"P2 Turn + (digital)", BIT_DIGITAL,  CpsDigUD+3,  "p2 fire 3"},

	{"Reset"            , BIT_DIGITAL,    &CpsReset,   "reset"    },
	{"Service"          , BIT_DIGITAL,    CpsInp018+2, "service"  },

	{"Dip A"            , BIT_DIPSWITCH,  &Cpi01A    , "dip"      },
	{"Dip B"            , BIT_DIPSWITCH,  &Cpi01C    , "dip"      },
	{"Dip C"            , BIT_DIPSWITCH,  &Cpi01E    , "dip"      },
	{"Dip D"            , BIT_DIPSWITCH,  &fFakeDip  , "dip"      },
};

#undef A

STDINPUTINFO(Forgottn)

static struct BurnInputInfo GanbareInputList[] = {
	{"Coin 1"           , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"Coin 2"           , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"Start"            , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"Left Switch"      , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"Right Switch"     , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"Show Switch"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"Pay Switch"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Ganbare)

static struct BurnInputInfo GhoulsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Fire"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	
	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Fire"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
	{"Dip D"            , BIT_DIPSWITCH, &fFakeDip  , "dip"       },
};

STDINPUTINFO(Ghouls)

static struct BurnInputInfo KnightsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Knights)

static struct BurnInputInfo KnightshInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Knightsh)

static struct BurnInputInfo KodInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Kod)

// Kodh - only players 1 & 2 have special!
static struct BurnInputInfo KodhInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc000+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInpc000+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInpc000+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInpc000+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInpc000+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInpc000+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc000+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc000+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Kodh)

static struct BurnInputInfo MegamanInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Fire"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Select"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Fire"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Select"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Megaman)

static struct BurnInputInfo MercsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Shot"          , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Special"       , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Mercs)

static struct BurnInputInfo MswordInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Msword)

static struct BurnInputInfo MtwinsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Mtwins)

static struct BurnInputInfo NemoInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Nemo)

static struct BurnInputInfo Pang3InputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot 1"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Shot 2"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot 1"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Shot 2"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Pang3)

static struct BurnInputInfo PnickjInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Turn 1"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Turn 2"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Turn 1"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Turn 2"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Pnickj)

static struct BurnInputInfo PokonyanInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Pokonyan)

#define A(a, b, c, d) {a, b, (UINT8*)(c), d}

static struct BurnInputInfo HkittympInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	A("P1 Wheel"        , BIT_ANALOG_REL, &CpsInpPaddle1, "p1 x-axis"),
 	{"P1 Kitty"         , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Keroppi"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Badtz-Maru"    , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Hkittymp)

static struct BurnInputInfo PunisherInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Punisher)

static struct BurnInputInfo PunisherbzInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Super"         , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Super"         , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
};

STDINPUTINFO(Punisherbz)

static struct BurnInputInfo QadInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },
	
	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Qad)

static struct BurnInputInfo Qtono2jInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Qtono2j)

static struct BurnInputInfo Sf2InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp177+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp177+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp177+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp177+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp177+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp177+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2)

static struct BurnInputInfo Sf2ueInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp1fd+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp1fd+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp1fd+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp1fd+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp1fd+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp1fd+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2ue)

static struct BurnInputInfo Sf2yycInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp019+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp019+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp176+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp176+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp176+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp019+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp019+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp176+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp176+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp176+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp019+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp019+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2yyc)

static struct BurnInputInfo Sf2ceeablInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp012+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp012+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp012+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp012+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp012+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp012+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2ceeabl)

static struct BurnInputInfo Sf2ceuablInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp029+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp029+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp011+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp011+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp011+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp011+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp011+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp011+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp011+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp186+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp186+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp186+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp029+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp029+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp010+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp010+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp010+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp010+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp010+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp010+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp010+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp186+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp186+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp186+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp029+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp029+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2ceuabl)

static struct BurnInputInfo SfzchInputList[] =
{
	{"P1 Pause"         , BIT_DIGITAL  , CpsInp018+2, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
 	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },
 	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp018+0, "p1 fire 5" },
 	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp018+6, "p1 fire 6" },

 	{"P2 Pause"         , BIT_DIGITAL  , CpsInp018+3, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
 	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },
 	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp018+1, "p2 fire 5" },
 	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp018+7, "p2 fire 6" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
};

STDINPUTINFO(Sfzch)

static struct BurnInputInfo SlammastInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   }, //  0
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  }, //  1
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     }, //  2
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   }, //  3
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   }, //  4
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  }, //  5
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" }, //  6
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" }, //  7
 	{"P1 Pin"           , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" }, //  8

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   }, //  9
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  }, //  a
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     }, //  b
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   }, //  c
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   }, //  d
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  }, //  e
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" }, //  f
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" }, // 10
 	{"P2 Pin"           , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" }, // 11

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  }, // 12
 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" }, // 13
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    }, // 14
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  }, // 15
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  }, // 16
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" }, // 17
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"}, // 18
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"}, // 19
 	{"P3 Pin"           , BIT_DIGITAL  , CpsInp001+7 , "p3 fire 3"}, // 1a

 	{"P4 Coin"          , BIT_DIGITAL  , CpsInpc003+6, "p4 coin"  }, // 1b
 	{"P4 Start"         , BIT_DIGITAL  , CpsInpc003+7, "p4 start" }, // 1c
 	{"P4 Up"            , BIT_DIGITAL  , CpsInpc003+3, "p4 up"    }, // 1d
 	{"P4 Down"          , BIT_DIGITAL  , CpsInpc003+2, "p4 down"  }, // 1e
 	{"P4 Left"          , BIT_DIGITAL  , CpsInpc003+1, "p4 left"  }, // 1f
 	{"P4 Right"         , BIT_DIGITAL  , CpsInpc003+0, "p4 right" }, // 20
 	{"P4 Attack"        , BIT_DIGITAL  , CpsInpc003+4, "p4 fire 1"}, // 21
 	{"P4 Jump"          , BIT_DIGITAL  , CpsInpc003+5, "p4 fire 2"}, // 22
 	{"P4 Pin"           , BIT_DIGITAL  , CpsInp000+7 , "p4 fire 3"}, // 23

 	{"Reset"            , BIT_DIGITAL  , &CpsReset   , "reset"    }, // 24
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 , "diag"     }, // 25
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2 , "service"  }, // 26
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     , "dip"      }, // 27
};

STDINPUTINFO(Slammast)

static struct BurnInputInfo MbombrdInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+6, "p1 fire 2" },
 	{"P1 Pin"           , BIT_DIGITAL  , CpsInp001+4, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+6, "p2 fire 2" },
 	{"P2 Pin"           , BIT_DIGITAL  , CpsInp000+4, "p2 fire 3" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 1"},
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInp001+7 , "p3 fire 2"},
 	{"P3 Pin"           , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 3"},

 	{"P4 Coin"          , BIT_DIGITAL  , CpsInpc003+6, "p4 coin"  },
 	{"P4 Start"         , BIT_DIGITAL  , CpsInpc003+7, "p4 start" },
 	{"P4 Up"            , BIT_DIGITAL  , CpsInpc003+3, "p4 up"    },
 	{"P4 Down"          , BIT_DIGITAL  , CpsInpc003+2, "p4 down"  },
 	{"P4 Left"          , BIT_DIGITAL  , CpsInpc003+1, "p4 left"  },
 	{"P4 Right"         , BIT_DIGITAL  , CpsInpc003+0, "p4 right" },
 	{"P4 Attack"        , BIT_DIGITAL  , CpsInpc003+5, "p4 fire 1"},
 	{"P4 Jump"          , BIT_DIGITAL  , CpsInp000+7 , "p4 fire 2"},
 	{"P4 Pin"           , BIT_DIGITAL  , CpsInpc003+4, "p4 fire 3"},

 	{"Reset"            , BIT_DIGITAL  , &CpsReset   , "reset"    },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 , "diag"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2 , "service"  },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     , "dip"      },
};

STDINPUTINFO(Mbombrd)

static struct BurnInputInfo StriderInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Strider)

static struct BurnInputInfo UnsquadInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },

};

STDINPUTINFO(Unsquad)

static struct BurnInputInfo VarthInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Varth)

static struct BurnInputInfo WillowInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
 
 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Willow)

static struct BurnInputInfo WofInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  ,  "reset"    },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6,  "diag"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2,  "service"  },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    ,  "dip"      },
};

STDINPUTINFO(Wof)

static struct BurnInputInfo WofchInputList[] =
{
	{"P1 Pause"         , BIT_DIGITAL  , CpsInp018+2, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire"          , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
 	{"P1 Fire 4"        , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },
 	{"P1 Fire 5"        , BIT_DIGITAL  , CpsInp018+0, "p1 fire 5" },
 	{"P1 Fire 6"        , BIT_DIGITAL  , CpsInp018+6, "p1 fire 6" },

	{"P2 Pause"         , BIT_DIGITAL  , CpsInp018+3, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire"          , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
 	{"P2 Fire 4"        , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },
 	{"P2 Fire 5"        , BIT_DIGITAL  , CpsInp018+1, "p2 fire 5" },
 	{"P2 Fire 6"        , BIT_DIGITAL  , CpsInp018+7, "p2 fire 6" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
};

STDINPUTINFO(Wofch)

static struct BurnInputInfo WofchpInputList[] =
{
	{"P1 Pause"         , BIT_DIGITAL  , CpsInp018+2, "p1 coin"   },  // Pressing with the Start key will enter config
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },  // Adjustable in config (6 keys)
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire"          , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
 	{"P1 Fire 4"        , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },
 	{"P1 Fire 5"        , BIT_DIGITAL  , CpsInp018+0, "p1 fire 5" },
 	{"P1 Fire 6"        , BIT_DIGITAL  , CpsInp018+6, "p1 fire 6" },

	{"P2 Pause"         , BIT_DIGITAL  , CpsInp018+3, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },  // Adjustable in config (6 keys)
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire"          , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
 	{"P2 Fire 4"        , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },
 	{"P2 Fire 5"        , BIT_DIGITAL  , CpsInp018+1, "p2 fire 5" },
 	{"P2 Fire 6"        , BIT_DIGITAL  , CpsInp018+7, "p2 fire 6" },

 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },  // There are no options for P3
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
};

STDINPUTINFO(Wofchp)

static struct BurnInputInfo WofhfhInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },
 	{"P3 Fire 3"        , BIT_DIGITAL  , CpsInp177+6, "p3 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Wofhfh)

static struct BurnInputInfo WofhInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   }, //  0
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  }, //  1
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     }, //  2
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   }, //  3
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   }, //  4
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  }, //  5
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" }, //  6
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" }, //  7
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" }, //  8

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   }, //  9
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  }, //  a
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     }, //  b
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   }, //  c
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   }, //  d
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  }, //  e
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" }, //  f
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" }, // 10
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" }, // 11

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   }, // 12	doesn't work in some sets?
 	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  }, // 13
 	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     }, // 14
 	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   }, // 15
 	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   }, // 16
 	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  }, // 17
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" }, // 18
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" }, // 19
 	{"P3 Fire 3"        , BIT_DIGITAL  , CpsInp177+6, "p3 fire 3" }, // 1a

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     }, // 1b
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   }, // 1c
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       }, // 1d
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       }, // 1e
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       }, // 1f
};

STDINPUTINFO(Wofh)

static struct BurnInputInfo Wof3jsInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },
	{"P3 Fire 3"        , BIT_DIGITAL  , CpsInp177+6, "p3 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Wof3js)

// don't know where this one reads config data from (if at all), reads values at 0x80001a, 0x80001e, 0x80001f (but values make no difference)
// if I force it to use EEPROM, the config data gets forgotten
static struct BurnInputInfo WofsjbInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInp01B+6, "p3 coin"   },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInp01B+7, "p3 start"  },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInp01B+3, "p3 up"     },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInp01B+2, "p3 down"   },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInp01B+1, "p3 left"   },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInp01B+0, "p3 right"  },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInp01B+4, "p3 fire 1" },
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInp01B+5, "p3 fire 2" },
 	{"P3 Fire 3"        , BIT_DIGITAL  , CpsInp01B+6, "p3 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
	{"Dip D"            , BIT_DIPSWITCH, &Cps1QSDip , "dip"       },
};

STDINPUTINFO(Wofsjb)

// Maximum three players, no third fire button, DIPSW has ABC input scheme.
static struct BurnInputInfo WofablaInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018 + 0, "p1 coin"   }, //  0
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018 + 4, "p1 start"  }, //  1
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001 + 3, "p1 up"     }, //  2
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001 + 2, "p1 down"   }, //  3
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001 + 1, "p1 left"   }, //  4
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001 + 0, "p1 right"  }, //  5
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001 + 4, "p1 fire 1" }, //  6
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001 + 5, "p1 fire 2" }, //  7

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018 + 1, "p2 coin"   }, //  8
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018 + 5, "p2 start"  }, //  9
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000 + 3, "p2 up"     }, //  a
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000 + 2, "p2 down"   }, //  b
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000 + 1, "p2 left"   }, //  c
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000 + 0, "p2 right"  }, //  d
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000 + 4, "p2 fire 1" }, //  e
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000 + 5, "p2 fire 2" }, //  f

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177 + 6, "p3 coin"   }, // 10
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177 + 7, "p3 start"  }, // 11
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177 + 3, "p3 up"     }, // 12
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177 + 2, "p3 down"   }, // 13
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177 + 1, "p3 left"   }, // 14
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177 + 0, "p3 right"  }, // 15
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177 + 4, "p3 fire 1" }, // 16
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177 + 5, "p3 fire 2" }, // 17

	{"Reset"            , BIT_DIGITAL  , &CpsReset    , "reset"     }, // 18
	{"Service"          , BIT_DIGITAL  , CpsInp018 + 2, "service"   }, // 19
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A      , "dip"       }, // 1a
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C      , "dip"       }, // 1b
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E      , "dip"       }, // 1c
};

STDINPUTINFO(Wofabla)


static struct BurnInputInfo QSoundPatchInputList[] =
{
	{"Dip D"            , BIT_DIPSWITCH, &Cps1QSDip , "dip"       },
};

STDINPUTINFOEXT(DinoQS, Dino, QSoundPatch)
STDINPUTINFOEXT(DinohQS, Dinoh, QSoundPatch)
STDINPUTINFOEXT(PunisherQS, Punisher, QSoundPatch)
STDINPUTINFOEXT(SlammastQS, Slammast, QSoundPatch)
STDINPUTINFOEXT(WofQS,Wof, QSoundPatch)


// Dip Switch Definitions

#define CPS1_COINAGE_1(dipval) \
	{0     , 0xfe, 0   , 8   , "Coin A"                 }, \
	{dipval, 0x01, 0x07, 0x07, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x06, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x05, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x01, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x07, 0x02, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x07, 0x03, "1 Coin  4 Credits"      }, \
	{dipval, 0x01, 0x07, 0x04, "1 Coin  6 Credits"      }, \
							       \
	{0     , 0xfe, 0   , 8   , "Coin B"                 }, \
	{dipval, 0x01, 0x38, 0x38, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x30, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x28, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x08, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x38, 0x10, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x38, 0x18, "1 Coin  4 Credits"      }, \
	{dipval, 0x01, 0x38, 0x20, "1 Coin  6 Credits"      }, 
	
#define CPS1_COINAGE_2(dipval) \
	{0     , 0xfe, 0   , 8   , "Coinage"                }, \
	{dipval, 0x01, 0x07, 0x07, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x06, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x05, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x01, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x07, 0x02, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x07, 0x03, "1 Coin  4 Credits"      }, \
	{dipval, 0x01, 0x07, 0x04, "1 Coin  6 Credits"      }, 
	
#define CPS1_COINAGE_3(dipval) \
	{0     , 0xfe, 0   , 8   , "Coin A"                 }, \
	{dipval, 0x01, 0x07, 0x06, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x05, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x04, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x07, "2 Coins 1 Credit (1 to cont)"}, \
	{dipval, 0x01, 0x07, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x01, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x07, 0x02, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x07, 0x03, "1 Coin  4 Credits"      }, \
							       \
	{0     , 0xfe, 0   , 8   , "Coin B"                 }, \
	{dipval, 0x01, 0x38, 0x30, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x28, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x20, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x38, "2 Coins 1 Credit (1 to cont)"}, \
	{dipval, 0x01, 0x38, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x08, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x38, 0x10, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x38, 0x18, "1 Coin  4 Credits"      }, 
	
#define CPS1_DIFFICULTY_1(dipval) \
	{0   , 0xfe, 0   , 8   , "Difficulty"               }, \
	{dipval, 0x01, 0x07, 0x00, "1 (Easiest)"            }, \
	{dipval, 0x01, 0x07, 0x01, "2"                      }, \
	{dipval, 0x01, 0x07, 0x02, "3"                      }, \
	{dipval, 0x01, 0x07, 0x03, "4 (Normal)"             }, \
	{dipval, 0x01, 0x07, 0x04, "5"                      }, \
	{dipval, 0x01, 0x07, 0x05, "6"                      }, \
	{dipval, 0x01, 0x07, 0x06, "7"                      }, \
	{dipval, 0x01, 0x07, 0x07, "8 (Hardest)"            },
	
#define CPS1_DIFFICULTY_2(dipval) \
	{0   , 0xfe, 0   , 8   , "Difficulty"               }, \
	{dipval, 0x01, 0x07, 0x03, "1 (Easiest)"            }, \
	{dipval, 0x01, 0x07, 0x02, "2"                      }, \
	{dipval, 0x01, 0x07, 0x01, "3"                      }, \
	{dipval, 0x01, 0x07, 0x00, "4 (Normal)"             }, \
	{dipval, 0x01, 0x07, 0x04, "5"                      }, \
	{dipval, 0x01, 0x07, 0x05, "6"                      }, \
	{dipval, 0x01, 0x07, 0x06, "7"                      }, \
	{dipval, 0x01, 0x07, 0x07, "8 (Hardest)"            },

static struct BurnDIPInfo NTFODIPList[]=
{
	// Defaults
	{0x12, 0xff, 0xff, 0x00, NULL                     },
	{0x13, 0xff, 0xff, 0x00, NULL                     },
	{0x14, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x12)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x12, 0x01, 0x40, 0x00, "Off"                    },
	{0x12, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x13)
	
	{0   , 0xfe, 0   , 4   , "Level Up Timer"         },
	{0x13, 0x01, 0x18, 0x00, "More Slowly"            },
	{0x13, 0x01, 0x18, 0x08, "Slowly"                 },
	{0x13, 0x01, 0x18, 0x10, "Quickly"                },
	{0x13, 0x01, 0x18, 0x18, "More Quickly"           },

	{0   , 0xfe, 0   , 4   , "Bullet's Speed"         },
	{0x13, 0x01, 0x60, 0x00, "Very Slow"              },
	{0x13, 0x01, 0x60, 0x20, "Slow"                   },
	{0x13, 0x01, 0x60, 0x40, "Fast"                   },
	{0x13, 0x01, 0x60, 0x60, "Very Fast"              },

	{0   , 0xfe, 0   , 2   , "Initial Vitality"       },
	{0x13, 0x01, 0x80, 0x00, "3 bars"                 },
	{0x13, 0x01, 0x80, 0x80, "4 bars"                 },
	
	// Dip C
	{0   , 0xfe, 0   , 2   , "Throttle Game Speed"    },
	{0x14, 0x01, 0x01, 0x01, "Off"                    },
	{0x14, 0x01, 0x01, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x14, 0x01, 0x04, 0x00, "Off"                    },
	{0x14, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x14, 0x01, 0x08, 0x00, "Off"                    },
	{0x14, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x14, 0x01, 0x10, 0x00, "Off"                    },
	{0x14, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x14, 0x01, 0x20, 0x00, "Off"                    },
	{0x14, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x14, 0x01, 0x40, 0x00, "Off"                    },
	{0x14, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x14, 0x01, 0x80, 0x00, "Game"                   },
	{0x14, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(NTFO)

static struct BurnDIPInfo ThreeWondersDIPList[]=
{
	// Defaults
	{0x13, 0xff, 0xff, 0x00, NULL                     },
	{0x14, 0xff, 0xff, 0x65, NULL                     },
	{0x15, 0xff, 0xff, 0x66, NULL                     },
	{0x16, 0xff, 0xff, 0x00, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x13)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x13, 0x01, 0x40, 0x00, "Off"                    },
	{0x13, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x13, 0x01, 0x80, 0x00, "Off"                    },
	{0x13, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 4   , "Action Lives"           },
	{0x14, 0x01, 0x03, 0x00, "1"                      },
	{0x14, 0x01, 0x03, 0x01, "2"                      },
	{0x14, 0x01, 0x03, 0x02, "3"                      },
	{0x14, 0x01, 0x03, 0x03, "5"                      },

	{0   , 0xfe, 0   , 4   , "Action Game Level"      },
	{0x14, 0x01, 0x0c, 0x00, "Easy"                   },
	{0x14, 0x01, 0x0c, 0x04, "Normal"                 },
	{0x14, 0x01, 0x0c, 0x08, "Hard"                   },
	{0x14, 0x01, 0x0c, 0x0c, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Shooting Lives"         },
	{0x14, 0x01, 0x30, 0x00, "1"                      },
	{0x14, 0x01, 0x30, 0x10, "2"                      },
	{0x14, 0x01, 0x30, 0x20, "3"                      },
	{0x14, 0x01, 0x30, 0x30, "5"                      },

	{0   , 0xfe, 0   , 4   , "Shooting Game Level"    },
	{0x14, 0x01, 0xc0, 0x00, "Easy"                   },
	{0x14, 0x01, 0xc0, 0x40, "Normal"                 },
	{0x14, 0x01, 0xc0, 0x80, "Hard"                   },
	{0x14, 0x01, 0xc0, 0xc0, "Hardest"                },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Puzzle Lives"           },
	{0x15, 0x01, 0x03, 0x00, "1"                      },
	{0x15, 0x01, 0x03, 0x01, "2"                      },
	{0x15, 0x01, 0x03, 0x02, "3"                      },
	{0x15, 0x01, 0x03, 0x03, "5"                      },

	{0   , 0xfe, 0   , 4   , "Puzzle Game Level"      },
	{0x15, 0x01, 0x0c, 0x00, "Easy"                   },
	{0x15, 0x01, 0x0c, 0x04, "Normal"                 },
	{0x15, 0x01, 0x0c, 0x08, "Hard"                   },
	{0x15, 0x01, 0x0c, 0x0c, "Hardest"                },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x15, 0x01, 0x10, 0x00, "Off"                    },
	{0x15, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x15, 0x01, 0x20, 0x00, "Off"                    },
	{0x15, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x15, 0x01, 0x40, 0x00, "Off"                    },
	{0x15, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x15, 0x01, 0x80, 0x00, "Game"                   },
	{0x15, 0x01, 0x80, 0x80, "Test"                   },

	{0   , 0xfe, 0   , 2   , "CPS1 Backdrop (fake)"   },
	{0x16, 0x01, 0x01, 0x00, "Normal"                 },
	{0x16, 0x01, 0x01, 0x01, "Always Black"           },
};

STDDIPINFO(ThreeWonders)

static struct BurnDIPInfo Captcomm1PDIPList[]=
{
	// Defaults
	{0x23, 0xff, 0xff, 0x00, NULL                     },
	{0x24, 0xff, 0xff, 0x8b, NULL                     },
	{0x25, 0xff, 0xff, 0x60, NULL                     },
};

static struct BurnDIPInfo Captcomm2PDIPList[] =
{
	// Defaults
	{0x23, 0xff, 0xff, 0x00, NULL                     },
	{0x24, 0xff, 0xff, 0x0b, NULL                     },
	{0x25, 0xff, 0xff, 0x60, NULL                     },
};

static struct BurnDIPInfo Captcomm3PDIPList[] =
{
	// Defaults
	{0x23, 0xff, 0xff, 0x00, NULL                     },
	{0x24, 0xff, 0xff, 0x4b, NULL                     },
	{0x25, 0xff, 0xff, 0x60, NULL                     },
};

static struct BurnDIPInfo Captcomm4PDIPList[] =
{
	// Defaults
	{0x23, 0xff, 0xff, 0x00, NULL                     },
	{0x24, 0xff, 0xff, 0xcb, NULL                     },
	{0x25, 0xff, 0xff, 0x60, NULL                     },
};

static struct BurnDIPInfo CaptcommDIPList[]=
{
	// Dip A
	CPS1_COINAGE_2(0x23)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x23, 0x01, 0x40, 0x00, "Off"                    },
	{0x23, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x24)

	{0   , 0xfe, 0   , 4   , "Difficulty 2"           },
	{0x24, 0x01, 0x18, 0x00, "Easy"                   },
	{0x24, 0x01, 0x18, 0x08, "Normal"                 },
	{0x24, 0x01, 0x18, 0x10, "Hard"                   },
	{0x24, 0x01, 0x18, 0x18, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Play Mode"              },
	{0x24, 0x01, 0xc0, 0x80, "1 Player"               },
	{0x24, 0x01, 0xc0, 0x00, "2 Player"               },
	{0x24, 0x01, 0xc0, 0x40, "3 Player"               },
	{0x24, 0x01, 0xc0, 0xc0, "4 Player"               },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x25, 0x01, 0x03, 0x03, "1"                      },
	{0x25, 0x01, 0x03, 0x00, "2"                      },
	{0x25, 0x01, 0x03, 0x01, "3"                      },
	{0x25, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x25, 0x01, 0x04, 0x00, "Off"                    },
	{0x25, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x25, 0x01, 0x08, 0x00, "Off"                    },
	{0x25, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x25, 0x01, 0x10, 0x00, "Off"                    },
	{0x25, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x25, 0x01, 0x20, 0x00, "Off"                    },
	{0x25, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x25, 0x01, 0x40, 0x00, "Off"                    },
	{0x25, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x25, 0x01, 0x80, 0x00, "Game"                   },
	{0x25, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFOEXT(Captcomm1P, Captcomm1P, Captcomm )
STDDIPINFOEXT(Captcomm,   Captcomm2P, Captcomm )
STDDIPINFOEXT(Captcomm3P, Captcomm3P, Captcomm )
STDDIPINFOEXT(Captcomm4P, Captcomm4P, Captcomm )

static struct BurnDIPInfo CawingDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x03, NULL                     },
	{0x17, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x15)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x15, 0x01, 0x40, 0x00, "Off"                    },
	{0x15, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Difficulty (Enemys strength)"},
	{0x16, 0x01, 0x07, 0x00, "1 (Easiest)"            },
	{0x16, 0x01, 0x07, 0x01, "2"                      },
	{0x16, 0x01, 0x07, 0x02, "3"                      },
	{0x16, 0x01, 0x07, 0x03, "4 (Normal)"             },
	{0x16, 0x01, 0x07, 0x04, "5"                      },
	{0x16, 0x01, 0x07, 0x05, "6"                      },
	{0x16, 0x01, 0x07, 0x06, "7"                      },
	{0x16, 0x01, 0x07, 0x07, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 4   , "Difficulty (Players strength)"},
	{0x16, 0x01, 0x18, 0x08, "Easy"                   },
	{0x16, 0x01, 0x18, 0x00, "Normal"                 },
	{0x16, 0x01, 0x18, 0x10, "Difficult"              },
	{0x16, 0x01, 0x18, 0x18, "Very Difficult"         },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x17, 0x01, 0x04, 0x00, "Off"                    },
	{0x17, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x08, 0x00, "Off"                    },
	{0x17, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Sound"                  },
	{0x17, 0x01, 0x20, 0x00, "Off"                    },
	{0x17, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Cawing)

static struct BurnDIPInfo Cworld2jDIPList[]=
{
	// Defaults
	{0x0f, 0xff, 0xff, 0x00, NULL                     },
	{0x10, 0xff, 0xff, 0x01, NULL                     },
	{0x11, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x0f)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x0f, 0x01, 0x40, 0x00, "Off"                    },
	{0x0f, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Extended Test Mode"     },
	{0x0f, 0x01, 0x80, 0x00, "Off"                    },
	{0x0f, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 4   , "Difficulty"             },
	{0x10, 0x01, 0x07, 0x01, "0"                      },
	{0x10, 0x01, 0x07, 0x02, "1"                      },
	{0x10, 0x01, 0x07, 0x03, "2"                      },
	{0x10, 0x01, 0x07, 0x04, "3"                      },
	{0x10, 0x01, 0x07, 0x05, "4"                      },

	{0   , 0xfe, 0   , 3   , "Extend"                 },
	{0x10, 0x01, 0x18, 0x18, "D"                      },
	{0x10, 0x01, 0x18, 0x08, "E"                      },
	{0x10, 0x01, 0x18, 0x00, "N"                      },

	{0   , 0xfe, 0   , 5   , "Lives"                  },
	{0x10, 0x01, 0xe0, 0xe0, "1"                      },
	{0x10, 0x01, 0xe0, 0x60, "2"                      },
	{0x10, 0x01, 0xe0, 0x00, "3"                      },
	{0x10, 0x01, 0xe0, 0x40, "4"                      },
	{0x10, 0x01, 0xe0, 0x20, "5"                      },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x11, 0x01, 0x04, 0x00, "Off"                    },
	{0x11, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x11, 0x01, 0x08, 0x00, "Off"                    },
	{0x11, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x11, 0x01, 0x10, 0x00, "Off"                    },
	{0x11, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x11, 0x01, 0x20, 0x00, "Off"                    },
	{0x11, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x11, 0x01, 0x40, 0x00, "Off"                    },
	{0x11, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x11, 0x01, 0x80, 0x00, "Game"                   },
	{0x11, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Cworld2j)

static struct BurnDIPInfo DinoDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1b, 0x01, 0x08, 0x00, "Off"                    },
	{0x1b, 0x01, 0x08, 0x08, "On"                     },
};

STDDIPINFO(Dino)

static struct BurnDIPInfo DinohDIPList[]=
{
	// Defaults
	{0x1d, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },
};

STDDIPINFO(Dinoh)

static struct BurnDIPInfo DynwarDIPList[]=
{
	// Defaults
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
        CPS1_COINAGE_3(0x14)

    {0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x14, 0x01, 0x80, 0x00, "Off"                    },
	{0x14, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_2(0x15)
	
	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x16, 0x01, 0x01, 0x00, "Off"                    },
	{0x16, 0x01, 0x01, 0x01, "On"                     },

	{0   , 0xfe, 0   , 2   , "Turbo Mode"             },
	{0x16, 0x01, 0x02, 0x00, "Off"                    },
	{0x16, 0x01, 0x02, 0x02, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x10, 0x00, "Off"                    },
	{0x16, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x16, 0x01, 0x20, 0x20, "Off"                    },
	{0x16, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x16, 0x01, 0x40, 0x40, "Off"                    },
	{0x16, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x16, 0x01, 0x80, 0x00, "Game"                   },
	{0x16, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Dynwar)

static struct BurnDIPInfo FfightDIPList[]=
{
	// Defaults
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x0b, NULL                     },
	{0x16, 0xff, 0xff, 0x60, NULL                     },
		
	// Dip A
	CPS1_COINAGE_1(0x14)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x14, 0x01, 0x40, 0x00, "Off"                    },
	{0x14, 0x01, 0x40, 0x40, "On"                     },
		
	// Dip B
	CPS1_DIFFICULTY_1(0x15)

	{0   , 0xfe, 0   , 4   , "Difficulty 2"           },
	{0x15, 0x01, 0x18, 0x00, "Easy"                   },
	{0x15, 0x01, 0x18, 0x08, "Normal"                 },
	{0x15, 0x01, 0x18, 0x10, "Hard"                   },
	{0x15, 0x01, 0x18, 0x18, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x15, 0x01, 0x60, 0x00, "100k"                   },
	{0x15, 0x01, 0x60, 0x20, "200k"                   },
	{0x15, 0x01, 0x60, 0x40, "100k and every 200k"    },
	{0x15, 0x01, 0x60, 0x60, "None"                   },
	
	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x16, 0x01, 0x03, 0x03, "1"                      },
	{0x16, 0x01, 0x03, 0x00, "2"                      },
	{0x16, 0x01, 0x03, 0x01, "3"                      },
	{0x16, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x16, 0x01, 0x04, 0x00, "Off"                    },
	{0x16, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x16, 0x01, 0x08, 0x00, "Off"                    },
	{0x16, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x10, 0x00, "Off"                    },
	{0x16, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x16, 0x01, 0x20, 0x00, "Off"                    },
	{0x16, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x16, 0x01, 0x40, 0x00, "Off"                    },
	{0x16, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x16, 0x01, 0x80, 0x00, "Game"                   },
	{0x16, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Ffight)

static struct BurnDIPInfo FfightaeDIPList[]=
{
	DIP_OFFSET(0x1d)

	// Defaults
	{0x00, 0xff, 0xff, 0x00, NULL                     },
	{0x01, 0xff, 0xff, 0x0b, NULL                     },
	{0x02, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x00)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x00, 0x01, 0x40, 0x00, "Off"                    },
	{0x00, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x01)

	{0   , 0xfe, 0   , 4   , "Difficulty 2"           },
	{0x01, 0x01, 0x18, 0x00, "Easy"                   },
	{0x01, 0x01, 0x18, 0x08, "Normal"                 },
	{0x01, 0x01, 0x18, 0x10, "Hard"                   },
	{0x01, 0x01, 0x18, 0x18, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x01, 0x01, 0x60, 0x00, "100k"                   },
	{0x01, 0x01, 0x60, 0x20, "200k"                   },
	{0x01, 0x01, 0x60, 0x40, "100k and every 200k"    },
	{0x01, 0x01, 0x60, 0x60, "None"                   },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x02, 0x01, 0x03, 0x03, "1"                      },
	{0x02, 0x01, 0x03, 0x00, "2"                      },
	{0x02, 0x01, 0x03, 0x01, "3"                      },
	{0x02, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x02, 0x01, 0x04, 0x00, "Off"                    },
	{0x02, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x02, 0x01, 0x08, 0x00, "Off"                    },
	{0x02, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x02, 0x01, 0x10, 0x00, "Off"                    },
	{0x02, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x02, 0x01, 0x20, 0x00, "Off"                    },
	{0x02, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x02, 0x01, 0x40, 0x00, "Off"                    },
	{0x02, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x02, 0x01, 0x80, 0x00, "Game"                   },
	{0x02, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Ffightae)

static struct BurnDIPInfo ForgottnDIPList[]=
{
	// Defaults
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	{0x17, 0xff, 0xff, 0x03, NULL                     },
	{0x18, 0xff, 0xff, 0x00, NULL                     },
	{0x19, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x16)

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x16, 0x01, 0x40, 0x40, "Off"                    },
	{0x16, 0x01, 0x40, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x80, 0x00, "Off"                    },
	{0x16, 0x01, 0x80, 0x80, "On"                     },
	
	// Dip B
	CPS1_DIFFICULTY_1(0x17)
	
	{0   , 0xfe, 0   , 2   , "Service Mode"           },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x80, 0x00, "Off"                    },
	{0x17, 0x01, 0x80, 0x80, "On"                     },

	// Fake dip for "turn"-input inversion
	{0   , 0xfe, 0   , 2   , "Invert \"Turn\" inputs" },
	{0x19, 0x01, 0x80, 0x00, "Off"                    },
	{0x19, 0x01, 0x80, 0x80, "On"                     },
};

STDDIPINFO(Forgottn)

static struct BurnDIPInfo ForgottnjDIPList[]=
{
	// Defaults
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	{0x17, 0xff, 0xff, 0x00, NULL                     },
	{0x18, 0xff, 0xff, 0x00, NULL                     },
	{0x19, 0xff, 0xff, 0x00, NULL                     },

	// Dip A
	{0   , 0xfe, 0   , 2   , "Service Mode"           },
	{0x16, 0x01, 0x80, 0x00, "Off"                    },
	{0x16, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	CPS1_COINAGE_1(0x17)

	{0   , 0xfe, 0   , 2   , "Speed Up"               },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x17, 0x01, 0x80, 0x00, "Off"                    },
	{0x17, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Slow Motion"            },
	{0x18, 0x01, 0x01, 0x00, "Off"                    },
	{0x18, 0x01, 0x01, 0x01, "On"                     },

	{0   , 0xfe, 0   , 2   , "Slowest Motion"         },
	{0x18, 0x01, 0x02, 0x00, "Off"                    },
	{0x18, 0x01, 0x02, 0x02, "On"                     },

	{0   , 0xfe, 0   , 3   , "Freeze"                 },
	{0x18, 0x01, 0xc0, 0x00, "Off"                    },
	{0x18, 0x01, 0xc0, 0x40, "On"                     },
	{0x18, 0x01, 0xc0, 0xc0, "On with Alignment Character" },

	// Fake dip for "turn"-input inversion
	{0   , 0xfe, 0   , 2   , "Invert \"Turn\" inputs" },
	{0x19, 0x01, 0x80, 0x00, "Off"                    },
	{0x19, 0x01, 0x80, 0x80, "On"                     },
};

STDDIPINFO(Forgottnj)

static struct BurnDIPInfo GanbareDIPList[]=
{
	// Defaults
	{0x0a, 0xff, 0xff, 0x00, NULL                     },
	{0x0b, 0xff, 0xff, 0x00, NULL                     },
	{0x0c, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 2   , "Medal Setup"            },
	{0x0a, 0x01, 0x01, 0x00, "1 Medal 1 Credit"       },
	{0x0a, 0x01, 0x01, 0x01, "Don't use"              },
	
	{0   , 0xfe, 0   , 2   , "Coin Setup"             },
	{0x0a, 0x01, 0x02, 0x00, "100 Yen"                },
	{0x0a, 0x01, 0x02, 0x02, "10 Yen"                 },
	
	{0   , 0xfe, 0   , 8   , "Change Setup"           },
	{0x0a, 0x01, 0x1c, 0x18, "12"                     },
	{0x0a, 0x01, 0x1c, 0x1c, "11"                     },
	{0x0a, 0x01, 0x1c, 0x00, "10"                     },
	{0x0a, 0x01, 0x1c, 0x04, "8"                      },
	{0x0a, 0x01, 0x1c, 0x08, "7"                      },
	{0x0a, 0x01, 0x1c, 0x0c, "6"                      },
	{0x0a, 0x01, 0x1c, 0x10, "5"                      },
	{0x0a, 0x01, 0x1c, 0x14, "No change"              },
	
	{0   , 0xfe, 0   , 4   , "10 Yen Setup"           },
	{0x0a, 0x01, 0x60, 0x00, "1 Coin  1 Credit"       },
	{0x0a, 0x01, 0x60, 0x20, "2 Coins 1 Credit"       },
	{0x0a, 0x01, 0x60, 0x40, "3 Coins 1 Credit"       },
	{0x0a, 0x01, 0x60, 0x60, "Don't use"              },
	
	{0   , 0xfe, 0   , 2   , "Payout Setup"           },
	{0x0a, 0x01, 0x80, 0x00, "Credit Mode"            },
	{0x0a, 0x01, 0x80, 0x80, "Payout Mode"            },
	
	// Dip B
	{0   , 0xfe, 0   , 8   , "Payout Rate Setup"      },
	{0x0b, 0x01, 0x07, 0x06, "90%"                    },
	{0x0b, 0x01, 0x07, 0x07, "85%"                    },
	{0x0b, 0x01, 0x07, 0x00, "80%"                    },
	{0x0b, 0x01, 0x07, 0x01, "75%"                    },
	{0x0b, 0x01, 0x07, 0x02, "70%"                    },
	{0x0b, 0x01, 0x07, 0x03, "65%"                    },
	{0x0b, 0x01, 0x07, 0x04, "60%"                    },
	{0x0b, 0x01, 0x07, 0x05, "55%"                    },
	
	// Dip C
	{0   , 0xfe, 0   , 4   , "Demo Sound Setup"       },
	{0x0c, 0x01, 0x03, 0x00, "Always"                 },
	{0x0c, 0x01, 0x03, 0x01, "Every second sound"     },
	{0x0c, 0x01, 0x03, 0x02, "Every third sound"      },
	{0x0c, 0x01, 0x03, 0x03, "Off"                    },
	
	{0   , 0xfe, 0   , 2   , "Clear RAM"              },
	{0x0c, 0x01, 0x40, 0x00, "No"                     },
	{0x0C, 0x01, 0x40, 0x40, "Yes"                    },
	
	{0   , 0xfe, 0   , 2   , "Test Mode Display"      },
	{0x0c, 0x01, 0x80, 0x00, "Off"                    },
	{0x0C, 0x01, 0x80, 0x80, "On"                     },	
};

STDDIPINFO(Ganbare)

static struct BurnDIPInfo GhoulsDIPList[]=
{
	// Defaults
	{0x12, 0xff, 0xff, 0x00, NULL                     },
	{0x13, 0xff, 0xff, 0x00, NULL                     },
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x00, NULL                     }, // fake

	// Dip A
	CPS1_COINAGE_1(0x12)

	{0   , 0xfe, 0   , 3   , "Cabinet"                },
	{0x12, 0x01, 0xc0, 0x00, "Upright 1 Player"       },
	{0x12, 0x01, 0xc0, 0x40, "Upright 2 Players"      },
	{0x12, 0x01, 0xc0, 0xc0, "Cocktail"               },

	// Dip B
	CPS1_DIFFICULTY_2(0x13)

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x13, 0x01, 0x30, 0x10, "10k, 30k and every 30k" },
	{0x13, 0x01, 0x30, 0x20, "20k, 50k and every 70k" },
	{0x13, 0x01, 0x30, 0x00, "30k, 60k and every 70k" },
	{0x13, 0x01, 0x30, 0x30, "40k, 70k and every 80k" },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x14, 0x01, 0x03, 0x00, "3"                      },
	{0x14, 0x01, 0x03, 0x01, "4"                      },
	{0x14, 0x01, 0x03, 0x02, "5"                      },
	{0x14, 0x01, 0x03, 0x03, "6"                      },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x14, 0x01, 0x10, 0x00, "Off"                    },
	{0x14, 0x01, 0x10, 0x10, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Demo Sounds"            },
	{0x14, 0x01, 0x20, 0x20, "Off"                    },
	{0x14, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x14, 0x01, 0x40, 0x40, "No"                     },
	{0x14, 0x01, 0x40, 0x00, "Yes"                    },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x14, 0x01, 0x80, 0x00, "Game"                   },
	{0x14, 0x01, 0x80, 0x80, "Test"                   },

	{0   , 0xfe, 0   , 2   , "4-Way Mode"             },
	{0x15, 0x01, 0x01, 0x00, "Normal"                 },
	{0x15, 0x01, 0x01, 0x01, "Alternate"              },
};

STDDIPINFO(Ghouls)

static struct BurnDIPInfo GhoulsuDIPList[]=
{
	// Defaults
	{0x12, 0xff, 0xff, 0x00, NULL                     },
	{0x13, 0xff, 0xff, 0x00, NULL                     },
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x00, NULL                     }, // fake

	// Dip A
	CPS1_COINAGE_1(0x12)

	{0   , 0xfe, 0   , 3   , "Cabinet"                },
	{0x12, 0x01, 0xc0, 0x00, "Upright 1 Player"       },
	{0x12, 0x01, 0xc0, 0x40, "Upright 2 Players"      },
	{0x12, 0x01, 0xc0, 0xc0, "Cocktail"               },
	
	// Dip B
	CPS1_DIFFICULTY_2(0x13)

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x13, 0x01, 0x30, 0x10, "10k, 30k and every 30k" },
	{0x13, 0x01, 0x30, 0x20, "20k, 50k and every 70k" },
	{0x13, 0x01, 0x30, 0x00, "30k, 60k and every 70k" },
	{0x13, 0x01, 0x30, 0x30, "40k, 70k and every 80k" },
	
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x13, 0x01, 0x80, 0x00, "Off"                    },
	{0x13, 0x01, 0x80, 0x80, "On"                     },
	
	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x14, 0x01, 0x03, 0x03, "2"                      },
	{0x14, 0x01, 0x03, 0x00, "3"                      },
	{0x14, 0x01, 0x03, 0x01, "4"                      },
	{0x14, 0x01, 0x03, 0x02, "5"                      },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x14, 0x01, 0x10, 0x00, "Off"                    },
	{0x14, 0x01, 0x10, 0x10, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Demo Sounds"            },
	{0x14, 0x01, 0x20, 0x20, "Off"                    },
	{0x14, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x14, 0x01, 0x40, 0x40, "No"                     },
	{0x14, 0x01, 0x40, 0x00, "Yes"                    },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x14, 0x01, 0x80, 0x00, "Game"                   },
	{0x14, 0x01, 0x80, 0x80, "Test"                   },

	{0   , 0xfe, 0   , 2   , "4-Way Mode"             },
	{0x15, 0x01, 0x01, 0x00, "Normal"                 },
	{0x15, 0x01, 0x01, 0x01, "Alternate"              },
};

STDDIPINFO(Ghoulsu)

static struct BurnDIPInfo DaimakaiDIPList[]=
{
	// Defaults
	{0x12, 0xff, 0xff, 0x00, NULL                     },
	{0x13, 0xff, 0xff, 0x00, NULL                     },
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x00, NULL                     }, // fake

	// Dip A
	CPS1_COINAGE_1(0x12)

	{0   , 0xfe, 0   , 3   , "Cabinet"                },
	{0x12, 0x01, 0xc0, 0x00, "Upright 1 Player"       },
	{0x12, 0x01, 0xc0, 0x40, "Upright 2 Players"      },
	{0x12, 0x01, 0xc0, 0xc0, "Cocktail"               },

	// Dip B
	CPS1_DIFFICULTY_2(0x13)

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x13, 0x01, 0x30, 0x10, "10k, 30k and every 30k" },
	{0x13, 0x01, 0x30, 0x20, "20k, 50k and every 70k" },
	{0x13, 0x01, 0x30, 0x00, "30k, 60k and every 70k" },
	{0x13, 0x01, 0x30, 0x30, "40k, 70k and every 80k" },
	
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x13, 0x01, 0x80, 0x00, "Off"                    },
	{0x13, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x14, 0x01, 0x03, 0x00, "3"                      },
	{0x14, 0x01, 0x03, 0x01, "4"                      },
	{0x14, 0x01, 0x03, 0x02, "5"                      },
	{0x14, 0x01, 0x03, 0x03, "6"                      },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x14, 0x01, 0x10, 0x00, "Off"                    },
	{0x14, 0x01, 0x10, 0x10, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Demo Sounds"            },
	{0x14, 0x01, 0x20, 0x20, "Off"                    },
	{0x14, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x14, 0x01, 0x40, 0x40, "Off"                    },
	{0x14, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x14, 0x01, 0x80, 0x00, "Game"                   },
	{0x14, 0x01, 0x80, 0x80, "Test"                   },

	{0   , 0xfe, 0   , 2   , "4-Way Mode"             },
	{0x15, 0x01, 0x01, 0x00, "Normal"                 },
	{0x15, 0x01, 0x01, 0x01, "Alternate"              },
};

STDDIPINFO(Daimakai)

static struct BurnDIPInfo GulunpaDIPList[]=
{
	{0x12, 0xf0, 0xff, 0xff, "-dip offset-"     	  },
	{0x00, 0xff, 0xff, 0x00, NULL					  },
	{0x01, 0xff, 0xff, 0x00, NULL					  },
	{0x02, 0xff, 0xff, 0x00, NULL					  },

	// Dip A
	CPS1_COINAGE_1(0x00)

	// Dip B
	CPS1_DIFFICULTY_1(0x01)

	// Dip C
	{0   , 0xfe, 0   ,    2, "Freeze"				  },
	{0x02, 0x01, 0x08, 0x00, "Off"					  },
	{0x02, 0x01, 0x08, 0x08, "On"					  },

	{0   , 0xfe, 0   ,    2, "Flip Screen"			  },
	{0x02, 0x01, 0x10, 0x00, "Off"					  },
	{0x02, 0x01, 0x10, 0x10, "On"					  },

	{0   , 0xfe, 0   ,    2, "Demo Sounds"			  },
	{0x02, 0x01, 0x20, 0x00, "Off"					  },
	{0x02, 0x01, 0x20, 0x20, "On"					  },

	{0   , 0xfe, 0   ,    2, "Game Mode"			  },
	{0x02, 0x01, 0x80, 0x00, "Game"					  },
	{0x02, 0x01, 0x80, 0x80, "Test"					  },
};

STDDIPINFO(Gulunpa)

static struct BurnDIPInfo KnightsDIPList[]=
{
	DIP_OFFSET(0x1b)

	// Defaults
	{0x00, 0xff, 0xff, 0x00, NULL                     },
	{0x01, 0xff, 0xff, 0x03, NULL                     },
	{0x02, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_2(0x00)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x00, 0x01, 0x40, 0x00, "Off"                    },
	{0x00, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Enemys Attack Frequency"},
	{0x01, 0x01, 0x07, 0x00, "1 (Easiest)"            },
	{0x01, 0x01, 0x07, 0x01, "2"                      },
	{0x01, 0x01, 0x07, 0x02, "3"                      },
	{0x01, 0x01, 0x07, 0x03, "4 (Normal)"             },
	{0x01, 0x01, 0x07, 0x04, "5"                      },
	{0x01, 0x01, 0x07, 0x05, "6"                      },
	{0x01, 0x01, 0x07, 0x06, "7"                      },
	{0x01, 0x01, 0x07, 0x07, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 8   , "Enemys Attack Power"    },
	{0x01, 0x01, 0x38, 0x38, "1 (Easiest)"            },
	{0x01, 0x01, 0x38, 0x30, "2"                      },
	{0x01, 0x01, 0x38, 0x28, "3"                      },
	{0x01, 0x01, 0x38, 0x00, "4 (Normal)"             },
	{0x01, 0x01, 0x38, 0x08, "5"                      },
	{0x01, 0x01, 0x38, 0x10, "6"                      },
	{0x01, 0x01, 0x38, 0x18, "7"                      },
	{0x01, 0x01, 0x38, 0x20, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x01, 0x01, 0x40, 0x40, "1"                      },
	{0x01, 0x01, 0x40, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x01, 0x01, 0x80, 0x80, "2P"                     },
	{0x01, 0x01, 0x80, 0x00, "3P"                     },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x02, 0x01, 0x03, 0x03, "1"                      },
	{0x02, 0x01, 0x03, 0x00, "2"                      },
	{0x02, 0x01, 0x03, 0x01, "3"                      },
	{0x02, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x02, 0x01, 0x04, 0x00, "Off"                    },
	{0x02, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x02, 0x01, 0x08, 0x00, "Off"                    },
	{0x02, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x02, 0x01, 0x10, 0x00, "Off"                    },
	{0x02, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x02, 0x01, 0x20, 0x00, "Off"                    },
	{0x02, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x02, 0x01, 0x40, 0x00, "Off"                    },
	{0x02, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x02, 0x01, 0x80, 0x00, "Game"                   },
	{0x02, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Knights)

static struct BurnDIPInfo KnightshDIPList[]=
{
	DIP_OFFSET(0x1d)

	// Defaults
	{0x00, 0xff, 0xff, 0x00, NULL                     },
	{0x01, 0xff, 0xff, 0x03, NULL                     },
	{0x02, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_2(0x00)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x00, 0x01, 0x40, 0x00, "Off"                    },
	{0x00, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Enemys Attack Frequency"},
	{0x01, 0x01, 0x07, 0x00, "1 (Easiest)"            },
	{0x01, 0x01, 0x07, 0x01, "2"                      },
	{0x01, 0x01, 0x07, 0x02, "3"                      },
	{0x01, 0x01, 0x07, 0x03, "4 (Normal)"             },
	{0x01, 0x01, 0x07, 0x04, "5"                      },
	{0x01, 0x01, 0x07, 0x05, "6"                      },
	{0x01, 0x01, 0x07, 0x06, "7"                      },
	{0x01, 0x01, 0x07, 0x07, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 8   , "Enemys Attack Power"    },
	{0x01, 0x01, 0x38, 0x38, "1 (Easiest)"            },
	{0x01, 0x01, 0x38, 0x30, "2"                      },
	{0x01, 0x01, 0x38, 0x28, "3"                      },
	{0x01, 0x01, 0x38, 0x00, "4 (Normal)"             },
	{0x01, 0x01, 0x38, 0x08, "5"                      },
	{0x01, 0x01, 0x38, 0x10, "6"                      },
	{0x01, 0x01, 0x38, 0x18, "7"                      },
	{0x01, 0x01, 0x38, 0x20, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x01, 0x01, 0x40, 0x40, "1"                      },
	{0x01, 0x01, 0x40, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x01, 0x01, 0x80, 0x80, "2P"                     },
	{0x01, 0x01, 0x80, 0x00, "3P"                     },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x02, 0x01, 0x03, 0x03, "1"                      },
	{0x02, 0x01, 0x03, 0x00, "2"                      },
	{0x02, 0x01, 0x03, 0x01, "3"                      },
	{0x02, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x02, 0x01, 0x04, 0x00, "Off"                    },
	{0x02, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x02, 0x01, 0x08, 0x00, "Off"                    },
	{0x02, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x02, 0x01, 0x10, 0x00, "Off"                    },
	{0x02, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x02, 0x01, 0x20, 0x00, "Off"                    },
	{0x02, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x02, 0x01, 0x40, 0x00, "Off"                    },
	{0x02, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x02, 0x01, 0x80, 0x00, "Game"                   },
	{0x02, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Knightsh)

static struct BurnDIPInfo KodDIPList[]=
{
	DIP_OFFSET(0x1b)

	// Defaults
	{0x00, 0xff, 0xff, 0x00, NULL                     },
	{0x01, 0xff, 0xff, 0x03, NULL                     },
	{0x02, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x00)

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x00, 0x01, 0x08, 0x08, "1"                      },
	{0x00, 0x01, 0x08, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x00, 0x01, 0x10, 0x10, "2 Players"              },
	{0x00, 0x01, 0x10, 0x00, "3 Players"              },

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x00, 0x01, 0x40, 0x00, "Off"                    },
	{0x00, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x01)

	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x01, 0x01, 0x38, 0x08, "1"                      },
	{0x01, 0x01, 0x38, 0x00, "2"                      },
	{0x01, 0x01, 0x38, 0x10, "3"                      },
	{0x01, 0x01, 0x38, 0x18, "4"                      },
	{0x01, 0x01, 0x38, 0x20, "5"                      },
	{0x01, 0x01, 0x38, 0x28, "6"                      },
	{0x01, 0x01, 0x38, 0x30, "7"                      },
	{0x01, 0x01, 0x38, 0x38, "8"                      },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x01, 0x01, 0xc0, 0x40, "80k and every 400k"     },
	{0x01, 0x01, 0xc0, 0x80, "160k and every 450k"    },
	{0x01, 0x01, 0xc0, 0x00, "200k and every 450k"    },
	{0x01, 0x01, 0xc0, 0xc0, "None"                   },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x02, 0x01, 0x04, 0x00, "Off"                    },
	{0x02, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x02, 0x01, 0x08, 0x00, "Off"                    },
	{0x02, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x02, 0x01, 0x10, 0x00, "Off"                    },
	{0x02, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x02, 0x01, 0x20, 0x00, "Off"                    },
	{0x02, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x02, 0x01, 0x40, 0x00, "Off"                    },
	{0x02, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x02, 0x01, 0x80, 0x00, "Game"                   },
	{0x02, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Kod)

static struct BurnDIPInfo KodhDIPList[]=
{
	DIP_OFFSET(0x1d)

	// Defaults
	{0x00, 0xff, 0xff, 0x00, NULL                     },
	{0x01, 0xff, 0xff, 0x03, NULL                     },
	{0x02, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_2(0x00)

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x00, 0x01, 0x08, 0x08, "1"                      },
	{0x00, 0x01, 0x08, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x00, 0x01, 0x10, 0x10, "2 Players"              },
	{0x00, 0x01, 0x10, 0x00, "3 Players"              },

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x00, 0x01, 0x40, 0x00, "Off"                    },
	{0x00, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x01)

	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x01, 0x01, 0x38, 0x08, "1"                      },
	{0x01, 0x01, 0x38, 0x00, "2"                      },
	{0x01, 0x01, 0x38, 0x10, "3"                      },
	{0x01, 0x01, 0x38, 0x18, "4"                      },
	{0x01, 0x01, 0x38, 0x20, "5"                      },
	{0x01, 0x01, 0x38, 0x28, "6"                      },
	{0x01, 0x01, 0x38, 0x30, "7"                      },
	{0x01, 0x01, 0x38, 0x38, "8"                      },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x01, 0x01, 0xc0, 0x40, "80k and every 400k"     },
	{0x01, 0x01, 0xc0, 0x80, "160k and every 450k"    },
	{0x01, 0x01, 0xc0, 0x00, "200k and every 450k"    },
	{0x01, 0x01, 0xc0, 0xc0, "None"                   },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x02, 0x01, 0x04, 0x00, "Off"                    },
	{0x02, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x02, 0x01, 0x08, 0x00, "Off"                    },
	{0x02, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x02, 0x01, 0x10, 0x00, "Off"                    },
	{0x02, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x02, 0x01, 0x20, 0x00, "Off"                    },
	{0x02, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x02, 0x01, 0x40, 0x00, "Off"                    },
	{0x02, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x02, 0x01, 0x80, 0x00, "Game"                   },
	{0x02, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Kodh)

static struct BurnDIPInfo Kodr1DIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x1b)

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x1b, 0x01, 0x08, 0x08, "1"                      },
	{0x1b, 0x01, 0x08, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x1b, 0x01, 0x10, 0x10, "2 Players"              },
	{0x1b, 0x01, 0x10, 0x00, "3 Players"              },

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1c, 0x01, 0x38, 0x08, "1"                      },
	{0x1c, 0x01, 0x38, 0x00, "2"                      },
	{0x1c, 0x01, 0x38, 0x10, "3"                      },
	{0x1c, 0x01, 0x38, 0x18, "4"                      },
	{0x1c, 0x01, 0x38, 0x20, "5"                      },
	{0x1c, 0x01, 0x38, 0x28, "6"                      },
	{0x1c, 0x01, 0x38, 0x30, "7"                      },
	{0x1c, 0x01, 0x38, 0x38, "8"                      },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x1c, 0x01, 0xc0, 0x40, "80k and every 400k"     },
	{0x1c, 0x01, 0xc0, 0x00, "160k and every 450k"    },
	{0x1c, 0x01, 0xc0, 0x80, "200k and every 450k"    },
	{0x1c, 0x01, 0xc0, 0xc0, "None"                   },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Kodr1)

static struct BurnDIPInfo MegamanDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x01, NULL                     },
	{0x17, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 19  , "Coinage"                },
	{0x15, 0x01, 0x1f, 0x00, "1 Coin  1 Credit"       },
	{0x15, 0x01, 0x1f, 0x01, "1 Coin  2 Credits"      },
	{0x15, 0x01, 0x1f, 0x02, "1 Coin  3 Credits"      },
	{0x15, 0x01, 0x1f, 0x03, "1 Coin  4 Credits"      },
	{0x15, 0x01, 0x1f, 0x04, "1 Coin  5 Credits"      },
	{0x15, 0x01, 0x1f, 0x05, "1 Coin  6 Credits"      },
	{0x15, 0x01, 0x1f, 0x06, "1 Coin  7 Credits"      },
	{0x15, 0x01, 0x1f, 0x07, "1 Coin  8 Credits"      },
	{0x15, 0x01, 0x1f, 0x08, "1 Coin  9 Credits"      },
	{0x15, 0x01, 0x1f, 0x09, "2 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0a, "3 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0b, "4 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0c, "5 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0d, "6 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0e, "7 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0f, "8 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x10, "9 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x11, "2 Coins Start 1 Coin Continue"},
	{0x15, 0x01, 0x1f, 0x12, "Free Play"              },

	{0   , 0xfe, 0   , 4   , "Coin Slots"             },
	{0x15, 0x01, 0x60, 0x40, "1, Common"              },
	{0x15, 0x01, 0x60, 0x00, "2, Common"              },
	{0x15, 0x01, 0x60, 0x20, "2, Individual"          },

	// Dip B
	{0   , 0xfe, 0   , 4   , "Difficulty"             },
	{0x16, 0x01, 0x03, 0x00, "Easy"                   },
	{0x16, 0x01, 0x03, 0x01, "Normal"                 },
	{0x16, 0x01, 0x03, 0x02, "Hard"                   },
	{0x16, 0x01, 0x03, 0x03, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Time"                   },
	{0x16, 0x01, 0x0c, 0x00, "100"                    },
	{0x16, 0x01, 0x0c, 0x04, "90"                     },
	{0x16, 0x01, 0x0c, 0x08, "70"                     },
	{0x16, 0x01, 0x0c, 0x0c, "60"                     },

	{0   , 0xfe, 0   , 2   , "Voice"                  },
	{0x16, 0x01, 0x40, 0x40, "Off"                    },
	{0x16, 0x01, 0x40, 0x00, "On"                     },
	
	// Dip C
	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x17, 0x01, 0x01, 0x00, "Off"                    },
	{0x17, 0x01, 0x01, 0x01, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x17, 0x01, 0x02, 0x02, "Off"                    },
	{0x17, 0x01, 0x02, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x04, 0x04, "Off"                    },
	{0x17, 0x01, 0x04, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },	
};

STDDIPINFO(Megaman)

static struct BurnDIPInfo RockmanjDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x01, NULL                     },
	{0x17, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 19  , "Coinage"                },
	{0x15, 0x01, 0x1f, 0x00, "1 Coin  1 Credit"       },
	{0x15, 0x01, 0x1f, 0x01, "1 Coin  2 Credits"      },
	{0x15, 0x01, 0x1f, 0x02, "1 Coin  3 Credits"      },
	{0x15, 0x01, 0x1f, 0x03, "1 Coin  4 Credits"      },
	{0x15, 0x01, 0x1f, 0x04, "1 Coin  5 Credits"      },
	{0x15, 0x01, 0x1f, 0x05, "1 Coin  6 Credits"      },
	{0x15, 0x01, 0x1f, 0x06, "1 Coin  7 Credits"      },
	{0x15, 0x01, 0x1f, 0x07, "1 Coin  8 Credits"      },
	{0x15, 0x01, 0x1f, 0x08, "1 Coin  9 Credits"      },
	{0x15, 0x01, 0x1f, 0x09, "2 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0a, "3 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0b, "4 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0c, "5 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0d, "6 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0e, "7 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x0f, "8 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x10, "9 Coins 1 Credit"       },
	{0x15, 0x01, 0x1f, 0x11, "2 Coins Start 1 Coin Continue"},
	{0x15, 0x01, 0x1f, 0x12, "Free Play"              },

	{0   , 0xfe, 0   , 3   , "Coin Slots"             },
	{0x15, 0x01, 0x60, 0x40, "1, Common"              },
	{0x15, 0x01, 0x60, 0x00, "2, Common"              },
	{0x15, 0x01, 0x60, 0x20, "2, Individual"          },

	// Dip B
	{0   , 0xfe, 0   , 4   , "Difficulty"             },
	{0x16, 0x01, 0x03, 0x00, "Easy"                   },
	{0x16, 0x01, 0x03, 0x01, "Normal"                 },
	{0x16, 0x01, 0x03, 0x02, "Hard"                   },
	{0x16, 0x01, 0x03, 0x03, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Time"                   },
	{0x16, 0x01, 0x0c, 0x00, "100"                    },
	{0x16, 0x01, 0x0c, 0x04, "90"                     },
	{0x16, 0x01, 0x0c, 0x08, "70"                     },
	{0x16, 0x01, 0x0c, 0x0c, "60"                     },
	
	// Dip C
	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x17, 0x01, 0x01, 0x00, "Off"                    },
	{0x17, 0x01, 0x01, 0x01, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x17, 0x01, 0x02, 0x02, "Off"                    },
	{0x17, 0x01, 0x02, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x04, 0x04, "Off"                    },
	{0x17, 0x01, 0x04, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },	
};

STDDIPINFO(Rockmanj)

static struct BurnDIPInfo MercsDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x1c, 0x01, 0x08, 0x08, "1"                      },
	{0x1c, 0x01, 0x08, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x1c, 0x01, 0x10, 0x10, "2 Player"               },
	{0x1c, 0x01, 0x10, 0x00, "3 Player"               },
	
	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Service Mode"           },
	{0x1d, 0x01, 0x80, 0x00, "Off"                    },
	{0x1d, 0x01, 0x80, 0x80, "On"                     },
};

STDDIPINFO(Mercs)

static struct BurnDIPInfo MswordDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x03, NULL                     },
	{0x17, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x15)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x15, 0x01, 0x40, 0x00, "Off"                    },
	{0x15, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Players vitality consumption"},
	{0x16, 0x01, 0x07, 0x00, "1 (Easiest)"            },
	{0x16, 0x01, 0x07, 0x01, "2"                      },
	{0x16, 0x01, 0x07, 0x02, "3"                      },
	{0x16, 0x01, 0x07, 0x03, "4 (Normal)"             },
	{0x16, 0x01, 0x07, 0x04, "5"                      },
	{0x16, 0x01, 0x07, 0x05, "6"                      },
	{0x16, 0x01, 0x07, 0x06, "7"                      },
	{0x16, 0x01, 0x07, 0x07, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 8   , "Level 2"                },
	{0x16, 0x01, 0x38, 0x18, "1 (Easiest)"            },
	{0x16, 0x01, 0x38, 0x10, "2"                      },
	{0x16, 0x01, 0x38, 0x08, "3"                      },
	{0x16, 0x01, 0x38, 0x00, "4 (Normal)"             },
	{0x16, 0x01, 0x38, 0x20, "5"                      },
	{0x16, 0x01, 0x38, 0x28, "6"                      },
	{0x16, 0x01, 0x38, 0x30, "7"                      },
	{0x16, 0x01, 0x38, 0x38, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 2   , "Stage Select"           },
	{0x16, 0x01, 0x40, 0x00, "Off"                    },
	{0x16, 0x01, 0x40, 0x40, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Vitality"               },
	{0x17, 0x01, 0x03, 0x03, "1"                      },
	{0x17, 0x01, 0x03, 0x00, "2"                      },
	{0x17, 0x01, 0x03, 0x01, "3 (2 when continue)"    },
	{0x17, 0x01, 0x03, 0x02, "4 (3 when continue)"    },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x17, 0x01, 0x04, 0x00, "Off"                    },
	{0x17, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x08, 0x00, "Off"                    },
	{0x17, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x17, 0x01, 0x20, 0x00, "Off"                    },
	{0x17, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Msword)

static struct BurnDIPInfo MtwinsDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x03, NULL                     },
	{0x17, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x15)

	// Dip B
	CPS1_DIFFICULTY_1(0x16)

	{0   , 0xfe, 0   , 5   , "Lives (Reserve)"        },
	{0x16, 0x01, 0x38, 0x00, "0"                      },
	{0x16, 0x01, 0x38, 0x28, "1"                      },
	{0x16, 0x01, 0x38, 0x20, "2"                      },
	{0x16, 0x01, 0x38, 0x30, "3"                      },
	{0x16, 0x01, 0x38, 0x38, "4"                      },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x17, 0x01, 0x04, 0x00, "Off"                    },
	{0x17, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x08, 0x00, "Off"                    },
	{0x17, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sounds"            },
	{0x17, 0x01, 0x20, 0x00, "Off"                    },
	{0x17, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Mtwins)

static struct BurnDIPInfo NemoDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x03, NULL                     },
	{0x17, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x15)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x15, 0x01, 0x40, 0x00, "Off"                    },
	{0x15, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x16)

	{0   , 0xfe, 0   , 3   , "Life Bar"               },
	{0x16, 0x01, 0x18, 0x18, "Minimum"                },
	{0x16, 0x01, 0x18, 0x00, "Medium"                 },
	{0x16, 0x01, 0x18, 0x10, "Maximum"                },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x17, 0x01, 0x03, 0x01, "1"                      },
	{0x17, 0x01, 0x03, 0x00, "2"                      },
	{0x17, 0x01, 0x03, 0x02, "3"                      },
	{0x17, 0x01, 0x03, 0x03, "4"                      },
	
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x17, 0x01, 0x04, 0x00, "Off"                    },
	{0x17, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x08, 0x00, "Off"                    },
	{0x17, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x17, 0x01, 0x20, 0x00, "Off"                    },
	{0x17, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Nemo)

static struct BurnDIPInfo Pang3DIPList[]=
{
	// Defaults
	{0x13, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x13, 0x01, 0x08, 0x00, "Off"                    },
	{0x13, 0x01, 0x08, 0x08, "On"                     },
};

STDDIPINFO(Pang3)

static struct BurnDIPInfo Pang3b4DIPList[]=
{
	// Defaults
	{0x11, 0xff, 0xff, 0x00, NULL                     },
	{0x12, 0xff, 0xff, 0x43, NULL                     },
	{0x13, 0xff, 0xff, 0x40, NULL                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Game level"             },
	{0x12, 0x01, 0x07, 0x00, "Easy 3"                 },
	{0x12, 0x01, 0x07, 0x01, "Easy 2"                 },
	{0x12, 0x01, 0x07, 0x02, "Easy 1"                 },
	{0x12, 0x01, 0x07, 0x03, "Normal"                 },
	{0x12, 0x01, 0x07, 0x04, "Hard 1"                 },
	{0x12, 0x01, 0x07, 0x05, "Hard 2"                 },
	{0x12, 0x01, 0x07, 0x06, "Hard 3"                 },
	{0x12, 0x01, 0x07, 0x07, "Hard 4"                 },

	{0   , 0xfe, 0   , 4   , "Player"                 },
	{0x12, 0x01, 0x18, 0x10, "1"                      },
	{0x12, 0x01, 0x18, 0x08, "2"                      },
	{0x12, 0x01, 0x18, 0x00, "3"                      },
	{0x12, 0x01, 0x18, 0x18, "4"                      },

	{0   , 0xfe, 0   , 4   , "Extend"                 },
	{0x12, 0x01, 0x60, 0x60, "30K, 250K, 1M, 3M, 7M"  },
	{0x12, 0x01, 0x60, 0x40, "80K, 500k, 2M, 5M, 10M" },
	{0x12, 0x01, 0x60, 0x20, "250K, 1M, 3M, 7M, 15M"  },
	{0x12, 0x01, 0x60, 0x00, "Not extend"             },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x12, 0x01, 0x80, 0x00, "Off"                    },
	{0x12, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x13, 0x01, 0x10, 0x00, "Off"                    },
	{0x13, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x13, 0x01, 0x20, 0x00, "Off"                    },
	{0x13, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x13, 0x01, 0x40, 0x00, "Off"                    },
	{0x13, 0x01, 0x40, 0x40, "On"                     },
};

STDDIPINFO(Pang3b4)

static struct BurnDIPInfo PnickjDIPList[]=
{
	// Defaults
	{0x13, 0xff, 0xff, 0x00, NULL                     },
	{0x14, 0xff, 0xff, 0x03, NULL                     },
	{0x15, 0xff, 0xff, 0x20, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x13)

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x13, 0x01, 0x08, 0x00, "1"                      },
	{0x13, 0x01, 0x08, 0x08, "2"                      },
	
	// Dip B
	CPS1_DIFFICULTY_1(0x14)

	{0   , 0xfe, 0   , 4   , "Vs. Play Mode"          },
	{0x14, 0x01, 0xc0, 0x00, "1 Game  Match"          },
	{0x14, 0x01, 0xc0, 0x40, "3 Games Match"          },
	{0x14, 0x01, 0xc0, 0x80, "5 Games Match"          },
	{0x14, 0x01, 0xc0, 0xc0, "7 Games Match"          },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x15, 0x01, 0x08, 0x00, "Off"                    },
	{0x15, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x15, 0x01, 0x10, 0x00, "Off"                    },
	{0x15, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x15, 0x01, 0x20, 0x00, "Off"                    },
	{0x15, 0x01, 0x20, 0x20, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x15, 0x01, 0x80, 0x00, "Game"                   },
	{0x15, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Pnickj)

static struct BurnDIPInfo PokonyanDIPList[]=
{
	// Defaults
	{0x14, 0xff, 0xff, 0x41, NULL                     },
	{0x15, 0xff, 0xff, 0x04, NULL                     },
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	
	{0   , 0xfe, 0   , 4   , "Coinage"                },
	{0x14, 0x01, 0x03, 0x03, "4 Coins 1 Credit"       },
	{0x14, 0x01, 0x03, 0x02, "3 Coins 1 Credit"       },
	{0x14, 0x01, 0x03, 0x00, "2 Coins 1 Credit"       },
	{0x14, 0x01, 0x03, 0x01, "1 Coin  1 Credit"       },
	
	{0   , 0xfe, 0   , 2   , "Controls"               },
	{0x14, 0x01, 0x40, 0x40, "Digital"                },
	{0x14, 0x01, 0x40, 0x00, "Wheel"                  }, // I assume this enables the wheel as the directions don't work (and the left/right input check just flashes) - not worked out to hook the wheel up yet though
	
	// Dip B
	{0   , 0xfe, 0   , 4   , "Demo Sounds"            },
	{0x15, 0x01, 0x03, 0x03, "Off"                    },
	{0x15, 0x01, 0x03, 0x02, "Every 4"                },
	{0x15, 0x01, 0x03, 0x01, "Every 2"                },
	{0x15, 0x01, 0x03, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Prize Mode"             },
	{0x15, 0x01, 0x04, 0x04, "Not Used"               },
	{0x15, 0x01, 0x04, 0x00, "Used"                   },
	
	{0   , 0xfe, 0   , 2   , "Credit Mode"            },
	{0x15, 0x01, 0x08, 0x00, "Off"                    },
	{0x15, 0x01, 0x08, 0x08, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Max Stage"              },
	{0x15, 0x01, 0x10, 0x10, "2"                      },
	{0x15, 0x01, 0x10, 0x00, "3"                      },
	
	{0   , 0xfe, 0   , 2   , "Card Check"             },
	{0x15, 0x01, 0x20, 0x00, "Off"                    },
	{0x15, 0x01, 0x20, 0x20, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Unknown"                },
	{0x15, 0x01, 0x80, 0x80, "1.0 sec"                },
	{0x15, 0x01, 0x80, 0x00, "1.2 sec"                },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Body Check"             },
	{0x16, 0x01, 0x02, 0x00, "Off"                    },
	{0x16, 0x01, 0x02, 0x02, "On"                     },

	{0   , 0xfe, 0   , 2   , "Screen Stop"            },
	{0x16, 0x01, 0x08, 0x00, "Off"                    },
	{0x16, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x10, 0x00, "Off"                    },
	{0x16, 0x01, 0x10, 0x10, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x16, 0x01, 0x80, 0x00, "Game"                   },
	{0x16, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Pokonyan)

// This dips struct is from Pokonyon and incorrect for Hkittymp(!)
// (Game Mode works at least)
static struct BurnDIPInfo HkittympDIPList[]=
{
	DIP_OFFSET(0x08)
	// Defaults
	{0x00, 0xff, 0xff, 0x01, NULL                     },
	{0x01, 0xff, 0xff, 0x04, NULL                     },
	{0x02, 0xff, 0xff, 0x00, NULL                     },

	{0   , 0xfe, 0   , 4   , "Coinage"                },
	{0x00, 0x01, 0x03, 0x03, "4 Coins 1 Credit"       },
	{0x00, 0x01, 0x03, 0x02, "3 Coins 1 Credit"       },
	{0x00, 0x01, 0x03, 0x00, "2 Coins 1 Credit"       },
	{0x00, 0x01, 0x03, 0x01, "1 Coin  1 Credit"       },

	// Dip B
	{0   , 0xfe, 0   , 4   , "Demo Sounds"            },
	{0x01, 0x01, 0x03, 0x03, "Off"                    },
	{0x01, 0x01, 0x03, 0x02, "Every 4"                },
	{0x01, 0x01, 0x03, 0x01, "Every 2"                },
	{0x01, 0x01, 0x03, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Prize Mode"             },
	{0x01, 0x01, 0x04, 0x04, "Not Used"               },
	{0x01, 0x01, 0x04, 0x00, "Used"                   },

	{0   , 0xfe, 0   , 2   , "Credit Mode"            },
	{0x01, 0x01, 0x08, 0x00, "Off"                    },
	{0x01, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Max Stage"              },
	{0x01, 0x01, 0x10, 0x10, "2"                      },
	{0x01, 0x01, 0x10, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Card Check"             },
	{0x01, 0x01, 0x20, 0x00, "Off"                    },
	{0x01, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Unknown"                },
	{0x01, 0x01, 0x80, 0x80, "1.0 sec"                },
	{0x01, 0x01, 0x80, 0x00, "1.2 sec"                },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Body Check"             },
	{0x02, 0x01, 0x02, 0x00, "Off"                    },
	{0x02, 0x01, 0x02, 0x02, "On"                     },

	{0   , 0xfe, 0   , 2   , "Screen Stop"            },
	{0x02, 0x01, 0x08, 0x00, "Off"                    },
	{0x02, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x02, 0x01, 0x10, 0x00, "Off"                    },
	{0x02, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x02, 0x01, 0x80, 0x00, "Game"                   },
	{0x02, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Hkittymp)

static struct BurnDIPInfo PunisherDIPList[]=
{
	// Defaults
	{0x13, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x13, 0x01, 0x08, 0x00, "Off"                    },
	{0x13, 0x01, 0x08, 0x08, "On"                     },
};

STDDIPINFO(Punisher)

static struct BurnDIPInfo PunisherbzDIPList[]=
{
	// Defaults
 	{0x15, 0xff, 0xff, 0x10, NULL                     },
 	{0x16, 0xff, 0xff, 0x6B, NULL                     },

	// Dip A
	CPS1_COINAGE_2(0x15)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x15, 0x01, 0x08, 0x00, "Off"                    },
	{0x15, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x15, 0x01, 0x30, 0x00, "1"                      },
	{0x15, 0x01, 0x30, 0x10, "2"                      },
	{0x15, 0x01, 0x30, 0x20, "3"                      },
	{0x15, 0x01, 0x30, 0x30, "4"                      },

	{0   , 0xfe, 0   , 2   , "Sound"                  },
	{0x15, 0x01, 0x40, 0x00, "Q Sound"                },
	{0x15, 0x01, 0x40, 0x40, "Monaural"               },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x15, 0x01, 0x80, 0x00, "Off"                    },
	{0x15, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Difficulty"             },
	{0x16, 0x01, 0x07, 0x00, "0 (Easiest)"            },
	{0x16, 0x01, 0x07, 0x01, "1"                      },
	{0x16, 0x01, 0x07, 0x02, "2"                      },
	{0x16, 0x01, 0x07, 0x03, "3 (Normal)"             },
	{0x16, 0x01, 0x07, 0x04, "4"                      },
	{0x16, 0x01, 0x07, 0x05, "5"                      },
	{0x16, 0x01, 0x07, 0x06, "6"                      },
	{0x16, 0x01, 0x07, 0x07, "7 (Hardest)"            },

	{0   , 0xfe, 0   , 4   , "Extend"                 },
	{0x16, 0x01, 0x18, 0x00, "800000"                 },
	{0x16, 0x01, 0x18, 0x08, "1800000"                },
	{0x16, 0x01, 0x18, 0x10, "2800000"                },
	{0x16, 0x01, 0x18, 0x18, "No Extend"              },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x16, 0x01, 0x20, 0x00, "Off"                    },
	{0x16, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x16, 0x01, 0x40, 0x00, "Off"                    },
	{0x16, 0x01, 0x40, 0x40, "On"                     },
};

STDDIPINFO(Punisherbz)

static struct BurnDIPInfo QadDIPList[]=
{
	// Defaults
	{0x0f, 0xff, 0xff, 0x00, NULL                     },
	{0x10, 0xff, 0xff, 0x0b, NULL                     },
	{0x11, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x0f)
	
	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x0f, 0x01, 0x40, 0x00, "Off"                    },
	{0x0f, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 5   , "Difficulty"             },
	{0x10, 0x01, 0x07, 0x01, "Easiest"                },
	{0x10, 0x01, 0x07, 0x02, "Easy"                   },
	{0x10, 0x01, 0x07, 0x03, "Normal"                 },
	{0x10, 0x01, 0x07, 0x04, "Hard"                   },
	{0x10, 0x01, 0x07, 0x05, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Wisdom of Enemy"        },
	{0x10, 0x01, 0x18, 0x00, "Easy"                   },
	{0x10, 0x01, 0x18, 0x08, "Normal"                 },
	{0x10, 0x01, 0x18, 0x10, "Hard"                   },
	{0x10, 0x01, 0x18, 0x18, "Hardest"                },

	{0   , 0xfe, 0   , 5   , "Lives"                  },
	{0x10, 0x01, 0xe0, 0x80, "1"                      },
	{0x10, 0x01, 0xe0, 0x60, "2"                      },
	{0x10, 0x01, 0xe0, 0x40, "3"                      },
	{0x10, 0x01, 0xe0, 0x20, "4"                      },
	{0x10, 0x01, 0xe0, 0x00, "5"                      },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x11, 0x01, 0x04, 0x00, "Off"                    },
	{0x11, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x11, 0x01, 0x08, 0x00, "Off"                    },
	{0x11, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x11, 0x01, 0x10, 0x00, "Off"                    },
	{0x11, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x11, 0x01, 0x20, 0x20, "Off"                    },
	{0x11, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x11, 0x01, 0x40, 0x40, "Off"                    },
	{0x11, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x11, 0x01, 0x80, 0x00, "Game"                   },
	{0x11, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Qad)

static struct BurnDIPInfo QadjrDIPList[]=
{
	// Defaults
	{0x0f, 0xff, 0xff, 0x00, NULL                     },
	{0x10, 0xff, 0xff, 0x00, NULL                     },
	{0x11, 0xff, 0xff, 0x20, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x0f)
	
	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x0f, 0x01, 0x40, 0x00, "Off"                    },
	{0x0f, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 5   , "Difficulty"             },
	{0x10, 0x01, 0x07, 0x00, "0"                      },
	{0x10, 0x01, 0x07, 0x01, "1"                      },
	{0x10, 0x01, 0x07, 0x02, "2"                      },
	{0x10, 0x01, 0x07, 0x03, "3"                      },
	{0x10, 0x01, 0x07, 0x04, "4"                      },

	{0   , 0xfe, 0   , 3   , "Lives"                  },
	{0x10, 0x01, 0xe0, 0x40, "1"                      },
	{0x10, 0x01, 0xe0, 0x20, "2"                      },
	{0x10, 0x01, 0xe0, 0x00, "3"                      },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x11, 0x01, 0x04, 0x00, "Off"                    },
	{0x11, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x11, 0x01, 0x08, 0x00, "Off"                    },
	{0x11, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x11, 0x01, 0x10, 0x00, "Off"                    },
	{0x11, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x11, 0x01, 0x20, 0x00, "Off"                    },
	{0x11, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x11, 0x01, 0x40, 0x40, "Off"                    },
	{0x11, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x11, 0x01, 0x80, 0x00, "Game"                   },
	{0x11, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Qadjr)

static struct BurnDIPInfo Qtono2jDIPList[]=
{
	// Defaults
	{0x0f, 0xff, 0xff, 0x00, NULL                     },
	{0x10, 0xff, 0xff, 0x03, NULL                     },
	{0x11, 0xff, 0xff, 0x20, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x0f)
	
	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x0f, 0x01, 0x40, 0x00, "Off"                    },
	{0x0f, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x10)

	{0   , 0xfe, 0   , 5   , "Lives"                  },
	{0x10, 0x01, 0xe0, 0x80, "1"                      },
	{0x10, 0x01, 0xe0, 0x60, "2"                      },
	{0x10, 0x01, 0xe0, 0x00, "3"                      },
	{0x10, 0x01, 0xe0, 0x40, "4"                      },
	{0x10, 0x01, 0xe0, 0x20, "5"                      },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Infinite Lives"         },
	{0x11, 0x01, 0x02, 0x00, "Off"                    },
	{0x11, 0x01, 0x02, 0x02, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x11, 0x01, 0x04, 0x00, "Off"                    },
	{0x11, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x11, 0x01, 0x08, 0x00, "Off"                    },
	{0x11, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x11, 0x01, 0x10, 0x00, "Off"                    },
	{0x11, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x11, 0x01, 0x20, 0x00, "Off"                    },
	{0x11, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x11, 0x01, 0x40, 0x40, "Off"                    },
	{0x11, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x11, 0x01, 0x80, 0x00, "Game"                   },
	{0x11, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Qtono2j)

static struct BurnDIPInfo Sf2DIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2)

static struct BurnDIPInfo Sf2mixDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },
	
    {0   , 0xfe, 0   , 2   , "Portuguese Win Quotes"  },
	{0x1b, 0x01, 0x80, 0x00, "Off"                    },
	{0x1b, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)
	{0   , 0xfe, 0   , 2   , "Complete Mode"           },
	{0x1c, 0x01, 0x08, 0x00, "Off"                    },
	{0x1c, 0x01, 0x08, 0x08, "On"                     },
	
	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2mix)

static struct BurnDIPInfo Sf2accp2DIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x80, NULL                     },
	{0x1c, 0xff, 0xff, 0x1a, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Shot Type" },
	{0x1b, 0x01, 0x80, 0x00, "Directional shots curve up or down" },
	{0x1b, 0x01, 0x80, 0x80, "3D wave shots slow-med-fast" },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)
	
	{0   , 0xfe, 0   , 8   , "Game speed"             },
	{0x1c, 0x01, 0x38, 0x00, "Extremely fast"         },
	{0x1c, 0x01, 0x38, 0x08, "Very fast"              },
	{0x1c, 0x01, 0x38, 0x10, "Fast"                   },
	{0x1c, 0x01, 0x38, 0x18, "Normal"                 },
	{0x1c, 0x01, 0x38, 0x20, "Slow"                   },
	{0x1c, 0x01, 0x38, 0x28, "Very slow"              },
	{0x1c, 0x01, 0x38, 0x38, "Slowest"                },
	{0x1c, 0x01, 0x38, 0x30, "Speed test mode"        },
	
	{0   , 0xfe, 0   , 2   , "Guile special rapid multiple shots" },
	{0x1c, 0x01, 0x40, 0x00, "Off"                    },
	{0x1c, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Blank special rapid multiple shots" },
	{0x1c, 0x01, 0x80, 0x00, "Off"                    },
	{0x1c, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Ken special rapid multiple shots" },
	{0x1d, 0x01, 0x01, 0x00, "Off"                    },
	{0x1d, 0x01, 0x01, 0x01, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Ryu special rapid multiple shots" },
	{0x1d, 0x01, 0x02, 0x00, "Off"                    },
	{0x1d, 0x01, 0x02, 0x02, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2accp2)

static struct BurnDIPInfo Sf2amfDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)
	
	{0   , 0xfe, 0   , 2   , "Turbo Mode"             },
	{0x1c, 0x01, 0x38, 0x00, "Off"                    },
	{0x1c, 0x01, 0x38, 0x38, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2amf)

static struct BurnDIPInfo Sf2jDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	{0   , 0xfe, 0   , 2   , "2 Players Game"         },
	{0x1c, 0x01, 0x08, 0x00, "2 Credits/Winner Continue"   },
	{0x1c, 0x01, 0x08, 0x08, "1 Credit/No Continue"	  },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2j)

static struct BurnDIPInfo Sf2cejDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	{0   , 0xfe, 0   , 2   , "2 Players Game"         },
	{0x1c, 0x01, 0x08, 0x00, "1 Credit/No Continue"   },
	{0x1c, 0x01, 0x08, 0x08, "2 Credits/Winner Continue"	},

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2cej)

static struct BurnDIPInfo Sf2bhhDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	// Dip C
	{0   , 0xfe, 0   , 2   , "Speed"                  },
	{0x1d, 0x01, 0x01, 0x00, "Normal"                 },
	{0x1d, 0x01, 0x01, 0x01, "Fast"                   },
	
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2bhh)

static struct BurnDIPInfo Sf2levelDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)
	
	{0   , 0xfe, 0   , 16  , "Level"                  },
	{0x1c, 0x01, 0xf0, 0x00, "0"                      },
	{0x1c, 0x01, 0xf0, 0x10, "1"                      },
	{0x1c, 0x01, 0xf0, 0x20, "2"                      },
	{0x1c, 0x01, 0xf0, 0x30, "3"                      },
	{0x1c, 0x01, 0xf0, 0x40, "4"                      },
	{0x1c, 0x01, 0xf0, 0x50, "5"                      },
	{0x1c, 0x01, 0xf0, 0x60, "6"                      },
	{0x1c, 0x01, 0xf0, 0x70, "7"                      },
	{0x1c, 0x01, 0xf0, 0x80, "8"                      },
	{0x1c, 0x01, 0xf0, 0x90, "9"                      },
	{0x1c, 0x01, 0xf0, 0xa0, "10"                     },
	{0x1c, 0x01, 0xf0, 0xb0, "11"                     },
	{0x1c, 0x01, 0xf0, 0xc0, "12"                     },
	{0x1c, 0x01, 0xf0, 0xd0, "13"                     },
	{0x1c, 0x01, 0xf0, 0xe0, "14"                     },
	{0x1c, 0x01, 0xf0, 0xf0, "15"                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2level)

static struct BurnDIPInfo Sf2megaDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x13, NULL                     }, // 0x10 high to boot
	{0x1d, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
        
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2mega)

static struct BurnDIPInfo SlammastDIPList[]=
{
	// Defaults
	{0x27, 0xff, 0xff, 0x08, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x27, 0x01, 0x08, 0x08, "Off"                    },
	{0x27, 0x01, 0x08, 0x00, "On"                     },
};

STDDIPINFO(Slammast)

static struct BurnDIPInfo StriderDIPList[]=
{
	// Defaults
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x14)

	{0   , 0xfe, 0   , 3   , "Cabinet"                },
	{0x14, 0x01, 0xc0, 0x00, "Upright 1P"             },
	{0x14, 0x01, 0xc0, 0x40, "Upright 2P"             },
	{0x14, 0x01, 0xc0, 0xc0, "Cocktail"               },

	// Dip B
	CPS1_DIFFICULTY_2(0x15)

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x15, 0x01, 0x30, 0x00, "20k, 40k and every 60k" },
	{0x15, 0x01, 0x30, 0x10, "30k, 50k and every 70k" },
	{0x15, 0x01, 0x30, 0x20, "20k & 60k only"         },
	{0x15, 0x01, 0x30, 0x30, "30k & 60k only"         },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x16, 0x01, 0x03, 0x03, "2"                      },
	{0x16, 0x01, 0x03, 0x00, "3"                      },
	{0x16, 0x01, 0x03, 0x01, "4"                      },
	{0x16, 0x01, 0x03, 0x02, "5"                      },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x16, 0x01, 0x04, 0x00, "Off"                    },
	{0x16, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x16, 0x01, 0x08, 0x00, "Off"                    },
	{0x16, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x10, 0x00, "Off"                    },
	{0x16, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Sound"                  },
	{0x16, 0x01, 0x20, 0x20, "Off"                    },
	{0x16, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x16, 0x01, 0x40, 0x40, "Off"                    },
	{0x16, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x16, 0x01, 0x80, 0x00, "Game"                   },
	{0x16, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Strider)

static struct BurnDIPInfo StrideruaDIPList[]=
{
	// Defaults
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x14)

	{0   , 0xfe, 0   , 3   , "Cabinet"                },
	{0x14, 0x01, 0xc0, 0x00, "Upright 1P"             },
	{0x14, 0x01, 0xc0, 0x40, "Upright 2P"             },
	{0x14, 0x01, 0xc0, 0xc0, "Cocktail"               },

	// Dip B
	CPS1_DIFFICULTY_2(0x15)
	
	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x15, 0x01, 0x08, 0x00, "Off"                    },
	{0x15, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x15, 0x01, 0x30, 0x00, "20k, 40k and every 60k" },
	{0x15, 0x01, 0x30, 0x10, "30k, 50k and every 70k" },
	{0x15, 0x01, 0x30, 0x20, "20k & 60k only"         },
	{0x15, 0x01, 0x30, 0x30, "30k & 60k only"         },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x16, 0x01, 0x03, 0x03, "2"                      },
	{0x16, 0x01, 0x03, 0x00, "3"                      },
	{0x16, 0x01, 0x03, 0x01, "4"                      },
	{0x16, 0x01, 0x03, 0x02, "5"                      },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x16, 0x01, 0x04, 0x00, "Off"                    },
	{0x16, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x16, 0x01, 0x08, 0x00, "Off"                    },
	{0x16, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x10, 0x00, "Off"                    },
	{0x16, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Sound"                  },
	{0x16, 0x01, 0x20, 0x20, "Off"                    },
	{0x16, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x16, 0x01, 0x40, 0x40, "Off"                    },
	{0x16, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x16, 0x01, 0x80, 0x00, "Game"                   },
	{0x16, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Striderua)

static struct BurnDIPInfo UnsquadDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x03, NULL                     },
	{0x17, 0xff, 0xff, 0x60, NULL                     },

	// Dip A
        CPS1_COINAGE_3(0x15)

	// Dip B
	CPS1_DIFFICULTY_1(0x16)
	
	{0   , 0xfe, 0   , 4   , "Damage"                 },
	{0x16, 0x01, 0x18, 0x08, "Small"                  },
	{0x16, 0x01, 0x18, 0x00, "Normal"                 },
	{0x16, 0x01, 0x18, 0x10, "Big"                    },
	{0x16, 0x01, 0x18, 0x18, "Biggest"                },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x17, 0x01, 0x04, 0x00, "Off"                    },
	{0x17, 0x01, 0x04, 0x04, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x08, 0x00, "Off"                    },
	{0x17, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x17, 0x01, 0x20, 0x00, "Off"                    },
	{0x17, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Unsquad)

static struct BurnDIPInfo VarthDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x0b, NULL                     },
	{0x17, 0xff, 0xff, 0x60, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x15)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x15, 0x01, 0x40, 0x00, "Off"                    },
	{0x15, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x16)

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x16, 0x01, 0x18, 0x00, "600k and every 1400k"   },
	{0x16, 0x01, 0x18, 0x08, "600k, 2000k and every 4500k"},
	{0x16, 0x01, 0x18, 0x10, "1200k, 3500k"           },
	{0x16, 0x01, 0x18, 0x18, "2000k only"             },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x17, 0x01, 0x03, 0x01, "1"                      },
	{0x17, 0x01, 0x03, 0x02, "2"                      },
	{0x17, 0x01, 0x03, 0x00, "3"                      },
	{0x17, 0x01, 0x03, 0x03, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x17, 0x01, 0x04, 0x00, "Off"                    },
	{0x17, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x17, 0x01, 0x08, 0x00, "Off"                    },
	{0x17, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x17, 0x01, 0x20, 0x00, "Off"                    },
	{0x17, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x00, "Off"                    },
	{0x17, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Varth)

static struct BurnDIPInfo WillowDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                     },
	{0x16, 0xff, 0xff, 0x00, NULL                     },
	{0x17, 0xff, 0xff, 0x00, NULL                     },

	// Dip A
        CPS1_COINAGE_3(0x15)

    {0   , 0xfe, 0   , 3   , "Cabinet"                },
	{0x15, 0x01, 0xc0, 0x00, "Upright 1P"             },
	{0x15, 0x01, 0xc0, 0x40, "Upright 2P"             },
	{0x15, 0x01, 0xc0, 0xc0, "Cocktail"               },
	
	// Dip B
	CPS1_DIFFICULTY_2(0x16)

	{0   , 0xfe, 0   , 4   , "Nando Speed"            },
	{0x16, 0x01, 0x18, 0x08, "Slow"                   },
	{0x16, 0x01, 0x18, 0x00, "Normal"                 },	
	{0x16, 0x01, 0x18, 0x10, "Fast"                   },
	{0x16, 0x01, 0x18, 0x18, "Very Fast"              },

	{0   , 0xfe, 0   , 2   , "Stage Magic Continue"   },
	{0x16, 0x01, 0x80, 0x00, "Off"                    },
	{0x16, 0x01, 0x80, 0x80, "On"                     },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x17, 0x01, 0x03, 0x01, "1"                      },
	{0x17, 0x01, 0x03, 0x00, "2"                      },
	{0x17, 0x01, 0x03, 0x02, "3"                      },
	{0x17, 0x01, 0x03, 0x03, "4"                      },

	{0   , 0xfe, 0   , 4   , "Vitality"               },
	{0x17, 0x01, 0x0c, 0x0c, "2"                      },
	{0x17, 0x01, 0x0c, 0x00, "3"                      },
	{0x17, 0x01, 0x0c, 0x04, "4"                      },
	{0x17, 0x01, 0x0c, 0x08, "5"                      },

	{0   , 0xfe, 0   , 2   , "Screen"                 },
	{0x17, 0x01, 0x10, 0x00, "Off"                    },
	{0x17, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sounds"            },
	{0x17, 0x01, 0x20, 0x20, "Off"                    },
	{0x17, 0x01, 0x20, 0x00, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x17, 0x01, 0x40, 0x40, "Off"                    },
	{0x17, 0x01, 0x40, 0x00, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x17, 0x01, 0x80, 0x00, "Game"                   },
	{0x17, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Willow)

static struct BurnDIPInfo WofDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1b, 0x01, 0x08, 0x08, "Off"                    },
	{0x1b, 0x01, 0x08, 0x00, "On"                     },
};

STDDIPINFO(Wof)

static struct BurnDIPInfo WofhfhDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x13, NULL                     },
	{0x1d, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 4   , "Coin A"                 },
	{0x1b, 0x01, 0x03, 0x00, "1 Coin 1 Credit"        },
	{0x1b, 0x01, 0x03, 0x01, "1 Coin 2 Credits"       },
	{0x1b, 0x01, 0x03, 0x02, "1 Coin 3 Credits"       },
	{0x1b, 0x01, 0x03, 0x03, "1 Coin 4 Credits"       },
	
	// Dip B
	{0   , 0xfe, 0   , 8   , "Difficulty"             },
	{0x1c, 0x01, 0x07, 0x00, "Extra Easy"             },
	{0x1c, 0x01, 0x07, 0x01, "Very Easy"              },
	{0x1c, 0x01, 0x07, 0x02, "Easy"                   },
	{0x1c, 0x01, 0x07, 0x03, "Normal"                 },
	{0x1c, 0x01, 0x07, 0x04, "Hard"                   },
	{0x1c, 0x01, 0x07, 0x05, "Very Hard"              },
	{0x1c, 0x01, 0x07, 0x06, "Extra Hard"             },
	{0x1c, 0x01, 0x07, 0x07, "Hardest"                },
	
	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1c, 0x01, 0x70, 0x70, "Start 4 Continue 5"     },
	{0x1c, 0x01, 0x70, 0x60, "Start 3 Continue 4"     },
	{0x1c, 0x01, 0x70, 0x50, "Start 2 Continue 3"     },
	{0x1c, 0x01, 0x70, 0x40, "Start 1 Continue 2"     },
	{0x1c, 0x01, 0x70, 0x30, "Start 4 Continue 4"     },
	{0x1c, 0x01, 0x70, 0x20, "Start 3 Continue 3"     },
	{0x1c, 0x01, 0x70, 0x10, "Start 2 Continue 2"     },
	{0x1c, 0x01, 0x70, 0x00, "Start 1 Continue 1"     },
	
	// Dip C
	{0   , 0xfe, 0   , 3   , "Coin Slots"             },
	{0x1d, 0x01, 0x03, 0x02, "2 Players 1 Shooter"    },
	{0x1d, 0x01, 0x03, 0x01, "3 Players 1 Shooter"    },
	{0x1d, 0x01, 0x03, 0x00, "3 Players 3 Shooters"   },
};

STDDIPINFO(Wofhfh)

static struct BurnDIPInfo WofhDIPList[]=
{
	// Defaults
	{0x1a, 0xff, 0xff, 0x00, NULL                     },
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x13, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 3   , "Coin Slots"             },
	{0x1a, 0x01, 0x03, 0x02, "2 Players 1 Shooter"    },
	{0x1a, 0x01, 0x03, 0x01, "3 Players 1 Shooter"    },
	{0x1a, 0x01, 0x03, 0x00, "3 Players 3 Shooters"   },
	
	// Dip B
	{0   , 0xfe, 0   , 4   , "Coinage"                },
	{0x1b, 0x01, 0x03, 0x00, "1 Coin 1 Credit"        },
	{0x1b, 0x01, 0x03, 0x01, "1 Coin 2 Credits"       },
	{0x1b, 0x01, 0x03, 0x02, "1 Coin 3 Credits"       },
	{0x1b, 0x01, 0x03, 0x03, "1 Coin 4 Credits"       },
	
	// Dip C
	{0   , 0xfe, 0   , 8   , "Difficulty"             },
	{0x1c, 0x01, 0x07, 0x00, "Extra Easy"             },
	{0x1c, 0x01, 0x07, 0x01, "Very Easy"              },
	{0x1c, 0x01, 0x07, 0x02, "Easy"                   },
	{0x1c, 0x01, 0x07, 0x03, "Normal"                 },
	{0x1c, 0x01, 0x07, 0x04, "Hard"                   },
	{0x1c, 0x01, 0x07, 0x05, "Very Hard"              },
	{0x1c, 0x01, 0x07, 0x06, "Extra Hard"             },
	{0x1c, 0x01, 0x07, 0x07, "Hardest"                },
	
	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1c, 0x01, 0x70, 0x70, "Start 4 Continue 5"     },
	{0x1c, 0x01, 0x70, 0x60, "Start 3 Continue 4"     },
	{0x1c, 0x01, 0x70, 0x50, "Start 2 Continue 3"     },
	{0x1c, 0x01, 0x70, 0x40, "Start 1 Continue 2"     },
	{0x1c, 0x01, 0x70, 0x30, "Start 4 Continue 4"     },
	{0x1c, 0x01, 0x70, 0x20, "Start 3 Continue 3"     },
	{0x1c, 0x01, 0x70, 0x10, "Start 2 Continue 2"     },
	{0x1c, 0x01, 0x70, 0x00, "Start 1 Continue 1"     },
};

STDDIPINFO(Wofh)

static struct BurnDIPInfo Wof3jsDIPList[]=
{
	// Defaults
	{0x1c, 0xff, 0xff, 0x00, NULL                     },
	{0x1d, 0xff, 0xff, 0x00, NULL                     },
	{0x1e, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 4   , "Coinage"                },
	{0x1c, 0x01, 0x03, 0x01, "2 Coins 1 Credit"       },
	{0x1c, 0x01, 0x03, 0x00, "1 Coin  1 Credit"       },	
	{0x1c, 0x01, 0x03, 0x02, "1 Coin  2 Credits"      },
	{0x1c, 0x01, 0x03, 0x03, "1 Coin  3 Credits"      },
	
	// Dip B
	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x1d, 0x01, 0x01, 0x01, "3 Players 1 Shooter"    },
	{0x1d, 0x01, 0x01, 0x00, "3 Players 3 Shooters"   },
	
	// Dip C
	// not sure about difficulty (no way to test)
	{0   , 0xfe, 0   , 8   , "Difficulty"             },
	{0x1e, 0x01, 0x07, 0x00, "Value 0"                },
	{0x1e, 0x01, 0x07, 0x01, "Value 1"                },
	{0x1e, 0x01, 0x07, 0x02, "Value 2"                },
	{0x1e, 0x01, 0x07, 0x03, "Value 3"                },
	{0x1e, 0x01, 0x07, 0x04, "Value 4"                },
	{0x1e, 0x01, 0x07, 0x05, "Value 5"                },
	{0x1e, 0x01, 0x07, 0x06, "Value 6"                },
	{0x1e, 0x01, 0x07, 0x07, "Value 7"                },
	
	{0   , 0xfe, 0   , 5   , "Lives"                  },
	{0x1e, 0x01, 0x70, 0x40, "Start 1 Continue 1"     },
	{0x1e, 0x01, 0x70, 0x30, "Start 4 Continue 3"     },
	{0x1e, 0x01, 0x70, 0x20, "Start 4 Continue 4"     },
	{0x1e, 0x01, 0x70, 0x10, "Start 3 Continue 3"     },
	{0x1e, 0x01, 0x70, 0x00, "Start 2 Continue 2"     },
};

STDDIPINFO(Wof3js)

static struct BurnDIPInfo Wof3jsaDIPList[]=
{
	// Defaults
	{0x1c, 0xff, 0xff, 0x00, NULL                     },
	{0x1d, 0xff, 0xff, 0x00, NULL                     },
	{0x1e, 0xff, 0xff, 0x13, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 3   , "Coin Slots"             },
	{0x1c, 0x01, 0x03, 0x02, "2 Players 1 Shooter"    },
	{0x1c, 0x01, 0x03, 0x01, "3 Players 1 Shooter"    },
	{0x1c, 0x01, 0x03, 0x00, "3 Players 3 Shooters"   },
	
	// Dip B
	{0   , 0xfe, 0   , 4   , "Coinage"                },
	{0x1d, 0x01, 0x03, 0x00, "1 Coin 1 Credit"        },
	{0x1d, 0x01, 0x03, 0x01, "1 Coin 2 Credits"       },
	{0x1d, 0x01, 0x03, 0x02, "1 Coin 3 Credits"       },
	{0x1d, 0x01, 0x03, 0x03, "1 Coin 4 Credits"       },
	
	// Dip C
	{0   , 0xfe, 0   , 8   , "Difficulty"             },
	{0x1e, 0x01, 0x07, 0x00, "Extra Easy"             },
	{0x1e, 0x01, 0x07, 0x01, "Very Easy"              },
	{0x1e, 0x01, 0x07, 0x02, "Easy"                   },
	{0x1e, 0x01, 0x07, 0x03, "Normal"                 },
	{0x1e, 0x01, 0x07, 0x04, "Hard"                   },
	{0x1e, 0x01, 0x07, 0x05, "Very Hard"              },
	{0x1e, 0x01, 0x07, 0x06, "Extra Hard"             },
	{0x1e, 0x01, 0x07, 0x07, "Hardest"                },
	
	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1e, 0x01, 0x70, 0x70, "Start 4 Continue 5"     },
	{0x1e, 0x01, 0x70, 0x60, "Start 3 Continue 4"     },
	{0x1e, 0x01, 0x70, 0x50, "Start 2 Continue 3"     },
	{0x1e, 0x01, 0x70, 0x40, "Start 1 Continue 2"     },
	{0x1e, 0x01, 0x70, 0x30, "Start 4 Continue 4"     },
	{0x1e, 0x01, 0x70, 0x20, "Start 3 Continue 3"     },
	{0x1e, 0x01, 0x70, 0x10, "Start 2 Continue 2"     },
	{0x1e, 0x01, 0x70, 0x00, "Start 1 Continue 1"     },
};

STDDIPINFO(Wof3jsa)

static struct BurnDIPInfo Wof3sjDIPList[]=
{
	// Defaults
	{0x1a, 0xff, 0xff, 0x00, NULL                     },
	{0x1b, 0xff, 0xff, 0x13, NULL                     },
	{0x1c, 0xff, 0xff, 0x00, NULL                     },
	
	// Dip A
	{0   , 0xfe, 0   , 4   , "Coinage"                },
	{0x1a, 0x01, 0x03, 0x00, "1 Coin 1 Credit"        },
	{0x1a, 0x01, 0x03, 0x01, "1 Coin 2 Credits"       },
	{0x1a, 0x01, 0x03, 0x02, "1 Coin 3 Credits"       },
	{0x1a, 0x01, 0x03, 0x03, "1 Coin 4 Credits"       },
	
	// Dip B
	{0   , 0xfe, 0   , 8   , "Difficulty"             },
	{0x1b, 0x01, 0x07, 0x00, "Extra Easy"             },
	{0x1b, 0x01, 0x07, 0x01, "Very Easy"              },
	{0x1b, 0x01, 0x07, 0x02, "Easy"                   },
	{0x1b, 0x01, 0x07, 0x03, "Normal"                 },
	{0x1b, 0x01, 0x07, 0x04, "Hard"                   },
	{0x1b, 0x01, 0x07, 0x05, "Very Hard"              },
	{0x1b, 0x01, 0x07, 0x06, "Extra Hard"             },
	{0x1b, 0x01, 0x07, 0x07, "Hardest"                },
	
	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1b, 0x01, 0x70, 0x70, "Start 4 Continue 5"     },
	{0x1b, 0x01, 0x70, 0x60, "Start 3 Continue 4"     },
	{0x1b, 0x01, 0x70, 0x50, "Start 2 Continue 3"     },
	{0x1b, 0x01, 0x70, 0x40, "Start 1 Continue 2"     },
	{0x1b, 0x01, 0x70, 0x30, "Start 4 Continue 4"     },
	{0x1b, 0x01, 0x70, 0x20, "Start 3 Continue 3"     },
	{0x1b, 0x01, 0x70, 0x10, "Start 2 Continue 2"     },
	{0x1b, 0x01, 0x70, 0x00, "Start 1 Continue 1"     },
	
	// Dip C
	{0   , 0xfe, 0   , 3   , "Coin Slots"             },
	{0x1c, 0x01, 0x03, 0x02, "2 Players 1 Shooter"    },
	{0x1c, 0x01, 0x03, 0x01, "3 Players 1 Shooter"    },
	{0x1c, 0x01, 0x03, 0x00, "3 Players 3 Shooters"   },
};

STDDIPINFO(Wof3sj)

static struct BurnDIPInfo WofablaDIPList[] =
{
	// Defaults
	{0x1a, 0xff, 0xff, 0x00, NULL                     },
	{0x1b, 0xff, 0xff, 0x13, NULL                     },
	{0x1c, 0xff, 0xff, 0x20, NULL                     },

	// Dip A
	{0   , 0xfe, 0   , 10   , "Coinage"                },
	{0x1a, 0x01, 0x09, 0x00, "1 Coin 1 Credit"        },
	{0x1a, 0x01, 0x09, 0x01, "1 Coin 2 Credits"       },
	{0x1a, 0x01, 0x09, 0x02, "1 Coin 3 Credits"       },
	{0x1a, 0x01, 0x09, 0x03, "1 Coin 4 Credits"       },
	{0x1a, 0x01, 0x09, 0x04, "1 Coin 6 Credits"       },
	{0x1a, 0x01, 0x09, 0x05, "2 Coin 1 Credits"       },
	{0x1a, 0x01, 0x09, 0x06, "3 Coin 1 Credits"       },
	{0x1a, 0x01, 0x09, 0x07, "4 Coin 1 Credits"       },
	{0x1a, 0x01, 0x09, 0x08, "2 Coins Start, 1 Coin Continue" },
	{0x1a, 0x01, 0x09, 0x09, "Free Play"              },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Game Difficulty"        },
	{0x1b, 0x01, 0x07, 0x00, "0 (Extra Easy)"         },
	{0x1b, 0x01, 0x07, 0x01, "1 (Very Easy)"          },
	{0x1b, 0x01, 0x07, 0x02, "2 (Easy)"               },
	{0x1b, 0x01, 0x07, 0x03, "3 (Normal)"             },
	{0x1b, 0x01, 0x07, 0x04, "4 (Hard)"               },
	{0x1b, 0x01, 0x07, 0x05, "5 (Very Hard)"          },
	{0x1b, 0x01, 0x07, 0x06, "6 (Extra Hard)"         },
	{0x1b, 0x01, 0x07, 0x07, "7 (Hardest)"            },

	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1b, 0x01, 0x70, 0x70, "Start 4 Continue 5"     },
	{0x1b, 0x01, 0x70, 0x60, "Start 3 Continue 4"     },
	{0x1b, 0x01, 0x70, 0x50, "Start 2 Continue 3"     },
	{0x1b, 0x01, 0x70, 0x40, "Start 1 Continue 2"     },
	{0x1b, 0x01, 0x70, 0x30, "Start 4 Continue 4"     },
	{0x1b, 0x01, 0x70, 0x20, "Start 3 Continue 3"     },
	{0x1b, 0x01, 0x70, 0x10, "Start 2 Continue 2"     },
	{0x1b, 0x01, 0x70, 0x00, "Start 1 Continue 1"     },

	// Dip C
	{0   , 0xfe, 0   , 3   , "Coin Slots"             },
	{0x1c, 0x01, 0x02, 0x00, "3 Players 3 Shooters"   },
	{0x1c, 0x01, 0x02, 0x01, "3 Players 1 Shooters"   },
	{0x1c, 0x01, 0x02, 0x02, "2 Players 1 Shooters"   },

	{0   , 0xfe, 0   , 4   , "Extend"                 },
	{0x1c, 0x01, 0x30, 0x00, "No Extend"              },
	{0x1c, 0x01, 0x30, 0x10, "100000 pts."            },
	{0x1c, 0x01, 0x30, 0x20, "300000 pts."            },
	{0x1c, 0x01, 0x30, 0x30, "100000, 300000, 500000, 1000000 pts." },
};

STDDIPINFO(Wofabla)

static struct BurnDIPInfo DinoQSoundDIPList[] =
{
	// Defaults
	{0x1c, 0xff, 0xff, 0x00, NULL                     },

	// Fake Dip
	{0   , 0xfe, 0   , 2   , "Q Sound"                },
	{0x1c, 0x01, 0x01, 0x00, "Off"                    },
	{0x1c, 0x01, 0x01, 0x01, "On"                     },
};

STDDIPINFO(DinoQSound) // For Wofsjb

static struct BurnDIPInfo DinohQSoundDIPList[] =
{
	// Defaults
	{0x1e, 0xff, 0xff, 0x00, NULL                     },

	// Fake Dip
	{0   , 0xfe, 0   , 2   , "Q Sound"                },
	{0x1e, 0x01, 0x01, 0x00, "Off"                    },
	{0x1e, 0x01, 0x01, 0x01, "On"                     },
};

static struct BurnDIPInfo PunisherQSoundDIPList[] =
{
	// Defaults
	{0x14, 0xff, 0xff, 0x00, NULL                     },

	// Fake Dip
	{0   , 0xfe, 0   , 2   , "Q Sound"                },
	{0x14, 0x01, 0x01, 0x00, "Off"                    },
	{0x14, 0x01, 0x01, 0x01, "On"                     },
};

static struct BurnDIPInfo SlammastQSoundDIPList[] =
{
	// Defaults
	{0x28, 0xff, 0xff, 0x00, NULL                     },

	// Fake Dip
	{0   , 0xfe, 0   , 2   , "Q Sound"                },
	{0x28, 0x01, 0x01, 0x00, "Off"                    },
	{0x28, 0x01, 0x01, 0x01, "On"                     },
};

STDDIPINFOEXT(DinoQS, Dino, DinoQSound)
STDDIPINFOEXT(DinohQS, Dinoh, DinohQSound)
STDDIPINFOEXT(PunisherQS, Punisher, PunisherQSound)
STDDIPINFOEXT(SlammastQS, Slammast, SlammastQSound)

// Rom Definitions

#define A_BOARD_PLDS						\
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT },	\
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },	\
	{ "prg1",          0x000117, 0xf1129744, BRF_OPT },	\
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },	\
	{ "sou1",          0x000117, 0x84f4b2fe, BRF_OPT },
	
#define A_BOARD_QSOUND_PLDS					\
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT },	\
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },	\
	{ "prg2",          0x000117, 0x4386879a, BRF_OPT },	\
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },	\

static struct BurnRomInfo NTFODrvRomDesc[] = {
	{ "41em_30.11f",   0x020000, 0x4249ec61, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41em_35.11h",   0x020000, 0xddbee5eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41em_31.12f",   0x020000, 0x584e88e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41em_36.12h",   0x020000, 0x3cfc31d0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41-32m.8h",     0x080000, 0x4e9648ca, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
 
	{ "41-5m.7a",      0x080000, 0x01d1cb11, BRF_GRA | CPS1_TILES },
	{ "41-7m.9a",      0x080000, 0xaeaa3509, BRF_GRA | CPS1_TILES },
	{ "41-1m.3a",      0x080000, 0xff77985a, BRF_GRA | CPS1_TILES },
	{ "41-3m.5a",      0x080000, 0x983be58f, BRF_GRA | CPS1_TILES },

	{ "41_9.12b",      0x010000, 0x0f9d8527, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "41_18.11c",     0x020000, 0xd1f15aeb, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "41_19.12c",     0x020000, 0x15aec3a6, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "yi24b.1a",      0x000117, 0x3004dcdf, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(NTFODrv)
STD_ROM_FN(NTFODrv)

static struct BurnRomInfo NTFOR1DrvRomDesc[] = {
	{ "41e_30.11f",    0x020000, 0x9deb1e75, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41e_35.11h",    0x020000, 0xd63942b3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41e_31.12f",    0x020000, 0xdf201112, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41e_36.12h",    0x020000, 0x816a818f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41-32m.8h",     0x080000, 0x4e9648ca, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
 
	{ "41-5m.7a",      0x080000, 0x01d1cb11, BRF_GRA | CPS1_TILES },
	{ "41-7m.9a",      0x080000, 0xaeaa3509, BRF_GRA | CPS1_TILES },
	{ "41-1m.3a",      0x080000, 0xff77985a, BRF_GRA | CPS1_TILES },
	{ "41-3m.5a",      0x080000, 0x983be58f, BRF_GRA | CPS1_TILES },

	{ "41_9.12b",      0x010000, 0x0f9d8527, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "41_18.11c",     0x020000, 0xd1f15aeb, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "41_19.12c",     0x020000, 0x15aec3a6, BRF_SND | CPS1_OKIM6295_SAMPLES },	
	
	A_BOARD_PLDS
	
	{ "yi24b.1a",      0x000117, 0x3004dcdf, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(NTFOR1Drv)
STD_ROM_FN(NTFOR1Drv)

static struct BurnRomInfo NTFOUDrvRomDesc[] = {
	{ "41u_30.11f",    0x020000, 0xbe5439d0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41u_35.11h",    0x020000, 0x6ac96595, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41u_31.12f",    0x020000, 0x9811d6eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41u_36.12h",    0x020000, 0xa87e6137, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41-32m.8h",     0x080000, 0x4e9648ca, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
 
	{ "41-5m.7a",      0x080000, 0x01d1cb11, BRF_GRA | CPS1_TILES },
	{ "41-7m.9a",      0x080000, 0xaeaa3509, BRF_GRA | CPS1_TILES },
	{ "41-1m.3a",      0x080000, 0xff77985a, BRF_GRA | CPS1_TILES },
	{ "41-3m.5a",      0x080000, 0x983be58f, BRF_GRA | CPS1_TILES },

	{ "41_9.12b",      0x010000, 0x0f9d8527, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "41e_18.11c",    0x020000, 0xd1f15aeb, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "41_19.12c",     0x020000, 0x15aec3a6, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "yi24b.1a",      0x000117, 0x3004dcdf, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(NTFOUDrv)
STD_ROM_FN(NTFOUDrv)

static struct BurnRomInfo NTFOJDrvRomDesc[] = {
	{ "41_36.12f",     0x020000, 0x7fbd42ab, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_42.12h",     0x020000, 0xc7781f89, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_37.13f",     0x020000, 0xc6464b0b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_43.13h",     0x020000, 0x440fc0b5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_34.10f",     0x020000, 0xb5f341ec, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_40.10h",     0x020000, 0x3979837d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_35.11f",     0x020000, 0x95cc979a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41_41.11h",     0x020000, 0x57496819, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "41_09.4b",      0x020000, 0xbe1b6bc2, BRF_GRA | CPS1_TILES },
	{ "41_01.4a",      0x020000, 0xd8946fc1, BRF_GRA | CPS1_TILES },
	{ "41_13.9b",      0x020000, 0x2e06d0ec, BRF_GRA | CPS1_TILES },
	{ "41_05.9a",      0x020000, 0xd8ba28e0, BRF_GRA | CPS1_TILES },
	{ "41_24.5e",      0x020000, 0x5aa43cee, BRF_GRA | CPS1_TILES },
	{ "41_17.5c",      0x020000, 0xbbeff902, BRF_GRA | CPS1_TILES },
	{ "41_38.8h",      0x020000, 0x8889c0aa, BRF_GRA | CPS1_TILES },
	{ "41_32.8f",      0x020000, 0xf0168249, BRF_GRA | CPS1_TILES },
	{ "41_10.5b",      0x020000, 0xb7eb6a6d, BRF_GRA | CPS1_TILES },
	{ "41_02.5a",      0x020000, 0x802e8153, BRF_GRA | CPS1_TILES },
	{ "41_14.10b",     0x020000, 0x5a33f676, BRF_GRA | CPS1_TILES },
	{ "41_06.10a",     0x020000, 0x4e53650b, BRF_GRA | CPS1_TILES },
	{ "41_25.7e",      0x020000, 0x94add360, BRF_GRA | CPS1_TILES },
	{ "41_18.7c",      0x020000, 0xa5e1c1f3, BRF_GRA | CPS1_TILES },
	{ "41_39.9h",      0x020000, 0x5b5c3949, BRF_GRA | CPS1_TILES },
	{ "41_33.9f",      0x020000, 0x7a31b0e2, BRF_GRA | CPS1_TILES },

	{ "41_23.13b",     0x010000, 0x0f9d8527, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "41_30.12c",     0x020000, 0xd1f15aeb, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "41_31.13c",     0x020000, 0x15aec3a6, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "yi22b.1a",      0x000117, 0xb5cad2a0, BRF_OPT }, // b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(NTFOJDrv)
STD_ROM_FN(NTFOJDrv)

static struct BurnRomInfo ThreeWondersRomDesc[] = {
	{ "rte_30a.11f",   0x020000, 0xef5b8b33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_35a.11h",   0x020000, 0x7d705529, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_31a.12f",   0x020000, 0x32835e5e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_36a.12h",   0x020000, 0x7637975f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_28a.9f",     0x020000, 0x054137c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_33a.9h",     0x020000, 0x7264cb1b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_29a.10f",   0x020000, 0xcddaa919, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_34a.10h",   0x020000, 0xed52e7e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "rt-5m.7a",      0x080000, 0x86aef804, BRF_GRA | CPS1_TILES },
	{ "rt-7m.9a",      0x080000, 0x4f057110, BRF_GRA | CPS1_TILES },
	{ "rt-1m.3a",      0x080000, 0x902489d0, BRF_GRA | CPS1_TILES },
	{ "rt-3m.5a",      0x080000, 0xe35ce720, BRF_GRA | CPS1_TILES },
	{ "rt-6m.8a",      0x080000, 0x13cb0e7c, BRF_GRA | CPS1_TILES },
	{ "rt-8m.10a",     0x080000, 0x1f055014, BRF_GRA | CPS1_TILES },
	{ "rt-2m.4a",      0x080000, 0xe9a034f4, BRF_GRA | CPS1_TILES },
	{ "rt-4m.6a",      0x080000, 0xdf0eea8b, BRF_GRA | CPS1_TILES },

	{ "rt_9.12b",      0x010000, 0xabfca165, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "rt_18.11c",     0x020000, 0x26b211ab, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rt_19.12c",     0x020000, 0xdbe64ad0, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rt24b.1a",      0x000117, 0x54b85159, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(ThreeWonders)
STD_ROM_FN(ThreeWonders)

static struct BurnRomInfo ThreeWondersr1RomDesc[] = {
	{ "rte_30.11f",    0x020000, 0x0d541519, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_35.11h",    0x020000, 0x73dd0e20, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_31.12f",    0x020000, 0x33e0337d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_36.12h",    0x020000, 0xa8865243, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_28.9f",     0x020000, 0x054137c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_33.9h",     0x020000, 0x7264cb1b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_29.10f",    0x020000, 0x9a8df1e4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_34.10h",    0x020000, 0x6348a79d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "rt-5m.7a",      0x080000, 0x86aef804, BRF_GRA | CPS1_TILES },
	{ "rt-7m.9a",      0x080000, 0x4f057110, BRF_GRA | CPS1_TILES },
	{ "rt-1m.3a",      0x080000, 0x902489d0, BRF_GRA | CPS1_TILES },
	{ "rt-3m.5a",      0x080000, 0xe35ce720, BRF_GRA | CPS1_TILES },
	{ "rt-6m.8a",      0x080000, 0x13cb0e7c, BRF_GRA | CPS1_TILES },
	{ "rt-8m.10a",     0x080000, 0x1f055014, BRF_GRA | CPS1_TILES },
	{ "rt-2m.4a",      0x080000, 0xe9a034f4, BRF_GRA | CPS1_TILES },
	{ "rt-4m.6a",      0x080000, 0xdf0eea8b, BRF_GRA | CPS1_TILES },

	{ "rt_9.12b",  	   0x010000, 0x7d5a77a7, BRF_PRG | CPS1_Z80_PROGRAM }, // 1 byte different from 3wonders, pcb verified

	{ "rt_18.11c", 	   0x020000, 0xf6dc0d3d, BRF_SND | CPS1_OKIM6295_SAMPLES }, // 6 bytes different from 3wonders, pcb verified
	{ "rt_19.12c",     0x020000, 0xdbe64ad0, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rt24b.1a",      0x000117, 0x54b85159, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(ThreeWondersr1)
STD_ROM_FN(ThreeWondersr1)

static struct BurnRomInfo Wonder3uRomDesc[] = {
	{ "rtu_30a.11f",   0x020000, 0x0b156fd8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtu_35a.11h",   0x020000, 0x57350bf4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtu_31a.12f",   0x020000, 0x0e723fcc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtu_36a.12h",   0x020000, 0x523a45dc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_28a.9f",     0x020000, 0x054137c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_33a.9h",     0x020000, 0x7264cb1b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtu_29a.10f",   0x020000, 0x37ba3e20, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtu_34a.10h",   0x020000, 0xf99f46c0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "rt-5m.7a",      0x080000, 0x86aef804, BRF_GRA | CPS1_TILES },
	{ "rt-7m.9a",      0x080000, 0x4f057110, BRF_GRA | CPS1_TILES },
	{ "rt-1m.3a",      0x080000, 0x902489d0, BRF_GRA | CPS1_TILES },
	{ "rt-3m.5a",      0x080000, 0xe35ce720, BRF_GRA | CPS1_TILES },
	{ "rt-6m.8a",      0x080000, 0x13cb0e7c, BRF_GRA | CPS1_TILES },
	{ "rt-8m.10a",     0x080000, 0x1f055014, BRF_GRA | CPS1_TILES },
	{ "rt-2m.4a",      0x080000, 0xe9a034f4, BRF_GRA | CPS1_TILES },
	{ "rt-4m.6a",      0x080000, 0xdf0eea8b, BRF_GRA | CPS1_TILES },

	{ "rt_9.12b",      0x010000, 0xabfca165, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "rt_18.11c",     0x020000, 0x26b211ab, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rt_19.12c",     0x020000, 0xdbe64ad0, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rt24b.1a",      0x000117, 0x54b85159, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Wonder3u)
STD_ROM_FN(Wonder3u)

static struct BurnRomInfo Wonder3RomDesc[] = {
	{ "rtj_36.12f",    0x020000, 0xe3741247, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtj_42.12h",    0x020000, 0xb4baa117, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtj_37.13f",    0x020000, 0xa1f677b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtj_43.13h",    0x020000, 0x85337a47, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_34.10f",     0x020000, 0x054137c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_40.10h",     0x020000, 0x7264cb1b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtj_35.11f",    0x020000, 0xe72f9ea3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rtj_41.11h",    0x020000, 0xa11ee998, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "rt_09.4b",      0x020000, 0x2c40e480, BRF_GRA | CPS1_TILES },
	{ "rt_01.4a",      0x020000, 0x3e11f8cd, BRF_GRA | CPS1_TILES },
	{ "rt_13.9b",      0x020000, 0x51009117, BRF_GRA | CPS1_TILES },
	{ "rt_05.9a",      0x020000, 0x283fd470, BRF_GRA | CPS1_TILES },
	{ "rt_24.5e",      0x020000, 0xee4484ce, BRF_GRA | CPS1_TILES },
	{ "rt_17.5c",      0x020000, 0xe5dcddeb, BRF_GRA | CPS1_TILES },
	{ "rt_38.8h",      0x020000, 0xb2940c2d, BRF_GRA | CPS1_TILES },
	{ "rt_32.8f",      0x020000, 0x08e2b758, BRF_GRA | CPS1_TILES },
	{ "rt_10.5b",      0x020000, 0xe3f3ff94, BRF_GRA | CPS1_TILES },
	{ "rt_02.5a",      0x020000, 0xfcffd73c, BRF_GRA | CPS1_TILES },
	{ "rt_14.10b",     0x020000, 0x5c546d9a, BRF_GRA | CPS1_TILES },
	{ "rt_06.10a",     0x020000, 0xd9650bc4, BRF_GRA | CPS1_TILES },
	{ "rt_25.7e",      0x020000, 0x11b28831, BRF_GRA | CPS1_TILES },
	{ "rt_18.7c",      0x020000, 0xce1afb7c, BRF_GRA | CPS1_TILES },
	{ "rt_39.9h",      0x020000, 0xea7ac9ee, BRF_GRA | CPS1_TILES },
	{ "rt_33.9f",      0x020000, 0xd6a99384, BRF_GRA | CPS1_TILES },
	{ "rt_11.7b",      0x020000, 0x04f3c298, BRF_GRA | CPS1_TILES },
	{ "rt_03.7a",      0x020000, 0x98087e08, BRF_GRA | CPS1_TILES },
	{ "rt_15.11b",     0x020000, 0xb6aba565, BRF_GRA | CPS1_TILES },
	{ "rt_07.11a",     0x020000, 0xc62defa1, BRF_GRA | CPS1_TILES },
	{ "rt_26.8e",      0x020000, 0x532f542e, BRF_GRA | CPS1_TILES },
	{ "rt_19.8c",      0x020000, 0x1f0f72bd, BRF_GRA | CPS1_TILES },
	{ "rt_28.10e",     0x020000, 0x6064e499, BRF_GRA | CPS1_TILES },
	{ "rt_21.10c",     0x020000, 0x20012ddc, BRF_GRA | CPS1_TILES },
	{ "rt_12.8b",      0x020000, 0xe54664cc, BRF_GRA | CPS1_TILES },
	{ "rt_04.8a",      0x020000, 0x4d7b9a1a, BRF_GRA | CPS1_TILES },
	{ "rt_16.12b",     0x020000, 0x37c96cfc, BRF_GRA | CPS1_TILES },
	{ "rt_08.12a",     0x020000, 0x75f4975b, BRF_GRA | CPS1_TILES },
	{ "rt_27.9e",      0x020000, 0xec6edc0f, BRF_GRA | CPS1_TILES },
	{ "rt_20.9c",      0x020000, 0x4fe52659, BRF_GRA | CPS1_TILES },
	{ "rt_29.11e",     0x020000, 0x8fa77f9f, BRF_GRA | CPS1_TILES },
	{ "rt_22.11c",     0x020000, 0x228a0d4a, BRF_GRA | CPS1_TILES },	

	{ "rt_23.13b",     0x010000, 0xabfca165, BRF_PRG | CPS1_Z80_PROGRAM },
//  { "rt_23.13b",     0x010000, 0x7d5a77a7, BRF_PRG | CPS1_Z80_PROGRAM }, // dumped from another board, 1 byte different, pcb verified
	
	{ "rt_30.12c",     0x020000, 0x26b211ab, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rt_31.13c",     0x020000, 0xdbe64ad0, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rt22b.1a",      0x000117, 0x89560d6a, BRF_OPT },	// b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Wonder3)
STD_ROM_FN(Wonder3)

static struct BurnRomInfo Wonder3hRomDesc[] = {
	{ "22.bin",        0x020000, 0xe6071884, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "26.bin",        0x020000, 0xa28447b7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "23.bin",        0x020000, 0xfd3d6509, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27.bin",        0x020000, 0x999cba3d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_28a.9f",     0x020000, 0x054137c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rt_33a.9h",     0x020000, 0x7264cb1b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_29a.10f",   0x020000, 0xcddaa919, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "rte_34a.10h",   0x020000, 0xed52e7e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "16.bin",        0x040000, 0xc997bca2, BRF_GRA | CPS1_TILES },
	{ "6.bin",         0x040000, 0x3eea321a, BRF_GRA | CPS1_TILES },
	{ "18.bin",        0x040000, 0x98acdfd4, BRF_GRA | CPS1_TILES },
	{ "8.bin",         0x040000, 0xdc9ca6f9, BRF_GRA | CPS1_TILES },
	{ "12.bin",        0x040000, 0x0d8a6007, BRF_GRA | CPS1_TILES },
	{ "2.bin",         0x040000, 0xd75563b9, BRF_GRA | CPS1_TILES },
	{ "14.bin",        0x040000, 0x84369a28, BRF_GRA | CPS1_TILES },
	{ "4.bin",         0x040000, 0xd4831578, BRF_GRA | CPS1_TILES },
	{ "17.bin",        0x040000, 0x040edff5, BRF_GRA | CPS1_TILES },
	{ "7.bin",         0x040000, 0xc7c0468c, BRF_GRA | CPS1_TILES },
	{ "19.bin",        0x040000, 0x9fef114f, BRF_GRA | CPS1_TILES },
	{ "9.bin",         0x040000, 0x48cbfba5, BRF_GRA | CPS1_TILES },
	{ "13.bin",        0x040000, 0x8fc3d7d1, BRF_GRA | CPS1_TILES },
	{ "3.bin",         0x040000, 0xc65e9a86, BRF_GRA | CPS1_TILES },
	{ "15.bin",        0x040000, 0xf239341a, BRF_GRA | CPS1_TILES },
	{ "5.bin",         0x040000, 0x947ac944, BRF_GRA | CPS1_TILES },
	
	{ "rt_9.12b",      0x010000, 0xabfca165, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "rt_18.11c",     0x020000, 0x26b211ab, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rt_19.12c",     0x020000, 0xdbe64ad0, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rt24b.1a",      0x000117, 0x54b85159, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Wonder3h)
STD_ROM_FN(Wonder3h)

static struct BurnRomInfo Wonder3haRomDesc[] = {
	// same as 3wondersh except for program roms
	// 3wondersb01 in HBMAME
	{ "b01.22",        0x040000, 0x8eb6b675, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "b01.26",        0x040000, 0xab2d0699, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "b01.23",        0x040000, 0x74db820f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "b01.27",        0x040000, 0xc75e807b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "16.bin",        0x040000, 0xc997bca2, BRF_GRA | CPS1_TILES },
	{ "6.bin",         0x040000, 0x3eea321a, BRF_GRA | CPS1_TILES },
	{ "18.bin",        0x040000, 0x98acdfd4, BRF_GRA | CPS1_TILES },
	{ "8.bin",         0x040000, 0xdc9ca6f9, BRF_GRA | CPS1_TILES },
	{ "12.bin",        0x040000, 0x0d8a6007, BRF_GRA | CPS1_TILES },
	{ "2.bin",         0x040000, 0xd75563b9, BRF_GRA | CPS1_TILES },
	{ "14.bin",        0x040000, 0x84369a28, BRF_GRA | CPS1_TILES },
	{ "4.bin",         0x040000, 0xd4831578, BRF_GRA | CPS1_TILES },
	{ "17.bin",        0x040000, 0x040edff5, BRF_GRA | CPS1_TILES },
	{ "7.bin",         0x040000, 0xc7c0468c, BRF_GRA | CPS1_TILES },
	{ "19.bin",        0x040000, 0x9fef114f, BRF_GRA | CPS1_TILES },
	{ "9.bin",         0x040000, 0x48cbfba5, BRF_GRA | CPS1_TILES },
	{ "13.bin",        0x040000, 0x8fc3d7d1, BRF_GRA | CPS1_TILES },
	{ "3.bin",         0x040000, 0xc65e9a86, BRF_GRA | CPS1_TILES },
	{ "15.bin",        0x040000, 0xf239341a, BRF_GRA | CPS1_TILES },
	{ "5.bin",         0x040000, 0x947ac944, BRF_GRA | CPS1_TILES },
	
	{ "rt_9.12b",      0x010000, 0xabfca165, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "rt_18.11c",     0x020000, 0x26b211ab, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rt_19.12c",     0x020000, 0xdbe64ad0, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rt24b.1a",      0x000117, 0x54b85159, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Wonder3ha)
STD_ROM_FN(Wonder3ha)

static struct BurnRomInfo Wonder3bRomDesc[] = {
	{ "274001.4",      0x080000, 0x47887cf3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "274001.3",      0x080000, 0xe79eacb3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "274001.12",     0x080000, 0x47cf8dfb, BRF_GRA | CPS1_TILES },
	{ "274001.10",     0x080000, 0xa0d27605, BRF_GRA | CPS1_TILES },
	{ "274001.11",     0x080000, 0x8112bbb4, BRF_GRA | CPS1_TILES },
	{ "274001.9",      0x080000, 0xcb73759d, BRF_GRA | CPS1_TILES },
	{ "274001.8",      0x080000, 0x3bc2ef5e, BRF_GRA | CPS1_TILES },
	{ "274001.6",      0x080000, 0x312d790c, BRF_GRA | CPS1_TILES },
	{ "274001.7",      0x080000, 0x58307167, BRF_GRA | CPS1_TILES },
	{ "274001.5",      0x080000, 0x3f765ae8, BRF_GRA | CPS1_TILES },	

	{ "27512.2",       0x010000, 0xabfca165, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "27020.1",       0x040000, 0x3c4348cf, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wonder3b)
STD_ROM_FN(Wonder3b)

static struct BurnRomInfo CaptcommRomDesc[] = {
	{ "cce_23f.8f",    0x080000, 0x42c814c5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cc_22f.7f",     0x080000, 0x0fd34195, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cc_24f.9e",     0x020000, 0x3a794f25, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cc_28f.9f",     0x020000, 0xfc3c2906, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cc-5m.3a",      0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cc-7m.5a",      0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "cc-1m.4a",      0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cc-3m.6a",      0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cc-6m.7a",      0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cc-8m.9a",      0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cc-2m.8a",      0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cc-4m.10a",     0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },

	{ "cc_09.11a",     0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cc_18.11c",     0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "cc_19.12c",     0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cc63b.1a",      0x000117, 0xcae8f0f9, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ccprg1.11d",    0x000117, 0xe1c225c4, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632b.ic1",     0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Captcomm)
STD_ROM_FN(Captcomm)

static struct BurnRomInfo Captcommr1RomDesc[] = {
	{ "cce_23d.8f",    0x080000, 0x19c58ece, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cc_22d.7f",     0x080000, 0xa91949b7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cc_24d.9e",     0x020000, 0x680e543f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cc_28d.9f",     0x020000, 0x8820039f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cc-5m.3a",      0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cc-7m.5a",      0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "cc-1m.4a",      0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cc-3m.6a",      0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cc-6m.7a",      0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cc-8m.9a",      0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cc-2m.8a",      0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cc-4m.10a",     0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },

	{ "cc_09.11a",     0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cc_18.11c",     0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "cc_19.12c",     0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cc63b.1a",      0x000117, 0xcae8f0f9, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ccprg.11d",     0x000117, 0xe1c225c4, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Captcommr1)
STD_ROM_FN(Captcommr1)

static struct BurnRomInfo CaptcommuRomDesc[] = {
	{ "ccu_23b.8f",    0x080000, 0x03da44fd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccu_22c.7f",    0x080000, 0x9b82a052, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccu_24b.9e",    0x020000, 0x84ff99b2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ccu_28b.9f",    0x020000, 0xfbcec223, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cc-5m.3a",      0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cc-7m.5a",      0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "cc-1m.4a",      0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cc-3m.6a",      0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cc-6m.7a",      0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cc-8m.9a",      0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cc-2m.8a",      0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cc-4m.10a",     0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },

	{ "ccu_09.11a",    0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ccu_18.11c",    0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ccu_19.12c",    0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cc63b.1a",      0x000117, 0xcae8f0f9, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ccprg1.11d",    0x000117, 0xe1c225c4, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Captcommu)
STD_ROM_FN(Captcommu)

static struct BurnRomInfo CaptcommjRomDesc[] = {
	{ "ccj_23f.8f",    0x080000, 0x5b482b62, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccj_22f.7f",    0x080000, 0x0fd34195, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccj_24f.9e",    0x020000, 0x3a794f25, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ccj_28f.9f",    0x020000, 0xfc3c2906, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cc_01.3a",      0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cc_02.4a",      0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "cc_03.5a",      0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cc_04.6a",      0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cc_05.7a",      0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cc_06.8a",      0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cc_07.9a",      0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cc_08.10a",     0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },

	{ "ccj_09.12a",    0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ccj_18.11c",    0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ccj_19.12c",    0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cc63b.1a",      0x000117, 0xcae8f0f9, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ccprg1.11d",    0x000117, 0xe1c225c4, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Captcommj)
STD_ROM_FN(Captcommj)

static struct BurnRomInfo Captcommjr1RomDesc[] = {
	{ "ccj_23b.8f",    0x080000, 0xe2a2d80e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccj_22c.7f",    0x080000, 0x9b82a052, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccj_24b.9e",    0x020000, 0x84ff99b2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ccj_28b.9f",    0x020000, 0xfbcec223, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cc_01.3a",      0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cc_02.4a",      0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "cc_03.5a",      0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cc_04.6a",      0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cc_05.7a",      0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cc_06.8a",      0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cc_07.9a",      0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cc_08.10a",     0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },

	{ "ccj_09.12a",    0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ccj_18.11c",    0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ccj_19.12c",    0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cc63b.1a",      0x000117, 0xcae8f0f9, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ccprg.11d",     0x000117, 0xe1c225c4, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Captcommjr1)
STD_ROM_FN(Captcommjr1)

static struct BurnRomInfo CaptcommbRomDesc[] = {
	{ "25.bin",        0x080000, 0xcb71ed7a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27.bin",        0x080000, 0x47cb2e87, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "24.bin",        0x040000, 0x79794279, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "26.bin",        0x040000, 0xb01077ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "c91e-01.bin",   0x100000, 0xf863071c, BRF_GRA | CPS1_TILES },
	{ "c91e-02.bin",   0x100000, 0x4b03c308, BRF_GRA | CPS1_TILES },
	{ "c91e-03.bin",   0x100000, 0x3383ea96, BRF_GRA | CPS1_TILES },
	{ "c91e-04.bin",   0x100000, 0xb8e1f4cf, BRF_GRA | CPS1_TILES },

	{ "l.bin",         0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "c91e-05.bin",   0x040000, 0x096115fb, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Captcommb)
STD_ROM_FN(Captcommb)

static struct BurnRomInfo Captcommb2RomDesc[] = {
	{ "5.bin",     	   0x080000, 0xc3a6ed28, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",         0x080000, 0x28729335, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.bin",         0x040000, 0x1b526d73, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",         0x040000, 0x73c99709, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "bnh-01.bin",    0x080000, 0xffbc3bdd, BRF_GRA | CPS1_TILES },
	{ "bnh-02.bin",    0x080000, 0x40e58d52, BRF_GRA | CPS1_TILES },
	{ "bnh-03.bin",    0x080000, 0x58f92cad, BRF_GRA | CPS1_TILES },
	{ "bnh-04.bin",    0x080000, 0x284eea8a, BRF_GRA | CPS1_TILES },
	{ "bnh-05.bin",    0x080000, 0xd02719b7, BRF_GRA | CPS1_TILES },
	{ "bnh-06.bin",    0x080000, 0xd9d43b55, BRF_GRA | CPS1_TILES },
	{ "bnh-07.bin",    0x080000, 0x03b7900d, BRF_GRA | CPS1_TILES },
	{ "bnh-08.bin",    0x080000, 0x327b8da8, BRF_GRA | CPS1_TILES },
				
	{ "1.bin",         0x040000, 0xaed2f4bd, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "1_gal20v8.ic169", 0x000157, 0xe5cf9f53, BRF_OPT },
	{ "2_gal16v8.ic7", 	 0x000117, 0x0ebc7cd7, BRF_OPT },
	{ "3_gal16v8.ic72",  0x000117, 0xebf1f643, BRF_OPT },
	{ "4_gal16v8.ic80",  0x000117, 0x2c43c330, BRF_OPT },
	{ "5_gal20v8.ic121", 0x000157, 0x76fa8969, BRF_OPT },
	{ "6_gal20v8.ic120", 0x000157, 0x6a55a974, BRF_OPT },
	// ic116  tpc1020afn-084c  no dump
};

STD_ROM_PICK(Captcommb2)
STD_ROM_FN(Captcommb2)

static struct BurnRomInfo Captcommb3RomDesc[] = {
	{ "5.bin",     	   0x080000, 0xc3a6ed28, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.bin",         0x080000, 0x28729335, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",         0x040000, 0x1b526d73, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",         0x040000, 0x73c99709, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "cap.bin",       0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cbp.bin",       0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "ccp.bin",       0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cdp.bin",       0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cai.bin",       0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cbi.bin",       0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cci.bin",       0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cdi.bin",       0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },
				
	{ "1.bin",         0x040000, 0xaed2f4bd, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Captcommb3)
STD_ROM_FN(Captcommb3)

static struct BurnRomInfo CawingRomDesc[] = {
	{ "cae_30a.11f",   0x020000, 0x91fceacd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cae_35a.11h",   0x020000, 0x3ef03083, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cae_31a.12f",   0x020000, 0xe5b75caf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cae_36a.12h",   0x020000, 0xc73fd713, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ca-32m.8h",     0x080000, 0x0c4837d4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ca-5m.7a",      0x080000, 0x66d4cc37, BRF_GRA | CPS1_TILES },
	{ "ca-7m.9a",      0x080000, 0xb6f896f2, BRF_GRA | CPS1_TILES },
	{ "ca-1m.3a",      0x080000, 0x4d0620fd, BRF_GRA | CPS1_TILES },
	{ "ca-3m.5a",      0x080000, 0x0b0341c3, BRF_GRA | CPS1_TILES },

	{ "ca_9.12b",      0x010000, 0x96fe7485, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ca_18.11c",     0x020000, 0x4a613a2c, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ca_19.12c",     0x020000, 0x74584493, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ca24b.1a",      0x000117, 0x76ec0b1c, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Cawing)
STD_ROM_FN(Cawing)

static struct BurnRomInfo Cawingr1RomDesc[] = {
	{ "cae_30.11f",    0x020000, 0x23305cd5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cae_35.11h",    0x020000, 0x69419113, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cae_31.12f",    0x020000, 0x9008dfb3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cae_36.12h",    0x020000, 0x4dbf6f8e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ca-32m.8h",     0x080000, 0x0c4837d4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ca-5m.7a",      0x080000, 0x66d4cc37, BRF_GRA | CPS1_TILES },
	{ "ca-7m.9a",      0x080000, 0xb6f896f2, BRF_GRA | CPS1_TILES },
	{ "ca-1m.3a",      0x080000, 0x4d0620fd, BRF_GRA | CPS1_TILES },
	{ "ca-3m.5a",      0x080000, 0x0b0341c3, BRF_GRA | CPS1_TILES },

	{ "cae_09.12b",    0x010000, 0x96fe7485, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cae_18.11c",    0x020000, 0x4a613a2c, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "cae_19.12c",    0x020000, 0x74584493, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ca24b.1a",      0x000117, 0x76ec0b1c, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Cawingr1)
STD_ROM_FN(Cawingr1)

static struct BurnRomInfo CawinguRomDesc[] = {
	{ "cau_36.12f",    0x020000, 0xc2574c0c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // == cae_30a.11f
	{ "cau_42.12h",    0x020000, 0xd89e00be, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_37.13f",    0x020000, 0x8e6d4f8a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // == cae_31a.12f
	{ "cau_43.13h",    0x020000, 0xece07955, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // == cae_36a.12h
	{ "cau_34.10f",    0x020000, 0x5fda906e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_40.10h",    0x020000, 0x736c1835, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_35.11f",    0x020000, 0x74c2ddf0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_41.11h",    0x020000, 0x2a44bfe5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cau_09.4b",     0x020000, 0xd4b17c3a, BRF_GRA | CPS1_TILES },
	{ "cau_01.4a",     0x020000, 0x34c3094e, BRF_GRA | CPS1_TILES },
	{ "cau_13.9b",     0x020000, 0x9d5c7911, BRF_GRA | CPS1_TILES },
	{ "cau_05.9a",     0x020000, 0xf042cc7b, BRF_GRA | CPS1_TILES },
	{ "cau_24.5e",     0x020000, 0x0eac450f, BRF_GRA | CPS1_TILES },
	{ "cau_17.5c",     0x020000, 0x4fab0d0c, BRF_GRA | CPS1_TILES },
	{ "cau_38.8h",     0x020000, 0xcb96ed24, BRF_GRA | CPS1_TILES },
	{ "cau_32.8f",     0x020000, 0x433a0859, BRF_GRA | CPS1_TILES },
	{ "cau_10.5b",     0x020000, 0x4af10ef2, BRF_GRA | CPS1_TILES },
	{ "cau_02.5a",     0x020000, 0x3e1f5b34, BRF_GRA | CPS1_TILES },
	{ "cau_14.10b",    0x020000, 0x2bef78c4, BRF_GRA | CPS1_TILES },
	{ "cau_06.10a",    0x020000, 0x3777ede1, BRF_GRA | CPS1_TILES },
	{ "cau_25.7e",     0x020000, 0x859ee531, BRF_GRA | CPS1_TILES },
	{ "cau_18.7c",     0x020000, 0x4c52edf1, BRF_GRA | CPS1_TILES },
	{ "cau_39.9h",     0x020000, 0x147be975, BRF_GRA | CPS1_TILES },
	{ "cau_33.9f",     0x020000, 0x8560c130, BRF_GRA | CPS1_TILES },

	{ "cau_23.13b",    0x010000, 0x96fe7485, BRF_PRG | CPS1_Z80_PROGRAM }, // == ca_9.12b

	{ "cau_30.12c",    0x020000, 0x4a613a2c, BRF_SND | CPS1_OKIM6295_SAMPLES }, // == ca_18.11c
	{ "cau_31.13c",    0x020000, 0x74584493, BRF_SND | CPS1_OKIM6295_SAMPLES }, // == ca_19.12c
	
	A_BOARD_PLDS
	
	{ "ca22b.1a",      0x000117, 0x5152e678, BRF_OPT },	// b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Cawingu)
STD_ROM_FN(Cawingu)

static struct BurnRomInfo Cawingur1RomDesc[] = {
	{ "cau_30a.11f",   0x020000, 0x91fceacd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_35a.11h",   0x020000, 0xf090d9b2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_31a.12f",   0x020000, 0xe5b75caf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cau_36a.12h",   0x020000, 0xc73fd713, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ca-32m.8h",     0x080000, 0x0c4837d4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ca-5m.7a",      0x080000, 0x66d4cc37, BRF_GRA | CPS1_TILES },
	{ "ca-7m.9a",      0x080000, 0xb6f896f2, BRF_GRA | CPS1_TILES },
	{ "ca-1m.3a",      0x080000, 0x4d0620fd, BRF_GRA | CPS1_TILES },
	{ "ca-3m.5a",      0x080000, 0x0b0341c3, BRF_GRA | CPS1_TILES },

	{ "cau_09.12b",    0x010000, 0x96fe7485, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cau_18.11c",    0x020000, 0x4a613a2c, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "cau_19.12c",    0x020000, 0x74584493, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ca24b.1a",      0x000117, 0x76ec0b1c, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Cawingur1)
STD_ROM_FN(Cawingur1)

static struct BurnRomInfo CawingjRomDesc[] = {
	{ "caj_36a.12f",   0x020000, 0x91fceacd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_42a.12h",   0x020000, 0x039f8362, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_37a.13f",   0x020000, 0xe5b75caf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_43a.13h",   0x020000, 0xc73fd713, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_34.10f",    0x020000, 0x51ea57f4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_40.10h",    0x020000, 0x2ab71ae1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_35.11f",    0x020000, 0x01d71973, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "caj_41.11h",    0x020000, 0x3a43b538, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "caj_09.4b",     0x020000, 0x41b0f9a6, BRF_GRA | CPS1_TILES },
	{ "caj_01.4a",     0x020000, 0x1002d0b8, BRF_GRA | CPS1_TILES },
	{ "caj_13.9b",     0x020000, 0x6f3948b2, BRF_GRA | CPS1_TILES },
	{ "caj_05.9a",     0x020000, 0x207373d7, BRF_GRA | CPS1_TILES },
	{ "caj_24.5e",     0x020000, 0xe356aad7, BRF_GRA | CPS1_TILES },
	{ "caj_17.5c",     0x020000, 0x540f2fd8, BRF_GRA | CPS1_TILES },
	{ "caj_38.8h",     0x020000, 0x2464d4ab, BRF_GRA | CPS1_TILES },
	{ "caj_32.8f",     0x020000, 0x9b5836b3, BRF_GRA | CPS1_TILES },
	{ "caj_10.5b",     0x020000, 0xbf8a5f52, BRF_GRA | CPS1_TILES },
	{ "caj_02.5a",     0x020000, 0x125b018d, BRF_GRA | CPS1_TILES },
	{ "caj_14.10b",    0x020000, 0x8458e7d7, BRF_GRA | CPS1_TILES },
	{ "caj_06.10a",    0x020000, 0xcf80e164, BRF_GRA | CPS1_TILES },
	{ "caj_25.7e",     0x020000, 0xcdd0204d, BRF_GRA | CPS1_TILES },
	{ "caj_18.7c",     0x020000, 0x29c1d4b1, BRF_GRA | CPS1_TILES },
	{ "caj_39.9h",     0x020000, 0xeea23b67, BRF_GRA | CPS1_TILES },
	{ "caj_33.9f",     0x020000, 0xdde3891f, BRF_GRA | CPS1_TILES },

	{ "caj_23.13b",    0x010000, 0x96fe7485, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "caj_30.12c",    0x020000, 0x4a613a2c, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "caj_31.13c",    0x020000, 0x74584493, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ca22b.1a",      0x000117, 0x5152e678, BRF_OPT },	// b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Cawingj)
STD_ROM_FN(Cawingj)

static struct BurnRomInfo CawingblRomDesc[] = {
	{ "caw2.bin",      0x080000, 0x8125d3f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw2
	{ "caw1.bin",      0x080000, 0xb19b10ce, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw1

	{ "caw7.bin",      0x080000, 0xa045c689, BRF_GRA | CPS1_TILES },
	{ "caw6.bin",      0x080000, 0x61192f7c, BRF_GRA | CPS1_TILES },	
	{ "caw5.bin",      0x080000, 0x30dd78db, BRF_GRA | CPS1_TILES },
	{ "caw4.bin",      0x080000, 0x4937fc41, BRF_GRA | CPS1_TILES },

	{ "caw3.bin",      0x020000, 0xffe16cdc, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Cawingbl)
STD_ROM_FN(Cawingbl)

static struct BurnRomInfo Cawingb2RomDesc[] = {
	{ "8.8",      	   0x020000, 0xf655708c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "4.4",      	   0x020000, 0xa02fb5aa, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "7.7",      	   0x020000, 0x8c6c7430, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw2
	{ "3.3",      	   0x020000, 0xf585bf2c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw1
	{ "6.6",      	   0x020000, 0x5fda906e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw2
	{ "2.2",      	   0x020000, 0x736c1835, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw1	
	{ "5.5",      	   0x020000, 0x76458083, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw2	
	{ "1.1",      	   0x020000, 0xd3523f34, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// caw1
	
	{ "17.17",         0x020000, 0x0b538062, BRF_GRA | CPS1_TILES },   //caw7
	{ "19.19",         0x020000, 0x3ad62311, BRF_GRA | CPS1_TILES },   //caw6
	{ "21.21",         0x020000, 0x1b872a98, BRF_GRA | CPS1_TILES },   //caw5
	{ "23.23",         0x020000, 0xad49eecd, BRF_GRA | CPS1_TILES },	
	{ "9.9",           0x020000, 0x8cd4df5b, BRF_GRA | CPS1_TILES },   //caw7
	{ "11.11",         0x020000, 0xbf14418a, BRF_GRA | CPS1_TILES },   //caw6
	{ "13.13",         0x020000, 0xcef1aab8, BRF_GRA | CPS1_TILES },   //caw5
	{ "15.15",         0x020000, 0x397725dc, BRF_GRA | CPS1_TILES },   //caw4
	{ "18.18",         0x020000, 0x9b14f7ed, BRF_GRA | CPS1_TILES },   //caw7
	{ "20.20",         0x020000, 0x59bcc1bb, BRF_GRA | CPS1_TILES },   //caw6
	{ "22.22",         0x020000, 0x23dc647a, BRF_GRA | CPS1_TILES },   //caw5
	{ "24.24",         0x020000, 0xeda9fa6b, BRF_GRA | CPS1_TILES },   //caw4
	{ "10.10",         0x020000, 0x17174249, BRF_GRA | CPS1_TILES },   //caw7	
	{ "12.12",         0x020000, 0x490440b2, BRF_GRA | CPS1_TILES },   //caw6	
	{ "14.14",         0x020000, 0x344a8270, BRF_GRA | CPS1_TILES },   //caw5	
	{ "16.16",         0x020000, 0xb991ad91, BRF_GRA | CPS1_TILES },   //caw4

	{ "5.a",           0x020000, 0xffe16cdc, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Cawingb2)
STD_ROM_FN(Cawingb2)

static struct BurnRomInfo Cps1demoRomDesc[] = {
	{ "cd30-36.bin",   0x020000, 0x5eb617d6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cd35-42.bin",   0x020000, 0x1f1c0a62, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cd31-37.bin",   0x020000, 0x7ee8cdcd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // sound rom from cps1frog ?
	{ "cd36-43.bin",   0x020000, 0x7ee8cdcd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // sound rom from cps1frog ?
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd05-05m.bin",  0x080000, 0x35dc6153, BRF_GRA | CPS1_TILES },
	{ "cd07-07m.bin",  0x080000, 0xbaf08a38, BRF_GRA | CPS1_TILES },
	{ "cd01-01m.bin",  0x080000, 0x3ad8e790, BRF_GRA | CPS1_TILES },
	{ "cd03-03m.bin",  0x080000, 0xfb5186f3, BRF_GRA | CPS1_TILES },

	{ "ff_09.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Cps1demo)
STD_ROM_FN(Cps1demo)

static struct BurnRomInfo Cworld2jRomDesc[] = {
	{ "q5_36.12f",     0x020000, 0x38a08099, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_42.12h",     0x020000, 0x4d29b3a4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_37.13f",     0x020000, 0xeb547ebc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_43.13h",     0x020000, 0x3ef65ea8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_34.10f",     0x020000, 0x7fcc1317, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_40.10h",     0x020000, 0x7f14b7b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_35.11f",     0x020000, 0xabacee26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
//  { "q5_35.11f",     0x020000, 0x59961612, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	// dumped from another board, 1 byte different, pcb verified
	{ "q5_41.11h",     0x020000, 0xd3654067, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "q5_09.4b",      0x020000, 0x48496d80, BRF_GRA | CPS1_TILES },
	{ "q5_01.4a",      0x020000, 0xc5453f56, BRF_GRA | CPS1_TILES },
	{ "q5_13.9b",      0x020000, 0xc741ac52, BRF_GRA | CPS1_TILES },
	{ "q5_05.9a",      0x020000, 0x143e068f, BRF_GRA | CPS1_TILES },
	{ "q5_24.5e",      0x020000, 0xb419d139, BRF_GRA | CPS1_TILES },
	{ "q5_17.5c",      0x020000, 0xbd3b4d11, BRF_GRA | CPS1_TILES },
	{ "q5_38.8h",      0x020000, 0x9c24670c, BRF_GRA | CPS1_TILES },
	{ "q5_32.8f",      0x020000, 0x3ef9c7c2, BRF_GRA | CPS1_TILES },
	{ "q5_10.5b",      0x020000, 0x119e5e93, BRF_GRA | CPS1_TILES },
	{ "q5_02.5a",      0x020000, 0xa2cadcbe, BRF_GRA | CPS1_TILES },
	{ "q5_14.10b",     0x020000, 0xa8755f82, BRF_GRA | CPS1_TILES },
	{ "q5_06.10a",     0x020000, 0xc92a91fc, BRF_GRA | CPS1_TILES },
	{ "q5_25.7e",      0x020000, 0x979237cb, BRF_GRA | CPS1_TILES },
	{ "q5_18.7c",      0x020000, 0xc57da03c, BRF_GRA | CPS1_TILES },
	{ "q5_39.9h",      0x020000, 0xa5839b25, BRF_GRA | CPS1_TILES },
	{ "q5_33.9f",      0x020000, 0x04d03930, BRF_GRA | CPS1_TILES },

	{ "q5_23.13b",     0x010000, 0xe14dc524, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "q5_30.12c",     0x020000, 0xd10c1b68, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "q5_31.13c",     0x020000, 0x7d17e496, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "q522b.1a",      0x000117, 0x0a1527ab, BRF_OPT },	// b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Cworld2j)
STD_ROM_FN(Cworld2j)

static struct BurnRomInfo Cworld2jaRomDesc[] = {
/* B-Board 90629B-3  - all roms have 90629B on the labels, no battery, possibly unofficial / desuicided with reproduction stickers */
	{ "q5 - 34_90629b.8f",      0x080000, 0xde54487f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "q5 - 33_90629b.6f",      0x080000, 0x93248458, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "q5 - 06_90629b.8a",      0x080000, 0x09d0e7ce, BRF_GRA | CPS1_TILES },
	{ "q5 - 08_90629b.10a",     0x080000, 0x22e4ce9a, BRF_GRA | CPS1_TILES },
	{ "q5 - 05_90629b.7a",      0x080000, 0xf7b3aed6, BRF_GRA | CPS1_TILES },
	{ "q5 - 07_90629b.9a",      0x080000, 0x520c6c88, BRF_GRA | CPS1_TILES },

	{ "q5 - 09_90629b.12a",     0x010000, 0xe14dc524, BRF_PRG | CPS1_Z80_PROGRAM }, // == q5_23.13b

	{ "q5 - 18_90629b.11c",     0x020000, 0xd10c1b68, BRF_SND | CPS1_OKIM6295_SAMPLES }, // == q5_30.12c
	{ "q5 - 19_90629b.12c",     0x020000, 0x7d17e496, BRF_SND | CPS1_OKIM6295_SAMPLES }, // == q5_31.13c
	
	A_BOARD_PLDS
	
	{ "q529b.1a",      			0x000117, 0x00000000, BRF_OPT | BRF_NODUMP},	// b-board PLDs
	{ "iob1.11d",      			0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      			0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Cworld2ja)
STD_ROM_FN(Cworld2ja)

static struct BurnRomInfo Cworld2jbRomDesc[] = {
/* B-Board 91634B-2  - all roms have 91634B on the labels */
	{ "q5 - 23_91634b.8f",      0x080000, 0x709f577f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "q5 - 22_91634b.7f",      0x080000, 0x93248458, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "q5 - 01_91634b.3a",      0x080000, 0x09d0e7ce, BRF_GRA | CPS1_TILES },
	{ "q5 - 02_91634b.4a",      0x080000, 0x22e4ce9a, BRF_GRA | CPS1_TILES },
	{ "q5 - 03_91634b.5a",      0x080000, 0xf7b3aed6, BRF_GRA | CPS1_TILES },
	{ "q5 - 04_91634b.6a",      0x080000, 0x520c6c88, BRF_GRA | CPS1_TILES },

	{ "q5 - 09_91634b.12a",     0x010000, 0xe14dc524, BRF_PRG | CPS1_Z80_PROGRAM }, // == q5_23.13b

	{ "q5 - 18_91634b.11c",     0x020000, 0xd10c1b68, BRF_SND | CPS1_OKIM6295_SAMPLES }, // == q5_30.12c
	{ "q5 - 19_91634b.12c",     0x020000, 0x7d17e496, BRF_SND | CPS1_OKIM6295_SAMPLES }, // == q5_31.13c
	
	A_BOARD_PLDS
	
	{ "q563b.1a",      			0x000117, 0x00000000, BRF_OPT | BRF_NODUMP},	// b-board PLDs
	{ "iob1.12d",      			0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     			0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      			0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      			0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Cworld2jb)
STD_ROM_FN(Cworld2jb)

static struct BurnRomInfo DinoRomDesc[] = {
	{ "cde_23a.8f",    0x080000, 0x8f4e585e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cde_22a.7f",    0x080000, 0x9278aa12, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cde_21a.6f",    0x080000, 0x66d23de2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd-1m.3a",      0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd-3m.5a",      0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd-2m.4a",      0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd-4m.6a",      0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd-5m.7a",      0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd-7m.9a",      0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd-6m.8a",      0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd-8m.10a",     0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",       0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",      0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",      0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",      0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",      0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "cd63b.1a",      0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Dino)
STD_ROM_FN(Dino)

static struct BurnRomInfo DinoaRomDesc[] = {
	// Title screen shows "distributed by Hung Hsi Enterprise". Hung Hsi produced some sf2 bootlegs.
	{ "cdt_23.8f",     0x080000, 0xf477f7a0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdt_22.7f",     0x080000, 0x1e534ca5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdt_21.6f",     0x080000, 0x74b04329, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd-1m.3a",      0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd-3m.5a",      0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd-2m.4a",      0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd-4m.6a",      0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd-5m.7a",      0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd-7m.9a",      0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd-6m.8a",      0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd-8m.10a",     0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",       0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",      0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",      0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",      0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",      0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "cd63b.1a",      0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Dinoa)
STD_ROM_FN(Dinoa)

static struct BurnRomInfo DinojRomDesc[] = {
	{ "cdj_23a.8f",    0x080000, 0x5f3ece96, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdj_22a.7f",    0x080000, 0xa0d8de29, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdj_21a.6f",    0x080000, 0x66d23de2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd_01.3a",      0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd_02.4a",      0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd_03.5a",      0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd_04.6a",      0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd_05.7a",      0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd_06.8a",      0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd_07.9a",      0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd_08.10a",     0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",       0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",      0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",      0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",      0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",      0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "cd63b.1a",      0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Dinoj)
STD_ROM_FN(Dinoj)

static struct BurnRomInfo DinouRomDesc[] = {
	{ "cdu_23a.8f",    0x080000, 0x7c2543cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdu_22a.7f",    0x080000, 0xd19f981e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdu_21a.6f",    0x080000, 0x66d23de2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd-1m.3a",      0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd-3m.5a",      0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd-2m.4a",      0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd-4m.6a",      0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd-5m.7a",      0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd-7m.9a",      0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd-6m.8a",      0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd-8m.10a",     0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",       0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",      0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",      0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",      0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",      0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "cd63b.1a",      0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Dinou)
STD_ROM_FN(Dinou)

static struct BurnRomInfo DinopicRomDesc[] = {
	// This set is also known as dinob
	{ "5.bin",         0x080000, 0x96dfcbf1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",         0x080000, 0x13dfeb08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "7.bin",         0x080000, 0x6133f349, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",         0x080000, 0x0e4058ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "4.bin",         0x080000, 0xf3c2c98d, BRF_GRA | CPS1_TILES },
	{ "8.bin",         0x080000, 0xd574befc, BRF_GRA | CPS1_TILES },
	{ "9.bin",         0x080000, 0x55ef0adc, BRF_GRA | CPS1_TILES },
	{ "6.bin",         0x080000, 0xcc0805fc, BRF_GRA | CPS1_TILES },
	{ "13.bin",        0x080000, 0x1371f714, BRF_GRA | CPS1_TILES },
	{ "12.bin",        0x080000, 0xb284c4a7, BRF_GRA | CPS1_TILES },
	{ "11.bin",        0x080000, 0xb7ad3394, BRF_GRA | CPS1_TILES },
	{ "10.bin",        0x080000, 0x88847705, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",       0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",      0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",      0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",      0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",      0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "cd63b.1a",      0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },

	/* PIC16c57 - protected, dump isn't valid */	
	{ "pic16c57-rp",   0x002d4c, 0x5a6d393c, BRF_PRG | CPS1_PIC },

	{ "1.bin",         0x080000, 0x7d921309, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Dinopic)
STD_ROM_FN(Dinopic)

static struct BurnRomInfo Dinopic2RomDesc[] = {
	{ "27c4000-m12481.bin",		0x080000, 0x96dfcbf1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c4000-m12374r-2.bin",	0x080000, 0x13dfeb08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c4000-m12374r-3.bin",	0x080000, 0x6133f349, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c4000-m12374r-1.bin",	0x080000, 0x0e4058ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "27c4000-m12481-4.bin",	0x080000, 0xf3c2c98d, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-3.bin",	0x080000, 0xa0e1f6e0, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-2.bin",	0x080000, 0x55ef0adc, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-1.bin",	0x080000, 0xcc0805fc, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-8.bin",	0x080000, 0x1371f714, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-7.bin",	0x080000, 0xb284c4a7, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-6.bin",	0x080000, 0xb7ad3394, BRF_GRA | CPS1_TILES },
	{ "27c4000-m12481-5.bin",	0x080000, 0x88847705, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",				0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",				0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",				0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",				0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",				0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "cd63b.1a",				0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",				0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",				0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",				0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",				0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",				0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",				0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",				0x000117, 0x6619c494, BRF_OPT },

	/* PIC16c57 - protected, dump isn't valid */
	{ "pic16c57-xt.hex",		0x0026cc, 0xa6a5eac4, BRF_PRG | CPS1_PIC },

	{ "27c4000-m12623.bin",		0x080000, 0x7d921309, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "gal20v8a-1.bin",			0x000157, 0xcd99ca47, BRF_OPT },
	{ "gal20v8a-2.bin",			0x000157, 0x60d016b9, BRF_OPT },
	{ "gal20v8a-3.bin",			0x000157, 0x049b7f4f, BRF_OPT },
	{ "palce16v8h-1.bin",		0x000117, 0x48253c66, BRF_OPT },
	{ "palce16v8h-2.bin",		0x000117, 0x9ae375ba, BRF_OPT },
	{ "palce16v8h-3.bin",		0x000117, 0xb0f10adf, BRF_OPT },
};

STD_ROM_PICK(Dinopic2)
STD_ROM_FN(Dinopic2)

static struct BurnRomInfo Dinopic3RomDesc[] = {
	// = dinopic but arranged differently
	{ "tk1-305_27c800.bin",     0x100000, 0xaa468337, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk1-204_27c800.bin",     0x100000, 0x0efd1ddb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tb416-02_27c160.bin",    0x200000, 0xbfd01d21, BRF_GRA | CPS1_TILES },
	{ "tb415-01_27c160.bin",	0x200000, 0xef508ec5, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",				0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",				0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",				0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",				0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",				0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "cd63b.1a",				0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",				0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",				0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",				0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",				0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",				0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",				0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",				0x000117, 0x6619c494, BRF_OPT },

	{ "ti-i_27c040.bin",		0x080000, 0x7d921309, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "1_palce20v8.bin",		0x000157, 0xcd99ca47, BRF_OPT },
	{ "2_palce20v8.bin",		0x000157, 0x60d016b9, BRF_OPT },
	{ "3_palce20v8.bin",		0x000157, 0x049b7f4f, BRF_OPT },
	{ "4_palce16v8.bin",		0x000117, 0x97a67c6d, BRF_OPT },
	{ "5_palce16v8.bin",		0x000117, 0x48253c66, BRF_OPT },
	{ "6_palce16v8.bin",		0x000117, 0x9ae375ba, BRF_OPT },
};

STD_ROM_PICK(Dinopic3)
STD_ROM_FN(Dinopic3)

static struct BurnRomInfo Dinopic4RomDesc[] = {
	{ "27c4000-m15377-a-5.bin",    	0x080000, 0x96dfcbf1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c4000-m15262-a-3.bin", 	0x080000, 0x13dfeb08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c4000-m15295-a-4.bin", 	0x080000, 0x6133f349, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c4000-m15263-a-1-2.bin", 	0x080000, 0x0e4058ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "27c4000-m15263-a-1-9.bin",  	0x080000, 0xf3c2c98d, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15262-a-8.bin",  	0x080000, 0xa0e1f6e0, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15279-a-7.bin",  	0x080000, 0x55ef0adc, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15279-a-6.bin",  	0x080000, 0xcc0805fc, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15013-b-1-13.bin",  0x080000, 0x1371f714, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15263-a-1-12.bin",  0x080000, 0xb284c4a7, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15377-a-11.bin",  	0x080000, 0xb7ad3394, BRF_GRA | CPS1_TILES },
	{ "27c4000-m15279-a-10.bin",  	0x080000, 0x88847705, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",					0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",					0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",					0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",					0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",					0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "cd63b.1a",					0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",					0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",					0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",					0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",					0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",					0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",					0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",					0x000117, 0x6619c494, BRF_OPT },

	{ "pic16c57-rc.bin",			0x001030, 0x4d262eaa, BRF_PRG | CPS1_PIC },

	{ "27c4000-m15388-a-1.bin",		0x080000, 0x7d921309, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "cat93c46p.bin",				0x000080, 0xd49fa351, BRF_OPT },
	{ "gal20v8a-1.bin",				0x000157, 0xcd99ca47, BRF_OPT },
	{ "gal20v8a-2.bin",				0x000157, 0x60d016b9, BRF_OPT },
	{ "gal20v8a-3.bin",				0x000157, 0x049b7f4f, BRF_OPT },
	{ "palce16v8h-1.bin",			0x000117, 0x48253c66, BRF_OPT },
	{ "palce16v8h-2.bin",			0x000117, 0x9ae375ba, BRF_OPT },
};

STD_ROM_PICK(Dinopic4)
STD_ROM_FN(Dinopic4)

static struct BurnRomInfo Dinopic5RomDesc[] = {
	{ "cad_28.bin",    0x040000, 0x97dc3d86, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cad_32.bin",    0x040000, 0x200a594f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cad_29.bin",    0x040000, 0x302303c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cad_33.bin",    0x040000, 0x5bf6deda, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cad_31.bin",    0x020000, 0xf0110c8a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cad_35.bin",    0x020000, 0xfbcf4314, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cad_30.bin",    0x020000, 0xbbcafc3b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "cad_34.bin",    0x020000, 0x481369b8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "cad_24.bin",    0x040000, 0xe59e0066, BRF_GRA | CPS1_TILES },
	{ "cad_20.bin",    0x040000, 0x779bffb2, BRF_GRA | CPS1_TILES },
	{ "cad_14.bin",    0x040000, 0x79b60fc5, BRF_GRA | CPS1_TILES },
	{ "cad_10.bin",    0x040000, 0x9d5b2ed4, BRF_GRA | CPS1_TILES },
	{ "cad_26.bin",    0x040000, 0x2db8cb57, BRF_GRA | CPS1_TILES },
	{ "cad_22.bin",    0x040000, 0xb58c4246, BRF_GRA | CPS1_TILES },
	{ "cad_16.bin",    0x040000, 0x569e5cf0, BRF_GRA | CPS1_TILES },
	{ "cad_12.bin",    0x040000, 0x33ed501d, BRF_GRA | CPS1_TILES },
	{ "cad_25.bin",    0x040000, 0x900b82b7, BRF_GRA | CPS1_TILES },
	{ "cad_21.bin",    0x040000, 0xd65ee299, BRF_GRA | CPS1_TILES },
	{ "cad_15.bin",    0x040000, 0xaa54f07c, BRF_GRA | CPS1_TILES },
	{ "cad_11.bin",    0x040000, 0x8594b5e8, BRF_GRA | CPS1_TILES },
	{ "cad_27.bin",    0x040000, 0x27492fde, BRF_GRA | CPS1_TILES },
	{ "cad_23.bin",    0x040000, 0xf07c16f2, BRF_GRA | CPS1_TILES },
	{ "cad_17.bin",    0x040000, 0x920df2fd, BRF_GRA | CPS1_TILES },
	{ "cad_13.bin",    0x040000, 0x07a564b4, BRF_GRA | CPS1_TILES },

	{ "cad_09.bin",    0x010000, 0x46546432, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cad_18.bin",    0x020000, 0xbd12c2ce, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "cad_19.bin",    0x020000, 0x9233de5a, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "pic16c57-rp",   0x000000, 0x00000000, BRF_PRG | BRF_NODUMP },
};

STD_ROM_PICK(Dinopic5)
STD_ROM_FN(Dinopic5)

static struct BurnRomInfo Jurassic99RomDesc[] = {
	{ "210204_rom2.bin",	0x100000, 0x3f713043, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "210105a_rom1.bin",	0x100000, 0xe6294edf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "210101a_cda2.bin",	0x200000, 0x3f167412, BRF_GRA | CPS1_TILES },
	{ "210102_cdb2.bin",	0x200000, 0x8a6920d8, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",			0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",			0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",			0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",			0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",			0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "cd63b.1a",			0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",			0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",			0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",			0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",			0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",			0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",			0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",			0x000117, 0x6619c494, BRF_OPT },

	{ "21003_u27.bin",		0x080000, 0x7d921309, BRF_SND | CPS1_OKIM6295_SAMPLES },

	{ "1_atf20v8.u25",		0x000157, 0xcd99ca47, BRF_OPT },
	{ "2_atf16v8.u66",		0x000117, 0x48253c66, BRF_OPT },
	{ "3_atf16v8.u100",		0x000117, 0x9ae375ba, BRF_OPT },
	{ "4_atf20v8.u118",		0x000157, 0x60d016b9, BRF_OPT },
	{ "5_atf20v8.u146",		0x000157, 0x049b7f4f, BRF_OPT },
	{ "6_atf16v8.u160",		0x000117, 0xb0f10adf, BRF_OPT },
	{ "8_atf16v8.u96g",		0x000117, 0x11f38ab7, BRF_OPT },
	{ "8_atf16v8.u97g",		0x000117, 0x11f38ab7, BRF_OPT },
	{ "8_atf16v8.u98g",		0x000117, 0x11f38ab7, BRF_OPT },
	{ "8_atf16v8.u99g",		0x000117, 0x11f38ab7, BRF_OPT },
	{ "8_atf16v8.u134g",	0x000117, 0x11f38ab7, BRF_OPT },
};

STD_ROM_PICK(Jurassic99)
STD_ROM_FN(Jurassic99)

static struct BurnRomInfo DinohRomDesc[] = {
	{ "cda_23h.rom",   0x080000, 0x8e2a9cf0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cda_22h.rom",   0x080000, 0xf72cd219, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cda_21h.rom",   0x080000, 0xbc275b76, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cda_20h.rom",   0x080000, 0x8987c975, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd_gfx01.rom",  0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd_gfx03.rom",  0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd_gfx02.rom",  0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd_gfx04.rom",  0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd_gfx05.rom",  0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd_gfx07.rom",  0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd_gfx06.rom",  0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd_gfx08.rom",  0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },
	
	// This doesn't work at all without the Q-Sound data present - does it really use Q-Sound??	
	{ "cd_q.rom",      0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd_q1.rom",     0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q2.rom",     0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q3.rom",     0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q4.rom",     0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Dinoh)
STD_ROM_FN(Dinoh)

static struct BurnRomInfo DinotRomDesc[] = {
	// This set is also known as Kl2d
	{ "kl2-r1.800",    0x100000, 0x4c70dca7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "kl2-l2.800",    0x100000, 0xc6ae7338, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd-a.160",      0x200000, 0x7e4f9fb3, BRF_GRA | CPS1_TILES },
	{ "cd-b.160",      0x200000, 0x89532d85, BRF_GRA | CPS1_TILES },
	
	{ "cd_q.rom",      0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd_q1.rom",     0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q2.rom",     0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q3.rom",     0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q4.rom",     0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Dinot)
STD_ROM_FN(Dinot)

static struct BurnRomInfo DinotpicRomDesc[] = {
	{ "cd-d.800",			0x100000, 0x2a7b2915, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cd-e.800",			0x100000, 0xe8370226, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd-a.160",			0x200000, 0x7e4f9fb3, BRF_GRA | CPS1_TILES },
	{ "cd-b.160",			0x200000, 0x89532d85, BRF_GRA | CPS1_TILES },

	{ "cd_q.5k",			0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd-q1.1k",			0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q2.2k",			0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q3.3k",			0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd-q4.4k",			0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "cd63b.1a",			0x000117, 0xef72e902, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",			0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",			0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",			0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",			0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",			0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",			0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",			0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Dinotpic)
STD_ROM_FN(Dinotpic)

static struct BurnRomInfo DinohuntRomDesc[] = {
	{ "u23",           0x080000, 0x8d5ddc5d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "u22",           0x080000, 0xf72cd219, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "u21",           0x080000, 0xbc275b76, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "u20",           0x080000, 0x8987c975, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "u1",            0x080000, 0xa01a9fb5, BRF_GRA | CPS1_TILES },
 	{ "u2",            0x080000, 0xbdf02c17, BRF_GRA | CPS1_TILES },
	{ "u3",            0x080000, 0x058beefa, BRF_GRA | CPS1_TILES },
	{ "u4",            0x080000, 0x5028a9f1, BRF_GRA | CPS1_TILES },
	{ "u5",            0x080000, 0xd77f89ea, BRF_GRA | CPS1_TILES },
	{ "u6",            0x080000, 0xbfbcb034, BRF_GRA | CPS1_TILES },
	{ "u7",            0x080000, 0xa2544d4e, BRF_GRA | CPS1_TILES },
	{ "u8",            0x080000, 0x8869bbb1, BRF_GRA | CPS1_TILES },

	{ "u9",            0x010000, 0x2eb16a83, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "u18",           0x020000, 0x8d2899ba, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "u19",           0x020000, 0xb34a4b42, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Dinohunt)
STD_ROM_FN(Dinohunt)

static struct BurnRomInfo DinoehRomDesc[] = {
	{ "dinoeh.23",     0x080000, 0xa6b88364, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cde_22a.rom",   0x080000, 0x9278aa12, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "dinoeh.21",     0x080000, 0xb89a0548, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd_gfx01.rom",  0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd_gfx03.rom",  0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd_gfx02.rom",  0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd_gfx04.rom",  0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd_gfx05.rom",  0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd_gfx07.rom",  0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd_gfx06.rom",  0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd_gfx08.rom",  0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "cd_q.rom",      0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd_q1.rom",     0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q2.rom",     0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q3.rom",     0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q4.rom",     0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Dinoeh)
STD_ROM_FN(Dinoeh)

static struct BurnRomInfo DinohcRomDesc[] = {
	{ "23",     	   0x080000, 0xcecf4b12, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22",   		   0x080000, 0x07eeb238, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "21",     	   0x080000, 0x3bc3d57a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1",  		   0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "2",  		   0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "3",  		   0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "4",  		   0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "5",  		   0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "6",  		   0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "7",  		   0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "8",  		   0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "9",     		   0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",     	   0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",     	   0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Dinohc)
STD_ROM_FN(Dinohc)

static struct BurnRomInfo DynwarRomDesc[] = {
	{ "30.11f",        0x020000, 0xf9ec6d68, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.11h",        0x020000, 0xe41fff2f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "31.12f",        0x020000, 0xe3de76ff, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "36.12h",        0x020000, 0x7a13cfbf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tkm-9.8h",      0x080000, 0x93654bcf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tkm-5.7a",      0x080000, 0xf64bb6a0, BRF_GRA | CPS1_TILES },
	{ "tkm-8.9a",      0x080000, 0x21fe6274, BRF_GRA | CPS1_TILES },
	{ "tkm-6.3a",      0x080000, 0x0bf228cb, BRF_GRA | CPS1_TILES },
	{ "tkm-7.5a",      0x080000, 0x1255dfb1, BRF_GRA | CPS1_TILES },
	{ "tkm-1.8a",      0x080000, 0x44f7661e, BRF_GRA | CPS1_TILES },
	{ "tkm-4.10a",     0x080000, 0xa54c515d, BRF_GRA | CPS1_TILES },
	{ "tkm-2.4a",      0x080000, 0xca5c687c, BRF_GRA | CPS1_TILES },
	{ "tkm-3.6a",      0x080000, 0xf9fe6591, BRF_GRA | CPS1_TILES },

	{ "tke_17.12b",    0x010000, 0xb3b79d4f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tke_18.11c",    0x020000, 0xac6e307d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "tke_19.12c",    0x020000, 0x068741db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "tk24b1.1a",     0x000117, 0xae4a7645, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Dynwar)
STD_ROM_FN(Dynwar)

static struct BurnRomInfo DynwaraRomDesc[] = {
	{ "tke_36.12f",    0x020000, 0x895991d1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tke_42.12h",    0x020000, 0xc898d2e8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tke_37.13f",    0x020000, 0xb228d58c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tke_43.13h",    0x020000, 0x1a14375a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "34.10f",        0x020000, 0x8f663d00, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "40.10h",        0x020000, 0x1586dbf3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.11f",        0x020000, 0x9db93d7a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41.11h",        0x020000, 0x1aae69a4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "09.4b",         0x020000, 0xc3e83c69, BRF_GRA | CPS1_TILES },
	{ "01.4a",         0x020000, 0x187b2886, BRF_GRA | CPS1_TILES },
	{ "13.9b",         0x020000, 0x0273d87d, BRF_GRA | CPS1_TILES },
	{ "05.9a",         0x020000, 0x339378b8, BRF_GRA | CPS1_TILES },
	{ "24.5e",         0x020000, 0xc6909b6f, BRF_GRA | CPS1_TILES },
	{ "17.5c",         0x020000, 0x2e2f8320, BRF_GRA | CPS1_TILES },
	{ "38.8h",         0x020000, 0xcd7923ed, BRF_GRA | CPS1_TILES },
	{ "32.8f",         0x020000, 0x21a0a453, BRF_GRA | CPS1_TILES },
	{ "10.5b",         0x020000, 0xff28f8d0, BRF_GRA | CPS1_TILES },
	{ "02.5a",         0x020000, 0xcc83c02f, BRF_GRA | CPS1_TILES },
	{ "14.10b",        0x020000, 0x58d9b32f, BRF_GRA | CPS1_TILES },
	{ "06.10a",        0x020000, 0x6f9edd75, BRF_GRA | CPS1_TILES },
	{ "25.7e",         0x020000, 0x152ea74a, BRF_GRA | CPS1_TILES },
	{ "18.7c",         0x020000, 0x1833f932, BRF_GRA | CPS1_TILES },
	{ "39.9h",         0x020000, 0xbc09b360, BRF_GRA | CPS1_TILES },
	{ "33.9f",         0x020000, 0x89de1533, BRF_GRA | CPS1_TILES },
	{ "11.7b",         0x020000, 0x29eaf490, BRF_GRA | CPS1_TILES },
	{ "03.7a",         0x020000, 0x7bf51337, BRF_GRA | CPS1_TILES },
	{ "15.11b",        0x020000, 0xd36cdb91, BRF_GRA | CPS1_TILES },
	{ "07.11a",        0x020000, 0xe04af054, BRF_GRA | CPS1_TILES },
	{ "26.8e",         0x020000, 0x07fc714b, BRF_GRA | CPS1_TILES },
	{ "19.8c",         0x020000, 0x7114e5c6, BRF_GRA | CPS1_TILES },
	{ "28.10e",        0x020000, 0xaf62bf07, BRF_GRA | CPS1_TILES },
	{ "21.10c",        0x020000, 0x523f462a, BRF_GRA | CPS1_TILES },
	{ "12.8b",         0x020000, 0x38652339, BRF_GRA | CPS1_TILES },
	{ "04.8a",         0x020000, 0x4951bc0f, BRF_GRA | CPS1_TILES },
	{ "16.12b",        0x020000, 0x381608ae, BRF_GRA | CPS1_TILES },
	{ "08.12a",        0x020000, 0xb475d4e9, BRF_GRA | CPS1_TILES },
	{ "27.9e",         0x020000, 0xa27e81fa, BRF_GRA | CPS1_TILES },
	{ "20.9c",         0x020000, 0x002796dc, BRF_GRA | CPS1_TILES },
	{ "29.11e",        0x020000, 0x6b41f82d, BRF_GRA | CPS1_TILES },
	{ "22.11c",        0x020000, 0x52145369, BRF_GRA | CPS1_TILES },

	{ "23.13c",        0x010000, 0xb3b79d4f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tke_30.12e",    0x020000, 0xac6e307d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "tke_31.13e",    0x020000, 0x068741db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "tk22b.1a",      0x000117, 0x1a1ab6d7, BRF_OPT },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Dynwara)
STD_ROM_FN(Dynwara)

static struct BurnRomInfo DynwarjRomDesc[] = {
	{ "36.12f",        0x020000, 0x1a516657, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "42.12h",        0x020000, 0x12a290a0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "37.13f",        0x020000, 0x932fc943, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "43.13h",        0x020000, 0x872ad76d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "34.10f",        0x020000, 0x8f663d00, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "40.10h",        0x020000, 0x1586dbf3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.11f",        0x020000, 0x9db93d7a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41.11h",        0x020000, 0x1aae69a4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "09.4b",         0x020000, 0xc3e83c69, BRF_GRA | CPS1_TILES },
	{ "01.4a",         0x020000, 0x187b2886, BRF_GRA | CPS1_TILES },
	{ "13.9b",         0x020000, 0x0273d87d, BRF_GRA | CPS1_TILES },
	{ "05.9a",         0x020000, 0x339378b8, BRF_GRA | CPS1_TILES },
	{ "24.5e",         0x020000, 0xc6909b6f, BRF_GRA | CPS1_TILES },
	{ "17.5c",         0x020000, 0x2e2f8320, BRF_GRA | CPS1_TILES },
	{ "38.8h",         0x020000, 0xcd7923ed, BRF_GRA | CPS1_TILES },
	{ "32.8f",         0x020000, 0x21a0a453, BRF_GRA | CPS1_TILES },
	{ "10.5b",         0x020000, 0xff28f8d0, BRF_GRA | CPS1_TILES },
	{ "02.5a",         0x020000, 0xcc83c02f, BRF_GRA | CPS1_TILES },
	{ "14.10b",        0x020000, 0x18fb232c, BRF_GRA | CPS1_TILES }, // 1 byte different from dynwara, pcb verified
	{ "06.10a",        0x020000, 0x6f9edd75, BRF_GRA | CPS1_TILES },
	{ "25.7e",         0x020000, 0x152ea74a, BRF_GRA | CPS1_TILES },
	{ "18.7c",         0x020000, 0x1833f932, BRF_GRA | CPS1_TILES },
	{ "39.9h",         0x020000, 0xbc09b360, BRF_GRA | CPS1_TILES },
	{ "33.9f",         0x020000, 0x89de1533, BRF_GRA | CPS1_TILES },
	{ "11.7b",         0x020000, 0x29eaf490, BRF_GRA | CPS1_TILES },
	{ "03.7a",         0x020000, 0x7bf51337, BRF_GRA | CPS1_TILES },
	{ "15.11b",        0x020000, 0xd36cdb91, BRF_GRA | CPS1_TILES },
	{ "07.11a",        0x020000, 0xe04af054, BRF_GRA | CPS1_TILES },
	{ "26.8e",         0x020000, 0x07fc714b, BRF_GRA | CPS1_TILES },
	{ "19.8c",         0x020000, 0x7114e5c6, BRF_GRA | CPS1_TILES },
	{ "28.10e",        0x020000, 0xaf62bf07, BRF_GRA | CPS1_TILES },
	{ "21.10c",        0x020000, 0x523f462a, BRF_GRA | CPS1_TILES },
	{ "12.8b",         0x020000, 0x38652339, BRF_GRA | CPS1_TILES },
	{ "04.8a",         0x020000, 0x4951bc0f, BRF_GRA | CPS1_TILES },
	{ "16.12b",        0x020000, 0x381608ae, BRF_GRA | CPS1_TILES },
	{ "08.12a",        0x020000, 0xb475d4e9, BRF_GRA | CPS1_TILES },
	{ "27.9e",         0x020000, 0xa27e81fa, BRF_GRA | CPS1_TILES },
	{ "20.9c",         0x020000, 0x002796dc, BRF_GRA | CPS1_TILES },
	{ "29.11e",        0x020000, 0x6b41f82d, BRF_GRA | CPS1_TILES },
	{ "22.11c",        0x020000, 0x52145369, BRF_GRA | CPS1_TILES },

	{ "23.13c",        0x010000, 0xb3b79d4f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "30.12e",        0x020000, 0x7e5f6cb4, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "31.13e",        0x020000, 0x4a30c737, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "tk22b.1a",      0x000117, 0x1a1ab6d7, BRF_OPT },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Dynwarj)
STD_ROM_FN(Dynwarj)

static struct BurnRomInfo DynwarjrRomDesc[] = {
	{ "tk1j_23.8f",    0x080000, 0x088a3009, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk1j_22.7f",    0x080000, 0x93654bcf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk1_01.3a",     0x080000, 0xf64bb6a0, BRF_GRA | CPS1_TILES },
	{ "tk1_02.4a",     0x080000, 0x21fe6274, BRF_GRA | CPS1_TILES },
	{ "tk1_03.5a",     0x080000, 0x0bf228cb, BRF_GRA | CPS1_TILES },
	{ "tk1_04.6a",     0x080000, 0x1255dfb1, BRF_GRA | CPS1_TILES },
	{ "tk1_05.7a",     0x080000, 0x44f7661e, BRF_GRA | CPS1_TILES },
	{ "tk1_06.8a",     0x080000, 0xa54c515d, BRF_GRA | CPS1_TILES },
	{ "tk1_07.9a",     0x080000, 0xca5c687c, BRF_GRA | CPS1_TILES },
	{ "tk1_08.10a",    0x080000, 0xf9fe6591, BRF_GRA | CPS1_TILES },

	{ "tk1_09.12a",    0x020000, 0xdb77d899, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk1_18.11c",    0x020000, 0x7e5f6cb4, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "tk1_19.12c",    0x020000, 0x4a30c737, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "tk163b.1a",     0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Dynwarjr)
STD_ROM_FN(Dynwarjr)

static struct BurnRomInfo FfightRomDesc[] = {
	{ "ff_36.11f",     0x020000, 0xf9a5ce83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_42.11h",     0x020000, 0x65f11215, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_37.12f",     0x020000, 0xe1033784, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffe_43.12h",    0x020000, 0x995e968a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },

	{ "ff_09.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Ffight)
STD_ROM_FN(Ffight)

static struct BurnRomInfo FfightaRomDesc[] = {
	{ "ffe_30.11f",    0x020000, 0x2347bf51, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffe_35.11h",    0x020000, 0x5f694ecc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffe_31.12f",    0x020000, 0x6dc6b792, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffe_36.12h",    0x020000, 0xb36a0b99, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },

	{ "ffe_23.12b",    0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffighta)
STD_ROM_FN(Ffighta)

static struct BurnRomInfo FfightuRomDesc[] = {
	{ "ff_36.11f",     0x020000, 0xf9a5ce83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_42.11h",     0x020000, 0x65f11215, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_37.12f",     0x020000, 0xe1033784, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_43.12h",    0x020000, 0x4ca65947, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },

	{ "ff_09.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Ffightu)
STD_ROM_FN(Ffightu)

static struct BurnRomInfo Ffightu1RomDesc[] = {
	{ "ff_36.11f",     0x020000, 0xf9a5ce83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_42.11h",     0x020000, 0x65f11215, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_37.12f",     0x020000, 0xe1033784, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_43.12h",    0x020000, 0x4ca65947, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_34.9f",      0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_40.9h",      0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_35.10f",     0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_41.10h",     0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },

	{ "ff_09.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Ffightu1)
STD_ROM_FN(Ffightu1)

static struct BurnRomInfo Ffightu2RomDesc[] = {
	{ "ffu_h0.12f",    0x020000, 0xf9a5ce83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_l0.12h",    0x020000, 0x65f11215, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_h1.13f",    0x020000, 0xe1033784, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_l1.13h",    0x020000, 0x4ca65947, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "34.10f",        0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "40.10h",        0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.11f",        0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "41.11h",        0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "09.4b",         0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "01.4a",     	   0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "13.9b",         0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "05.9a",         0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "24.5e",         0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "19.7c",         0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "38.8h",         0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES },
	{ "32.8f",         0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "10.5b",         0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "02.5a",         0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "14.10b",        0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "06.10a",        0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "25.7e",         0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "18.5c",         0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "39.9h",         0x020000, 0x9416b477, BRF_GRA | CPS1_TILES },
	{ "33.9f",         0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "s.13c",         0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "30.12e",        0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "31.13e",        0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x6d86b45e, BRF_OPT }, // b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightu2)
STD_ROM_FN(Ffightu2)

static struct BurnRomInfo FfightuaRomDesc[] = {
	{ "ffu_36.11f",    0x020000, 0xe2a48af9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // in "30" socket
	{ "ffu_42.11h",    0x020000, 0xf4bb480e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // in "35" socket
	{ "ffu_37.12f",    0x020000, 0xc371c667, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // in "31" socket
	{ "ffu_43.12h",    0x020000, 0x2f5771f9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // in "36" socket / different CRC from ffightu, ffightu1, pcb verified
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },
	
	{ "ff_09.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Ffightua)
STD_ROM_FN(Ffightua)

static struct BurnRomInfo FfightubRomDesc[] = {
	{ "ffu_30_3.11f",  0x020000, 0xe619eb30, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_35_3.11h",  0x020000, 0xbca85263, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_31_3.12f",  0x020000, 0x59abd207, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_36_3.12h",  0x020000, 0xdf46ece8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },

	{ "ff_09.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Ffightub)
STD_ROM_FN(Ffightub)

static struct BurnRomInfo FfightucRomDesc[] = {
	{ "ffu_30.11f",    0x020000, 0xed988977, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_35.11h",    0x020000, 0x07bf1c21, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_31.12f",    0x020000, 0xdba5a476, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffu_36.12h",    0x020000, 0x4d89f542, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff-32m.8h",     0x080000, 0xc747696e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff-5m.7a",      0x080000, 0x9c284108, BRF_GRA | CPS1_TILES },
	{ "ff-7m.9a",      0x080000, 0xa7584dfb, BRF_GRA | CPS1_TILES },
	{ "ff-1m.3a",      0x080000, 0x0b605e44, BRF_GRA | CPS1_TILES },
	{ "ff-3m.5a",      0x080000, 0x52291cd2, BRF_GRA | CPS1_TILES },

	{ "ff_23.12b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM }, // == ff_09.12b /* label is FF_23, pcb verified */

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s224b.1a",      0x000117, 0xcdc4413e, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Ffightuc)
STD_ROM_FN(Ffightuc)

static struct BurnRomInfo FfightjRomDesc[] = {
	{ "ff36.bin",      0x020000, 0xf9a5ce83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff42.bin",      0x020000, 0x65f11215, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff37.bin",      0x020000, 0xe1033784, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff43.bin",      0x020000, 0xb6dee1c3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_34.10f",    0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_40.10h",    0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_35.11f",    0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_41.11h",    0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ffj_09.4b",     0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "ffj_01.4a",     0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "ffj_13.9b",     0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "ffj_05.9a",     0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "ffj_24.5e",     0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "ffj_17.5c",     0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "ffj_38.8h",     0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES },
	{ "ffj_32.8f",     0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "ffj_10.5b",     0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "ffj_02.5a",     0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "ffj_14.10b",    0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "ffj_06.10a",    0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "ffj_25.7e",     0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "ffj_18.7c",     0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "ffj_39.9h",     0x020000, 0x9416b477, BRF_GRA | CPS1_TILES },
	{ "ffj_33.9f",     0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "ff_23.bin",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ffj_30.bin",    0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ffj_31.bin",    0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x6d86b45e, BRF_OPT }, // b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightj)
STD_ROM_FN(Ffightj)

static struct BurnRomInfo Ffightj1RomDesc[] = {
	{ "ffj_36.12f",    0x020000, 0xe2a48af9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_42.12h",    0x020000, 0xf4bb480e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_37.13f",    0x020000, 0xc371c667, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_43.13h",    0x020000, 0x6f81f194, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_34.10f",    0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_40.10h",    0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_35.11f",    0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_41.11h",    0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ffj_09.4b",     0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "ffj_01.4a",     0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "ffj_13.9b",     0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "ffj_05.9a",     0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "ffj_24.5e",     0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "ffj_17.5c",     0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "ffj_38.8h",     0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES },
	{ "ffj_32.8f",     0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "ffj_10.5b",     0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "ffj_02.5a",     0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "ffj_14.10b",    0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "ffj_06.10a",    0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "ffj_25.7e",     0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "ffj_18.7c",     0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "ffj_39.9h",     0x020000, 0x9416b477, BRF_GRA | CPS1_TILES },
	{ "ffj_33.9f",     0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "ff_23.13b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ffj_30.12c",    0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ffj_31.13c",    0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x6d86b45e, BRF_OPT }, // b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightj1)
STD_ROM_FN(Ffightj1)

static struct BurnRomInfo Ffightj2RomDesc[] = {
	{ "ffj_36a.12f",   0x020000, 0x088ed1c9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_42a.12h",   0x020000, 0xc4c491e6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_37a.13f",   0x020000, 0x708557ff, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_43a.13h",   0x020000, 0xc004004a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_34.10f",     0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_40.10h",     0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_35.11f",     0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_41.11h",     0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ff_09.4b",      0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "ff_01.4a",      0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "ff_13.9b",      0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "ff_05.9a",      0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "ff_24.5e",      0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "ff_17.5c",      0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "ff_38.8h",      0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES },
	{ "ff_32.8f",      0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "ff_10.5b",      0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "ff_02.5a",      0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "ff_14.10b",     0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "ff_06.10a",     0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "ff_25.7e",      0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "ff_18.7c",      0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "ff_39.9h",      0x020000, 0x9416b477, BRF_GRA | CPS1_TILES },
	{ "ff_33.9f",      0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "ff_23.13c",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_30.12e",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_31.13e",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x6d86b45e, BRF_OPT }, // b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightj2)
STD_ROM_FN(Ffightj2)

static struct BurnRomInfo Ffightj3RomDesc[] = {
	{ "ffj_36.12f",    0x020000, 0xe619eb30, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_42.12h",    0x020000, 0xbca85263, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_37.13f",    0x020000, 0xa8127e4e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_43.13h",    0x020000, 0x56ccd34a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_34.10f",    0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_40.10h",    0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_35.11f",    0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_41.11h",    0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ff_09.4b",      0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "ff_01.4a",      0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "ff_13.9b",      0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "ff_05.9a",      0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "ff_24.5e",      0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "ff_17.5c",      0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "ff_38.8h",      0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES },
	{ "ff_32.8f",      0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "ff_10.5b",      0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "ff_02.5a",      0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "ff_14.10b",     0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "ff_06.10a",     0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "ff_25.7e",      0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "ff_18.7c",      0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "ff_39.9h",      0x020000, 0x9416b477, BRF_GRA | CPS1_TILES },
	{ "ff_33.9f",      0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "ff_23.13b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ffj_30.12e",    0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ffj_31.13e",    0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x6d86b45e, BRF_OPT }, // b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightj3)
STD_ROM_FN(Ffightj3)

static struct BurnRomInfo Ffightj4RomDesc[] = {
	{ "ff_36.12f",     0x020000, 0xed988977, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_42.12h",    0x020000, 0x07bf1c21, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_37.13f",     0x020000, 0xdba5a476, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_43.13h",    0x020000, 0xfbeca028, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_34.10f",     0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_40.10h",    0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff_35.11f",     0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_41.11h",    0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ff_09.4b",      0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "ff_01.4a",      0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "ff_13.9b",      0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "ff_05.9a",      0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "ff_24.5e",      0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "ff_17.5c",      0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "ffj_38.8h",     0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES }, // == ff_38.8h 
	{ "ff_32.8f",      0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "ff_10.5b",      0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "ff_02.5a",      0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "ff_14.10b",     0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "ff_06.10a",     0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "ff_25.7e",      0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "ff_18.7c",      0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "ffj_39.9h",     0x020000, 0x9416b477, BRF_GRA | CPS1_TILES }, // == ff_39.9h
	{ "ff_33.9f",      0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "ff_23.13b",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_30.12c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_31.13c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x6d86b45e, BRF_OPT }, // b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightj4)
STD_ROM_FN(Ffightj4)

static struct BurnRomInfo FfightjhRomDesc[] = {
	{ "ff_23.8f",      0x080000, 0xae3dda7f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ff_22.7f",      0x080000, 0xb2d5a3aa, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ff_1.3a",       0x080000, 0x969d18e2, BRF_GRA | CPS1_TILES },
	{ "ff_2.4a",       0x080000, 0x02b59f99, BRF_GRA | CPS1_TILES },
	{ "ff_3.5a",       0x080000, 0x01d507ae, BRF_GRA | CPS1_TILES },
	{ "ff_4.6a",       0x080000, 0xf7c4ceb0, BRF_GRA | CPS1_TILES },

	{ "ff_9.12a",      0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ff_18.11c",     0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ff_19.12c",     0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "gal16v8a-15lp.1a", 0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Ffightjh)
STD_ROM_FN(Ffightjh)

static struct BurnRomInfo FfightblRomDesc[] = {
	{ "fg-e.bin",      0x080000, 0xf8ccf27e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "fg-f.bin",      0x080000, 0xd96c76b2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "fg-d.bin",      0x080000, 0x4303f863, BRF_GRA | CPS1_TILES },
	{ "fg-c.bin",      0x080000, 0xd1dfcd2d, BRF_GRA | CPS1_TILES },
	{ "fg-b.bin",      0x080000, 0x22f2c097, BRF_GRA | CPS1_TILES },
	{ "fg-a.bin",      0x080000, 0x16a89b2c, BRF_GRA | CPS1_TILES },
	
	{ "ff1.bin",       0x020000, 0x5b276c14, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Ffightbl)
STD_ROM_FN(Ffightbl)

static struct BurnRomInfo FfightblaRomDesc[] = {
	// This dump comes from another ffight bootleg. It contains same datas as ffightbl but reordered in smaller roms.
	// Almost identical to Final Crash except for ROMs 19, 21, 23 and 25.
	{ "9.bin",         0x020000, 0xc6854c91, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-e.bin
	{ "5.bin",         0x020000, 0x77f7c2b3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-f.bin
	{ "8.bin",         0x020000, 0x1895b3df, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-e.bin
	{ "4.bin",         0x020000, 0xbbd411ee, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-f.bin
	{ "7.bin",         0x020000, 0x5b23ebf2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP } ,// fg-e.bin
	{ "3.bin",         0x020000, 0xaba2aebe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-f.bin
	{ "6.bin",         0x020000, 0xd4bf37f6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-e.bin
	{ "2.bin",         0x020000, 0x07ac8f43, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // fg-f.bin

	{ "18.bin",        0x020000, 0xf1eee6d9, BRF_GRA | CPS1_TILES }, // fg-d.bin
	{ "20.bin",        0x020000, 0x675f4537, BRF_GRA | CPS1_TILES }, // fg-c.bin
	{ "22.bin",        0x020000, 0xdb8a32ac, BRF_GRA | CPS1_TILES }, // fg-b.bin
	{ "24.bin",        0x020000, 0xf4113e57, BRF_GRA | CPS1_TILES }, // fg-a.bin
	{ "10.bin",        0x020000, 0xd478853e, BRF_GRA | CPS1_TILES }, // fg-d.bin
	{ "12.bin",        0x020000, 0x25055642, BRF_GRA | CPS1_TILES }, // fg-c.bin
	{ "14.bin",        0x020000, 0xb77d0328, BRF_GRA | CPS1_TILES }, // fg-b.bin
	{ "16.bin",        0x020000, 0xea111a79, BRF_GRA | CPS1_TILES }, // fg-a.bin
	{ "ff-19.bin",     0x020000, 0x7bc03747, BRF_GRA | CPS1_TILES }, // fg-d.bin
	{ "ff-21.bin",     0x020000, 0x0c248e2b, BRF_GRA | CPS1_TILES }, // fg-c.bin
	{ "ff-23.bin",     0x020000, 0x53949d0e, BRF_GRA | CPS1_TILES }, // fg-b.bin
	{ "ff-25.bin",     0x020000, 0x8d34a67d, BRF_GRA | CPS1_TILES }, // fg-a.bin
	{ "11.bin",        0x020000, 0xd4457a60, BRF_GRA | CPS1_TILES }, // fg-d.bin
	{ "13.bin",        0x020000, 0x3b26a37d, BRF_GRA | CPS1_TILES }, // fg-c.bin
	{ "15.bin",        0x020000, 0x6d837e09, BRF_GRA | CPS1_TILES }, // fg-b.bin
	{ "17.bin",        0x020000, 0xc59a4d6c, BRF_GRA | CPS1_TILES }, // fg-a.bin

	{ "1.bin",         0x020000, 0x5b276c14, BRF_PRG | CPS1_Z80_PROGRAM }, // ff1.bin
};

STD_ROM_PICK(Ffightbla)
STD_ROM_FN(Ffightbla)

static struct BurnRomInfo FcrashRomDesc[] = {
	{ "9.bin",         0x020000, 0xc6854c91, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.bin",         0x020000, 0x77f7c2b3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "8.bin",         0x020000, 0x1895b3df, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.bin",         0x020000, 0xbbd411ee, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "7.bin",         0x020000, 0x5b23ebf2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",         0x020000, 0xaba2aebe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "6.bin",         0x020000, 0xd4bf37f6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",         0x020000, 0x07ac8f43, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "18.bin",        0x020000, 0xf1eee6d9, BRF_GRA | CPS1_TILES },
	{ "20.bin",        0x020000, 0x675f4537, BRF_GRA | CPS1_TILES },
	{ "22.bin",        0x020000, 0xdb8a32ac, BRF_GRA | CPS1_TILES },
	{ "24.bin",        0x020000, 0xf4113e57, BRF_GRA | CPS1_TILES },
	{ "10.bin",        0x020000, 0xd478853e, BRF_GRA | CPS1_TILES },
	{ "12.bin",        0x020000, 0x25055642, BRF_GRA | CPS1_TILES },
	{ "14.bin",        0x020000, 0xb77d0328, BRF_GRA | CPS1_TILES },
	{ "16.bin",        0x020000, 0xea111a79, BRF_GRA | CPS1_TILES },
	{ "19.bin",        0x020000, 0xb3aa1f48, BRF_GRA | CPS1_TILES },
	{ "21.bin",        0x020000, 0x04d175c9, BRF_GRA | CPS1_TILES },
	{ "23.bin",        0x020000, 0xe592ba4f, BRF_GRA | CPS1_TILES },
	{ "25.bin",        0x020000, 0xb89a740f, BRF_GRA | CPS1_TILES },
	{ "11.bin",        0x020000, 0xd4457a60, BRF_GRA | CPS1_TILES },
	{ "13.bin",        0x020000, 0x3b26a37d, BRF_GRA | CPS1_TILES },
	{ "15.bin",        0x020000, 0x6d837e09, BRF_GRA | CPS1_TILES },
	{ "17.bin",        0x020000, 0xc59a4d6c, BRF_GRA | CPS1_TILES },

	{ "1.bin",         0x020000, 0x5b276c14, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Fcrash)
STD_ROM_FN(Fcrash)

static struct BurnRomInfo ForgottnRomDesc[] = {
	{ "lw40.12f",      0x020000, 0x73e920b7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, /* Higher program numbers indicates a later revision */
	{ "lw41.12h",      0x020000, 0x58210b9e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, /* 1 byte difference: 0x66D4 == 0x0C versus 0x04 in lw15.12h below */
	{ "lw42.13f",      0x020000, 0xbea45994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw43.13h",      0x020000, 0x539b2339, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.10g",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, 

	{ "lw_2.2b",       0x020000, 0x4bd75fee, BRF_GRA | CPS1_TILES },
	{ "lw_1.2a",       0x020000, 0x65f41485, BRF_GRA | CPS1_TILES },
	{ "lw-08.9b",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw_18.5e",      0x020000, 0xb4b6241b, BRF_GRA | CPS1_TILES },
	{ "lw_17.5c",      0x020000, 0xc5eea115, BRF_GRA | CPS1_TILES },
	{ "lw_30.8h",      0x020000, 0xb385954e, BRF_GRA | CPS1_TILES },
	{ "lw_29.8f",      0x020000, 0x7bda1ac6, BRF_GRA | CPS1_TILES },
	{ "lw_4.3b",       0x020000, 0x50cf757f, BRF_GRA | CPS1_TILES },
	{ "lw_3.3a",       0x020000, 0xc03ef278, BRF_GRA | CPS1_TILES },
	{ "lw_20.7e",      0x020000, 0xdf1a3665, BRF_GRA | CPS1_TILES },
	{ "lw_19.7c",      0x020000, 0x15af8440, BRF_GRA | CPS1_TILES },
	{ "lw_32.9h",      0x020000, 0x30967a15, BRF_GRA | CPS1_TILES },
	{ "lw_31.9f",      0x020000, 0xc49d37fb, BRF_GRA | CPS1_TILES },
	{ "lw-02.6b",      0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw_14.10b",     0x020000, 0x82862cce, BRF_GRA | CPS1_TILES },
	{ "lw_13.10a",     0x020000, 0xb81c0e96, BRF_GRA | CPS1_TILES },
	{ "lw-06.9d",      0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw_26.10e",     0x020000, 0x57bcd032, BRF_GRA | CPS1_TILES },
	{ "lw_25.10c",     0x020000, 0xbac91554, BRF_GRA | CPS1_TILES },	
	{ "lw_16.11b",     0x020000, 0x40b26554, BRF_GRA | CPS1_TILES },
	{ "lw_15.11a",     0x020000, 0x1b7d2e07, BRF_GRA | CPS1_TILES },
	{ "lw_28.11e",     0x020000, 0xa805ad30, BRF_GRA | CPS1_TILES },
	{ "lw_27.11c",     0x020000, 0x103c1bd2, BRF_GRA | CPS1_TILES },
	
	{ "lw_37.13c",     0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.12e",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13e",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lw621.1a",      0x000117, 0x5eec6ce9, BRF_OPT },	// b-board PLDs
	{ "lwio.12b",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottn)
STD_ROM_FN(Forgottn)

static struct BurnRomInfo ForgottnaRomDesc[] = {
	{ "lw11.12f",      0x020000, 0x73e920b7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw15.12h",      0x020000, 0x50d7012d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw10.13f",      0x020000, 0xbea45994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw14.13h",      0x020000, 0x539b2339, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.10g",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },  

	{ "lw_2.2b",       0x020000, 0x4bd75fee, BRF_GRA | CPS1_TILES },
	{ "lw_1.2a",       0x020000, 0x65f41485, BRF_GRA | CPS1_TILES },
	{ "lw-08.9b",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.6d",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw_30.8h",      0x020000, 0xb385954e, BRF_GRA | CPS1_TILES },
	{ "lw_29.8f",      0x020000, 0x7bda1ac6, BRF_GRA | CPS1_TILES },
	{ "lw_4.3b",       0x020000, 0x50cf757f, BRF_GRA | CPS1_TILES },
	{ "lw_3.3a",       0x020000, 0xc03ef278, BRF_GRA | CPS1_TILES },
	{ "lw_32.9h",      0x020000, 0x30967a15, BRF_GRA | CPS1_TILES },
	{ "lw_31.9f",      0x020000, 0xc49d37fb, BRF_GRA | CPS1_TILES },
	{ "lw-02.6b",      0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw_14.10b",     0x020000, 0x82862cce, BRF_GRA | CPS1_TILES },
	{ "lw_13.10a",     0x020000, 0xb81c0e96, BRF_GRA | CPS1_TILES },
	{ "lw-06.9d",      0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw_26.10e",     0x020000, 0x57bcd032, BRF_GRA | CPS1_TILES },
	{ "lw_25.10c",     0x020000, 0xbac91554, BRF_GRA | CPS1_TILES },	
	{ "lw_16.11b",     0x020000, 0x40b26554, BRF_GRA | CPS1_TILES },
	{ "lw_15.11a",     0x020000, 0x1b7d2e07, BRF_GRA | CPS1_TILES },
	{ "lw_28.11e",     0x020000, 0xa805ad30, BRF_GRA | CPS1_TILES },
	{ "lw_27.11c",     0x020000, 0x103c1bd2, BRF_GRA | CPS1_TILES },
	
	{ "lw_00.13c",     0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.12e",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13e",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lw621.1a",      0x000117, 0x5eec6ce9, BRF_OPT },	// b-board PLDs
	{ "lwio.12b",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottna)
STD_ROM_FN(Forgottna)

static struct BurnRomInfo ForgottnuRomDesc[] = {
	{ "lw11c.12f",     0x020000, 0xe62742b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw15c.12h",     0x020000, 0x1b70f216, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw10c.13f",     0x020000, 0x8f5ea3f5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw14c.13h",     0x020000, 0x708e7472, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.10g",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw_2.2b",       0x020000, 0x4bd75fee, BRF_GRA | CPS1_TILES },
	{ "lw_1.2a",       0x020000, 0x65f41485, BRF_GRA | CPS1_TILES },
	{ "lw-08.9b",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.6d",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw_30.8h",      0x020000, 0xb385954e, BRF_GRA | CPS1_TILES },
	{ "lw_29.8f",      0x020000, 0x7bda1ac6, BRF_GRA | CPS1_TILES },
	{ "lw_4.3b",       0x020000, 0x50cf757f, BRF_GRA | CPS1_TILES },
	{ "lw_3.3a",       0x020000, 0xc03ef278, BRF_GRA | CPS1_TILES },
	{ "lw_32.9h",      0x020000, 0x30967a15, BRF_GRA | CPS1_TILES },
	{ "lw_31.9f",      0x020000, 0xc49d37fb, BRF_GRA | CPS1_TILES },
	{ "lw-02.6b",      0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw_14.10b",     0x020000, 0x82862cce, BRF_GRA | CPS1_TILES },
	{ "lw_13.10a",     0x020000, 0xb81c0e96, BRF_GRA | CPS1_TILES },
	{ "lw-06.9d",      0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.10d",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },
	{ "lw_16.11b",     0x020000, 0x40b26554, BRF_GRA | CPS1_TILES },
	{ "lw_15.11a",     0x020000, 0x1b7d2e07, BRF_GRA | CPS1_TILES },

	{ "lw_00.13c",     0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.12e",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13e",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lw621.1a",      0x000117, 0x5eec6ce9, BRF_OPT },	// b-board PLDs
	{ "lwio.12b",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottnu)
STD_ROM_FN(Forgottnu)

static struct BurnRomInfo ForgottnuaRomDesc[] = {
	{ "lwu_11a.14f",   0x020000, 0xddf78831, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lwu_15a.14g",   0x020000, 0xf7ce2097, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lwu_10a.13f",   0x020000, 0x8cb38c81, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lwu_14a.13g",   0x020000, 0xd70ef9fd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "lwu_00.14a",    0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.14c",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13c",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottnua)
STD_ROM_FN(Forgottnua)

static struct BurnRomInfo ForgottnuaaRomDesc[] = {
	{ "lwu_11aa.14f",  0x020000, 0x73e920b7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lwu_15aa.14g",  0x020000, 0xe47524b9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lwu_10aa.13f",  0x020000, 0xbea45994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lwu_14aa.13g",  0x020000, 0x539b2339, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "lwu_00.14a",    0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.14c",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13c",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottnuaa)
STD_ROM_FN(Forgottnuaa)

static struct BurnRomInfo ForgottnucRomDesc[] = {
	{ "lw11c.14f",     0x020000, 0xe62742b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw15c.14g",     0x020000, 0x1b70f216, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw10c.13f",     0x020000, 0x8f5ea3f5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw14c.13g",     0x020000, 0x708e7472, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "lw_00.14a",     0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.14c",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13c",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottnuc)
STD_ROM_FN(Forgottnuc)

static struct BurnRomInfo ForgottnueRomDesc[] = {
	{ "lw11e.14f",     0x020000, 0x82656910, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw15e.14g",     0x020000, 0xfb1e2bd0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw10e.13f",     0x020000, 0x3ce81dbe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw14e.13g",     0x020000, 0x472eaad1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "lw_00.14a",     0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.14c",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13c",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottnue)
STD_ROM_FN(Forgottnue)

static struct BurnRomInfo ForgottnjRomDesc[] = {
	/* comes from a PCB with a very early serial number:  LW00022 */
	{ "11.14f",        0x020000, 0xc9a6b319, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "15.14g",        0x020000, 0x524f920e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "10.13f",        0x020000, 0xff7e41d9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "14.13g",        0x020000, 0x80c3a813, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "00.14a",        0x010000, 0x3bc962ea, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03u.14c",    0x020000, 0x807d051f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04u.13c",    0x020000, 0xe6cd098e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Forgottnj)
STD_ROM_FN(Forgottnj)

static struct BurnRomInfo LostwrldRomDesc[] = {
	{ "lw_11c.14f",    0x020000, 0x67e42546, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw_15c.14g",    0x020000, 0x402e2a46, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw_10c.13f",    0x020000, 0xc46479d7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw_14c.13g",    0x020000, 0x97670f4a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "lw_00b.14a",    0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03.14c",     0x020000, 0xce2159e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04.13c",     0x020000, 0x39305536, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Lostwrld)
STD_ROM_FN(Lostwrld)

static struct BurnRomInfo LostwrldoRomDesc[] = {
	{ "lw_11.14f",     0x020000, 0x61e2cc56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw_15.14g",     0x020000, 0x8a0c18d3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw_10.13f",     0x020000, 0x23bca4d5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw_14.13g",     0x020000, 0x3a023771, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "lw-07.13e",     0x080000, 0xfd252a26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "lw-01.9d",      0x080000, 0x0318f298, BRF_GRA | CPS1_TILES },
	{ "lw-08.9f",      0x080000, 0x25a8e43c, BRF_GRA | CPS1_TILES },
	{ "lw-05.9e",      0x080000, 0xe4552fd7, BRF_GRA | CPS1_TILES },
	{ "lw-12.9g",      0x080000, 0x8e6a832b, BRF_GRA | CPS1_TILES },
	{ "lw-02.12d",     0x080000, 0x43e6c5c8, BRF_GRA | CPS1_TILES },
	{ "lw-09.12f",     0x080000, 0x899cb4ad, BRF_GRA | CPS1_TILES },
	{ "lw-06.12e",     0x080000, 0x5b9edffc, BRF_GRA | CPS1_TILES },
	{ "lw-13.12g",     0x080000, 0x8e058ef5, BRF_GRA | CPS1_TILES },

	{ "lw_00b.14a",    0x010000, 0x59df2a63, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "lw-03.14c",     0x020000, 0xce2159e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "lw-04.13c",     0x020000, 0x39305536, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "lwchr.3a",      0x000117, 0x54ed4c39, BRF_OPT },	// b-board PLDs
	{ "lwio.15e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Lostwrldo)
STD_ROM_FN(Lostwrldo)

static struct BurnRomInfo GanbareRomDesc[] = {
	{ "mrnj_23d.8f",   0x080000, 0xf929be72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mrnj_01.3a",    0x080000, 0x3f878020, BRF_GRA | CPS1_TILES },
	{ "mrnj_02.4a",    0x080000, 0x3e5624d8, BRF_GRA | CPS1_TILES },
	{ "mrnj_03.5a",    0x080000, 0xd1e61f96, BRF_GRA | CPS1_TILES },
	{ "mrnj_04.6a",    0x080000, 0xd241971b, BRF_GRA | CPS1_TILES },
	{ "mrnj_05.7a",    0x080000, 0xc0a14562, BRF_GRA | CPS1_TILES },
	{ "mrnj_06.8a",    0x080000, 0xe6a71dfc, BRF_GRA | CPS1_TILES },
	{ "mrnj_07.9a",    0x080000, 0x99afb6c7, BRF_GRA | CPS1_TILES },
	{ "mrnj_08.10a",   0x080000, 0x52882c20, BRF_GRA | CPS1_TILES },

	{ "mrnj_09.12a",   0x010000, 0x62470d72, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mrnj_18.11c",   0x020000, 0x08e13940, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "mrnj_19.12c",   0x020000, 0x5fa59927, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "m48t35y-70pc1.9n", 0x008000, 0x96107b4a, BRF_OPT }, // timekeeper internal ram - game overwrites it on init anyway
	
	A_BOARD_PLDS
	
	{ "gbpr2.1a",      0x000117, 0x486e8ca0, BRF_OPT }, // b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Ganbare)
STD_ROM_FN(Ganbare)

static struct BurnRomInfo GhoulsRomDesc[] = {
	{ "dme_29.10h",    0x020000, 0x166a58a2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dme_30.10j",    0x020000, 0x7ac8407a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dme_27.9h",     0x020000, 0xf734b2be, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dme_28.9j",     0x020000, 0x03d3e714, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dm-17.7j",      0x080000, 0x3ea1b0f2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "dm-05.3a",      0x080000, 0x0ba9c0b0, BRF_GRA | CPS1_TILES },
	{ "dm-07.3f",      0x080000, 0x5d760ab9, BRF_GRA | CPS1_TILES },
	{ "dm-06.3c",      0x080000, 0x4ba90b59, BRF_GRA | CPS1_TILES },
	{ "dm-08.3g",      0x080000, 0x4bdee9de, BRF_GRA | CPS1_TILES },
	{ "09.4a",         0x010000, 0xae24bb19, BRF_GRA | CPS1_TILES },
	{ "18.7a",         0x010000, 0xd34e271a, BRF_GRA | CPS1_TILES },
	{ "13.4e",         0x010000, 0x3f70dd37, BRF_GRA | CPS1_TILES },
	{ "22.7e",         0x010000, 0x7e69e2e6, BRF_GRA | CPS1_TILES },
	{ "11.4c",         0x010000, 0x37c9b6c6, BRF_GRA | CPS1_TILES },
	{ "20.7c",         0x010000, 0x2f1345b4, BRF_GRA | CPS1_TILES },
	{ "15.4g",         0x010000, 0x3c2a212a, BRF_GRA | CPS1_TILES },
	{ "24.7g",         0x010000, 0x889aac05, BRF_GRA | CPS1_TILES },
	{ "10.4b",         0x010000, 0xbcc0f28c, BRF_GRA | CPS1_TILES },
	{ "19.7b",         0x010000, 0x2a40166a, BRF_GRA | CPS1_TILES },
	{ "14.4f",         0x010000, 0x20f85c03, BRF_GRA | CPS1_TILES },
	{ "23.7f",         0x010000, 0x8426144b, BRF_GRA | CPS1_TILES },
	{ "12.4d",         0x010000, 0xda088d61, BRF_GRA | CPS1_TILES },
	{ "21.7d",         0x010000, 0x17e11df0, BRF_GRA | CPS1_TILES },
	{ "16.4h",         0x010000, 0xf187ba1c, BRF_GRA | CPS1_TILES },
	{ "25.7h",         0x010000, 0x29f79c78, BRF_GRA | CPS1_TILES },

	{ "26.10a",        0x010000, 0x3692f6e5, BRF_PRG | CPS1_Z80_PROGRAM },
	
	A_BOARD_PLDS
	
	{ "dm620.2a",      0x000117, 0xf6e5f727, BRF_OPT },	// b-board PLDs
	{ "lwio.8i",       0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ghouls)
STD_ROM_FN(Ghouls)

static struct BurnRomInfo GhoulsuRomDesc[] = {
	{ "dmu_29.10h",    0x020000, 0x334d85b2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmu_30.10j",    0x020000, 0xcee8ceb5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmu_27.9h",     0x020000, 0x4a524140, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmu_28.9j",     0x020000, 0x94aae205, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dm-17.7j",      0x080000, 0x3ea1b0f2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "dm-05.3a",      0x080000, 0x0ba9c0b0, BRF_GRA | CPS1_TILES },
	{ "dm-07.3f",      0x080000, 0x5d760ab9, BRF_GRA | CPS1_TILES },
	{ "dm-06.3c",      0x080000, 0x4ba90b59, BRF_GRA | CPS1_TILES },
	{ "dm-08.3g",      0x080000, 0x4bdee9de, BRF_GRA | CPS1_TILES },
	{ "09.4a",         0x010000, 0xae24bb19, BRF_GRA | CPS1_TILES },
	{ "18.7a",         0x010000, 0xd34e271a, BRF_GRA | CPS1_TILES },
	{ "13.4e",         0x010000, 0x3f70dd37, BRF_GRA | CPS1_TILES },
	{ "22.7e",         0x010000, 0x7e69e2e6, BRF_GRA | CPS1_TILES },
	{ "11.4c",         0x010000, 0x37c9b6c6, BRF_GRA | CPS1_TILES },
	{ "20.7c",         0x010000, 0x2f1345b4, BRF_GRA | CPS1_TILES },
	{ "15.4g",         0x010000, 0x3c2a212a, BRF_GRA | CPS1_TILES },
	{ "24.7g",         0x010000, 0x889aac05, BRF_GRA | CPS1_TILES },
	{ "10.4b",         0x010000, 0xbcc0f28c, BRF_GRA | CPS1_TILES },
	{ "19.7b",         0x010000, 0x2a40166a, BRF_GRA | CPS1_TILES },
	{ "14.4f",         0x010000, 0x20f85c03, BRF_GRA | CPS1_TILES },
	{ "23.7f",         0x010000, 0x8426144b, BRF_GRA | CPS1_TILES },
	{ "12.4d",         0x010000, 0xda088d61, BRF_GRA | CPS1_TILES },
	{ "21.7d",         0x010000, 0x17e11df0, BRF_GRA | CPS1_TILES },
	{ "16.4h",         0x010000, 0xf187ba1c, BRF_GRA | CPS1_TILES },
	{ "25.7h",         0x010000, 0x29f79c78, BRF_GRA | CPS1_TILES },

	{ "26.10a",        0x010000, 0x3692f6e5, BRF_PRG | CPS1_Z80_PROGRAM },
	
	A_BOARD_PLDS
	
	{ "dm620.2a",      0x000117, 0xf6e5f727, BRF_OPT },	// b-board PLDs
	{ "lwio.8i",       0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ghoulsu)
STD_ROM_FN(Ghoulsu)

static struct BurnRomInfo DaimakaiRomDesc[] = {
	{ "dmj_38.12f",    0x020000, 0x82fd1798, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmj_39.12h",    0x020000, 0x35366ccc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmj_40.13f",    0x020000, 0xa17c170a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmj_41.13h",    0x020000, 0x6af0b391, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dm_33.10f",     0x020000, 0x384d60c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dm_34.10h",     0x020000, 0x19abe30f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dm_35.11f",     0x020000, 0xc04b85c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dm_36.11h",     0x020000, 0x89be83de, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "dm_02.4b",      0x020000, 0x8b98dc48, BRF_GRA | CPS1_TILES },
	{ "dm_01.4a",      0x020000, 0x80896c33, BRF_GRA | CPS1_TILES },
	{ "dm_10.9b",      0x020000, 0xc2e7d9ef, BRF_GRA | CPS1_TILES },
	{ "dm_09.9a",      0x020000, 0xc9c4afa5, BRF_GRA | CPS1_TILES },
	{ "dm_18.5e",      0x020000, 0x1aa0db99, BRF_GRA | CPS1_TILES },
	{ "dm_17.5c",      0x020000, 0xdc6ed8ad, BRF_GRA | CPS1_TILES },
	{ "dm_30.8h",      0x020000, 0xd9d3f8bd, BRF_GRA | CPS1_TILES },
	{ "dm_29.8f",      0x020000, 0x49a48796, BRF_GRA | CPS1_TILES },
	{ "dm_04.5b",      0x020000, 0xa4f4f8f0, BRF_GRA | CPS1_TILES },
	{ "dm_03.5a",      0x020000, 0xb1033e62, BRF_GRA | CPS1_TILES },
	{ "dm_12.10b",     0x020000, 0x10fdd76a, BRF_GRA | CPS1_TILES },
	{ "dm_11.10a",     0x020000, 0x9040cb04, BRF_GRA | CPS1_TILES },
	{ "dm_20.7e",      0x020000, 0x281d0b3e, BRF_GRA | CPS1_TILES },
	{ "dm_19.7c",      0x020000, 0x2623b52f, BRF_GRA | CPS1_TILES },
	{ "dm_32.9h",      0x020000, 0x99692344, BRF_GRA | CPS1_TILES },
	{ "dm_31.9f",      0x020000, 0x54acb729, BRF_GRA | CPS1_TILES },
	{ "dm_06.7b",      0x010000, 0xae24bb19, BRF_GRA | CPS1_TILES },
	{ "dm_05.7a",      0x010000, 0xd34e271a, BRF_GRA | CPS1_TILES },
	{ "dm_14.11b",     0x010000, 0x3f70dd37, BRF_GRA | CPS1_TILES },
	{ "dm_13.11a",     0x010000, 0x7e69e2e6, BRF_GRA | CPS1_TILES },
	{ "dm_22.8e",      0x010000, 0x37c9b6c6, BRF_GRA | CPS1_TILES },
	{ "dm_21.8c",      0x010000, 0x2f1345b4, BRF_GRA | CPS1_TILES },
	{ "dm_26.10e",     0x010000, 0x3c2a212a, BRF_GRA | CPS1_TILES },
	{ "dm_25.10c",     0x010000, 0x889aac05, BRF_GRA | CPS1_TILES },
	{ "dm_08.8b",      0x010000, 0xbcc0f28c, BRF_GRA | CPS1_TILES },
	{ "dm_07.8a",      0x010000, 0x2a40166a, BRF_GRA | CPS1_TILES },
	{ "dm_16.12b",     0x010000, 0x20f85c03, BRF_GRA | CPS1_TILES },
	{ "dm_15.12a",     0x010000, 0x8426144b, BRF_GRA | CPS1_TILES },
	{ "dm_24.9e",      0x010000, 0xda088d61, BRF_GRA | CPS1_TILES },
	{ "dm_23.9c",      0x010000, 0x17e11df0, BRF_GRA | CPS1_TILES },
	{ "dm_28.11e",     0x010000, 0xf187ba1c, BRF_GRA | CPS1_TILES },
	{ "dm_27.11c",     0x010000, 0x29f79c78, BRF_GRA | CPS1_TILES },

	{ "37.13c",        0x010000, 0x3692f6e5, BRF_PRG | CPS1_Z80_PROGRAM },
	
	A_BOARD_PLDS
	
	{ "dm22a.1a",      0x000117, 0xd4776116, BRF_OPT }, // b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Daimakai)
STD_ROM_FN(Daimakai)

static struct BurnRomInfo DaimakairRomDesc[] = {
	{ "damj_23.8f",    0x080000, 0xc3b248ec, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "damj_22.7f",    0x080000, 0x595ff2f3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "dam_01.3a",     0x080000, 0x0ba9c0b0, BRF_GRA | CPS1_TILES },
	{ "dam_02.4a",     0x080000, 0x5d760ab9, BRF_GRA | CPS1_TILES },
	{ "dam_03.5a",     0x080000, 0x4ba90b59, BRF_GRA | CPS1_TILES },
	{ "dam_04.6a",     0x080000, 0x4bdee9de, BRF_GRA | CPS1_TILES },
	{ "dam_05.7a",     0x080000, 0x7dc61b94, BRF_GRA | CPS1_TILES },
	{ "dam_06.8a",     0x080000, 0xfde89758, BRF_GRA | CPS1_TILES },
	{ "dam_07.9a",     0x080000, 0xec351d78, BRF_GRA | CPS1_TILES },
	{ "dam_08.10a",    0x080000, 0xee2acc1e, BRF_GRA | CPS1_TILES },

	{ "dam_09.12a",    0x020000, 0x0656ff53, BRF_PRG | CPS1_Z80_PROGRAM },
	
	A_BOARD_PLDS
	
	{ "dam63b.1a",     0x000117, 0x474b3c8a, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Daimakair)
STD_ROM_FN(Daimakair)

static struct BurnRomInfo DaimakaibRomDesc[] = {
	{ "dmjb2.bin",     0x080000, 0x7d5f9f84, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "dmjb1.bin",     0x080000, 0x9b945cc4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	{ "dm_02.4b",      0x020000, 0x8b98dc48, BRF_GRA | CPS1_TILES },
	{ "dm_01.4a",      0x020000, 0x80896c33, BRF_GRA | CPS1_TILES },
	{ "dm_10.9b",      0x020000, 0xc2e7d9ef, BRF_GRA | CPS1_TILES },
	{ "dm_09.9a",      0x020000, 0xc9c4afa5, BRF_GRA | CPS1_TILES },
	{ "dm_18.5e",      0x020000, 0x1aa0db99, BRF_GRA | CPS1_TILES },
	{ "dm_17.5c",      0x020000, 0xdc6ed8ad, BRF_GRA | CPS1_TILES },
	{ "dm_30.8h",      0x020000, 0xd9d3f8bd, BRF_GRA | CPS1_TILES },
	{ "dm_29.8f",      0x020000, 0x49a48796, BRF_GRA | CPS1_TILES },
	{ "dm_04.5b",      0x020000, 0xa4f4f8f0, BRF_GRA | CPS1_TILES },
	{ "dm_03.5a",      0x020000, 0xb1033e62, BRF_GRA | CPS1_TILES },
	{ "dm_12.10b",     0x020000, 0x10fdd76a, BRF_GRA | CPS1_TILES },
	{ "dm_11.10a",     0x020000, 0x9040cb04, BRF_GRA | CPS1_TILES },
	{ "dm_20.7e",      0x020000, 0x281d0b3e, BRF_GRA | CPS1_TILES },
	{ "dm_19.7c",      0x020000, 0x2623b52f, BRF_GRA | CPS1_TILES },
	{ "dm_32.9h",      0x020000, 0x99692344, BRF_GRA | CPS1_TILES },
	{ "dm_31.9f",      0x020000, 0x54acb729, BRF_GRA | CPS1_TILES },
	{ "dm_06.7b",      0x010000, 0xae24bb19, BRF_GRA | CPS1_TILES },
	{ "dm_05.7a",      0x010000, 0xd34e271a, BRF_GRA | CPS1_TILES },
	{ "dm_14.11b",     0x010000, 0x3f70dd37, BRF_GRA | CPS1_TILES },
	{ "dm_13.11a",     0x010000, 0x7e69e2e6, BRF_GRA | CPS1_TILES },
	{ "dm_22.8e",      0x010000, 0x37c9b6c6, BRF_GRA | CPS1_TILES },
	{ "dm_21.8c",      0x010000, 0x2f1345b4, BRF_GRA | CPS1_TILES },
	{ "dm_26.10e",     0x010000, 0x3c2a212a, BRF_GRA | CPS1_TILES },
	{ "dm_25.10c",     0x010000, 0x889aac05, BRF_GRA | CPS1_TILES },
	{ "dm_08.8b",      0x010000, 0xbcc0f28c, BRF_GRA | CPS1_TILES },
	{ "dm_07.8a",      0x010000, 0x2a40166a, BRF_GRA | CPS1_TILES },
	{ "dm_16.12b",     0x010000, 0x20f85c03, BRF_GRA | CPS1_TILES },
	{ "dm_15.12a",     0x010000, 0x8426144b, BRF_GRA | CPS1_TILES },
	{ "dm_24.9e",      0x010000, 0xda088d61, BRF_GRA | CPS1_TILES },
	{ "dm_23.9c",      0x010000, 0x17e11df0, BRF_GRA | CPS1_TILES },
	{ "dm_28.11e",     0x010000, 0xf187ba1c, BRF_GRA | CPS1_TILES },
	{ "dm_27.11c",     0x010000, 0x29f79c78, BRF_GRA | CPS1_TILES },

	{ "dm_37.13c",     0x010000, 0x3692f6e5, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Daimakaib)
STD_ROM_FN(Daimakaib)

static struct BurnRomInfo GulunpaRomDesc[] = {
	{ "26",		0x20000, 0xf30ffa29, BRF_PRG | BRF_ESS | CPS1_68K_PROGRAM_BYTESWAP },
	{ "30",		0x20000, 0x5d35f737, BRF_PRG | BRF_ESS | CPS1_68K_PROGRAM_BYTESWAP },

	{ "1",		0x80000, 0xb55e648f, BRF_GRA | CPS1_TILES },
	{ "2",		0x80000, 0xad033bce, BRF_GRA | CPS1_TILES },
	{ "3",		0x80000, 0x36c3951a, BRF_GRA | CPS1_TILES },
	{ "4",		0x80000, 0xff0cb826, BRF_GRA | CPS1_TILES },

	{ "9",		0x10000, 0x15afd06f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",		0x20000, 0x9997a34f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",		0x20000, 0xe95270ac, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Gulunpa)
STD_ROM_FN(Gulunpa)

static struct BurnRomInfo MpumpkinRomDesc[] = {
	{ "mpa_23.8f",	0x080000, 0x38b9883a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mpa_01.3a",	0x080000, 0x7c8c0c22, BRF_GRA | CPS1_TILES },
	{ "mpa_02.4a",	0x080000, 0x23f95339, BRF_GRA | CPS1_TILES },
	{ "mpa_03.5a",	0x080000, 0x107842a6, BRF_GRA | CPS1_TILES },
	{ "mpa_04.6a",	0x080000, 0xfce457ae, BRF_GRA | CPS1_TILES },
	{ "mpa_05.7a",	0x080000, 0xba8f3585, BRF_GRA | CPS1_TILES },
	{ "mpa_06.8a",	0x080000, 0x037f20cc, BRF_GRA | CPS1_TILES },
	{ "mpa_07.9a",	0x080000, 0xba8f3585, BRF_GRA | CPS1_TILES },
	{ "mpa_08.10a",	0x080000, 0x037f20cc, BRF_GRA | CPS1_TILES },
	{ "mpa_10.3c",	0x080000, 0x870f3a2a, BRF_GRA | CPS1_TILES },
	{ "mpa_11.4c",	0x080000, 0x8923fc3a, BRF_GRA | CPS1_TILES },
	{ "mpa_12.5c",	0x080000, 0x87b88629, BRF_GRA | CPS1_TILES },
	{ "mpa_13.6c",  0x080000, 0xa09a6acf, BRF_GRA | CPS1_TILES },

	{ "mpa_09.12a",	0x010000, 0x0b5b1b72, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mpa_18.11c",	0x020000, 0xcef6d39e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "mpa_19.12c",	0x020000, 0x24947f8e, BRF_SND | CPS1_OKIM6295_SAMPLES },

	A_BOARD_PLDS

	{ "sfz63b.1a",	0x000104, 0xf5a351da, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",	0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",	0x000117, 0x31793da7, BRF_OPT },

	{ "ioc1.ic7",	0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",	0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Mpumpkin)
STD_ROM_FN(Mpumpkin)

static struct BurnRomInfo KnightsRomDesc[] = {
	{ "kr_23e.8f",     0x080000, 0x1b3997eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "kr_22.7f",      0x080000, 0xd0b671a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kr-5m.3a",      0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr-7m.5a",      0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr-1m.4a",      0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr-3m.6a",      0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr-6m.7a",      0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr-8m.9a",      0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr-2m.8a",      0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr-4m.10a",     0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "kr_09.11a",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_18.11c",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_19.12c",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kr63b.1a",      0x000117, 0xfd5b6522, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	
};

STD_ROM_PICK(Knights)
STD_ROM_FN(Knights)

static struct BurnRomInfo KnightsuRomDesc[] = {
	{ "kr_23u.8f",     0x080000, 0x252bc2ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "kr_22.7f",      0x080000, 0xd0b671a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kr-5m.3a",      0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr-7m.5a",      0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr-1m.4a",      0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr-3m.6a",      0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr-6m.7a",      0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr-8m.9a",      0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr-2m.8a",      0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr-4m.10a",     0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "kr_09.11a",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_18.11c",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_19.12c",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kr63b.1a",      0x000117, 0xfd5b6522, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	
};

STD_ROM_PICK(Knightsu)
STD_ROM_FN(Knightsu)

static struct BurnRomInfo KnightsjRomDesc[] = {
	{ "kr_23j.8f",     0x080000, 0xeae7417f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "kr_22.7f",      0x080000, 0xd0b671a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kr_01.3a",      0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr_02.4a",      0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr_03.5a",      0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr_04.6a",      0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr_05.7a",      0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr_06.8a",      0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr_07.9a",      0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr_08.10a",     0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "kr_09.12a",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_18.11c",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_19.12c",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kr63b.1a",      0x000117, 0xfd5b6522, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Knightsj)
STD_ROM_FN(Knightsj)

static struct BurnRomInfo KnightsjaRomDesc[] = {
	{ "krj_36.12f",    0x020000, 0xad3d1a8e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "krj_42.12h",    0x020000, 0xe694a491, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "krj_37.13f",    0x020000, 0x85596094, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "krj_43.13h",    0x020000, 0x9198bf8f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kr_34.10f",     0x020000, 0xfe6eb08d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kr_40.10h",     0x020000, 0x1172806d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kr_35.11f",     0x020000, 0xf854b020, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kr_41.11h",     0x020000, 0xeb52e78d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "kr_09.4b",      0x020000, 0x08b76e10, BRF_GRA | CPS1_TILES },
	{ "kr_01.4a",      0x020000, 0x40cecf5c, BRF_GRA | CPS1_TILES },
	{ "kr_13.9b",      0x020000, 0x435aaa03, BRF_GRA | CPS1_TILES },
	{ "kr_05.9a",      0x020000, 0x5b8a615b, BRF_GRA | CPS1_TILES },
	{ "kr_24.5e",      0x020000, 0xde65153e, BRF_GRA | CPS1_TILES },
	{ "kr_17.5c",      0x020000, 0xb171c968, BRF_GRA | CPS1_TILES },
	{ "kr_38.8h",      0x020000, 0xf4466bf4, BRF_GRA | CPS1_TILES },
	{ "kr_32.8f",      0x020000, 0x87380ddd, BRF_GRA | CPS1_TILES },
	{ "kr_10.5b",      0x020000, 0x37006d66, BRF_GRA | CPS1_TILES },
	{ "kr_02.5a",      0x020000, 0xb54612e3, BRF_GRA | CPS1_TILES },
	{ "kr_14.10b",     0x020000, 0x0ae88766, BRF_GRA | CPS1_TILES },
	{ "kr_06.10a",     0x020000, 0xecb1a09a, BRF_GRA | CPS1_TILES },
	{ "kr_25.7e",      0x020000, 0x9aace189, BRF_GRA | CPS1_TILES },
	{ "kr_18.7c",      0x020000, 0x09fa14a5, BRF_GRA | CPS1_TILES },
	{ "kr_39.9h",      0x020000, 0xfd8a9aeb, BRF_GRA | CPS1_TILES },
	{ "kr_33.9f",      0x020000, 0x11803e95, BRF_GRA | CPS1_TILES },
	{ "kr_11.7b",      0x020000, 0xa967ceb3, BRF_GRA | CPS1_TILES },
	{ "kr_03.7a",      0x020000, 0xea10db07, BRF_GRA | CPS1_TILES },
	{ "kr_15.11b",     0x020000, 0x8140b83b, BRF_GRA | CPS1_TILES },
	{ "kr_07.11a",     0x020000, 0x6af10648, BRF_GRA | CPS1_TILES },
	{ "kr_26.8e",      0x020000, 0x8865d86b, BRF_GRA | CPS1_TILES },
	{ "kr_19.8c",      0x020000, 0x029f4abe, BRF_GRA | CPS1_TILES },
	{ "kr_28.10e",     0x020000, 0x5f84f92f, BRF_GRA | CPS1_TILES },
	{ "kr_21.10c",     0x020000, 0x01b35065, BRF_GRA | CPS1_TILES },
	{ "kr_12.8b",      0x020000, 0x03d945b1, BRF_GRA | CPS1_TILES },
	{ "kr_04.8a",      0x020000, 0xe30c8388, BRF_GRA | CPS1_TILES },
	{ "kr_16.12b",     0x020000, 0x40c39d1b, BRF_GRA | CPS1_TILES },
	{ "kr_08.12a",     0x020000, 0xd310c9e8, BRF_GRA | CPS1_TILES },
	{ "kr_27.9e",      0x020000, 0x3e041444, BRF_GRA | CPS1_TILES },
	{ "kr_20.9c",      0x020000, 0xbd4bffb8, BRF_GRA | CPS1_TILES },
	{ "kr_29.11e",     0x020000, 0x1387a076, BRF_GRA | CPS1_TILES },
	{ "kr_22.11c",     0x020000, 0xfd351922, BRF_GRA | CPS1_TILES },
	
	{ "kr_23.13b",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_30.12c",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_31.13c",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kr22b.1a",      0x000117, 0xf15b2c0f, BRF_OPT }, // b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Knightsja)
STD_ROM_FN(Knightsja)

static struct BurnRomInfo KnightsbRomDesc[] = {
	{ "5.ic172",       0x040000, 0x7fd91118, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.ic173",       0x040000, 0xc9c6e720, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.ic176",       0x040000, 0xaf352703, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic175",       0x040000, 0x1eb91343, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	{ "kr_gfx1.rom",   0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr_gfx3.rom",   0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr_gfx2.rom",   0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx4.rom",   0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr_gfx5.rom",   0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr_gfx7.rom",   0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr_gfx6.rom",   0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx8.rom",   0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "1.ic26",        0x040000, 0xbd6f9cc1, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Knightsb)
STD_ROM_FN(Knightsb)

static struct BurnRomInfo Knightsb2RomDesc[] = {
	{ "left.code.040",                 0x080000, 0x95d00a7e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "right.code.040",                0x080000, 0x5a9d0b64, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "spe-a.japan9207d.mask1.801",    0x100000, 0x14a15fcd, BRF_GRA | CPS1_TILES },
	{ "spe-b.japan9207d.mask2.801",    0x100000, 0x250d2957, BRF_GRA | CPS1_TILES },
	{ "spe-c.japan9207d.mask4.801",    0x100000, 0x0721c26d, BRF_GRA | CPS1_TILES },
	{ "spe-d.japan9207d.mask3.801",    0x100000, 0xdb97f56a, BRF_GRA | CPS1_TILES },

	{ "sound.code.512",                0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "spe-e.japan9208d.snd.mask.020", 0x040000, 0x85f837a0, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Knightsb2)
STD_ROM_FN(Knightsb2)

static struct BurnRomInfo Knightsb3RomDesc[] = {
	{ "5.bin",           0x080000, 0xb818272c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",           0x080000, 0xb0b9a4c2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    	
	{ "svr-01.bin",      0x080000, 0xb08dc61f, BRF_GRA | CPS1_TILES },
	{ "svr-02.bin",      0x080000, 0xcca262aa, BRF_GRA | CPS1_TILES },
	{ "svr-03.bin",      0x080000, 0x1fe7056c, BRF_GRA | CPS1_TILES },
	{ "svr-04.bin",      0x080000, 0xb29ce7cf, BRF_GRA | CPS1_TILES },
	{ "svr-05.bin",      0x080000, 0x1c774671, BRF_GRA | CPS1_TILES },
	{ "svr-06.bin",      0x080000, 0x05463aa3, BRF_GRA | CPS1_TILES },
	{ "svr-07.bin",      0x080000, 0x87944aaa, BRF_GRA | CPS1_TILES },
	{ "svr-08.bin",      0x080000, 0xaa9d82fb, BRF_GRA | CPS1_TILES },

	{ "1.ic26",        	 0x040000, 0xbd6f9cc1, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "1_palce20v8.bin", 0x000157, 0xa5078c38, BRF_OPT },
	{ "2_palce16v8.bin", 0x000117, 0xbad3316b, BRF_OPT },
};

STD_ROM_PICK(Knightsb3)
STD_ROM_FN(Knightsb3)

static struct BurnRomInfo Knightsb4RomDesc[] = {
	{ "3.bin",         0x080000, 0xb818272c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",         0x080000, 0xb0b9a4c2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    	
	{ "kr_gfx1.rom",   0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr_gfx3.rom",   0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr_gfx2.rom",   0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx4.rom",   0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr_gfx5.rom",   0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr_gfx7.rom",   0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr_gfx6.rom",   0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx8.rom",   0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "1.bin",         0x040000, 0xbd6f9cc1, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Knightsb4)
STD_ROM_FN(Knightsb4)

static struct BurnRomInfo Knightsb5RomDesc[] = {
	{ "23.096",        0x080000, 0x7733b8a6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22.096",        0x080000, 0xd0b671a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.096",         0x080000, 0x91541596, BRF_GRA | CPS1_TILES },
	{ "2.096",         0x080000, 0x5d332114, BRF_GRA | CPS1_TILES },
	{ "3.096",         0x080000, 0x60488eba, BRF_GRA | CPS1_TILES },
	{ "4.096",         0x080000, 0x394bdd11, BRF_GRA | CPS1_TILES },
	{ "5.096",         0x080000, 0xb52af98b, BRF_GRA | CPS1_TILES },
	{ "6.096",         0x080000, 0xe44e5eac, BRF_GRA | CPS1_TILES },
	{ "7.096",         0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "8.096",         0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "9.512",         0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.010",        0x020000, 0x9b9be3ab, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.010",        0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Knightsb5)
STD_ROM_FN(Knightsb5)

static struct BurnRomInfo KnightshRomDesc[] = {
	{ "krh_23.rom",    0x080000, 0xfa2ff63d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "krh_22.rom",    0x080000, 0x1438d070, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kr_gfx1.rom",   0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr_gfx3.rom",   0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr_gfx2.rom",   0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx4.rom",   0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr_gfx5.rom",   0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr_gfx7.rom",   0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr_gfx6.rom",   0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx8.rom",   0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "kr_09.rom",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_18.rom",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_19.rom",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Knightsh)
STD_ROM_FN(Knightsh)

static struct BurnRomInfo Knightsh2RomDesc[] = {
	{ "krha_23.rom",   0x080000, 0xa7fd309a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "krh_22.rom",    0x080000, 0x1438d070, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kr_gfx1.rom",   0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr_gfx3.rom",   0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr_gfx2.rom",   0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx4.rom",   0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr_gfx5.rom",   0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr_gfx7.rom",   0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr_gfx6.rom",   0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx8.rom",   0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "kr_09.rom",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_18.rom",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_19.rom",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Knightsh2)
STD_ROM_FN(Knightsh2)

static struct BurnRomInfo KodRomDesc[] = {
	{ "kde_30a.11e",   0x020000, 0xfcb5efe2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_37a.11f",   0x020000, 0xf22e5266, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_31a.12e",   0x020000, 0xc710d722, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_38a.12f",   0x020000, 0x57d6ed3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_28.9e",      0x020000, 0x9367bcd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_35.9f",      0x020000, 0x4ca6a48a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_29.10e",     0x020000, 0x0360fa72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_36a.10f",    0x020000, 0x95a3cef8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "kd-5m.4a",      0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kd-7m.6a",      0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kd-1m.3a",      0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kd-3m.5a",      0x080000, 0x5e5303bf, BRF_GRA | CPS1_TILES },
	{ "kd-6m.4c",      0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kd-8m.6c",      0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kd-2m.3c",      0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kd-4m.5c",      0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "kd_9.12a",      0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kd_18.11c",     0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kd_19.12c",     0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kd29b.1a",      0x000117, 0x6b892f82, BRF_OPT }, // b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kod)
STD_ROM_FN(Kod)

static struct BurnRomInfo Kodr1RomDesc[] = {
	{ "kde_30.11e",    0x020000, 0xc7414fd4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_37.11f",    0x020000, 0xa5bf40d2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_31.12e",    0x020000, 0x1fffc7bd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_38.12f",    0x020000, 0x89e57a82, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_28.9e",     0x020000, 0x9367bcd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_35.9f",     0x020000, 0x4ca6a48a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_29.10e",    0x020000, 0x6a0ba878, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_36.10f",    0x020000, 0xb509b39d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "kd-5m.4a",      0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kd-7m.6a",      0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kd-1m.3a",      0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kd-3m.5a",      0x080000, 0x5e5303bf, BRF_GRA | CPS1_TILES },
	{ "kd-6m.4c",      0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kd-8m.6c",      0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kd-2m.3c",      0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kd-4m.5c",      0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "kd_9.12a",  	   0x010000, 0xf5514510, BRF_PRG | CPS1_Z80_PROGRAM }, // different CRC from kod, pcb verified

	{ "kd_18.11c", 	   0x020000, 0x69ecb2c8, BRF_SND | CPS1_OKIM6295_SAMPLES }, // different CRC from kod, pcb verified
	{ "kd_19.12c",     0x020000, 0x02d851c1, BRF_SND | CPS1_OKIM6295_SAMPLES }, // different CRC from kod, pcb verified
	
	A_BOARD_PLDS
	
	{ "kd29b.1a",      0x000117, 0x6b892f82, BRF_OPT }, // b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kodr1)
STD_ROM_FN(Kodr1)

static struct BurnRomInfo Kodr2RomDesc[] = {
	{ "kde_30.11e",    0x020000, 0xf8dc4ce3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_37.11f",    0x020000, 0xd1276c1c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_31.12e",    0x020000, 0x309debd8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kde_38.12f",    0x020000, 0x76cd5738, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_28.9e",      0x020000, 0x9367bcd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_35.9f",      0x020000, 0x4ca6a48a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_29.10e",     0x020000, 0x0360fa72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_36.10f",     0x020000, 0x3c66c32b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "kd-5m.4a",      0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kd-7m.6a",      0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kd-1m.3a",      0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kd-3m.5a",      0x080000, 0x5e5303bf, BRF_GRA | CPS1_TILES },
	{ "kd-6m.4c",      0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kd-8m.6c",      0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kd-2m.3c",      0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kd-4m.5c",      0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "kd_9.12a",  	   0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM }, 

	{ "kd_18.11c", 	   0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES }, 
	{ "kd_19.12c",     0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES }, 
	
	A_BOARD_PLDS
	
	{ "kd29b.1a",      0x000117, 0x6b892f82, BRF_OPT }, // b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kodr2)
STD_ROM_FN(Kodr2)

static struct BurnRomInfo KoduRomDesc[] = {
	{ "kdu_30b.11e",   0x020000, 0x825817f9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_37b.11f",   0x020000, 0xd2422dfb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_31b.12e",   0x020000, 0x9af36039, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_38b.12f",   0x020000, 0xbe8405a1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_28.9e",     0x020000, 0x9367bcd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_35.9f",     0x020000, 0x4ca6a48a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_29.10e",    0x020000, 0x0360fa72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdu_36a.10f",   0x020000, 0x95a3cef8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "kd-5m.4a",      0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kd-7m.6a",      0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kd-1m.3a",      0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kd-3m.5a",      0x080000, 0x5e5303bf, BRF_GRA | CPS1_TILES },
	{ "kd-6m.4c",      0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kd-8m.6c",      0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kd-2m.3c",      0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kd-4m.5c",      0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "kd_09.12a",     0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kd_18.11c",     0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kd_19.12c",     0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kd29b.1a",      0x000117, 0x6b892f82, BRF_OPT }, // b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kodu)
STD_ROM_FN(Kodu)

static struct BurnRomInfo KodjRomDesc[] = {
	{ "kdj_30a.11e",   0x020000, 0xebc788ad, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdj_37a.11f",   0x020000, 0xe55c3529, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdj_31a.12e",   0x020000, 0xc710d722, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdj_38a.12f",   0x020000, 0x57d6ed3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_33.6f",      0x080000, 0x9bd7ad4b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kd_06.8a",      0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kd_08.10a",     0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kd_05.7a",      0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kd_07.9a",      0x080000, 0x5e5303bf, BRF_GRA | CPS1_TILES },
	{ "kd_15.8c",      0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kd_17.10c",     0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kd_14.7c",      0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kd_16.9c",      0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "kd_09.12a",     0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kd_18.11c",     0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kd_19.12c",     0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kd29b.1a",      0x000117, 0x6b892f82, BRF_OPT }, // b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kodj)
STD_ROM_FN(Kodj)

static struct BurnRomInfo KodjaRomDesc[] = {
	{ "kdj_36a.12f",   0x020000, 0xebc788ad, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdj_42a.12h",   0x020000, 0xe55c3529, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdj_37a.13f",   0x020000, 0xc710d722, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kdj_43a.13h",   0x020000, 0x57d6ed3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_34.10f",     0x020000, 0x9367bcd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_40.10h",     0x020000, 0x4ca6a48a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_35.11f",     0x020000, 0x0360fa72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd_41a.11h",    0x020000, 0x95a3cef8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "kd_9.4b",       0x020000, 0x401a98e3, BRF_GRA | CPS1_TILES },
	{ "kd_1.4a",       0x020000, 0x5894399a, BRF_GRA | CPS1_TILES },
	{ "kd_13.9b",      0x020000, 0xb6685131, BRF_GRA | CPS1_TILES },
	{ "kd_5.9a",       0x020000, 0xc29b9ab3, BRF_GRA | CPS1_TILES },
	{ "kd_24.5e",      0x020000, 0x97008fdb, BRF_GRA | CPS1_TILES },
	{ "kd_17.5c",      0x020000, 0xdc9a83d3, BRF_GRA | CPS1_TILES },
	{ "kd_38.8h",      0x020000, 0x9c3dd2d1, BRF_GRA | CPS1_TILES },
	{ "kd_32.8f",      0x020000, 0x1b2a802a, BRF_GRA | CPS1_TILES },
	{ "kd_10.5b",      0x020000, 0xe788ae96, BRF_GRA | CPS1_TILES },
	{ "kd_2.5a",       0x020000, 0xb022e3e3, BRF_GRA | CPS1_TILES },
	{ "kd_14.10b",     0x020000, 0x4840c5ef, BRF_GRA | CPS1_TILES },
	{ "kd_6.10a",      0x020000, 0x519faee4, BRF_GRA | CPS1_TILES },
	{ "kd_25.7e",      0x020000, 0x5d0fa853, BRF_GRA | CPS1_TILES },
	{ "kd_18.7c",      0x020000, 0x6ad3b2bb, BRF_GRA | CPS1_TILES },
	{ "kd_39.9h",      0x020000, 0xd7920213, BRF_GRA | CPS1_TILES },
	{ "kd_33.9f",      0x020000, 0x65c2bed6, BRF_GRA | CPS1_TILES },
	{ "kd_11.7b",      0x020000, 0x147e3310, BRF_GRA | CPS1_TILES },
	{ "kd_3.7a",       0x020000, 0x5d18bc83, BRF_GRA | CPS1_TILES },
	{ "kd_15.11b",     0x020000, 0x57359746, BRF_GRA | CPS1_TILES },
	{ "kd_7.11a",      0x020000, 0x7fe03079, BRF_GRA | CPS1_TILES },
	{ "kd_26.8e",      0x020000, 0x57e5fab5, BRF_GRA | CPS1_TILES },
	{ "kd_19.8c",      0x020000, 0xb1f30f7c, BRF_GRA | CPS1_TILES },
	{ "kd_28.10e",     0x020000, 0x3a424135, BRF_GRA | CPS1_TILES },
	{ "kd_21.10c",     0x020000, 0xce10d2c3, BRF_GRA | CPS1_TILES },
	{ "kd_12.8b",      0x020000, 0xa6042aa2, BRF_GRA | CPS1_TILES },
	{ "kd_4.8a",       0x020000, 0x0ce0ba30, BRF_GRA | CPS1_TILES },
	{ "kd_16.12b",     0x020000, 0x63dcb7e0, BRF_GRA | CPS1_TILES },
	{ "kd_8.12a",      0x020000, 0xc69b77ae, BRF_GRA | CPS1_TILES },
	{ "kd_27.9e",      0x020000, 0x40d7bfed, BRF_GRA | CPS1_TILES },
	{ "kd_20.9c",      0x020000, 0x01c1f399, BRF_GRA | CPS1_TILES },
	{ "kd_29.11e",     0x020000, 0xa1eeac03, BRF_GRA | CPS1_TILES },
	{ "kd_22.11c",     0x020000, 0x5ade98eb, BRF_GRA | CPS1_TILES },

	{ "kd_23.13b",     0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kd_30.12c",     0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kd_31.13c",     0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "kd22b.1a",      0x000117, 0xbd1a6035, BRF_OPT }, // b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kodja)
STD_ROM_FN(Kodja)

static struct BurnRomInfo KodbRomDesc[] = {
	{ "3.ic172",       0x080000, 0x036dd74c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.ic171",       0x080000, 0x3e4b7295, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cp.ic90",       0x080000, 0xe3b8589e, BRF_GRA | CPS1_TILES },
	{ "dp.ic89",       0x080000, 0x3eec9580, BRF_GRA | CPS1_TILES },
	{ "ap.ic88",       0x080000, 0xfdf5f163, BRF_GRA | CPS1_TILES },
	{ "bp.ic87",       0x080000, 0x4e1c52b7, BRF_GRA | CPS1_TILES },
	{ "ci.ic91",       0x080000, 0x22228bc5, BRF_GRA | CPS1_TILES },
	{ "di.ic92",       0x080000, 0xab031763, BRF_GRA | CPS1_TILES },
	{ "ai.ic93",       0x080000, 0xcffbf4be, BRF_GRA | CPS1_TILES },
	{ "bi.ic94",       0x080000, 0x4a1b43fe, BRF_GRA | CPS1_TILES },

	{ "1.ic28",        0x010000, 0x01cae60c, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "2.ic19",        0x040000, 0xa2db1575, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Kodb)
STD_ROM_FN(Kodb)

static struct BurnRomInfo KodhRomDesc[] = {
	{ "23.096",        0x080000, 0xdaf89cfb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22.096",        0x080000, 0xc83e19d8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.096",         0x080000, 0x09261881, BRF_GRA | CPS1_TILES },
	{ "2.096",         0x080000, 0xbc121ff2, BRF_GRA | CPS1_TILES },
	{ "3.096",         0x080000, 0xf463ae22, BRF_GRA | CPS1_TILES },
	{ "4.096",         0x080000, 0x01308733, BRF_GRA | CPS1_TILES },
	{ "5.096",     	   0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "6.096",         0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "7.096",         0x080000, 0xc7ab4704, BRF_GRA | CPS1_TILES },
	{ "8.096",     	   0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "9.096",         0x010000, 0xf5514510, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.096",        0x020000, 0x69ecb2c8, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.096",        0x020000, 0x02d851c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Kodh)
STD_ROM_FN(Kodh)

// King Of Dragons 910731 ETC Phoenix set

static struct BurnRomInfo KoddaRomDesc[] = {
	{ "8f",            0x080000, 0x0a6ab826, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "7f",            0x080000, 0x9bd7ad4b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	
	{ "kd-5m.4a",      0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kd-7m.6a",      0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kd-1m.3a",      0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kdda-7m.6a",    0x080000, 0x0e2cb76f, BRF_GRA | CPS1_TILES },
	{ "kd-6m.4c",      0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kd-8m.6c",      0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kd-2m.3c",      0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kd-4m.5c",      0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },
	
	{ "kd_9.12a",      0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kd_18.11c",     0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kd_19.12c",     0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
#if !defined (ROM_VERIFY)
	{ "kd29b.1a",      0x000117, 0xcc4866ff, BRF_OPT }, // b-board PLDs
#else
	{ "kd29b.1a",      0x000117, 0x00000000, BRF_OPT | BRF_NODUMP }, // b-board PLDs
#endif
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Kodda)
STD_ROM_FN(Kodda)

static struct BurnRomInfo MegamanRomDesc[] = {
	{ "rcmu_23b.8f",   0x080000, 0x1cd33c7a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "rcmu_22b.7f",   0x080000, 0x708268c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "rcmu_21a.6f",   0x080000, 0x4376ea95, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "rcm_01.3a",     0x080000, 0x6ecdf13f, BRF_GRA | CPS1_TILES },
	{ "rcm_02.4a",     0x080000, 0x944d4f0f, BRF_GRA | CPS1_TILES },
	{ "rcm_03.5a",     0x080000, 0x36f3073c, BRF_GRA | CPS1_TILES },
	{ "rcm_04.6a",     0x080000, 0x54e622ff, BRF_GRA | CPS1_TILES },
	{ "rcm_05.7a",     0x080000, 0x5dd131fd, BRF_GRA | CPS1_TILES },
	{ "rcm_06.8a",     0x080000, 0xf0faf813, BRF_GRA | CPS1_TILES },
	{ "rcm_07.9a",     0x080000, 0x826de013, BRF_GRA | CPS1_TILES },
	{ "rcm_08.10a",    0x080000, 0xfbff64cf, BRF_GRA | CPS1_TILES },
	{ "rcm_10.3c",     0x080000, 0x4dc8ada9, BRF_GRA | CPS1_TILES },
	{ "rcm_11.4c",     0x080000, 0xf2b9ee06, BRF_GRA | CPS1_TILES },
	{ "rcm_12.5c",     0x080000, 0xfed5f203, BRF_GRA | CPS1_TILES },
	{ "rcm_13.6c",     0x080000, 0x5069d4a9, BRF_GRA | CPS1_TILES },
	{ "rcm_14.7c",     0x080000, 0x303be3bd, BRF_GRA | CPS1_TILES },
	{ "rcm_15.8c",     0x080000, 0x4f2d372f, BRF_GRA | CPS1_TILES },
	{ "rcm_16.9c",     0x080000, 0x93d97fde, BRF_GRA | CPS1_TILES },
	{ "rcm_17.10c",    0x080000, 0x92371042, BRF_GRA | CPS1_TILES },

	{ "rcm_09.11a",    0x010000, 0x22ac8f5f, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "rcm_18.11c",    0x020000, 0x80f1f8aa, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rcm_19.12c",    0x020000, 0xf257dbe1, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rcm63b.1a",     0x000117, 0x84acd494, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Megaman)
STD_ROM_FN(Megaman)

static struct BurnRomInfo MegamanaRomDesc[] = {
	{ "rcma_23b.8f",   0x080000, 0x61e4a397, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "rcma_22b.7f",   0x080000, 0x708268c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "rcma_21a.6f",   0x080000, 0x4376ea95, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "rcm_01.3a",     0x080000, 0x6ecdf13f, BRF_GRA | CPS1_TILES },
	{ "rcm_02.4a",     0x080000, 0x944d4f0f, BRF_GRA | CPS1_TILES },
	{ "rcm_03.5a",     0x080000, 0x36f3073c, BRF_GRA | CPS1_TILES },
	{ "rcm_04.6a",     0x080000, 0x54e622ff, BRF_GRA | CPS1_TILES },
	{ "rcm_05.7a",     0x080000, 0x5dd131fd, BRF_GRA | CPS1_TILES },
	{ "rcm_06.8a",     0x080000, 0xf0faf813, BRF_GRA | CPS1_TILES },
	{ "rcm_07.9a",     0x080000, 0x826de013, BRF_GRA | CPS1_TILES },
	{ "rcm_08.10a",    0x080000, 0xfbff64cf, BRF_GRA | CPS1_TILES },
	{ "rcm_10.3c",     0x080000, 0x4dc8ada9, BRF_GRA | CPS1_TILES },
	{ "rcm_11.4c",     0x080000, 0xf2b9ee06, BRF_GRA | CPS1_TILES },
	{ "rcm_12.5c",     0x080000, 0xfed5f203, BRF_GRA | CPS1_TILES },
	{ "rcm_13.6c",     0x080000, 0x5069d4a9, BRF_GRA | CPS1_TILES },
	{ "rcm_14.7c",     0x080000, 0x303be3bd, BRF_GRA | CPS1_TILES },
	{ "rcm_15.8c",     0x080000, 0x4f2d372f, BRF_GRA | CPS1_TILES },
	{ "rcm_16.9c",     0x080000, 0x93d97fde, BRF_GRA | CPS1_TILES },
	{ "rcm_17.10c",    0x080000, 0x92371042, BRF_GRA | CPS1_TILES },

	{ "rcm_09.12a",    0x020000, 0x9632d6ef, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "rcm_18.11c",    0x020000, 0x80f1f8aa, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rcm_19.12c",    0x020000, 0xf257dbe1, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rcm63b.1a",     0x000117, 0x84acd494, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Megamana)
STD_ROM_FN(Megamana)

static struct BurnRomInfo RockmanjRomDesc[] = {
	{ "rcm_23a.8f",    0x080000, 0xefd96cb2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "rcm_22a.7f",    0x080000, 0x8729a689, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "rcm_21a.6f",    0x080000, 0x517ccde2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "rcm_01.3a",     0x080000, 0x6ecdf13f, BRF_GRA | CPS1_TILES },
	{ "rcm_02.4a",     0x080000, 0x944d4f0f, BRF_GRA | CPS1_TILES },
	{ "rcm_03.5a",     0x080000, 0x36f3073c, BRF_GRA | CPS1_TILES },
	{ "rcm_04.6a",     0x080000, 0x54e622ff, BRF_GRA | CPS1_TILES },
	{ "rcm_05.7a",     0x080000, 0x5dd131fd, BRF_GRA | CPS1_TILES },
	{ "rcm_06.8a",     0x080000, 0xf0faf813, BRF_GRA | CPS1_TILES },
	{ "rcm_07.9a",     0x080000, 0x826de013, BRF_GRA | CPS1_TILES },
	{ "rcm_08.10a",    0x080000, 0xfbff64cf, BRF_GRA | CPS1_TILES },
	{ "rcm_10.3c",     0x080000, 0x4dc8ada9, BRF_GRA | CPS1_TILES },
	{ "rcm_11.4c",     0x080000, 0xf2b9ee06, BRF_GRA | CPS1_TILES },
	{ "rcm_12.5c",     0x080000, 0xfed5f203, BRF_GRA | CPS1_TILES },
	{ "rcm_13.6c",     0x080000, 0x5069d4a9, BRF_GRA | CPS1_TILES },
	{ "rcm_14.7c",     0x080000, 0x303be3bd, BRF_GRA | CPS1_TILES },
	{ "rcm_15.8c",     0x080000, 0x4f2d372f, BRF_GRA | CPS1_TILES },
	{ "rcm_16.9c",     0x080000, 0x93d97fde, BRF_GRA | CPS1_TILES },
	{ "rcm_17.10c",    0x080000, 0x92371042, BRF_GRA | CPS1_TILES },

	{ "rcm_09.12a",    0x020000, 0x9632d6ef, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "rcm_18.11c",    0x020000, 0x80f1f8aa, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "rcm_19.12c",    0x020000, 0xf257dbe1, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "rcm63b.1a",     0x000117, 0x84acd494, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Rockmanj)
STD_ROM_FN(Rockmanj)

static struct BurnRomInfo MercsRomDesc[] = {
	{ "so2_30e.11f",   0x020000, 0xe17f9bf7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_35e.11h",   0x020000, 0x78e63575, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_31e.12f",   0x020000, 0x51204d36, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_36e.12h",   0x020000, 0x9cfba8b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2-32m.8h",    0x080000, 0x2eb5cf0c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "so2-6m.8a",     0x080000, 0xaa6102af, BRF_GRA | CPS1_TILES },
	{ "so2-8m.10a",    0x080000, 0x839e6869, BRF_GRA | CPS1_TILES },
	{ "so2-2m.4a",     0x080000, 0x597c2875, BRF_GRA | CPS1_TILES },
	{ "so2-4m.6a",     0x080000, 0x912a9ca0, BRF_GRA | CPS1_TILES },
	{ "so2_24.7d",     0x020000, 0x3f254efe, BRF_GRA | CPS1_TILES },
	{ "so2_14.7c",     0x020000, 0xf5a8905e, BRF_GRA | CPS1_TILES },
	{ "so2_26.9d",     0x020000, 0xf3aa5a4a, BRF_GRA | CPS1_TILES },
	{ "so2_16.9c",     0x020000, 0xb43cd1a8, BRF_GRA | CPS1_TILES },
	{ "so2_20.3d",     0x020000, 0x8ca751a3, BRF_GRA | CPS1_TILES },
	{ "so2_10.3c",     0x020000, 0xe9f569fd, BRF_GRA | CPS1_TILES },
	{ "so2_22.5d",     0x020000, 0xfce9a377, BRF_GRA | CPS1_TILES },
	{ "so2_12.5c",     0x020000, 0xb7df8a06, BRF_GRA | CPS1_TILES },

	{ "so2_09.12b",    0x010000, 0xd09d7c7a, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "so2_18.11c",    0x020000, 0xbbea1643, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "so2_19.12c",    0x020000, 0xac58aa71, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "o224b.1a",      0x000117, 0xc211c8cd, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c628",          0x000117, 0x662e090f, BRF_OPT }, // c-board PLDs
};

STD_ROM_PICK(Mercs)
STD_ROM_FN(Mercs)

static struct BurnRomInfo MercsuRomDesc[] = {
	{ "so2_30a.11f",   0x020000, 0xe4e725d7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_35a.11h",   0x020000, 0xe7843445, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_31a.12f",   0x020000, 0xc0b91dea, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_36a.12h",   0x020000, 0x591edf6c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2-32m.8h",    0x080000, 0x2eb5cf0c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "so2-6m.8a",     0x080000, 0xaa6102af, BRF_GRA | CPS1_TILES },
	{ "so2-8m.10a",    0x080000, 0x839e6869, BRF_GRA | CPS1_TILES },
	{ "so2-2m.4a",     0x080000, 0x597c2875, BRF_GRA | CPS1_TILES },
	{ "so2-4m.6a",     0x080000, 0x912a9ca0, BRF_GRA | CPS1_TILES },
	{ "so2_24.7d",     0x020000, 0x3f254efe, BRF_GRA | CPS1_TILES },
	{ "so2_14.7c",     0x020000, 0xf5a8905e, BRF_GRA | CPS1_TILES },
	{ "so2_26.9d",     0x020000, 0xf3aa5a4a, BRF_GRA | CPS1_TILES },
	{ "so2_16.9c",     0x020000, 0xb43cd1a8, BRF_GRA | CPS1_TILES },
	{ "so2_20.3d",     0x020000, 0x8ca751a3, BRF_GRA | CPS1_TILES },
	{ "so2_10.3c",     0x020000, 0xe9f569fd, BRF_GRA | CPS1_TILES },
	{ "so2_22.5d",     0x020000, 0xfce9a377, BRF_GRA | CPS1_TILES },
	{ "so2_12.5c",     0x020000, 0xb7df8a06, BRF_GRA | CPS1_TILES },

	{ "so2_09.12b",    0x010000, 0xd09d7c7a, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "so2_18.11c",    0x020000, 0xbbea1643, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "so2_19.12c",    0x020000, 0xac58aa71, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "o224b.1a",      0x000117, 0xc211c8cd, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c628",          0x000117, 0x662e090f, BRF_OPT }, // c-board PLDs
};

STD_ROM_PICK(Mercsu)
STD_ROM_FN(Mercsu)

static struct BurnRomInfo Mercsur1RomDesc[] = {
	{ "so2_30.11f",    0x020000, 0xe17f9bf7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_35.11h",    0x020000, 0x4477df61, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_31.12f",    0x020000, 0x51204d36, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_36.12h",    0x020000, 0x9cfba8b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2-32m.8h",    0x080000, 0x2eb5cf0c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "so2-6m.8a",     0x080000, 0xaa6102af, BRF_GRA | CPS1_TILES },
	{ "so2-8m.10a",    0x080000, 0x839e6869, BRF_GRA | CPS1_TILES },
	{ "so2-2m.4a",     0x080000, 0x597c2875, BRF_GRA | CPS1_TILES },
	{ "so2-4m.6a",     0x080000, 0x912a9ca0, BRF_GRA | CPS1_TILES },
	{ "so2_24.7d",     0x020000, 0x3f254efe, BRF_GRA | CPS1_TILES },
	{ "so2_14.7c",     0x020000, 0xf5a8905e, BRF_GRA | CPS1_TILES },
	{ "so2_26.9d",     0x020000, 0xf3aa5a4a, BRF_GRA | CPS1_TILES },
	{ "so2_16.9c",     0x020000, 0xb43cd1a8, BRF_GRA | CPS1_TILES },
	{ "so2_20.3d",     0x020000, 0x8ca751a3, BRF_GRA | CPS1_TILES },
	{ "so2_10.3c",     0x020000, 0xe9f569fd, BRF_GRA | CPS1_TILES },
	{ "so2_22.5d",     0x020000, 0xfce9a377, BRF_GRA | CPS1_TILES },
	{ "so2_12.5c",     0x020000, 0xb7df8a06, BRF_GRA | CPS1_TILES },

	{ "so2_09.12b",    0x010000, 0xd09d7c7a, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "so2_18.11c",    0x020000, 0xbbea1643, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "so2_19.12c",    0x020000, 0xac58aa71, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "o224b.1a",      0x000117, 0xc211c8cd, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c628",          0x000117, 0x662e090f, BRF_OPT }, // c-board PLDs
};

STD_ROM_PICK(Mercsur1)
STD_ROM_FN(Mercsur1)

static struct BurnRomInfo MercsjRomDesc[] = {
	{ "so2_36.12f",    0x020000, 0xe17f9bf7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_42.12h",    0x020000, 0x2c3884c6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_37.13f",    0x020000, 0x51204d36, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_43.13h",    0x020000, 0x9cfba8b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_34.10f",    0x020000, 0xb8dae95f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_40.10h",    0x020000, 0xde37771c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_35.11f",    0x020000, 0x7d24394d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "so2_41.11h",    0x020000, 0x914f85e0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "so2_09.4b",     0x020000, 0x690c261d, BRF_GRA | CPS1_TILES },
	{ "so2_01.4a",     0x020000, 0x31fd2715, BRF_GRA | CPS1_TILES },
	{ "so2_13.9b",     0x020000, 0xb5e48282, BRF_GRA | CPS1_TILES },
	{ "so2_05.9a",     0x020000, 0x54bed82c, BRF_GRA | CPS1_TILES },
	{ "so2_24.5e",     0x020000, 0x78b6f0cb, BRF_GRA | CPS1_TILES },
	{ "so2_17.5c",     0x020000, 0xe78bb308, BRF_GRA | CPS1_TILES },
	{ "so2_38.8h",     0x020000, 0x0010a9a2, BRF_GRA | CPS1_TILES },
	{ "so2_32.8f",     0x020000, 0x75dffc9a, BRF_GRA | CPS1_TILES },
	{ "so2_10.5b",     0x020000, 0x2f871714, BRF_GRA | CPS1_TILES },
	{ "so2_02.5a",     0x020000, 0xb4b2a0b7, BRF_GRA | CPS1_TILES },
	{ "so2_14.10b",    0x020000, 0x737a744b, BRF_GRA | CPS1_TILES },
	{ "so2_06.10a",    0x020000, 0x9d756f51, BRF_GRA | CPS1_TILES },
	{ "so2_25.7e",     0x020000, 0x6d0e05d6, BRF_GRA | CPS1_TILES },
	{ "so2_18.7c",     0x020000, 0x96f61f4e, BRF_GRA | CPS1_TILES },
	{ "so2_39.9h",     0x020000, 0xd52ba336, BRF_GRA | CPS1_TILES },
	{ "so2_33.9f",     0x020000, 0x39b90d25, BRF_GRA | CPS1_TILES },
	{ "so2_11.7b",     0x020000, 0x3f254efe, BRF_GRA | CPS1_TILES },
	{ "so2_03.7a",     0x020000, 0xf5a8905e, BRF_GRA | CPS1_TILES },
	{ "so2_15.11b",    0x020000, 0xf3aa5a4a, BRF_GRA | CPS1_TILES },
	{ "so2_07.11a",    0x020000, 0xb43cd1a8, BRF_GRA | CPS1_TILES },
	{ "so2_26.8e",     0x020000, 0x8ca751a3, BRF_GRA | CPS1_TILES },
	{ "so2_19.8c",     0x020000, 0xe9f569fd, BRF_GRA | CPS1_TILES },
	{ "so2_28.10e",    0x020000, 0xfce9a377, BRF_GRA | CPS1_TILES },
	{ "so2_21.10c",    0x020000, 0xb7df8a06, BRF_GRA | CPS1_TILES },

	{ "so2_23.13b",    0x010000, 0xd09d7c7a, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "so2_30.12c",    0x020000, 0xbbea1643, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "so2_31.13c",    0x020000, 0xac58aa71, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "o222b.1a",      0x000117, 0x00000000, BRF_OPT | BRF_NODUMP }, // b-board PLDs
	{ "lwio.12e",      0x000117, 0xad52b90c, BRF_OPT },
	{ "c628",          0x000117, 0x662e090f, BRF_OPT }, // c-board PLDs
};

STD_ROM_PICK(Mercsj)
STD_ROM_FN(Mercsj)

static struct BurnRomInfo MswordRomDesc[] = {
	{ "mse_30.11f",    0x020000, 0x03fc8dbc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mse_35.11h",    0x020000, 0xd5bf66cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mse_31.12f",    0x020000, 0x30332bcf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mse_36.12h",    0x020000, 0x8f7d6ce9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms-32m.8h",     0x080000, 0x2475ddfc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ms-5m.7a",      0x080000, 0xc00fe7e2, BRF_GRA | CPS1_TILES },
	{ "ms-7m.9a",      0x080000, 0x4ccacac5, BRF_GRA | CPS1_TILES },
	{ "ms-1m.3a",      0x080000, 0x0d2bbe00, BRF_GRA | CPS1_TILES },
	{ "ms-3m.5a",      0x080000, 0x3a1a5bf4, BRF_GRA | CPS1_TILES },

	{ "ms_09.12b",     0x010000, 0x57b29519, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ms_18.11c",     0x020000, 0xfb64e90d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ms_19.12c",     0x020000, 0x74f892b9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ms24b.1a",      0x000117, 0x636dbe6d, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Msword)
STD_ROM_FN(Msword)

static struct BurnRomInfo Mswordr1RomDesc[] = {
	{ "ms_30.11f",     0x020000, 0x21c1f078, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_35.11h",     0x020000, 0xa540a73a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_31.12f",     0x020000, 0xd7e762b5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_36.12h",     0x020000, 0x66f2dcdb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms-32m.8h",     0x080000, 0x2475ddfc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ms-5m.7a",      0x080000, 0xc00fe7e2, BRF_GRA | CPS1_TILES },
	{ "ms-7m.9a",      0x080000, 0x4ccacac5, BRF_GRA | CPS1_TILES },
	{ "ms-1m.3a",      0x080000, 0x0d2bbe00, BRF_GRA | CPS1_TILES },
	{ "ms-3m.5a",      0x080000, 0x3a1a5bf4, BRF_GRA | CPS1_TILES },

	{ "ms_09.12b",     0x010000, 0x57b29519, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ms_18.11c",     0x020000, 0xfb64e90d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ms_19.12c",     0x020000, 0x74f892b9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ms24b.1a",      0x000117, 0x636dbe6d, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Mswordr1)
STD_ROM_FN(Mswordr1)

static struct BurnRomInfo MswordjRomDesc[] = {
	{ "msj_36.12f",    0x020000, 0x04f0ef50, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "msj_42.12h",    0x020000, 0x9fcbb9cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "msj_37.13f",    0x020000, 0x6c060d70, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "msj_43.13h",    0x020000, 0xaec77787, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_34.10f",     0x020000, 0x0e59a62d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_40.10h",     0x020000, 0xbabade3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_35.11f",     0x020000, 0x03da99d1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms_41.11h",     0x020000, 0xfadf99ea, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ms_09.4b",      0x020000, 0x4adee6f6, BRF_GRA | CPS1_TILES },
	{ "ms_01.4a",      0x020000, 0xf7ab1b88, BRF_GRA | CPS1_TILES },
	{ "ms_13.9b",      0x020000, 0xe01adc4b, BRF_GRA | CPS1_TILES },
	{ "ms_05.9a",      0x020000, 0xf62c2369, BRF_GRA | CPS1_TILES },
	{ "ms_24.5e",      0x020000, 0xbe64a3a1, BRF_GRA | CPS1_TILES },
	{ "ms_17.5c",      0x020000, 0x0bc1665f, BRF_GRA | CPS1_TILES },
	{ "ms_38.8h",      0x020000, 0x904a2ed5, BRF_GRA | CPS1_TILES },
	{ "ms_32.8f",      0x020000, 0x3d89c530, BRF_GRA | CPS1_TILES },
	{ "ms_10.5b",      0x020000, 0xf02c0718, BRF_GRA | CPS1_TILES },
	{ "ms_02.5a",      0x020000, 0xd071a405, BRF_GRA | CPS1_TILES },
	{ "ms_14.10b",     0x020000, 0xdfb2e4df, BRF_GRA | CPS1_TILES },
	{ "ms_06.10a",     0x020000, 0xd3ce2a91, BRF_GRA | CPS1_TILES },
	{ "ms_25.7e",      0x020000, 0x0f199d56, BRF_GRA | CPS1_TILES },
	{ "ms_18.7c",      0x020000, 0x1ba76df2, BRF_GRA | CPS1_TILES },
	{ "ms_39.9h",      0x020000, 0x01efce86, BRF_GRA | CPS1_TILES },
	{ "ms_33.9f",      0x020000, 0xce25defc, BRF_GRA | CPS1_TILES },

	{ "ms_23.13b",     0x010000, 0x57b29519, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ms_30.12c",     0x020000, 0xfb64e90d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ms_31.13c",     0x020000, 0x74f892b9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ms22b.1a",      0x000117, 0xdde86cb0, BRF_OPT }, // b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Mswordj)
STD_ROM_FN(Mswordj)

static struct BurnRomInfo MsworduRomDesc[] = {
	{ "msu_30.11f",    0x020000, 0xd963c816, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "msu_35.11h",    0x020000, 0x72f179b3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "msu_31.12f",    0x020000, 0x20cd7904, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "msu_36.12h",    0x020000, 0xbf88c080, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ms-32m.8h",     0x080000, 0x2475ddfc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ms-5m.7a",      0x080000, 0xc00fe7e2, BRF_GRA | CPS1_TILES },
	{ "ms-7m.9a",      0x080000, 0x4ccacac5, BRF_GRA | CPS1_TILES },
	{ "ms-1m.3a",      0x080000, 0x0d2bbe00, BRF_GRA | CPS1_TILES },
	{ "ms-3m.5a",      0x080000, 0x3a1a5bf4, BRF_GRA | CPS1_TILES },

	{ "ms_09.12b",     0x010000, 0x57b29519, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ms_18.11c",     0x020000, 0xfb64e90d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ms_19.12c",     0x020000, 0x74f892b9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ms24b.1a",      0x000117, 0x636dbe6d, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Mswordu)
STD_ROM_FN(Mswordu)

static struct BurnRomInfo MtwinsRomDesc[] = {
	{ "che_30.11f",    0x020000, 0x9a2a2db1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "che_35.11h",    0x020000, 0xa7f96b02, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "che_31.12f",    0x020000, 0xbbff8a99, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "che_36.12h",    0x020000, 0x0fa00c39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ck-32m.8h",     0x080000, 0x9b70bd41, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ck-5m.7a",      0x080000, 0x4ec75f15, BRF_GRA | CPS1_TILES },
	{ "ck-7m.9a",      0x080000, 0xd85d00d6, BRF_GRA | CPS1_TILES },
	{ "ck-1m.3a",      0x080000, 0xf33ca9d4, BRF_GRA | CPS1_TILES },
	{ "ck-3m.5a",      0x080000, 0x0ba2047f, BRF_GRA | CPS1_TILES },

	{ "ch_09.12b",     0x010000, 0x4d4255b7, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ch_18.11c",     0x020000, 0xf909e8de, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ch_19.12c",     0x020000, 0xfc158cf7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ck24b.1a",      0x000117, 0xbd99c448, BRF_OPT }, // b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Mtwins)
STD_ROM_FN(Mtwins)

static struct BurnRomInfo ChikijRomDesc[] = {
	{ "chj_36a.12f",   0x020000, 0xec1328d8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "chj_42a.12h",   0x020000, 0x4ae13503, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "chj_37a.13f",   0x020000, 0x46d2cf7b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "chj_43a.13h",   0x020000, 0x8d387fe8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ch_34.10f",     0x020000, 0x609ed2f9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ch_40.10h",     0x020000, 0xbe0d8301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ch_35.11f",     0x020000, 0xb810867f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ch_41.11h",     0x020000, 0x8ad96155, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ch_09.4b",      0x020000, 0x567ab3ca, BRF_GRA | CPS1_TILES },
	{ "ch_01.4a",      0x020000, 0x7f3b7b56, BRF_GRA | CPS1_TILES },
	{ "ch_13.9b",      0x020000, 0x12a7a8ba, BRF_GRA | CPS1_TILES },
	{ "ch_05.9a",      0x020000, 0x6c1afb9a, BRF_GRA | CPS1_TILES },
	{ "ch_24.5e",      0x020000, 0x9cb6e6bc, BRF_GRA | CPS1_TILES },
	{ "ch_17.5c",      0x020000, 0xfe490846, BRF_GRA | CPS1_TILES },
	{ "ch_38.8h",      0x020000, 0x6e5c8cb6, BRF_GRA | CPS1_TILES },
	{ "ch_32.8f",      0x020000, 0x317d27b0, BRF_GRA | CPS1_TILES },
	{ "ch_10.5b",      0x020000, 0xe8251a9b, BRF_GRA | CPS1_TILES },
	{ "ch_02.5a",      0x020000, 0x7c8c88fb, BRF_GRA | CPS1_TILES },
	{ "ch_14.10b",     0x020000, 0x4012ec4b, BRF_GRA | CPS1_TILES },
	{ "ch_06.10a",     0x020000, 0x81884b2b, BRF_GRA | CPS1_TILES },
	{ "ch_25.7e",      0x020000, 0x1dfcbac5, BRF_GRA | CPS1_TILES },
	{ "ch_18.7c",      0x020000, 0x516a34d1, BRF_GRA | CPS1_TILES },
	{ "ch_39.9h",      0x020000, 0x872fb2a4, BRF_GRA | CPS1_TILES },
	{ "ch_33.9f",      0x020000, 0x30dc5ded, BRF_GRA | CPS1_TILES },

	{ "ch_23.13b",     0x010000, 0x4d4255b7, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ch_30.12c",     0x020000, 0xf909e8de, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ch_31.13c",     0x020000, 0xfc158cf7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ck22b.1a",      0x000117, 0x24fdfdeb, BRF_OPT }, // b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Chikij)
STD_ROM_FN(Chikij)

static struct BurnRomInfo MtwinsbRomDesc[] = {
	{ "2-prg-27c4001.bin",    0x080000, 0x7d5b8a97, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1-prg-27c4001.bin",    0x080000, 0x8938a029, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "g4.bin",               0x080000, 0x11493e55, BRF_GRA | CPS1_TILES },
	{ "g3.bin",               0x080000, 0xfeda0f8b, BRF_GRA | CPS1_TILES },
	{ "g2.bin",               0x080000, 0x745f0eba, BRF_GRA | CPS1_TILES },
	{ "g1.bin",               0x080000, 0x8069026f, BRF_GRA | CPS1_TILES },

	{ "4-snd-z80-27c512.bin", 0x010000, 0x4d4255b7, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "3-snd-27c208.bin",     0x040000, 0xa0c3de92, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Mtwinsb)
STD_ROM_FN(Mtwinsb)

static struct BurnRomInfo NemoRomDesc[] = {
	{ "nme_30a.11f",   0x020000, 0xd2c03e56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nme_35a.11h",   0x020000, 0x5fd31661, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nme_31a.12f",   0x020000, 0xb2bd4f6f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nme_36a.12h",   0x020000, 0xee9450e3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nm-32m.8h",     0x080000, 0xd6d1add3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "nm-5m.7a",      0x080000, 0x487b8747, BRF_GRA | CPS1_TILES },
	{ "nm-7m.9a",      0x080000, 0x203dc8c6, BRF_GRA | CPS1_TILES },
	{ "nm-1m.3a",      0x080000, 0x9e878024, BRF_GRA | CPS1_TILES },
	{ "nm-3m.5a",      0x080000, 0xbb01e6b6, BRF_GRA | CPS1_TILES },

	{ "nme_09.12b",    0x010000, 0x0f4b0581, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "nme_18.11c",    0x020000, 0xbab333d4, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "nme_19.12c",    0x020000, 0x2650a0a8, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "nm24b.1a",      0x000117, 0x7b25bac6, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Nemo)
STD_ROM_FN(Nemo)

static struct BurnRomInfo Nemor1RomDesc[] = {
	{ "nme_30.11f",    0x020000, 0x71b333db, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nme_35.11h",    0x020000, 0xd153bc18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nme_31.12f",    0x020000, 0x7e83dbd2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nme_36.12h",    0x020000, 0x6aeeec81, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nm-32m.8h",     0x080000, 0xd6d1add3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "nm-5m.7a",      0x080000, 0x487b8747, BRF_GRA | CPS1_TILES },
	{ "nm-7m.9a",      0x080000, 0x203dc8c6, BRF_GRA | CPS1_TILES },
	{ "nm-1m.3a",      0x080000, 0x9e878024, BRF_GRA | CPS1_TILES },
	{ "nm-3m.5a",      0x080000, 0xbb01e6b6, BRF_GRA | CPS1_TILES },

	{ "nme_09.12b",    0x010000, 0x0f4b0581, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "nme_18.11c",    0x020000, 0xbab333d4, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "nme_19.12c",    0x020000, 0x2650a0a8, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "nm24b.1a",      0x000117, 0x7b25bac6, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Nemor1)
STD_ROM_FN(Nemor1)

static struct BurnRomInfo NemojRomDesc[] = {
	{ "nmj_36a.12f",   0x020000, 0xdaeceabb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nmj_42a.12h",   0x020000, 0x55024740, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nmj_37a.13f",   0x020000, 0x619068b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nmj_43a.13h",   0x020000, 0xa948a53b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nm_34.10f",     0x020000, 0x5737feed, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nm_40.10h",     0x020000, 0x8a4099f3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nm_35.11f",     0x020000, 0xbd11a7f8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "nm_41.11h",     0x020000, 0x6309603d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "nm_09.4b",      0x020000, 0x9d60d286, BRF_GRA | CPS1_TILES },
	{ "nm_01.4a",      0x020000, 0x8a83f7c4, BRF_GRA | CPS1_TILES },
	{ "nm_13.9b",      0x020000, 0xa4909fe0, BRF_GRA | CPS1_TILES },
	{ "nm_05.9a",      0x020000, 0x16db1e61, BRF_GRA | CPS1_TILES },
	{ "nm_24.5e",      0x020000, 0x3312c648, BRF_GRA | CPS1_TILES },
	{ "nm_17.5c",      0x020000, 0xccfc50e2, BRF_GRA | CPS1_TILES },
	{ "nm_38.8h",      0x020000, 0xae98a997, BRF_GRA | CPS1_TILES },
	{ "nm_32.8f",      0x020000, 0xb3704dde, BRF_GRA | CPS1_TILES },
	{ "nm_10.5b",      0x020000, 0x33c1388c, BRF_GRA | CPS1_TILES },
	{ "nm_02.5a",      0x020000, 0x84c69469, BRF_GRA | CPS1_TILES },
	{ "nm_14.10b",     0x020000, 0x66612270, BRF_GRA | CPS1_TILES },
	{ "nm_06.10a",     0x020000, 0x8b9bcf95, BRF_GRA | CPS1_TILES },
	{ "nm_25.7e",      0x020000, 0xacfc84d2, BRF_GRA | CPS1_TILES },
	{ "nm_18.7c",      0x020000, 0x4347deed, BRF_GRA | CPS1_TILES },
	{ "nm_39.9h",      0x020000, 0x6a274ecd, BRF_GRA | CPS1_TILES },
	{ "nm_33.9f",      0x020000, 0xc469dc74, BRF_GRA | CPS1_TILES },
	
	{ "nm_23.13b",     0x010000, 0x8d3c5a42, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "nm_30.12c",     0x020000, 0xbab333d4, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "nm_31.13c",     0x020000, 0x2650a0a8, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "nm22b.1a",      0x000117, 0x00000000, BRF_OPT | BRF_NODUMP }, // b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Nemoj)
STD_ROM_FN(Nemoj)

static struct BurnRomInfo Pang3RomDesc[] = {
	{ "pa3e_17a.11l",  0x080000, 0xa213fa80, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "pa3e_16a.10l",  0x080000, 0x7169ea67, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "pa3-01m.2c",    0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "pa3-07m.2f",    0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",    0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pa3_05.10d",    0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",    0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9ka.9k",    0x000117, 0x238d3ff4, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3)
STD_ROM_FN(Pang3)

static struct BurnRomInfo Pang3r1RomDesc[] = {
	{ "pa3e_17.11l",   0x080000, 0xd7041d32, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "pa3e_16.10l",   0x080000, 0x1be9a483, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "pa3-01m.2c",    0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "pa3-07m.2f",    0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",    0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pa3_05.10d",    0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",    0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3r1)
STD_ROM_FN(Pang3r1)

static struct BurnRomInfo Pang3r1aRomDesc[] = {
	{ "d.t.11l",   	   0x080000, 0xd7041d32, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "d.t.10l",       0x080000, 0x1be9a483, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mx27c4100.2c",  0x080000, 0x22c934c4, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.3c",  0x080000, 0x07c85e9b, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.4c",  0x080000, 0xac119a46, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.5c",  0x080000, 0x4ad13297, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.2f",  0x080000, 0x51031180, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.3f",  0x080000, 0xe9cd657a, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.4f",  0x080000, 0x2e1d35f2, BRF_GRA | CPS1_TILES },
	{ "mx27c4100.5f",  0x080000, 0x026d0cd2, BRF_GRA | CPS1_TILES },

	{ "d.t.11f",       0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "d.t.10d",       0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "d.t.11d",       0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3r1a)
STD_ROM_FN(Pang3r1a)

static struct BurnRomInfo Pang3bRomDesc[] = {
	{ "pa3w_17.11l",   0x080000, 0x12138234, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "pa3w_16.10l",   0x080000, 0xd1ba585c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "pa3-01m.2c",    0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "pa3-07m.2f",    0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",    0x008000, 0x90a08c46, BRF_PRG | CPS1_Z80_PROGRAM }, // == pa3_11.11f but different size, resized by bootlegger

	{ "pa3_05.10d",    0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",    0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3b)
STD_ROM_FN(Pang3b)

static struct BurnRomInfo Pang3b2RomDesc[] = {
	// This bootleg uses an original B-13 chip top and original main board. ROM content is the same as pang3, but split differently
	{ "16.u70",   	   0x040000, 0x8d3fd82c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "14.u72",   	   0x040000, 0x654904c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "15.u71",   	   0x040000, 0x42774e37, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "13.u73",   	   0x040000, 0x531ea745, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "4.u68",    	   0x080000, 0x45fc0a81, BRF_GRA | CPS1_TILES },
	{ "2.u66",    	   0x080000, 0x27668828, BRF_GRA | CPS1_TILES },
	{ "10.u69",    	   0x080000, 0xe051b2e9, BRF_GRA | CPS1_TILES },
	{ "8.u63",    	   0x080000, 0x4a68b194, BRF_GRA | CPS1_TILES },
	{ "3.u67",    	   0x080000, 0x91c8d782, BRF_GRA | CPS1_TILES },
	{ "1.u65",    	   0x080000, 0xfe32af5d, BRF_GRA | CPS1_TILES },
	{ "9.u62",    	   0x080000, 0xf0bba5c7, BRF_GRA | CPS1_TILES },
	{ "7.u64",    	   0x080000, 0xc60c5e75, BRF_GRA | CPS1_TILES },

	{ "11.u32",    	   0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM }, // == pa3_11.11f but different size, resized by bootlegger

	{ "5.u34",    	   0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "6.u33",    	   0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT }, // a-board PLDs
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },
	{ "prg1",          0x000117, 0xf1129744, BRF_OPT },
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },
	{ "sou1",          0x000117, 0x84f4b2fe, BRF_OPT },
};

STD_ROM_PICK(Pang3b2)
STD_ROM_FN(Pang3b2)

/* An interesting single board bootleg which is an almost exact replica of the official Pang3 A/B board circuitry condensed onto a single pcb.
   All component refs match the official 89626A short 10MHz A board and 94916-10 pang3 exclusive B board.
   Uses pin compatible clone CPS-A/B chips which are marked 27C634 and 27C633 respectively, the clone B is a CPS-B-17.
   They appear to be 3.3v chips as the common bootlegger trick of stepping down the supply voltage with power diodes is used.
   Main code has been hacked to use the CPS-B-17 rather than official CPS-B-21 config.
   All PALs confirmed to match official A/B board PALs.
   Uses same encryption and mach215 security pld as official.
*/
static struct BurnRomInfo Pang3b3RomDesc[] = {
	{ "u11l1_17.bin",  0x080000, 0xdd3b95c0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "u10l1_16.bin",  0x080000, 0x1be9a483, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "pa3-01m.2c",    0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "pa3-07m.2f",    0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "u11f1.bin",     0x010000, 0x278d786c, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pa3_05.10d",    0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",    0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
};

STD_ROM_PICK(Pang3b3)
STD_ROM_FN(Pang3b3)

/* This bootleg uses a bootlegged B board nearly identical to that used in sf2ceblp.
   In my set:
     - Board-A is missing so I don't know if a normal or a dash board was used. 
     - Board-C is an hacked 88622-C-5 with an unusual CPS-B-12 and clearly it's not its C-board because 
       code analisys led to identify the CPS_B_21_DEF as the right configuration.
     - Board-B has some missing components:
      - audio cpu code EPROM @B13 (pang3b pa3_11.11f used instead)
      - 28 pin DIP component @F8, probably a PIC16C55/7 looking the pinout (VCC on pin2, GND on pin 4, ...)

   The program code is almost the same as of pang3b with some minor, yet interesting, hacks:
      - Dip switch use for board configuration (code@ 0x000300, 0xe0000) instead of a serial EPROM
      - Removed freeze from dip switch (code@ 020B74)
      - Some code to handle the PIC (protection?). 
        Read and write to addresses 0x5762b0 and 0x57a2b0 occurs in the code but the return value is never really used (nop or bra skips relevant parts)
        and so seems that the PIC protection is ineffective.
      - Read and write to port 0x80017a (EEPROM in pang3) still are present in the code, but are filtered by the PAL16V8 @ E13 so there is no need to 
        create a port for that address here in mame (altough this causes a popmessage "CPS-B read port 3A contact MAMEDEV" to occurr at startup if compiled with
        DEBUG=1)

   Board-B has five PALs:
      - PALCE16V8  @A2
      - PAL16L8    @E11
      - PALCE16V8  @E13
      - PAL16L8    @J8
      - PALCE22V10 @J8

*/
static struct BurnRomInfo Pang3b4RomDesc[] = {
	{ "22.u30",      0x020000, 0xbf3ebe68, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "26.u35",      0x020000, 0xd20db83c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "23.u31",      0x020000, 0x94d494c2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27.u36",      0x020000, 0x38e43390, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "20.u28",      0x020000, 0x8daf3814, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "24.u33",      0x020000, 0xbb34e444, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "21.u29",      0x020000, 0x54d0b680, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "25.u34",      0x020000, 0xd666ec70, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "14.u25",      0x040000, 0xd2b764a9, BRF_GRA | CPS1_TILES },
	{ "10.u21",      0x040000, 0x79673708, BRF_GRA | CPS1_TILES },
	{ "13.u24",      0x040000, 0x0c73a1c7, BRF_GRA | CPS1_TILES },
	{ "09.u20",      0x040000, 0x6e36e963, BRF_GRA | CPS1_TILES },
	{ "06.u15",      0x040000, 0xfb68be4e, BRF_GRA | CPS1_TILES },
	{ "02.u11",      0x040000, 0xf706b466, BRF_GRA | CPS1_TILES },
	{ "05.u14",      0x040000, 0x475a5ef1, BRF_GRA | CPS1_TILES },
	{ "01.u10",      0x040000, 0x7d15b9d7, BRF_GRA | CPS1_TILES },
	{ "16.u27",      0x040000, 0x3e293482, BRF_GRA | CPS1_TILES },
	{ "12.u23",      0x040000, 0x3c4dfb4f, BRF_GRA | CPS1_TILES },
	{ "15.u26",      0x040000, 0xa933434f, BRF_GRA | CPS1_TILES },
	{ "11.u22",      0x040000, 0x29194b90, BRF_GRA | CPS1_TILES },
	{ "08.u17",      0x040000, 0x7e0ca927, BRF_GRA | CPS1_TILES },
	{ "04.u13",      0x040000, 0x44cd5e95, BRF_GRA | CPS1_TILES },
	{ "07.u16",      0x040000, 0x83b3fa5e, BRF_GRA | CPS1_TILES },
	{ "03.u12",      0x040000, 0x7e28974e, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",  0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM }, // 19.u9 missing, used pang3b audio code instead

	{ "pa3_05.10d",  0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",  0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },

	{ "pal16l8.11e", 0x000117, 0x27617943, BRF_OPT }, // b-board PLDs, bruteforced
	{ "pal16v8.1a",  0x000117, 0x78c3161f, BRF_OPT },
	{ "pal16v8.13e", 0x000117, 0x5406caf1, BRF_OPT },
	{ "pal22v10.j8", 0x0002dd, 0xa9445f88, BRF_OPT },
	{ "pal16l8.j8",  0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },
};

STD_ROM_PICK(Pang3b4)
STD_ROM_FN(Pang3b4)

/* B-Board Mitchell 94916-10 */
/* This set comes from an encrypted bootleg that uses a very well reproduced Mitchell 94916-10 B-Board surmounted by an
   original Capcom 90631C-5 C-Board taken from a Knights of the round board (there's a sticker on it). 
   Protection chip MACH215 is present. */
static struct BurnRomInfo Pang3b5RomDesc[] = {
	{ "pa3e_17.11l",    0x080000, 0xd7041d32, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "pa3e_16.10l",    0x080000, 0x1be9a483, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.2c",           0x080000, 0x22c934c4, BRF_GRA | CPS1_TILES },
	{ "7.2f",           0x080000, 0x51031180, BRF_GRA | CPS1_TILES },
	{ "3.4c",           0x080000, 0xac119a46, BRF_GRA | CPS1_TILES },
	{ "9.4f",           0x080000, 0x2e1d35f2, BRF_GRA | CPS1_TILES },
	{ "2.3c",           0x080000, 0x07c85e9b, BRF_GRA | CPS1_TILES },
	{ "8.3f",           0x080000, 0x325cc0b7, BRF_GRA | CPS1_TILES },
	{ "4.5c",           0x080000, 0x4ad13297, BRF_GRA | CPS1_TILES },
	{ "10.5f",          0x080000, 0x026d0cd2, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",     0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pa3_05.10d",     0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",     0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },

	A_BOARD_PLDS

	{ "cp1b1f_boot.1f", 0x000117, 0x658849dc, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",      0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9ka.9k",     0x000117, 0x238d3ff4, BRF_OPT },
	{ "ioc1.ic7",       0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",       0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3b5)
STD_ROM_FN(Pang3b5)

static struct BurnRomInfo Pang3b6RomDesc[] = {
	{ "pa3_17bl.11l",  0x080000, 0x3b5d99de, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "pa3_16bl.10l",  0x080000, 0x1be9a483, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "pa3-01m.2c",    0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "pa3-07m.2f",    0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",    0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pa3_05.10d",    0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",    0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3b6)
STD_ROM_FN(Pang3b6)

static struct BurnRomInfo Pang3b7RomDesc[] = {
	{ "17.11l",        0x080000, 0xf62425e9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "16.10l",        0x080000, 0x7169ea67, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.2c",          0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "7.2f",          0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "11.11f",        0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "5.10d",         0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "06.11d",        0x020000, 0x6266d1df, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3b7)
STD_ROM_FN(Pang3b7)

static struct BurnRomInfo Pang3jRomDesc[] = {
	{ "pa3j_17.11l",   0x080000, 0x21f6e51f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "pa3j_16.10l",   0x080000, 0xca1d7897, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "pa3-01m.2c",    0x200000, 0x068a152c, BRF_GRA | CPS1_TILES },
	{ "pa3-07m.2f",    0x200000, 0x3a4a619d, BRF_GRA | CPS1_TILES },

	{ "pa3_11.11f",    0x020000, 0xcb1423a2, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pa3_05.10d",    0x020000, 0x73a10d5d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pa3_06.11d",    0x020000, 0xaffa4f82, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cp1b1f.1f",     0x000117, 0x3979b8e3, BRF_OPT },	// b-board PLDs
	{ "cp1b8k.8k",     0x000117, 0x8a52ea7a, BRF_OPT },
	{ "cp1b9k.9k",     0x000117, 0xa754bdc3, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pang3j)
STD_ROM_FN(Pang3j)

static struct BurnRomInfo PnickjRomDesc[] = {
	{ "pnij_36.12f",   0x020000, 0x2d4ffb2b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pnij_42.12h",   0x020000, 0xc085dfaf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "pnij_09.4b",    0x020000, 0x48177b0a, BRF_GRA | CPS1_TILES },
	{ "pnij_01.4a",    0x020000, 0x01a0f311, BRF_GRA | CPS1_TILES },
	{ "pnij_13.9b",    0x020000, 0x406451b0, BRF_GRA | CPS1_TILES },
	{ "pnij_05.9a",    0x020000, 0x8c515dc0, BRF_GRA | CPS1_TILES },
	{ "pnij_26.5e",    0x020000, 0xe2af981e, BRF_GRA | CPS1_TILES },
	{ "pnij_18.5c",    0x020000, 0xf17a0e56, BRF_GRA | CPS1_TILES },
	{ "pnij_38.8h",    0x020000, 0xeb75bd8c, BRF_GRA | CPS1_TILES },
	{ "pnij_32.8f",    0x020000, 0x84560bef, BRF_GRA | CPS1_TILES },
	{ "pnij_10.5b",    0x020000, 0xc2acc171, BRF_GRA | CPS1_TILES },
	{ "pnij_02.5a",    0x020000, 0x0e21fc33, BRF_GRA | CPS1_TILES },
	{ "pnij_14.10b",   0x020000, 0x7fe59b19, BRF_GRA | CPS1_TILES },
	{ "pnij_06.10a",   0x020000, 0x79f4bfe3, BRF_GRA | CPS1_TILES },
	{ "pnij_27.7e",    0x020000, 0x83d5cb0e, BRF_GRA | CPS1_TILES },
	{ "pnij_19.7c",    0x020000, 0xaf08b230, BRF_GRA | CPS1_TILES },
	{ "pnij_39.9h",    0x020000, 0x70fbe579, BRF_GRA | CPS1_TILES },
	{ "pnij_33.9f",    0x020000, 0x3ed2c680, BRF_GRA | CPS1_TILES },

	{ "pnij_17.13b",   0x010000, 0xe86f787a, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "pnij_24.12c",   0x020000, 0x5092257d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "pnij_25.13c",   0x020000, 0x22109aaa, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "pkb10b.1a",     0x000117, 0x00000000, BRF_OPT | BRF_NODUMP }, // b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Pnickj)
STD_ROM_FN(Pnickj)

static struct BurnRomInfo PokonyanRomDesc[] = {
	{ "xmqq-12f.bin",  0x020000, 0x196297bf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "xmqq-12h.bin",  0x020000, 0x2d7ee2e9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "xmqq-13f.bin",  0x020000, 0x8f6abf26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "xmqq-13h.bin",  0x020000, 0x3fefe432, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "xmqq-4b.bin",   0x020000, 0x933ab76d, BRF_GRA | CPS1_TILES },
	{ "xmqq-4a.bin",   0x020000, 0xb098e7a9, BRF_GRA | CPS1_TILES },
	{ "xmqq-9b.bin",   0x020000, 0xb66d62d4, BRF_GRA | CPS1_TILES },
	{ "xmqq-9a.bin",   0x020000, 0x9c23e40b, BRF_GRA | CPS1_TILES },
	{ "xmqq-5e.bin",   0x020000, 0x63d06d6f, BRF_GRA | CPS1_TILES },
	{ "xmqq-5c.bin",   0x020000, 0xe2169bb5, BRF_GRA | CPS1_TILES },
	{ "xmqq-8h.bin",   0x020000, 0x113121f5, BRF_GRA | CPS1_TILES },
	{ "xmqq-8f.bin",   0x020000, 0xbeb00e07, BRF_GRA | CPS1_TILES },
	{ "xmqq-5b.bin",   0x020000, 0x05354905, BRF_GRA | CPS1_TILES },
	{ "xmqq-5a.bin",   0x020000, 0xbd40215e, BRF_GRA | CPS1_TILES },
	{ "xmqq-10b.bin",  0x020000, 0x9fa773ef, BRF_GRA | CPS1_TILES },
	{ "xmqq-10a.bin",  0x020000, 0x638d4bc7, BRF_GRA | CPS1_TILES },
	{ "xmqq-7e.bin",   0x020000, 0x72c45858, BRF_GRA | CPS1_TILES },
	{ "xmqq-7c.bin",   0x020000, 0xd91cda18, BRF_GRA | CPS1_TILES },
	{ "xmqq-9h.bin",   0x020000, 0x3cd8594b, BRF_GRA | CPS1_TILES },
	{ "xmqq-9f.bin",   0x020000, 0x1ec10bed, BRF_GRA | CPS1_TILES },

	{ "xmqq-13b.bin",  0x010000, 0x4e8b81a8, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "xmqq-12c.bin",  0x020000, 0x71ac69ad, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "xmqq-13c.bin",  0x020000, 0x71e29699, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Pokonyan)
STD_ROM_FN(Pokonyan)

static struct BurnRomInfo PunisherRomDesc[] = {
	{ "pse_26.11e",    0x020000, 0x389a99d2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_30.11f",    0x020000, 0x68fb06ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_27.12e",    0x020000, 0x3eb181c3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_31.12f",    0x020000, 0x37108e7b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_24.9e",     0x020000, 0x0f434414, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_28.9f",     0x020000, 0xb732345d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_25.10e",    0x020000, 0xb77102e2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "pse_29.10f",    0x020000, 0xec037bce, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ps_21.6f",      0x080000, 0x8affa5a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ps-1m.3a",      0x080000, 0x77b7ccab, BRF_GRA | CPS1_TILES },
	{ "ps-3m.5a",      0x080000, 0x0122720b, BRF_GRA | CPS1_TILES },
	{ "ps-2m.4a",      0x080000, 0x64fa58d4, BRF_GRA | CPS1_TILES },
	{ "ps-4m.6a",      0x080000, 0x60da42c8, BRF_GRA | CPS1_TILES },
	{ "ps-5m.7a",      0x080000, 0xc54ea839, BRF_GRA | CPS1_TILES },
	{ "ps-7m.9a",      0x080000, 0x04c5acbd, BRF_GRA | CPS1_TILES },
	{ "ps-6m.8a",      0x080000, 0xa544f4cc, BRF_GRA | CPS1_TILES },
	{ "ps-8m.10a",     0x080000, 0x8f02f436, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Punisher)
STD_ROM_FN(Punisher)

static struct BurnRomInfo PunisheruRomDesc[] = {
	{ "psu_26.11e",    0x020000, 0x9236d121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_30.11f",    0x020000, 0x8320e501, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_27.12e",    0x020000, 0x61c960a1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_31.12f",    0x020000, 0x78d4c298, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_24.9e",     0x020000, 0x1cfecad7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_28.9f",     0x020000, 0xbdf921c1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_25.10e",    0x020000, 0xc51acc94, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psu_29.10f",    0x020000, 0x52dce1ca, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ps_21.6f",      0x080000, 0x8affa5a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ps-1m.3a",      0x080000, 0x77b7ccab, BRF_GRA | CPS1_TILES },
	{ "ps-3m.5a",      0x080000, 0x0122720b, BRF_GRA | CPS1_TILES },
	{ "ps-2m.4a",      0x080000, 0x64fa58d4, BRF_GRA | CPS1_TILES },
	{ "ps-4m.6a",      0x080000, 0x60da42c8, BRF_GRA | CPS1_TILES },
	{ "ps-5m.7a",      0x080000, 0xc54ea839, BRF_GRA | CPS1_TILES },
	{ "ps-7m.9a",      0x080000, 0x04c5acbd, BRF_GRA | CPS1_TILES },
	{ "ps-6m.8a",      0x080000, 0xa544f4cc, BRF_GRA | CPS1_TILES },
	{ "ps-8m.10a",     0x080000, 0x8f02f436, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Punisheru)
STD_ROM_FN(Punisheru)

static struct BurnRomInfo PunisherjRomDesc[] = {
	{ "psj_23.8f",     0x080000, 0x6b2fda52, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "psj_22.7f",     0x080000, 0xe01036bc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "psj_21.6f",     0x080000, 0x8affa5a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ps_01.3a",      0x080000, 0x77b7ccab, BRF_GRA | CPS1_TILES },
	{ "ps_02.4a",      0x080000, 0x0122720b, BRF_GRA | CPS1_TILES },
	{ "ps_03.5a",      0x080000, 0x64fa58d4, BRF_GRA | CPS1_TILES },
	{ "ps_04.6a",      0x080000, 0x60da42c8, BRF_GRA | CPS1_TILES },
	{ "ps_05.7a",      0x080000, 0xc54ea839, BRF_GRA | CPS1_TILES },
	{ "ps_06.8a",      0x080000, 0x04c5acbd, BRF_GRA | CPS1_TILES },
	{ "ps_07.9a",      0x080000, 0xa544f4cc, BRF_GRA | CPS1_TILES },
	{ "ps_08.10a",     0x080000, 0x8f02f436, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Punisherj)
STD_ROM_FN(Punisherj)

static struct BurnRomInfo PunisherhRomDesc[] = {
	{ "psh_26.11e",    0x020000, 0x6ad2bb83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_30.11f",    0x020000, 0x058d3659, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_27.12e",    0x020000, 0x579f4fd3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_31.12f",    0x020000, 0x2c9f70b5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_24.9e",     0x020000, 0xfaa14841, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_28.9f",     0x020000, 0x5c5b1f20, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_25.10e",    0x020000, 0x724fdfda, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psh_29.10f",    0x020000, 0x779cf901, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ps_21.6f",      0x080000, 0x8affa5a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ps-1m.3a",      0x080000, 0x77b7ccab, BRF_GRA | CPS1_TILES },
	{ "ps-3m.5a",      0x080000, 0x0122720b, BRF_GRA | CPS1_TILES },
	{ "ps-2m.4a",      0x080000, 0x64fa58d4, BRF_GRA | CPS1_TILES },
	{ "ps-4m.6a",      0x080000, 0x60da42c8, BRF_GRA | CPS1_TILES },
	{ "ps-5m.7a",      0x080000, 0xc54ea839, BRF_GRA | CPS1_TILES },
	{ "ps-7m.9a",      0x080000, 0x04c5acbd, BRF_GRA | CPS1_TILES },
	{ "ps-6m.8a",      0x080000, 0xa544f4cc, BRF_GRA | CPS1_TILES },
	{ "ps-8m.10a",     0x080000, 0x8f02f436, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Punisherh)
STD_ROM_FN(Punisherh)

static struct BurnRomInfo PunipicRomDesc[] = {
	/* bootleg with pic, like dinopic / dinopic2 */
	{ "cpu5.bin",      0x080000, 0xc3151563, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cpu3.bin",      0x080000, 0x8c2593ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cpu4.bin",      0x080000, 0x665a5485, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cpu2.bin",      0x080000, 0xd7b13f39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "gfx9.bin",      0x080000, 0x9b9a887a, BRF_GRA | CPS1_TILES },
	{ "gfx8.bin",      0x080000, 0x2b94287a, BRF_GRA | CPS1_TILES },
	{ "gfx7.bin",      0x080000, 0xe9bd74f5, BRF_GRA | CPS1_TILES },
	{ "gfx6.bin",      0x080000, 0xa5e1c8a4, BRF_GRA | CPS1_TILES },
	{ "gfx13.bin",     0x080000, 0x6d75a193, BRF_GRA | CPS1_TILES },
	{ "gfx12.bin",     0x080000, 0xa3c205c1, BRF_GRA | CPS1_TILES },
	{ "gfx11.bin",     0x080000, 0x22f2ec92, BRF_GRA | CPS1_TILES },
	{ "gfx10.bin",     0x080000, 0x763974c9, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },

	{ "pic16c57",      0x004000, 0x00000000, BRF_PRG | BRF_NODUMP | CPS1_PIC },

	{ "sound.bin",     0x080000, 0xaeec9dc6, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Punipic)
STD_ROM_FN(Punipic)

static struct BurnRomInfo Punipic2RomDesc[] = {
	{ "prg4.bin",      0x080000, 0xc3151563, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prg3.bin",      0x080000, 0x8c2593ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prg2.bin",      0x080000, 0x665a5485, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prg1.bin",      0x080000, 0xd7b13f39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "pu11256.bin",   0x200000, 0x6581faea, BRF_GRA | CPS1_TILES },
	{ "pu13478.bin",   0x200000, 0x61613de4, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },

	{ "pic16c57",      0x004000, 0x00000000, BRF_PRG | BRF_NODUMP | CPS1_PIC },

	{ "sound.bin",     0x080000, 0xaeec9dc6, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "93c46.bin",     0x000080, 0x36ab4e7d, BRF_OPT },
};

STD_ROM_PICK(Punipic2)
STD_ROM_FN(Punipic2)

static struct BurnRomInfo Punipic3RomDesc[] = {
	/* the readme doesn't actually state this has a PIC, and there's no sound ROM
	   so it might be different */
	{ "psb5b.rom",     0x080000, 0x58f42c05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psb3b.rom",     0x080000, 0x90113db4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psb4a.rom",     0x080000, 0x665a5485, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "psb2a.rom",     0x080000, 0xd7b13f39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "psb-a.rom",     0x200000, 0x57f0f5e3, BRF_GRA | CPS1_TILES },
	{ "psb-b.rom",     0x200000, 0xd9eb867e, BRF_GRA | CPS1_TILES },

	{ "ps_q.5k",       0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps-q1.1k",      0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q2.2k",      0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q3.3k",      0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps-q4.4k",      0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "ps63b.1a",      0x000117, 0x03a758b0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },

//	{ "pic16c57",      0x004000, 0x00000000, BRF_PRG | BRF_NODUMP | CPS1_PIC },

//	{ "sound.bin",     0x080000, 0xaeec9dc6, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Punipic3)
STD_ROM_FN(Punipic3)

static struct BurnRomInfo PunisherbzRomDesc[] = {
	{ "23.096",        0x080000, 0xbfa45d23, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22.096",        0x080000, 0x092578a4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "21.096",        0x080000, 0xd21ccddb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "20.096",        0x080000, 0xf9f334ce, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.096",         0x080000, 0xad468e07, BRF_GRA | CPS1_TILES },
	{ "2.096",         0x080000, 0xb9fdb6b5, BRF_GRA | CPS1_TILES },
	{ "3.096",         0x080000, 0xbe0b1a78, BRF_GRA | CPS1_TILES },
	{ "4.096",         0x080000, 0xbba67a43, BRF_GRA | CPS1_TILES },
	{ "ps_gfx5.rom",   0x080000, 0xc54ea839, BRF_GRA | CPS1_TILES },
	{ "ps_gfx7.rom",   0x080000, 0x04c5acbd, BRF_GRA | CPS1_TILES },
	{ "ps_gfx6.rom",   0x080000, 0xa544f4cc, BRF_GRA | CPS1_TILES },
	{ "ps_gfx8.rom",   0x080000, 0x8f02f436, BRF_GRA | CPS1_TILES },

	{ "9.512",         0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.010",        0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.010",        0x020000, 0xeb5ca884, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Punisherbz)
STD_ROM_FN(Punisherbz)

static struct BurnRomInfo PunisherbRomDesc[] = {
	{ "18.bin",        0x040000, 0x2565ad20, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "19.bin",        0x040000, 0x84bb4acf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "16.bin",        0x040000, 0x4568520f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "17.bin",        0x040000, 0xfda67fc1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "14.bin",        0x020000, 0x1286d6ad, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "15.bin",        0x020000, 0x092538ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "12.bin",        0x020000, 0x019744d4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "13.bin",        0x020000, 0x8b88ae0d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "1.bin",         0x080000, 0x35cb609a, BRF_GRA | CPS1_TILES },
	{ "2.bin",         0x080000, 0xdcf61484, BRF_GRA | CPS1_TILES },
	{ "3.bin",         0x080000, 0x3a76db83, BRF_GRA | CPS1_TILES },
	{ "4.bin",         0x080000, 0xb099b669, BRF_GRA | CPS1_TILES },
	{ "5.bin",         0x080000, 0x91365595, BRF_GRA | CPS1_TILES },
	{ "6.bin",         0x080000, 0xb3cd4553, BRF_GRA | CPS1_TILES },
	{ "7.bin",         0x080000, 0x3b940554, BRF_GRA | CPS1_TILES },
	{ "8.bin",         0x080000, 0x43704b5a, BRF_GRA | CPS1_TILES },

	{ "11.bin",        0x010000, 0xd09d7c7a, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "9.bin",         0x020000, 0xbbea1643, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "10.bin",        0x020000, 0xac58aa71, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "pal1.jed",      0x000bd4, 0x22a9ff9e, BRF_OPT },
	{ "pal2.jed",      0x000bd4, 0x8c4a97ac, BRF_OPT },
	{ "pal3.jed",      0x000bd4, 0x0fdd5375, BRF_OPT },
	{ "pal4.jed",      0x000e05, 0xb2d16eac, BRF_OPT },
};

STD_ROM_PICK(Punisherb)
STD_ROM_FN(Punisherb)

static struct BurnRomInfo QadRomDesc[] = {
	{ "qdu_36a.12f",   0x020000, 0xde9c24a0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "qdu_42a.12h",   0x020000, 0xcfe36f0c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "qdu_37a.13f",   0x020000, 0x10d22320, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "qdu_43a.13h",   0x020000, 0x15e6beb9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "qd_09.4b",      0x020000, 0x8c3f9f44, BRF_GRA | CPS1_TILES },
	{ "qd_01.4a",      0x020000, 0xf688cf8f, BRF_GRA | CPS1_TILES },
	{ "qd_13.9b",      0x020000, 0xafbd551b, BRF_GRA | CPS1_TILES },
	{ "qd_05.9a",      0x020000, 0xc3db0910, BRF_GRA | CPS1_TILES },
	{ "qd_24.5e",      0x020000, 0x2f1bd0ec, BRF_GRA | CPS1_TILES },
	{ "qd_17.5c",      0x020000, 0xa812f9e2, BRF_GRA | CPS1_TILES },
	{ "qd_38.8h",      0x020000, 0xccdddd1f, BRF_GRA | CPS1_TILES },
	{ "qd_32.8f",      0x020000, 0xa8d295d3, BRF_GRA | CPS1_TILES },

	{ "qd_23.13b",     0x010000, 0xcfb5264b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "qdu_30.12c",    0x020000, 0xf190da84, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "qdu_31.13c",    0x020000, 0xb7583f73, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "qd22b.1a",      0x000117, 0x783c53ab, BRF_OPT },	// b-board PLDs
	{ "iob1.12e",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Qad)
STD_ROM_FN(Qad)

static struct BurnRomInfo QadjrRomDesc[] = {
	{ "qad_23a.8f",    0x080000, 0x4d3553de, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "qad_22a.7f",    0x080000, 0x3191ddd0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "qad_01.3a",     0x080000, 0x9d853b57, BRF_GRA | CPS1_TILES },
	{ "qad_02.4a",     0x080000, 0xb35976c4, BRF_GRA | CPS1_TILES },
	{ "qad_03.5a",     0x080000, 0xcea4ca8c, BRF_GRA | CPS1_TILES },
	{ "qad_04.6a",     0x080000, 0x41b74d1b, BRF_GRA | CPS1_TILES },

	{ "qad_09.12a",    0x010000, 0x733161cc, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "qad_18.11c",    0x020000, 0x2bfe6f6a, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "qad_19.12c",    0x020000, 0x13d3236b, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "qad63b.1a",     0x000117, 0xb3312b13, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Qadjr)
STD_ROM_FN(Qadjr)

static struct BurnRomInfo Qtono2jRomDesc[] = {
	{ "tn2j_30.11e",   0x020000, 0x9226eb5e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_37.11f",   0x020000, 0xd1d30da1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_31.12e",   0x020000, 0x015e6a8a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_38.12f",   0x020000, 0x1f139bcc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_28.9e",    0x020000, 0x86d27f71, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_35.9f",    0x020000, 0x7a1ab87d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_29.10e",   0x020000, 0x9c384e99, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tn2j_36.10f",   0x020000, 0x4c4b2a0a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "tn2-02m.4a",    0x080000, 0xf2016a34, BRF_GRA | CPS1_TILES },
	{ "tn2-04m.6a",    0x080000, 0x094e0fb1, BRF_GRA | CPS1_TILES },
	{ "tn2-01m.3a",    0x080000, 0xcb950cf9, BRF_GRA | CPS1_TILES },
	{ "tn2-03m.5a",    0x080000, 0x18a5bf59, BRF_GRA | CPS1_TILES },
	{ "tn2-11m.4c",    0x080000, 0xd0edd30b, BRF_GRA | CPS1_TILES },
	{ "tn2-13m.6c",    0x080000, 0x426621c3, BRF_GRA | CPS1_TILES },
	{ "tn2-10m.3c",    0x080000, 0xa34ece70, BRF_GRA | CPS1_TILES },
	{ "tn2-12m.5c",    0x080000, 0xe04ff2f4, BRF_GRA | CPS1_TILES },

	{ "tn2j_09.12a",   0x010000, 0xe464b969, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tn2j_18.11c",   0x020000, 0xa40bf9a7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "tn2j_19.12c",   0x020000, 0x5b3b931e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "tn2292.1a",     0x000117, 0x3d899539, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Qtono2j)
STD_ROM_FN(Qtono2j)

static struct BurnRomInfo Sf2RomDesc[] = {
	{ "sf2e_30g.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37g.11f",  0x020000, 0xfb92cd74, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31g.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38g.12f",  0x020000, 0x5e22db70, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_28g.9e",   0x020000, 0x8bf9f1e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_35g.9f",   0x020000, 0x626ef934, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2)
STD_ROM_FN(Sf2)

static struct BurnRomInfo Sf2eaRomDesc[] = {
	{ "sf2e_30a.11e",  0x020000, 0xbc02c14c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37a.11f",  0x020000, 0x1c1266b3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31a.12e",  0x020000, 0x8b8221e6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38a.12f",  0x020000, 0x2d42d82a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_28a.9e",    0x020000, 0x852e10ec, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_35a.9f",    0x020000, 0x3b075de1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29.10e",    0x020000, 0xfdd0b5c1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36.10f",    0x020000, 0xdb66b127, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ea)
STD_ROM_FN(Sf2ea)

static struct BurnRomInfo Sf2ebRomDesc[] = {
	{ "sf2e_30b.11e",  0x020000, 0x57bd7051, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37b.11f",  0x020000, 0x62691cdd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31b.12e",  0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38b.12f",  0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_28b.9e",    0x020000, 0x4009955e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_35b.9f",    0x020000, 0x8c1f3994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2eb)
STD_ROM_FN(Sf2eb)

static struct BurnRomInfo Sf2edRomDesc[] = {
	{ "sf2e_30d.11e",  0x020000, 0x4bb2657c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37d.11f",  0x020000, 0x102f4561, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31d.12e",  0x020000, 0xd57b67d7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38d.12f",  0x020000, 0x9c8916ef, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_28d.9e",   0x020000, 0x175819d1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_35d.9f",   0x020000, 0x82060da4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ed)
STD_ROM_FN(Sf2ed)

static struct BurnRomInfo Sf2eeRomDesc[] = {
	{ "sf2e_30e.11e",  0x020000, 0xf37cd088, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37e.11f",  0x020000, 0xc39468e6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31e.12e",  0x020000, 0x7c4771b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38e.12f",  0x020000, 0xa4bd0cd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_28e.9e",   0x020000, 0xe3b95625, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_35e.9f",   0x020000, 0x3648769a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob2.11d",      0x000117, 0xd26f0a27, BRF_OPT },
	{ "c632b.ic1",     0x000117, 0x5c3cbb67, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ee)
STD_ROM_FN(Sf2ee)

static struct BurnRomInfo Sf2efRomDesc[] = {
	{ "sf2e_30f.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37f.11f",  0x020000, 0xb58a741b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31f.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38f.12f",  0x020000, 0x1510e4e2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_28f.9e",   0x020000, 0xacd8175b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_35f.9f",   0x020000, 0xc0a80bd1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ef)
STD_ROM_FN(Sf2ef)

static struct BurnRomInfo Sf2emRomDesc[] = {
	{ "sf2e_30.11e",   0x020000, 0x997bdac4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_37.11f",   0x020000, 0xf11b3d64, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_31.12e",   0x020000, 0x53e54744, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2e_38.12f",   0x020000, 0x5ff4dc81, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_28.9e",     0x020000, 0x55d88c35, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_35.9f",     0x020000, 0x4b964478, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29.10e",    0x020000, 0xfdd0b5c1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36.10f",    0x020000, 0xdb66b127, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2em)
STD_ROM_FN(Sf2em)

static struct BurnRomInfo Sf2enRomDesc[] = {
	{ "epr-b-05.12f",  0x020000, 0xbc02c14c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-09.12h",  0x020000, 0x1c1266b3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-06.13f",  0x020000, 0x8b8221e6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-10.13h",  0x020000, 0x2d42d82a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-03.10f",  0x020000, 0x852e10ec, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-07.10h",  0x020000, 0x3b075de1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-04.11f",  0x020000, 0xfdd0b5c1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "epr-b-08.11h",  0x020000, 0xdb66b127, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "epr-b-18.5e",   0x040000, 0x88f3485a, BRF_GRA | CPS1_TILES },
	{ "epr-b-13.5c",   0x040000, 0x63d63e0c, BRF_GRA | CPS1_TILES },
	{ "epr-b-24.8h",   0x040000, 0x25ae23bc, BRF_GRA | CPS1_TILES },
	{ "epr-b-23.8f",   0x040000, 0xe5819676, BRF_GRA | CPS1_TILES },
	{ "epr-b-07.4b",   0x040000, 0x84afb959, BRF_GRA | CPS1_TILES },
	{ "epr-b-01.4a",   0x040000, 0xab21635d, BRF_GRA | CPS1_TILES },
	{ "epr-b-10.9b",   0x040000, 0x2ce56f9f, BRF_GRA | CPS1_TILES },
	{ "epr-b-04.9a",   0x040000, 0x0ad7fb2b, BRF_GRA | CPS1_TILES },
	{ "epr-b-19.8e",   0x040000, 0x031525cc, BRF_GRA | CPS1_TILES },
	{ "epr-b-14.8c",   0x040000, 0xc97046a5, BRF_GRA | CPS1_TILES },
	{ "epr-b-21.10e",  0x040000, 0xacbbdb09, BRF_GRA | CPS1_TILES },
	{ "epr-b-16.10c",  0x040000, 0xfa6f32d9, BRF_GRA | CPS1_TILES },
	{ "epr-b-08.7b",   0x040000, 0x14756473, BRF_GRA | CPS1_TILES },
	{ "epr-b-02.7a",   0x040000, 0xee3d878a, BRF_GRA | CPS1_TILES },
	{ "epr-b-11.11b",  0x040000, 0xdbbfd400, BRF_GRA | CPS1_TILES },
	{ "epr-b-05.11a",  0x040000, 0x37635e97, BRF_GRA | CPS1_TILES },
	{ "epr-b-20.9e",   0x040000, 0x27cae573, BRF_GRA | CPS1_TILES },
	{ "epr-b-15.9c",   0x040000, 0x14e46ab1, BRF_GRA | CPS1_TILES },
	{ "epr-b-22.11e",  0x040000, 0xf241f0c7, BRF_GRA | CPS1_TILES },
	{ "epr-b-17.11c",  0x040000, 0xf187086b, BRF_GRA | CPS1_TILES },
	{ "epr-b-09.8b",   0x040000, 0x4894aa8f, BRF_GRA | CPS1_TILES },
	{ "epr-b-03.8a",   0x040000, 0xe8877e9d, BRF_GRA | CPS1_TILES },
	{ "epr-b-12.12b",  0x040000, 0xc9d4ed76, BRF_GRA | CPS1_TILES },
	{ "epr-b-06.12a",  0x040000, 0x67dcc295, BRF_GRA | CPS1_TILES },

	{ "27c512.13b",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "epr-b-01.12c",  0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "epr-b-02.13c",  0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "unknown.1a",    0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2en)
STD_ROM_FN(Sf2en)

static struct BurnRomInfo Sf2ebblRomDesc[] = {
	{ "12.bin",        0x040000, 0xa258b4d5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "09.bin",        0x040000, 0x59ccd474, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "11.bin",        0x040000, 0x82097d63, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "10.bin",        0x040000, 0x0c83844d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "1b_yf082.bin",  0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "1d_yf028.bin",  0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "1a_yf087.bin",  0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "1c_yf088.bin",  0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "1f_yf085.bin",  0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "1h_yf115.bin",  0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "1e_yf111.bin",  0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "1g_yf002.bin",  0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "1j_yf117.bin",  0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "1l_ye040.bin",  0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "1i_yf038.bin",  0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "1k_ye039.bin",  0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "03.bin",        0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "02.bin",        0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "01.bin",        0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "05.bin",        0x020000, 0xa505621e, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "07.bin",        0x020000, 0xde6271fb, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "06.bin",        0x020000, 0x23775344, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "08.bin",        0x020000, 0x81c9550f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "04.bin",        0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ebbl)
STD_ROM_FN(Sf2ebbl)

static struct BurnRomInfo Sf2ebbl2RomDesc[] = {
	{ "27c020.7", 		0x040000, 0xa258b4d5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c020.5", 		0x040000, 0x59ccd474, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c020.6",       0x040000, 0x82097d63, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c020.4",       0x040000, 0x0c83844d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "a-se235.bin", 	0x100000, 0xa258de13, BRF_GRA | CPS1_TILES }, 
	{ "c-se005.bin", 	0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES }, 
	{ "b-se194.bin", 	0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES }, 
	{ "d-se064.bin", 	0x100000, 0x4dd24197, BRF_GRA | CPS1_TILES }, //sf2-8m.6c 99.999809%
	{ "e-sf004.bin", 	0x100000, 0x187667cc, BRF_GRA | CPS1_TILES }, 
	{ "f-sf001.bin", 	0x100000, 0x5b585071, BRF_GRA | CPS1_TILES }, 

	{ "27c512.3",       0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "27c010.2",       0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "27c010.1",       0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "27c1024.10",     0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.12",     0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.9",      0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.11",     0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "27c512.8",       0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ebbl2)
STD_ROM_FN(Sf2ebbl2)

static struct BurnRomInfo Sf2ebbl3RomDesc[] = {
	{ "ce91e-b.bin",        0x080000, 0x963200d2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ce91e-a.bin",        0x080000, 0x02e88ec7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "1-b-yf197.07",  		0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "1-d-yf207.12",  		0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "27020.1",  	   		0x040000, 0x84afb959, BRF_GRA | CPS1_TILES },
	{ "27020.3",  	   		0x040000, 0xab21635d, BRF_GRA | CPS1_TILES },
	{ "27020.5",  	   		0x040000, 0x2ce56f9f, BRF_GRA | CPS1_TILES },
	{ "27020.7",  	   		0x040000, 0x0ad7fb2b, BRF_GRA | CPS1_TILES },
	{ "27020.2",  	   		0x040000, 0x031525cc, BRF_GRA | CPS1_TILES },
	{ "27020.4",  	   		0x040000, 0xc97046a5, BRF_GRA | CPS1_TILES },
	{ "1-h-yg010.10",  		0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "1-e-yg003.02",  		0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "27020.6",  	   		0x040000, 0xdbbfd400, BRF_GRA | CPS1_TILES },
	{ "27020.8",  	   		0x040000, 0x37635e97, BRF_GRA | CPS1_TILES },
	{ "1-j-yf213.09",  		0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "wm91m-11-yd025.11",  0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "1-i-yf224.03",  		0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "1-k-yf036.06",  		0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "27512.3",       0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "27010.2",       0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "27010.1",       0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "27010.09hi",    0x020000, 0xa505621e, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "27010.11",      0x020000, 0xde6271fb, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "27010.09lo",    0x020000, 0x23775344, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "27010.06",      0x020000, 0x81c9550f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "27512.8",        0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ebbl3)
STD_ROM_FN(Sf2ebbl3)

static struct BurnRomInfo Sf2sttRomDesc[] = {
#if !defined ROM_VERIFY
	// These first two are missing from the PCB
	{ "prg part 1.stt", 0x040000, 0xa258b4d5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prg part 2.stt", 0x040000, 0x59ccd474, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
#else
	{ "prg part 1.stt", 0x040000, 0x00000000, BRF_OPT | BRF_PRG | BRF_NODUMP },
	{ "prg part 2.stt", 0x040000, 0x00000000, BRF_OPT | BRF_PRG | BRF_NODUMP },
#endif
	{ "ce91e-b",        0x040000, 0x0862386e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ce91e-a",        0x040000, 0x0c83844d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "stt-a",          0x100000, 0x10a7036d, BRF_GRA | CPS1_TILES }, 
	{ "stt-d",          0x100000, 0x3580b124, BRF_GRA | CPS1_TILES }, 
	{ "stt-b",          0x100000, 0x7a09224e, BRF_GRA | CPS1_TILES }, 
	{ "stt-e",          0x100000, 0x382a612c, BRF_GRA | CPS1_TILES }, 
	{ "stt-c",          0x100000, 0x11701b8f, BRF_GRA | CPS1_TILES }, 
	{ "stt-f",          0x100000, 0x101a0b72, BRF_GRA | CPS1_TILES },

	{ "3.stt",          0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "2.stt",          0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "1.stt",          0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "5.stt",          0x020000, 0xa505621e, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "7.stt",          0x020000, 0xde6271fb, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "6.stt",          0x020000, 0x23775344, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.stt",          0x020000, 0x81c9550f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "4.stt",          0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2stt)
STD_ROM_FN(Sf2stt)

static struct BurnRomInfo Sf2lyRomDesc[] = {
	/* Street Fighter II - The World Warrior with bosses availables like in Champion Edition
	
	Dumped from an official Capcom board. Only eproms on the PCB.
	
	A-board 89626A-4 DASH
	B-board 91634B-2
	C-board PPU B-11*/
	
	{ "23",  		   0x080000, 0xca331c3c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22",  		   0x080000, 0xe446d96a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
		
	{ "1",     		   0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "2",     		   0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "3",     		   0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "4",     		   0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "5",     		   0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "6",     		   0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "7",     		   0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "8",     		   0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "10",    		   0x080000, 0x4267b696, BRF_GRA | CPS1_TILES },
	{ "11",    		   0x080000, 0xdf9b9146, BRF_GRA | CPS1_TILES },
	{ "12",     	   0x080000, 0xa08a9786, BRF_GRA | CPS1_TILES },
	{ "13",    		   0x080000, 0x80feac31, BRF_GRA | CPS1_TILES },

	{ "9",     		   0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",    		   0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",    		   0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ly)
STD_ROM_FN(Sf2ly)

static struct BurnRomInfo Sf2uaRomDesc[] = {
	{ "sf2u_30a.11e",  0x020000, 0x08beb861, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37a.11f",  0x020000, 0xb7638d69, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31a.12e",  0x020000, 0x0d5394e0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38a.12f",  0x020000, 0x42d6a79e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28a.9e",   0x020000, 0x387a175c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35a.9f",   0x020000, 0xa1a5adcc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ua)
STD_ROM_FN(Sf2ua)

static struct BurnRomInfo Sf2ubRomDesc[] = {
	{ "sf2u_30b.11e",  0x020000, 0x57bd7051, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37b.11f",  0x020000, 0x4a54d479, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31b.12e",  0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38b.12f",  0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28b.9e",   0x020000, 0x4009955e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35b.9f",   0x020000, 0x8c1f3994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ub)
STD_ROM_FN(Sf2ub)

static struct BurnRomInfo Sf2ucRomDesc[] = {
	{ "sf2u_30c.11e",  0x020000, 0x6cb59385, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37c.11f",  0x020000, 0x32e2c278, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31c.12e",  0x020000, 0xc4fff4a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38c.12f",  0x020000, 0x8210fc0e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28c.9e",   0x020000, 0x6eddd5e8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35c.9f",   0x020000, 0x6bcb404c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },
	
	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2uc)
STD_ROM_FN(Sf2uc)

static struct BurnRomInfo Sf2udRomDesc[] = {
	{ "sf2u_30d.11e",  0x020000, 0x4bb2657c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37d.11f",  0x020000, 0xb33b42f2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31d.12e",  0x020000, 0xd57b67d7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38d.12f",  0x020000, 0x9c8916ef, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28d.9e",   0x020000, 0x175819d1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35d.9f",   0x020000, 0x82060da4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ud)
STD_ROM_FN(Sf2ud)

static struct BurnRomInfo Sf2ueRomDesc[] = {
	{ "sf2u_30e.11e",  0x020000, 0xf37cd088, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37e.11f",  0x020000, 0x6c61a513, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31e.12e",  0x020000, 0x7c4771b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38e.12f",  0x020000, 0xa4bd0cd9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28e.9e",   0x020000, 0xe3b95625, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35e.9f",   0x020000, 0x3648769a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob2.11d",      0x000117, 0xd26f0a27, BRF_OPT },
	{ "c632b.ic1",     0x000117, 0x5c3cbb67, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ue)
STD_ROM_FN(Sf2ue)

static struct BurnRomInfo Sf2ufRomDesc[] = {
	{ "sf2u_30f.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37f.11f",  0x020000, 0x169e7388, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31f.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38f.12f",  0x020000, 0x1510e4e2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28f.9e",   0x020000, 0xacd8175b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35f.9f",   0x020000, 0xc0a80bd1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2uf)
STD_ROM_FN(Sf2uf)

static struct BurnRomInfo Sf2ugRomDesc[] = {
	{ "sf2u_30g.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37g.11f",  0x020000, 0x5886cae7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31g.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38g.12f",  0x020000, 0x5e22db70, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28g.9e",   0x020000, 0x8bf9f1e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35g.9f",   0x020000, 0x626ef934, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ug)
STD_ROM_FN(Sf2ug)

static struct BurnRomInfo Sf2uhRomDesc[] = {
	{ "sf2u_30h.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37h.11f",  0x020000, 0xe4dffbfe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31h.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38h.12f",  0x020000, 0xa659f678, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28h.9e",   0x020000, 0x8a5c8ee0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35h.9f",   0x020000, 0xc828fc4d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2uh)
STD_ROM_FN(Sf2uh)

static struct BurnRomInfo Sf2uiRomDesc[] = {
	{ "sf2u_30i.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37i.11f",  0x020000, 0x9df707dd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31i.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38i.12f",  0x020000, 0x4cb46daf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28i.9e",   0x020000, 0x1580be4c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35i.9f",   0x020000, 0x1468d185, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_9.12a",     0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ui)
STD_ROM_FN(Sf2ui)

static struct BurnRomInfo Sf2ukRomDesc[] = {
	{ "sf2u_30k.11e",  0x020000, 0x8f66076c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_37k.11f",  0x020000, 0x4e1f6a83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31k.12e",  0x020000, 0xf9f89f60, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38k.12f",  0x020000, 0x6ce0a85a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28k.9e",   0x020000, 0x8e958f31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35k.9f",   0x020000, 0xfce76fad, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_29a.10e",  0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_36a.10f",  0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.12a",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2uk)
STD_ROM_FN(Sf2uk)

static struct BurnRomInfo Sf2umRomDesc[] = {
	/* same as sf2jl - Street Fighter II: The World Warrior (Japan 920312) except for region byte */
	{ "sf-2u_30m.11e", 0x020000, 0x34a1ce02, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_37m.11f", 0x020000, 0x8cbff19c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_31m.12e", 0x020000, 0x64ebc8d2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_38m.12f", 0x020000, 0x73847443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_28m.9e",  0x020000, 0xeee2b426, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_35m.9f",  0x020000, 0xeca8b452, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_29m.10e", 0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2u_36m.10f", 0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2-5m.4a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2-7m.6a",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2-1m.3a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2-3m.5a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2-6m.4c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2-8m.6c",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2-2m.3c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2-4m.5c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2-13m.4d",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2-15m.6d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2-9m.3d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2-11m.5d",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.12a",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2um)
STD_ROM_FN(Sf2um)

static struct BurnRomInfo Sf2jRomDesc[] = {
	{ "sf2j30.bin",    0x020000, 0x79022b31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j37.bin",    0x020000, 0x516776ec, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j31.bin",    0x020000, 0xfe15cb39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j38.bin",    0x020000, 0x38614d70, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j28.bin",    0x020000, 0xd283187a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j35.bin",    0x020000, 0xd28158e4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29a.bin",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36a.bin",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.bin",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2j)
STD_ROM_FN(Sf2j)

static struct BurnRomInfo Sf2j17RomDesc[] = {
	{ "sf2_30l.11e",   0x020000, 0x79022b31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_37l.11f",  0x020000, 0x04ba20c7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_31l.12e",   0x020000, 0xfe15cb39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_38l.12f",   0x020000, 0x65cb1883, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_28l.9e",    0x020000, 0xd283187a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_35l.9f",    0x020000, 0xe3266622, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29l.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_36l.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.12a",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2j17)
STD_ROM_FN(Sf2j17)

static struct BurnRomInfo Sf2jaRomDesc[] = {
	{ "sf2j_30a.11e",  0x020000, 0x57bd7051, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_37a.11f",  0x020000, 0x1e1f6844, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_31a.12e",  0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_38a.12f",  0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_28a.9e",   0x020000, 0x4009955e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_35a.9f",   0x020000, 0x8c1f3994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_29a.10e",  0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_36a.10f",  0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2j_09.12a",   0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2j_18.11c",   0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2j_19.12c",   0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2ja)
STD_ROM_FN(Sf2ja)

static struct BurnRomInfo Sf2jcRomDesc[] = {
	{ "sf2j_30c.11e",  0x020000, 0x8add35ec, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_37c.11f",  0x020000, 0x0d74a256, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_31c.12e",  0x020000, 0xc4fff4a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_38c.12f",  0x020000, 0x8210fc0e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_28c.9e",   0x020000, 0x6eddd5e8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_35c.9f",   0x020000, 0x6bcb404c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_29a.10e",  0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_36a.10f",  0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.12a",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },  

	{ "sf2j_18.11c",   0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },  
	{ "sf2j_19.12c",   0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2jc)
STD_ROM_FN(Sf2jc)

static struct BurnRomInfo Sf2jfRomDesc[] = {
	{ "sf2j_30f.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2e_30g.11e
	{ "sf2j_37f.11f",  0x020000, 0xc1428cc6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_31f.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2e_31g.12e
	{ "sf2j_38f.12f",  0x020000, 0x1510e4e2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_28f.9e",   0x020000, 0xacd8175b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_35f.9f",   0x020000, 0xc0a80bd1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_29a.10e",  0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_29b.10e
	{ "sf2j_36a.10f",  0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_36b.10f

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.12a",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },  // == sf2_9.12a

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },  
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2jf)
STD_ROM_FN(Sf2jf)

static struct BurnRomInfo Sf2jhRomDesc[] = {
	{ "sf2j_30h.11e",  0x020000, 0xfe39ee33, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2e_30g.11e
	{ "sf2j_37h.11f",  0x020000, 0x330304b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_31h.12e",  0x020000, 0x69a0a301, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2e_31g.12e
	{ "sf2j_38h.12f",  0x020000, 0xa659f678, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_28h.9e",   0x020000, 0x8a5c8ee0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_35h.9f",   0x020000, 0xc828fc4d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_29a.10e",  0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_29b.10e
	{ "sf2j_36a.10f",  0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_36b.10f

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.12a",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },  // == sf2_9.12a

	{ "sf2_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },  
	{ "sf2_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },  
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2jh)
STD_ROM_FN(Sf2jh)

static struct BurnRomInfo Sf2jlRomDesc[] = {
	{ "sf-2_30l.11e",  0x020000, 0x34a1ce02, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // Verified "SF-2" without "J" for Japan region
	{ "sf-2_37l.11f",  0x020000, 0x5b630ed2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_31l.12e",  0x020000, 0x64ebc8d2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_38l.12f",  0x020000, 0x73847443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_28l.9e",   0x020000, 0xeee2b426, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_35l.9f",   0x020000, 0xeca8b452, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2j_29a.10e",  0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_29b.10e
	{ "sf2j_36a.10f",  0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_36b.10f

	{ "sf2_06.8a",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2j_09.12a",   0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },  // == sf2_09.12a / sf2_9.12a

	{ "sf2j_18.11c",   0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },  // == sf2_18.11c
	{ "sf2j_19.12c",   0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },  // == sf2_19.12c
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2jl)
STD_ROM_FN(Sf2jl)

static struct BurnRomInfo Sf2jlaRomDesc[] = {
	// Not yet added to MAME but dumped from a real official board from Capcom 
	{ "sf-2_30l.bin",  	0x020000, 0x79022b31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // Verified "SF-2" without "J" for Japan region
	{ "sf-2_37l.bin",  	0x020000, 0x04ba20c7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
	{ "sf-2_31l.bin",  	0x020000, 0xfe15cb39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_38l.bin",  	0x020000, 0x65cb1883, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_28l.bin",  	0x020000, 0xd283187a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf-2_35l.bin",  	0x020000, 0xe3266622, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_j_29_a.bin", 0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_29b.10e
	{ "sf2_j_36_a.bin", 0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  // == sf2_36b.10f

	{ "sf2_06.8a",     	0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.10a",    	0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.7a",     	0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.9a",     	0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.8c",     	0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.10c",    	0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.7c",     	0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.9c",     	0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.8d",     	0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.10d",    	0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.7d",     	0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.9d",     	0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2j_09.12a",   	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },  // == sf2_09.12a / sf2_9.12a

	{ "sf2j_18.11c",   	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },  // == sf2_18.11c
	{ "sf2j_19.12c",   	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },  // == sf2_19.12c
	
	A_BOARD_PLDS
	
	{ "stf29.1a",      0x000117, 0x043309c5, BRF_OPT },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Sf2jla)
STD_ROM_FN(Sf2jla)

static struct BurnRomInfo Sf2qp1RomDesc[] = {
	{ "stfii-qkn-cps-17.33", 0x080000, 0x3a9458ee, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "stfii-qkn-cps-17.34", 0x080000, 0x4ed215d8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sf2_06.bin",    		 0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.bin",    		 0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.bin",    		 0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.bin",    		 0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.bin",    		 0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.bin",    		 0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.bin",    		 0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.bin",    		 0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.bin",    		 0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.bin",    		 0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.bin",    		 0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.bin",    		 0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.bin",    		 0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.bin",    		 0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.bin",    		 0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Sf2qp1)
STD_ROM_FN(Sf2qp1)

static struct BurnRomInfo Sf2qp2RomDesc[] = {
	{ "qkn.33", 	   0x080000, 0x43aa343d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "qkn.34", 	   0x080000, 0xd03b553f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sf2_06.bin",    0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.bin",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.bin",    0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.bin",    0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.bin",    0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.bin",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.bin",    0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.bin",    0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.bin",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.bin",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.bin",    0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.bin",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.bin",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Sf2qp2)
STD_ROM_FN(Sf2qp2)

static struct BurnRomInfo Sf2thndrRomDesc[] = {
	// speed modifiable via dsw
	{ "17_30.11e",     0x020000, 0xd3cd6d18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "17_37.11f",     0x020000, 0xe892716e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_31b.12e",  0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_38b.12f",  0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_28b.9e",   0x020000, 0x4009955e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2u_35b.9f",   0x020000, 0x8c1f3994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "17_29.10e",     0x020000, 0x8830b54d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "17_36.10f",     0x020000, 0x3f13ada3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2_06.bin",    0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.bin",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.bin",    0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.bin",    0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.bin",    0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.bin",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.bin",    0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.bin",    0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.bin",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.bin",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.bin",    0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.bin",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.bin",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Sf2thndr)
STD_ROM_FN(Sf2thndr)

static struct BurnRomInfo Sf2thndr2RomDesc[] = {
	// has interruptible and aerial special moves, speed modifiable via dsw, only the program ROMs were provided, rest taken from sf2thundr
	{ "31.bin",        0x020000, 0xeec8cbe3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "38.bin",        0x020000, 0x1c0fc4e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "30.bin",        0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "37.bin",        0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "28.bin",        0x020000, 0x4009955e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.bin",        0x020000, 0x8c1f3994, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "29.bin",        0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "36.bin",        0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sf2_06.bin",    0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.bin",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.bin",    0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.bin",    0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.bin",    0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.bin",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.bin",    0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.bin",    0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.bin",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.bin",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.bin",    0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.bin",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "sf2_09.bin",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sf2_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Sf2thndr2)
STD_ROM_FN(Sf2thndr2)

static struct BurnRomInfo Sf2bRomDesc[] = {
	{ "pf1-2-sg076.bin",	0x0100000, 0x1d15bc7a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	
	// the pcb is missing some pals/gals so it cannot be tested 
	{ "pf4-sg072.bin",  0x0100000, 0x16289710, BRF_GRA | CPS1_TILES },
	{ "pf7-sg103.bin", 	0x0100000, 0xfb78022e, BRF_GRA | CPS1_TILES },
	{ "pf5-sg095.bin",  0x0100000, 0x0a6be48b, BRF_GRA | CPS1_TILES },
	{ "pf8-sg101.bin",  0x0100000, 0x6258c7cf, BRF_GRA | CPS1_TILES },
	{ "pf6-sg068.bin",  0x0100000, 0x9b5b09d7, BRF_GRA | CPS1_TILES },
	{ "pf9-sh001.bin",  0x0100000, 0x9f25090e, BRF_GRA | CPS1_TILES },

	{ "3snd.ic28",     	0x0020000, 0xd5bee9cc, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Sf2b)
STD_ROM_FN(Sf2b)

static struct BurnRomInfo Sf2b2RomDesc[] = {
    { "2.bin", 	  	  0x0080000, 0x42809e5a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.bin", 	  	  0x0080000, 0xe58db26c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "5.bin",        0x0080000, 0x47fab9ed, BRF_GRA | CPS1_TILES },
	{ "11.bin",       0x0080000, 0x6e8c98d8, BRF_GRA | CPS1_TILES },	
	{ "8.bin",        0x0080000, 0xb8c39d56, BRF_GRA | CPS1_TILES },	
	{ "14.bin",       0x0080000, 0x672d4f85, BRF_GRA | CPS1_TILES },
	{ "4.bin",        0x0080000, 0x69d7b06b, BRF_GRA | CPS1_TILES },
	{ "10.bin",       0x0080000, 0x8c2fca3c, BRF_GRA | CPS1_TILES },	
	{ "7.bin",        0x0080000, 0xded88f5f, BRF_GRA | CPS1_TILES },
	{ "13.bin",       0x0080000, 0x26f09d38, BRF_GRA | CPS1_TILES },
	{ "6.bin",        0x0080000, 0xb6215991, BRF_GRA | CPS1_TILES },
	{ "12.bin",       0x0080000, 0x971903fa, BRF_GRA | CPS1_TILES },	
	{ "9.bin",        0x0080000, 0xb6a71ed7, BRF_GRA | CPS1_TILES },
	{ "15.bin",       0x0080000, 0x00983914, BRF_GRA | CPS1_TILES },

	{ "3.bin",        0x0020000, 0x17d5ba8a, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Sf2b2)
STD_ROM_FN(Sf2b2)

static struct BurnRomInfo Sf2b3RomDesc[] = {
	// Program roms u195 and u221 were missing from the PCB
//  { "prg.u195",      0x080000, 0x00000000, BRF_ESS | BRF_PRG | BRF_NODUMP }, // missing from dump
//  { "prg.u221",      0x080000, 0x00000000, BRF_ESS | BRF_PRG | BRF_NODUMP }, // missing from dump
	// Instead we use some programs rom from sf2eb
	{ "sf2e_30b.11e",  0x020000, 0x57bd7051, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "sf2e_37b.11f",  0x020000, 0x62691cdd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
	{ "sf2e_31b.12e",  0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "sf2e_38b.12f",  0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
	{ "prh2.u222",     0x040000, 0x6d0f77b8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prl1.u196",     0x040000, 0x9b96ee64, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
		
	{ "bdst-1.u70",    0x100000, 0xa94a8b19, BRF_GRA | CPS1_TILES },
	{ "bdst-4.u68",    0x100000, 0x0405f21f, BRF_GRA | CPS1_TILES },
	{ "bdst-2.u69",    0x100000, 0x05dc2043, BRF_GRA | CPS1_TILES },
	{ "bdst-5.u64",    0x100000, 0x055b64f1, BRF_GRA | CPS1_TILES },
	{ "bdst-3.u19",    0x100000, 0x1a518609, BRF_GRA | CPS1_TILES },
	{ "bdst-6.u18",    0x100000, 0x84f9354f, BRF_GRA | CPS1_TILES },
	
	{ "sound.u191",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "voice.u210",    0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "grp1.u31",      0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp3.u29",      0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp2.u30",      0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp4.u28",      0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "u133",          0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2b3)
STD_ROM_FN(Sf2b3)

static struct BurnRomInfo Sf2b4RomDesc[] = {
/*Street Fighter 2 bootleg


This game runs on a single bootleg PCB.
It uses 2 square PLCC custom graphics chips by Altera
On chips are written ...
ALTERA EP1810LC
I have seen a similar ALTERA chip on a Killer Instinct PCB


CPU: 68000-10, Z8400 (Z80A)
SND: YM2151, OKI6295, YM3012A
OSC: 16.000Mhz, 10.000Mhz, 3.5795Mhz

Developers:
This PCB also has some 42 Pin Mask roms which are not dumped 
as my reader will only accept up to 40 pin roms.
Hopefully, the existing dumped gfx roms will be the same.

If you need more info, contact me.

theguru@emuunlim.com*/

	{ "sf2e_30b.11e",  0x020000, 0x57bd7051, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // missing from dump (u6.bin and u5.bin match this set closest)
	{ "sf2e_37b.11f",  0x020000, 0x62691cdd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // missing from dump (u6.bin and u5.bin match this set closest)
	{ "sf2e_31b.12e",  0x020000, 0xa673143d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // missing from dump (u6.bin and u5.bin match this set closest)
	{ "sf2e_38b.12f",  0x020000, 0x4c2ccef7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // missing from dump (u6.bin and u5.bin match this set closest)
	{ "u6.bin",        0x020000, 0x5cfc3f39, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u5.bin",        0x020000, 0x47dd24b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2_29b.10e",   0x020000, 0xbb4af315, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // missing from dump (u6.bin and u5.bin match this set closest)
	{ "sf2_36b.10f",   0x020000, 0xc02a13eb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // missing from dump (u6.bin and u5.bin match this set closest)
	
	{ "sf2_06.bin",    0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES },
	{ "sf2_08.bin",    0x080000, 0x57213be8, BRF_GRA | CPS1_TILES },
	{ "sf2_05.bin",    0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES },
	{ "sf2_07.bin",    0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES },
	{ "sf2_15.bin",    0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES },
	{ "sf2_17.bin",    0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES },
	{ "sf2_14.bin",    0x080000, 0x14b84312, BRF_GRA | CPS1_TILES },
	{ "sf2_16.bin",    0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES },
	{ "sf2_25.bin",    0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES },
	{ "sf2_27.bin",    0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES },
	{ "sf2_24.bin",    0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES },
	{ "sf2_26.bin",    0x080000, 0x0627c831, BRF_GRA | CPS1_TILES },

	{ "u7.bin",        0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "u8.bin",        0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "sf2-1.bin",     0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "sf2-3.bin",     0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "sf2-2.bin",     0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "sf2-4.bin",     0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "sf2-5.bin",     0x010000, 0x13ea1c44, BRF_OPT }, // unknown
	
	{ "u3.bin",        0x020000, 0x2c9ece7c, BRF_OPT }, // seems to have most in common with some extra gfx roms, but also some program roms, maybe bad dump or maybe needing data from Altera chip?
	{ "u4.bin",        0x020000, 0x4efb4c7a, BRF_OPT }, // seems to have most in common with some extra gfx roms, but also some program roms, maybe bad dump or maybe needing data from Altera chip?
};

STD_ROM_PICK(Sf2b4)
STD_ROM_FN(Sf2b4)

static struct BurnRomInfo Sf2rkRomDesc[] = {
	{ "w6.u222",       0x080000, 0x49422b6f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "w5.u196",       0x080000, 0x7e9c8c2f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "01 rk098",      0x100000, 0x4296de4d, BRF_GRA | CPS1_TILES },
	{ "03 rk097",      0x100000, 0x16cf11d0, BRF_GRA | CPS1_TILES },
	{ "02 rk037",      0x100000, 0x68ca7fce, BRF_GRA | CPS1_TILES },
	{ "04 rk033",      0x100000, 0x9f46f926, BRF_GRA | CPS1_TILES },
	{ "05 rk116",      0x100000, 0x4c161fa9, BRF_GRA | CPS1_TILES },
	{ "06 rk077",      0x100000, 0xec949f8c, BRF_GRA | CPS1_TILES },

	{ "1.rk",    	   0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "w7.u210",       0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },

	{ "w-1",      	   0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "w-2",           0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "w-3",           0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "w-4",           0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },

	{ "2.rk",     	   0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2rk)
STD_ROM_FN(Sf2rk)

static struct BurnRomInfo Sf2rk2RomDesc[] = {
// 	u222.bin is almost identical to w6.u222 from sf2rk set; only 1 difference found at offset 2295: 60  6B. 
// 	Probably a bitrot; needs redump.
//  { "u222.bin",       	0x080000, 0x49422b6f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "u222.bin",     		0x080000, 0x10eea0b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196.bin",       	0x080000, 0x7e9c8c2f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
// 	Different from sf2rk set. Instead it uses same GFX ROMs as sf2rules.
	{ "u70.bin",    		0x100000, 0xa258de13, BRF_GRA | CPS1_TILES },
	{ "u68.bin",    		0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES },
	{ "u69.bin",    		0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES },
	{ "u67.bin",    		0x100000, 0xbc90c12f, BRF_GRA | CPS1_TILES },
	{ "u19.bin",    		0x100000, 0x187667cc, BRF_GRA | CPS1_TILES },
	{ "u18.bin",    		0x100000, 0x5b585071, BRF_GRA | CPS1_TILES },
	
// 	Not present in original dump.
	{ "sound.u191",    		0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

// 	Original dump has double size and part 1 and 2 are identical; it is probably an overdump.
//	{ "u210.bin",    		0x080000, 0x44d62caa, BRF_SND | CPS1_OKIM6295_SAMPLES }, // 
	{ "u210.bin",    		0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES }, // 
	
	//u31.bin is amost identical to 6.amf; only 1 difference found at offset 74500: 6B  69. 
	// Probably a bitrot; needs redump.
//	{ "u31.bin",        	0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "u31.bin",        	0x020000, 0x3e9b4e52, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "u29.bin",        	0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "u30.bin",        	0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "u28.bin",       		0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "conv.u133",     		0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2rk2)
STD_ROM_FN(Sf2rk2)

static struct BurnRomInfo Sf2rulesRomDesc[] = {
    { "prh2.u222",     		0x080000, 0xfff85f9b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prl1.u196",     		0x080000, 0x65c28bc9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "ycecmkr001.u70",    	0x100000, 0xa258de13, BRF_GRA | CPS1_TILES },
	{ "ycecmkr003.u69",    	0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES },
	{ "ycecmkr002.u68",    	0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES },
	{ "ycecdwc011.u64",    	0x100000, 0xbc90c12f, BRF_GRA | CPS1_TILES },
	{ "ycecdwc012.u19",    	0x100000, 0x187667cc, BRF_GRA | CPS1_TILES },
	{ "ycecdwc013.u18",    	0x100000, 0x5b585071, BRF_GRA | CPS1_TILES },
	
	{ "sound.u191",    		0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "voice.u210",    		0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "grp1.u31",      		0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp3.u29",      		0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp2.u30",      		0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp4.u28",      		0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "conv.u133",     		0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2rules)
STD_ROM_FN(Sf2rules)

static struct BurnRomInfo Sf2ceRomDesc[] = {
	{ "s92e_23b.8f",   0x080000, 0x0aaa1a3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22b.7f",    0x080000, 0x2bbe15ed, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ce)
STD_ROM_FN(Sf2ce)

static struct BurnRomInfo Sf2ceeaRomDesc[] = {
	{ "s92e_23a.8f",   0x080000, 0x3f846b74, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22a.7f",    0x080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceea)
STD_ROM_FN(Sf2ceea)

static struct BurnRomInfo Sf2ceecRomDesc[] = {
	{ "s92e_23c.8f",   0x080000, 0x994b408d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22c.7f",    0x080000, 0x5fd8630b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceec)
STD_ROM_FN(Sf2ceec)

static struct BurnRomInfo Sf2cejaRomDesc[] = {
	{ "s92j_23a.8f",   0x080000, 0x4f42bb5a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92j_22a.7f",   0x080000, 0xc4f64bcd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.3c",     0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.4c",     0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.5c",     0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.6c",     0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceja)
STD_ROM_FN(Sf2ceja)

static struct BurnRomInfo Sf2cejbRomDesc[] = {
	{ "s92j_23b.8f",   0x080000, 0x140876c5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92j_22b.7f",   0x080000, 0x2fbb3bfe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.3c",     0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.4c",     0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.5c",     0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.6c",     0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2cejb)
STD_ROM_FN(Sf2cejb)

static struct BurnRomInfo Sf2cejcRomDesc[] = {
	{ "s92j_23c.8f",   0x080000, 0xf0120635, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92j_22c.7f",   0x080000, 0x8c0b2ed6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92j_21a.6f",   0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.3c",     0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.4c",     0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.5c",     0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.6c",     0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2cejc)
STD_ROM_FN(Sf2cejc)

static struct BurnRomInfo Sf2ceuaRomDesc[] = {
	{ "s92u_23a.8f",   0x080000, 0xac44415b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22a.7f",    0x080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceua)
STD_ROM_FN(Sf2ceua)

static struct BurnRomInfo Sf2ceubRomDesc[] = {
	{ "s92u_23b.8f",   0x080000, 0x996a3015, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22b.7f",    0x080000, 0x2bbe15ed, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceub)
STD_ROM_FN(Sf2ceub)

static struct BurnRomInfo Sf2ceucRomDesc[] = {
	{ "s92u_23c.8f",   0x080000, 0x0a8b6aa2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22c.7f",    0x080000, 0x5fd8630b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceuc)
STD_ROM_FN(Sf2ceuc)

static struct BurnRomInfo Sf2cetRomDesc[] = {
	{ "s92t_23a.8f",   0x080000, 0xd7c28ade, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_22a.7f",    0x080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2cet)
STD_ROM_FN(Sf2cet)

static struct BurnRomInfo Sf2accRomDesc[] = {
	{ "sf2ca_23-c.bin", 0x080000, 0xe7c8c5a6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2ca_22-c.bin", 0x080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2ca_21-c.bin", 0x040000, 0xcf7fcc8c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",     0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",     0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",     0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",     0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",     0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",     0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",     0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",     0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2acc)
STD_ROM_FN(Sf2acc)

static struct BurnRomInfo Sf2accaRomDesc[] = {
	{ "23-c.8f",        0x080000, 0x35f9517b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22-c.7f",        0x080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "21-c.6f",        0x080000, 0x2ab2034f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",     0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",     0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",     0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",     0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",     0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",     0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",     0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",     0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2acca)
STD_ROM_FN(Sf2acca)

static struct BurnRomInfo Sf2accp2RomDesc[] = {
	{ "sf2ca-23.bin",  0x080000, 0x36c3ba2f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2ca-22.bin",  0x080000, 0x0550453d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2ca-21.bin",  0x040000, 0x4c1c43ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2accp2)
STD_ROM_FN(Sf2accp2)

static struct BurnRomInfo Sf2dkot2RomDesc[] = {
	{ "turboii.23",    0x080000, 0x9bbfe420, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "turboii.22",    0x080000, 0x3e57ba19, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "turboii.21",    0x080000, 0xed4186bd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2dkot2)
STD_ROM_FN(Sf2dkot2)

static struct BurnRomInfo Sf2rbRomDesc[] = {
	{ "sf2d__23.rom",  0x080000, 0x450532b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2d__22.rom",  0x080000, 0xfe9d9cf5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.bin",   0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2rb)
STD_ROM_FN(Sf2rb)

static struct BurnRomInfo Sf2rb2RomDesc[] = {
	// Is this really a rainbow set? There is no rainbow logo and little else in common
	{ "27.bin",        0x020000, 0x40296ecd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "31.bin",        0x020000, 0x87954a41, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "26.bin",        0x020000, 0xa6974195, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "30.bin",        0x020000, 0x8141fe32, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "25.bin",        0x020000, 0x9ef8f772, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "29.bin",        0x020000, 0x7d9c479c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "24.bin",        0x020000, 0x93579684, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "28.bin",        0x020000, 0xff728865, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",   0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2rb2)
STD_ROM_FN(Sf2rb2)

static struct BurnRomInfo Sf2rb3RomDesc[] = {
	{ "sf2_ce_rb.23",  0x080000, 0x202f9e50, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2_ce_rb.22",  0x080000, 0x145e5219, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.bin",   0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2rb3)
STD_ROM_FN(Sf2rb3)

static struct BurnRomInfo Sf2rb4RomDesc[] = {
	// this set was previously known as sf2m4
	{ "u222ne",       0x0080000, 0x7133489e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196ne",       0x0080000, 0xb07a4f90, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2rb4)
STD_ROM_FN(Sf2rb4)

static struct BurnRomInfo Sf2rb5RomDesc[] = {
	// this set was previously known as sf2m12
	{ "sfu8-1.040",   0x0080000, 0x10ec67fe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu8-3.040",   0x0080000, 0x92eb3a1c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu8-2.010",   0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu8-4.010",   0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2rb5)
STD_ROM_FN(Sf2rb5)

static struct BurnRomInfo Sf2rb6RomDesc[] = {
	{ "cebl_23",       0x080000, 0x1439fcad, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cebl_22",       0x080000, 0x27e80cb1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cebl_21",       0x080000, 0xf21e3046, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2rb6)
STD_ROM_FN(Sf2rb6)

static struct BurnRomInfo Sf2redRomDesc[] = {
	{ "sf2red.23",     0x080000, 0x40276abb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2red.22",     0x080000, 0x18daf387, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2red.21",     0x080000, 0x52c486bb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2red)
STD_ROM_FN(Sf2red)

static struct BurnRomInfo Sf2redaRomDesc[] = {
	{ "stf champ wave rom 23.8f",     0x080000, 0xeb265dc7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "stf champ wave rom 22.7f",     0x080000, 0x27e80cb1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "stf champ wave rom 21.6f",     0x080000, 0x04fff17b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },

	A_BOARD_PLDS

	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "pw.11d",        0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2reda)
STD_ROM_FN(Sf2reda)

static struct BurnRomInfo Sf2redp2RomDesc[] = {
	{ "sf2red.23",     0x080000, 0x2d3c4f72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2red.22",     0x080000, 0x18daf387, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2red.21",     0x080000, 0xaaf693b5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2redp2)
STD_ROM_FN(Sf2redp2)

static struct BurnRomInfo Sf2red2RomDesc[] = {
	//  this set was previously known as sf2m13
	{ "sf3d5-1040",   0x0080000, 0xbcdd2c3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3d5-3040",   0x0080000, 0x01965987, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3d5-2010",   0x0020000, 0xdd2e1d31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3d5-4010",   0x0020000, 0xc95e4443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2red2)
STD_ROM_FN(Sf2red2)

static struct BurnRomInfo Sf2v004RomDesc[] = {
	{ "sf2v004.23",    0x080000, 0x52d19f2c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2v004.22",    0x080000, 0x4b26fde7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2red.21",     0x080000, 0x52c486bb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2v004)
STD_ROM_FN(Sf2v004)

static struct BurnRomInfo Sf2v0042RomDesc[] = {
	// this set was previously known as sf2m15
	{ "sf3g-1.040",   0x0080000, 0xc90559a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3g-3.040",   0x0080000, 0x81f36682, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3g-2.010",   0x0020000, 0x9eee20a1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3g-4.010",   0x0020000, 0x6ac3d875, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2v0042)
STD_ROM_FN(Sf2v0042)

static struct BurnRomInfo Sf2v0043RomDesc[] = {
	{ "22_08-92.7f",   0x080000, 0x95fbcc3e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "21_08-92.6f",   0x080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "23_08-92.8f",   0x080000, 0x52c486bb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2v0043)
STD_ROM_FN(Sf2v0043)

static struct BurnRomInfo Sf2dongbRomDesc[] = {
	{ "1.8f",         0x0080000, 0x19fffa37, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "1.7f",         0x0080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "1.6f",         0x0080000, 0x65c2c719, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2dongb)
STD_ROM_FN(Sf2dongb)

static struct BurnRomInfo Sf2bhhRomDesc[] = {
	{ "23",  		   0x0080000, 0x5cf63a9e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22",  		   0x0080000, 0x3ed72bca, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s92_21a.6f",    0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },

	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2bhh)
STD_ROM_FN(Sf2bhh)

static struct BurnRomInfo Sf2hfRomDesc[] = {
	{ "s2te_23.8f",    0x080000, 0x2dd72514, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2te_22.7f",    0x080000, 0xaea6e035, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2te_21.6f",    0x080000, 0xfd200288, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2hf)
STD_ROM_FN(Sf2hf)

static struct BurnRomInfo Sf2hfuRomDesc[] = {
	{ "s2tu_23.8f",    0x080000, 0x89a1fc38, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2tu_22.7f",    0x080000, 0xaea6e035, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2tu_21.6f",    0x080000, 0xfd200288, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92-1m.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2hfu)
STD_ROM_FN(Sf2hfu)

static struct BurnRomInfo Sf2hfjRomDesc[] = {
	{ "s2tj_23.8f",    0x080000, 0xea73b4dc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2tj_22.7f",    0x080000, 0xaea6e035, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2tj_21.6f",    0x080000, 0xfd200288, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s2t_10.3c",     0x080000, 0x3c042686, BRF_GRA | CPS1_TILES },
	{ "s2t_11.4c",     0x080000, 0x8b7e7183, BRF_GRA | CPS1_TILES },
	{ "s2t_12.5c",     0x080000, 0x293c888c, BRF_GRA | CPS1_TILES },
	{ "s2t_13.6c",     0x080000, 0x842b35a4, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2hfj)
STD_ROM_FN(Sf2hfj)

static struct BurnRomInfo Sf2hfubRomDesc[] = {
	{ "s2tu-23",       0x080000, 0x71d36456, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2tu-22",       0x080000, 0x8259426a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "s2tu-21",       0x080000, 0x938f44d5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.3a",     0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",     0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",     0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",     0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",     0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",     0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",     0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s2t_10.3c",     0x080000, 0x3c042686, BRF_GRA | CPS1_TILES },
	{ "s2t_11.4c",     0x080000, 0x8b7e7183, BRF_GRA | CPS1_TILES },
	{ "s2t_12.5c",     0x080000, 0x293c888c, BRF_GRA | CPS1_TILES },
	{ "s2t_13.6c",     0x080000, 0x842b35a4, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2hfub)
STD_ROM_FN(Sf2hfub)

static struct BurnRomInfo Sf2hfjbRomDesc[] = {
	// This set is also known as sf2ce13
	{ "222-040.13",    0x080000, 0xec6f5cb3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "196-040.13",    0x080000, 0x0e9ac52b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "221-010.13",    0x020000, 0x8226c11c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "195-010.13",    0x020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s2t_10.bin",    0x080000, 0x3c042686, BRF_GRA | CPS1_TILES },
	{ "s2t_11.bin",    0x080000, 0x8b7e7183, BRF_GRA | CPS1_TILES },
	{ "s2t_12.bin",    0x080000, 0x293c888c, BRF_GRA | CPS1_TILES },
	{ "s2t_13.bin",    0x080000, 0x842b35a4, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2hfjb)
STD_ROM_FN(Sf2hfjb)

static struct BurnRomInfo Sf2hfjb2RomDesc[] = {
	{ "sf12-1.040",    0x080000, 0xec6f5cb3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf12-3.040",    0x080000, 0x0e9ac52b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf12-2.010",    0x020000, 0xd1707134, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf12-4.010",    0x020000, 0xcd1d5666, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s2t_10.bin",    0x080000, 0x3c042686, BRF_GRA | CPS1_TILES },
	{ "s2t_11.bin",    0x080000, 0x8b7e7183, BRF_GRA | CPS1_TILES },
	{ "s2t_12.bin",    0x080000, 0x293c888c, BRF_GRA | CPS1_TILES },
	{ "s2t_13.bin",    0x080000, 0x842b35a4, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2hfjb2)
STD_ROM_FN(Sf2hfjb2)

static struct BurnRomInfo Sf2yycRomDesc[] = {
	{ "b12.rom",      0x0080000, 0x8f742fd5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "b14.rom",      0x0080000, 0x8831ec7f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "b11.rom",      0x0020000, 0x94a46525, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "b13.rom",      0x0020000, 0x8fb3dd47, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },

#if !defined ROM_VERIFY	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
#endif
};

STD_ROM_PICK(Sf2yyc)
STD_ROM_FN(Sf2yyc)

static struct BurnRomInfo Sf2yyc2RomDesc[] = {
	// This set was previously known as sf2m14
	{ "sf6-1.040",    0x0080000, 0xccd74822, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf6-3.040",    0x0080000, 0x2a48b557, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf6-2.010",    0x0020000, 0x64e6e091, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf6-4.010",    0x0020000, 0xc95e4443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2yyc2)
STD_ROM_FN(Sf2yyc2)

static struct BurnRomInfo Sf2koryuRomDesc[] = {
	{ "u222.rom",     0x0080000, 0x9236a79a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196.rom",     0x0080000, 0xb23a869d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u221.rom",     0x0020000, 0x64e6e091, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u195.rom",     0x0020000, 0xc95e4443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

#if !defined ROM_VERIFY
	{ "u70.rom",      0x0100000, 0xbaa0f81f, BRF_GRA | CPS1_TILES },
	{ "u68.rom",      0x0100000, 0x8edff95a, BRF_GRA | CPS1_TILES },
	{ "u69.rom",      0x0100000, 0x468962b1, BRF_GRA | CPS1_TILES },
	{ "u64.rom",      0x0100000, 0x8165f536, BRF_GRA | CPS1_TILES },
	{ "u19.rom",      0x0100000, 0x39d763d3, BRF_GRA | CPS1_TILES },
	{ "u18.rom",      0x0100000, 0x93ec42ae, BRF_GRA | CPS1_TILES },
#else
	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },
#endif

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2koryu)
STD_ROM_FN(Sf2koryu)

static struct BurnRomInfo Sf2koryu2RomDesc[] = {
    { "sf10-3040",    0x0080000, 0x9236a79a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf10-1040",    0x0080000, 0xb23a869d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf10-2010",    0x0020000, 0x8226c11c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "sf10-4010",    0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2koryu2)
STD_ROM_FN(Sf2koryu2)

static struct BurnRomInfo Sf2koryu3RomDesc[] = {
	// this set was previously known as sf2m6
	{ "27c040.u222",    	0x0080000, 0x0a3692be, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c040.u196",    	0x0080000, 0x80454da7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c010.u221",     	0x0020000, 0x8226c11c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27c010.u195",     	0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ycecmkr001.u70", 	0x100000, 0xa258de13, BRF_GRA | CPS1_TILES }, 
	{ "ycecmkr003.u69", 	0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES }, 
	{ "ycecmkr002.u68", 	0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES }, 
	{ "ycecdwc011.u68", 	0x100000, 0xbc90c12f, BRF_GRA | CPS1_TILES }, 
	{ "ycecdwc012.u64", 	0x100000, 0x187667cc, BRF_GRA | CPS1_TILES }, 
	{ "ycecdwc013.u18", 	0x100000, 0x5b585071, BRF_GRA | CPS1_TILES }, 

	{ "sound.u191",    		0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "voice.u210",  		0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "grp1.u31",      		0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp3.u29",      		0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp2.u30",      		0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp4.u28",      		0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "conv.u133",    		0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2koryu3)
STD_ROM_FN(Sf2koryu3)

static struct BurnRomInfo Sf2amfRomDesc[] = {
	{ "5.amf",             	0x080000, 0x03991fba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.amf",             	0x080000, 0x39f15a1e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
#if !defined ROM_VERIFY
	{ "4.u221",  		   	0x040000, 0xb0bb6242, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // wasn't in original dump (set seems to be same as sf2amf7 but with different graphics roms)
	{ "3.u195",            	0x040000, 0xf516e578, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // wasn't in original dump (set seems to be same as sf2amf7 but with different graphics roms)
#else
	{ "prg part 3.amf",    	0x040000, 0x00000000, BRF_OPT | BRF_PRG | BRF_NODUMP | CPS1_68K_PROGRAM_BYTESWAP },
	{ "prg part 4.amf",    	0x040000, 0x00000000, BRF_OPT | BRF_PRG | BRF_NODUMP | CPS1_68K_PROGRAM_BYTESWAP },
#endif	
	
	{ "y.c.e.c m.k.r-001", 	0x100000, 0xa258de13, BRF_GRA | CPS1_TILES }, 
	{ "y.c.e.c m.k.r-003", 	0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES }, 
	{ "y.c.e.c m.k.r-002", 	0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES }, 
	{ "y.c.e.c d.w.c-011", 	0x100000, 0xbc90c12f, BRF_GRA | CPS1_TILES }, 
	{ "y.c.e.c d.w.c-012", 	0x100000, 0x187667cc, BRF_GRA | CPS1_TILES }, 
	{ "y.c.e.c d.w.c-013", 	0x100000, 0x5b585071, BRF_GRA | CPS1_TILES }, 

	{ "3.amf",             	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "2.amf",             	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "1.amf",             	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "6.amf",             	0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",             	0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",             	0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",            	0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },

	{ "7.amf",             	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2amf)
STD_ROM_FN(Sf2amf)

static struct BurnRomInfo Sf2amf2RomDesc[] = {
	{ "m5m27c401.u222", 0x080000, 0x03991fba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "m5m27c401.u196", 0x080000, 0x39f15a1e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
	{ "27020.u221",  	0x040000, 0xaa4d55a6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "27020.u195",  	0x040000, 0x2bffa6f9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
		
	{ "fun-u70.bin",   	0x100000, 0xa94a8b19, BRF_GRA | CPS1_TILES },
	{ "fun-u68.bin",   	0x100000, 0x0405f21f, BRF_GRA | CPS1_TILES },
	{ "fun-u69.bin",   	0x100000, 0x05dc2043, BRF_GRA | CPS1_TILES },
	{ "fun-u67.bin",   	0x100000, 0x055b64f1, BRF_GRA | CPS1_TILES },
	{ "fun-u19.bin",   	0x100000, 0x1a518609, BRF_GRA | CPS1_TILES },
	{ "fun-u18.bin",   	0x100000, 0x84f9354f, BRF_GRA | CPS1_TILES },
	
	{ "27512.u191",    	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "fun-u210.bin",  	0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "grp1.u31",      	0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp3.u29",      	0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp2.u30",      	0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp4.u28",      	0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "27512.u133",    	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2amf2)
STD_ROM_FN(Sf2amf2)

/* This set is identical to sf2amf2 except for program roms, the pcb has some kind of mod around the rom area with cut traces
   and a17 pins of u221 and u195 bent out of their sockets and connected together with a wire.
   Perhaps it's an "upgraded" sf2amf2 board ? */
static struct BurnRomInfo Sf2amf3RomDesc[] = {
	{ "u222.bin", 	   0x080000, 0x0d305e8b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196.bin", 	   0x080000, 0x137d8665, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
	{ "u221.bin",  	   0x040000, 0x0b3fe5dd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "u195.bin",  	   0x040000, 0xdbee7b18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
		
	{ "fun-u70.bin",   0x100000, 0xa94a8b19, BRF_GRA | CPS1_TILES },
	{ "fun-u68.bin",   0x100000, 0x0405f21f, BRF_GRA | CPS1_TILES },
	{ "fun-u69.bin",   0x100000, 0x05dc2043, BRF_GRA | CPS1_TILES },
	{ "fun-u67.bin",   0x100000, 0x055b64f1, BRF_GRA | CPS1_TILES },
	{ "fun-u19.bin",   0x100000, 0x1a518609, BRF_GRA | CPS1_TILES },
	{ "fun-u18.bin",   0x100000, 0x84f9354f, BRF_GRA | CPS1_TILES },
	
	{ "27512.u191",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "fun-u210.bin",  0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "grp1.u31",      0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp3.u29",      0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp2.u30",      0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp4.u28",      0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "27512.u133",    0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2amf3)
STD_ROM_FN(Sf2amf3)

static struct BurnRomInfo Sf2amf4RomDesc[] = {
	// this set was previously known as sf2m7
	{ "u222-2i",      0x0040000, 0x1ca7adbd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196-2i",      0x0040000, 0xf758408c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u222-2s",      0x0040000, 0x720cea3e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196-2s",      0x0040000, 0x9932832c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2amf4)
STD_ROM_FN(Sf2amf4)

static struct BurnRomInfo Sf2amf5RomDesc[] = {
	// this set was previously known as sf2m10
	{ "sfu9-1.040",   0x0080000, 0x95306baf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu9-3.040",   0x0080000, 0x21024d5f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu9-2.020",   0x0040000, 0x0b3fe5dd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu9-4.020",   0x0040000, 0xdbee7b18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo (it's the only set that shows the ' after the logo
};

STD_ROM_PICK(Sf2amf5)
STD_ROM_FN(Sf2amf5)

static struct BurnRomInfo Sf2amf6RomDesc[] = {
	// this set was previously known as sf2th
//	This was the original dump (JacKc found that if you split it into 4 then parts 2, 3 and 4 match u196 from sf2m5)
//	The first 128Kb of the original dump appears to be missing data, and we are assuming that the dump is bad and using
//	the u196 dump instead
//	{ "stf2th-5.bin", 0x0080000, 0x3127302c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "stf2th-7.bin", 	0x0080000, 0x03991fba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "stf2th-5.bin", 	0x0080000, 0x39f15a1e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "stf2th-6.bin", 	0x0020000, 0x64e6e091, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "stf2th-4.bin", 	0x0020000, 0xc95e4443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   	0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   	0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   	0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   	0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   	0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   	0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   	0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   	0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   	0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   	0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   	0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   	0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   	0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   	0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   	0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "stf2th-10.bin", 	0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "stf2th-12.bin", 	0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "stf2th-9.bin",  	0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "stf2th-11.bin", 	0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "sf2th-8.bin",   	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2amf6)
STD_ROM_FN(Sf2amf6)

static struct BurnRomInfo Sf2amf7RomDesc[] = {
	// this set was previously known as sf2tha
	{ "t-2.u52",        	0x0080000, 0x0d305e8b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "t-1.u36",        	0x0080000, 0x137d8665, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "t-4.u54",        	0x0040000, 0x0b3fe5dd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "t-3.u38",        	0x0040000, 0xdbee7b18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "w03.bin",        	0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "w05.bin",        	0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "w04.bin",        	0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "w06.bin",        	0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "w07.bin",        	0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "w09.bin",        	0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "w08.bin",        	0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "w10.bin",        	0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "w11.bin",        	0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "w13.bin",        	0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "w12.bin",        	0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "w14.bin",        	0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",     	0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",     	0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",     	0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "r04.bin",        	0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "r06.bin",        	0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "r03.bin",        	0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "r05.bin",        	0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "g01.bin",        	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
		
	{ "palce16v8h-7.u35",   0x006462, 0x4ce28f4a, BRF_OPT },	
	{ "plhs16l8an-8.u1",    0x001946, 0x50852ce7, BRF_OPT },
	{ "palce16v8h-9.u34",   0x003254, 0xfeb26c41, BRF_OPT },
	{ "plhs16l8an-x.u19",   0x001946, 0x63d7d7ba, BRF_OPT },			
};

STD_ROM_PICK(Sf2amf7)
STD_ROM_FN(Sf2amf7)

static struct BurnRomInfo Sf2amf8RomDesc[] = {
	{ "2.u222",  	   0x080000, 0x3a7a78f8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "1.u196",  	   0x080000, 0x6a3cb7ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
	{ "4.u221",  	   0x040000, 0xb0bb6242, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, 
	{ "3.u195",  	   0x040000, 0xf516e578, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },  
			
	{ "y.c.e.c m.k.r-001.u70",    0x100000, 0xa258de13, BRF_GRA | CPS1_TILES },
	{ "y.c.e.c.m.k.r-003.u68",    0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES },
	{ "y.c.e.c.m.k.r-002.u69",    0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES },
	{ "y.c.e.c.d.w.c-011.u64",    0x100000, 0xbc90c12f, BRF_GRA | CPS1_TILES },
	{ "y.c.e.c.d.w.c-012.u19",    0x100000, 0x187667cc, BRF_GRA | CPS1_TILES },
	{ "y.c.e.c.d.w.c-013.u18",    0x100000, 0x5b585071, BRF_GRA | CPS1_TILES },
	
	{ "sound.u191",    0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "voice.u210",    0x040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "grp1.u31",      0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp3.u29",      0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp2.u30",      0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "grp4.u28",      0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
	{ "conv.u133",     0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2amf8)
STD_ROM_FN(Sf2amf8)

static struct BurnRomInfo Sf2amf9RomDesc[] = {
	// this set was previously known as sf2m5
	{ "u222",         0x0080000, 0x03991fba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196",         0x0080000, 0x39f15a1e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2amf9)
STD_ROM_FN(Sf2amf9)

static struct BurnRomInfo Sf2amf10RomDesc[] = {
	// f205v id 1750
	// PCB is labeled "9354" and "O.K" on component side 
	{ "24.n",    	0x080000, 0x03991fba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "22.m",       0x080000, 0x39f15a1e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "23.bin",     0x020000, 0x94a46525, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "21.bin",     0x020000, 0x8fb3dd47, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "a.bin",   	0x080000, 0x817af36b, BRF_GRA | CPS1_TILES },
	{ "b.bin",   	0x080000, 0x38668d02, BRF_GRA | CPS1_TILES },
	{ "g.bin",   	0x080000, 0xa69ee127, BRF_GRA | CPS1_TILES },	
	{ "h.bin",   	0x080000, 0xe7ca9db7, BRF_GRA | CPS1_TILES },	
	{ "c.bin",   	0x080000, 0x201b4e86, BRF_GRA | CPS1_TILES },
	{ "d.bin",   	0x080000, 0x9e7ddcc2, BRF_GRA | CPS1_TILES },
	{ "i.bin",   	0x080000, 0x4ecc4c30, BRF_GRA | CPS1_TILES },
	{ "j.bin",   	0x080000, 0xb1f5c806, BRF_GRA | CPS1_TILES },
	{ "e.bin",   	0x080000, 0x64ac2ae5, BRF_GRA | CPS1_TILES },
	{ "f.bin",   	0x080000, 0xd9ee7246, BRF_GRA | CPS1_TILES },
	{ "k.bin",   	0x080000, 0x6639a843, BRF_GRA | CPS1_TILES },
	{ "l.bin",   	0x080000, 0x9ac6e349, BRF_GRA | CPS1_TILES },

	{ "30.bin",   	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "28.4",       0x010000, 0x8153ef93, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "25.2",       0x010000, 0x45bca686, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "27.3",       0x010000, 0x84b21ad9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "24.1",       0x010000, 0xd0c7f119, BRF_SND | CPS1_OKIM6295_SAMPLES },

	{ "30.13",      0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "26.10",      0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "27.11",      0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "29.12",      0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },

	{ "6.bin",      0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2amf10)
STD_ROM_FN(Sf2amf10)

static struct BurnRomInfo Sf2megaRomDesc[] = {
	// this set was previously known as sf2m2
	{ "ch222esp",     0x0080000, 0x9e6d058a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ch196esp",     0x0080000, 0xed2ff437, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2mega)
STD_ROM_FN(Sf2mega)

static struct BurnRomInfo Sf2mega2RomDesc[] = {
	// this set was previously known as sf2m9
	{ "sf3a-1.040",   0x0080000, 0x9e6d058a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3a-3.040",   0x0080000, 0x518d8404, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3a-2",       0x0020000, 0xfca4fc1e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf3a-4",       0x0020000, 0xcfdd6f54, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2mega2)
STD_ROM_FN(Sf2mega2)

static struct BurnRomInfo Sf2mdRomDesc[] = {
	{ "27040.6",      	  0x0080000, 0x16c6372e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27040.5",      	  0x0080000, 0x137d5f2e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27010.4", 	  	  0x0020000, 0x8226c11c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "27010.3", 	  	  0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "tat-01.bin",   	  0x0080000, 0xa887f7d4, BRF_GRA | CPS1_TILES },
	{ "tat-03.bin",   	  0x0080000, 0x79fa8bf0, BRF_GRA | CPS1_TILES },
	{ "tat-05.bin",   	  0x0080000, 0x9390ff23, BRF_GRA | CPS1_TILES },
	{ "tat-07.bin",   	  0x0080000, 0x6a5f153c, BRF_GRA | CPS1_TILES },
	{ "tat-02.bin",   	  0x0080000, 0xafb3b589, BRF_GRA | CPS1_TILES },
	{ "tat-04.bin",   	  0x0080000, 0x32518120, BRF_GRA | CPS1_TILES },
	{ "tat-06.bin",   	  0x0080000, 0x90f2053e, BRF_GRA | CPS1_TILES },	
	{ "tat-08.bin",   	  0x0080000, 0xc16579ae, BRF_GRA | CPS1_TILES },	
	{ "tat-09.bin",   	  0x0080000, 0x169d85a6, BRF_GRA | CPS1_TILES },
	{ "tat-10.bin",   	  0x0080000, 0x0c638630, BRF_GRA | CPS1_TILES },
	{ "tat-11.bin",   	  0x0080000, 0x32a3a841, BRF_GRA | CPS1_TILES },	
	{ "tat-12.bin",   	  0x0080000, 0x6ee19b94, BRF_GRA | CPS1_TILES },

	{ "27512.1", 	  	  0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "27020.2", 	  	  0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "gal20v8.68kadd",   0x000157, 0xb7fbcc26, BRF_OPT },
};

STD_ROM_PICK(Sf2md)
STD_ROM_FN(Sf2md)

static struct BurnRomInfo Sf2mdtRomDesc[] = {
    { "3.ic172",      0x0080000, 0x5301b41f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.ic171",      0x0080000, 0xc1c803f6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.ic176",      0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "2.ic175",      0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "7.ic90",       0x0080000, 0x896eaf48, BRF_GRA | CPS1_TILES },
	{ "13.ic89",      0x0080000, 0x305dd72a, BRF_GRA | CPS1_TILES },	
	{ "10.ic88",      0x0080000, 0xef3f5be8, BRF_GRA | CPS1_TILES },	
	{ "16.ic87",      0x0080000, 0xe57f6db9, BRF_GRA | CPS1_TILES },
	{ "6.ic91",       0x0080000, 0x054cd5c4, BRF_GRA | CPS1_TILES },
	{ "12.ic92",      0x0080000, 0x87e069e8, BRF_GRA | CPS1_TILES },
	{ "9.ic93",       0x0080000, 0x818ca33d, BRF_GRA | CPS1_TILES },	
	{ "15.ic94",      0x0080000, 0x5dfb44d1, BRF_GRA | CPS1_TILES },
	{ "8.ic86",       0x0080000, 0x34bbb3fa, BRF_GRA | CPS1_TILES },
	{ "14.ic85",      0x0080000, 0x7d9f1a67, BRF_GRA | CPS1_TILES },
	{ "11.ic84",      0x0080000, 0xcea6d1d6, BRF_GRA | CPS1_TILES },	
	{ "17.ic83",      0x0080000, 0x91a9a05d, BRF_GRA | CPS1_TILES },

	{ "5.ic26",       0x0020000, 0x17d5ba8a, BRF_PRG | CPS1_Z80_PROGRAM },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2mdt)
STD_ROM_FN(Sf2mdt)

static struct BurnRomInfo Sf2mdtaRomDesc[] = {
    { "3.mdta",         0x0080000, 0x9f544ef4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.mdta",         0x0080000, 0xd76d6621, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.mdta",         0x0020000, 0x74844192, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "4.mdta",         0x0020000, 0xbd98ff15, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

//  f205v has redumped pf4 sh058.ic89 with the same result, it reports an error on pin 30, assumed bad.
//  Instead we used pf4-sg072.bin from a sf2mdta alt set dump by ANY.

//	{ "pf4 sh058.ic89", 0x0100000, 0x40fdf624, BRF_GRA | CPS1_TILES }, 
	{ "pf4 sh058.ic89", 0x0100000, 0x16289710, BRF_GRA | CPS1_TILES }, // == pf4-sg072.bin
	{ "pf7 sh072.ic92", 0x0100000, 0xfb78022e, BRF_GRA | CPS1_TILES },
	{ "pf5 sh036.ic90", 0x0100000, 0x0a6be48b, BRF_GRA | CPS1_TILES },
	{ "pf8 sh074.ic93", 0x0100000, 0x6258c7cf, BRF_GRA | CPS1_TILES },
	{ "pf6 sh070.ic88", 0x0100000, 0x9b5b09d7, BRF_GRA | CPS1_TILES },
	{ "pf9 sh001.ic91", 0x0100000, 0x9f25090e, BRF_GRA | CPS1_TILES },

	{ "1.ic28",         0x0020000, 0xd5bee9cc, BRF_PRG | CPS1_Z80_PROGRAM },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2mdta)
STD_ROM_FN(Sf2mdta)

static struct BurnRomInfo Sf2mdtbRomDesc[] = {
    { "3.ic172", 	  0x0080000, 0x0bdb9da2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.ic171", 	  0x0080000, 0xd88abbce, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.ic176", 	  0x0020000, 0x74844192, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "2.ic175", 	  0x0020000, 0xbd98ff15, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "7.ic90",       0x0080000, 0x896eaf48, BRF_GRA | CPS1_TILES },
	{ "13.ic89",      0x0080000, 0x305dd72a, BRF_GRA | CPS1_TILES },	
	{ "10.ic88",      0x0080000, 0xef3f5be8, BRF_GRA | CPS1_TILES },	
	{ "16.ic87",      0x0080000, 0xe57f6db9, BRF_GRA | CPS1_TILES },
	{ "6.ic91",       0x0080000, 0x054cd5c4, BRF_GRA | CPS1_TILES },
	{ "12.ic92",      0x0080000, 0x87e069e8, BRF_GRA | CPS1_TILES },
	{ "9.ic93",       0x0080000, 0x818ca33d, BRF_GRA | CPS1_TILES },	
	{ "15.ic94",      0x0080000, 0x5dfb44d1, BRF_GRA | CPS1_TILES },
	{ "8.ic86",       0x0080000, 0x34bbb3fa, BRF_GRA | CPS1_TILES },
	{ "14.ic85",      0x0080000, 0x7d9f1a67, BRF_GRA | CPS1_TILES },
	{ "11.ic84",      0x0080000, 0xcea6d1d6, BRF_GRA | CPS1_TILES },	
	{ "17.ic83",      0x0080000, 0x91a9a05d, BRF_GRA | CPS1_TILES },

	{ "5.ic28",       0x0020000, 0xd5bee9cc, BRF_PRG | CPS1_Z80_PROGRAM },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2mdtb)
STD_ROM_FN(Sf2mdtb)

static struct BurnRomInfo Sf2mdtcRomDesc[] = {
	// f205v id 1396
	// PCB marked: 110-09-91 CH35/1 
	{ "3.ic171",        0x0080000, 0x9f544ef4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.ic171",        0x0080000, 0xd76d6621, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic171",        0x0020000, 0x74844192, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "4.ic171",        0x0020000, 0xbd98ff15, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "pf4-sg072.ic90", 0x0100000, 0x446575c7, BRF_GRA | CPS1_TILES }, 
	{ "pf7-sg088.ic88", 0x0100000, 0xfb78022e, BRF_GRA | CPS1_TILES },
	{ "pf5-sg095.ic91", 0x0100000, 0x0a6be48b, BRF_GRA | CPS1_TILES },
	{ "pf8-sg101.ic93", 0x0100000, 0x6258c7cf, BRF_GRA | CPS1_TILES },
	{ "pf6-sg078.ic86", 0x0100000, 0x9b5b09d7, BRF_GRA | CPS1_TILES },
	{ "pf9-sh001.ic84", 0x0100000, 0x9f25090e, BRF_GRA | CPS1_TILES },

	{ "3.ic26",         0x0020000, 0xd5bee9cc, BRF_PRG | CPS1_Z80_PROGRAM },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2mdtc)
STD_ROM_FN(Sf2mdtc)

static struct BurnRomInfo Sf2cebRomDesc[] = {
	// f205v id 1585
	// main PCB is marked "110-09-91 CH35/1 COMP" on component side
	// sub PCB is marked "LS 938" on solder side 
	{ "3.ic171",        0x0080000, 0xa2355d90, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.ic171",        0x0080000, 0xc6f86e84, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic171",        0x0020000, 0x74844192, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "4.ic171",        0x0020000, 0xbd98ff15, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "pf4-sg072.ic90", 0x0100000, 0x446575c7, BRF_GRA | CPS1_TILES }, 
	{ "pf7-sg103.ic88", 0x0100000, 0xfb78022e, BRF_GRA | CPS1_TILES },
	{ "pf5-sg063.ic91", 0x0100000, 0x0a6be48b, BRF_GRA | CPS1_TILES },
	{ "pf8-sg101.ic93", 0x0100000, 0x6258c7cf, BRF_GRA | CPS1_TILES },
	{ "pf6-sg070.ic86", 0x0100000, 0x9b5b09d7, BRF_GRA | CPS1_TILES },
	{ "pf9-sh001.ic84", 0x0100000, 0x9f25090e, BRF_GRA | CPS1_TILES },

	{ "3.ic28",         0x0020000, 0xd5bee9cc, BRF_PRG | CPS1_Z80_PROGRAM },
	
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2ceb)
STD_ROM_FN(Sf2ceb)

static struct BurnRomInfo Sf2ceb4RomDesc[] = {
	// f205v id 1400
    { "3.ic172",      0x0080000, 0x11b5fe98, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.ic171",      0x0080000, 0x43e85f2c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic176",      0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "4.ic175",      0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "10.ic90",      0x0080000, 0x896eaf48, BRF_GRA | CPS1_TILES },
	{ "16.ic89",      0x0080000, 0x305dd72a, BRF_GRA | CPS1_TILES },	
	{ "7.ic88",       0x0080000, 0xef3f5be8, BRF_GRA | CPS1_TILES },	
	{ "13.ic87",      0x0080000, 0xe57f6db9, BRF_GRA | CPS1_TILES },
	{ "11.ic91",      0x0080000, 0x054cd5c4, BRF_GRA | CPS1_TILES },
	{ "17.ic92",      0x0080000, 0x87e069e8, BRF_GRA | CPS1_TILES },
	{ "8.ic93",       0x0080000, 0x818ca33d, BRF_GRA | CPS1_TILES },	
	{ "14.ic94",      0x0080000, 0x5dfb44d1, BRF_GRA | CPS1_TILES },
	{ "9.ic86",       0x0080000, 0x34bbb3fa, BRF_GRA | CPS1_TILES },
	{ "15.ic85",      0x0080000, 0x7d9f1a67, BRF_GRA | CPS1_TILES },
	{ "6.ic84",       0x0080000, 0xcea6d1d6, BRF_GRA | CPS1_TILES },	
	{ "12.ic83",      0x0080000, 0x91a9a05d, BRF_GRA | CPS1_TILES },

	{ "1.ic26",       0x0020000, 0x17d5ba8a, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Sf2ceb4)
STD_ROM_FN(Sf2ceb4)

static struct BurnRomInfo Sf2ceb5RomDesc[] = {
	// f205v id 1680
	// main PCB is marked "110-09-91 CH35/1 COMP" on component side
	// sub PCB is marked "LS 938" on solder side 
	{ "3.ic171",        0x0080000, 0xa2355d90, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.ic171",        0x0080000, 0xc6f86e84, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic171",        0x0020000, 0x74844192, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "4.ic171",        0x0020000, 0xbd98ff15, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "pf4-sh058.ic90", 0x0100000, 0x446575c7, BRF_GRA | CPS1_TILES }, 
	{ "pf7-sh072.ic88", 0x0100000, 0xfb78022e, BRF_GRA | CPS1_TILES },
	{ "pf5-sh036.ic91", 0x0100000, 0x0a6be48b, BRF_GRA | CPS1_TILES },
	{ "pf8-sh074.ic93", 0x0100000, 0x6258c7cf, BRF_GRA | CPS1_TILES },
	{ "pf6-sh071.ic86", 0x0100000, 0x9b5b09d7, BRF_GRA | CPS1_TILES },
	{ "pf9-sh065.ic84", 0x0100000, 0x9f25090e, BRF_GRA | CPS1_TILES },

	{ "5.ic26",         0x0020000, 0x17d5ba8a, BRF_PRG | CPS1_Z80_PROGRAM },
		
	// extra graphics roms are required (see bike's on Chun-Li stage), but using the current dumps we have lead to a corrupt
	// Street Fighter II logo
};

STD_ROM_PICK(Sf2ceb5)
STD_ROM_FN(Sf2ceb5)

static struct BurnRomInfo Sf2ceeablRomDesc[] = {
	// this set was previously known as sf2m16
	{ "joe-922",      0x0080000, 0xe927556c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "joe-921",      0x0080000, 0x8632e786, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2m16_4.bin", 0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2m16_3.bin", 0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "tat-01.bin",   0x0080000, 0xa887f7d4, BRF_GRA | CPS1_TILES },
	{ "tat-03.bin",   0x0080000, 0x79fa8bf0, BRF_GRA | CPS1_TILES },
	{ "tat-05.bin",   0x0080000, 0x9390ff23, BRF_GRA | CPS1_TILES },
	{ "tat-07.bin",   0x0080000, 0x6a5f153c, BRF_GRA | CPS1_TILES },
	{ "tat-02.bin",   0x0080000, 0xafb3b589, BRF_GRA | CPS1_TILES },
	{ "tat-04.bin",   0x0080000, 0x32518120, BRF_GRA | CPS1_TILES },
	{ "tat-06.bin",   0x0080000, 0x90f2053e, BRF_GRA | CPS1_TILES },	
	{ "tat-08.bin",   0x0080000, 0xc16579ae, BRF_GRA | CPS1_TILES },	
	{ "tat-09.bin",   0x0080000, 0x169d85a6, BRF_GRA | CPS1_TILES },
	{ "tat-10.bin",   0x0080000, 0x0c638630, BRF_GRA | CPS1_TILES },
	{ "tat-11.bin",   0x0080000, 0x32a3a841, BRF_GRA | CPS1_TILES },	
	{ "tat-12.bin",   0x0080000, 0x6ee19b94, BRF_GRA | CPS1_TILES },

	{ "sf2m16_1.bin", 0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2m16_2.bin", 0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2ceeabl)
STD_ROM_FN(Sf2ceeabl)

static struct BurnRomInfo Sf2ceeab2RomDesc[] = {
	// this set was previously known as sf2m1
	{ "222e",         0x0080000, 0x1e20d0a3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "196e",         0x0080000, 0x88cc38a3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2ceeab2)
STD_ROM_FN(Sf2ceeab2)

static struct BurnRomInfo Sf2ceb2RomDesc[] = {
	// f205v id 1395
	{ "3.ic172",      0x0080000, 0x11b5fe98, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.ic171",      0x0080000, 0x6d948623, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.ic176",      0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic175",      0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "7.ic90",       0x0080000, 0x896eaf48, BRF_GRA | CPS1_TILES },
	{ "13.ic89",      0x0080000, 0x305dd72a, BRF_GRA | CPS1_TILES },	
	{ "10.ic88",      0x0080000, 0xef3f5be8, BRF_GRA | CPS1_TILES },	
	{ "16.ic87",      0x0080000, 0xe57f6db9, BRF_GRA | CPS1_TILES },
	{ "6.ic91",       0x0080000, 0x054cd5c4, BRF_GRA | CPS1_TILES },
	{ "12.ic92",      0x0080000, 0x87e069e8, BRF_GRA | CPS1_TILES },
	{ "9.ic93",       0x0080000, 0x818ca33d, BRF_GRA | CPS1_TILES },	
	{ "15.ic94",      0x0080000, 0x5dfb44d1, BRF_GRA | CPS1_TILES },
	{ "8.ic86",       0x0080000, 0x34bbb3fa, BRF_GRA | CPS1_TILES },
	{ "14.ic85",      0x0080000, 0x7d9f1a67, BRF_GRA | CPS1_TILES },
	{ "11.ic84",      0x0080000, 0xcea6d1d6, BRF_GRA | CPS1_TILES },	
	{ "17.ic83",      0x0080000, 0x91a9a05d, BRF_GRA | CPS1_TILES },

	{ "5.ic26",       0x0020000, 0x17d5ba8a, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Sf2ceb2)
STD_ROM_FN(Sf2ceb2)

static struct BurnRomInfo Sf2ceb3RomDesc[] = {
	// f20v id 1394
	{ "3.ic172",      0x0080000, 0x30848e16, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.ic171",      0x0080000, 0x6d948623, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.ic176",      0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.ic175",      0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "7.ic90",       0x0080000, 0x896eaf48, BRF_GRA | CPS1_TILES },
	{ "13.ic89",      0x0080000, 0x305dd72a, BRF_GRA | CPS1_TILES },	
	{ "10.ic88",      0x0080000, 0xef3f5be8, BRF_GRA | CPS1_TILES },	
	{ "16.ic87",      0x0080000, 0xe57f6db9, BRF_GRA | CPS1_TILES },
	{ "6.ic91",       0x0080000, 0x054cd5c4, BRF_GRA | CPS1_TILES },
	{ "12.ic92",      0x0080000, 0x87e069e8, BRF_GRA | CPS1_TILES },
	{ "9.ic93",       0x0080000, 0x818ca33d, BRF_GRA | CPS1_TILES },	
	{ "15.ic94",      0x0080000, 0x5dfb44d1, BRF_GRA | CPS1_TILES },
	{ "8.ic86",       0x0080000, 0x34bbb3fa, BRF_GRA | CPS1_TILES },
	{ "14.ic85",      0x0080000, 0x7d9f1a67, BRF_GRA | CPS1_TILES },
	{ "11.ic84",      0x0080000, 0xcea6d1d6, BRF_GRA | CPS1_TILES },	
	{ "17.ic83",      0x0080000, 0x91a9a05d, BRF_GRA | CPS1_TILES },

	{ "5.ic26",       0x0020000, 0x17d5ba8a, BRF_PRG | CPS1_Z80_PROGRAM },
};

STD_ROM_PICK(Sf2ceb3)
STD_ROM_FN(Sf2ceb3)

static struct BurnRomInfo Sf2cejablRomDesc[] = {
	// this set was previously known as sf2m11
	{ "sfu7-1.040",   0x0080000, 0x866a9b31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu7-3.040",   0x0080000, 0xf3a45593, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu7-2.010",   0x0020000, 0xd1707134, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sfu7-4.010",   0x0020000, 0xcd1d5666, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2cejabl)
STD_ROM_FN(Sf2cejabl)

static struct BurnRomInfo Sf2cejab2RomDesc[] = {
	{ "u7-1.040",     0x0080000, 0x866a9b31, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u7-3.040",     0x0080000, 0x49b15fcd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2cejab2)
STD_ROM_FN(Sf2cejab2)

static struct BurnRomInfo Sf2ceuplRomDesc[] = {
	// Only the main program EPROMS were dumped for this set
	{ "s2.u222",   	  0x0080000, 0x0804f973, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s1.u196",      0x0080000, 0x2bc76a02, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "10.u221",   	  0x0020000, 0xd1707134, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "9.u195",       0x0020000, 0xcd1d5666, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.3a",    0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",    0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",    0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",    0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",    0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",    0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",    0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.3c",    0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.4c",    0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.5c",    0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.6c",    0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",    0x000117, 0x0a7ecfe0, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",     0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",    0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",     0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",     0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2ceupl)
STD_ROM_FN(Sf2ceupl)

static struct BurnRomInfo Sf2ceuablRomDesc[] = {
	// this set was previously known as sf2m3
	{ "u222chp",      0x0080000, 0xdb567b66, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196chp",      0x0080000, 0x95ea597e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.bin",  0x0080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2ceuabl)
STD_ROM_FN(Sf2ceuabl)

static struct BurnRomInfo Sf2ceuab2RomDesc[] = {
	// this set was previously known as sf2m8
//	This was the original dump which was bad
//	{ "u221.epr",     0x0020000, 0xd8276822, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "k4-222",       0x0080000, 0xdb567b66, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "k4-196",       0x0080000, 0x95ea597e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u221.epr",     0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u195.epr",     0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2ceuab2)
STD_ROM_FN(Sf2ceuab2)

static struct BurnRomInfo Sf2ceuab3RomDesc[] = {
	// this set was previously known as sf2m8a
	{ "yyc-2.2",  0x0080000, 0xdb567b66, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "yyc-3.4",  0x0080000, 0x95ea597e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "yyc-4.1",  0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "yyc-5.3",  0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	
	{ "yyc-a",    0x0100000, 0x8242621f, BRF_GRA | CPS1_TILES },
	{ "yyc-c",    0x0100000, 0x0793a960, BRF_GRA | CPS1_TILES }, 
	{ "yyc-b",    0x0100000, 0xb0159973, BRF_GRA | CPS1_TILES }, 
	{ "yyc-d",    0x0100000, 0x92a8b572, BRF_GRA | CPS1_TILES },	
	{ "yyc-e",    0x0100000, 0x61138469, BRF_GRA | CPS1_TILES },
	{ "yyc-f",    0x0100000, 0xb800dcdb, BRF_GRA | CPS1_TILES },	

	{ "a-15.5",   0x0010000, 0x6f07d2cb, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "b-16.6",   0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
		
	{ "yyc-6.1",  0x0020000, 0x94778332, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "yyc-8.9",  0x0020000, 0xf95bc505, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "yyc-7.10", 0x0020000, 0xd1e452d3, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "yyc-9.8",  0x0020000, 0x155824a9, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "c-27.7",   0x0010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ceuab3)
STD_ROM_FN(Sf2ceuab3)

static struct BurnRomInfo Sf2ceuab4RomDesc[] = {
	// This set is known as sf2cems6a in MAME
	{ "ms6.u196",          0x0100000, 0x596609d4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ms6.u10",           0x0080000, 0xed4186bd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ms6.u70",           0x0100000, 0xbaa0f81f, BRF_GRA | CPS1_TILES },
	{ "ms6.u68",           0x0100000, 0x8edff95a, BRF_GRA | CPS1_TILES },
	{ "ms6.u69",           0x0100000, 0x468962b1, BRF_GRA | CPS1_TILES },
	{ "ms6.u64",           0x0100000, 0x8165f536, BRF_GRA | CPS1_TILES },
	{ "ms6.u19",           0x0100000, 0x39d763d3, BRF_GRA | CPS1_TILES },
	{ "ms6.u18",           0x0100000, 0x2ddfe46e, BRF_GRA | CPS1_TILES },

	{ "ms6.u191",          0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ms6.u210",          0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "ms6.u31",           0x0040000, 0x35486f2d, BRF_GRA | CPS1_EXTRA_TILES_SF2KORYU_400000 }, 
	{ "ms6.u29",           0x0040000, 0xe4eca601, BRF_GRA | CPS1_EXTRA_TILES_SF2KORYU_400000 },
	
	{ "ms6.u133",          0x0010000, 0x13ea1c44, BRF_OPT }, // unknown
	
	{ "ms6_gal20v8a.u104", 0x0000157, 0x67b56d29, BRF_OPT }, // pld devices
};

STD_ROM_PICK(Sf2ceuab4)
STD_ROM_FN(Sf2ceuab4)

static struct BurnRomInfo Sf2reRomDesc[] = {
	// combines sf2m8 program ROMs with sf2cems6a ROMs for most GFX and common ROMs for sound
	{ "4.u222",   			0x0080000, 0xdb567b66, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "3.u196",   			0x0080000, 0x95ea597e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "2.u221",   			0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "1.u195",   			0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	
	{ "1mre125.u70",    	0x0100000, 0xbaa0f81f, BRF_GRA | CPS1_TILES },
	{ "3mre121.u68",  		0x0100000, 0x8edff95a, BRF_GRA | CPS1_TILES },
	{ "5mre148.u69",  		0x0100000, 0x468962b1, BRF_GRA | CPS1_TILES },
	{ "7mrd413.u64",    	0x0100000, 0x8165f536, BRF_GRA | CPS1_TILES },
	{ "sfiire143.u19",  	0x0100000, 0x39d763d3, BRF_GRA | CPS1_TILES },
	{ "sfiire073.u18",  	0x0100000, 0x93ec42ae, BRF_GRA | CPS1_TILES },	

	{ "csicat27c512.u191", 	0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "27c020.u210",   		0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
		
	{ "27c010.u31",    		0x020000, 0x6de44671, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "27c010.u29",    		0x020000, 0xe8f14362, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "27c010.u30",    		0x020000, 0xbf0cd819, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	{ "27c010.u28",    		0x020000, 0x76f9f91f, BRF_GRA | CPS1_EXTRA_TILES_SF2B_400000 },
	
};

STD_ROM_PICK(Sf2re)
STD_ROM_FN(Sf2re)

// PCB is marked: "100P003" and "054-034" on solder side
// PCB is labelled: "10037SI 7", "STREET FIGHTER 2" and "STREET FIGHTER II MAGIC TURBO" on component side
static struct BurnRomInfo Sf2mkotRomDesc[] = {
	{ "u222.bin",     	   	0x0080000, 0xb01a94b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u196.bin",     	   	0x0080000, 0x20461c47, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u221.bin",     	   	0x0020000, 0x64e6e091, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u195.bin",     	   	0x0020000, 0xc95e4443, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "d21.u70",      	   	0x0100000, 0xbaa0f81f, BRF_GRA | CPS1_TILES },
	{ "d24.u68",      	   	0x0100000, 0x8edff95a, BRF_GRA | CPS1_TILES },
	{ "d22.u69",      	   	0x0100000, 0x468962b1, BRF_GRA | CPS1_TILES },
	{ "d25.u64",      	   	0x0100000, 0x8165f536, BRF_GRA | CPS1_TILES },
	{ "d23.u19",      	   	0x0100000, 0x39d763d3, BRF_GRA | CPS1_TILES },
	{ "d26.u18",      	   	0x0100000, 0x93ec42ae, BRF_GRA | CPS1_TILES },

	{ "conv2.u191",        	0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "voice.u210",        	0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "moon-1.c173.u30",   	0x0040000, 0x7e36ec84, BRF_GRA | CPS1_EXTRA_TILES_SF2MKOT_400000 }, 
	{ "moon-2.c132.u29",   	0x0040000, 0x66403570, BRF_GRA | CPS1_EXTRA_TILES_SF2MKOT_400000 },

	{ "u133.bin",          	0x0010000, 0x13ea1c44, BRF_OPT }, // unknown (bootleg prority?)
	
	{ "gal16v8a-25lp.u6",  	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, // plds
	{ "gal16v8a-25lp.u15", 	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.n03", 	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.n05", 	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.n06", 	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.u95", 	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.u96", 	0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.u107", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.u125", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.u139", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP }, 
	{ "gal16v8a-25lp.u151", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u173", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u176", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u177", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u178", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u183", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u198", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal16v8a-25lp.u218", 0x0000117, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u20",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u21",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u34",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u35",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u39",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.n07",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.n08",  0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u104", 0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u131", 0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u135", 0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal20v8a-25lp.u140", 0x0000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "gal22v10-25lp.u134", 0x00002e5, 0x00000000, BRF_OPT | BRF_NODUMP },
};

STD_ROM_PICK(Sf2mkot)
STD_ROM_FN(Sf2mkot)

static struct BurnRomInfo Sf2ceuab5RomDesc[] = {
	{ "7.bin",         0x080000, 0xdb567b66, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "5.bin",         0x080000, 0x95ea597e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
	{ "6.bin",         0x020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8
    { "4.bin",         0x020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // same as sf2m8

	// not in the original dump (see below)
	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",   0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM }, // this was missing from dump, but the pcm data is the same, so assuming the z80 program is too

	{ "2.bin",        0x040000, 0x06dec6cd, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "9.bin",        0x020000, 0x94778332, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "17.bin",       0x020000, 0xf95bc505, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.bin",       0x020000, 0xd1e452d3, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "18.bin",       0x020000, 0x155824a9, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "8.bin",        0x010000, 0x13ea1c44, BRF_OPT }, // unknown
	
	// original gfx files (these are in similar format to the tat-x gfx roms with each half swapped,
	// however, only about 60% of the data is the same and each of these compress to approx. 52-55%
	// of the others, I believe these are bad dumps
	// romcmp also reports BADADDR -xxx-xxxxxxxxxxxxxx for each one
	{ "11.bin",        			0x080000, 0xc5430b62, BRF_OPT },
	{ "13.bin",        			0x080000, 0xe57f4114, BRF_OPT },
	{ "12.bin",        			0x080000, 0x9a3672e9, BRF_OPT },
	{ "14.bin",        			0x080000, 0x36b69ebd, BRF_OPT },
	{ "19.bin",        			0x080000, 0xadb33f90, BRF_OPT },
	{ "21.bin",        			0x080000, 0xfacffca9, BRF_OPT },
	{ "20.bin",        			0x080000, 0x28b4c2d1, BRF_OPT },
	{ "22.bin",        			0x080000, 0xcb49e6a7, BRF_OPT },
	{ "15.bin",        			0x080000, 0x8c08c9bd, BRF_OPT },
	{ "23.bin",        			0x080000, 0xf613febd, BRF_OPT },
	{ "16.bin",        			0x080000, 0xf23b588b, BRF_OPT },
	{ "24(__sf2ceuab5).bin",	0x080000, 0xb4f16226, BRF_OPT },
};

STD_ROM_PICK(Sf2ceuab5)
STD_ROM_FN(Sf2ceuab5)

static struct BurnRomInfo Sf2ceuab6RomDesc[] = {
	{ "s92u_23a.8f",  0x0080000, 0xac44415b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // not in original dump
	{ "s92_22a.7f",   0x0080000, 0x99f1cca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // not in original dump
	{ "6",            0x0020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
    { "4",            0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "7",            0x0020000, 0x8312d055, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // loads over final part of s92u_23a.8f
	{ "5",            0x0020000, 0xd0580ff2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // loads over final part of s92_22a.7f
	
	{ "11",           0x0080000, 0xa887f7d4, BRF_GRA | CPS1_TILES },
	{ "13",           0x0080000, 0x79fa8bf0, BRF_GRA | CPS1_TILES },
	{ "12",           0x0080000, 0x9390ff23, BRF_GRA | CPS1_TILES },
	{ "14",           0x0080000, 0x6a5f153c, BRF_GRA | CPS1_TILES },
	{ "19",           0x0080000, 0xafb3b589, BRF_GRA | CPS1_TILES },
	{ "21",           0x0080000, 0x32518120, BRF_GRA | CPS1_TILES },
	{ "20",           0x0080000, 0x90f2053e, BRF_GRA | CPS1_TILES },	
	{ "22",           0x0080000, 0xc16579ae, BRF_GRA | CPS1_TILES },	
	{ "15",           0x0080000, 0x169d85a6, BRF_GRA | CPS1_TILES },
	{ "23",           0x0080000, 0x0c638630, BRF_GRA | CPS1_TILES },
	{ "16",           0x0080000, 0x32a3a841, BRF_GRA | CPS1_TILES },	
	{ "24",           0x0080000, 0x6ee19b94, BRF_GRA | CPS1_TILES },

	{ "3",            0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "2",            0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "1",            0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "9",            0x0020000, 0x94778332, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "17",           0x0020000, 0xf95bc505, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10",           0x0020000, 0xd1e452d3, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "18",           0x0020000, 0x155824a9, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	{ "8",            0x0010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ceuab6)
STD_ROM_FN(Sf2ceuab6)

static struct BurnRomInfo Sf2ceuab7RomDesc[] = {
	// this set is known as sf2ceblp in MAME 0.153
	{ "1k.31.e13",    0x0020000, 0xea78f9b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "se.36.j13",    0x0020000, 0xd30c263e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "0e.30.e11",    0x0020000, 0x005b54cc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "de.35.j11",    0x0020000, 0xc184d26d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "bk.29.e10",    0x0020000, 0x524f5c55, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff.34.j10",    0x0020000, 0xf06a12f2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "8k.28.e9",     0x0040000, 0xb7ad5214, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tf.33.j9",     0x0040000, 0x6340b914, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

    { "24.e7", 	      0x0040000, 0xa8b5633a, BRF_GRA | CPS1_TILES },
    { "20.e3",        0x0040000, 0x8d5d0045, BRF_GRA | CPS1_TILES },
    { "25.e8", 	      0x0040000, 0x72e923df, BRF_GRA | CPS1_TILES },
    { "21.e4",        0x0040000, 0x55c2b455, BRF_GRA | CPS1_TILES },
    { "14.c7",        0x0040000, 0x5db24ca7, BRF_GRA | CPS1_TILES },
    { "10.c3",        0x0040000, 0xeb48f7f2, BRF_GRA | CPS1_TILES },
    { "15.c8",        0x0040000, 0x9a96be48, BRF_GRA | CPS1_TILES },
    { "11.c4",        0x0040000, 0xff36859e, BRF_GRA | CPS1_TILES },
    { "26.e9",    	  0x0040000, 0x82e8e384, BRF_GRA | CPS1_TILES },
    { "22.e5",        0x0040000, 0x4109d637, BRF_GRA | CPS1_TILES },
    { "27.e10", 	  0x0040000, 0x4a3a8d09, BRF_GRA | CPS1_TILES },
    { "23.e6",        0x0040000, 0xef9c2d4d, BRF_GRA | CPS1_TILES },
    { "16.c9",        0x0040000, 0x1fd98ad0, BRF_GRA | CPS1_TILES },
    { "12.c5",        0x0040000, 0x5d21d8b3, BRF_GRA | CPS1_TILES },
    { "17.c10",       0x0040000, 0xa917a922, BRF_GRA | CPS1_TILES },
    { "13.c6",        0x0040000, 0xbc937c96, BRF_GRA | CPS1_TILES },
    { "6.a8",         0x0040000, 0x023baa18, BRF_GRA | CPS1_TILES },
    { "1.a3",         0x0040000, 0x877b2b18, BRF_GRA | CPS1_TILES },
    { "8.a10",        0x0040000, 0x26fb340c, BRF_GRA | CPS1_TILES },
    { "4.a6",         0x0040000, 0xf2c400b4, BRF_GRA | CPS1_TILES },
    { "5.a7",         0x0040000, 0xa6ad6ef3, BRF_GRA | CPS1_TILES },
    { "2.a4",         0x0040000, 0x144aa4c9, BRF_GRA | CPS1_TILES },
    { "7.a9",         0x0040000, 0xf56085ba, BRF_GRA | CPS1_TILES },
    { "3.a5",         0x0040000, 0x8053335d, BRF_GRA | CPS1_TILES },

    { "snd.9.b13",    0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

    { "9k.18.c11",    0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
    { "lk.19.c13",    0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },

    { "pic16c55",     0x0002000, 0xf22e2311, BRF_OPT }, // PIC
};

STD_ROM_PICK(Sf2ceuab7)
STD_ROM_FN(Sf2ceuab7)

static struct BurnRomInfo Sf2ceuab8RomDesc[] = {
	// f205v id 1404 & 1405
	{ "sf2h14.7",          	0x080000, 0x74803532, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2h14.5",          	0x080000, 0x66c91972, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "yyc-4.1",          	0x020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "yyc-5.3",          	0x020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "a-se235.bin", 		0x100000, 0xa258de13, BRF_GRA | CPS1_TILES }, 
	{ "c-se005.bin", 		0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES }, 
	{ "b-se194.bin", 		0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES }, 
	{ "d-se064.bin", 		0x100000, 0x4dd24197, BRF_GRA | CPS1_TILES },
	{ "e-sf004.bin", 		0x100000, 0x187667cc, BRF_GRA | CPS1_TILES }, 
	{ "f-sf001.bin", 		0x100000, 0x5b585071, BRF_GRA | CPS1_TILES }, 

	{ "27c512.3",          	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "27c010.2",          	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "27c010.1",          	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "27c1024.10",        	0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.12",        	0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.9",         	0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.11",      	0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "27c512.8",          	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ceuab8)
STD_ROM_FN(Sf2ceuab8)

static struct BurnRomInfo Sf2ceuab9RomDesc[] = {
	// f205v id 1403
	{ "sf2h14.7",          	0x080000, 0x74803532, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2h14.5",          	0x080000, 0x66c91972, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "yyc-4.1",          	0x020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "yyc-5.3",          	0x020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "wm91m-07_yd034",     0x080000, 0x22c9cc8e, BRF_GRA | CPS1_TILES }, // == sf2-5m.4a
	{ "wm91m-12_yd021",     0x080000, 0x57213be8, BRF_GRA | CPS1_TILES }, // == sf2-7m.6a
	{ "wm91m-01_yd403",     0x080000, 0xba529b4f, BRF_GRA | CPS1_TILES }, // == sf2-1m.3a
	{ "wm91m-04_yd051",     0x080000, 0x4b1b33a8, BRF_GRA | CPS1_TILES }, // == sf2-3m.5a
	{ "wm91m-08_yd062",     0x080000, 0x2c7e2229, BRF_GRA | CPS1_TILES }, // == sf2-6m.4c
	{ "wm91m-10_yd032",     0x080000, 0xb5548f17, BRF_GRA | CPS1_TILES }, // == sf2-8m.6c
	{ "wm91m-02_yd028",     0x080000, 0x14b84312, BRF_GRA | CPS1_TILES }, // == sf2-2m.3c
	{ "wm91m-05_yd004",     0x080000, 0x5e9cd89a, BRF_GRA | CPS1_TILES }, // == sf2-4m.5c
	{ "wm91m-09_yd024",     0x080000, 0x994bfa58, BRF_GRA | CPS1_TILES }, // == sf2-13m.4d
	{ "wm91m-11_yd014",     0x080000, 0x3e66ad9d, BRF_GRA | CPS1_TILES }, // == sf2-15m.6d
	{ "wm91m-03_yd036",     0x080000, 0xc1befaa8, BRF_GRA | CPS1_TILES }, // == sf2-9m.3d
	{ "wm91m-06_yd009",     0x080000, 0x0627c831, BRF_GRA | CPS1_TILES }, // == sf2-11m.5d

	{ "27c512.3",          	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "27c010.2",          	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "27c010.1",          	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "27c1024.10",        	0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.12",        	0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.9",         	0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.11",      	0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "27c512.8",          	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ceuab9)
STD_ROM_FN(Sf2ceuab9)

static struct BurnRomInfo Sf2ceuab10RomDesc[] = {
	// this set is known as Sf2m10 in MAME
	{ "sf2h14.7",          	0x080000, 0x74803532, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf2h14.5",          	0x080000, 0x66c91972, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "yyc-4.1",          	0x020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "yyc-5.3",          	0x020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "s92-1m.3a",          0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92-3m.5a",          0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92-2m.4a",          0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92-4m.6a",          0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92-5m.7a",          0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92-7m.9a",          0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92-6m.8a",          0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92-8m.10a",         0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92-10m.3c",         0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92-12m.5c",         0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92-11m.4c",         0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92-13m.6c",         0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "27c512.3",          	0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "27c010.2",          	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "27c010.1",          	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "27c1024.10",        	0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.12",        	0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.9",         	0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "27c1024.11",      	0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "27c512.8",          	0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ceuab10)
STD_ROM_FN(Sf2ceuab10)

static struct BurnRomInfo Sf2ceuab11RomDesc[] = {
	// PCB is marked: "STF REV.3" on component side
	// PCB is labeled: "STREET FIGHTER III" on component side 
	// f205v id 1615
	{ "7.bin",          0x080000, 0x74803532, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "5.bin",          0x080000, 0x66c91972, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "6.bin",          0x020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.bin",          0x020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "a-se168.07", 	0x100000, 0xa258de13, BRF_GRA | CPS1_TILES }, 
	{ "c-se005.12", 	0x100000, 0xc781bf87, BRF_GRA | CPS1_TILES }, 
	{ "b-se194.02", 	0x100000, 0x5726cab8, BRF_GRA | CPS1_TILES }, 
	{ "d-se064.05", 	0x100000, 0x4dd24197, BRF_GRA | CPS1_TILES },
	{ "e-sf004.09", 	0x100000, 0x187667cc, BRF_GRA | CPS1_TILES }, 
	{ "f-sf001.01", 	0x100000, 0x5b585071, BRF_GRA | CPS1_TILES }, 

	{ "3.bin",          0x010000, 0xa4823a1b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "2.18",          	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "1.19",          	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "10.09",        	0x020000, 0x84427d1b, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "12.11",        	0x020000, 0x55bc790c, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "9.03",         	0x020000, 0xf8725add, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	{ "11.06",      	0x020000, 0xc2a5373e, BRF_GRA | CPS1_EXTRA_TILES_400000 },
	
	{ "8.bin",          0x010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2ceuab11)
STD_ROM_FN(Sf2ceuab11)

static struct BurnRomInfo Sf2ceucblRomDesc[] = {
	{ "s92u_23c.8f",   	0x080000, 0x0a8b6aa2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // not included in dump (matches first half of ym.u23)
	{ "s92_22c.7f",    	0x080000, 0x5fd8630b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // not included in dump (matches first half of ym.u22)
	{ "s92_21a.6f",    	0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // not included in dump (nearly matches first half of ym.u21)
	{ "ym.u23",        	0x040000, 0xd6b39cc3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // this looks half-sized (loading over the top of above roms)
	{ "ym.u22",        	0x040000, 0xefa0a775, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // this looks half-sized (loading over the top of above roms)
	{ "ym.u21",        	0x040000, 0xc812b7b2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // this looks half-sized (loading over the top of above roms)
	
	// not in the original dump (see below)
	{ "s92_01.bin",   	0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   	0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   	0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   	0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   	0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   	0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   	0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   	0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   	0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   	0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   	0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   	0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.11a",    	0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM }, // this was missing from dump, but the pcm data is the same, so assuming the z80 program is too

	{ "2.bin",         	0x040000, 0x06dec6cd, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't in this dump - but given the presence of the bad graphic rom dumps (from sf2ceuab5), I think these should be here too
	{ "9.bin",         	0x020000, 0x94778332, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "17.bin",        	0x020000, 0xf95bc505, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.bin",        	0x020000, 0xd1e452d3, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "18.bin",        	0x020000, 0x155824a9, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	
	// original gfx files (these are in similar format to the tat-x gfx roms with each half swapped,
	// however, only about 60% of the data is the same and each of these compress to approx. 52-55%
	// of the others, I believe these are bad dumps
	// romcmp also reports BADADDR -xxx-xxxxxxxxxxxxxx for each one
	{ "11.bin",        		 0x080000, 0xc5430b62, BRF_OPT },
	{ "13.bin",        		 0x080000, 0xe57f4114, BRF_OPT },
	{ "12.bin",        		 0x080000, 0x9a3672e9, BRF_OPT },
	{ "14.bin",        		 0x080000, 0x36b69ebd, BRF_OPT },
	{ "19.bin",        		 0x080000, 0xadb33f90, BRF_OPT },
	{ "21.bin",        		 0x080000, 0xfacffca9, BRF_OPT },
	{ "20.bin",        		 0x080000, 0x28b4c2d1, BRF_OPT },
	{ "22.bin",        		 0x080000, 0xcb49e6a7, BRF_OPT },
	{ "15.bin",        		 0x080000, 0x8c08c9bd, BRF_OPT },
	{ "23.bin",        		 0x080000, 0xf613febd, BRF_OPT },
	{ "16.bin",        		 0x080000, 0xf23b588b, BRF_OPT },
	{ "24(__sf2ceucbl).bin", 0x080000, 0xb4f16226, BRF_OPT },
};

STD_ROM_PICK(Sf2ceucbl)
STD_ROM_FN(Sf2ceucbl)

static struct BurnRomInfo Sf2levelRomDesc[] = {
	{ "rj313.u196.800",     0x0100000, 0x435153d5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ci030.u10.400",      0x0080000, 0xed4186bd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	// roms from this set not dumped - Note from dumper: 'GFX is slightly different mask rom layout than others. (2x mask instead of a rack of 010's)'
	{ "s92_01.3a",          0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",          0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",          0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",          0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",          0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",          0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",          0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",         0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.3c",          0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.4c",          0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.5c",          0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.6c",          0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "km6264b-10.u191",    0x0010000, 0x6f07d2cb, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "km418c256z-80.u210", 0x0040000, 0x6cfffb11, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "km6264-10.u133",     0x0010000, 0x13ea1c44, BRF_OPT }, // unknown
};

STD_ROM_PICK(Sf2level)
STD_ROM_FN(Sf2level)

static struct BurnRomInfo Sf2tlonaRomDesc[] = {
	// There is a set known as sf2tlond and sf2turyu which contains the same data, but has double-size program roms
	{ "tl4mt.1",       	0x080000, 0x158635ca, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tl4m.2",        	0x080000, 0x882cd1c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u221t.1m",      	0x020000, 0x1073b7b6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u195t.1m",      	0x020000, 0xdb7e1f72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",    	0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    	0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    	0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    	0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    	0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    	0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    	0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    	0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    	0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    	0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    	0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    	0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    	0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        	0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        	0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        	0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       	0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2tlona)
STD_ROM_FN(Sf2tlona)

static struct BurnRomInfo Sf2tlonbRomDesc[] = {
	// This set is also known as sf2tury2
	{ "tl4m.1",        	0x080000, 0xafc7bd18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tl4m.2",        	0x080000, 0x882cd1c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u221.1m",       	0x020000, 0xd1707134, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u195.1m",       	0x020000, 0xcd1d5666, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",    	0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    	0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    	0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    	0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    	0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    	0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    	0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    	0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    	0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    	0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    	0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    	0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    	0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        	0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        	0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        	0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       	0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2tlonb)
STD_ROM_FN(Sf2tlonb)

static struct BurnRomInfo Sf2tloncRomDesc[] = {
	{ "sf11-1.040",    	0x080000, 0xafc7bd18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf11-3.040",    	0x080000, 0x882cd1c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf11-2.010",    	0x020000, 0xf8a5cd53, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sf11-4.010",    	0x020000, 0xdb7e1f72, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",    	0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    	0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    	0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    	0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    	0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    	0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    	0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    	0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    	0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    	0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    	0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    	0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    	0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    	0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    	0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	// these weren't present with this set, but extra graphics are required (see bike's on Chun-Li stage)
	{ "6.amf",        	0x020000, 0x3a85a275, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "9.amf",        	0x020000, 0x9156472f, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "8.amf",        	0x020000, 0xecdb083b, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
	{ "10.amf",       	0x020000, 0x8fea8384, BRF_GRA | CPS1_EXTRA_TILES_SF2EBBL_400000 },
};

STD_ROM_PICK(Sf2tlonc)
STD_ROM_FN(Sf2tlonc)

static struct BurnRomInfo Sf2sl73aRomDesc[] = {
	// Sheng Long Hack is based off of sf2m5. 
	// It runs perfectly fine on an real sf2ce capcom cps1 arcade board.
	{ "sf2ced_23b.8f", 	0x080000, 0x190f5419, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2ced_22b.7f", 	0x080000, 0x2b329193, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sf2ced_21a.6f", 	0x080000, 0xb4f13bef, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",   	0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   	0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   	0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   	0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   	0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   	0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   	0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   	0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   	0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   	0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   	0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   	0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   	0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sf2ced_18.11c",  0x0020000, 0xa446a596, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   	0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2sl73a)
STD_ROM_FN(Sf2sl73a)

static struct BurnRomInfo Sf2cebltwRomDesc[] = {
	{ "27.12e",        0x020000, 0x035ee5d9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "31.12f",        0x020000, 0x353dbde1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "24.9e",         0x020000, 0x005b54cc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "28.9f",         0x020000, 0xc184d26d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "25.10e",        0x020000, 0x524f5c55, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "29.10f",        0x020000, 0xf06a12f2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "26.11e",        0x020000, 0x8312d055, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "30.11f",        0x020000, 0xd0580ff2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "s92_21a.5f",    0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "bruteforce.palce16v8h-25.11d",     0x040000, 0x430f722d, BRF_OPT }, // pal
};

STD_ROM_PICK(Sf2cebltw)
STD_ROM_FN(Sf2cebltw)

static struct BurnRomInfo SfzchRomDesc[] = {
	{ "sfzch23",       0x080000, 0x1140743f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza22",        0x080000, 0x8d9b2480, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfzch21",       0x080000, 0x5435225d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza20",        0x080000, 0x806e8f38, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sfz_01.3a",     0x080000, 0x0dd53e62, BRF_GRA | CPS1_TILES },
	{ "sfz_02.4a",     0x080000, 0x94c31e3f, BRF_GRA | CPS1_TILES },
	{ "sfz_03.5a",     0x080000, 0x9584ac85, BRF_GRA | CPS1_TILES },
	{ "sfz_04.6a",     0x080000, 0xb983624c, BRF_GRA | CPS1_TILES },
	{ "sfz_05.7a",     0x080000, 0x2b47b645, BRF_GRA | CPS1_TILES },
	{ "sfz_06.8a",     0x080000, 0x74fd9fb1, BRF_GRA | CPS1_TILES },
	{ "sfz_07.9a",     0x080000, 0xbb2c734d, BRF_GRA | CPS1_TILES },
	{ "sfz_08.10a",    0x080000, 0x454f7868, BRF_GRA | CPS1_TILES },
	{ "sfz_10.3c",     0x080000, 0x2a7d675e, BRF_GRA | CPS1_TILES },
	{ "sfz_11.4c",     0x080000, 0xe35546c8, BRF_GRA | CPS1_TILES },
	{ "sfz_12.5c",     0x080000, 0xf122693a, BRF_GRA | CPS1_TILES },
	{ "sfz_13.6c",     0x080000, 0x7cf942c8, BRF_GRA | CPS1_TILES },
	{ "sfz_14.7c",     0x080000, 0x09038c81, BRF_GRA | CPS1_TILES },
	{ "sfz_15.8c",     0x080000, 0x1aa17391, BRF_GRA | CPS1_TILES },
	{ "sfz_16.9c",     0x080000, 0x19a5abd6, BRF_GRA | CPS1_TILES },
	{ "sfz_17.10c",    0x080000, 0x248b3b73, BRF_GRA | CPS1_TILES },
	
	{ "sfz_09.12a",    0x010000, 0xc772628b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "sfz_18.11c",    0x020000, 0x61022b2d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sfz_19.12c",    0x020000, 0x3b5886d5, BRF_SND | CPS1_OKIM6295_SAMPLES },

	// SFZ63B was found on mpumpkin, assumed to be from SFZ
	{ "sfz63b.1a",     0x000104, 0xf5a351da, BRF_OPT },	// b-board PLDs
};

STD_ROM_PICK(Sfzch)
STD_ROM_FN(Sfzch)

static struct BurnRomInfo SfzchaRomDesc[] = {
	{ "23",       	   0x080000, 0xd21e200d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza22",        0x080000, 0x8d9b2480, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfzch21",       0x080000, 0x5435225d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza20",        0x080000, 0x806e8f38, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sfz_01.3a",     0x080000, 0x0dd53e62, BRF_GRA | CPS1_TILES },
	{ "sfz_02.4a",     0x080000, 0x94c31e3f, BRF_GRA | CPS1_TILES },
	{ "sfz_03.5a",     0x080000, 0x9584ac85, BRF_GRA | CPS1_TILES },
	{ "sfz_04.6a",     0x080000, 0xb983624c, BRF_GRA | CPS1_TILES },
	{ "sfz_05.7a",     0x080000, 0x2b47b645, BRF_GRA | CPS1_TILES },
	{ "sfz_06.8a",     0x080000, 0x74fd9fb1, BRF_GRA | CPS1_TILES },
	{ "sfz_07.9a",     0x080000, 0xbb2c734d, BRF_GRA | CPS1_TILES },
	{ "sfz_08.10a",    0x080000, 0x454f7868, BRF_GRA | CPS1_TILES },
	{ "sfz_10.3c",     0x080000, 0x2a7d675e, BRF_GRA | CPS1_TILES },
	{ "sfz_11.4c",     0x080000, 0xe35546c8, BRF_GRA | CPS1_TILES },
	{ "sfz_12.5c",     0x080000, 0xf122693a, BRF_GRA | CPS1_TILES },
	{ "sfz_13.6c",     0x080000, 0x7cf942c8, BRF_GRA | CPS1_TILES },
	{ "sfz_14.7c",     0x080000, 0x09038c81, BRF_GRA | CPS1_TILES },
	{ "sfz_15.8c",     0x080000, 0x1aa17391, BRF_GRA | CPS1_TILES },
	{ "sfz_16.9c",     0x080000, 0x19a5abd6, BRF_GRA | CPS1_TILES },
	{ "sfz_17.10c",    0x080000, 0x248b3b73, BRF_GRA | CPS1_TILES },
	
	{ "sfz_09.12a",    0x010000, 0xc772628b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "sfz_18.11c",    0x020000, 0x61022b2d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sfz_19.12c",    0x020000, 0x3b5886d5, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sfzcha)
STD_ROM_FN(Sfzcha)

static struct BurnRomInfo SlammastRomDesc[] = {
	{ "mbe_23e.8f",    	0x080000, 0x5394057a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_24b.9e",    	0x020000, 0x95d5e729, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_28b.9f",    	0x020000, 0xb1c7cbcb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_25b.10e",   	0x020000, 0xa50d3fd4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "mbe_29b.10f",   	0x020000, 0x08e32e56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_21a.6f",    	0x080000, 0xd5007b05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_20a.5f",    	0x080000, 0xaeb557b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb-1m.3a",      	0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb-3m.5a",      	0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb-2m.4a",      	0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb-4m.6a",      	0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb-5m.7a",      	0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb-7m.9a",      	0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb-6m.8a",      	0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb-8m.10a",     	0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb-10m.3c",     	0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb-12m.5c",     	0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb-11m.4c",     	0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb-13m.6c",     	0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },
	
	{ "mb_qa.5k",      	0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb-q1.1k",     	0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q2.2k",     	0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q3.3k",     	0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q4.4k",     	0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q5.1m",     	0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q6.2m",     	0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q7.3m",     	0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q8.4m",     	0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "mb63b.1a",      	0x000117, 0xb8392f02, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      	0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     	0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      	0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       	0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       	0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       	0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     	0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Slammast)
STD_ROM_FN(Slammast)

static struct BurnRomInfo SlammastuRomDesc[] = {
	{ "mbu_23e.8f",    	0x080000, 0x224f0062, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbu_24b.9e",    	0x020000, 0x95d5e729, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbu_28b.9f",    	0x020000, 0xb1c7cbcb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbu_25b.10e",   	0x020000, 0xa50d3fd4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbu_29b.10f",   	0x020000, 0x08e32e56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbu_21a.6f",    	0x080000, 0xd5007b05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbu_20a.5f",    	0x080000, 0xfc848af5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb-1m.3a",      	0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb-3m.5a",      	0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb-2m.4a",      	0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb-4m.6a",      	0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb-5m.7a",      	0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb-7m.9a",      	0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb-6m.8a",      	0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb-8m.10a",     	0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb-10m.3c",     	0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb-12m.5c",     	0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb-11m.4c",     	0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb-13m.6c",     	0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },
	
	{ "mb_qa.5k",      	0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb-q1.1k",     	0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q2.2k",     	0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q3.3k",     	0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q4.4k",     	0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q5.1m",     	0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q6.2m",     	0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q7.3m",     	0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q8.4m",     	0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "mb63b.1a",      	0x000117, 0xb8392f02, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      	0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     	0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      	0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       	0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       	0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       	0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     	0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Slammastu)
STD_ROM_FN(Slammastu)

static struct BurnRomInfo MbomberjRomDesc[] = {
	{ "mbj_23e.8f",    0x080000, 0x0d06036a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbj_22b.7f",    0x080000, 0xacd38478, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbj_21a.6f",    0x080000, 0xd5007b05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbj_20a.5f",    0x080000, 0xaeb557b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_01.3a",      0x080000, 0xa53b1c81, BRF_GRA | CPS1_TILES },
	{ "mb_02.4a",      0x080000, 0x23fe10f6, BRF_GRA | CPS1_TILES },
	{ "mb_03.5a",      0x080000, 0xcb866c2f, BRF_GRA | CPS1_TILES },
	{ "mb_04.6a",      0x080000, 0xc9143e75, BRF_GRA | CPS1_TILES },
	{ "mb_05.7a",      0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_06.8a",      0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_07.9a",      0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.10a",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.3c",      0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_11.4c",      0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_12.5c",      0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.6c",      0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },
	
	{ "mb_qa.5k",      0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb-q1.1k",      0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q2.2k",      0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q3.3k",      0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q4.4k",      0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q5.1m",      0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q6.2m",      0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q7.3m",      0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q8.4m",      0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "mb63b.1a",      0x000117, 0xb8392f02, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Mbomberj)
STD_ROM_FN(Mbomberj)

static struct BurnRomInfo MbombrdRomDesc[] = {
	{ "mbde_26.11e",   0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_30.11f",   0x020000, 0xa036dc16, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_27.12e",   0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_31.12f",   0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_24.9e",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_28.9f",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_25.10e",   0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_29.10f",   0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbde_21.6f",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbde_20.5f",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb-1m.3a",      0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb-3m.5a",  	   0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb-2m.4a",      0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb-4m.6a",      0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb-5m.7a",      0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb-7m.9a",      0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb-6m.8a",      0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb-8m.10a",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb-10m.3c",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb-12m.5c",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb-11m.4c",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb-13m.6c",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_q.5k",       0x020000, 0xd6fa76d1, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb-q1.1k",      0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q2.2k",      0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q3.3k",      0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q4.4k",      0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q5.1m",      0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q6.2m",      0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q7.3m",      0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q8.4m",      0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "mb63b.1a",      0x000117, 0xb8392f02, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Mbombrd)
STD_ROM_FN(Mbombrd)

static struct BurnRomInfo MbombrdjRomDesc[] = {
	{ "mbdj_26.11e",   0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_30.11f",   0x020000, 0xbeff31cf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_27.12e",   0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_31.12f",   0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_24.9e",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_28.9f",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_25.10e",   0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_29.10f",   0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_21.6f",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbdj_20.5f",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_01.3a",      0x080000, 0xa53b1c81, BRF_GRA | CPS1_TILES },
	{ "mb_02.4a",      0x080000, 0x23fe10f6, BRF_GRA | CPS1_TILES },
	{ "mb_03.5a",      0x080000, 0xcb866c2f, BRF_GRA | CPS1_TILES },
	{ "mb_04.6a",      0x080000, 0xc9143e75, BRF_GRA | CPS1_TILES },
	{ "mb_05.7a",      0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_06.8a",      0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_07.9a",      0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.10a",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.3c",      0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_11.4c",      0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_12.5c",      0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.6c",      0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_qa.5k",      0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb-q1.1k",      0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q2.2k",      0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q3.3k",      0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q4.4k",      0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q5.1m",      0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q6.2m",      0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q7.3m",      0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q8.4m",      0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "mb63b.1a",      0x000117, 0xb8392f02, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",       0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Mbombrdj)
STD_ROM_FN(Mbombrdj)

static struct BurnRomInfo SlampicRomDesc[] = {
	{ "5.bin",				0x080000, 0x7dba63cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",				0x080000, 0xd86671f3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.bin",				0x080000, 0xd14d0e42, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",				0x080000, 0x38063cd8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	{ "9.bin",				0x080000, 0xdc140351, BRF_GRA | CPS1_TILES },
	{ "8.bin",				0x080000, 0x9ae88035, BRF_GRA | CPS1_TILES },
	{ "7.bin",				0x080000, 0x5321f759, BRF_GRA | CPS1_TILES },
	{ "6.bin",				0x080000, 0xc8eb5f76, BRF_GRA | CPS1_TILES },
	{ "17.bin",				0x080000, 0x21652214, BRF_GRA | CPS1_TILES },
	{ "16.bin",				0x080000, 0xd49d2eb0, BRF_GRA | CPS1_TILES },
	{ "15.bin",				0x080000, 0x0d98bfd6, BRF_GRA | CPS1_TILES },
	{ "14.bin",				0x080000, 0x807284f1, BRF_GRA | CPS1_TILES },
	{ "13.bin",				0x080000, 0x293579c5, BRF_GRA | CPS1_TILES },
	{ "12.bin",				0x080000, 0xc3727ce7, BRF_GRA | CPS1_TILES },
	{ "11.bin",				0x080000, 0x2919883b, BRF_GRA | CPS1_TILES },
	{ "10.bin",				0x080000, 0xf538e620, BRF_GRA | CPS1_TILES },
	
	// not in dump but the game expects to read it as protection, maybe the PIC writes to the same area?
	{ "mb_qa.5k",			0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb-q1.1k",		 	0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q2.2k",		 	0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q3.3k",			0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q4.4k",			0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q5.1m",			0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q6.2m",		 	0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q7.3m",		  	0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb-q8.4m",		 	0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "mb63b.1a",		  	0x000117, 0xb8392f02, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",		  	0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",		 	0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",		  	0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs

	{ "d7l1.7l",		 	0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",		  	0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k2.9k",		   	0x000117, 0xcd85a156, BRF_OPT },
	{ "d10f1.10f",			0x000117, 0x6619c494, BRF_OPT },

	{ "pic16c57-xt-p.bin",	0x002000, 0xaeae5ccc, BRF_PRG | CPS1_PIC },
#if !defined ROM_VERIFY
	{ "pic16c57-xt-p.hex",	0x005a1e, 0x61f8607e, BRF_OPT }, // hex dump of PIC
#endif

	{ "18.bin",				0x080000, 0x73a0c11c, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "1_palce16v8.bin",	0x000117, 0xbac89609, BRF_OPT },
	{ "2_palce16v8.bin",	0x000117, 0x680edfd5, BRF_OPT },
	{ "3_palce20v8.bin",	0x000157, 0xf1fe9368, BRF_OPT },
	{ "4_palce20v8.bin",	0x000157, 0x20946530, BRF_OPT },
	{ "5_palce20v8.bin",	0x000157, 0x44df0cc6, BRF_OPT },
	{ "6_palce16v8.bin",	0x000117, 0x12516583, BRF_OPT },
};

STD_ROM_PICK(Slampic)
STD_ROM_FN(Slampic)

static struct BurnRomInfo Slampic2RomDesc[] = {
	{ "4.bin",			0x080000, 0x105cfefd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",			0x080000, 0x6026c95e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",			0x080000, 0x0effa84a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.bin",			0x080000, 0x8fcb683a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	// overall just 2 bytes diff vs official set (slammast)
	{ "rom7.bin",		0x080000, 0xb5669ad3, BRF_GRA | CPS1_TILES },
	{ "rom8.bin",		0x080000, 0xf07a6085, BRF_GRA | CPS1_TILES },
	{ "rom5.bin",		0x080000, 0x5321f759, BRF_GRA | CPS1_TILES },
	{ "rom6.bin",		0x080000, 0xc8eb5f76, BRF_GRA | CPS1_TILES },
	{ "rom11.bin",		0x080000, 0x21652214, BRF_GRA | CPS1_TILES },
	{ "rom12.bin",		0x080000, 0xd49d2eb0, BRF_GRA | CPS1_TILES },
	{ "rom9.bin",		0x080000, 0x0d98bfd6, BRF_GRA | CPS1_TILES },
	{ "rom10.bin",		0x080000, 0x807284f1, BRF_GRA | CPS1_TILES },
	{ "rom15.bin",		0x080000, 0x293579c5, BRF_GRA | CPS1_TILES },
	{ "rom16.bin",		0x080000, 0xc3727ce7, BRF_GRA | CPS1_TILES },
	{ "rom13.bin",		0x080000, 0x2919883b, BRF_GRA | CPS1_TILES },
	{ "rom14.bin",		0x080000, 0xf538e620, BRF_GRA | CPS1_TILES },
	
	{ "24.bin",			0x010000, 0x13ea1c44, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "pic_u33.bin",	0x001007, 0x6dba4094, BRF_PRG | CPS1_PIC },

	{ "v1.bin",			0x040000, 0x8962b469, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "v2.bin",			0x080000, 0x6687df38, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "v3.bin",			0x080000, 0x5782baee, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "2_gal16v8.p1",	0x000117, 0xa944ff96, BRF_OPT },
};

STD_ROM_PICK(Slampic2)
STD_ROM_FN(Slampic2)

static struct BurnRomInfo StriderRomDesc[] = {
	{ "30.11f",        0x020000, 0xda997474, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.11h",        0x020000, 0x5463aaa3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "31.12f",        0x020000, 0xd20786db, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "36.12h",        0x020000, 0x21aa2863, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "st-14.8h",      0x080000, 0x9b3cfc08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "st-2.8a",       0x080000, 0x4eee9aea, BRF_GRA | CPS1_TILES },
	{ "st-11.10a",     0x080000, 0x2d7f21e4, BRF_GRA | CPS1_TILES },
	{ "st-5.4a",       0x080000, 0x7705aa46, BRF_GRA | CPS1_TILES },
	{ "st-9.6a",       0x080000, 0x5b18b722, BRF_GRA | CPS1_TILES },
	{ "st-1.7a",       0x080000, 0x005f000b, BRF_GRA | CPS1_TILES },
	{ "st-10.9a",      0x080000, 0xb9441519, BRF_GRA | CPS1_TILES },
	{ "st-4.3a",       0x080000, 0xb7d04e8b, BRF_GRA | CPS1_TILES },
	{ "st-8.5a",       0x080000, 0x6b4713b4, BRF_GRA | CPS1_TILES },

	{ "09.12b",        0x010000, 0x2ed403bc, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.11c",        0x020000, 0x4386bc80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.12c",        0x020000, 0x444536d7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "st24m1.1a",     0x000117, 0xa80d357e, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Strider)
STD_ROM_FN(Strider)

static struct BurnRomInfo StrideruaRomDesc[] = {
	{ "30.11f", 	   0x020000, 0x66aec273, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // different CRC from strider, pcb verified
	{ "35.11h", 	   0x020000, 0x50e0e865, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // different CRC from strider, pcb verified
	{ "31.12f", 	   0x020000, 0xeae93bd1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // different CRC from strider, pcb verified
	{ "36.12h", 	   0x020000, 0xb904a31d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // different CRC from strider, pcb verified
	{ "st-14.8h",      0x080000, 0x9b3cfc08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // in "32" socket

	{ "st-2.8a",       0x080000, 0x4eee9aea, BRF_GRA | CPS1_TILES },
	{ "st-11.10a",     0x080000, 0x2d7f21e4, BRF_GRA | CPS1_TILES },
	{ "st-5.4a",       0x080000, 0x7705aa46, BRF_GRA | CPS1_TILES },
	{ "st-9.6a",       0x080000, 0x5b18b722, BRF_GRA | CPS1_TILES },
	{ "st-1.7a",       0x080000, 0x005f000b, BRF_GRA | CPS1_TILES },
	{ "st-10.9a",      0x080000, 0xb9441519, BRF_GRA | CPS1_TILES },
	{ "st-4.3a",       0x080000, 0xb7d04e8b, BRF_GRA | CPS1_TILES },
	{ "st-8.5a",       0x080000, 0x6b4713b4, BRF_GRA | CPS1_TILES },

	{ "09.12b", 	   0x010000, 0x08d63519, BRF_PRG | CPS1_Z80_PROGRAM }, // different CRC from strider, pcb verified

	{ "18.11c",        0x020000, 0x4386bc80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.12c",        0x020000, 0x444536d7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "st24b2.1a",     0x000117, 0x00000000, BRF_OPT | BRF_NODUMP }, // b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Striderua)
STD_ROM_FN(Striderua)

static struct BurnRomInfo StriderucRomDesc[] = {
	{ "34.8f",    	   0x080000, 0xe0fb5657, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "33.6f",    	   0x080000, 0x9b3cfc08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "6.8a",          0x080000, 0x4eee9aea, BRF_GRA | CPS1_TILES },
	{ "8.10a",     	   0x080000, 0x2d7f21e4, BRF_GRA | CPS1_TILES },
	{ "5.7a",          0x080000, 0x7705aa46, BRF_GRA | CPS1_TILES },
	{ "7.9a",          0x080000, 0x5b18b722, BRF_GRA | CPS1_TILES },
	{ "15.8c",         0x080000, 0x005f000b, BRF_GRA | CPS1_TILES },
	{ "17.10c",        0x080000, 0xb9441519, BRF_GRA | CPS1_TILES },
	{ "14.7c",         0x080000, 0xb7d04e8b, BRF_GRA | CPS1_TILES },
	{ "16.9c",         0x080000, 0x6b4713b4, BRF_GRA | CPS1_TILES },

	{ "9.12a",  	   0x010000, 0x08d63519, BRF_PRG | CPS1_Z80_PROGRAM }, 

	{ "18.11c",        0x020000, 0x4386bc80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.12c",        0x020000, 0x444536d7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT }, // a-board PLDs
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },
	{ "prg1",          0x000117, 0xf1129744, BRF_OPT },
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },
	{ "sou1",          0x000117, 0x84f4b2fe, BRF_OPT },
	
	{ "unknown.1a",    0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },	// b-board PLDs
	{ "iob1.11d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Strideruc)
STD_ROM_FN(Strideruc)

static struct BurnRomInfo StriderjrRomDesc[] = {
	{ "sthj_23.8f",    0x080000, 0x046e7b12, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sthj_22.7f",    0x080000, 0x9b3cfc08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sth_01.3a",     0x080000, 0x4eee9aea, BRF_GRA | CPS1_TILES },
	{ "sth_02.4a",     0x080000, 0x2d7f21e4, BRF_GRA | CPS1_TILES },
	{ "sth_03.5a",     0x080000, 0x7705aa46, BRF_GRA | CPS1_TILES },
	{ "sth_04.6a",     0x080000, 0x5b18b722, BRF_GRA | CPS1_TILES },
	{ "sth_05.7a",     0x080000, 0x005f000b, BRF_GRA | CPS1_TILES },
	{ "sth_06.8a",     0x080000, 0xb9441519, BRF_GRA | CPS1_TILES },
	{ "sth_07.9a",     0x080000, 0xb7d04e8b, BRF_GRA | CPS1_TILES },
	{ "sth_08.10a",    0x080000, 0x6b4713b4, BRF_GRA | CPS1_TILES },

	{ "sth_09.12a",    0x010000, 0x08d63519, BRF_PRG | CPS1_Z80_PROGRAM }, 

	{ "sth_18.11c",    0x020000, 0x4386bc80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sth_19.12c",    0x020000, 0x444536d7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "sth63b.1a",     0x000117, 0xc706b773, BRF_OPT }, // b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Striderjr)
STD_ROM_FN(Striderjr)

static struct BurnRomInfo StriderjRomDesc[] = {
	{ "sth_36.12f",    0x020000, 0x53c7b006, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_42.12h",    0x020000, 0x4037f65f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_37.13f",    0x020000, 0x80e8877d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_43.13h",    0x020000, 0x6b3fa466, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_34.10f",    0x020000, 0xbea770b5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_40.10h",    0x020000, 0x43b922dc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_35.11f",    0x020000, 0x5cc429da, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sth_41.11h",    0x020000, 0x50af457f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "sth_09.4b",     0x020000, 0x1ef6bfbd, BRF_GRA | CPS1_TILES },
	{ "sth_01.4a",     0x020000, 0x1e21b0c1, BRF_GRA | CPS1_TILES },
	{ "sth_13.9b",     0x020000, 0x063263ae, BRF_GRA | CPS1_TILES },
	{ "sth_05.9a",     0x020000, 0xec9f8714, BRF_GRA | CPS1_TILES },	
	{ "sth_24.5e",     0x020000, 0x6356f4d2, BRF_GRA | CPS1_TILES },	
	{ "sth_17.5c",     0x020000, 0xb4f73d86, BRF_GRA | CPS1_TILES },
	{ "sth_38.8h",     0x020000, 0xee5abfc2, BRF_GRA | CPS1_TILES },
	{ "sth_32.8f",     0x020000, 0x44a206a3, BRF_GRA | CPS1_TILES },	
	{ "sth_10.5b",     0x020000, 0xdf3dd3bc, BRF_GRA | CPS1_TILES },	
	{ "sth_02.5a",     0x020000, 0xc75f9ea0, BRF_GRA | CPS1_TILES },
	{ "sth_14.10b",    0x020000, 0x6c03e19d, BRF_GRA | CPS1_TILES },
	{ "sth_06.10a",    0x020000, 0xd84f5478, BRF_GRA | CPS1_TILES },	
	{ "sth_25.7e",     0x020000, 0x921e506a, BRF_GRA | CPS1_TILES },
	{ "sth_18.7c",     0x020000, 0x5b318956, BRF_GRA | CPS1_TILES },
	{ "sth_39.9h",     0x020000, 0x9321d6aa, BRF_GRA | CPS1_TILES },
	{ "sth_33.9f",     0x020000, 0xb47ddfc7, BRF_GRA | CPS1_TILES },	
	{ "sth_11.7b",     0x020000, 0x2484f241, BRF_GRA | CPS1_TILES },
	{ "sth_03.7a",     0x020000, 0xaaa07245, BRF_GRA | CPS1_TILES },
	{ "sth_15.11b",    0x020000, 0xe415d943, BRF_GRA | CPS1_TILES },
	{ "sth_07.11a",    0x020000, 0x97d072d2, BRF_GRA | CPS1_TILES },
	{ "sth_26.8e",     0x020000, 0x0ebfcb02, BRF_GRA | CPS1_TILES },
	{ "sth_19.8c",     0x020000, 0x257ce683, BRF_GRA | CPS1_TILES },
	{ "sth_28.10e",    0x020000, 0x98ac8cd1, BRF_GRA | CPS1_TILES },
	{ "sth_21.10c",    0x020000, 0x538d9423, BRF_GRA | CPS1_TILES },
	{ "sth_12.8b",     0x020000, 0xf670a477, BRF_GRA | CPS1_TILES },
	{ "sth_04.8a",     0x020000, 0x853d3e01, BRF_GRA | CPS1_TILES },
	{ "sth_16.12b",    0x020000, 0x4092019f, BRF_GRA | CPS1_TILES },
	{ "sth_08.12a",    0x020000, 0x2ce9b4c7, BRF_GRA | CPS1_TILES },
	{ "sth_27.9e",     0x020000, 0xf82c88d9, BRF_GRA | CPS1_TILES },
	{ "sth_20.9c",     0x020000, 0xeb584dd4, BRF_GRA | CPS1_TILES },
	{ "sth_29.11e",    0x020000, 0x34ae2997, BRF_GRA | CPS1_TILES },
	{ "sth_22.11c",    0x020000, 0x78dd9c48, BRF_GRA | CPS1_TILES },

	{ "sth_23.13c",    0x010000, 0x2ed403bc, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sth_30.12e",    0x020000, 0x4386bc80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sth_31.13e",    0x020000, 0x444536d7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "st22b.1a",      0x000117, 0x68fecc55, BRF_OPT },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Striderj)
STD_ROM_FN(Striderj)

// Strider arcade graphic and music fixes, author: NeoInvader
// source: https://www.romhacking.net/hacks/6758/

static struct BurnRomInfo StriderfixRomDesc[] = {
	{ "striderfix.11f",        0x020000, 0x8be794bf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "striderfix.11h",        0x020000, 0x9318060c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "31.12f",                0x020000, 0xd20786db, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "36.12h",                0x020000, 0x21aa2863, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "st-14.8h",              0x080000, 0x9b3cfc08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "striderfix.8a",         0x080000, 0xea572e97, BRF_GRA | CPS1_TILES },
	{ "striderfix.10a",        0x080000, 0xd0bb852f, BRF_GRA | CPS1_TILES },
	{ "striderfix.4a",         0x080000, 0x8c408787, BRF_GRA | CPS1_TILES },
	{ "striderfix.6a",         0x080000, 0x07ba4914, BRF_GRA | CPS1_TILES },
	{ "st-1.7a",               0x080000, 0x005f000b, BRF_GRA | CPS1_TILES },
	{ "st-10.9a",              0x080000, 0xb9441519, BRF_GRA | CPS1_TILES },
	{ "st-4.3a",               0x080000, 0xb7d04e8b, BRF_GRA | CPS1_TILES },
	{ "st-8.5a",               0x080000, 0x6b4713b4, BRF_GRA | CPS1_TILES },

	{ "striderfix.12b",        0x010000, 0x08d63519, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.11c",                0x020000, 0x4386bc80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.12c",                0x020000, 0x444536d7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "st24m1.1a",             0x000117, 0xa80d357e, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",              0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Striderfix)
STD_ROM_FN(Striderfix)

static struct BurnRomInfo UnsquadRomDesc[] = {
	{ "aru_30.11f",    0x020000, 0x24d8f88d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "aru_35.11h",    0x020000, 0x8b954b59, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "aru_31.12f",    0x020000, 0x33e9694b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "aru_36.12h",    0x020000, 0x7cc8fb9e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar-32m.8h",     0x080000, 0xae1d7fb0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ar-5m.7a",      0x080000, 0xbf4575d8, BRF_GRA | CPS1_TILES },
	{ "ar-7m.9a",      0x080000, 0xa02945f4, BRF_GRA | CPS1_TILES },
	{ "ar-1m.3a",      0x080000, 0x5965ca8d, BRF_GRA | CPS1_TILES },
	{ "ar-3m.5a",      0x080000, 0xac6db17d, BRF_GRA | CPS1_TILES },

	{ "ar_09.12b",     0x010000, 0xf3dd1367, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "aru_18.11c",    0x020000, 0x584b43a9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ar24b.1a",      0x000117, 0x09a51271, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Unsquad)
STD_ROM_FN(Unsquad)

static struct BurnRomInfo Area88RomDesc[] = {
	{ "ar_36.12f",     0x020000, 0x65030392, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_42.12h",     0x020000, 0xc48170de, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_37.13f",     0x020000, 0x33e9694b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_43.13h",     0x020000, 0x7cc8fb9e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_34.10f",     0x020000, 0xf6e80386, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_40.10h",     0x020000, 0xbe36c145, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_35.11f",     0x020000, 0x86d98ff3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ar_41.11h",     0x020000, 0x758893d3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ar_09.4b",      0x020000, 0xdb9376f8, BRF_GRA | CPS1_TILES },
	{ "ar_01.4a",      0x020000, 0x392151b4, BRF_GRA | CPS1_TILES },
	{ "ar_13.9b",      0x020000, 0x81436481, BRF_GRA | CPS1_TILES },
	{ "ar_05.9a",      0x020000, 0xe246ed9f, BRF_GRA | CPS1_TILES },
	{ "ar_24.5e",      0x020000, 0x9cd6e2a3, BRF_GRA | CPS1_TILES },
	{ "ar_17.5c",      0x020000, 0x0b8e0df4, BRF_GRA | CPS1_TILES },
	{ "ar_38.8h",      0x020000, 0x8b9e75b9, BRF_GRA | CPS1_TILES },
	{ "ar_32.8f",      0x020000, 0xdb6acdcf, BRF_GRA | CPS1_TILES },
	{ "ar_10.5b",      0x020000, 0x4219b622, BRF_GRA | CPS1_TILES },
	{ "ar_02.5a",      0x020000, 0xbac5dec5, BRF_GRA | CPS1_TILES },
	{ "ar_14.10b",     0x020000, 0xe6bae179, BRF_GRA | CPS1_TILES },
	{ "ar_06.10a",     0x020000, 0xc8f04223, BRF_GRA | CPS1_TILES },
	{ "ar_25.7e",      0x020000, 0x15ccf981, BRF_GRA | CPS1_TILES },
	{ "ar_18.7c",      0x020000, 0x9336db6a, BRF_GRA | CPS1_TILES },
	{ "ar_39.9h",      0x020000, 0x9b8e1363, BRF_GRA | CPS1_TILES },
	{ "ar_33.9f",      0x020000, 0x3968f4b5, BRF_GRA | CPS1_TILES },

	{ "ar_23.13c",     0x010000, 0xf3dd1367, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ar_30.12e",     0x020000, 0x584b43a9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ar22b.1a",      0x000117, 0xf1db9030, BRF_OPT },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Area88)
STD_ROM_FN(Area88)

static struct BurnRomInfo Area88rRomDesc[] = {
	{ "araj_23.8f",    0x080000, 0x7045d6cb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "araj_22.7f",    0x080000, 0x9913002e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ara_01.3a",     0x080000, 0xbf4575d8, BRF_GRA | CPS1_TILES },
	{ "ara_02.4a",     0x080000, 0xa02945f4, BRF_GRA | CPS1_TILES },
	{ "ara_03.5a",     0x080000, 0x5965ca8d, BRF_GRA | CPS1_TILES },
	{ "ara_04.6a",     0x080000, 0xac6db17d, BRF_GRA | CPS1_TILES },

	{ "ara_09.12a",    0x020000, 0xaf88359c, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ara_18.11c",    0x020000, 0x584b43a9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "ara63b.1a",     0x000117, 0xf5569c93, BRF_OPT },// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Area88r)
STD_ROM_FN(Area88r)

static struct BurnRomInfo VarthRomDesc[] = {
	{ "vae_30b.11f",   0x020000, 0xadb8d391, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_35b.11h",   0x020000, 0x44e5548f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_31b.12f",   0x020000, 0x1749a71c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_36b.12h",   0x020000, 0x5f2e2450, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_28b.9f",    0x020000, 0xe524ca50, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_33b.9h",    0x020000, 0xc0bbf8c9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_29b.10f",   0x020000, 0x6640996a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_34b.10h",   0x020000, 0xfa59be8a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "va-5m.7a",      0x080000, 0xb1fb726e, BRF_GRA | CPS1_TILES },
	{ "va-7m.9a",      0x080000, 0x4c6588cd, BRF_GRA | CPS1_TILES },
	{ "va-1m.3a",      0x080000, 0x0b1ace37, BRF_GRA | CPS1_TILES },
	{ "va-3m.5a",      0x080000, 0x44dfe706, BRF_GRA | CPS1_TILES },

	{ "va_09.12b",     0x010000, 0x7a99446e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "va_18.11c",     0x020000, 0xde30510e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "va_19.12c",     0x020000, 0x0610a4ac, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "va24b.1a",      0x000117, 0xcc476650, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Varth)
STD_ROM_FN(Varth)

static struct BurnRomInfo Varthr1RomDesc[] = {
	{ "vae_30a.11f",   0x020000, 0x7fcd0091, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_35a.11h",   0x020000, 0x35cf9509, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_31a.12f",   0x020000, 0x15e5ee81, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_36a.12h",   0x020000, 0x153a201e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_28a.9f",    0x020000, 0x7a0e0d25, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_33a.9h",    0x020000, 0xf2365922, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_29a.10f",   0x020000, 0x5e2cd2c3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vae_34a.10h",   0x020000, 0x3d9bdf83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "va-5m.7a",      0x080000, 0xb1fb726e, BRF_GRA | CPS1_TILES },
	{ "va-7m.9a",      0x080000, 0x4c6588cd, BRF_GRA | CPS1_TILES },
	{ "va-1m.3a",      0x080000, 0x0b1ace37, BRF_GRA | CPS1_TILES },
	{ "va-3m.5a",      0x080000, 0x44dfe706, BRF_GRA | CPS1_TILES },

	{ "va_09.12b",     0x010000, 0x7a99446e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "va_18.11c",     0x020000, 0xde30510e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "va_19.12c",     0x020000, 0x0610a4ac, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "va24b.1a",      0x000117, 0xcc476650, BRF_OPT },	// b-board PLDs
	{ "iob1.11e",      0x000117, 0x3abc0700, BRF_OPT },
};

STD_ROM_PICK(Varthr1)
STD_ROM_FN(Varthr1)

static struct BurnRomInfo VarthjRomDesc[] = {
	{ "vaj_36b.12f",   0x020000, 0x1d798d6a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_42b.12h",   0x020000, 0x0f720233, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_37b.13f",   0x020000, 0x24414b17, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_43b.13h",   0x020000, 0x34b4b06c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_34b.10f",   0x020000, 0x87c79aed, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_40b.10h",   0x020000, 0x210b4bd0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_35b.11f",   0x020000, 0x6b0da69f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "vaj_41b.11h",   0x020000, 0x6542c8a4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "va_09.4b",      0x020000, 0x183dfaa8, BRF_GRA | CPS1_TILES },
	{ "va_01.4a",      0x020000, 0xc41312b5, BRF_GRA | CPS1_TILES },
	{ "va_13.9b",      0x020000, 0x45537e69, BRF_GRA | CPS1_TILES },
	{ "va_05.9a",      0x020000, 0x7065d4e9, BRF_GRA | CPS1_TILES },
	{ "va_24.5e",      0x020000, 0x57191ccf, BRF_GRA | CPS1_TILES },
	{ "va_17.5c",      0x020000, 0x054f5a5b, BRF_GRA | CPS1_TILES },
	{ "va_38.8h",      0x020000, 0xe117a17e, BRF_GRA | CPS1_TILES },
	{ "va_32.8f",      0x020000, 0x3b4f40b2, BRF_GRA | CPS1_TILES },
	{ "va_10.5b",      0x020000, 0xd62750cd, BRF_GRA | CPS1_TILES },
	{ "va_02.5a",      0x020000, 0x11590325, BRF_GRA | CPS1_TILES },
	{ "va_14.10b",     0x020000, 0xdc2f4783, BRF_GRA | CPS1_TILES },
	{ "va_06.10a",     0x020000, 0x06e833ac, BRF_GRA | CPS1_TILES },
	{ "va_25.7e",      0x020000, 0x51d90690, BRF_GRA | CPS1_TILES },
	{ "va_18.7c",      0x020000, 0xa17817c0, BRF_GRA | CPS1_TILES },
	{ "va_39.9h",      0x020000, 0xb0b12f51, BRF_GRA | CPS1_TILES },
	{ "va_33.9f",      0x020000, 0x4b003af7, BRF_GRA | CPS1_TILES },

	{ "va_23.13c",     0x010000, 0x7a99446e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "va_30.12e",     0x020000, 0xde30510e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "va_31.13e",     0x020000, 0x0610a4ac, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "va22b.1a",      0x000117, 0xbd7cd574, BRF_OPT },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Varthj)
STD_ROM_FN(Varthj)

static struct BurnRomInfo VarthjrRomDesc[] = {
	{ "vaj_23b.8f",    0x080000, 0xad3d3522, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "vaj_22b.7f",    0x080000, 0x034e3e55, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "va_01.3a",      0x080000, 0xb1fb726e, BRF_GRA | CPS1_TILES }, // == va-5m.7a
	{ "va_02.4a",      0x080000, 0x4c6588cd, BRF_GRA | CPS1_TILES }, // == va-7m.9a
	{ "va_03.5a",      0x080000, 0x0b1ace37, BRF_GRA | CPS1_TILES }, // == va-1m.3a
	{ "va_04.6a",      0x080000, 0x44dfe706, BRF_GRA | CPS1_TILES }, // == va-3m.5a

	{ "va_09.12a",     0x010000, 0x7a99446e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "va_18.11c",     0x020000, 0xde30510e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "va_19.12c",     0x020000, 0x0610a4ac, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "va63b.1a",      0x000117, 0x132ab7c5, BRF_OPT }, // b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Varthjr)
STD_ROM_FN(Varthjr)

static struct BurnRomInfo VarthuRomDesc[] = {
	{ "vau_23a.8f",    0x080000, 0xfbe68726, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "vau_22a.7f",    0x080000, 0x0ed71bbd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "va-5m.3a",      0x080000, 0xb1fb726e, BRF_GRA | CPS1_TILES },
	{ "va-7m.5a",      0x080000, 0x4c6588cd, BRF_GRA | CPS1_TILES },
	{ "va-1m.4a",      0x080000, 0x0b1ace37, BRF_GRA | CPS1_TILES },
	{ "va-3m.6a",      0x080000, 0x44dfe706, BRF_GRA | CPS1_TILES },

	{ "va_09.11a",     0x010000, 0x7a99446e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "va_18.11c",     0x020000, 0xde30510e, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "va_19.12c",     0x020000, 0x0610a4ac, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "va63b.1a",      0x000117, 0x132ab7c5, BRF_OPT }, // b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
};

STD_ROM_PICK(Varthu)
STD_ROM_FN(Varthu)

static struct BurnRomInfo VarthbRomDesc[] = {
	{ "2",             0x080000, 0x2f010023, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1",             0x080000, 0x0861dff3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4",             0x010000, 0xaa51e43b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3",             0x010000, 0xf7e4f2f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "14",            0x040000, 0x7ca73780, BRF_GRA | CPS1_TILES },
	{ "13",            0x040000, 0x9fb11869, BRF_GRA | CPS1_TILES },
	{ "12",            0x040000, 0xafeba416, BRF_GRA | CPS1_TILES },
	{ "11",            0x040000, 0x9eef3507, BRF_GRA | CPS1_TILES },
	{ "10",            0x040000, 0xeeec6183, BRF_GRA | CPS1_TILES },
	{ "9",             0x040000, 0x0e94f718, BRF_GRA | CPS1_TILES },
	{ "8",             0x040000, 0xc4ddc5b4, BRF_GRA | CPS1_TILES },
	{ "7",             0x040000, 0x8941ca12, BRF_GRA | CPS1_TILES },

	{ "6",             0x010000, 0x7a99446e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "5",             0x040000, 0x1547e595, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	{ "varth1.bin",    0x000157, 0x4c6a0d99, BRF_OPT },	// unknown
	{ "varth2.bin",    0x000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "varth3.bin",    0x000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "varth4.bin",    0x000117, 0x53317bf6, BRF_OPT },	// unknown
	{ "varth5.bin",    0x000157, 0x00000000, BRF_OPT | BRF_NODUMP },
	{ "varth6.bin",    0x000157, 0x00000000, BRF_OPT | BRF_NODUMP },
};

STD_ROM_PICK(Varthb)
STD_ROM_FN(Varthb)

static struct BurnRomInfo WillowRomDesc[] = {
	// No "Warning" (c) Capcom U.S.A., genuine export ROM labels
	{ "wle_30.11f",    0x020000, 0x15372aa2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wle_35.11h",    0x020000, 0x2e64623b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_31.12f",    0x020000, 0x0eb48a83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_36.12h",    0x020000, 0x36100209, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlm-32.8h",     0x080000, 0xdfd9f643, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "wlm-7.7a",      0x080000, 0xafa74b73, BRF_GRA | CPS1_TILES },
	{ "wlm-5.9a",      0x080000, 0x12a0dc0b, BRF_GRA | CPS1_TILES },
	{ "wlm-3.3a",      0x080000, 0xc6f2abce, BRF_GRA | CPS1_TILES },
	{ "wlm-1.5a",      0x080000, 0x4aa4c6d3, BRF_GRA | CPS1_TILES },
	{ "wl_24.7d",      0x020000, 0x6f0adee5, BRF_GRA | CPS1_TILES },
	{ "wl_14.7c",      0x020000, 0x9cf3027d, BRF_GRA | CPS1_TILES },
	{ "wl_26.9d",      0x020000, 0xf09c8ecf, BRF_GRA | CPS1_TILES },
	{ "wl_16.9c",      0x020000, 0xe35407aa, BRF_GRA | CPS1_TILES },
	{ "wl_20.3d",      0x020000, 0x84992350, BRF_GRA | CPS1_TILES },
	{ "wl_10.3c",      0x020000, 0xb87b5a36, BRF_GRA | CPS1_TILES },
	{ "wl_22.5d",      0x020000, 0xfd3f89f0, BRF_GRA | CPS1_TILES },
	{ "wl_12.5c",      0x020000, 0x7da49d69, BRF_GRA | CPS1_TILES },

	{ "wl_09.12b",     0x010000, 0xf6b3d060, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "wl_18.11c",     0x020000, 0xbde23d4d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "wl_19.12c",     0x020000, 0x683898f5, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "wl24b.1a",      0x000117, 0x7101cdf1, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Willow)
STD_ROM_FN(Willow)

static struct BurnRomInfo WillowuRomDesc[] = {
	{ "wlu_30.11f",    0x020000, 0xd604dbb1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "35.11h",        0x020000, 0x7a791e77, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_31.12f",    0x020000, 0x0eb48a83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_36.12h",    0x020000, 0x36100209, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlm-32.8h",     0x080000, 0xdfd9f643, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "wlm-7.7a",      0x080000, 0xafa74b73, BRF_GRA | CPS1_TILES },
	{ "wlm-5.9a",      0x080000, 0x12a0dc0b, BRF_GRA | CPS1_TILES },
	{ "wlm-3.3a",      0x080000, 0xc6f2abce, BRF_GRA | CPS1_TILES },
	{ "wlm-1.5a",      0x080000, 0x4aa4c6d3, BRF_GRA | CPS1_TILES },
	{ "wl_24.7d",      0x020000, 0x6f0adee5, BRF_GRA | CPS1_TILES },
	{ "wl_14.7c",      0x020000, 0x9cf3027d, BRF_GRA | CPS1_TILES },
	{ "wl_26.9d",      0x020000, 0xf09c8ecf, BRF_GRA | CPS1_TILES },
	{ "wl_16.9c",      0x020000, 0xe35407aa, BRF_GRA | CPS1_TILES },
	{ "wl_20.3d",      0x020000, 0x84992350, BRF_GRA | CPS1_TILES },
	{ "wl_10.3c",      0x020000, 0xb87b5a36, BRF_GRA | CPS1_TILES },
	{ "wl_22.5d",      0x020000, 0xfd3f89f0, BRF_GRA | CPS1_TILES },
	{ "wl_12.5c",      0x020000, 0x7da49d69, BRF_GRA | CPS1_TILES },

	{ "wl_09.12b",     0x010000, 0xf6b3d060, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "wl_18.11c",     0x020000, 0xbde23d4d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "wl_19.12c",     0x020000, 0x683898f5, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "wl24b.1a",      0x000117, 0x7101cdf1, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Willowu)
STD_ROM_FN(Willowu)

static struct BurnRomInfo WillowuoRomDesc[] = {
	{ "wlu_30.11f",    0x020000, 0xd604dbb1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_35.11h",    0x020000, 0xdaee72fe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_31.12f",    0x020000, 0x0eb48a83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlu_36.12h",    0x020000, 0x36100209, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wlm-32.8h",     0x080000, 0xdfd9f643, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "wlm-7.7a",      0x080000, 0xafa74b73, BRF_GRA | CPS1_TILES },
	{ "wlm-5.9a",      0x080000, 0x12a0dc0b, BRF_GRA | CPS1_TILES },
	{ "wlm-3.3a",      0x080000, 0xc6f2abce, BRF_GRA | CPS1_TILES },
	{ "wlm-1.5a",      0x080000, 0x4aa4c6d3, BRF_GRA | CPS1_TILES },
	{ "wl_24.7d",      0x020000, 0x6f0adee5, BRF_GRA | CPS1_TILES },
	{ "wl_14.7c",      0x020000, 0x9cf3027d, BRF_GRA | CPS1_TILES },
	{ "wl_26.9d",      0x020000, 0xf09c8ecf, BRF_GRA | CPS1_TILES },
	{ "wl_16.9c",      0x020000, 0xe35407aa, BRF_GRA | CPS1_TILES },
	{ "wl_20.3d",      0x020000, 0x84992350, BRF_GRA | CPS1_TILES },
	{ "wl_10.3c",      0x020000, 0xb87b5a36, BRF_GRA | CPS1_TILES },
	{ "wl_22.5d",      0x020000, 0xfd3f89f0, BRF_GRA | CPS1_TILES },
	{ "wl_12.5c",      0x020000, 0x7da49d69, BRF_GRA | CPS1_TILES },

	{ "wl_09.12b",     0x010000, 0xf6b3d060, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "wl_18.11c",     0x020000, 0xbde23d4d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "wl_19.12c",     0x020000, 0x683898f5, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "wl24b.1a",      0x000117, 0x7101cdf1, BRF_OPT },	// b-board PLDs
	{ "lwio.11e",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Willowuo)
STD_ROM_FN(Willowuo)

static struct BurnRomInfo WillowjRomDesc[] = {
	// Japan "warning" but (c) Capcom U.S.A.
	{ "wl_36.12f",     0x020000, 0x2b0d7cbc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_42.12h",     0x020000, 0x1ac39615, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_37.13f",     0x020000, 0x30a717fa, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_43.13h",     0x020000, 0xd0dddc9e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_34.10f",     0x020000, 0x23a84f7a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_40.10h",     0x020000, 0xc7a0ed21, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_35.11f",     0x020000, 0x5eff7951, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "wl_41.11h",     0x020000, 0x8d6477a3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "wl_09.4b",      0x020000, 0x05aa71b4, BRF_GRA | CPS1_TILES },
	{ "wl_01.4a",      0x020000, 0x08c2df12, BRF_GRA | CPS1_TILES },
	{ "wl_13.9b",      0x020000, 0x1f7c87cd, BRF_GRA | CPS1_TILES },
	{ "wl_05.9a",      0x020000, 0xf5254bf2, BRF_GRA | CPS1_TILES },
	{ "wl_24.5e",      0x020000, 0xd9d73ba1, BRF_GRA | CPS1_TILES },
	{ "wl_17.5c",      0x020000, 0xa652f30c, BRF_GRA | CPS1_TILES },
	{ "wl_38.8h",      0x020000, 0xf6f9111b, BRF_GRA | CPS1_TILES },
	{ "wl_32.8f",      0x020000, 0x10f64027, BRF_GRA | CPS1_TILES },
	{ "wl_10.5b",      0x020000, 0xdbba0a3f, BRF_GRA | CPS1_TILES },
	{ "wl_02.5a",      0x020000, 0x86fba7a5, BRF_GRA | CPS1_TILES },
	{ "wl_14.10b",     0x020000, 0x7d5798b2, BRF_GRA | CPS1_TILES },
	{ "wl_06.10a",     0x020000, 0x1f052948, BRF_GRA | CPS1_TILES },
	{ "wl_25.7e",      0x020000, 0x857d17d2, BRF_GRA | CPS1_TILES },
	{ "wl_18.7c",      0x020000, 0x316c7fbc, BRF_GRA | CPS1_TILES },
	{ "wl_39.9h",      0x020000, 0xe6fce9b0, BRF_GRA | CPS1_TILES },
	{ "wl_33.9f",      0x020000, 0xa15d5517, BRF_GRA | CPS1_TILES },
		
	{ "wl_11.7b",      0x020000, 0x6f0adee5, BRF_GRA | CPS1_TILES },
	{ "wl_03.7a",      0x020000, 0x9cf3027d, BRF_GRA | CPS1_TILES },
	{ "wl_15.11b",     0x020000, 0xf09c8ecf, BRF_GRA | CPS1_TILES },
	{ "wl_07.11a",     0x020000, 0xe35407aa, BRF_GRA | CPS1_TILES },
	{ "wl_26.8e",      0x020000, 0x84992350, BRF_GRA | CPS1_TILES },
	{ "wl_19.8c",      0x020000, 0xb87b5a36, BRF_GRA | CPS1_TILES },
	{ "wl_28.10e",     0x020000, 0xfd3f89f0, BRF_GRA | CPS1_TILES },
	{ "wl_21.10c",     0x020000, 0x7da49d69, BRF_GRA | CPS1_TILES },

	{ "wl_23.13c",     0x010000, 0xf6b3d060, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "wl_30.12e",     0x020000, 0xbde23d4d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "wl_31.13e",     0x020000, 0x683898f5, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "wl22b.1a",      0x000117, 0x950cfa39, BRF_OPT },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Willowj)
STD_ROM_FN(Willowj)

static struct BurnRomInfo WofRomDesc[] = {
	{ "tk2e_23c.8f",   0x080000, 0x0d708505, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2e_22c.7f",   0x080000, 0x608c17e3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2-1m.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2-3m.5a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2-2m.4a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2-4m.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2-5m.7a",     0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2-7m.9a",     0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2-6m.8a",     0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2-8m.10a",    0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wof)
STD_ROM_FN(Wof)

static struct BurnRomInfo Wofr1RomDesc[] = {
	{ "tk2e_23b.8f",   0x080000, 0x11fb2ed1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2e_22b.7f",   0x080000, 0x479b3f24, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2-1m.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2-3m.5a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2-2m.4a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2-4m.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2-5m.7a",     0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2-7m.9a",     0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2-6m.8a",     0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2-8m.10a",    0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wofr1)
STD_ROM_FN(Wofr1)

static struct BurnRomInfo WofuRomDesc[] = {
	{ "tk2u_23c.8f",   0x080000, 0x29b89c12, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2u_22c.7f",   0x080000, 0xf5af4774, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2-1m.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2-3m.5a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2-2m.4a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2-4m.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2-5m.7a",     0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2-7m.9a",     0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2-6m.8a",     0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2-8m.10a",    0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wofu)
STD_ROM_FN(Wofu)

static struct BurnRomInfo WofjRomDesc[] = {
	{ "tk2j_23c.8f",   0x080000, 0x9b215a68, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2j_22c.7f",   0x080000, 0xb74b09ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_01.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_02.4a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_03.5a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_04.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_05.7a",     0x080000, 0xe4a44d53, BRF_GRA | CPS1_TILES },
	{ "tk2_06.8a",     0x080000, 0x58066ba8, BRF_GRA | CPS1_TILES },
	{ "tk2_07.9a",     0x080000, 0xd706568e, BRF_GRA | CPS1_TILES },
	{ "tk2_08.10a",    0x080000, 0xd4a19a02, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wofj)
STD_ROM_FN(Wofj)

static struct BurnRomInfo WofaRomDesc[] = {
	{ "tk2a_23c.8f",   0x080000, 0x2e024628, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2a_22c.7f",   0x080000, 0x900ad4cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2-1m.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2-3m.5a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2-2m.4a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2-4m.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2-5m.7a",     0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2-7m.9a",     0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2-6m.8a",     0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2-8m.10a",    0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wofa)
STD_ROM_FN(Wofa)

static struct BurnRomInfo WofchRomDesc[] = {
	{ "tk2=ch=_23.8f", 0x080000, 0x4e0b8dee, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2=ch=_22.7f", 0x080000, 0xd0937a8d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2-1m.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2-3m.5a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2-2m.4a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2-4m.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2=ch=_05.7a", 0x080000, 0xe4a44d53, BRF_GRA | CPS1_TILES },
	{ "tk2=ch=_06.8a", 0x080000, 0x58066ba8, BRF_GRA | CPS1_TILES },
	{ "tk2=ch=_07.9a", 0x080000, 0xcc9006c9, BRF_GRA | CPS1_TILES }, // 1 byte different from wofj, pcb verified
	{ "tk2=ch=_08.10a",0x080000, 0xd4a19a02, BRF_GRA | CPS1_TILES },
	
	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT }, // a-board PLDs
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },
	{ "prg2",          0x000117, 0x4386879a, BRF_OPT },
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },
	{ "sou1",          0x000117, 0x84f4b2fe, BRF_OPT },
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wofch)
STD_ROM_FN(Wofch)

static struct BurnRomInfo WofchdxRomDesc[] = {
	{ "tk2(ch)dx_23.8f", 0x080000, 0xa1696ca4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2(ch)dx_22.7f", 0x080000, 0x00d388c0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2-1m.3a",     0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2-3m.5a",     0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2-2m.4a",     0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2-4m.6a",     0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2=ch=_05.7a", 0x080000, 0xe4a44d53, BRF_GRA | CPS1_TILES },
	{ "tk2=ch=_06.8a", 0x080000, 0x58066ba8, BRF_GRA | CPS1_TILES },
	{ "tk2=ch=_07.9a", 0x080000, 0xcc9006c9, BRF_GRA | CPS1_TILES }, // 1 byte different from wofj, pcb verified
	{ "tk2=ch=_08.10a",0x080000, 0xd4a19a02, BRF_GRA | CPS1_TILES },
	
	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT }, // a-board PLDs
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },
	{ "prg2",          0x000117, 0x4386879a, BRF_OPT },
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },
	{ "sou1",          0x000117, 0x84f4b2fe, BRF_OPT },
	
	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	
	{ "ioc1.ic7",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
	
	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },
};

STD_ROM_PICK(Wofchdx)
STD_ROM_FN(Wofchdx)

static struct BurnRomInfo WofhfhRomDesc[] = {
	{ "23",            0x080000, 0x6ae4b312, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "22",            0x080000, 0x94e8d01a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1",             0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "2",             0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "3",             0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "4",             0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "5",             0x080000, 0x34949d7b, BRF_GRA | CPS1_TILES },
	{ "6",             0x080000, 0xdfa70971, BRF_GRA | CPS1_TILES },
	{ "7",             0x080000, 0x073686a6, BRF_GRA | CPS1_TILES },
	{ "8",             0x080000, 0x5300f8db, BRF_GRA | CPS1_TILES },

	{ "9",             0x020000, 0x86fe8a97, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",            0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",            0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofhfh)
STD_ROM_FN(Wofhfh)

static struct BurnRomInfo WofhRomDesc[] = {
	{ "sgyx.800",       0x100000, 0x3703a650, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sgyx-1.160",     0x200000, 0xa60be9f6, BRF_GRA | CPS1_TILES },
	{ "sgyx-2.160",     0x200000, 0x6ad9d048, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from sgyxz
	{ "sgyxz_snd2.bin", 0x010000, 0x210c376f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sgyxz_snd1.bin", 0x040000, 0xc15ac0f2, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofh)
STD_ROM_FN(Wofh)

static struct BurnRomInfo WofhaRomDesc[] = {
	{ "fg-c.040",       0x080000, 0xd046fc86, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "fg-a.040",       0x080000, 0xf176ee8f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sgyx-1.160",     0x200000, 0xa60be9f6, BRF_GRA | CPS1_TILES },
	{ "sgyx-2.160",     0x200000, 0x6ad9d048, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from sgyxz
	{ "sgyxz_snd2.bin", 0x010000, 0x210c376f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sgyxz_snd1.bin", 0x040000, 0xc15ac0f2, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofha)
STD_ROM_FN(Wofha)

static struct BurnRomInfo SgyxzRomDesc[] = {
	{ "sgyxz_prg2.bin", 0x080000, 0x95429c83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "sgyxz_prg1.bin", 0x080000, 0xd8511929, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "sgyxz_gfx1.bin", 0x200000, 0xa60be9f6, BRF_GRA | CPS1_TILES },
	{ "sgyxz_gfx2.bin", 0x200000, 0x6ad9d048, BRF_GRA | CPS1_TILES },

	{ "sgyxz_snd2.bin", 0x010000, 0x210c376f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sgyxz_snd1.bin", 0x040000, 0xc15ac0f2, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sgyxz)
STD_ROM_FN(Sgyxz)

static struct BurnRomInfo Wof3jsRomDesc[] = {
	{ "3js_23.rom",    0x080000, 0x1ebb76da, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "3js_22.rom",    0x080000, 0xf41d6153, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP }, // First and second halves identical
	{ "3js_24.rom",    0x020000, 0x06ead409, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3js_28.rom",    0x020000, 0x8ba934e6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "3js_gfx5.rom",  0x080000, 0x94b58f82, BRF_GRA | CPS1_TILES },
	{ "3js_gfx7.rom",  0x080000, 0xdf4fb386, BRF_GRA | CPS1_TILES },
	{ "3js_gfx6.rom",  0x080000, 0xc22c5bd8, BRF_GRA | CPS1_TILES },
	{ "3js_gfx8.rom",  0x080000, 0xf9cfd08b, BRF_GRA | CPS1_TILES },

	{ "3js_09.rom",    0x010000, 0x21ce044c, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "3js_18.rom",    0x020000, 0xac6e307d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "3js_19.rom",    0x020000, 0x068741db, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wof3js)
STD_ROM_FN(Wof3js)

static struct BurnRomInfo Wof3jsaRomDesc[] = {
	{ "cx2.040",       0x080000, 0xc01a6d2f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "cx1.040",       0x080000, 0xfd95e677, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "tx-a.160",      0x200000, 0xae348da2, BRF_GRA | CPS1_TILES },
	{ "tx-b.160",      0x200000, 0x384a6db0, BRF_GRA | CPS1_TILES },

	// These sound roms are taken from wofhfh, this set looks it uses psound
	{ "9",             0x020000, 0x86fe8a97, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",            0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",            0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wof3jsa)
STD_ROM_FN(Wof3jsa)

static struct BurnRomInfo Wof3sjRomDesc[] = {
	{ "k6b.040",       0x080000, 0x7b365108, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "k6a.040",       0x080000, 0x10488a51, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "k6a.160",       0x200000, 0xa121180d, BRF_GRA | CPS1_TILES },
	{ "k6b.160",       0x200000, 0xa4db96c4, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from wofhfh, this set looks it uses psound
	{ "9",             0x020000, 0x86fe8a97, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",            0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",            0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wof3sj)
STD_ROM_FN(Wof3sj)

static struct BurnRomInfo Wof3sjaRomDesc[] = {
	{ "3js.800",       0x100000, 0x812f9200, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "k6a.160",       0x200000, 0xa121180d, BRF_GRA | CPS1_TILES },
	{ "k6b.160",       0x200000, 0xa4db96c4, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from wofhfh, this set looks it uses psound
	{ "9",             0x020000, 0x86fe8a97, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",            0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",            0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wof3sja)
STD_ROM_FN(Wof3sja)

static struct BurnRomInfo WofsjRomDesc[] = {
	{ "c-c47b.040",    0x080000, 0xb1809761, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "a-2402.040",    0x080000, 0x4fab4232, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5.rom",  0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7.rom",  0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6.rom",  0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8.rom",  0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from wofhfh, this set looks it uses psound
	{ "9",             0x020000, 0x86fe8a97, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",            0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",            0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofsj)
STD_ROM_FN(Wofsj)

static struct BurnRomInfo WofsjaRomDesc[] = {
	{ "one.800",       0x100000, 0x0507584d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5.rom",  0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7.rom",  0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6.rom",  0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8.rom",  0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from wofhfh, this set looks it uses psound
	{ "9",             0x020000, 0x86fe8a97, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18",            0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19",            0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofsja)
STD_ROM_FN(Wofsja)

static struct BurnRomInfo WofsjbRomDesc[] = {
	{ "c-d140.040",    0x080000, 0xe6d933a6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "a-0050.040",    0x080000, 0x403eaead, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5.rom",  0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7.rom",  0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6.rom",  0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8.rom",  0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },

	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs

	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },

	// using the sound roms from wofhfh or wof3js doesn't give the right result
	// it doesn't use Q-Sound either
};

STD_ROM_PICK(Wofsjb)
STD_ROM_FN(Wofsjb)

static struct BurnRomInfo WofsjcRomDesc[] = {
	{ "2223.bin",      0x100000, 0xcb28807e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.bin",         0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "2.bin",         0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "3.bin",         0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "4.bin",         0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "5.bin",         0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "6.bin",         0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "7.bin",         0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "8.bin",         0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },
	
	{ "9.bin",         0x010000, 0x210c376f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.bin",        0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.bin",        0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofsjc)
STD_ROM_FN(Wofsjc)

static struct BurnRomInfo Wofr1blRomDesc[] = {
	{ "3-f2ab.040",    0x080000, 0x61fd0a01, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1-9207.040",    0x080000, 0x7f59e24c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4-d4d2.010",    0x020000, 0xfe5eee87, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2-6c41.010",    0x020000, 0x739379be, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	{ "5-caf3.040",    0x080000, 0xc8dcaa95, BRF_GRA | CPS1_TILES },
	{ "6-034f.040",    0x080000, 0x1ab0000c, BRF_GRA | CPS1_TILES },
	{ "7-b0fa.040",    0x080000, 0x8425ff6b, BRF_GRA | CPS1_TILES },
	{ "8-a6b7.040",    0x080000, 0x24ce197b, BRF_GRA | CPS1_TILES },
	{ "9-8a2c.040",    0x080000, 0x9d20ef9b, BRF_GRA | CPS1_TILES },
	{ "10-7d24.040",   0x080000, 0x90c93dd2, BRF_GRA | CPS1_TILES },
	{ "11-4171.040",   0x080000, 0x219fd7e2, BRF_GRA | CPS1_TILES },
	{ "12-f56b.040",   0x080000, 0xefc17c9a, BRF_GRA | CPS1_TILES },
	
	// These sound roms are taken from wof3js, this set looks it uses psound
	{ "3js_09.rom",    0x010000, 0x21ce044c, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "3js_18.rom",    0x020000, 0xac6e307d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "3js_19.rom",    0x020000, 0x068741db, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofr1bl)
STD_ROM_FN(Wofr1bl)

static struct BurnRomInfo WofpicRomDesc[] = {
	{ "2.4m",   	   0x080000, 0x61fd0a01, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "1.4m",    	   0x080000, 0xd2ae67a8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.1m",    	   0x020000, 0xfe5eee87, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.1m",    	   0x020000, 0x739379be, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	

	{ "m12073-2",      0x080000, 0xc8dcaa95, BRF_GRA | CPS1_TILES },
	{ "m12223-2",      0x080000, 0x1ab0000c, BRF_GRA | CPS1_TILES },
	{ "m12223-1",      0x080000, 0x8425ff6b, BRF_GRA | CPS1_TILES },
	{ "m12073-1",      0x080000, 0x24ce197b, BRF_GRA | CPS1_TILES },
	{ "m12073-6",      0x080000, 0x9d20ef9b, BRF_GRA | CPS1_TILES },
	{ "m12073-5",      0x080000, 0x90c93dd2, BRF_GRA | CPS1_TILES },
	{ "m12073-4",      0x080000, 0x219fd7e2, BRF_GRA | CPS1_TILES },
	{ "m12073-3",      0x080000, 0xefc17c9a, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.5k",     0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2-q1.1k",     0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q2.2k",     0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q3.3k",     0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2-q4.4k",     0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },

	A_BOARD_QSOUND_PLDS

	{ "tk263b.1a",     0x000117, 0xc4b0349b, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },

	{ "ioc1.ic1",      0x000104, 0xa399772d, BRF_OPT },	// c-board PLDs

	{ "d7l1.7l",       0x000117, 0x27b7410d, BRF_OPT },	// d-board PLDs
	{ "d8l1.8l",       0x000117, 0x539fc7da, BRF_OPT },
	{ "d9k1.9k",       0x000117, 0x6c35c805, BRF_OPT },
	{ "d10f1.10f",     0x000117, 0x6619c494, BRF_OPT },

	{ "pic.bin",   	   0x001007, 0x00000000, BRF_PRG | CPS1_PIC | BRF_NODUMP},
	
	{ "ma12073.4mm",   0x080000, 0xac421276, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofpic)
STD_ROM_FN(Wofpic)

static struct BurnRomInfo WofjhRomDesc[] = {
	{ "tk2j23h.bin",   0x080000, 0x84d38575, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2j22c.bin",   0x080000, 0xb74b09ac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk205.bin",     0x080000, 0xe4a44d53, BRF_GRA | CPS1_TILES },
	{ "tk206.bin",     0x080000, 0x58066ba8, BRF_GRA | CPS1_TILES },
	{ "tk207.bin",     0x080000, 0xd706568e, BRF_GRA | CPS1_TILES },
	{ "tk208.bin",     0x080000, 0xd4a19a02, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.rom",    0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2_q1.rom",    0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q2.rom",    0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q3.rom",    0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q4.rom",    0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Wofjh)
STD_ROM_FN(Wofjh)

static struct BurnRomInfo WofablRomDesc[] = {
	{ "5.prg.040",     0x080000, 0x4d9d2327, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.prg.040",     0x080000, 0xef25fe49, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "6.prg.010",     0x020000, 0x93eeb161, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "4.prg.010",     0x020000, 0xa0751944, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "gfx13.040",     0x080000, 0x8e8db215, BRF_GRA | CPS1_TILES },
	{ "gfx14.040",     0x080000, 0xf34a7f9d, BRF_GRA | CPS1_TILES },
	{ "gfx15.040",     0x080000, 0xa5e4f449, BRF_GRA | CPS1_TILES },
	{ "gfx16.040",     0x080000, 0x49a3dfc7, BRF_GRA | CPS1_TILES },
	{ "gfx9.040",      0x080000, 0xf8f33a0e, BRF_GRA | CPS1_TILES },
	{ "gfx10.040",     0x080000, 0x6a060c6c, BRF_GRA | CPS1_TILES },
	{ "gfx11.040",     0x080000, 0x13324965, BRF_GRA | CPS1_TILES },
	{ "gfx12.040",     0x080000, 0xc29f7b70, BRF_GRA | CPS1_TILES },

	{ "sound.512",     0x010000, 0x210c376f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "sound.020",     0x040000, 0x672dcb46, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofabl)
STD_ROM_FN(Wofabl)

static struct BurnRomInfo WofablaRomDesc[] = {
	{ "2233.bin",	0x100000, 0xcb28807e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "1.bin",		0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "2.bin",		0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "3.bin",		0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "4.bin",		0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "5.bin",		0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "6.bin",		0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "7.bin",		0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "8.bin",		0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "9.bin",		0x010000, 0x210c376f, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "18.bin",		0x020000, 0xc04be720, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "19.bin",		0x020000, 0xfbb8d8c1, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Wofabla)
STD_ROM_FN(Wofabla)

static struct BurnRomInfo WofahRomDesc[] = {
	{ "htk2a_23b.rom", 0x080000, 0x1b17fc85, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2a_22b.rom",  0x080000, 0x900ad4cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5.rom",  0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7.rom",  0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6.rom",  0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8.rom",  0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.rom",    0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2_q1.rom",    0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q2.rom",    0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q3.rom",    0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q4.rom",    0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Wofah)
STD_ROM_FN(Wofah)

static struct BurnRomInfo WofahaRomDesc[] = {
	{ "htk2ah_23b.rom",0x080000, 0x6e3ff382, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	// Taken from wofah, possibly not correct, although does match original Asia set as well
	{ "tk2a_22b.rom",  0x080000, 0x900ad4cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5.rom",  0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7.rom",  0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6.rom",  0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8.rom",  0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.rom",    0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2_q1.rom",    0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q2.rom",    0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q3.rom",    0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q4.rom",    0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Wofaha)
STD_ROM_FN(Wofaha)

static struct BurnRomInfo WofahbRomDesc[] = {
	{ "tk2ah_23b.rom", 0x080000, 0x48fd83c6, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	// Taken from wofah, possibly not correct, although does match original Asia set as well
	{ "tk2a_22b.rom",  0x080000, 0x900ad4cd, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5.rom",  0x080000, 0x291f0f0b, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7.rom",  0x080000, 0x3edeb949, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6.rom",  0x080000, 0x1abd14d6, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8.rom",  0x080000, 0xb27948e3, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.rom",    0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2_q1.rom",    0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q2.rom",    0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q3.rom",    0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q4.rom",    0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Wofahb)
STD_ROM_FN(Wofahb)

static struct BurnRomInfo Cps1frogRomDesc[] = {
	{ "frog30-36.bin", 0x020000, 0x8eb8ddbe, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "frog35-42.bin", 0x020000, 0xacb5a988, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "frog31-37.bin", 0x020000, 0x154803cc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "frog36-43.bin", 0x020000, 0x154803cc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "frog32-32m.bin",0x080000, 0x75660aac, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "frog05-05m.bin",0x080000, 0x7bbc4b54, BRF_GRA | CPS1_TILES },
	{ "frog07-07m.bin",0x080000, 0x0beadd80, BRF_GRA | CPS1_TILES },
	{ "frog01-01m.bin",0x080000, 0xf84d02bb, BRF_GRA | CPS1_TILES },
	{ "frog03-03m.bin",0x080000, 0xd784a5b0, BRF_GRA | CPS1_TILES },

	{ "frog09-09.bin", 0x010000, 0x3ac7fb5c, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "frog18-18.bin", 0x020000, 0x65d1ef07, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "frog19-19.bin", 0x020000, 0x7ee8cdcd, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Cps1frog)
STD_ROM_FN(Cps1frog)

// Game config

typedef void (*KabukiDecode)();
static KabukiDecode KabukiDecodeFunction;

static INT32 GameHasStars = 0;

void wof_patch(void) {
	if (Cps1QSDip & 1)
		wof_decode();
}
void dino_patch(void) {
	if (Cps1QSDip & 1)
		dino_decode();
}
void punisher_patch(void) {
	if (Cps1QSDip & 1)
		punisher_decode();
}
void slammast_patch(void) {
	if (Cps1QSDip & 1)
		slammast_decode();
}

struct GameConfig {
	const char *DriverName;
	INT32 CpsBId;
	INT32 CpsMapperId;
	INT32 CpsStars;
	KabukiDecode DecodeFunction;
};

static const struct GameConfig ConfigTable[] =
{
	{ "1941"          , CPS_B_05    , mapper_YI24B , 0, NULL                },
	{ "1941r1"        , CPS_B_05    , mapper_YI24B , 0, NULL                },
	{ "1941u"         , CPS_B_05    , mapper_YI24B , 0, NULL                },
	{ "1941j"         , CPS_B_05    , mapper_YI24B , 0, NULL                },
	{ "3wonders"      , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "3wondersr1"    , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "3wondersu"     , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "wonder3"       , CPS_B_21_BT1, mapper_RT22B , 0, NULL                },
	{ "3wondersh"     , CPS_B_02    , mapper_RT24B , 0, NULL                },
	{ "3wondersha"    , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "3wondersb"     , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "captcomm"      , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommr1"    , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommu"     , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommj"     , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommjr1"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommb"     , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommb2"    , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommb3"    , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommp4"    , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommpwx"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcomm2y"    , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommpjy"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommpmy"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommc"     , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captre"        , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "cawing"        , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingr1"      , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingu"       , CPS_B_05    , mapper_CA22B , 0, NULL                },
	{ "cawingur1"     , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingj"       , CPS_B_16    , mapper_CA22B , 0, NULL                },
	{ "cawingbl"      , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingb2"      , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cworld2j"      , CPS_B_21_BT6, mapper_Q522B , 0, NULL                },
	{ "cworld2ja"     , CPS_B_21_DEF, mapper_Q522B , 0, NULL                }, // patched set, no battery, could be desuicided
	{ "cworld2jb"     , CPS_B_21_BT6, mapper_Q522B , 0, NULL                }, // actually Q563B
	{ "dino"          , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinoa"         , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinou"         , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinoj"         , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinopic"       , CPS_B_21_QS2, mapper_CD63B , 0, dino_patch          },
	{ "dinopic2"      , CPS_B_21_QS2, mapper_CD63B , 0, dino_patch          },
	{ "dinopic3"      , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinopic4"      , CPS_B_21_QS2, mapper_CD63B , 0, dino_patch          },
	{ "dinopic5"      , CPS_B_21_QS2, mapper_CD63B , 0, NULL                },
	{ "jurassic99"    , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinoeh"        , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinoh"         , CPS_B_21_DEF, mapper_CD63B , 0, dino_decode         },
	{ "dinohc"        , CPS_B_21_DEF, mapper_CD63B , 0, dino_decode         }, // hacked to run on Street Fighter II' Champion Edition C-Board
	{ "dinot"         , CPS_B_21_DEF, mapper_CD63B , 0, dino_decode         },
	{ "dinotpic"      , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinohunt"      , CPS_B_21_DEF, mapper_CD63B , 0, NULL                },
	{ "dinods"        , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinosyn"       , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinogae"       , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinotj"        , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinotw"        , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinore"        , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dynwar"        , CPS_B_02    , mapper_TK22B , 0, NULL                },
	{ "dynwara"       , CPS_B_02    , mapper_TK22B , 0, NULL                },
	{ "dynwarj"       , CPS_B_02    , mapper_TK22B , 0, NULL                },
	{ "dynwarjr"      , CPS_B_21_DEF, mapper_TK22B , 0, NULL                },
	{ "ffight"        , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightae"      , CPS_B_21_DEF, mapper_S224B , 0, NULL                },
	{ "ffightaemgc"   , CPS_B_21_DEF, mapper_S224B , 0, NULL                },
	{ "ffighta"       , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightu"       , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightu1"      , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightu2"      , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightua"      , CPS_B_01    , mapper_S224B , 0, NULL                },
	{ "ffightub"      , CPS_B_03    , mapper_S224B , 0, NULL                }, // 04 handwritten on CPS-B chip
	{ "ffightuc"      , CPS_B_05    , mapper_S224B , 0, NULL                }, 
	{ "ffightj"       , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightj1"      , CPS_B_01    , mapper_S224B , 0, NULL                },
	{ "ffightj2"      , CPS_B_02    , mapper_S224B , 0, NULL                },
	{ "ffightj3"      , CPS_B_03    , mapper_S224B , 0, NULL                },
	{ "ffightj4"      , CPS_B_05    , mapper_S224B , 0, NULL                },
	{ "ffightjh"      , CPS_B_01    , mapper_S224B , 0, NULL                },
	{ "ffightbl"      , HACK_B_5    , mapper_S224B , 0, NULL                },
	{ "ffightbla"     , HACK_B_5    , mapper_S224B , 0, NULL                },
	{ "fcrash"        , HACK_B_5    , mapper_S224B , 0, NULL                }, // doesn't really have an ID, but this used to give the relevant values to our rendering functions
	{ "forgottn"      , CPS_B_01    , mapper_LW621 , 1, NULL                },
	{ "forgottna"     , CPS_B_01    , mapper_LW621 , 1, NULL                },
	{ "forgottnu"     , CPS_B_01    , mapper_LW621 , 1, NULL                },
	{ "forgottnua"    , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "forgottnuaa"   , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "forgottnuc"    , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "forgottnue"    , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "forgottnj"     , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "lostwrld"      , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "lostwrldo"     , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "ganbare"       , CPS_B_21_DEF, mapper_sfzch , 0, NULL                },
	{ "ghouls"        , CPS_B_01    , mapper_DM620 , 0, NULL                },
	{ "ghoulsu"       , CPS_B_01    , mapper_DM620 , 0, NULL                },
	{ "daimakai"      , CPS_B_01    , mapper_DM22A , 0, NULL                },
	{ "daimakair"     , CPS_B_21_DEF, mapper_DAM63B, 0, NULL                },
	{ "daimakaib"     , CPS_B_21_DEF, mapper_DAM63B, 0, NULL                }, // game controls layers at 0x98000c
	{ "mpumpkin"      , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },
	{ "knights"       , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsu"      , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsj"      , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsja"     , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsb"      , CPS_B_21_BT4, mapper_KR63B , 0, NULL                }, // game controls layers (and priorities?) at 0x98000c
	{ "knightsb2"     , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsb3"     , CPS_B_21_BT4, mapper_KR63B , 0, NULL                }, // game controls layers (and priorities?) at 0x98000c
	{ "knightsb4"     , CPS_B_21_BT4, mapper_KR63B , 0, NULL                }, // game controls layers (and priorities?) at 0x98000c
	{ "knightsb5"     , CPS_B_21_DEF, mapper_KR63B , 0, NULL                },
	{ "knightsh"      , CPS_B_21_DEF, mapper_KR63B , 0, NULL                },
	{ "knightsh2"     , CPS_B_21_DEF, mapper_KR63B , 0, NULL                },
	{ "knightsc"      , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "kod"           , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodr1"         , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodr2"         , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodu"          , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodj"          , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodja"         , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodb"          , CPS_B_21_BT2, mapper_KD29B , 0, NULL                }, // game writes priority masks 1&2 at 0x980020-22 range, 0&3 assumed hard-coded at boot
	{ "kodh"          , CPS_B_21_DEF, mapper_KD29B , 0, NULL                },
	{ "kodda"         , CPS_B_21_DEF, mapper_KD29B , 0, NULL                },
	{ "megaman"       , CPS_B_21_DEF, mapper_RCM63B, 0, NULL                },
	{ "megamana"      , CPS_B_21_DEF, mapper_RCM63B, 0, NULL                },
	{ "rockmanj"      , CPS_B_21_DEF, mapper_RCM63B, 0, NULL                },
	{ "mercs"         , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsu"        , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsur1"      , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsj"        , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsc"        , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "msword"        , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mswordr1"      , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mswordu"       , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mswordj"       , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mtwins"        , CPS_B_14    , mapper_CK24B , 0, NULL                },
	{ "chikij"        , CPS_B_14    , mapper_CK24B , 0, NULL                },
	{ "mtwinsb"       , CPS_B_14    , mapper_CK24B , 0, NULL                },
	{ "nemo"          , CPS_B_15    , mapper_NM24B , 0, NULL                },
	{ "nemor1"        , CPS_B_15    , mapper_NM24B , 0, NULL                },
	{ "nemoj"         , CPS_B_15    , mapper_NM24B , 0, NULL                },
	{ "pang3"         , CPS_B_21_DEF, mapper_CP1B1F, 0, NULL                },
	{ "pang3r1"       , CPS_B_21_DEF, mapper_CP1B1F, 0, NULL                },
	{ "pang3r1a"      , CPS_B_21_DEF, mapper_CP1B1F, 0, NULL                },
	{ "pang3b"        , CPS_B_21_DEF, mapper_CP1B1F, 0, NULL                },
	{ "pang3b2"       , CPS_B_21_DEF, mapper_CP1B1F, 0, NULL                },
	{ "pang3b3"       , CPS_B_17	, mapper_CP1B1F, 0, NULL                },
	{ "pang3b4"       , CPS_B_21_DEF, mapper_pang3b4, 0, NULL               },
	{ "pang3b5"       , CPS_B_21_DEF, mapper_CP1B1F_boot, 0, NULL           },
	{ "pang3b6"       , CPS_B_04    , mapper_CP1B1F, 0, NULL                }, // hacked to run on Final Fight C-Board
	{ "pang3b7"       , CPS_B_04    , mapper_CP1B1F, 0, NULL                }, // hacked to run on Final Fight C-Board
	{ "pang3j"        , CPS_B_21_DEF, mapper_CP1B1F, 0, NULL                },
	{ "pnickj"        , CPS_B_21_DEF, mapper_PKB10B, 0, NULL                },
	{ "pokonyan"      , CPS_B_21_DEF, mapper_pokon , 0, NULL                },
	{ "gulunpa"       , CPS_B_21_DEF, mapper_gulun , 0, NULL                },
	{ "punisher"      , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punisheru"     , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punisherj"     , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punisherh"     , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punipic"       , CPS_B_21_QS3, mapper_PS63B , 0, punisher_patch      }, // game controls layers at 0x98000c
	{ "punipic2"      , CPS_B_21_QS3, mapper_PS63B , 0, punisher_patch      }, // game controls layers at 0x98000c
	{ "punipic3"      , CPS_B_21_QS3, mapper_PS63B , 0, punisher_patch      }, // game controls layers at 0x98000c
	{ "punisherbz"    , CPS_B_21_DEF, mapper_PS63B , 0, NULL                },
	{ "punisherb"     , CPS_B_21_QS3, mapper_PS63B , 0, NULL                },
	{ "punisherly"    , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punisherhr"    , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "qad"           , CPS_B_21_BT7, mapper_QD22B , 0, NULL                },
	{ "qadjr"         , CPS_B_21_DEF, mapper_QD63B , 0, NULL                },
	{ "qtono2j"       , CPS_B_21_DEF, mapper_TN2292, 0, NULL                },
	{ "sf2"           , CPS_B_11    , mapper_STF29 , 0, NULL                },
	{ "sf2ea"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2eb"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ed"         , CPS_B_05    , mapper_STF29 , 0, NULL                },
	{ "sf2ee"         , CPS_B_18    , mapper_STF29 , 0, NULL                },
	{ "sf2ef"         , CPS_B_15    , mapper_STF29 , 0, NULL                },
	{ "sf2em"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2en"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ebbl"       , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ebbl2"      , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ebbl3"      , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2stt"        , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ly"         , CPS_B_11    , mapper_STF29 , 0, NULL                },
	{ "sf2ua"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ub"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2uc"         , CPS_B_12    , mapper_STF29 , 0, NULL                },
	{ "sf2ud"         , CPS_B_05    , mapper_STF29 , 0, NULL                },
	{ "sf2ue"         , CPS_B_18    , mapper_STF29 , 0, NULL                },
	{ "sf2uf"         , CPS_B_15    , mapper_STF29 , 0, NULL                },
	{ "sf2ug"         , CPS_B_11    , mapper_STF29 , 0, NULL                },
	{ "sf2uh"         , CPS_B_13    , mapper_STF29 , 0, NULL                },
	{ "sf2ui"         , CPS_B_14    , mapper_STF29 , 0, NULL                },
	{ "sf2uk"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2um"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2j"          , CPS_B_13    , mapper_STF29 , 0, NULL                },
	{ "sf2j17"        , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ja"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2jc"         , CPS_B_12    , mapper_STF29 , 0, NULL                },
	{ "sf2jf"         , CPS_B_15    , mapper_STF29 , 0, NULL                },
	{ "sf2jh"         , CPS_B_13    , mapper_STF29 , 0, NULL                },
	{ "sf2jl"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2jla"        , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2qp1"        , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2qp2"        , CPS_B_14    , mapper_STF29 , 0, NULL                },
	{ "sf2thndr"      , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2thndr2"     , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2b"          , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2b2"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2b3"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2b4"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2rk"         , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2rk2"        , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2rules"      , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2bhh"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ce"         , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceea"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceec"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceua"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceub"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceuc"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2cet"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceja"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2cejb"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2cejc"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2mix"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb"         , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb2"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb3"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb4"        , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2rb5"        , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2rb6"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2red"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2reda"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2redp2"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2red2"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2v004"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2v0042"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2v0043"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2dongb"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2acc"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2acca"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2accp2"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2dkot2"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2md"         , CPS_B_21_DEF, mapper_S9263B, 0, NULL                }, // game controls layers at 0x98000c
	{ "sf2mdt"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2mdta"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2mdtb"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2mdtc"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceb"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceb2"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceb3"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceb4"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceb5"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2tlona"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2tlonb"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2tlonc"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2yyc"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2yyc2"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2koryu"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2koryu2"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2koryu3"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf2"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf3"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf4"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf5"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf6"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf7"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf8"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf9"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2amf10"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2mega"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2mega2"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceeabl"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                }, // game controls layers at 0x98000c
	{ "sf2ceeab2"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                }, // game controls layers at 0x98000c
	{ "sf2cejabl"     , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2cejab2"     , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2ceupl"      , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuabl"     , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab2"     , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab3"     , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab4"     , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2re"   	  , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2mkot"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceuab5"     , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab6"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceuab7"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceuab8"     , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab9"     , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab10"    , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2ceuab11"    , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2ceucbl"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2level"      , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2cebltw"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2sl73a"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hf"         , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hfu"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hfj"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hfub"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hfjb"       , HACK_B_4    , mapper_S9263B, 0, NULL                },
	{ "sf2hfjb2"      , HACK_B_4    , mapper_S9263B, 0, NULL                },
	{ "slammast"      , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },
	{ "slammastu"     , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },
	{ "mbomberj"      , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },
	{ "mbombrd"       , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },
	{ "mbombrdj"      , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },
	{ "slampic"       , CPS_B_21_QS4, mapper_MB63B , 0, slammast_patch		},
	{ "slampic2"      , CPS_B_21_QS4, mapper_MB63B , 0, NULL                },
	{ "strider"       , CPS_B_01    , mapper_ST24M1, 1, NULL                },
	{ "striderua"     , CPS_B_01    , mapper_ST24M1, 1, NULL                },
	{ "strideruc"     , CPS_B_17    , mapper_ST24M1, 1, NULL                },
	{ "striderjr"     , CPS_B_21_DEF, mapper_ST24M1, 1, NULL                },
	{ "striderj"      , CPS_B_01    , mapper_ST22B , 1, NULL                },
	{ "striderfix"    , CPS_B_01    , mapper_ST24M1, 1, NULL                },
	{ "unsquad"       , CPS_B_11    , mapper_AR24B , 0, NULL                },
	{ "area88"        , CPS_B_11    , mapper_AR22B , 0, NULL                },
	{ "area88r"       , CPS_B_21_DEF, mapper_AR22B , 0, NULL                },
	{ "varth"         , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "varthr1"       , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "varthu"        , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "varthj"        , CPS_B_21_BT5, mapper_VA22B , 0, NULL                },
	{ "varthjr"       , CPS_B_21_BT5, mapper_VA63B , 0, NULL                }, // CPSB test has been patched out (72=0001) register is also written to, possibly leftover from development */   
	{ "varthb"        , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "willow"        , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "willowu"       , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "willowuo"      , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "willowj"       , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "wof"           , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofr1"         , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofu"          , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofj"          , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofa"          , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofhfh"        , CPS_B_21_DEF, mapper_TK263B, 0, NULL                },
	{ "wofh"          , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofha"         , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "sgyxz"         , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wof3js"        , CPS_B_21_DEF, mapper_TK263B, 0, NULL                },
	{ "wof3jsa"       , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wof3sj"        , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wof3sja"       , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofsj"         , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofsja"        , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofsjb"        , CPS_B_21_DEF, mapper_TK263B, 0, wof_patch			},
	{ "wofsjc"        , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofr1bl"       , CPS_B_21_DEF, mapper_TK263B, 0, NULL                }, // game controls layers at 0x98000c
	{ "wofpic"        , CPS_B_21_DEF, mapper_TK263B, 0, wof_patch			}, // game controls layers at 0x98000c
	{ "wofjh"         , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofabl"        , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofabla"       , HACK_B_6    , mapper_TK263B, 0, NULL                },
	{ "wofah"         , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofaha"        , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofahb"        , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "sfzch"         , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },
	{ "sfzcha"        , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },
	{ "wofch"         , CPS_B_21_DEF, mapper_sfzch , 0, wof_decode          },
	{ "wofchp"        , CPS_B_21_DEF, mapper_sfzch , 0, wof_decode          },
	{ "wofchdx"       , CPS_B_21_DEF, mapper_sfzch , 0, wof_decode          },
	{ "wofjdr"        , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofdr2020"     , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofac"         , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "cps1demo"      , CPS_B_04    , mapper_sfzch , 0, NULL                },
	{ "cps1frog"      , CPS_B_04    , mapper_frog  , 0, NULL                },
	{ "kenseim"       , CPS_B_21_DEF, mapper_KNM10B, 0, NULL                },
	
	// Not included games
	{ "pnicku"        , CPS_B_21_DEF, mapper_PKB10B, 0, NULL                },	// IPS
	{ "sf2cebr"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },	// IPS
	{ "sf2ceh"        , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },	// IPS
	{ "slammasa"      , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "slammash"      , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombdje"      , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombrda"      , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombrdh"      , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombrdu"      , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "woffr"         , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },	// IPS
	
	// CPS Changer Region Hacks (not included)
	{ "sfach"         , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                }, // SFZ63B found on mpumpkin, assumed to be from SFZ
	{ "sfabch"        , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },
	{ "sfzbch"        , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },
	{ "sfzech"        , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },
	{ "sfzhch"        , CPS_B_21_DEF, mapper_SFZ63B, 0, NULL                },

	{ 0               , 0           , 0            , 0, 0                   }
};

static void SetGameConfig()
{
	const char *GameName = BurnDrvGetTextA(DRV_NAME);
	const struct GameConfig *k = &ConfigTable[0];

	while (k->DriverName) {
		if (strcmp(k->DriverName, GameName) == 0) {
			break;
		}
		++k;
	}

	if (k->DriverName) {
		GameHasStars = k->CpsStars;
		SetCpsBId(k->CpsBId, GameHasStars);
		SetGfxMapper(k->CpsMapperId);
		KabukiDecodeFunction = k->DecodeFunction;
	} else {
#if 1 && defined FBNEO_DEBUG
		bprintf(PRINT_IMPORTANT, _T("Missing Config Data\n"));
#endif
	}
}

// Driver functions

static UINT32 nCps68KByteswapRomNum = 0;
static UINT32 nCps68KNoByteswapRomNum = 0;
static UINT32 nCpsZ80RomNum = 0;
static UINT32 nCpsTilesRomNum = 0;
static UINT32 nCpsOkim6295RomNum = 0;
static UINT32 nCpsQsoundRomNum = 0;
static UINT32 nCpsPicRomNum = 0;
static UINT32 nCpsExtraTilesRomNum = 0;
static UINT32 nCpsExtraGfxLen = 0;

static INT32 Cps1LoadRoms(INT32 bLoad)
{
	struct BurnRomInfo ri;
	ri.nType = 0;
	ri.nLen = 0;
	INT32 nOffset = -1;
	UINT32 i = 0;
	INT32 nRet = 0;

	if (!bLoad) {
		do {
			ri.nLen = 0;
			ri.nType = 0;
			BurnDrvGetRomInfo(&ri, ++nOffset);
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_BYTESWAP) {
				nCpsRomLen += ri.nLen;
				nCps68KByteswapRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_NO_BYTESWAP) {
				nCpsRomLen += ri.nLen;
				nCps68KNoByteswapRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_Z80_PROGRAM) {
				nCpsZRomLen += ri.nLen;
				nCpsZ80RomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_TILES) {
				nCpsGfxLen += ri.nLen;
				nCpsTilesRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_PIC) {
				nCpsPicRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_OKIM6295_SAMPLES) {
				nCpsAdLen += ri.nLen;
				nCpsOkim6295RomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_QSOUND_SAMPLES) {
				Cps1Qs = 1;
				nCpsQSamLen += ri.nLen;
				nCpsQsoundRomNum++;
			}
			if (((ri.nType & 0xff) == CPS1_EXTRA_TILES_SF2EBBL_400000) || ((ri.nType & 0xff) == CPS1_EXTRA_TILES_400000) || ((ri.nType & 0xff) == CPS1_EXTRA_TILES_SF2KORYU_400000) || ((ri.nType & 0xff) == CPS1_EXTRA_TILES_SF2B_400000)) {
				nCpsExtraGfxLen += ri.nLen;
				nCpsExtraTilesRomNum++;
			}
			i++;

		} while (ri.nLen);

		// Some ips come from hack games in which CpsRom is expanded.
		if (bDoIpsPatch)
			nCpsRomLen += nIpsMemExpLen[PRG1_ROM];

		if (Cps1Qs) nCpsZRomLen *= 2;
		if (GameHasStars) nCpsGfxLen += 0x2000;
		if (nCpsPicRomNum) Cps1DisablePSnd = 1;
		
#if 1 && defined FBNEO_DEBUG
		if (nCpsRomLen) bprintf(PRINT_IMPORTANT, _T("68K Rom Length %06X, (%i roms byteswapped, %i roms not byteswapped)\n"), nCpsRomLen, nCps68KByteswapRomNum, nCps68KNoByteswapRomNum);
		if (nCpsZRomLen) bprintf(PRINT_IMPORTANT, _T("Z80 Rom Length %06X, (%i roms)\n"), nCpsZRomLen, nCpsZ80RomNum);
		if (nCpsGfxLen) bprintf(PRINT_IMPORTANT, _T("Tile Rom Length %08X, (%i roms)\n"), nCpsGfxLen, nCpsTilesRomNum);
		if (nCpsAdLen) bprintf(PRINT_IMPORTANT, _T("OKIM6295 Rom Length %08X, (%i roms)\n"), nCpsAdLen, nCpsOkim6295RomNum);
		if (nCpsQSamLen) bprintf(PRINT_IMPORTANT, _T("QSound Rom Length %08X, (%i roms)\n"), nCpsQSamLen, nCpsQsoundRomNum);
		if (nCpsExtraGfxLen) bprintf(PRINT_IMPORTANT, _T("Extra Tile Rom Length %08X, (%i roms)\n"), nCpsExtraGfxLen, nCpsExtraTilesRomNum);
#endif
	}

	if (bLoad) {
		INT32 Offset = 0;
		
		i = 0;
		while (i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum) {
			BurnDrvGetRomInfo(&ri, i + 0);
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_BYTESWAP) {
				nRet = BurnLoadRom(CpsRom + Offset + 1, i + 0, 2); if (nRet) return 1;
				nRet = BurnLoadRom(CpsRom + Offset + 0, i + 1, 2); if (nRet) return 1;
			
				BurnDrvGetRomInfo(&ri, i + 0);
				Offset += ri.nLen;
				BurnDrvGetRomInfo(&ri, i + 1);
				Offset += ri.nLen;
				
				i += 2;
			}
			
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_NO_BYTESWAP) {
				nRet = BurnLoadRom(CpsRom + Offset, i, 1); if (nRet) return 1;
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
				
				i++;
			}
		}

		// Graphics
		if (nCpsGfxLen) {
			Offset = 0;
			i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum;
			while (i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum) {
				if (Cps1GfxLoadCallbackFunction) {
					Cps1GfxLoadCallbackFunction(i);
				
					i += nCpsTilesRomNum;
				} else {
					BurnDrvGetRomInfo(&ri, i + 0);

					if (ri.nLen < 0x80000) {
						CpsLoadTilesByte(CpsGfx + Offset, i);
		
						BurnDrvGetRomInfo(&ri, i + 0);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 1);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 2);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 3);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 4);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 5);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 6);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 7);
						Offset += ri.nLen;
						
						i += 8;
					} else {
						if (nCpsTilesRomNum < 4) {
							// Handle this seperately
							i += nCpsTilesRomNum;
						} else {
							CpsLoadTiles(CpsGfx + Offset, i);
				
							BurnDrvGetRomInfo(&ri, i + 0);
							Offset += ri.nLen;
							BurnDrvGetRomInfo(&ri, i + 1);
							Offset += ri.nLen;
							BurnDrvGetRomInfo(&ri, i + 2);
							Offset += ri.nLen;
							BurnDrvGetRomInfo(&ri, i + 3);
							Offset += ri.nLen;
			
							i += 4;
						}
					}
				}
			}			
		}

		// Z80 Program
		if (nCpsZRomLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i++) {
				BurnLoadRom(CpsZRom + Offset, i, 1);
				
				if (Cps1Qs) BurnLoadRom(CpsEncZRom + Offset, i, 1);
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
			}
		}
		
		// Pic (skip for now)
		if (nCpsPicRomNum) {
			BurnDrvGetRomInfo(&ri, i);
		}
		
		// OKIM6295 Samples
		if (nCpsAdLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsOkim6295RomNum; i++) {
				BurnLoadRom(CpsAd + Offset, i, 1);
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
			}
		}
		
		// QSound Samples
		if (nCpsQSamLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsQsoundRomNum; i++) {
				BurnLoadRom((UINT8*)CpsQSam + Offset, i, 1);
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
			}
		}
		
		// Extra Tile Roms
		if (nCpsExtraGfxLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsQsoundRomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsQsoundRomNum + nCpsExtraTilesRomNum; i++) {
				BurnDrvGetRomInfo(&ri, i + 0);
				
				if ((ri.nType & 0xff) == CPS1_EXTRA_TILES_SF2EBBL_400000) {
					memset(CpsGfx + 0x400000, 0, nCpsExtraGfxLen);
					CpsLoadTilesSf2ebbl(CpsGfx + 0x400000, i);
				
					i += 4;
				}
				
				if ((ri.nType & 0xff) == CPS1_EXTRA_TILES_400000) {
					memset(CpsGfx + 0x400000, 0, nCpsExtraGfxLen);
					CpsLoadTiles(CpsGfx + 0x400000, i);
				
					i += 4;
				}
				
				if ((ri.nType & 0xff) == CPS1_EXTRA_TILES_SF2KORYU_400000) {
					memset(CpsGfx + 0x400000, 0, nCpsExtraGfxLen);
					CpsLoadTilesSf2koryuExtra(CpsGfx + 0x400000, i);
					
					i += 2;
				}
				
				if ((ri.nType & 0xff) == CPS1_EXTRA_TILES_SF2B_400000) {
					memset(CpsGfx + 0x400000, 0, nCpsExtraGfxLen);
					CpsLoadTilesSf2b(CpsGfx + 0x400000, i);
				
					i += 4;
				}
			}
		}
	}

	return nRet;
}

typedef void (*AmendProgRom)();
static AmendProgRom AmendProgRomCallback;

static INT32 DrvInit()
{
	INT32 nRet = 0;
	
	SetGameConfig();
    
	Cps1LoadRoms(0);

	Cps = 1;
	nRet = CpsInit(); if (nRet != 0) return 1;
	
	if (Cps1LoadRoms(1)) return 1;
	
	if (AmendProgRomCallback) AmendProgRomCallback();
	
	SetGameConfig();
	
	if (Cps1Qs) {
		KabukiDecodeFunction();
	}
	
	nRet = CpsRunInit(); if (nRet != 0) return 1;
	
	Cps1VBlankIRQLine = 2;

	return 0;
}

static INT32 DrvExit()
{
	CpsRunExit();
	CpsExit();
	
	nCpsRomLen = 0;
	nCpsZRomLen = 0;
	nCpsGfxLen = 0;
	nCpsAdLen = 0;
	nCpsQSamLen = 0;
	nCpsPicRomNum = 0;
	nCpsExtraGfxLen = 0;
	
	nCps68KByteswapRomNum = 0;
	nCps68KNoByteswapRomNum = 0;
	nCpsZ80RomNum = 0;
	nCpsTilesRomNum = 0;
	nCpsOkim6295RomNum = 0;
	nCpsQsoundRomNum = 0;
	nCpsExtraTilesRomNum = 0;
	KabukiDecodeFunction = NULL;
	GameHasStars = 0;
	
	AmendProgRomCallback = NULL;
	
	CpsLayer1XOffs = 0;
	CpsLayer2XOffs = 0;
	CpsLayer3XOffs = 0;
	CpsLayer1YOffs = 0;
	CpsLayer2YOffs = 0;
	CpsLayer3YOffs = 0;
	CpsDrawSpritesInReverse = 0;
	Cps1OverrideLayers = 0;
	nCps1Layers[0] = -1;
	nCps1Layers[1] = -1;
	nCps1Layers[2] = -1;
	nCps1Layers[3] = -1;

	Cps = 0;
	Cps1Qs = 0;
	Cps1DisablePSnd = 0;
	Forgottn = 0;
	Ghouls = 0;
	Kodb = 0;
	PangEEP = 0;
	Cps1LockSpriteList910000 = 0;
	Cps1DisableBgHi = 0;
	CpsDisableRowScroll = 0;
	Dinohunt = 0;
	Sf2thndr = 0;
	Hkittymp = 0;
	Port6SoundWrite = 0;
	
	Cps1QsHack = 0;
	
	Cps1GfxLoadCallbackFunction = NULL;
	
	BurnFree(CpsBootlegSpriteRam);
	
	return 0;
}

static INT32 TwelveMhzInit()
{
	nCPS68KClockspeed = 12000000;
	
	return DrvInit();
}

static INT32 MpumpkinInit()
{
	Hkittymp = 1;

	return DrvInit();
}

static INT32 CpsBootlegSpriteRamScanCallback(INT32 nAction, INT32*)
{
	if (nAction & ACB_MEMORY_RAM) {
		struct BurnArea ba;
		memset(&ba, 0, sizeof(ba));

		ba.Data = CpsBootlegSpriteRam;
		ba.nLen = 0x4000;
		ba.szName = "CpsBootlegSpriteRam";
		BurnAcb(&ba);
	}
	
	return 0;
}

static INT32 Cps1RasterInit()
{
	Cps1DrawAtVblank = 1;

	return DrvInit();
}

static INT32 Wonder3bInit()
{
	bCpsUpdatePalEveryFrame = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesWonder3b;
	
	CpsLayer1XOffs = 4;
	CpsLayer2XOffs = 6;
	CpsLayer3XOffs = 10;
	
	INT32 nRet = Cps1RasterInit();
	if (nRet) return nRet;
	
	// the game doesn't write these anywhere - does the hardware have them stored somewhere?	
	*((UINT16*)(CpsReg + 0x04)) = BURN_ENDIAN_SWAP_INT16(0x90c0); // scroll2 address
	*((UINT16*)(CpsReg + 0x06)) = BURN_ENDIAN_SWAP_INT16(0x9100); // scroll3 address
	*((UINT16*)(CpsReg + 0x0a)) = BURN_ENDIAN_SWAP_INT16(0x9140); // palette address
	*((UINT16*)(CpsReg + nCpsPalCtrlReg)) = BURN_ENDIAN_SWAP_INT16(0x003f); // palette control
	
	return nRet;
}

static INT32 CaptcommbInit()
{
	CpsLayer1XOffs = -8;
	CpsLayer2XOffs = -11;
	CpsLayer3XOffs = -12;
	CpsDrawSpritesInReverse = 1;
	Cps1DetectEndSpriteList8000 = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesCaptcommb;

	return Cps1RasterInit();
}

static INT32 Captcommb3Init()
{
	Cps1DisablePSnd = 1;
	CpsRunInitCallbackFunction = Sf2mdtSoundInit;
	CpsRunResetCallbackFunction = Sf2mdtSoundReset;
	CpsRunExitCallbackFunction = Sf2mdtSoundExit;
	CpsRunFrameStartCallbackFunction = Sf2mdtSoundFrameStart;
	CpsRunFrameEndCallbackFunction = Sf2mdtSoundFrameEnd;
	CpsRWSoundCommandCallbackFunction = Sf2mdtSoundCommand;
	CpsMemScanCallbackFunction = Sf2mdtScanSound;
	
	return Cps1RasterInit();
}

UINT8 __fastcall CawingblInputReadByte(UINT32 a)
{
	switch (a) {
		case 0x882000: {
			return ~Inp000;
		}
		
		case 0x882001: {
			return ~Inp001;
		}
		
		case 0x882008: {
			return ~Inp018;
		}
		
		case 0x88200a: {
			return ~Cpi01A;
		}
		
		case 0x88200c: {
			return ~Cpi01C;
		}
		
		case 0x88200e: {
			return ~Cpi01E;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Byte %x\n"), a);
		}
	}

	return 0;
}

UINT16 __fastcall CawingblInputReadWord(UINT32 a)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Word %x\n"), a);
		}
	}

	return 0;
}

void __fastcall CawingblInputWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x882006: {
			FcrashSoundCommand(d);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall CawingblInputWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x882006: {
			FcrashSoundCommand(d);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write Word %x, %x\n"), a, d);
		}
	}
}

static INT32 CawingblInit()
{
	INT32 nRet = 0;
	
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	
	CpsLayer1XOffs = -63;
	CpsLayer2XOffs = -62;
	CpsLayer3XOffs = -65;

	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesCawingbl;
	CpsRunInitCallbackFunction = FcrashSoundInit;
	CpsRunResetCallbackFunction = FcrashSoundReset;
	CpsRunExitCallbackFunction = FcrashSoundExit;
	CpsRunFrameStartCallbackFunction = FcrashSoundFrameStart;
	CpsRunFrameEndCallbackFunction = FcrashSoundFrameEnd;
	CpsMemScanCallbackFunction = FcrashScanSound;
	
	nRet = DrvInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0x882000, 0x882fff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, CawingblInputReadByte);
	SekSetReadWordHandler(1, CawingblInputReadWord);
	SekSetWriteByteHandler(1, CawingblInputWriteByte);
	SekSetWriteWordHandler(1, CawingblInputWriteWord);
	SekClose();
	
	Cps1VBlankIRQLine = 6;
	
	return 0;
}

static INT32 Cawingb2Init()
{
	INT32 nRet = 0;
	
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	
	CpsLayer1XOffs = -63;
	CpsLayer2XOffs = -62;
	CpsLayer3XOffs = -65;

	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesFcrash;
	CpsRunInitCallbackFunction = FcrashSoundInit;
	CpsRunResetCallbackFunction = FcrashSoundReset;
	CpsRunExitCallbackFunction = FcrashSoundExit;
	CpsRunFrameStartCallbackFunction = FcrashSoundFrameStart;
	CpsRunFrameEndCallbackFunction = FcrashSoundFrameEnd;
	CpsMemScanCallbackFunction = FcrashScanSound;
	
	nRet = DrvInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0x882000, 0x882fff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, CawingblInputReadByte);
	SekSetReadWordHandler(1, CawingblInputReadWord);
	SekSetWriteByteHandler(1, CawingblInputWriteByte);
	SekSetWriteWordHandler(1, CawingblInputWriteWord);
	SekClose();
	
	Cps1VBlankIRQLine = 6;
	
	return 0;
}

static INT32 Cps1demoInit()
{
	bCpsUpdatePalEveryFrame = 1;

	return DrvInit();
}

void __fastcall DinopicScrollWrite(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

void __fastcall DinopicLayerWrite(UINT32 a, UINT16 d)
{
	if (a == 0x800222) {
		*((UINT16*)(CpsReg + 0x06)) = d;
		return;
	}
	
	// Send anything else through the main handler
	SEK_DEF_WRITE_WORD(0, a, d);
}

static void Jurassic99PatchCallback()
{
	UINT32 patch_fix_a[] = {
		// Fix screen transitions
		0x000b28, 0x00, 0x000b29, 0x70, 0x000b2a, 0x00, 0x000b2b, 0x72, 0x000b2c, 0x3c, 0x000b2d, 0x34,
		0x000b32, 0xc1, 0x000b33, 0x20
	};

	for (INT32 i = 0; i < (sizeof(patch_fix_a) / sizeof(UINT32)) >> 1; i++) {
		CpsRom[patch_fix_a[(i << 1) + 0]] = (UINT8)patch_fix_a[(i << 1) + 1];
	}

	if (Cps1QSDip & 1) {
		UINT32 patch_fix_b[] = {
			// Fix draw scroll
			0x0006c2, 0xc0, 0x0006c3, 0xff,

			// Fix gfx
			0x000472, 0xfc, 0x000473, 0x33, 0x000474, 0x00, 0x000475, 0x90, 0x000476, 0x80, 0x000478, 0x00,
			0x000479, 0x01, 0x00047a, 0xfc, 0x00047b, 0x33, 0x00047c, 0x80, 0x00047d, 0x90, 0x00047e, 0x80,
			0x000480, 0x02, 0x000481, 0x01, 0x000482, 0xfc, 0x000483, 0x33, 0x000484, 0xc0, 0x000485, 0x90,
			0x000486, 0x80, 0x000487, 0x00, 0x000488, 0x04, 0x000489, 0x01, 0x00048a, 0xfc, 0x00048b, 0x33,
			0x00048c, 0x00, 0x00048d, 0x91, 0x00048e, 0x80, 0x00048f, 0x00, 0x000490, 0x06, 0x000491, 0x01,
			0x0006cc, 0x80, 0x0006cd, 0x00, 0x0006ce, 0x0c, 0x0006cf, 0x01, 0x0006de, 0x80, 0x0006df, 0x00,
			0x0006e0, 0x10, 0x0006e1, 0x01, 0x0006f0, 0x80, 0x0006f1, 0x00, 0x0006f2, 0x14, 0x0006f3, 0x01,
			0x000704, 0x80, 0x000705, 0x00, 0x000706, 0x0e, 0x000707, 0x01, 0x000718, 0x80, 0x000719, 0x00,
			0x00071a, 0x12, 0x00071b, 0x01, 0x00072c, 0x80, 0x00072d, 0x00, 0x00072e, 0x16, 0x00072f, 0x01,

			// Fix sound
			0x000666, 0xf1, 0x000667, 0x00, 0x000668, 0x02, 0x000669, 0x80, 0x0aaa6c, 0xd8, 0x0aaa6d, 0x00
		};

		for (INT32 i = 0; i < (sizeof(patch_fix_b) / sizeof(UINT32)) >> 1; i++) {
			CpsRom[patch_fix_b[(i << 1) + 0]] = (UINT8)patch_fix_b[(i << 1) + 1];
		}
	}
}

static INT32 DinopicInit()
{
	Cps1DisablePSnd = 1;
	CpsBootlegEEPROM = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesDinopic;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = Jurassic99PatchCallback;
	} else {
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;
		
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	if (Cps1QSDip ^ 1) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

		SekOpen(0);
		SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x991fff, MAP_RAM);
		SekMapHandler(1, 0x980000, 0x98000f, MAP_WRITE);
		SekSetWriteWordHandler(1, DinopicScrollWrite);
		SekMapHandler(2, 0x800200, 0x8002ff, MAP_WRITE);
		SekSetWriteWordHandler(2, DinopicLayerWrite);
		SekClose();
	}
	return nRet;
}

UINT8 __fastcall DinohuntQSharedRamRead(UINT32 /*a*/)
{
	return 0xff;
}

static INT32 DinohInit()
{
	INT32 nRet = 0;

	Cps1QsHack = 1;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;

	SekOpen(0);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, DinohuntQSharedRamRead);
	SekClose();

	return nRet;
}

static INT32 Dinopic3Init()
{
	Cps1DisablePSnd = 1;
	CpsBootlegEEPROM = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160Alt;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = Jurassic99PatchCallback;
	} else {
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	if (Cps1QSDip ^ 1) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

		SekOpen(0);
		SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x991fff, MAP_RAM);
		SekMapHandler(1, 0x980000, 0x98000f, MAP_WRITE);
		SekSetWriteWordHandler(1, DinopicScrollWrite);
		SekMapHandler(2, 0x800200, 0x8002ff, MAP_WRITE);
		SekSetWriteWordHandler(2, DinopicLayerWrite);
		SekClose();
	}
	return nRet;
}

static UINT16 Dinopic5ProtValue = 0;

UINT16 __fastcall Dinopic5ProtReadWord(UINT32 a)
{
	switch (a) {
		case 0x57a2b0: {
			if (Dinopic5ProtValue == 0x04) return 0x0404;
			return 0xffff;
		}
	}
	
	return 0;
}

void __fastcall Dinopic5ProtWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x5762b0: {
			Dinopic5ProtValue = d;
			return;
		}
	}
}

static INT32 Dinopic5Init()
{
	INT32 nRet = 0;
	
	CpsBootlegEEPROM = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesDinopic5;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, DinohuntQSharedRamRead);
	SekMapHandler(2, 0x570000, 0x57ffff, MAP_READ | MAP_WRITE);
	SekSetReadWordHandler(2, Dinopic5ProtReadWord);
	SekSetWriteWordHandler(2, Dinopic5ProtWriteWord);
	SekClose();
	
	return nRet;
}

static void DinotCallback()
{
	UINT8 *TempRom = (UINT8*)BurnMalloc(0x200000);
	if (TempRom) {
		memcpy(TempRom, CpsRom, 0x200000);
		memset(CpsRom, 0, 0x200000);
		memcpy(CpsRom + 0x080000, TempRom + 0x000000, 0x80000);
		memcpy(CpsRom + 0x000000, TempRom + 0x080000, 0x80000);
		memcpy(CpsRom + 0x180000, TempRom + 0x100000, 0x80000);
		memcpy(CpsRom + 0x100000, TempRom + 0x180000, 0x80000);
		BurnFree(TempRom);
	}
}

static INT32 DinotInit()
{
	INT32 nRet = 0;

	Cps1QsHack = 1;
	AmendProgRomCallback = DinotCallback;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;

	SekOpen(0);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, DinohuntQSharedRamRead);
	SekClose();

	return nRet;
}

static INT32 DinotpicInit()
{
	Cps1DisablePSnd = 1;
	CpsBootlegEEPROM = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = Jurassic99PatchCallback;
	} else {
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	if (Cps1QSDip ^ 1) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

		SekOpen(0);
		SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x991fff, MAP_RAM);
		SekMapHandler(1, 0x980000, 0x98000f, MAP_WRITE);
		SekSetWriteWordHandler(1, DinopicScrollWrite);
		SekMapHandler(2, 0x800200, 0x8002ff, MAP_WRITE);
		SekSetWriteWordHandler(2, DinopicLayerWrite);
		SekClose();
	}
	return nRet;
}

static INT32 Jurassic99Init()
{
	Cps1DisablePSnd = 1;
	CpsBootlegEEPROM = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = Jurassic99PatchCallback;
	} else {
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;

	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x991fff, MAP_RAM);
	if (Cps1QSDip ^ 1) {
		SekMapHandler(1, 0x980000, 0x98000f, MAP_WRITE);
		SekSetWriteWordHandler(1, DinopicScrollWrite);
		SekMapHandler(2, 0x800200, 0x8002ff, MAP_WRITE);
		SekSetWriteWordHandler(2, DinopicLayerWrite);
	}
	SekClose();

	return nRet;
}

static INT32 DinohuntInit()
{
	INT32 nRet = 0;
	
	Dinohunt = 1;
	CpsBootlegEEPROM = 1;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, DinohuntQSharedRamRead);
	SekClose();
	
	return nRet;
}

UINT8 __fastcall FcrashInputReadByte(UINT32 a)
{
	switch (a) {
		case 0x880000: {
			return ~Inp000;
		}
		
		case 0x880008: {
			return ~Inp018;
		}
		
		case 0x88000a: {
			return ~Cpi01A;
		}
		
		case 0x88000c: {
			return ~Cpi01C;
		}
		
		case 0x88000e: {
			return ~Cpi01E;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Byte %x\n"), a);
		}
	}
	
	return 0;
}

UINT16 __fastcall FcrashInputReadWord(UINT32 a)
{
	switch (a) {
		case 0x880000: {
			return (~Inp000 << 8) | ~Inp001;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Word %x\n"), a);
		}
	}
	
	return 0;
}

void __fastcall FcrashInputWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall FcrashInputWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x880006: {
			FcrashSoundCommand(d);
			return;
		}
		
		case 0x890000: {
			// ???
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write word %x, %x\n"), a, d);
		}
	}
}

static INT32 FfightblInit()
{
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = -0x3f;
	CpsLayer2XOffs = -0x3c;
	CpsLayer3XOffs = 0xffc0;
	
	Cps1GfxLoadCallbackFunction = CpsLoadTilesCawingbl;
	Cps1ObjGetCallbackFunction = FcrashObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = FcrashSoundInit;
	CpsRunResetCallbackFunction = FcrashSoundReset;
	CpsRunExitCallbackFunction = FcrashSoundExit;
	CpsRunFrameStartCallbackFunction = FcrashSoundFrameStart;
	CpsRunFrameEndCallbackFunction = FcrashSoundFrameEnd;
	CpsMemScanCallbackFunction = FcrashScanSound;
	
	INT32 nRet = DrvInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, FcrashInputReadByte);
	SekSetReadWordHandler(1, FcrashInputReadWord);
	SekSetWriteByteHandler(1, FcrashInputWriteByte);
	SekSetWriteWordHandler(1, FcrashInputWriteWord);
	SekClose();
	
	return nRet;
}

static void FcrashPatch()
{
	// This fixes sprite ram clearing - shouldn't be necessary, but used for now pending understanding of the underlying issue
	CpsRom[0x2611] = 0x07;
}

static INT32 FcrashInit()
{
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = -0x3f;
	CpsLayer2XOffs = -0x3c;
	CpsLayer3XOffs = 0xffc0;
	
	AmendProgRomCallback = FcrashPatch;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesFcrash;
	Cps1ObjGetCallbackFunction = FcrashObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = FcrashSoundInit;
	CpsRunResetCallbackFunction = FcrashSoundReset;
	CpsRunExitCallbackFunction = FcrashSoundExit;
	CpsRunFrameStartCallbackFunction = FcrashSoundFrameStart;
	CpsRunFrameEndCallbackFunction = FcrashSoundFrameEnd;
	CpsMemScanCallbackFunction = FcrashScanSound;
	
	INT32 nRet = DrvInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, FcrashInputReadByte);
	SekSetReadWordHandler(1, FcrashInputReadWord);
	SekSetWriteByteHandler(1, FcrashInputWriteByte);
	SekSetWriteWordHandler(1, FcrashInputWriteWord);
	SekClose();
	
	return nRet;
}

static INT32 ForgottnNewerInit()
{
	INT32 nRet = 0;
	
	Forgottn = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesForgottn;
	
	nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStarsForgottnAlt(CpsStar, 18);
	
	return nRet;
}

static INT32 ForgottnInit()
{
	INT32 nRet = 0;
	
	Forgottn = 1;
	
	nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStars(CpsStar, 9);
	
	return nRet;
}

static INT32 ForgottnAltGfxInit()
{
	INT32 nRet = 0;
	
	Forgottn = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesForgottna;
	
	nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStarsForgottnAlt(CpsStar, 15);
	
	return nRet;
}

static INT32 ForgottnAltGfxuInit()
{
	INT32 nRet = 0;
	
	Forgottn = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesForgottnu;
	
	nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStarsForgottnAlt(CpsStar, 15);
	
	return nRet;
}

UINT8 __fastcall GanbareTimeKeeperReadByte(UINT32 a)
{
	if (a & 1) {
		return TimeKeeperRead((a & 0xffff) >> 1);
	} else {
		return CpsRamFF[(a & 0xffff) >> 1];
	}
}

UINT16 __fastcall GanbareTimeKeeperReadWord(UINT32 a)
{
	SEK_DEF_READ_WORD(1, a);
}

void __fastcall GanbareTimeKeeperWriteByte(UINT32 a, UINT8 d)
{
	if (a & 1) {
		TimeKeeperWrite((a & 0xffff) >> 1, d);
	} else {
		CpsRamFF[(a & 0xffff) >> 1] = d;
	}
}

void __fastcall GanbareTimeKeeperWriteWord(UINT32 a, UINT16 d)
{
	SEK_DEF_WRITE_WORD(1, a, d);
}

static void GanabareTimeKeeperTick()
{
	if ((GetCurrentFrame() % 60) == 0) TimeKeeperTick(); // refresh is 59.61
	
	SekOpen(0);
	SekSetIRQLine(4, CPU_IRQSTATUS_AUTO);
	SekClose();
}

static INT32 GanbareScanCallback(INT32 nAction, INT32*)
{
	TimeKeeperScan(nAction);

	return 0;
}

static INT32 GanbareInit()
{
	CpsRunFrameStartCallbackFunction = GanabareTimeKeeperTick;
	CpsMemScanCallbackFunction = GanbareScanCallback;
	
	INT32 nRet = DrvInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(1, 0xff0000, 0xffffff, MAP_RAM);
	SekSetReadByteHandler(1, GanbareTimeKeeperReadByte);
	SekSetReadWordHandler(1, GanbareTimeKeeperReadWord);
	SekSetWriteByteHandler(1, GanbareTimeKeeperWriteByte);
	SekSetWriteWordHandler(1, GanbareTimeKeeperWriteWord);
	SekClose();
	
	TimeKeeperInit(TIMEKEEPER_M48T35, NULL);
	
	return nRet;
}

static INT32 GanbareExit()
{
	TimeKeeperExit();
	
	return DrvExit();
}

static void GhoulsCallback()
{
	BurnByteswap(CpsRom + 0x080000, 0x080000);
}

static INT32 GhoulsInit()
{
	Ghouls = 1;
	AmendProgRomCallback = GhoulsCallback;

	return DrvInit();
}

static INT32 DaimakaiInit()
{
	Ghouls = 1;
	
	return DrvInit();
}

void __fastcall Daimakaib88WriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x880000: {
			*((UINT16*)(CpsReg + nCpsPalCtrlReg)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
	}
	
	bprintf(PRINT_NORMAL, _T("Write word %x, %x\n"), a, d);
}

void __fastcall Daimakaib98WriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x98000c: {
			// This seems to control layer order and enable
			switch (d) {
				case 0: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 1: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = -1;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 2: {
					nCps1Layers[0] = 3;
					nCps1Layers[1] = -1;
					nCps1Layers[2] = -1;
					nCps1Layers[3] = 1;
					break;
				}
				
				case 6: {
					nCps1Layers[0] = -1;
					nCps1Layers[1] = -1;
					nCps1Layers[2] = -1;
					nCps1Layers[3] = -1;
					break;
				}
				
				default: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 0;
					nCps1Layers[3] = 0;
					bprintf(PRINT_IMPORTANT, _T("Unknown value written at 0x98000c %x\n"), d);
				}
			}
			return;
		}
	}
	
	bprintf(PRINT_NORMAL, _T("Write word %x, %x\n"), a, d);
}

void __fastcall DaimakaibFFWriteByte(UINT32 a, UINT8 d)
{
	CpsRamFF[((a & 0xffff) ^ 1)] = d;
}

void __fastcall DaimakaibFFWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0xff0680: {
			*((UINT16*)(CpsReg + MaskAddr[1])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff0682: {
			*((UINT16*)(CpsReg + MaskAddr[2])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff0684: {
			*((UINT16*)(CpsReg + MaskAddr[3])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
	}
	
	UINT16 *RAM = (UINT16*)CpsRamFF;
	RAM[((a & 0xffff) >> 1)] = d;
}

static INT32 DaimakaibInit()
{
	Ghouls = 1;
	Port6SoundWrite = 1;
	Cps1OverrideLayers = 1;
	Cps1ObjGetCallbackFunction = DaimakaibObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;
	
	INT32 nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x991fff, MAP_RAM);
	SekMapHandler(1, 0x880000, 0x88ffff, MAP_WRITE);
	SekSetWriteWordHandler(1, Daimakaib88WriteWord);
	SekMapHandler(2, 0x980000, 0x98ffff, MAP_WRITE);
	SekSetWriteWordHandler(2, Daimakaib98WriteWord);
	SekMapHandler(3, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(3, DaimakaibFFWriteByte);
	SekSetWriteWordHandler(3, DaimakaibFFWriteWord);
	SekClose();
	
	return nRet;
}

void __fastcall Knightsb98WriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x3e);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x3c);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x98000c: {
			// This seems to control layer order and enable
			switch (d) {
				case 0x0000:
				case 0x001f:
				case 0x00ff:
				case 0x07ff:
				case 0x5800:
				case 0x5f00: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 0x2000: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 1;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 0x80ff:
				case 0x87ff:
				case 0xd800: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 3;
					nCps1Layers[3] = 2;
					break;
				}
				
				case 0xa000: {
					nCps1Layers[0] = 2;
					nCps1Layers[1] = 1;
					nCps1Layers[2] = 0;
					nCps1Layers[3] = 3;
					break;
				}
				
				default: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					bprintf(PRINT_IMPORTANT, _T("Unknown value written at 0x98000c %x\n"), d);
				}
			}
			return;
		}
		
		case 0x980020: {
			*((UINT16*)(CpsReg + MaskAddr[1])) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980022: {
			*((UINT16*)(CpsReg + MaskAddr[2])) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980024: {
			*((UINT16*)(CpsReg + MaskAddr[3])) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write word %x, %x\n"), a, d);
		}
	}
}

static INT32 KnightsbScanCallback(INT32 nAction, INT32*pnMin)
{
	CpsBootlegSpriteRamScanCallback(nAction, pnMin);
	Sf2mdtScanSound(nAction, pnMin);
	
	return 0;
}

static INT32 KnightsbInit()
{
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	Cps1OverrideLayers = 1;
	Port6SoundWrite = 1;
	
	Cps1ObjGetCallbackFunction = DinopicObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = Sf2mdtSoundInit;
	CpsRunResetCallbackFunction = Sf2mdtSoundReset;
	CpsRunExitCallbackFunction = Sf2mdtSoundExit;
	CpsRunFrameStartCallbackFunction = Sf2mdtSoundFrameStart;
	CpsRunFrameEndCallbackFunction = Sf2mdtSoundFrameEnd;
	CpsRWSoundCommandCallbackFunction = Sf2mdtSoundCommand;
	CpsMemScanCallbackFunction = Sf2mdtScanSound;
	CpsMemScanCallbackFunction = KnightsbScanCallback;
	
	INT32 nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
	SekMapHandler(1, 0x980000, 0x98ffff, MAP_WRITE);
	SekSetWriteWordHandler(1, Knightsb98WriteWord);
	SekClose();
	
	return nRet;
}

static INT32 Knightsb2Init()
{
	CpsDrawSpritesInReverse = 1;
	Cps1DetectEndSpriteList8000 = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesKnightsb2;
	
	return DrvInit();
}

UINT8 __fastcall KodbInputReadByte(UINT32 a)
{
	switch (a) {
		case 0x992000: {
			return ~Inp000;
		}
		
		case 0x992001: {
			return ~Inp001;
		}
		
		case 0x992008: {
			return ~Inp018;
		}
		
		case 0x992009: {
			return 0xff;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Byte %x\n"), a);
		}
	}
	
	return 0;
}

void __fastcall Kodb98WriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x992007: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);
			PsndCode = d;
			return;
		}
	}
	
	bprintf(PRINT_IMPORTANT, _T("Unknown byte value written at %x %x\n"), a, d);
}

void __fastcall Kodb98WriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x3e);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x3c);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x98000c: {
			*((UINT16*)(CpsReg + nCpsLcReg)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980020: {
			*((UINT16*)(CpsReg + MaskAddr[1])) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980022: {
			*((UINT16*)(CpsReg + MaskAddr[2])) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x994000: {
			// ???
			return;
		}
	}
	
	bprintf(PRINT_IMPORTANT, _T("Unknown value written at %x %x\n"), a, d);
}

static void KodbPatch()
{
	// This fixes sprite ram clearing - shouldn't be necessary, but used for now pending understanding of the underlying issue
	CpsRom[0x953] = 0x07;
}

static INT32 KodbInit()
{
	INT32 nRet = 0;

	Kodb = 1;
	bCpsUpdatePalEveryFrame = 1;
	CpsDisableRowScroll = 1;
	AmendProgRomCallback = KodbPatch;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesKodb;
	Cps1ObjGetCallbackFunction = KodbObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	nRet = Cps1RasterInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x900000, 0x903fff, MAP_RAM);
	SekMapMemory(CpsBootlegSpriteRam, 0x904000, 0x907fff, MAP_RAM);
	SekMapHandler(1, 0x980000, 0x99ffff, MAP_WRITE);
	SekSetWriteByteHandler(1, Kodb98WriteByte);
	SekSetWriteWordHandler(1, Kodb98WriteWord);
	SekMapHandler(2, 0x992000, 0x992009, MAP_READ);
	SekSetReadByteHandler(2, KodbInputReadByte);
	SekClose();
	
	Cps1VBlankIRQLine = 4;

	return nRet;
}

static INT32 KodhInit()
{
	Kodh = 1;
	
	return Cps1RasterInit();
}

static INT32 MercsInit()
{
	Cps1DisableBgHi = 1;

	return DrvInit();
}

void __fastcall MtwinsbWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x3e);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x3c);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
	}
	
	bprintf(PRINT_IMPORTANT, _T("Unknown value written at %x %x\n"), a, d);
}

static INT32 MtwinsbInit()
{
	INT32 nRet = 0;
	
	Port6SoundWrite = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesMtwinsb;
	Cps1ObjGetCallbackFunction = DinopicObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;
	
	nRet = Cps1RasterInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
	SekMapHandler(1, 0x980000, 0x98ffff, MAP_WRITE);
	SekSetWriteWordHandler(1, MtwinsbWriteWord);
	SekClose();
	
	*((UINT16*)(CpsReg + 0x06)) = BURN_ENDIAN_SWAP_INT16(0x9100); // doesn't seem to write this anywhere
	
	return nRet;
}

static INT32 Pang3bInit()
{
	PangEEP = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPang3;

	return TwelveMhzInit();
}

static void Pang3Callback()
{
	for (INT32 i = 0x80000; i < 0x100000; i += 2) {
		INT32 src = CpsRom[i];
		INT32 dst = src & 0xff00;
		if ( src & 0x01) dst ^= 0x04;
		if ( src & 0x02) dst ^= 0x21;
		if ( src & 0x04) dst ^= 0x01;
		if (~src & 0x08) dst ^= 0x50;
		if ( src & 0x10) dst ^= 0x40;
		if ( src & 0x20) dst ^= 0x06;
		if ( src & 0x40) dst ^= 0x08;
		if (~src & 0x80) dst ^= 0x88;
		CpsRom[i] = (UINT8)dst;
  	}
}

static INT32 Pang3Init()
{
	PangEEP = 1;
	AmendProgRomCallback = Pang3Callback;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPang3;
	
	return TwelveMhzInit();
}

static INT32 Pang3r1aInit()
{
	PangEEP = 1;
	AmendProgRomCallback = Pang3Callback;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPang3r1a;
	
	return TwelveMhzInit();
}

static INT32 Pang3b2Init()
{
	PangEEP = 1;
	AmendProgRomCallback = Pang3Callback;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPang3b2;

	return TwelveMhzInit();
}

static UINT16 Pang3b4ProtValue = 0;

UINT16 __fastcall Pang3b4ProtReadWord(UINT32 a)
{
	switch (a) {
		case 0x5762b0: {
			return 0;
		}
		
		case 0x57a2b0: {
			if ((Pang3b4ProtValue & 0xff) <= 7) return (Pang3b4ProtValue & 0xff) + 0x20; // Game level + extend
			if (Pang3b4ProtValue == 0x17) return 0x7321; // Guessed from code @0x314
			return 0xffff;
		}
	}
	
	return 0;
}

void __fastcall Pang3b4ProtWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x5762b0: {
			Pang3b4ProtValue = d;
			return;
		}
	}
}

static INT32 Pang3b4Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPang3b4;

	INT32 nRet = TwelveMhzInit();

	if (!nRet) {
		SekOpen(0);
		SekMapHandler(1, 0x570000, 0x57ffff, MAP_READ | MAP_WRITE);
		SekSetReadWordHandler(1, Pang3b4ProtReadWord);
		SekSetWriteWordHandler(1, Pang3b4ProtWriteWord);
	}

	return nRet;
}

static INT32 Pang3b5Init()
{
	PangEEP = 1;
	AmendProgRomCallback = Pang3Callback;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPang3b5;

	return TwelveMhzInit();
}

static INT32 GulunpaInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesGulunpa;

	return DrvInit();
}

static UINT16 PunipicPriorityValue = 0;

UINT8 __fastcall PunipicF18Read(UINT32)
{
	return 0xff;
}

void __fastcall Punipic98WriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x46);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x46);
			return;
		}
		
		case 0x98000c: {
			PunipicPriorityValue = d;
			return;
		}
		
		case 0x98000e: {
			// layer enable and order appears to be handled by writes here and at 0x98000c
			if (d == 0x0000) {
				switch (PunipicPriorityValue) {
					case 0x24: {
						nCps1Layers[0] = 1;
						nCps1Layers[1] = 0;
						nCps1Layers[2] = 3;
						nCps1Layers[3] = 2;
						return;
					}
					
					case 0x54:{
						nCps1Layers[0] = 1;
						nCps1Layers[1] = 0;
						nCps1Layers[2] = 2;
						nCps1Layers[3] = 3;
						return;
					}
					
					case 0x64: {
						nCps1Layers[0] = 1;
						nCps1Layers[1] = 0;
						nCps1Layers[2] = 2;
						nCps1Layers[3] = 3;
						return;
					}
					
					case 0x7c: {
						nCps1Layers[0] = 0;
						nCps1Layers[1] = 1;
						nCps1Layers[2] = 3;
						nCps1Layers[3] = 2;
						return;
					}
					
					default: {
						bprintf(PRINT_NORMAL, _T("Unknown PunipicPriorityValue %x when 0x98000e is %x\n"), PunipicPriorityValue, d);
						return;
					}
				}
			}
			
			if (d == 0xffff) {
				switch (PunipicPriorityValue) {
					case 0x24: {
						nCps1Layers[0] = 1;
						nCps1Layers[1] = 0;
						nCps1Layers[2] = -1;
						nCps1Layers[3] = 3;
						return;
					}
					
					case 0x54: {
						nCps1Layers[0] = 1;
						nCps1Layers[1] = 0;
						nCps1Layers[2] = 2;
						nCps1Layers[3] = -1;
						return;
					}
					
					case 0x64: {
						nCps1Layers[0] = 1;
						nCps1Layers[1] = 0;
						nCps1Layers[2] = 2;
						nCps1Layers[3] = -1;
						return;
					}
					
					default: {
						bprintf(PRINT_NORMAL, _T("Unknown PunipicPriorityValue %x when 0x98000e is %x\n"), PunipicPriorityValue, d);
						return;
					}
				}
			}
			
			bprintf(PRINT_NORMAL, _T("Unknown value written to 0x98000e %x\n"), d);
			
			return;
		}
	}
	
	bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
}

void __fastcall PunipicFFWriteByte(UINT32 a, UINT8 d)
{
	CpsRamFF[((a & 0xffff) ^ 1)] = d;
}

void __fastcall PunipicFFWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0xff5b30: {
			*((UINT16*)(CpsReg + MaskAddr[1])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff5b32: {
			*((UINT16*)(CpsReg + MaskAddr[2])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff5b34: {
			*((UINT16*)(CpsReg + MaskAddr[3])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff5b8a: {
			// scroll 1 ram offset
			*((UINT16*)(CpsReg + 0x02)) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff5b8c: {
			// scroll 2 ram offset
			*((UINT16*)(CpsReg + 0x04)) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff5b8e: {
			// scroll 3 ram offset
			*((UINT16*)(CpsReg + 0x06)) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
	}
	
	UINT16 *RAM = (UINT16*)CpsRamFF;
	RAM[((a & 0xffff) >> 1)] = d;
}

static INT32 PunipicScanCallback(INT32 nAction, INT32 *pnMin)
{
	if (nAction & ACB_DRIVER_DATA) {
		SCAN_VAR(PunipicPriorityValue);
	}

	return CpsBootlegSpriteRamScanCallback(nAction, pnMin);
}

static void PunipicPatchCallback()
{
	UINT32 patch_fix[] = {
		// Use standard ports
		0x000ab3, 0x33, 0x000ab4, 0x30, 0x000ab6, 0x80, 0x000ab7, 0x00, 0x000ab8, 0x56, 0x000ab9, 0x01,
		0x000aba, 0xed, 0x000abb, 0x33, 0x000abc, 0x32, 0x000abd, 0xdb, 0x000abe, 0x80, 0x000abf, 0x00,
		0x000ac0, 0x48, 0x000ac1, 0x01, 0x000ac2, 0xed, 0x000ac3, 0x33, 0x000ac4, 0x34, 0x000ac5, 0xdb,
		0x000ac6, 0x80, 0x000ac7, 0x00, 0x000ac8, 0x4a, 0x000ac9, 0x01, 0x000aca, 0xed, 0x000acb, 0x33,
		0x000acc, 0x2e, 0x000acd, 0xdb, 0x000ace, 0x80, 0x000ad0, 0x52, 0x000ad1, 0x01, 0x000ad2, 0xed,
		0x000ad3, 0x33, 0x000ad4, 0x88, 0x000ad5, 0xdb, 0x000ad6, 0x80, 0x000ad7, 0x00, 0x000ad8, 0x00,
		0x000ad9, 0x01, 0x000ada, 0xed, 0x000adb, 0x33, 0x000adc, 0x8a, 0x000add, 0xdb, 0x000ade, 0x80,
		0x000adf, 0x00, 0x000ae0, 0x02, 0x000ae1, 0x01, 0x000ae2, 0xed, 0x000ae3, 0x33, 0x000ae4, 0x8c,
		0x000ae5, 0xdb, 0x000ae6, 0x80, 0x000ae7, 0x00, 0x000ae8, 0x04, 0x000ae9, 0x01, 0x000aea, 0xed,
		0x000aeb, 0x33, 0x000aec, 0x8e, 0x000aed, 0xdb, 0x000aee, 0x80, 0x000aef, 0x00, 0x000af0, 0x06,
		0x000af1, 0x01, 0x000af2, 0xed, 0x000af3, 0x33, 0x000af4, 0x90, 0x000af5, 0xdb, 0x000af6, 0x80,
		0x000af7, 0x00, 0x000af8, 0x08, 0x000af9, 0x01, 0x000afa, 0xed, 0x000afb, 0x50, 0x000afc, 0x49,
		0x000afd, 0xdb, 0x000afe, 0xfc, 0x000aff, 0x33, 0x000b00, 0x3f, 0x000b02, 0x80, 0x000b03, 0x00,
		0x000b04, 0x4c, 0x000b05, 0x01, 0x000b06, 0xfc, 0x000b07, 0x33, 0x000b08, 0x40, 0x000b09, 0x91,
		0x000b0a, 0x80, 0x000b0c, 0x0a, 0x000b0d, 0x01, 0x000ba8, 0x80, 0x000baa, 0x0c, 0x000bab, 0x01,
		0x000bba, 0x80, 0x000bbc, 0x10, 0x000bbd, 0x01, 0x000bcc, 0x80, 0x000bce, 0x14, 0x000bcf, 0x01,
		0x000bda, 0x80, 0x000bdc, 0x0e, 0x000bdd, 0x01, 0x000bee, 0x80, 0x000bf0, 0x12, 0x000bf1, 0x01,
		0x000c02, 0x80, 0x000c04, 0x16, 0x000c05, 0x01,

		// Transitions
		0x0042b5, 0x00,

		// Q sound
		0x004dbc, 0x00, 0x004dbe, 0x58, 0x004dbf, 0x00, 0x004dc0, 0xf9, 0x004dc1, 0x41, 0x004dc2, 0xf1,
		0x004dc3, 0x00, 0x004dc4, 0x00, 0x004dc5, 0x80, 0x004dc6, 0x28, 0x004dc7, 0x4a, 0x004dc8, 0x1f,
		0x004dc9, 0x00, 0x004dca, 0x00, 0x004dcb, 0x6a, 0x004dcc, 0x4a, 0x004dcd, 0x00, 0x004dce, 0xed,
		0x004dcf, 0x49, 0x004dd0, 0x96, 0x004dd1, 0xe2, 0x004dd2, 0xf4, 0x004dd3, 0x49, 0x004dd4, 0x00,
		0x004dd5, 0x00, 0x004dd6, 0x40, 0x004dd7, 0x06, 0x004dd8, 0x10, 0x004dda, 0x40, 0x004ddb, 0x02,
		0x004ddc, 0xff, 0x004ddd, 0x0f, 0x004dde, 0x40, 0x004ddf, 0x3b, 0x004de0, 0xe8, 0x004de1, 0xda,
		0x004de2, 0x5c, 0x004de3, 0x11, 0x004de4, 0x01, 0x004de6, 0x5c, 0x004de7, 0x11, 0x004de8, 0x03,
		0x004de9, 0x00, 0x004dea, 0x5c, 0x004deb, 0x11, 0x004dec, 0x07, 0x004ded, 0x00, 0x004dee, 0x5c,
		0x004def, 0x11, 0x004df0, 0x09, 0x004df1, 0x00, 0x004df2, 0x1c, 0x004df3, 0x30, 0x004df4, 0x40,
		0x004df5, 0x11, 0x004df6, 0x0d, 0x004df7, 0x00, 0x004df8, 0x5c, 0x004df9, 0x11, 0x004dfa, 0x0f,
		0x004dfb, 0x00, 0x004dfc, 0x5c, 0x004dfd, 0x11, 0x004dfe, 0x11, 0x004e00, 0x5c, 0x004e01, 0x11,
		0x004e02, 0x17, 0x004e04, 0x5c, 0x004e05, 0x11, 0x004e06, 0x19, 0x004e07, 0x00, 0x004e08, 0x5c,
		0x004e09, 0x11, 0x004e0a, 0x13, 0x004e0b, 0x00, 0x004e0c, 0x5c, 0x004e0d, 0x11, 0x004e0e, 0x15,
		0x004e0f, 0x00, 0x004e10, 0x7c, 0x004e11, 0x11, 0x004e12, 0x00, 0x004e14, 0x1f, 0x004e16, 0x75,
		0x004e17, 0x4e,

		// Sprites
		0x014ca0, 0x90, 0x014ca3, 0x00, 0x014cb0, 0x90, 0x014cb3, 0x40, 0x014f68, 0xfc, 0x014f69, 0x28,
		0x014f6a, 0x00, 0x014f6d, 0x01,

		// Fix draw scroll
		0x000b98, 0xc0, 0x000ba4, 0x40, 0x000ba5, 0xd2, 0x000bc8, 0x40, 0x000bc9, 0xd2
	};

	for (INT32 i = 0; i < (sizeof(patch_fix) / sizeof(UINT32)) >> 1; i++) {
		CpsRom[patch_fix[(i << 1) + 0]] = (UINT8)patch_fix[(i << 1) + 1];
	}
}

static INT32 PunipicInit()
{
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	CpsBootlegEEPROM = 1;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = PunipicPatchCallback;
	} else {
		Cps1OverrideLayers = 1;
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	Cps1GfxLoadCallbackFunction = CpsLoadTilesDinopic;
	CpsMemScanCallbackFunction = PunipicScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, PunipicF18Read);
	SekMapHandler(2, 0x980000, 0x980fff, MAP_WRITE);
	SekSetWriteWordHandler(2, Punipic98WriteWord);
	SekMapHandler(3, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(3, PunipicFFWriteByte);
	SekSetWriteWordHandler(3, PunipicFFWriteWord);
	SekClose();
	
	return nRet;
}

static INT32 PunipicExit()
{
	PunipicPriorityValue = 0;
	
	return DrvExit();
}

static INT32 Punipic2Init()
{
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	CpsBootlegEEPROM = 1;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = PunipicPatchCallback;
	} else {
		Cps1OverrideLayers = 1;
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160Alt;
	CpsMemScanCallbackFunction = PunipicScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, PunipicF18Read);
	SekMapHandler(2, 0x980000, 0x980fff, MAP_WRITE);
	SekSetWriteWordHandler(2, Punipic98WriteWord);
	SekMapHandler(3, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(3, PunipicFFWriteByte);
	SekSetWriteWordHandler(3, PunipicFFWriteWord);
	SekClose();
	
	return nRet;
}

static INT32 Punipic3Init()
{
	Cps1DisablePSnd = 1;
	bCpsUpdatePalEveryFrame = 1;
	CpsBootlegEEPROM = 1;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = PunipicPatchCallback;
	} else {
		Cps1OverrideLayers = 1;
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	CpsMemScanCallbackFunction = PunipicScanCallback;

	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
	SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
	SekSetReadByteHandler(1, PunipicF18Read);
	SekMapHandler(2, 0x980000, 0x980fff, MAP_WRITE);
	SekSetWriteWordHandler(2, Punipic98WriteWord);
	SekMapHandler(3, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(3, PunipicFFWriteByte);
	SekSetWriteWordHandler(3, PunipicFFWriteWord);
	SekClose();

	return nRet;
}

static INT32 PunisherbInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesPunisherb;
	
	return TwelveMhzInit();
}

static INT32 QadInit()
{
	Cps1DisableBgHi = 1;

	return TwelveMhzInit();
}

static INT32 Sf2ebblInit()
{
	INT32 nRet = DrvInit();
	
	Cps1LockSpriteList910000 = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer1YOffs = 1;
	CpsLayer2XOffs = -14;
	CpsLayer2YOffs = 1;
	CpsLayer3XOffs = -16;
	CpsLayer3YOffs = 1;
	CpsDrawSpritesInReverse = 1;
	
	return nRet;
}

static INT32 Sf2ebbl2Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	
	INT32 nRet = DrvInit();
	
	Cps1LockSpriteList910000 = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return nRet;
}

static INT32 Sf2ebbl3Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2ebbl3;
	
	return Sf2ebblInit();
}

static INT32 Sf2sttInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2stt;
	
	INT32 nRet = DrvInit();
	
	Cps1LockSpriteList910000 = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer1YOffs = 1;
	CpsLayer2XOffs = -14;
	CpsLayer2YOffs = 1;
	CpsLayer3XOffs = -16;
	CpsLayer3YOffs = 1;
	CpsDrawSpritesInReverse = 1;
	
	return nRet;
}

static INT32 Sf2jcInit()
{
	Cps1DisableBgHi = 1;

	return DrvInit();
}

static void Sf2qp1Callback()
{
	UINT8 *TempRom = (UINT8*)BurnMalloc(0x100000);
	if (TempRom) {
		memcpy(TempRom, CpsRom, 0x100000);
		memset(CpsRom, 0, 0x100000);
		memcpy(CpsRom + 0x000000, TempRom + 0x000000, 0x40000);
		memcpy(CpsRom + 0x0c0000, TempRom + 0x040000, 0x40000);
		memcpy(CpsRom + 0x080000, TempRom + 0x080000, 0x40000);
		memcpy(CpsRom + 0x040000, TempRom + 0x0c0000, 0x40000);
		BurnFree(TempRom);
	}
}

static INT32 Sf2qp1Init()
{
	AmendProgRomCallback = Sf2qp1Callback;
	
	return DrvInit();
}

static INT32 Sf2thndrInit()
{
	Sf2thndr = 1;
	
	return DrvInit();
}

UINT8 __fastcall Sf2bReadByte(UINT32 a)
{
	switch (a) {
		case 0x70c000: {
			return ~Inp000;
		}
		
		case 0x70c001: {
			return ~Inp001;
		}
		
		case 0x70c008: {
			return 0xff;
		}
		
		case 0x70c009: {
			return ~Inp177;
		}
		
		case 0x70c018: {
			return ~Inp018;
		}
		
		case 0x70c01a: {
			return ~Cpi01A;
		}
		
		case 0x70c01c: {
			return ~Cpi01C;
		}
		
		case 0x70c01e: {
			return ~Cpi01E;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Read Byte %x\n"), a);
		}
	}

	return 0;
}

UINT16 __fastcall Sf2bReadWord(UINT32 a)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Read Word %x\n"), a);
		}
	}

	return 0;
}

void __fastcall Sf2bWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x70c106: {
			Sf2mdtSoundCommand(d);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall Sf2bWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x70810c: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d + 0xffbe);
			return;
		}
		
		case 0x70810e: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x708110: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d + 0xffc0);
			return;
		}
		
		case 0x708112: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			// update the row scroll start reg here as well
			*((UINT16*)(CpsReg + 0x20)) = BURN_ENDIAN_SWAP_INT16(d);
			// get the row scroll table address
			//*((UINT16*)(CpsReg + 0x08)) = *((UINT16*)(CpsRamFF + 0x8032));
			return;
		}
		
		case 0x708114: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d + 0xffbe);
			return;
		}
		
		case 0x708116: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x70814c: {
			*((UINT16*)(CpsReg + nCpsLcReg)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x70d000: {
			// nop?
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

static INT32 Sf2mdtScanCallback(INT32, INT32*);

static INT32 Sf2bInit()
{
	bCpsUpdatePalEveryFrame = 1;	
	Cps1DisablePSnd = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2mdta;
	Cps1ObjGetCallbackFunction = Sf2mdtObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = Sf2mdtSoundInit;
	CpsRunResetCallbackFunction = Sf2mdtSoundReset;
	CpsRunExitCallbackFunction = Sf2mdtSoundExit;
	CpsRunFrameStartCallbackFunction = Sf2mdtSoundFrameStart;
	CpsRunFrameEndCallbackFunction = Sf2mdtSoundFrameEnd;
	CpsRWSoundCommandCallbackFunction = Sf2mdtSoundCommand;
	CpsMemScanCallbackFunction = Sf2mdtScanCallback;
	
	INT32 nRet = DrvInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x700000, 0x703fff, MAP_RAM);
	SekMapMemory(CpsBootlegSpriteRam, 0x704000, 0x707fff, MAP_RAM); // mirror?
	SekMapHandler(1, 0x708000, 0x7fffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, Sf2bReadByte);
	SekSetReadWordHandler(1, Sf2bReadWord);
	SekSetWriteByteHandler(1, Sf2bWriteByte);
	SekSetWriteWordHandler(1, Sf2bWriteWord);
	SekClose();
	
	Cps1VBlankIRQLine = 4; // triggers the sprite ram and layer enable/scroll writes at 0x700000
	
	return nRet;
}

static INT32 Sf2b3Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2stt;
	
	return DrvInit();
}

static INT32 Sf2rulesInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return DrvInit();
}

static INT32 Sf2rkInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;

	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;

	INT32 nRet = DrvInit();

	if (!nRet) {
		INT32 *qGFX = (INT32*)CpsGfx;
		for (INT32 i = 0; i < 0x600000/4; i++) {
			if (i >= 0x400000/4 && i < 0x480000/4) continue; // unscramble range

			qGFX[i] = ((qGFX[i] >> 28) & 0xf) | ((qGFX[i] << 28) & 0xf0000000) | (qGFX[i] & 0x0ffffff0);
		}
	}

	return nRet;
}

static void Sf2accp2Callback()
{
	// This causes problems in FBA, but is ignored in MAME??
	// 011756: 66FF                       dc.w    $66ff; ILLEGAL

//	*((UINT16*)(CpsRom + 0x11756)) = 0x4e71;
}

static INT32 Sf2accp2Init()
{
	AmendProgRomCallback = Sf2accp2Callback;
	
	return TwelveMhzInit();
}

static INT32 Sf2dkot2Init()
{
	INT32 nRet;

	nRet = TwelveMhzInit();
	if (nRet) return nRet;

	SekOpen(0);
	SekMapMemory(CpsRom + 0x000000, 0x280000, 0x2fffff, MAP_ROM);
	SekMapMemory(CpsRom + 0x080000, 0x200000, 0x27ffff, MAP_ROM);
	SekClose();

	return nRet;
}

UINT8 __fastcall Sf2rbProtReadByte(UINT32 a)
{
	switch (a) {
		case 0x201201: {
			return 0x02;
		}
		
		case 0x281201: {
			return 0x40;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Prot Read Byte %x\n"), a);
		}
	}
	
	return 0;
}

UINT16 __fastcall Sf2rbProtReadWord(UINT32 a)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Prot Read Word %x\n"), a);
		}
	}
	
	return 0;
}

static void Sf2rbCallback()
{
	BurnByteswap(CpsRom, 0x100000);
}

static INT32 Sf2rbInit()
{
	AmendProgRomCallback = Sf2rbCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	SekOpen(0);
	SekMapHandler(1, 0x200000, 0x2fffff, MAP_READ);
	SekSetReadByteHandler(1, Sf2rbProtReadByte);
	SekSetReadWordHandler(1, Sf2rbProtReadWord);
	SekClose();

	return nRet;
}

UINT8 __fastcall Sf2rb2ProtReadByte(UINT32 a)
{
	switch (a) {
		case 0x201201: {
			return 0x00;
		}
		
		case 0x281201: {
			return 0x40;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Prot Read Byte %x\n"), a);
		}
	}
	
	return 0;
}

UINT16 __fastcall Sf2rb2ProtReadWord(UINT32 a)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Prot Read Word %x\n"), a);
		}
	}
	
	return 0;
}

static INT32 Sf2rb2Init()
{
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	SekOpen(0);
	SekMapHandler(1, 0x200000, 0x2fffff, MAP_READ);
	SekSetReadByteHandler(1, Sf2rb2ProtReadByte);
	SekSetReadWordHandler(1, Sf2rb2ProtReadWord);
	SekClose();

	return nRet;
}

static void Sf2rb6Callback()
{
	UINT8 *pTemp = (UINT8*)BurnMalloc(0x180000);
	
	if (pTemp) {
		memcpy(pTemp, CpsRom, 0x180000);
		memcpy(CpsRom + 0x080000, pTemp + 0x000000, 0x40000);
		memcpy(CpsRom + 0x140000, pTemp + 0x040000, 0x40000);
		memcpy(CpsRom + 0x100000, pTemp + 0x080000, 0x40000);
		memcpy(CpsRom + 0x040000, pTemp + 0x0c0000, 0x40000);
		memcpy(CpsRom + 0x000000, pTemp + 0x100000, 0x40000);
		memcpy(CpsRom + 0x0c0000, pTemp + 0x140000, 0x40000);
		BurnFree(pTemp);
	}
}

static INT32 Sf2rb6Init()
{
	AmendProgRomCallback = Sf2rb6Callback;

	return TwelveMhzInit();
}

static void Sf2yycCallback()
{
	memcpy(CpsRom + 0x140000, CpsRom + 0x100000, 0x40000);
}

static INT32 Sf2yycInit()
{
	nCpsRomLen = 0x40000;
	
	Cps1LockSpriteList910000 = 1;
	AmendProgRomCallback = Sf2yycCallback;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return TwelveMhzInit();
}

static INT32 Sf2koryuInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	
	Cps1LockSpriteList910000 = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return TwelveMhzInit();
}

static INT32 Sf2koryu2Init()
{
	Cps1LockSpriteList910000 = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return TwelveMhzInit();
}

static INT32 Sf2amfInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	
	return Sf2koryu2Init();
}

static INT32 Sf2amf2Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2stt;
	
	return Sf2koryu2Init();
}

static INT32 Sf2amf10Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2amf10;

	return Sf2koryu2Init();
}

UINT8 __fastcall Sf2mdtReadByte(UINT32 a)
{
	switch (a) {
		case 0x70c000: {
			return ~Inp000;
		}
		
		case 0x70c001: {
			return ~Inp001;
		}
		
		case 0x70c008: {
			return 0xff;
		}
		
		case 0x70c009: {
			return ~Inp177;
		}
		
		case 0x70c018: {
			return ~Inp018;
		}
		
		case 0x70c01a: {
			return ~Cpi01A;
		}
		
		case 0x70c01c: {
			return ~Cpi01C;
		}
		
		case 0x70c01e: {
			return ~Cpi01E;
		}		
		
		default: {
			bprintf(PRINT_NORMAL, _T("Read Byte %x\n"), a);
		}
	}

	return 0;
}

UINT16 __fastcall Sf2mdtReadWord(UINT32 a)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Read Word %x\n"), a);
		}
	}

	return 0;
}

void __fastcall Sf2mdtWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x70c106: {
			Sf2mdtSoundCommand(d);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall Sf2mdtWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x70810c: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d + 0xffbe);
			return;
		}
		
		case 0x70810e: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x708110: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d + 0xffc0);
			return;
		}
		
		case 0x708112: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d + 0xffbe);
			return;
		}
		
		case 0x708114: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			// update the row scroll start reg here as well
			*((UINT16*)(CpsReg + 0x20)) = BURN_ENDIAN_SWAP_INT16(d);
			// get the row scroll table address
			*((UINT16*)(CpsReg + 0x08)) = *((UINT16*)(CpsRamFF + 0x802e));
			return;
		}
		
		case 0x708116: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x70814c: {
			*((UINT16*)(CpsReg + nCpsLcReg)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x70d000: {
			// nop?
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

void __fastcall Sf2mdtaWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x70810c: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d + 0xffbe);
			return;
		}
		
		case 0x70810e: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x708110: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d + 0xffbe);
			return;
		}
		
		case 0x708112: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			// update the row scroll start reg here as well
			*((UINT16*)(CpsReg + 0x20)) = BURN_ENDIAN_SWAP_INT16(d);
			// get the row scroll table address
			*((UINT16*)(CpsReg + 0x08)) = *((UINT16*)(CpsRamFF + 0x802e));
			return;
		}
		
		case 0x708114: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x708116: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x70814c: {
			*((UINT16*)(CpsReg + nCpsLcReg)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x70d000: {
			// nop?
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

static INT32 Sf2mdtScanCallback(INT32 nAction, INT32*pnMin)
{
	CpsBootlegSpriteRamScanCallback(nAction, pnMin);
	Sf2mdtScanSound(nAction, pnMin);
	
	return 0;
}

static INT32 Sf2mdtInit()
{
	bCpsUpdatePalEveryFrame = 1;	
	Cps1DisablePSnd = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2mdt;
	Cps1ObjGetCallbackFunction = Sf2mdtObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = Sf2mdtSoundInit;
	CpsRunResetCallbackFunction = Sf2mdtSoundReset;
	CpsRunExitCallbackFunction = Sf2mdtSoundExit;
	CpsRunFrameStartCallbackFunction = Sf2mdtSoundFrameStart;
	CpsRunFrameEndCallbackFunction = Sf2mdtSoundFrameEnd;
	CpsRWSoundCommandCallbackFunction = Sf2mdtSoundCommand;
	CpsMemScanCallbackFunction = Sf2mdtScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x700000, 0x703fff, MAP_RAM);
	SekMapMemory(CpsBootlegSpriteRam, 0x704000, 0x707fff, MAP_RAM); // mirror? can use either of this - seems to make no difference
	SekMapHandler(1, 0x708000, 0x7fffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, Sf2mdtReadByte);
	SekSetReadWordHandler(1, Sf2mdtReadWord);
	SekSetWriteByteHandler(1, Sf2mdtWriteByte);
	SekSetWriteWordHandler(1, Sf2mdtWriteWord);
	SekClose();
	
	Cps1VBlankIRQLine = 4; // triggers the sprite ram and layer enable/scroll writes at 0x700000
	
	return nRet;
}

static INT32 Sf2mdtaInit()
{
	bCpsUpdatePalEveryFrame = 1;	
	Cps1DisablePSnd = 1;
	CpsLayer2XOffs = 0xffc0; // layer 2 scrolling seems to be taken care of by row scroll tables
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2mdta;
	Cps1ObjGetCallbackFunction = Sf2mdtObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = Sf2mdtSoundInit;
	CpsRunResetCallbackFunction = Sf2mdtSoundReset;
	CpsRunExitCallbackFunction = Sf2mdtSoundExit;
	CpsRunFrameStartCallbackFunction = Sf2mdtSoundFrameStart;
	CpsRunFrameEndCallbackFunction = Sf2mdtSoundFrameEnd;
	CpsRWSoundCommandCallbackFunction = Sf2mdtSoundCommand;
	CpsMemScanCallbackFunction = Sf2mdtScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x700000, 0x703fff, MAP_RAM);
	SekMapMemory(CpsBootlegSpriteRam, 0x704000, 0x707fff, MAP_RAM); // mirror? can use either of this - seems to make no difference
	SekMapMemory(CpsRamFF, 0xfc0000, 0xfcffff, MAP_RAM);	
	SekMapHandler(1, 0x708000, 0x7fffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, Sf2mdtReadByte);
	SekSetReadWordHandler(1, Sf2mdtReadWord);
	SekSetWriteByteHandler(1, Sf2mdtWriteByte);
	SekSetWriteWordHandler(1, Sf2mdtaWriteWord);
	SekClose();
	
	Cps1VBlankIRQLine = 4; // triggers the sprite ram and layer enable/scroll writes at 0x700000
	
	return nRet;
}

static INT32 Sf2mdtbInit()
{
	bCpsUpdatePalEveryFrame = 1;	
	Cps1DisablePSnd = 1;
	CpsLayer2XOffs = 0xffc0; // layer 2 scrolling seems to be taken care of by row scroll tables
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2mdt;
	Cps1ObjGetCallbackFunction = Sf2mdtObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsRunInitCallbackFunction = Sf2mdtSoundInit;
	CpsRunResetCallbackFunction = Sf2mdtSoundReset;
	CpsRunExitCallbackFunction = Sf2mdtSoundExit;
	CpsRunFrameStartCallbackFunction = Sf2mdtSoundFrameStart;
	CpsRunFrameEndCallbackFunction = Sf2mdtSoundFrameEnd;
	CpsRWSoundCommandCallbackFunction = Sf2mdtSoundCommand;
	CpsMemScanCallbackFunction = Sf2mdtScanCallback;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x700000, 0x703fff, MAP_RAM);
	SekMapMemory(CpsBootlegSpriteRam, 0x704000, 0x707fff, MAP_RAM); // mirror? can use either of this - seems to make no difference
	SekMapMemory(CpsRamFF, 0xfc0000, 0xfcffff, MAP_RAM);	
	SekMapHandler(1, 0x708000, 0x7fffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(1, Sf2mdtReadByte);
	SekSetReadWordHandler(1, Sf2mdtReadWord);
	SekSetWriteByteHandler(1, Sf2mdtWriteByte);
	SekSetWriteWordHandler(1, Sf2mdtaWriteWord);
	SekClose();
	
	Cps1VBlankIRQLine = 4; // triggers the sprite ram and layer enable/scroll writes at 0x700000
	
	return nRet;
}

void __fastcall Sf2ceeablScrollWrite(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = d;
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = d - 0x40;
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = d;
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = d - 0x3c;
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = d;
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = d - 0x40;
			return;
		}
		
		case 0x98000c: {
			// This seems to control layer order and enable
			switch (d) {
				case 0x00: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 1;
					nCps1Layers[2] = 3;
					nCps1Layers[3] = 2;
					break;
				}
				
				case 0x01: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 3;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 1;
					break;
				}
				
				case 0x02: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 1;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 0x03: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 2;
					nCps1Layers[2] = 1;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 0x04: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 0x05: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 2;
					nCps1Layers[2] = 3;
					nCps1Layers[3] = 1;
					break;
				}
				
				default: {
					nCps1Layers[0] = 0;
					nCps1Layers[1] = 3;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 1;
					bprintf(PRINT_IMPORTANT, _T("Unknown value written at 0x98000c %x\n"), d);
				}
			}
			return;
		}
		
		case 0x980016: {
			// scroll3 ram offset
			*((UINT16*)(CpsReg + 0x06)) = d;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

static INT32 Sf2ceeab2Init()
{
	Port6SoundWrite = 1;
	bCpsUpdatePalEveryFrame = 1;
	Cps1OverrideLayers = 1;
	Cps1ObjGetCallbackFunction = DinopicObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	INT32 nRet = TwelveMhzInit();

	if (!nRet) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

		SekOpen(0);
		SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
		SekMapHandler(1, 0x980000, 0x980fff, MAP_WRITE);
		SekSetWriteWordHandler(1, Sf2ceeablScrollWrite);
		SekClose();
	}

	return nRet;
}

static INT32 Sf2ceeablInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2ceeabl;
	
	return Sf2ceeab2Init();
}

static INT32 Sf2cejablInit()
{
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return TwelveMhzInit();
}

UINT8 __fastcall Sf2ceuablReadByte(UINT32 a)
{
	UINT8 d = 0xff;
	
	switch (a) {
		case 0x800010: {
			d = (UINT8)~Inp010;
			return d;
		}
		
		case 0x800011: {
			d = (UINT8)~Inp011;
			return d;
		}
		
		case 0x800029: {
			d = (UINT8)~Inp029;
			return d;
		}
		
		case 0x800186: {
			d = (UINT8)~Inp186;
			return d;
		}
		
		case 0x80002a: {
			d = (UINT8)~Cpi01A;
			return d;
		}
		
		case 0x80002c: {
			d = (UINT8)~Cpi01C;
			return d;
		}
		
		case 0x80002e: {
			d = (UINT8)~Cpi01E;
			return d;
		}
	}
	
//	bprintf(PRINT_NORMAL, _T("Read byte %x\n"), a);
	
	return 0;
}

void __fastcall Sf2ceuablWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x800191: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d;
			return;
		}
	}
	
//	bprintf(PRINT_NORMAL, _T("Write byte %x, %x\n"), a, d);
}

void __fastcall Sf2ceuablWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x800100: {
			CpsReg[0x00] = d & 0xff;
			CpsReg[0x01] = d >> 8;
			return;
		}
		
		case 0x800102: {
			CpsReg[0x02] = d & 0xff;
			CpsReg[0x03] = d >> 8;
			return;
		}
		
		case 0x800104: {
			CpsReg[0x04] = d & 0xff;
			CpsReg[0x05] = d >> 8;
			return;
		}
		
		case 0x800106: {
			CpsReg[0x06] = d & 0xff;
			CpsReg[0x07] = d >> 8;
			return;
		}
		
		case 0x80010a: {
			CpsReg[0x0a] = d & 0xff;
			CpsReg[0x0b] = d >> 8;
			
			GetPalette(0, 6);
			CpsPalUpdate(CpsSavePal);
			return;
		}
		
		case 0x800122: {
			CpsReg[0x22] = d & 0xff;
			CpsReg[0x23] = d >> 8;
			return;
		}
		
		case 0x80014a: {
			CpsReg[0x4a] = d & 0xff;
			CpsReg[0x4b] = d >> 8;
			return;
		}
		
		case 0x80014c: {
			CpsReg[0x4c] = d & 0xff;
			CpsReg[0x4d] = d >> 8;
			return;
		}
		
		case 0x80014e: {
			CpsReg[0x4e] = d & 0xff;
			CpsReg[0x4f] = d >> 8;
			return;
		}
		
		case 0x800150: {
			CpsReg[0x50] = d & 0xff;
			CpsReg[0x51] = d >> 8;
			return;
		}
		
		case 0x800152: {
			CpsReg[0x52] = d & 0xff;
			CpsReg[0x53] = d >> 8;
			return;
		}
		
		case 0x8001a8: {
			CpsReg[0x08] = d & 0xff;
			CpsReg[0x09] = d >> 8;
			return;
		}
		
		case 0x8001ac: {
			CpsReg[0x0c] = d & 0xff;
			CpsReg[0x0d] = d >> 8;
			return;
		}
		
		case 0x8001ae: {
			CpsReg[0x0e] = d & 0xff;
			CpsReg[0x0f] = d >> 8;
			return;
		}
		
		case 0x8001b0: {
			CpsReg[0x10] = d & 0xff;
			CpsReg[0x11] = d >> 8;
			return;
		}
		
		case 0x8001b2: {
			CpsReg[0x12] = d & 0xff;
			CpsReg[0x13] = d >> 8;
			return;
		}
		
		case 0x8001b4: {
			CpsReg[0x14] = d & 0xff;
			CpsReg[0x15] = d >> 8;
			return;
		}
		
		case 0x8001b6: {
			CpsReg[0x16] = d & 0xff;
			CpsReg[0x17] = d >> 8;
			return;
		}
		
		case 0x8001c0: {
			CpsReg[0x20] = d & 0xff;
			CpsReg[0x21] = d >> 8;
			return;
		}	
		
		case 0x8001c4: {
			CpsReg[0xc4] = d & 0xff;
			CpsReg[0xc5] = d >> 8;
			return;
		}
	}
	
//	bprintf(PRINT_NORMAL, _T("Write word %x, %x\n"), a, d);
}

static INT32 Sf2ceuablInit()
{
	INT32 nRet = 0;
	
	CpsLayer1XOffs = -16;
	CpsLayer2XOffs = -16;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	nRet = TwelveMhzInit();

	if (!nRet) {
		SekOpen(0);
		SekMapHandler(1, 0x800000, 0x800200, MAP_RAM);
		SekSetReadByteHandler(1, Sf2ceuablReadByte);
		SekSetWriteByteHandler(1, Sf2ceuablWriteByte);
		SekSetWriteWordHandler(1, Sf2ceuablWriteWord);
		SekClose();
	}

	return nRet;
}

static INT32 Sf2ceuab2Init()
{
	Scroll1TileMask = 0x4fff;
	Scroll3TileMask = 0x1fff;
	
	return Sf2ceuablInit();
}

static INT32 Sf2ceuab3Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2m8;
	
	return Sf2ceuablInit();
}

static INT32 Sf2ceuab4Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	
	return Sf2ceuablInit();
}

static INT32 Sf2reInit()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	
	return Sf2ceuablInit();
}

static void Sf2ceuab6Callback()
{
	memcpy(CpsRom + 0x0c0000, CpsRom + 0x140000, 0x40000);
}

static INT32 Sf2ceuab6Init()
{
	AmendProgRomCallback = Sf2ceuab6Callback;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2ceeabl;
	
	return TwelveMhzInit();
}

static UINT16 Sf2ceuab7ProtValue = 0;

UINT16 __fastcall Sf2ceuab7ProtReadWord(UINT32 a)
{
	switch (a) {
		case 0x5762b0: {
			return 0;
		}
		
		case 0x57a2b0: {
			if (Sf2ceuab7ProtValue == 0x00) return 0x1992;
			if (Sf2ceuab7ProtValue == 0x04) return 0x0408;
			return 0xffff;
		}
	}
	
	return 0;
}

void __fastcall Sf2ceuab7ProtWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x5762b0: {
			Sf2ceuab7ProtValue = d;
			return;
		}
	}
}

static INT32 Sf2ceuab7Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2ceuab7;
	
	INT32 nRet = DrvInit();

	if (!nRet) {
		SekOpen(0);
		SekMapHandler(1, 0x570000, 0x57ffff, MAP_READ | MAP_WRITE);
		SekSetReadWordHandler(1, Sf2ceuab7ProtReadWord);
		SekSetWriteWordHandler(1, Sf2ceuab7ProtWriteWord);
		SekClose();
	}

	return nRet;
}

void __fastcall Sf2ceuab8WriteByte(UINT32 a, UINT8 d)
{
	CpsWritePort(a & 0x1ff, d);
}

void __fastcall Sf2ceuab8WriteWord(UINT32 a, UINT16 d)
{
	if (a == 0x8001b2) {
		// scroll 2 X offset has moved in this set
		*((UINT16*)(CpsReg + 0x10)) = d;
		return;
	}
	
	SEK_DEF_WRITE_WORD(1, a, d);
}

static INT32 Sf2ceuab8Init()
{
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSf2koryu;
	CpsDrawSpritesInReverse = 1;
	CpsLayer1XOffs = -16;
	CpsLayer2XOffs = -16;
	CpsLayer3XOffs = -16;
	
	INT32 nRet = TwelveMhzInit();
	
	if (!nRet) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x110000); // not sprite ram - but we'll use this for convenience

		SekOpen(0);
		SekMapHandler(1, 0x800000, 0x807fff, MAP_WRITE);
		SekSetWriteByteHandler(1, Sf2ceuab8WriteByte);
		SekSetWriteWordHandler(1, Sf2ceuab8WriteWord);
		SekMapMemory(CpsBootlegSpriteRam + 0x000000, 0xe00000, 0xefffff, MAP_RAM);
		SekMapMemory(CpsBootlegSpriteRam + 0x100000, 0xfe0000, 0xfeffff, MAP_RAM);
		SekClose();
	}

	return nRet;
}

static INT32 Sf2ceuab9Init()
{
	CpsDrawSpritesInReverse = 1;
	CpsLayer1XOffs = -16;
	CpsLayer2XOffs = -16;
	CpsLayer3XOffs = -16;
	
	INT32 nRet = TwelveMhzInit();
	
	if (!nRet) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x110000); // not sprite ram - but we'll use this for convenience

		SekOpen(0);
		SekMapHandler(1, 0x800000, 0x807fff, MAP_WRITE);
		SekSetWriteByteHandler(1, Sf2ceuab8WriteByte);
		SekSetWriteWordHandler(1, Sf2ceuab8WriteWord);
		SekMapMemory(CpsBootlegSpriteRam + 0x000000, 0xe00000, 0xefffff, MAP_RAM);
		SekMapMemory(CpsBootlegSpriteRam + 0x100000, 0xfe0000, 0xfeffff, MAP_RAM);
		SekClose();
	}

	return nRet;
}

static void Sf2ceucblCallback()
{
	memcpy(CpsRom + 0x000000, CpsRom + 0x180000, 0x40000);
	memcpy(CpsRom + 0x080000, CpsRom + 0x1c0000, 0x40000);
	memcpy(CpsRom + 0x100000, CpsRom + 0x200000, 0x40000);
}

static INT32 Sf2ceucblInit()
{
	AmendProgRomCallback = Sf2ceucblCallback;
	
	return TwelveMhzInit();
}

UINT8 __fastcall Sf2dongbProtReadByte(UINT32 a)
{
	switch (a) {
		default: {
			bprintf(PRINT_NORMAL, _T("Prot Read Byte %x\n"), a);
		}
	}
	
	return 0;
}

UINT16 __fastcall Sf2dongbProtReadWord(UINT32 a)
{
	switch (a) {
		case 0x180000: {
			return 0x0200;
		}
		
		case 0x1f7040: {
			return 0x0210;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Prot Read Word %x\n"), a);
		}
	}
	
	return 0;
}

static INT32 Sf2dongbInit()
{
	INT32 nRet = TwelveMhzInit();

	if (!nRet) {
		SekOpen(0);
		SekMapHandler(1, 0x180000, 0x1fffff, MAP_READ);
		SekSetReadByteHandler(1, Sf2dongbProtReadByte);
		SekSetReadWordHandler(1, Sf2dongbProtReadWord);
		SekClose();
	}

	return nRet;
}

static INT32 Sf2bhhInit()
{
	AmendProgRomCallback = Sf2qp1Callback;

	return TwelveMhzInit();
}

static INT32 Sf2hfInit()
{
	// game runs too fast - RN compared MAME/FBA to PCB
	// RN January 2021 research: 0 frame diff https://youtu.be/nuobplWeBTI?t=88
	
	nCPS68KClockspeed = 8500000;
	
	return DrvInit();
}

static void Sf2hfubCallback()
{
	UINT8 *pTemp = (UINT8*)BurnMalloc(0x40000);
	
	if (pTemp) {
		memcpy(pTemp, CpsRom + 0xc0000, 0x40000);
		memcpy(CpsRom + 0xc0000, CpsRom + 0x140000, 0x40000);
		memcpy(CpsRom + 0x140000, pTemp, 0x40000);
		BurnFree(pTemp);
	}
}

static INT32 Sf2hfubInit()
{
	AmendProgRomCallback = Sf2hfubCallback;
	
	return Sf2hfInit();
}

void __fastcall Sf2hfjbWriteByte(UINT32 a, UINT8 d)
{
	CpsWritePort(a & 0x1ff, d);
}

void __fastcall Sf2hfjbWriteWord(UINT32 a, UINT16 d)
{
	if (a == 0x800124) {
		// row scroll start register moved in this set
		*((UINT16*)(CpsReg + 0x20)) = d;
		return;
	}
	
	SEK_DEF_WRITE_WORD(1, a, d);
}

static INT32 Sf2hfjbInit()
{
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	INT32 nRet = Sf2hfInit();

	if (!nRet) {
		SekOpen(0);
		SekMapHandler(1, 0x800000, 0x807fff, MAP_WRITE);
		SekSetWriteByteHandler(1, Sf2hfjbWriteByte);
		SekSetWriteWordHandler(1, Sf2hfjbWriteWord);
		SekClose();
	}

	return nRet;
}

static INT32 SfzchInit()
{
	INT32 nRet = 0;
	
	nRet = TwelveMhzInit();
	
	Cps = 3;
	
	return nRet;
}

UINT8 __fastcall SlampicF18Read(UINT32)
{
	return 0xff;
}

void __fastcall SlampicScrollWrite(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x98000c: {
			// scroll 2 ram offset
			*((UINT16*)(CpsReg + 0x04)) = BURN_ENDIAN_SWAP_INT16(d << 4);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

void __fastcall SlampicFFWriteByte(UINT32 a, UINT8 d)
{
	CpsRamFF[((a & 0xffff) ^ 1)] = d;
}

void __fastcall SlampicFFWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0xff8d74: {
			*((UINT16*)(CpsReg + MaskAddr[1])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff8d76: {
			*((UINT16*)(CpsReg + MaskAddr[2])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff8d78: {
			*((UINT16*)(CpsReg + MaskAddr[3])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
	}
	
	UINT16 *RAM = (UINT16*)CpsRamFF;
	RAM[((a & 0xffff) >> 1)] = d;
}

static void SlampicPatchCallback()
{
	UINT32 patch_fix[] = {
		// Fix sound
		0x000666, 0xed, 0x000668, 0x74, 0x000669, 0x0d, 0x00066a, 0x80, 0x00066c, 0x42, 0x00066d, 0x01,
		0x00066e, 0xed, 0x00066f, 0x33, 0x000670, 0x76, 0x000671, 0x0d, 0x000672, 0x80, 0x000673, 0x00,
		0x000674, 0x68, 0x000675, 0x01, 0x000676, 0xed, 0x000677, 0x33, 0x000678, 0x78, 0x000679, 0x0d,
		0x00067a, 0x80, 0x00067b, 0x00, 0x00067c, 0x6a, 0x00067d, 0x01, 0x00067e, 0xed, 0x00067f, 0x33,
		0x000680, 0x72, 0x000681, 0x0d, 0x000682, 0x80, 0x000684, 0x56, 0x000685, 0x01, 0x000686, 0xed,
		0x000687, 0x33, 0x000688, 0xa0, 0x000689, 0x0d, 0x00068a, 0x80, 0x00068d, 0x01, 0x00068e, 0xfc,
		0x00068f, 0x33, 0x000690, 0x3f, 0x000691, 0x00, 0x000692, 0x80, 0x000693, 0x00, 0x000876, 0x80,
		0x000878, 0x0c, 0x000879, 0x01, 0x000888, 0x80, 0x00088a, 0x10, 0x00088b, 0x01, 0x00089a, 0x80,
		0x00089c, 0x14, 0x00089d, 0x01, 0x0008a8, 0x80, 0x0008aa, 0x0e, 0x0008ab, 0x01, 0x0008bc, 0x80,
		0x0008be, 0x12, 0x0008bf, 0x01, 0x0008d0, 0x80, 0x0008d2, 0x16, 0x0008d3, 0x01, 0x0404de, 0xfc,
		0x0404df, 0x20, 0x0404e0, 0x00, 0x0404e2, 0x00, 0x0404e3, 0x01,

		// Fix draw scroll
		0x000866, 0xc0, 0x000867, 0xff
	};

	for (INT32 i = 0; i < (sizeof(patch_fix) / sizeof(UINT32)) >> 1; i++) {
		CpsRom[patch_fix[(i << 1) + 0]] = (UINT8)patch_fix[(i << 1) + 1];
	}
}

static INT32 SlampicInit()
{
	Cps1DisablePSnd = 1;
	CpsBootlegEEPROM = 1;
	bCpsUpdatePalEveryFrame = 1;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesSlampic;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = SlampicPatchCallback;
	} else {
		Cps1ObjGetCallbackFunction = Sf2mdtObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;

	INT32 nRet = TwelveMhzInit();

	if (!nRet) {
		if (Cps1QSDip ^ 1) {
			for (INT32 i = 0x7fff; i >= 0; i--) {
				CpsZRom[(i << 1) + 0] = CpsZRom[i];
				CpsZRom[(i << 1) + 1] = 0xff;
			}
		}
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

		SekOpen(0);
		if (Cps1QSDip ^ 1)
			SekMapMemory(CpsZRom, 0xf00000, 0xf0ffff, MAP_ROM);
		SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
		SekMapHandler(1, 0xf18000, 0xf19fff, MAP_READ);
		if (Cps1QSDip ^ 1)
			SekSetReadByteHandler(1, SlampicF18Read);
		SekMapHandler(2, 0xf1e000, 0xf1ffff, MAP_READ);
		if (Cps1QSDip ^ 1)
			SekSetReadByteHandler(2, SlampicF18Read);
		SekMapHandler(3, 0x980000, 0x980fff, MAP_WRITE);
		if (Cps1QSDip ^ 1)
			SekSetWriteWordHandler(3, SlampicScrollWrite);
		SekMapHandler(4, 0xff0000, 0xffffff, MAP_WRITE);
		SekSetWriteByteHandler(4, SlampicFFWriteByte);
		SekSetWriteWordHandler(4, SlampicFFWriteWord);
		SekClose();
	}
	return nRet;
}

static INT32 StriderInit()
{
	INT32 nRet = 0;
	
	nRet = Cps1RasterInit();

	if (!nRet) {
		CpsStar = CpsGfx + nCpsGfxLen - 0x2000;

		CpsLoadStars(CpsStar, 5);
	}

	return nRet;
}

static INT32 StriderjrInit()
{
	INT32 nRet = 0;
	
	nRet = TwelveMhzInit();

	if (!nRet) {
		CpsStar = CpsGfx + nCpsGfxLen - 0x2000;

		CpsLoadStars(CpsStar, 2);

		Cps1DrawAtVblank = 1;
	}

	return nRet;
}

static INT32 StriderjInit()
{
	INT32 nRet = 0;
	
	nRet = Cps1RasterInit();

	if (!nRet) {
		CpsStar = CpsGfx + nCpsGfxLen - 0x2000;

		CpsLoadStarsByte(CpsStar, 8);
	}

	return nRet;
}

void __fastcall VarthbScrollWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d - 0x40);
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write Word %x, %x\n"), a, d);
		}
	}
}

void __fastcall VarthbRegWriteByte(UINT32 a, UINT8 d)
{
	CpsWritePort(a & 0x1ff, d);
}

void __fastcall VarthbRegWriteWord(UINT32 a, UINT16 d)
{
	if (a == 0x800188) {
		if (d > 0x9000) {
			// scroll 3 ram offset
			*((UINT16*)(CpsReg + 0x06)) = d;
			return;
		} // sound fade command written through CpsWritePort
	}
	
	SEK_DEF_WRITE_WORD(2, a, d);
}

static INT32 VarthbInit()
{
	INT32 nRet = 0;
	
	Port6SoundWrite = 1;
	Cps1ObjGetCallbackFunction = DinopicObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);
	
	SekOpen(0);
	SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
	SekMapHandler(1, 0x980000, 0x980fff, MAP_WRITE);
	SekSetWriteWordHandler(1, VarthbScrollWriteWord);
	SekMapHandler(2, 0x800000, 0x807fff, MAP_WRITE);
	SekSetWriteByteHandler(2, VarthbRegWriteByte);
	SekSetWriteWordHandler(2, VarthbRegWriteWord);
	SekClose();
	
	return nRet;
}

static INT32 WofchInit()
{
	INT32 nRet = 0;

	Cps1Qs = 1;
	
	nRet = TwelveMhzInit();
	
	Cps = 3;
	
	return nRet;
}

static UINT8 WofhProtValue;

UINT8 __fastcall Wofh135ReadByte(UINT32)
{
	return 0xff;
}

UINT16 __fastcall Wofh135ReadWord(UINT32)
{
	return 0xffff;
}

UINT8 __fastcall WofhInputReadByte(UINT32 a)
{
	switch (a) {
		case 0x880000: {
			return ~Inp000;
		}
		
		case 0x880001: {
			return ~Inp001;
		}
		
		case 0x880006: {
			return ~Inp018;
		}
		
		case 0x880007: {
			return ~Inp177;
		}
		
		case 0x880008: {
			return ~Cpi01A;
		}
		
		case 0x88000a: {
			return ~Cpi01C;
		}
		
		case 0x88000c: {
			return ~Cpi01E;
		}

		case 0x880e78: {
			return WofhProtValue; // protection
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Byte %x\n"), a);
		}
	}
	
	return 0x00;
}

UINT16 __fastcall WofhInputReadWord(UINT32 a)
{
	SEK_DEF_READ_WORD(3, a);
}

void __fastcall WofhInputWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x88000e: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall WofhInputWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x88000e: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d & 0xff;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write word %x, %x\n"), a, d);
		}
	}
}

void __fastcall Wofr1blFFWriteByte(UINT32 a, UINT8 d)
{
	CpsRamFF[((a & 0xffff) ^ 1)] = d;
}

void __fastcall Wofr1blFFWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0xff639a: {
			*((UINT16*)(CpsReg + MaskAddr[1])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff639c: {
			*((UINT16*)(CpsReg + MaskAddr[2])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
		
		case 0xff639e: {
			*((UINT16*)(CpsReg + MaskAddr[3])) = BURN_ENDIAN_SWAP_INT16(d);
			break;
		}
	}
	
	UINT16 *RAM = (UINT16*)CpsRamFF;
	RAM[((a & 0xffff) >> 1)] = d;
}

static void WofhPatch()
{
	// The following patches fix the boss not coming out on 1st stage, and maybe also fix other things. They are from FBAS.
	CpsRom[0x10cdc] = 0x12;
	CpsRom[0x10cdd] = 0xc1;
	CpsRom[0x10cde] = 0x12;
	CpsRom[0x10cdf] = 0x8d;
	CpsRom[0x10cea] = 0x14;
	CpsRom[0x10ceb] = 0xc1;
	CpsRom[0x10cec] = 0x14;
	CpsRom[0x10ced] = 0x8d;
	CpsRom[0x147f0] = 0xae;
	CpsRom[0x147f1] = 0x01;
	CpsRom[0x147f2] = 0x1e;
	CpsRom[0x147f3] = 0x00;
	CpsRom[0x147f4] = 0x28;
	CpsRom[0x147f5] = 0x54;
	CpsRom[0x147f7] = 0x00;
	CpsRom[0x14800] = 0x28;
	CpsRom[0x14801] = 0x54;
	CpsRom[0x14803] = 0x00;
}

static INT32 WofhInit()
{
	INT32 nRet = 0;

	WofhProtValue = 0xd0;

	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	AmendProgRomCallback = WofhPatch;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(3, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(3, WofhInputReadByte);
	SekSetReadWordHandler(3, WofhInputReadWord);
	SekSetWriteByteHandler(3, WofhInputWriteByte);
	SekSetWriteWordHandler(3, WofhInputWriteWord);
	SekMapHandler(4, 0x135000, 0x135fff, MAP_READ);
	SekSetReadByteHandler(4, Wofh135ReadByte);
	SekSetReadWordHandler(4, Wofh135ReadWord);
	SekMapHandler(5, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(5, Wofr1blFFWriteByte);
	SekSetWriteWordHandler(5, Wofr1blFFWriteWord);
	SekClose();
	
	return nRet;
}

static void SgyxzPatch()
{
	// This fixes sprite ram clearing - shouldn't be necessary, but used for now pending understanding of the underlying issue
	CpsRom[0x2449] = 0x07;
}

static void SgyxzCallback()
{
	UINT8 *pTemp = (UINT8*)BurnMalloc(0x40000);
	
	if (pTemp) {
		memcpy(pTemp           , CpsRom + 0x40000, 0x40000);
		memcpy(CpsRom + 0x40000, CpsRom + 0x80000, 0x40000);
		memcpy(CpsRom + 0x80000, pTemp           , 0x40000);
		BurnFree(pTemp);
	}
	
	SgyxzPatch();
}

static void __fastcall SgyxzSpriteRamWriteLong(UINT32 a, UINT32 d)
{
	if (d == 0xffffffff) d = 0xefffefff; // Strange protection or glitch???

	*((UINT32*)(CpsRam90 + (a & 0x3fffc))) = (d << 16) | (d >> 16);
}

static INT32 SgyxzInit()
{
	INT32 nRet = 0;

	WofhProtValue = 0xD0;

	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	AmendProgRomCallback = SgyxzCallback;
	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(3, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(3, WofhInputReadByte);
	SekSetReadWordHandler(3, WofhInputReadWord);
	SekSetWriteByteHandler(3, WofhInputWriteByte);
	SekSetWriteWordHandler(3, WofhInputWriteWord);
	SekMapHandler(4, 0x135000, 0x135fff, MAP_READ);
	SekSetReadByteHandler(4, Wofh135ReadByte);
	SekSetReadWordHandler(4, Wofh135ReadWord);
	SekMapHandler(5, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(5, Wofr1blFFWriteByte);
	SekSetWriteWordHandler(5, Wofr1blFFWriteWord);
	SekMapHandler(6, 0x900000, 0x9007FF, MAP_WRITE);
	SekSetWriteLongHandler(6, SgyxzSpriteRamWriteLong);
	SekClose();

	return nRet;
}

static void Wof3jsCallback()
{
	memcpy(CpsRom + 0x0c0000, CpsRom + 0x100000, 0x40000);
	memset(CpsRom + 0x100000, 0, 0x40000);
}

static INT32 Wof3jsInit()
{
	AmendProgRomCallback = Wof3jsCallback;
	
	return TwelveMhzInit();
}

static INT32 Wof3jsaInit()
{
	AmendProgRomCallback = SgyxzCallback;

	WofhProtValue = 0x50;

	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(3, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(3, WofhInputReadByte);
	SekSetReadWordHandler(3, WofhInputReadWord);
	SekSetWriteByteHandler(3, WofhInputWriteByte);
	SekSetWriteWordHandler(3, WofhInputWriteWord);
	SekMapHandler(4, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(4, Wofr1blFFWriteByte);
	SekSetWriteWordHandler(4, Wofr1blFFWriteWord);
	SekClose();
	
	return nRet;
}

UINT8 __fastcall Wof3sjInputReadByte(UINT32 a)
{
	switch (a) {
		case 0x880000: {
			return ~Inp000;
		}
		
		case 0x880001: {
			return ~Inp001;
		}
		
		case 0x880008: {
			return ~Inp018;
		}
		
		case 0x880009: {
			return ~Inp177;
		}
		
		case 0x88000a: {
			return ~Cpi01A;
		}
		
		case 0x88000c: {
			return ~Cpi01C;
		}
		
		case 0x88000e: {
			return ~Cpi01E;
		}
		
		case 0x880c1e: {
			return 0xff;
		}
		
		case 0x880e7e: {
			return 0xff;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Byte %x\n"), a);
		}
	}
	
	return 0;
}

UINT16 __fastcall Wof3sjInputReadWord(UINT32 a)
{
	SEK_DEF_READ_WORD(3, a);
}

void __fastcall Wof3sjInputWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x880006: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall Wof3sjInputWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x880006: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d & 0xff;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write word %x, %x\n"), a, d);
		}
	}
}

static INT32 Wof3sjInit()
{
	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	Cps1GfxLoadCallbackFunction = CpsLoadTilesHack160;
	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(3, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(3, Wof3sjInputReadByte);
	SekSetReadWordHandler(3, Wof3sjInputReadWord);
	SekSetWriteByteHandler(3, Wof3sjInputWriteByte);
	SekSetWriteWordHandler(3, Wof3sjInputWriteWord);
	SekMapHandler(4, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(4, Wofr1blFFWriteByte);
	SekSetWriteWordHandler(4, Wofr1blFFWriteWord);
	SekClose();
	
	return nRet;
}

static INT32 WofsjInit()
{
	bCpsUpdatePalEveryFrame = 1;
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	
	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(3, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(3, Wof3sjInputReadByte);
	SekSetReadWordHandler(3, Wof3sjInputReadWord);
	SekSetWriteByteHandler(3, Wof3sjInputWriteByte);
	SekSetWriteWordHandler(3, Wof3sjInputWriteWord);
	SekMapHandler(4, 0xff0000, 0xffffff, MAP_WRITE);
	SekSetWriteByteHandler(4, Wofr1blFFWriteByte);
	SekSetWriteWordHandler(4, Wofr1blFFWriteWord);
	SekClose();
	
	return nRet;
}

static void WofsjbPatchCallback()
{
	UINT16 patch_fix[] = {
		0x5a1a, 0x00, 0x5a1b, 0x67, 0x5a1c, 0x56, 0x5a1d, 0x00, 0x5a1e, 0x7c, 0x5a1f, 0x20,
		0x5a20, 0xf1, 0x5a21, 0x00, 0x5a22, 0x00, 0x5a23, 0x80, 0x5a24, 0x28, 0x5a25, 0x4a,
		0x5a26, 0x1f, 0x5a28, 0x00, 0x5a29, 0x6a, 0x5a40, 0x5c, 0x5a41, 0x11, 0x5a42, 0x01,
		0x5a44, 0x5c, 0x5a45, 0x11, 0x5a46, 0x03, 0x5a47, 0x00, 0x5a4a, 0x07, 0x5a4c, 0x5c,
		0x5a4d, 0x11, 0x5a4e, 0x09, 0x5a4f, 0x00, 0x5a50, 0x5c, 0x5a51, 0x31, 0x5a52, 0x31,
		0x5a52, 0x0c, 0x5a54, 0x5c, 0x5a55, 0x11, 0x5a56, 0x0f, 0x5a57, 0x00, 0x5a58, 0x5c,
		0x5a59, 0x11, 0x72a3, 0x60, 0x72a4, 0x42, 0x72a6, 0x71, 0x72a8, 0x71, 0x72a9, 0x4e,
		0x72aa, 0x71, 0x72ab, 0x4e, 0x72ac, 0x71, 0x72ae, 0x71, 0x72af, 0x4e, 0x72b0, 0x71,
		0x72b1, 0x4e, 0x72b2, 0x39, 0x72b3, 0x30, 0x72b4, 0xf1, 0x72b5, 0x00, 0x72b6, 0xfe,
		0x72b7, 0x9f, 0x72b8, 0x00, 0x72b9, 0x0c
	};

	for (INT32 i = 0; i < (sizeof(patch_fix) / sizeof(UINT16)) >> 1; i++) {
		CpsRom[patch_fix[(i << 1) + 0]] = (UINT8)patch_fix[(i << 1) + 1];
	}
}

static INT32 WofsjbInit()
{
	CpsLayer1XOffs = 2;
	CpsLayer2XOffs = 4;
	CpsLayer3XOffs = 8;

	Cps1DisablePSnd = 1;

	if (Cps1QSDip & 1)
		AmendProgRomCallback = WofsjbPatchCallback;

	return TwelveMhzInit();
}

void __fastcall Wofr1bl98WriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x980000: {
			// scroll1 y
			*((UINT16*)(CpsReg + 0x0e)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980002: {
			// scroll1 x
			*((UINT16*)(CpsReg + 0x0c)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980004: {
			// scroll2 y
			*((UINT16*)(CpsReg + 0x12)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980006: {
			// scroll2 x
			*((UINT16*)(CpsReg + 0x10)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x980008: {
			// scroll3 y
			*((UINT16*)(CpsReg + 0x16)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000a: {
			// scroll3 x
			*((UINT16*)(CpsReg + 0x14)) = BURN_ENDIAN_SWAP_INT16(d);
			return;
		}
		
		case 0x98000c: {
			switch (d) {
				case 0x00:
				case 0x04:
				case 0x06:
				case 0x08:
				case 0x0a:
				case 0x0b:
				case 0x0e: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					break;
				}
				
				case 0x01:
				case 0x05:
				case 0x0f: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 3;
					nCps1Layers[3] = 2;
					break;
				}
				
				case 0x03:
				case 0x07:
				case 0x09: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 3;
					nCps1Layers[2] = 0;
					nCps1Layers[3] = 2;
					break;
				}
				
				default: {
					nCps1Layers[0] = 1;
					nCps1Layers[1] = 0;
					nCps1Layers[2] = 2;
					nCps1Layers[3] = 3;
					bprintf(PRINT_IMPORTANT, _T("Unknown value written at 0x98000c %x\n"), d);
				}
			}
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Write word %x, %x\n"), a, d);
		}
	}
}

static void WofpicPatchCallback()
{
	UINT32 patch_fix[] = {
		0x000506, 0xe7, 0x000507, 0x48, 0x000508, 0xfe, 0x000509, 0xff, 0x00050a, 0xf8, 0x00050b, 0x4b,
		0x006abc, 0x06, 0x006abd, 0x01, 0x00764e, 0x71, 0x007650, 0x71, 0x007651, 0x4e, 0x05d236, 0xfc,
		0x05d237, 0x28, 0x05d238, 0x00, 0x05d23b, 0x01
	};

	for (INT32 i = 0; i < (sizeof(patch_fix) / sizeof(UINT32)) >> 1; i++) {
		CpsRom[patch_fix[(i << 1) + 0]] = (UINT8)patch_fix[(i << 1) + 1];
	}
}

static INT32 Wofr1blInit()
{
	bCpsUpdatePalEveryFrame = 1;
	CpsBootlegEEPROM = 1;
	if (Cps1QSDip & 1) {
		AmendProgRomCallback = WofpicPatchCallback;
	} else {
		Cps1OverrideLayers = 1;
		Port6SoundWrite = 1;
		CpsLayer1XOffs = 0xffc0;
		CpsLayer2XOffs = 0xffc0;
		CpsLayer3XOffs = 0xffc0;
		Cps1ObjGetCallbackFunction = DinopicObjGet;
		Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	}
	Cps1GfxLoadCallbackFunction = CpsLoadTilesDinopic;
	CpsMemScanCallbackFunction = CpsBootlegSpriteRamScanCallback;

	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;

	if (Cps1QSDip ^ 1) {
		CpsBootlegSpriteRam = (UINT8*)BurnMalloc(0x4000);

		SekOpen(0);
		SekMapMemory(CpsBootlegSpriteRam, 0x990000, 0x993fff, MAP_RAM);
		SekMapHandler(1, 0x980000, 0x98ffff, MAP_WRITE);
		SekSetWriteWordHandler(1, Wofr1bl98WriteWord);
		SekMapHandler(2, 0xff0000, 0xffffff, MAP_WRITE);
		SekSetWriteByteHandler(2, Wofr1blFFWriteByte);
		SekSetWriteWordHandler(2, Wofr1blFFWriteWord);
		SekClose();

		// scroll3 ram offset
		*((UINT16*)(CpsReg + 0x06)) = BURN_ENDIAN_SWAP_INT16(0x9100);
	}
	return nRet;
}

UINT8 __fastcall WofablInputReadByte(UINT32 a)
{
	switch (a) {
		case 0x880000: {
			return ~Inp000;
		}
		
		case 0x880001: {
			return ~Inp001;
		}
		
		case 0x880008: {
			return ~Inp018;
		}
		
		case 0x880009: {
			return ~Inp177;
		}
		
		case 0x88000a: {
			return ~Cpi01A;
		}
		
		case 0x88000c: {
			return ~Cpi01C;
		}
		
		case 0x88000e: {
			return ~Cpi01E;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Read Byte %x\n"), a);
		}
	}
	
	return 0x00;
}

UINT16 __fastcall WofablInputReadWord(UINT32 a)
{
	SEK_DEF_READ_WORD(3, a);
}

void __fastcall WofablInputWriteByte(UINT32 a, UINT8 d)
{
	switch (a) {
		case 0x880006: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write Byte %x, %x\n"), a, d);
		}
	}
}

void __fastcall WofablInputWriteWord(UINT32 a, UINT16 d)
{
	switch (a) {
		case 0x880006: {
			PsndSyncZ80((INT64)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d & 0xff;
			return;
		}
		
		default: {
			bprintf(PRINT_NORMAL, _T("Input Write word %x, %x\n"), a, d);
		}
	}
}

static INT32 WofablInit()
{
	bCpsUpdatePalEveryFrame = 1;
	CpsBootlegEEPROM = 1;
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	
	Cps1GfxLoadCallbackFunction = CpsLoadTilesWofabl;
	Cps1ObjGetCallbackFunction = WofhObjGet;
	Cps1ObjDrawCallbackFunction = FcrashObjDraw;
	
	INT32 nRet = TwelveMhzInit();
	if (nRet) return nRet;
	
	SekOpen(0);
	SekMapHandler(3, 0x880000, 0x89ffff, MAP_READ | MAP_WRITE);
	SekSetReadByteHandler(3, WofablInputReadByte);
	SekSetReadWordHandler(3, WofablInputReadWord);
	SekSetWriteByteHandler(3, WofablInputWriteByte);
	SekSetWriteWordHandler(3, WofablInputWriteWord);
	SekClose();
	
	return nRet;
}

// Driver Definitions

struct BurnDriver BurnDrvCps1941 = {
	"1941", NULL, NULL, NULL, "1990",
	"1941 - Counter Attack (900227 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VERSHOOT, FBF_19XX,
	NULL, NTFODrvRomInfo, NTFODrvRomName, NULL, NULL, NULL, NULL, NTFOInputInfo, NTFODIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCps1941r1 = {
	"1941r1", "1941", NULL, NULL, "1990",
	"1941 - Counter Attack (World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VERSHOOT, FBF_19XX,
	NULL, NTFOR1DrvRomInfo, NTFOR1DrvRomName, NULL, NULL, NULL, NULL, NTFOInputInfo, NTFODIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCps1941u = {
	"1941u", "1941", NULL, NULL, "1990",
	"1941 - Counter Attack (900227 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VERSHOOT, FBF_19XX,
	NULL, NTFOUDrvRomInfo, NTFOUDrvRomName, NULL, NULL, NULL, NULL, NTFOInputInfo, NTFODIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCps1941j = {
	"1941j", "1941", NULL, NULL, "1990",
	"1941 - Counter Attack (Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VERSHOOT, FBF_19XX,
	NULL, NTFOJDrvRomInfo, NTFOJDrvRomName, NULL, NULL, NULL, NULL, NTFOInputInfo, NTFODIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCps3wonders = {
	"3wonders", NULL, NULL, NULL, "1991",
	"Three Wonders (wonder 3 910520 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, ThreeWondersRomInfo, ThreeWondersRomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCps3wondersr1 = {
	"3wondersr1", "3wonders", NULL, NULL, "1991",
	"Three Wonders (wonder 3 910513 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, ThreeWondersr1RomInfo, ThreeWondersr1RomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCps3wondersu = {
	"3wondersu", "3wonders", NULL, NULL, "1991",
	"Three Wonders (wonder 3 910520 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, Wonder3uRomInfo, Wonder3uRomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsWonder3 = {
	"wonder3", "3wonders", NULL, NULL, "1991",
	"Wonder 3 (910520 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, Wonder3RomInfo, Wonder3RomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCps3wondersh = {
	"3wondersh", "3wonders", NULL, NULL, "1991",
	"Three Wonders (bootleg set 1, wonder 3 910520 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, Wonder3hRomInfo, Wonder3hRomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCps3wondersha = {
	"3wondersha", "3wonders", NULL, NULL, "1991",
	"Three Wonders (bootleg set 3, wonder 3 910520 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, Wonder3haRomInfo, Wonder3haRomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCps3wondersb = {
	"3wondersb", "3wonders", NULL, NULL, "1991",
	"Three Wonders (bootleg set 2, wonder 3 910520 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, Wonder3bRomInfo, Wonder3bRomName, NULL, NULL, NULL, NULL, ThreeWondersInputInfo, ThreeWondersDIPInfo,
	Wonder3bInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcomm = {
	"captcomm", NULL, NULL, NULL, "1991",
	"Captain Commando (911202 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, CaptcommRomInfo, CaptcommRomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommr1 = {
	"captcommr1", "captcomm", NULL, NULL, "1991",
	"Captain Commando (911014 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Captcommr1RomInfo, Captcommr1RomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommu = {
	"captcommu", "captcomm", NULL, NULL, "1991",
	"Captain Commando (910928 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, CaptcommuRomInfo, CaptcommuRomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommj = {
	"captcommj", "captcomm", NULL, NULL, "1991",
	"Captain Commando (911202 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, CaptcommjRomInfo, CaptcommjRomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommjr1 = {
	"captcommjr1", "captcomm", NULL, NULL, "1991",
	"Captain Commando (910928 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Captcommjr1RomInfo, Captcommjr1RomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommb = {
	"captcommb", "captcomm", NULL, NULL, "1991",
	"Captain Commando (bootleg set 1, 911014 other country)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, CaptcommbRomInfo, CaptcommbRomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	CaptcommbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommb2 = {
	"captcommb2", "captcomm", NULL, NULL, "1991",
	"Captain Commando (bootleg set 2 (with 2xMSM5205), 911014 other country)\0", "unemulated graphics", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_NOT_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Captcommb2RomInfo, Captcommb2RomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Captcommb3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCaptcommb3 = {
	"captcommb3", "captcomm", NULL, NULL, "1991",
	"Captain Commando (bootleg set 3 (with YM2151 + 2xMSM5205), 911014 other country)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Captcommb3RomInfo, Captcommb3RomName, NULL, NULL, NULL, NULL, CaptcommInputInfo, CaptcommDIPInfo,
	Captcommb3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawing = {
	"cawing", NULL, NULL, NULL, "1990",
	"Carrier Air Wing (U.S. navy 901012 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, CawingRomInfo, CawingRomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawingr1 = {
	"cawingr1", "cawing", NULL, NULL, "1990",
	"Carrier Air Wing (U.S. navy 901009 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, Cawingr1RomInfo, Cawingr1RomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawingu = {
	"cawingu", "cawing", NULL, NULL, "1990",
	"Carrier Air Wing (U.S. navy 901130 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, CawinguRomInfo, CawinguRomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawingur1 = {
	"cawingur1", "cawing", NULL, NULL, "1990",
	"Carrier Air Wing (U.S. navy 901012 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, Cawingur1RomInfo, Cawingur1RomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawingj = {
	"cawingj", "cawing", NULL, NULL, "1990",
	"U.S. Navy (901012 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, CawingjRomInfo, CawingjRomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawingbl = {
	"cawingbl", "cawing", NULL, NULL, "1990",
	"Carrier Air Wing (bootleg set 1 (with 2xYM2203 + 2xMSM5205), U.S. navy 901012 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, CawingblRomInfo, CawingblRomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	CawingblInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCawingb2 = {
	"cawingb2", "cawing", NULL, NULL, "1990",
	"Carrier Air Wing (bootleg set 2 (with 2xYM2203 + 2xMSM5205), U.S. navy 901012 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_HORSHOOT, 0,
	NULL, Cawingb2RomInfo, Cawingb2RomName, NULL, NULL, NULL, NULL, CawingInputInfo, CawingDIPInfo,
	Cawingb2Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCps1demo = {
	"cps1demo", NULL, NULL, NULL, "2000",
	"Chaos Demo (CPS-1)\0", NULL, "Chaos", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_DEMO, 2, HARDWARE_CAPCOM_CPS1, GBF_MISC, 0,
	NULL, Cps1demoRomInfo, Cps1demoRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	Cps1demoInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCworld2j = {
	"cworld2j", NULL, NULL, NULL, "1992",
	"Adventure Quiz Capcom World 2 (920611 Japan)\0", NULL, "Capcom", "CPS1",
	L"Adventure Quiz Capcom World 2 (\u30AF\u30A4\u30BA\uFF15 \u3042\u3069\u3079\u3093\u3061\u3083\u30FC\u304F\u3044\u305A \u304B\u3077\u3053\u3093\u308F\u30FC\u308B\u3069\uFF12 920611 Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PUZZLE, 0,
	NULL, Cworld2jRomInfo, Cworld2jRomName, NULL, NULL, NULL, NULL, Cworld2jInputInfo, Cworld2jDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCworld2ja = {
	"cworld2ja", "cworld2j", NULL, NULL, "1992",
	"Adventure Quiz Capcom World 2 (Japan 920611, B-Board 90629B-3, no battery)\0", NULL, "Capcom", "CPS1",
	L"Adventure Quiz Capcom World 2 (\u30AF\u30A4\u30BA\uFF15 \u3042\u3069\u3079\u3093\u3061\u3083\u30FC\u304F\u3044\u305A \u304B\u3077\u3053\u3093\u308F\u30FC\u308B\u3069\uFF12 Japan 920611, B-Board 90629B-3, no battery)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 2, HARDWARE_CAPCOM_CPS1, GBF_PUZZLE, 0,
	NULL, Cworld2jaRomInfo, Cworld2jaRomName, NULL, NULL, NULL, NULL, Cworld2jInputInfo, Cworld2jDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCworld2jb = {
	"cworld2jb", "cworld2j", NULL, NULL, "1992",
	"Adventure Quiz Capcom World 2 (Japan 920611, B-Board 91634B-2)\0", NULL, "Capcom", "CPS1",
	L"Adventure Quiz Capcom World 2 (\u30AF\u30A4\u30BA\uFF15 \u3042\u3069\u3079\u3093\u3061\u3083\u30FC\u304F\u3044\u305A \u304B\u3077\u3053\u3093\u308F\u30FC\u308B\u3069\uFF12 Japan 920611, B-Board 91634B-2)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 2, HARDWARE_CAPCOM_CPS1, GBF_PUZZLE, 0,
	NULL, Cworld2jbRomInfo, Cworld2jbRomName, NULL, NULL, NULL, NULL, Cworld2jInputInfo, Cworld2jDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDino = {
	"dino", NULL, NULL, NULL, "1993",
	"Cadillacs & Dinosaurs (930201 World)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinoRomInfo, DinoRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinoa = {
	"dinoa", "dino", NULL, NULL, "1993",
	"Cadillacs & Dinosaurs (930223 Asia TW)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinoaRomInfo, DinoaRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinoj = {
	"dinoj", "dino", NULL, NULL, "1993",
	"Cadillacs Kyouryuu-Shinseiki (930201 Japan)\0", NULL, "Capcom", "CPS1 / QSound",
	L"Cadillacs \u6050\u7ADC\u65B0\u4E16\u7D00\0Cadillacs Kyouryuu-Shinseiki (930201 Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinojRomInfo, DinojRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinou = {
	"dinou", "dino", NULL, NULL, "1993",
	"Cadillacs & Dinosaurs (930201 USA)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinouRomInfo, DinouRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinopic = {
	"dinopic", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (bootleg set 1 (with PIC16c57), 930201 etc)\0", "No sound", "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DinopicRomInfo, DinopicRomName, NULL, NULL, NULL, NULL, DinoQSInputInfo, DinoQSDIPInfo,
	DinopicInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinopic2 = {
	"dinopic2", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (bootleg set 2 (with PIC16c57), 930201 etc)\0", "No sound", "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Dinopic2RomInfo, Dinopic2RomName, NULL, NULL, NULL, NULL, DinoQSInputInfo, DinoQSDIPInfo,
	DinopicInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinopic3 = {
	"dinopic3", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (bootleg set 3 (with PIC16c57), 930201 etc)\0", "No sound", "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Dinopic3RomInfo, Dinopic3RomName, NULL, NULL, NULL, NULL, DinoQSInputInfo, DinoQSDIPInfo,
	Dinopic3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinopic4 = {
	"dinopic4", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (bootleg set 4 (with PIC16c57), 930201 etc)\0", "No sound", "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Dinopic4RomInfo, Dinopic4RomName, NULL, NULL, NULL, NULL, DinoQSInputInfo, DinoQSDIPInfo,
	DinopicInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinopic5 = {
	"dinopic5", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (bootleg set 5 (with PIC16c57), 930223 Asia TW)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Dinopic5RomInfo, Dinopic5RomName, NULL, NULL, NULL, NULL, DinohInputInfo, DinohDIPInfo,
	Dinopic5Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsJurassic99 = {
	"jurassic99", "dino", NULL, NULL, "1993",
	"Jurassic 99 (Cadillacs and Dinosaurs bootleg with EM78P447AP, 930201 ?)\0", "No sound", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Jurassic99RomInfo, Jurassic99RomName, NULL, NULL, NULL, NULL, DinohQSInputInfo, DinohQSDIPInfo,
	Jurassic99Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinoh = {
	"dinoh", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (bootleg set 3, 930223 Asia TW)\0", NULL, "bootleg", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinohRomInfo, DinohRomName, NULL, NULL, NULL, NULL, DinohInputInfo, DinohDIPInfo,
	DinohInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinot = {
	"dinot", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs Turbo (bootleg set 1, 930223 Asia TW)\0", NULL, "bootleg", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinotRomInfo, DinotRomName, NULL, NULL, NULL, NULL, DinohInputInfo, DinohDIPInfo,
	DinotInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinotpic = {
	"dinotpic", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs Turbo (bootleg set 2 (with PIC16c57), 930201 etc)\0", "No sound", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DinotpicRomInfo, DinotpicRomName, NULL, NULL, NULL, NULL, DinoQSInputInfo, DinoQSDIPInfo,
	DinotpicInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinohunt = {
	"dinohunt", "dino", NULL, NULL, "1993",
	"Dinosaur Hunter (Chinese bootleg, 930223 Asia TW)\0", NULL, "bootleg", "CPS1",
	L"Dinosaur Hunter \u6050\u9F8D\u7375\u4EBA (Chinese bootleg, 930223 Asia TW)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DinohuntRomInfo, DinohuntRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	DinohuntInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinoeh = {
	"dinoeh", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (hack, 930201 etc)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HACK, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinoehRomInfo, DinoehRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinohc = {
	"dinohc", "dino", NULL, NULL, "1993",
	"Cadillacs and Dinosaurs (Chinese bootleg, 930223 Asia TW)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DinohcRomInfo, DinohcRomName, NULL, NULL, NULL, NULL, DinoInputInfo, DinoDIPInfo,
	DinohuntInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDynwar = {
	"dynwar", NULL, NULL, NULL, "1989",
	"Dynasty Wars (US set 1)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DynwarRomInfo, DynwarRomName, NULL, NULL, NULL, NULL, DynwarInputInfo, DynwarDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDynwara = {
	"dynwara", "dynwar", NULL, NULL, "1989",
	"Dynasty Wars (US set 2)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DynwaraRomInfo, DynwaraRomName, NULL, NULL, NULL, NULL, DynwarInputInfo, DynwarDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDynwarj = {
	"dynwarj", "dynwar", NULL, NULL, "1989",
	"Tenchi wo Kurau (Japan)\0", NULL, "Capcom", "CPS1",
	L"\u5929\u5730\u3092\u55B0\u3089\u3046\0Tenchi wo Kurau (Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DynwarjRomInfo, DynwarjRomName, NULL, NULL, NULL, NULL, DynwarInputInfo, DynwarDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDynwarjr = {
	"dynwarjr", "dynwar", NULL, NULL, "1989",
	"Tenchi wo Kurau (Japan Resale Ver.)\0", NULL, "Capcom", "CPS1",
	L"\u5929\u5730\u3092\u55B0\u3089\u3046\0Tenchi wo Kurau (Japan Resale Ver.)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, DynwarjrRomInfo, DynwarjrRomName, NULL, NULL, NULL, NULL, DynwarInputInfo, DynwarDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfight = {
	"ffight", NULL, NULL, NULL, "1989",
	"Final Fight (World, set 1)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightRomInfo, FfightRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfighta = {
	"ffighta", "ffight", NULL, NULL, "1989",
	"Final Fight (World, set 2)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightaRomInfo, FfightaRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightu = {
	"ffightu", "ffight", NULL, NULL, "1989",
	"Final Fight (USA, set 1)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightuRomInfo, FfightuRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightu1 = {
	"ffightu1", "ffight", NULL, NULL, "1989",
	"Final Fight (USA, set 2)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Ffightu1RomInfo, Ffightu1RomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightu2 = {
	"ffightu2", "ffight", NULL, NULL, "1989",
	"Final Fight (USA, set 3)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Ffightu2RomInfo, Ffightu2RomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightua = {
	"ffightua", "ffight", NULL, NULL, "1989",
	"Final Fight (900112 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightuaRomInfo, FfightuaRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightub = {
	"ffightub", "ffight", NULL, NULL, "1989",
	"Final Fight (900424 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightubRomInfo, FfightubRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightuc = {
	"ffightuc", "ffight", NULL, NULL, "1989",
	"Final Fight (900613 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightucRomInfo, FfightucRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightj = {
	"ffightj", "ffight", NULL, NULL, "1989",
	"Final Fight (Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightjRomInfo, FfightjRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightj1 = {
	"ffightj1", "ffight", NULL, NULL, "1989",
	"Final Fight (900112 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Ffightj1RomInfo, Ffightj1RomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightj2 = {
	"ffightj2", "ffight", NULL, NULL, "1989",
	"Final Fight (900305 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Ffightj2RomInfo, Ffightj2RomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightj3 = {
	"ffightj3", "ffight", NULL, NULL, "1989",
	"Final Fight (900405 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Ffightj3RomInfo, Ffightj3RomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightj4 = {
	"ffightj4", "ffight", NULL, NULL, "1989",
	"Final Fight (900613 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Ffightj4RomInfo, Ffightj4RomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightjh = {
	"ffightjh", "ffight", NULL, NULL, "1989",
	"Street Smart / Final Fight (Japan, hack)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightjhRomInfo, FfightjhRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightbl = {
	"ffightbl", "ffight", NULL, NULL, "1990",
	"Final Fight (bootleg set 1 (with 2xYM2203 + 2xMSM5205), World)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightblRomInfo, FfightblRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	FfightblInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightbla = {
	"ffightbla", "ffight", NULL, NULL, "1990",
	"Final Fight (bootleg set 2 (with 2xYM2203 + 2xMSM5205), World))\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightblaRomInfo, FfightblaRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	FcrashInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFcrash = {
	"fcrash", "ffight", NULL, NULL, "1990",
	"Final Crash (bootleg (with 2xYM2203 + 2xMSM5205))\0", NULL, "Playmark", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FcrashRomInfo, FcrashRomName, NULL, NULL, NULL, NULL, FfightInputInfo, FfightDIPInfo,
	FcrashInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottn = {
	"forgottn", NULL, NULL, NULL, "1988",
	"Forgotten Worlds (World, newer)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnRomInfo, ForgottnRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnNewerInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottna = {
	"forgottna", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnaRomInfo, ForgottnaRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnAltGfxInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottnu = {
	"forgottnu", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (US, B-Board 88621B-2, rev C)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnuRomInfo, ForgottnuRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnAltGfxuInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottnua = {
	"forgottnua", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (US, B-Board 88618B-2, rev A)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnuaRomInfo, ForgottnuaRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottnuaa = {
	"forgottnuaa", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (US, B-Board 88618B-2, rev AA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnuaaRomInfo, ForgottnuaaRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottnuc = {
	"forgottnuc", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (US, B-Board 88618B-2, Rev C)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnucRomInfo, ForgottnucRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottnue = {
	"forgottnue", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (US, B-Board 88618B-2, Rev E)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnueRomInfo, ForgottnueRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsForgottnj = {
	"forgottnj", "forgottn", NULL, NULL, "1988",
	"Forgotten Worlds (Japan) (English prototype)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, ForgottnjRomInfo, ForgottnjRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnjDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsLostwrld = {
	"lostwrld", "forgottn", NULL, NULL, "1988",
	"Lost Worlds (Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
 	NULL, LostwrldRomInfo, LostwrldRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsLostwrldo = {
	"lostwrldo", "forgottn", NULL, NULL, "1988",
	"Lost Worlds (Japan Old ver.)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
 	NULL, LostwrldoRomInfo, LostwrldoRomName, NULL, NULL, NULL, NULL, ForgottnInputInfo, ForgottnDIPInfo,
	ForgottnInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsGanbare = {
	"ganbare", NULL, NULL, NULL, "2000",
	"Ganbare! Marine Kun (Marine 2K0411 JPN)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_HORSHOOT, 0,
	NULL, GanbareRomInfo, GanbareRomName, NULL, NULL, NULL, NULL, GanbareInputInfo, GanbareDIPInfo,
	GanbareInit, GanbareExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsGhouls = {
	"ghouls", NULL, NULL, NULL, "1988",
	"Ghouls'n Ghosts (World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, GhoulsRomInfo, GhoulsRomName, NULL, NULL, NULL, NULL, GhoulsInputInfo, GhoulsDIPInfo,
	GhoulsInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsGhoulsu = {
	"ghoulsu", "ghouls", NULL, NULL, "1988",
	"Ghouls'n Ghosts (US)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, GhoulsuRomInfo, GhoulsuRomName, NULL, NULL, NULL, NULL, GhoulsInputInfo, GhoulsuDIPInfo,
	GhoulsInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDaimakai = {
	"daimakai", "ghouls", NULL, NULL, "1988",
	"Dai Makai-Mura (Japan)\0", NULL, "Capcom", "CPS1",
	L"\u5927\u9B54\u754C\u6751\0Dai Makai-Mura (Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, DaimakaiRomInfo, DaimakaiRomName, NULL, NULL, NULL, NULL, GhoulsInputInfo, DaimakaiDIPInfo,
	DaimakaiInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDaimakair = {
	"daimakair", "ghouls", NULL, NULL, "1988",
	"Dai Makai-Mura (Japan Resale Ver.)\0", NULL, "Capcom", "CPS1",
	L"\u5927\u9B54\u754C\u6751\0Dai Makai-Mura (Japan Resale Ver.)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, DaimakairRomInfo, DaimakairRomName, NULL, NULL, NULL, NULL, GhoulsInputInfo, DaimakaiDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDaimakaib = {
	"daimakaib", "ghouls", NULL, NULL, "1988",
	"Dai Makai-Mura (bootleg, Japan)\0", NULL, "Capcom", "CPS1",
	L"\u5927\u9B54\u754C\u6751\0Dai Makai-Mura (bootleg, Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, DaimakaibRomInfo, DaimakaibRomName, NULL, NULL, NULL, NULL, GhoulsInputInfo, DaimakaiDIPInfo,
	DaimakaibInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvGulunpa = {
	"gulunpa", NULL, NULL, NULL, "1993",
	"Gulun.Pa! (Japan 931220 L) (prototype)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_PROTOTYPE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PUZZLE, 0,
	NULL, GulunpaRomInfo, GulunpaRomName, NULL, NULL, NULL, NULL, NTFOInputInfo, GulunpaDIPInfo,
	GulunpaInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvMpumpkin = {
	"mpumpkin", NULL, NULL, NULL, "1996",
	"Magical Pumpkin: Puroland de Daibouken (Japan 960712)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_MINIGAMES, 0,
	NULL, MpumpkinRomInfo, MpumpkinRomName, NULL, NULL, NULL, NULL, HkittympInputInfo, HkittympDIPInfo,
	MpumpkinInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnights = {
	"knights", NULL, NULL, NULL, "1991",
	"Knights of the Round (911127 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightsRomInfo, KnightsRomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsu = {
	"knightsu", "knights", NULL, NULL, "1991",
	"Knights of the Round (911127 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightsuRomInfo, KnightsuRomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsj = {
	"knightsj", "knights", NULL, NULL, "1991",
	"Knights of the Round (911127 Japan, B-Board 91634B-2)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightsjRomInfo, KnightsjRomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsja = {
	"knightsja", "knights", NULL, NULL, "1991",
	"Knights of the Round (911127 Japan, B-Board 89625B-1)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightsjaRomInfo, KnightsjaRomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsb = {
	"knightsb", "knights", NULL, NULL, "1991",
	"Knights of the Round (bootleg set 1 (with YM2151 + 2xMSM5205), 911127 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightsbRomInfo, KnightsbRomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	KnightsbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsb2 = {
	"knightsb2", "knights", NULL, NULL, "1991",
	"Knights of the Round (bootleg set 2, 911127 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Knightsb2RomInfo, Knightsb2RomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	Knightsb2Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsb3 = {
	"knightsb3", "knights", NULL, NULL, "1991",
	"Knights of the Round (bootleg set 3 (with 2xMSM5205), 911127 etc)\0", "unemulated graphics", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_NOT_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Knightsb3RomInfo, Knightsb3RomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	KnightsbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsb4 = {
	"knightsb4", "knights", NULL, NULL, "1991",
	"Knights of the Round (bootleg set 4 (with YM2151 + 2xMSM5205), 911127 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Knightsb4RomInfo, Knightsb4RomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	KnightsbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsb5 = {
	"knightsb5", "knights", NULL, NULL, "1991",
	"Knights of the Round (bootleg set 5, 911127 Japan)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Knightsb5RomInfo, Knightsb5RomName, NULL, NULL, NULL, NULL, KnightsInputInfo, KnightsDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsh = {
	"knightsh", "knights", NULL, NULL, "1991",
	"Knights of the Round (hack set 1)\0", NULL, "hack", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HACK, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightshRomInfo, KnightshRomName, NULL, NULL, NULL, NULL, KnightshInputInfo, KnightshDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsh2 = {
	"knightsh2", "knights", NULL, NULL, "1991",
	"Knights of the Round (hack set 2, 911127 etc)\0", NULL, "hack", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HACK, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Knightsh2RomInfo, Knightsh2RomName, NULL, NULL, NULL, NULL, KnightshInputInfo, KnightshDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKod = {
	"kod", NULL, NULL, NULL, "1991",
	"The King of Dragons (World 910805)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KodRomInfo, KodRomName, NULL, NULL, NULL, NULL, KodInputInfo, KodDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodr1 = {
	"kodr1", "kod", NULL, NULL, "1991",
	"The King of Dragons (World 910711)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Kodr1RomInfo, Kodr1RomName, NULL, NULL, NULL, NULL, KodInputInfo, Kodr1DIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodr2 = {
	"kodr2", "kod", NULL, NULL, "1991",
	"The King of Dragons (910731 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Kodr2RomInfo, Kodr2RomName, NULL, NULL, NULL, NULL, KodInputInfo, Kodr1DIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodu = {
	"kodu", "kod", NULL, NULL, "1991",
	"The King of Dragons (US 910910)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KoduRomInfo, KoduRomName, NULL, NULL, NULL, NULL, KodInputInfo, KodDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodj = {
	"kodj", "kod", NULL, NULL, "1991",
	"The King of Dragons (Japan 910805, B-Board 90629B-3)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KodjRomInfo, KodjRomName, NULL, NULL, NULL, NULL, KodInputInfo, KodDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodja = {
	"kodja", "kod", NULL, NULL, "1991",
	"The King of Dragons (Japan 910805, B-Board 89625B-1)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KodjaRomInfo, KodjaRomName, NULL, NULL, NULL, NULL, KodInputInfo, KodDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodb = {
	"kodb", "kod", NULL, NULL, "1991",
	"The King of Dragons (bootleg, 910731 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KodbRomInfo, KodbRomName, NULL, NULL, NULL, NULL, KodInputInfo, KodDIPInfo,
	KodbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodh = {
	"kodh", "kod", NULL, NULL, "2002",
	"The King of Dragons (hack)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HACK, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KodhRomInfo, KodhRomName, NULL, NULL, NULL, NULL, KodhInputInfo, KodhDIPInfo,
	KodhInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodda = {
	"kodda", "kod", NULL, NULL, "1991",
	"The King of Dragons (Phoenix bootleg, 910731 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KoddaRomInfo, KoddaRomName, NULL, NULL, NULL, NULL, KodInputInfo, KodDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMegaman = {
	"megaman", NULL, NULL, NULL, "1995",
	"Mega Man - the power battle (951006 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MegamanRomInfo, MegamanRomName, NULL, NULL, NULL, NULL, MegamanInputInfo, MegamanDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMegamana = {
	"megamana", "megaman", NULL, NULL, "1995",
	"Mega Man - the power battle (951006 Asia)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MegamanaRomInfo, MegamanaRomName, NULL, NULL, NULL, NULL, MegamanInputInfo, MegamanDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsRockmanj = {
	"rockmanj", "megaman", NULL, NULL, "1995",
	"Rockman - the power battle (950922 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, RockmanjRomInfo, RockmanjRomName, NULL, NULL, NULL, NULL, MegamanInputInfo, RockmanjDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMercs = {
	"mercs", NULL, NULL, NULL, "1990",
	"Mercs (900302 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, MercsRomInfo, MercsRomName, NULL, NULL, NULL, NULL, MercsInputInfo, MercsDIPInfo,
	MercsInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCpsMercsu = {
	"mercsu", "mercs", NULL, NULL, "1990",
	"Mercs (900608 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, MercsuRomInfo, MercsuRomName, NULL, NULL, NULL, NULL, MercsInputInfo, MercsDIPInfo,
	MercsInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCpsMercsur1 = {
	"mercsur1", "mercs", NULL, NULL, "1990",
	"Mercs (900302 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, Mercsur1RomInfo, Mercsur1RomName, NULL, NULL, NULL, NULL, MercsInputInfo, MercsDIPInfo,
	MercsInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCpsMercsj = {
	"mercsj", "mercs", NULL, NULL, "1990",
	"Senjo no Ookami II (Ookami 2 900302 Japan)\0", NULL, "Capcom", "CPS1",
	L"\u6226\u5834\u306E\u72FC II\0Senjo no Ookami II (Ookami 2 900302 Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_ORIENTATION_VERTICAL | BDF_HISCORE_SUPPORTED, 3, HARDWARE_CAPCOM_CPS1, GBF_RUNGUN, 0,
	NULL, MercsjRomInfo, MercsjRomName, NULL, NULL, NULL, NULL, MercsInputInfo, MercsDIPInfo,
	MercsInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 224, 384, 3, 4
};

struct BurnDriver BurnDrvCpsMsword = {
	"msword", NULL, NULL, NULL, "1990",
	"Magic Sword - heroic fantasy (25.07.1990 other country)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, MswordRomInfo, MswordRomName, NULL, NULL, NULL, NULL, MswordInputInfo, MswordDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMswordr1 = {
	"mswordr1", "msword", NULL, NULL, "1990",
	"Magic Sword - heroic fantasy (23.06.1990 other country)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Mswordr1RomInfo, Mswordr1RomName, NULL, NULL, NULL, NULL, MswordInputInfo, MswordDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMswordj = {
	"mswordj", "msword", NULL, NULL, "1990",
	"Magic Sword (23.06.1990 Japan)\0", NULL, "Capcom", "CPS1",
	L"Magic Sword (23.06.1990 Japan)\0Magic Sword\u30DE\u30B8\u30C3\u30AF\uFF65\u30BD\u30FC\u30C9\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, MswordjRomInfo, MswordjRomName, NULL, NULL, NULL, NULL, MswordInputInfo, MswordDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMswordu = {
	"mswordu", "msword", NULL, NULL, "1990",
	"Magic Sword - heroic fantasy (25.07.1990 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, MsworduRomInfo, MsworduRomName, NULL, NULL, NULL, NULL, MswordInputInfo, MswordDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMtwins = {
	"mtwins", NULL, NULL, NULL, "1990",
	"Mega Twins (chiki chiki boys 900619 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PLATFORM, 0,
	NULL, MtwinsRomInfo, MtwinsRomName, NULL, NULL, NULL, NULL, MtwinsInputInfo, MtwinsDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsChikij = {
	"chikij", "mtwins", NULL, NULL, "1990",
	"Chiki Chiki Boys (900619 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PLATFORM, 0,
	NULL, ChikijRomInfo, ChikijRomName, NULL, NULL, NULL, NULL, MtwinsInputInfo, MtwinsDIPInfo,
	Cps1RasterInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMtwinsb = {
	"mtwinsb", "mtwins", NULL, NULL, "1993",
	"Twins (bootleg of Mega Twins)\0", NULL, "David Inc. (bootleg)", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PLATFORM, 0,
	NULL, MtwinsbRomInfo, MtwinsbRomName, NULL, NULL, NULL, NULL, MtwinsInputInfo, MtwinsDIPInfo,
	MtwinsbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsNemo = {
	"nemo", NULL, NULL, NULL, "1990",
	"Nemo (90 11 30 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PLATFORM, 0,
	NULL, NemoRomInfo, NemoRomName, NULL, NULL, NULL, NULL, NemoInputInfo, NemoDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsNemor1 = {
	"nemor1", "nemo", NULL, NULL, "1990",
	"Nemo (90 11 09 etc)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PLATFORM, 0,
	NULL, Nemor1RomInfo, Nemor1RomName, NULL, NULL, NULL, NULL, NemoInputInfo, NemoDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsNemoj = {
	"nemoj", "nemo", NULL, NULL, "1990",
	"Nemo (90 11 20 Japan)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PLATFORM, 0,
	NULL, NemojRomInfo, NemojRomName, NULL, NULL, NULL, NULL, NemoInputInfo, NemoDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3 = {
	"pang3", NULL, NULL, NULL, "1995",
	"Pang! 3 (950601 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3RomInfo, Pang3RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3r1 = {
	"pang3r1", "pang3", NULL, NULL, "1995",
	"Pang! 3 (950511 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3r1RomInfo, Pang3r1RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3r1a = {
	"pang3r1a", "pang3", NULL, NULL, "1995",
	"Pang! 3 (950511 Euro, alt)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3r1aRomInfo, Pang3r1aRomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3r1aInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b = {
	"pang3b", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 1, 950511 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3bRomInfo, Pang3bRomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3bInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b2 = {
	"pang3b2", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 2, 950601 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3b2RomInfo, Pang3b2RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3b2Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b3 = {
	"pang3b3", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 3, 950511 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3b3RomInfo, Pang3b3RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b4 = {
	"pang3b4", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 4, 950601 Euro, unencrypted, protection PIC, no serial EPROM)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3b4RomInfo, Pang3b4RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3b4DIPInfo,
	Pang3b4Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b5 = {
	"pang3b5", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 5, 950511 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3b5RomInfo, Pang3b5RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3b5Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b6 = {
	"pang3b6", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 6, 950511 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3b6RomInfo, Pang3b6RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3b7 = {
	"pang3b7", "pang3", NULL, NULL, "1995",
	"Pang! 3 (bootleg set 7, 950601 Euro)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3b7RomInfo, Pang3b7RomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPang3j = {
	"pang3j", "pang3", NULL, NULL, "1995",
	"Pang! 3: Kaitou Tachi no Karei na Gogo (950511 Japan)\0", NULL, "Mitchell", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_GENERIC, GBF_PUZZLE, 0,
	NULL, Pang3jRomInfo, Pang3jRomName, NULL, NULL, NULL, NULL, Pang3InputInfo, Pang3DIPInfo,
	Pang3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPnickj = {
	"pnickj", NULL, NULL, NULL, "1994",
	"Pnickies (940608 Japan)\0", NULL, "Compile (Capcom license)", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_PUZZLE, 0,
	NULL, PnickjRomInfo, PnickjRomName, NULL, NULL, NULL, NULL, PnickjInputInfo, PnickjDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvPokonyan = {
	"pokonyan", NULL, NULL, NULL, "1994",
	"Pokonyan (Japan 940322)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS1, GBF_MISC, 0,
	NULL, PokonyanRomInfo, PokonyanRomName, NULL, NULL, NULL, NULL, PokonyanInputInfo, PokonyanDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisher = {
	"punisher", NULL, NULL, NULL, "1993",
	"The Punisher (930422 World)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, PunisherRomInfo, PunisherRomName, NULL, NULL, NULL, NULL, PunisherInputInfo, PunisherDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisheru = {
	"punisheru", "punisher", NULL, NULL, "1993",
	"The Punisher (930422 USA)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, PunisheruRomInfo, PunisheruRomName, NULL, NULL, NULL, NULL, PunisherInputInfo, PunisherDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisherj = {
	"punisherj", "punisher", NULL, NULL, "1993",
	"The Punisher (930422 Japan)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, PunisherjRomInfo, PunisherjRomName, NULL, NULL, NULL, NULL, PunisherInputInfo, PunisherDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisherh = {
	"punisherh", "punisher", NULL, NULL, "1993",
	"The Punisher (930422 Hispanic)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, PunisherhRomInfo, PunisherhRomName, NULL, NULL, NULL, NULL, PunisherInputInfo, PunisherDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunipic = {
	"punipic", "punisher", NULL, NULL, "1993",
	"The Punisher (bootleg set 1 (with PIC16c57), 930422 etc)\0", "No sound", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, PunipicRomInfo, PunipicRomName, NULL, NULL, NULL, NULL, PunisherQSInputInfo, PunisherQSDIPInfo,
	PunipicInit, PunipicExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunipic2 = {
	"punipic2", "punisher", NULL, NULL, "1993",
	"The Punisher (bootleg set 2 (with PIC16c57), 930422 etc)\0", "No sound", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Punipic2RomInfo, Punipic2RomName, NULL, NULL, NULL, NULL, PunisherQSInputInfo, PunisherQSDIPInfo,
	Punipic2Init, PunipicExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunipic3 = {
	"punipic3", "punisher", NULL, NULL, "1993",
	"The Punisher (bootleg set 3 (with PIC16c57), 930422 etc)\0", "No sound", "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, Punipic3RomInfo, Punipic3RomName, NULL, NULL, NULL, NULL, PunisherQSInputInfo, PunisherQSDIPInfo,
	Punipic3Init, PunipicExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisherbz = {
	"punisherbz", "punisher", NULL, NULL, "2002",
	"Biaofeng Zhanjing (Chinese bootleg)\0", NULL, "bootleg", "CPS1",
	L"\uFEFF\u98C6\u98A8\u6230\u8B66\0The Punisher: Biaofeng Zhanjing (Chinese bootleg)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, PunisherbzRomInfo, PunisherbzRomName, NULL, NULL, NULL, NULL, PunisherbzInputInfo, PunisherbzDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisherb = {
	"punisherb", "punisher", NULL, NULL, "1993",
	"The Punisher (bootleg, 930422 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, PunisherbRomInfo, PunisherbRomName, NULL, NULL, NULL, NULL, PunisherInputInfo, PunisherDIPInfo,
	PunisherbInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsQad = {
	"qad", NULL, NULL, NULL, "1992",
	"Quiz & Dragons (capcom quiz game 920701 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_QUIZ, 0,
	NULL, QadRomInfo, QadRomName, NULL, NULL, NULL, NULL, QadInputInfo, QadDIPInfo,
	QadInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsQadjr = {
	"qadjr", "qad", NULL, NULL, "1992",
	"Quiz & Dragons (940921 Japan Resale Ver.)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_QUIZ, 0,
	NULL, QadjrRomInfo, QadjrRomName, NULL, NULL, NULL, NULL, QadInputInfo, QadjrDIPInfo,
	QadInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsQtono2j = {
	"qtono2j", NULL, NULL, NULL, "1995",
	"Quiz Tonosama no Yabou 2 Zenkoku-ban (tonosama 2 950123 Japan)\0", NULL, "Capcom", "CPS1",
	L"\u30AF\u30A4\u30BA\u6BBF\u69D8\u306E\u91CE\u671B\uFF12 (\u3068\u306E\u3055\u307E\u306E\u3084\u307C\u3046 2)\0Quiz Tonosama no Yabou 2 Zenkoku-ban (tonosama 2 950123 Japan)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_QUIZ, 0,
	NULL, Qtono2jRomInfo, Qtono2jRomName, NULL, NULL, NULL, NULL, Qtono2jInputInfo, Qtono2jDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2 = {
	"sf2", NULL, NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910522 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2RomInfo, Sf2RomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ea = {
	"sf2ea", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910204 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2eaRomInfo, Sf2eaRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2eb = {
	"sf2eb", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910214 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ebRomInfo, Sf2ebRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ed = {
	"sf2ed", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910318 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2edRomInfo, Sf2edRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ee = {
	"sf2ee", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910228 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2eeRomInfo, Sf2eeRomName, NULL, NULL, NULL, NULL, Sf2ueInputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ef = {
	"sf2ef", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910411 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2efRomInfo, Sf2efRomName, NULL, NULL, NULL, NULL, Sf2ueInputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2em = {
	"sf2em", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910129 World)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2emRomInfo, Sf2emRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2en = {
	"sf2en", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910204 World, conversion)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2enRomInfo, Sf2enRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ebbl = {
	"sf2ebbl", "sf2", NULL, NULL, "1992",
	"Street Fighter II - The World Warrior (TAB Austria bootleg, 910214 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ebblRomInfo, Sf2ebblRomName, NULL, NULL, NULL, NULL, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2ebblInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ebbl2 = {
	"sf2ebbl2", "sf2", NULL, NULL, "1992",
	"Street Fighter II - The World Warrior (TAB Austria bootleg set 2, 910214 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ebbl2RomInfo, Sf2ebbl2RomName, NULL, NULL, NULL, NULL, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2ebbl2Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ebbl3 = {
	"sf2ebbl3", "sf2", NULL, NULL, "1992",
	"Street Fighter II - The World Warrior (TAB Austria bootleg set 3, 910214 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ebbl3RomInfo, Sf2ebbl3RomName, NULL, NULL, NULL, NULL, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2ebbl3Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2stt = {
	"sf2stt", "sf2", NULL, NULL, "1992",
	"Street Fighter II - The World Warrior (STT, TAB Austria bootleg, 910214 etc)\0", NULL, "bootleg", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_BOOTLEG | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2sttRomInfo, Sf2sttRomName, NULL, NULL, NULL, NULL, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2sttInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ly = {
	"sf2ly", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (with bosses like Champion Edition, 910522 Japan, CPS-B-11)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2lyRomInfo, Sf2lyRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ua = {
	"sf2ua", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910206 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2uaRomInfo, Sf2uaRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ub = {
	"sf2ub", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910214 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ubRomInfo, Sf2ubRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2uc = {
	"sf2uc", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910306 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ucRomInfo, Sf2ucRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ud = {
	"sf2ud", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910318 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2udRomInfo, Sf2udRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ue = {
	"sf2ue", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910228 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ueRomInfo, Sf2ueRomName, NULL, NULL, NULL, NULL, Sf2ueInputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2uf = {
	"sf2uf", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910411 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ufRomInfo, Sf2ufRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ug = {
	"sf2ug", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910522 USA, rev G)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ugRomInfo, Sf2ugRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2uh = {
	"sf2uh", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910522 USA, rev H)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2uhRomInfo, Sf2uhRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2ui = {
	"sf2ui", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (910522 USA, rev I)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2uiRomInfo, Sf2uiRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2uk = {
	"sf2uk", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (911101 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ukRomInfo, Sf2ukRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2um = {
	"sf2um", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (920312 USA)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2umRomInfo, Sf2umRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2DIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2j = {
	"sf2j", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (911210 Japan, CPS-B-13)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2jRomInfo, Sf2jRomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2jDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2j17 = {
	"sf2j17", "sf2", NULL, NULL, "1991",
	"Street Fighter II - The World Warrior (911210 Japan, CPS-B-17)\0", NULL, "Capcom", "CPS1",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_HISCORE_SUPPORTED, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2j17RomInfo, Sf2j17RomName, NULL, NULL, NULL, NULL, Sf2InputInfo, Sf2jDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	&C