#include "burnint.h"
#include "pce.h"

// Driver generated by database on http://www.barryharris.me.uk

static struct BurnInputInfo pceInputList[] = {
	{"P1 Start",		BIT_DIGITAL,	PCEJoy1 + 3,	"p1 start"	}, // 0
	{"P1 Select",		BIT_DIGITAL,	PCEJoy1 + 2,	"p1 select"	},
	{"P1 Up",		BIT_DIGITAL,	PCEJoy1 + 4,	"p1 up"		},
	{"P1 Down",		BIT_DIGITAL,	PCEJoy1 + 6,	"p1 down"	},
	{"P1 Left",		BIT_DIGITAL,	PCEJoy1 + 7,	"p1 left"	},
	{"P1 Right",		BIT_DIGITAL,	PCEJoy1 + 5,	"p1 right"	},
	{"P1 Button 1",		BIT_DIGITAL,	PCEJoy1 + 1,	"p1 fire 1"	},
	{"P1 Button 2",		BIT_DIGITAL,	PCEJoy1 + 0,	"p1 fire 2"	},
	{"P1 Button 3",		BIT_DIGITAL,	PCEJoy1 + 8,	"p1 fire 3"	},
	{"P1 Button 4",		BIT_DIGITAL,	PCEJoy1 + 9,	"p1 fire 4"	},
	{"P1 Button 5",		BIT_DIGITAL,	PCEJoy1 + 10,	"p1 fire 5"	},
	{"P1 Button 6",		BIT_DIGITAL,	PCEJoy1 + 11,	"p1 fire 6"	},

	{"P2 Start",		BIT_DIGITAL,	PCEJoy2 + 3,	"p2 start"	}, // 12
	{"P2 Select",		BIT_DIGITAL,	PCEJoy2 + 2,	"p2 select"	},
	{"P2 Up",		BIT_DIGITAL,	PCEJoy2 + 4,	"p2 up"		},
	{"P2 Down",		BIT_DIGITAL,	PCEJoy2 + 6,	"p2 down"	},
	{"P2 Left",		BIT_DIGITAL,	PCEJoy2 + 7,	"p2 left"	},
	{"P2 Right",		BIT_DIGITAL,	PCEJoy2 + 5,	"p2 right"	},
	{"P2 Button 1",		BIT_DIGITAL,	PCEJoy2 + 1,	"p2 fire 1"	},
	{"P2 Button 2",		BIT_DIGITAL,	PCEJoy2 + 0,	"p2 fire 2"	},
	{"P2 Button 3",		BIT_DIGITAL,	PCEJoy2 + 8,	"p2 fire 3"	},
	{"P2 Button 4",		BIT_DIGITAL,	PCEJoy2 + 9,	"p2 fire 4"	},
	{"P2 Button 5",		BIT_DIGITAL,	PCEJoy2 + 10,	"p2 fire 5"	},
	{"P2 Button 6",		BIT_DIGITAL,	PCEJoy2 + 11,	"p2 fire 6"	},

	{"P3 Start",		BIT_DIGITAL,	PCEJoy3 + 3,	"p3 start"	}, // 24
	{"P3 Select",		BIT_DIGITAL,	PCEJoy3 + 2,	"p3 select"	},
	{"P3 Up",		BIT_DIGITAL,	PCEJoy3 + 4,	"p3 up"		},
	{"P3 Down",		BIT_DIGITAL,	PCEJoy3 + 6,	"p3 down"	},
	{"P3 Left",		BIT_DIGITAL,	PCEJoy3 + 7,	"p3 left"	},
	{"P3 Right",		BIT_DIGITAL,	PCEJoy3 + 5,	"p3 right"	},
	{"P3 Button 1",		BIT_DIGITAL,	PCEJoy3 + 1,	"p3 fire 1"	},
	{"P3 Button 2",		BIT_DIGITAL,	PCEJoy3 + 0,	"p3 fire 2"	},
	{"P3 Button 3",		BIT_DIGITAL,	PCEJoy3 + 8,	"p3 fire 3"	},
	{"P3 Button 4",		BIT_DIGITAL,	PCEJoy3 + 9,	"p3 fire 4"	},
	{"P3 Button 5",		BIT_DIGITAL,	PCEJoy3 + 10,	"p3 fire 5"	},
	{"P3 Button 6",		BIT_DIGITAL,	PCEJoy3 + 11,	"p3 fire 6"	},

	{"P4 Start",		BIT_DIGITAL,	PCEJoy4 + 3,	"p4 start"	}, // 36
	{"P4 Select",		BIT_DIGITAL,	PCEJoy4 + 2,	"p4 select"	},
	{"P4 Up",		BIT_DIGITAL,	PCEJoy4 + 4,	"p4 up"		},
	{"P4 Down",		BIT_DIGITAL,	PCEJoy4 + 6,	"p4 down"	},
	{"P4 Left",		BIT_DIGITAL,	PCEJoy4 + 7,	"p4 left"	},
	{"P4 Right",		BIT_DIGITAL,	PCEJoy4 + 5,	"p4 right"	},
	{"P4 Button 1",		BIT_DIGITAL,	PCEJoy4 + 1,	"p4 fire 1"	},
	{"P4 Button 2",		BIT_DIGITAL,	PCEJoy4 + 0,	"p4 fire 2"	},
	{"P4 Button 3",		BIT_DIGITAL,	PCEJoy4 + 8,	"p4 fire 3"	},
	{"P4 Button 4",		BIT_DIGITAL,	PCEJoy4 + 9,	"p4 fire 4"	},
	{"P4 Button 5",		BIT_DIGITAL,	PCEJoy4 + 10,	"p4 fire 5"	},
	{"P4 Button 6",		BIT_DIGITAL,	PCEJoy4 + 11,	"p4 fire 6"	},

	{"P5 Start",		BIT_DIGITAL,	PCEJoy5 + 3,	"p5 start"	}, // 48
	{"P5 Select",		BIT_DIGITAL,	PCEJoy5 + 2,	"p5 select"	},
	{"P5 Up",		BIT_DIGITAL,	PCEJoy5 + 4,	"p5 up"		},
	{"P5 Down",		BIT_DIGITAL,	PCEJoy5 + 6,	"p5 down"	},
	{"P5 Left",		BIT_DIGITAL,	PCEJoy5 + 7,	"p5 left"	},
	{"P5 Right",		BIT_DIGITAL,	PCEJoy5 + 5,	"p5 right"	},
	{"P5 Button 1",		BIT_DIGITAL,	PCEJoy5 + 1,	"p5 fire 1"	},
	{"P5 Button 2",		BIT_DIGITAL,	PCEJoy5 + 0,	"p5 fire 2"	},
	{"P5 Button 3",		BIT_DIGITAL,	PCEJoy5 + 8,	"p5 fire 3"	},
	{"P5 Button 4",		BIT_DIGITAL,	PCEJoy5 + 9,	"p5 fire 4"	},
	{"P5 Button 5",		BIT_DIGITAL,	PCEJoy5 + 10,	"p5 fire 5"	},
	{"P5 Button 6",		BIT_DIGITAL,	PCEJoy5 + 11,	"p5 fire 6"	},

	{"Reset",		BIT_DIGITAL,	&PCEReset,	"reset"		}, // 60
	{"Dip A",		BIT_DIPSWITCH,	PCEDips + 0,	"dip"		},
	{"Dip B",		BIT_DIPSWITCH,	PCEDips + 1,	"dip"		},
	{"Dip C",		BIT_DIPSWITCH,	PCEDips + 2,	"dip"		},
};

STDINPUTINFO(pce)

static struct BurnDIPInfo pceDIPList[] = {
	{0x3d, 0xff, 0xff, 0x00, NULL				},
	{0x3e, 0xff, 0xff, 0x00, NULL				},
	{0x3f, 0xff, 0xff, 0x01, NULL				},

	{0   , 0xfe, 0   ,    2, "Joystick Type Player 1"	},
	{0x3d, 0x01, 0x03, 0x00, "2-buttons"			},
	{0x3d, 0x01, 0x03, 0x02, "6-buttons"			},

	{0   , 0xfe, 0   ,    2, "Joystick Type Player 2"	},
	{0x3d, 0x01, 0x0c, 0x00, "2-buttons"			},
	{0x3d, 0x01, 0x0c, 0x08, "6-buttons"			},

	{0   , 0xfe, 0   ,    2, "Joystick Type Player 3"	},
	{0x3d, 0x01, 0x30, 0x00, "2-buttons"			},
	{0x3d, 0x01, 0x30, 0x20, "6-buttons"			},

	{0   , 0xfe, 0   ,    2, "Joystick Type Player 4"	},
	{0x3d, 0x01, 0xc0, 0x00, "2-buttons"			},
	{0x3d, 0x01, 0xc0, 0x80, "6-buttons"			},

	{0   , 0xfe, 0   ,    2, "Joystick Type Player 5"	},
	{0x3e, 0x01, 0x03, 0x00, "2-buttons"			},
	{0x3e, 0x01, 0x03, 0x02, "6-buttons"			},

	{0   , 0xfe, 0   ,    2, "Arcade Card"			},
	{0x3f, 0x01, 0x01, 0x00, "Off"				},
	{0x3f, 0x01, 0x01, 0x01, "On"				},
};

STDDIPINFO(pce)

// 1943 Kai

static struct BurnRomInfo pce_1943kaiRomDesc[] = {
	{ "1943 kai (japan).pce", 0x080000, 0xfde08d6d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_1943kai)
STD_ROM_FN(pce_1943kai)

struct BurnDriver BurnDrvpce_1943kai = {
	"pce_1943kai", NULL, NULL, NULL, "1991",
	"1943 Kai\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_1943kaiRomInfo, pce_1943kaiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// 21 Emon - Mezase Hotel ou!!

static struct BurnRomInfo pce_21emonRomDesc[] = {
	{ "21 emon - mezase hotel ou!! (japan).pce", 0x080000, 0x73614660, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_21emon)
STD_ROM_FN(pce_21emon)

struct BurnDriver BurnDrvpce_21emon = {
	"pce_21emon", NULL, NULL, NULL, "1994",
	"21 Emon - Mezase Hotel ou!!\0", NULL, "NEC Home Electronics", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_21emonRomInfo, pce_21emonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Adventure Island

static struct BurnRomInfo pce_advislndRomDesc[] = {
	{ "adventure island (japan).pce", 0x040000, 0x8e71d4f3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_advislnd)
STD_ROM_FN(pce_advislnd)

struct BurnDriver BurnDrvpce_advislnd = {
	"pce_advislnd", NULL, NULL, NULL, "1991",
	"Adventure Island\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_advislndRomInfo, pce_advislndRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Aero Blasters

static struct BurnRomInfo pce_aeroblstRomDesc[] = {
	{ "aero blasters (japan).pce", 0x080000, 0x25be2b81, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_aeroblst)
STD_ROM_FN(pce_aeroblst)

struct BurnDriver BurnDrvpce_aeroblst = {
	"pce_aeroblst", NULL, NULL, NULL, "1990",
	"Aero Blasters\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_aeroblstRomInfo, pce_aeroblstRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// After Burner II

static struct BurnRomInfo pce_aburner2RomDesc[] = {
	{ "after burner ii (japan).pce", 0x080000, 0xca72a828, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_aburner2)
STD_ROM_FN(pce_aburner2)

struct BurnDriver BurnDrvpce_aburner2 = {
	"pce_aburner2", NULL, NULL, NULL, "1990",
	"After Burner II\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_aburner2RomInfo, pce_aburner2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Alien Crush

static struct BurnRomInfo pce_acrushRomDesc[] = {
	{ "alien crush (japan).pce", 0x040000, 0x60edf4e1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_acrush)
STD_ROM_FN(pce_acrush)

struct BurnDriver BurnDrvpce_acrush = {
	"pce_acrush", NULL, NULL, NULL, "1988",
	"Alien Crush\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_acrushRomInfo, pce_acrushRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ankoku Densetsu

static struct BurnRomInfo pce_ankokuRomDesc[] = {
	{ "ankoku densetsu (japan).pce", 0x040000, 0xcacc06fb, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ankoku)
STD_ROM_FN(pce_ankoku)

struct BurnDriver BurnDrvpce_ankoku = {
	"pce_ankoku", NULL, NULL, NULL, "1990",
	"Ankoku Densetsu\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ankokuRomInfo, pce_ankokuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Aoi Blink

static struct BurnRomInfo pce_aoiblinkRomDesc[] = {
	{ "aoi blink (japan).pce", 0x060000, 0x08a09b9a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_aoiblink)
STD_ROM_FN(pce_aoiblink)

struct BurnDriver BurnDrvpce_aoiblink = {
	"pce_aoiblink", NULL, NULL, NULL, "1990",
	"Aoi Blink\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_aoiblinkRomInfo, pce_aoiblinkRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Appare! Gateball

static struct BurnRomInfo pce_appgatebRomDesc[] = {
	{ "appare gateball (japan).pce", 0x040000, 0x2b54cba2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_appgateb)
STD_ROM_FN(pce_appgateb)

struct BurnDriver BurnDrvpce_appgateb = {
	"pce_appgateb", NULL, NULL, NULL, "1988",
	"Appare! Gateball\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_appgatebRomInfo, pce_appgatebRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Armed Formation F

static struct BurnRomInfo pce_armedfRomDesc[] = {
	{ "armed formation f (japan).pce", 0x040000, 0x20ef87fd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_armedf)
STD_ROM_FN(pce_armedf)

struct BurnDriver BurnDrvpce_armedf = {
	"pce_armedf", NULL, NULL, NULL, "1990",
	"Armed Formation F\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_armedfRomInfo, pce_armedfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Artist Tool

static struct BurnRomInfo pce_arttoolRomDesc[] = {
	{ "artist tool (japan).pce", 0x040000, 0x5e4fa713, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_arttool)
STD_ROM_FN(pce_arttool)

struct BurnDriver BurnDrvpce_arttool = {
	"pce_arttool", NULL, NULL, NULL, "1990",
	"Artist Tool\0", NULL, "NEC Home Electronics", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_arttoolRomInfo, pce_arttoolRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Atomic Robo-kid Special

static struct BurnRomInfo pce_atomroboRomDesc[] = {
	{ "atomic robo-kid special (japan).pce", 0x080000, 0xdd175efd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_atomrobo)
STD_ROM_FN(pce_atomrobo)

struct BurnDriver BurnDrvpce_atomrobo = {
	"pce_atomrobo", NULL, NULL, NULL, "1990",
	"Atomic Robo-kid Special\0", NULL, "UPL", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_atomroboRomInfo, pce_atomroboRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// AV Poker

static struct BurnRomInfo pce_avpokerRomDesc[] = {
	{ "av poker (japan).pce", 0x080000, 0xb866d282, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_avpoker)
STD_ROM_FN(pce_avpoker)

struct BurnDriver BurnDrvpce_avpoker = {
	"pce_avpoker", NULL, NULL, NULL, "1992",
	"AV Poker\0", NULL, "Games Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_avpokerRomInfo, pce_avpokerRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ballistix

static struct BurnRomInfo pce_ballistxRomDesc[] = {
	{ "ballistix (japan).pce", 0x040000, 0x8acfc8aa, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ballistx)
STD_ROM_FN(pce_ballistx)

struct BurnDriver BurnDrvpce_ballistx = {
	"pce_ballistx", NULL, NULL, NULL, "1991",
	"Ballistix\0", NULL, "Coconuts Japan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ballistxRomInfo, pce_ballistxRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bari Bari Densetsu

static struct BurnRomInfo pce_baribariRomDesc[] = {
	{ "bari bari densetsu (japan).pce", 0x060000, 0xc267e25d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_baribari)
STD_ROM_FN(pce_baribari)

struct BurnDriver BurnDrvpce_baribari = {
	"pce_baribari", NULL, NULL, NULL, "1989",
	"Bari Bari Densetsu\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_baribariRomInfo, pce_baribariRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Barunba

static struct BurnRomInfo pce_barunbaRomDesc[] = {
	{ "barunba (japan).pce", 0x080000, 0x4a3df3ca, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_barunba)
STD_ROM_FN(pce_barunba)

struct BurnDriver BurnDrvpce_barunba = {
	"pce_barunba", NULL, NULL, NULL, "1990",
	"Barunba\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_barunbaRomInfo, pce_barunbaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Batman

static struct BurnRomInfo pce_batmanRomDesc[] = {
	{ "batman (japan).pce", 0x060000, 0x106bb7b2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_batman)
STD_ROM_FN(pce_batman)

struct BurnDriver BurnDrvpce_batman = {
	"pce_batman", NULL, NULL, NULL, "1990",
	"Batman\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_batmanRomInfo, pce_batmanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Battle Lode Runner

static struct BurnRomInfo pce_batloderRomDesc[] = {
	{ "battle lode runner (japan).pce", 0x040000, 0x59e44f45, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_batloder)
STD_ROM_FN(pce_batloder)

struct BurnDriver BurnDrvpce_batloder = {
	"pce_batloder", NULL, NULL, NULL, "1993",
	"Battle Lode Runner\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_batloderRomInfo, pce_batloderRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Be Ball

static struct BurnRomInfo pce_beballRomDesc[] = {
	{ "be ball (japan).pce", 0x040000, 0xe439f299, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_beball)
STD_ROM_FN(pce_beball)

struct BurnDriver BurnDrvpce_beball = {
	"pce_beball", NULL, NULL, NULL, "1990",
	"Be Ball\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_beballRomInfo, pce_beballRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Benkei Gaiden

static struct BurnRomInfo pce_benkeiRomDesc[] = {
	{ "benkei gaiden (japan).pce", 0x060000, 0xe1a73797, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_benkei)
STD_ROM_FN(pce_benkei)

struct BurnDriverD BurnDrvpce_benkei = {
	"pce_benkei", NULL, NULL, NULL, "1989",
	"Benkei Gaiden\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_benkeiRomInfo, pce_benkeiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Benkei Gaiden (Alt)

static struct BurnRomInfo pce_benkei1RomDesc[] = {
	{ "benkei gaiden (japan) [a].pce", 0x060000, 0xc9626a43, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_benkei1)
STD_ROM_FN(pce_benkei1)

struct BurnDriverD BurnDrvpce_benkei1 = {
	"pce_benkei1", "pce_benkei", NULL, NULL, "1989",
	"Benkei Gaiden (Alt)\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_benkei1RomInfo, pce_benkei1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bikkuriman World

static struct BurnRomInfo pce_bikkuriRomDesc[] = {
	{ "bikkuriman world (japan).pce", 0x040000, 0x2841fd1e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bikkuri)
STD_ROM_FN(pce_bikkuri)

struct BurnDriver BurnDrvpce_bikkuri = {
	"pce_bikkuri", NULL, NULL, NULL, "1987",
	"Bikkuriman World\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bikkuriRomInfo, pce_bikkuriRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bikkuriman World (Alt)

static struct BurnRomInfo pce_bikkuri1RomDesc[] = {
	{ "bikkuriman world (japan) [a].pce", 0x040000, 0x34893891, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bikkuri1)
STD_ROM_FN(pce_bikkuri1)

struct BurnDriver BurnDrvpce_bikkuri1 = {
	"pce_bikkuri1", "pce_bikkuri", NULL, NULL, "1987",
	"Bikkuriman World (Alt)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bikkuri1RomInfo, pce_bikkuri1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Blodia

static struct BurnRomInfo pce_blodiaRomDesc[] = {
	{ "blodia (japan).pce", 0x020000, 0x958bcd09, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_blodia)
STD_ROM_FN(pce_blodia)

struct BurnDriver BurnDrvpce_blodia = {
	"pce_blodia", NULL, NULL, NULL, "1990",
	"Blodia\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_blodiaRomInfo, pce_blodiaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Body Conquest II

static struct BurnRomInfo pce_bodycon2RomDesc[] = {
	{ "body conquest ii (japan).pce", 0x080000, 0xffd92458, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bodycon2)
STD_ROM_FN(pce_bodycon2)

struct BurnDriver BurnDrvpce_bodycon2 = {
	"pce_bodycon2", NULL, NULL, NULL, "1993",
	"Body Conquest II\0", NULL, "Games Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bodycon2RomInfo, pce_bodycon2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman '93

static struct BurnRomInfo pce_bombmn93RomDesc[] = {
	{ "bomberman '93 (japan).pce", 0x080000, 0xb300c5d0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bombmn93)
STD_ROM_FN(pce_bombmn93)

struct BurnDriver BurnDrvpce_bombmn93 = {
	"pce_bombmn93", NULL, NULL, NULL, "1992",
	"Bomberman '93\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bombmn93RomInfo, pce_bombmn93RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman '93 (Special Version)

static struct BurnRomInfo pce_bombmn93sRomDesc[] = {
	{ "bomberman '93 (special version) (japan).pce", 0x080000, 0x02309aa0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bombmn93s)
STD_ROM_FN(pce_bombmn93s)

struct BurnDriver BurnDrvpce_bombmn93s = {
	"pce_bombmn93s", "pce_bombmn93", NULL, NULL, "1992",
	"Bomberman '93 (Special Version)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bombmn93sRomInfo, pce_bombmn93sRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman '94

static struct BurnRomInfo pce_bombmn94RomDesc[] = {
	{ "bomberman '94 (japan).pce", 0x100000, 0x05362516, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bombmn94)
STD_ROM_FN(pce_bombmn94)

struct BurnDriver BurnDrvpce_bombmn94 = {
	"pce_bombmn94", NULL, NULL, NULL, "1993",
	"Bomberman '94\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bombmn94RomInfo, pce_bombmn94RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman

static struct BurnRomInfo pce_bombmanRomDesc[] = {
	{ "bomberman (japan).pce", 0x040000, 0x9abb4d1f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bombman)
STD_ROM_FN(pce_bombman)

struct BurnDriver BurnDrvpce_bombman = {
	"pce_bombman", NULL, NULL, NULL, "1990",
	"Bomberman\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bombmanRomInfo, pce_bombmanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman - Users Battle

static struct BurnRomInfo pce_bombmnubRomDesc[] = {
	{ "bomberman - users battle (japan).pce", 0x040000, 0x1489fa51, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bombmnub)
STD_ROM_FN(pce_bombmnub)

struct BurnDriver BurnDrvpce_bombmnub = {
	"pce_bombmnub", NULL, NULL, NULL, "19??",
	"Bomberman - Users Battle\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bombmnubRomInfo, pce_bombmnubRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bouken Danshaku Don - The Lost Sunheart

static struct BurnRomInfo pce_lostsunhRomDesc[] = {
	{ "bouken danshaku don - the lost sunheart (japan).pce", 0x080000, 0x8f4d9f94, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_lostsunh)
STD_ROM_FN(pce_lostsunh)

struct BurnDriver BurnDrvpce_lostsunh = {
	"pce_lostsunh", NULL, NULL, NULL, "1992",
	"Bouken Danshaku Don - The Lost Sunheart\0", "Bad sound", "IMax", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_lostsunhRomInfo, pce_lostsunhRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Break In

static struct BurnRomInfo pce_breakinRomDesc[] = {
	{ "break in (japan).pce", 0x040000, 0xc9d7426a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_breakin)
STD_ROM_FN(pce_breakin)

struct BurnDriver BurnDrvpce_breakin = {
	"pce_breakin", NULL, NULL, NULL, "1989",
	"Break In\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_breakinRomInfo, pce_breakinRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bubblegum Crash! - Knight Sabers 2034

static struct BurnRomInfo pce_bubblegmRomDesc[] = {
	{ "bubblegum crash! - knight sabers 2034 (japan).pce", 0x080000, 0x0d766139, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bubblegm)
STD_ROM_FN(pce_bubblegm)

struct BurnDriver BurnDrvpce_bubblegm = {
	"pce_bubblegm", NULL, NULL, NULL, "1991",
	"Bubblegum Crash! - Knight Sabers 2034\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bubblegmRomInfo, pce_bubblegmRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bull Fight - Ring no Haja

static struct BurnRomInfo pce_bullfghtRomDesc[] = {
	{ "bull fight - ring no haja (japan).pce", 0x060000, 0x5c4d1991, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bullfght)
STD_ROM_FN(pce_bullfght)

struct BurnDriver BurnDrvpce_bullfght = {
	"pce_bullfght", NULL, NULL, NULL, "1989",
	"Bull Fight - Ring no Haja\0", NULL, "Cream", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bullfghtRomInfo, pce_bullfghtRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Burning Angels

static struct BurnRomInfo pce_burnanglRomDesc[] = {
	{ "burning angels (japan).pce", 0x060000, 0xd233c05a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_burnangl)
STD_ROM_FN(pce_burnangl)

struct BurnDriver BurnDrvpce_burnangl = {
	"pce_burnangl", NULL, NULL, NULL, "1990",
	"Burning Angels\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_burnanglRomInfo, pce_burnanglRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Busou Keiji - Cyber Cross

static struct BurnRomInfo pce_cyberxRomDesc[] = {
	{ "busou keiji - cyber cross (japan).pce", 0x060000, 0xd0c250ca, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cyberx)
STD_ROM_FN(pce_cyberx)

struct BurnDriver BurnDrvpce_cyberx = {
	"pce_cyberx", NULL, NULL, NULL, "1989",
	"Busou Keiji - Cyber Cross\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cyberxRomInfo, pce_cyberxRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cadash

static struct BurnRomInfo pce_cadashRomDesc[] = {
	{ "cadash (japan).pce", 0x060000, 0x8dc0d85f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cadash)
STD_ROM_FN(pce_cadash)

struct BurnDriver BurnDrvpce_cadash = {
	"pce_cadash", NULL, NULL, NULL, "1991",
	"Cadash\0", "Bad graphics", "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cadashRomInfo, pce_cadashRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Champion Wrestler

static struct BurnRomInfo pce_champwrsRomDesc[] = {
	{ "champion wrestler (japan).pce", 0x060000, 0x9edc0aea, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_champwrs)
STD_ROM_FN(pce_champwrs)

struct BurnDriver BurnDrvpce_champwrs = {
	"pce_champwrs", NULL, NULL, NULL, "1990",
	"Champion Wrestler\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_champwrsRomInfo, pce_champwrsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Chibi Maruko Chan - Quiz de Piihyara

static struct BurnRomInfo pce_chibimRomDesc[] = {
	{ "chibi maruko chan - quiz de piihyara (japan).pce", 0x080000, 0x951ed380, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_chibim)
STD_ROM_FN(pce_chibim)

struct BurnDriver BurnDrvpce_chibim = {
	"pce_chibim", NULL, NULL, NULL, "1992",
	"Chibi Maruko Chan - Quiz de Piihyara\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_chibimRomInfo, pce_chibimRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Chikudenya Toubei - Kubikiri Yakata Yori

static struct BurnRomInfo pce_chikudenRomDesc[] = {
	{ "chikudenya toubei - kubikiri yakata yori (japan).pce", 0x080000, 0xcab21b2e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_chikuden)
STD_ROM_FN(pce_chikuden)

struct BurnDriver BurnDrvpce_chikuden = {
	"pce_chikuden", NULL, NULL, NULL, "1990",
	"Chikudenya Toubei - Kubikiri Yakata Yori\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_chikudenRomInfo, pce_chikudenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Chikudenya Toubei - Kubikiri Yakata Yori (Alt)

static struct BurnRomInfo pce_chikuden1RomDesc[] = {
	{ "chikudenya toubei - kubikiri yakata yori (japan) [a].pce", 0x080000, 0x84098884, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_chikuden1)
STD_ROM_FN(pce_chikuden1)

struct BurnDriver BurnDrvpce_chikuden1 = {
	"pce_chikuden1", "pce_chikuden", NULL, NULL, "1990",
	"Chikudenya Toubei - Kubikiri Yakata Yori (Alt)\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_chikuden1RomInfo, pce_chikuden1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Chouzetsu Rinjin - Bravoman

static struct BurnRomInfo pce_bravomanRomDesc[] = {
	{ "chouzetsu rinjin - bravoman (japan).pce", 0x080000, 0x0df57c90, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_bravoman)
STD_ROM_FN(pce_bravoman)

struct BurnDriver BurnDrvpce_bravoman = {
	"pce_bravoman", NULL, NULL, NULL, "1990",
	"Chouzetsu Rinjin - Bravoman\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_bravomanRomInfo, pce_bravomanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Circus Lido

static struct BurnRomInfo pce_circusldRomDesc[] = {
	{ "circus lido (japan).pce", 0x040000, 0xc3212c24, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_circusld)
STD_ROM_FN(pce_circusld)

struct BurnDriver BurnDrvpce_circusld = {
	"pce_circusld", NULL, NULL, NULL, "1991",
	"Circus Lido\0", NULL, "Yuni Post", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_circusldRomInfo, pce_circusldRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// City Hunter

static struct BurnRomInfo pce_cityhuntRomDesc[] = {
	{ "city hunter (japan).pce", 0x060000, 0xf91b055f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cityhunt)
STD_ROM_FN(pce_cityhunt)

struct BurnDriver BurnDrvpce_cityhunt = {
	"pce_cityhunt", NULL, NULL, NULL, "1990",
	"City Hunter\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cityhuntRomInfo, pce_cityhuntRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Columns

static struct BurnRomInfo pce_columnsRomDesc[] = {
	{ "columns (japan).pce", 0x020000, 0x99f7a572, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_columns)
STD_ROM_FN(pce_columns)

struct BurnDriver BurnDrvpce_columns = {
	"pce_columns", NULL, NULL, NULL, "1991",
	"Columns\0", NULL, "Nihon Telenet", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_columnsRomInfo, pce_columnsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Coryoon - Child of Dragon

static struct BurnRomInfo pce_coryoonRomDesc[] = {
	{ "coryoon - child of dragon (japan).pce", 0x080000, 0xb4d29e3b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_coryoon)
STD_ROM_FN(pce_coryoon)

struct BurnDriver BurnDrvpce_coryoon = {
	"pce_coryoon", NULL, NULL, NULL, "1991",
	"Coryoon - Child of Dragon\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_coryoonRomInfo, pce_coryoonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Coryoon - Child of Dragon (Alt)

static struct BurnRomInfo pce_coryoon1RomDesc[] = {
	{ "coryoon - child of dragon (japan) [a].pce", 0x080000, 0xd5389889, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_coryoon1)
STD_ROM_FN(pce_coryoon1)

struct BurnDriver BurnDrvpce_coryoon1 = {
	"pce_coryoon1", "pce_coryoon", NULL, NULL, "1991",
	"Coryoon - Child of Dragon (Alt)\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_coryoon1RomInfo, pce_coryoon1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cross Wiber - Cyber Combat Police

static struct BurnRomInfo pce_xwiberRomDesc[] = {
	{ "cross wiber - cyber combat police (japan).pce", 0x080000, 0x2df97bd0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_xwiber)
STD_ROM_FN(pce_xwiber)

struct BurnDriver BurnDrvpce_xwiber = {
	"pce_xwiber", NULL, NULL, NULL, "1990",
	"Cross Wiber - Cyber Combat Police\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_xwiberRomInfo, pce_xwiberRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cyber Core

static struct BurnRomInfo pce_cybrcoreRomDesc[] = {
	{ "cyber core (japan).pce", 0x060000, 0xa98d276a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cybrcore)
STD_ROM_FN(pce_cybrcore)

struct BurnDriver BurnDrvpce_cybrcore = {
	"pce_cybrcore", NULL, NULL, NULL, "1990",
	"Cyber Core\0", NULL, "IGS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cybrcoreRomInfo, pce_cybrcoreRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cyber Dodge

static struct BurnRomInfo pce_cyberdodRomDesc[] = {
	{ "cyber dodge (japan).pce", 0x080000, 0xb5326b16, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cyberdod)
STD_ROM_FN(pce_cyberdod)

struct BurnDriver BurnDrvpce_cyberdod = {
	"pce_cyberdod", NULL, NULL, NULL, "1992",
	"Cyber Dodge\0", NULL, "Tonkin House", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cyberdodRomInfo, pce_cyberdodRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cyber Knight

static struct BurnRomInfo pce_cyknightRomDesc[] = {
	{ "cyber knight (japan).pce", 0x080000, 0xa594fac0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cyknight)
STD_ROM_FN(pce_cyknight)

struct BurnDriver BurnDrvpce_cyknight = {
	"pce_cyknight", NULL, NULL, NULL, "1990",
	"Cyber Knight\0", NULL, "Tonkin House", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cyknightRomInfo, pce_cyknightRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dai Senpu

static struct BurnRomInfo pce_daisenpuRomDesc[] = {
	{ "dai senpu (japan).pce", 0x080000, 0x9107bcc8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_daisenpu)
STD_ROM_FN(pce_daisenpu)

struct BurnDriver BurnDrvpce_daisenpu = {
	"pce_daisenpu", NULL, NULL, NULL, "1990",
	"Dai Senpu\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_daisenpuRomInfo, pce_daisenpuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Daichi Kun Crisis - Do Natural

static struct BurnRomInfo pce_donaturlRomDesc[] = {
	{ "daichi kun crisis - do natural (japan).pce", 0x060000, 0x61a2935f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_donaturl)
STD_ROM_FN(pce_donaturl)

struct BurnDriver BurnDrvpce_donaturl = {
	"pce_donaturl", NULL, NULL, NULL, "1989",
	"Daichi Kun Crisis - Do Natural\0", NULL, "Salio", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_donaturlRomInfo, pce_donaturlRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Darius Alpha

static struct BurnRomInfo pce_dariusaRomDesc[] = {
	{ "darius alpha (japan).pce", 0x060000, 0xb0ba689f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dariusa)
STD_ROM_FN(pce_dariusa)

struct BurnDriver BurnDrvpce_dariusa = {
	"pce_dariusa", NULL, NULL, NULL, "1990",
	"Darius Alpha\0", NULL, "NEC Avenue", "SuperGrafx Enhanced",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dariusaRomInfo, pce_dariusaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Darius Plus

static struct BurnRomInfo pce_dariuspRomDesc[] = {
	{ "darius plus (japan).pce", 0x0c0000, 0xbebfe042, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dariusp)
STD_ROM_FN(pce_dariusp)

struct BurnDriver BurnDrvpce_dariusp = {
	"pce_dariusp", NULL, NULL, NULL, "1990",
	"Darius Plus\0", NULL, "NEC Avenue", "SuperGrafx Enhanced",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dariuspRomInfo, pce_dariuspRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dead Moon - Tsuki Sekai no Akumu

static struct BurnRomInfo pce_deadmoonRomDesc[] = {
	{ "dead moon (japan).pce", 0x080000, 0x56739bc7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_deadmoon)
STD_ROM_FN(pce_deadmoon)

struct BurnDriver BurnDrvpce_deadmoon = {
	"pce_deadmoon", NULL, NULL, NULL, "1990",
	"Dead Moon - Tsuki Sekai no Akumu\0", NULL, "B.S.S.", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_deadmoonRomInfo, pce_deadmoonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Deep Blue - Kaitei Shinwa

static struct BurnRomInfo pce_deepblueRomDesc[] = {
	{ "deep blue - kaitei shinwa (japan).pce", 0x040000, 0x053a0f83, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_deepblue)
STD_ROM_FN(pce_deepblue)

struct BurnDriver BurnDrvpce_deepblue = {
	"pce_deepblue", NULL, NULL, NULL, "1989",
	"Deep Blue - Kaitei Shinwa\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_deepblueRomInfo, pce_deepblueRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Detana!! Twinbee

static struct BurnRomInfo pce_twinbeeRomDesc[] = {
	{ "detana!! twinbee (japan).pce", 0x080000, 0x5cf59d80, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_twinbee)
STD_ROM_FN(pce_twinbee)

struct BurnDriver BurnDrvpce_twinbee = {
	"pce_twinbee", NULL, NULL, NULL, "1992",
	"Detana!! Twinbee\0", NULL, "Konami", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_twinbeeRomInfo, pce_twinbeeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Devil Crash - Naxat Pinball

static struct BurnRomInfo pce_devlcrshRomDesc[] = {
	{ "devil crash - naxat pinball (japan).pce", 0x060000, 0x4ec81a80, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_devlcrsh)
STD_ROM_FN(pce_devlcrsh)

struct BurnDriver BurnDrvpce_devlcrsh = {
	"pce_devlcrsh", NULL, NULL, NULL, "1990",
	"Devil Crash - Naxat Pinball\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_devlcrshRomInfo, pce_devlcrshRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Die Hard

static struct BurnRomInfo pce_diehardRomDesc[] = {
	{ "die hard (japan).pce", 0x080000, 0x1b5b1cb1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_diehard)
STD_ROM_FN(pce_diehard)

struct BurnDriver BurnDrvpce_diehard = {
	"pce_diehard", NULL, NULL, NULL, "1990",
	"Die Hard\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_diehardRomInfo, pce_diehardRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Digital Champ

static struct BurnRomInfo pce_digichmpRomDesc[] = {
	{ "digital champ (japan).pce", 0x040000, 0x17ba3032, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_digichmp)
STD_ROM_FN(pce_digichmp)

struct BurnDriver BurnDrvpce_digichmp = {
	"pce_digichmp", NULL, NULL, NULL, "1989",
	"Digital Champ\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_digichmpRomInfo, pce_digichmpRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Don Doko Don!

static struct BurnRomInfo pce_dondokoRomDesc[] = {
	{ "don doko don! (japan).pce", 0x060000, 0xf42aa73e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dondoko)
STD_ROM_FN(pce_dondoko)

struct BurnDriver BurnDrvpce_dondoko = {
	"pce_dondoko", NULL, NULL, NULL, "1990",
	"Don Doko Don!\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dondokoRomInfo, pce_dondokoRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Doraemon - Meikyuu Dai Sakusen

static struct BurnRomInfo pce_doramsRomDesc[] = {
	{ "doraemon - meikyuu dai sakusen (japan).pce", 0x040000, 0xdc760a07, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dorams)
STD_ROM_FN(pce_dorams)

struct BurnDriver BurnDrvpce_dorams = {
	"pce_dorams", NULL, NULL, NULL, "1989",
	"Doraemon - Meikyuu Dai Sakusen\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_doramsRomInfo, pce_doramsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Doraemon - Nobita no Dorabian Night

static struct BurnRomInfo pce_dorandnRomDesc[] = {
	{ "doraemon - nobita no dorabian night (japan).pce", 0x080000, 0x013a747f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dorandn)
STD_ROM_FN(pce_dorandn)

struct BurnDriver BurnDrvpce_dorandn = {
	"pce_dorandn", NULL, NULL, NULL, "1991",
	"Doraemon - Nobita no Dorabian Night\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dorandnRomInfo, pce_dorandnRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Double Dungeons - W

static struct BurnRomInfo pce_ddungwRomDesc[] = {
	{ "double dungeons - w (japan).pce", 0x040000, 0x86087b39, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ddungw)
STD_ROM_FN(pce_ddungw)

struct BurnDriver BurnDrvpce_ddungw = {
	"pce_ddungw", NULL, NULL, NULL, "1989",
	"Double Dungeons - W\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ddungwRomInfo, pce_ddungwRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Download

static struct BurnRomInfo pce_downloadRomDesc[] = {
	{ "download (japan).pce", 0x080000, 0x85101c20, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_download)
STD_ROM_FN(pce_download)

struct BurnDriver BurnDrvpce_download = {
	"pce_download", NULL, NULL, NULL, "1990",
	"Download\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_downloadRomInfo, pce_downloadRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Download (Alt)

static struct BurnRomInfo pce_download1RomDesc[] = {
	{ "download (japan) [a].pce", 0x080000, 0x4e0de488, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_download1)
STD_ROM_FN(pce_download1)

struct BurnDriver BurnDrvpce_download1 = {
	"pce_download1", "pce_download", NULL, NULL, "1990",
	"Download (Alt)\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_download1RomInfo, pce_download1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dragon Egg!

static struct BurnRomInfo pce_dragneggRomDesc[] = {
	{ "dragon egg! (japan).pce", 0x080000, 0x442405d5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dragnegg)
STD_ROM_FN(pce_dragnegg)

struct BurnDriver BurnDrvpce_dragnegg = {
	"pce_dragnegg", NULL, NULL, NULL, "1991",
	"Dragon Egg!\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dragneggRomInfo, pce_dragneggRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dragon Saber - After Story of Dragon Spirit

static struct BurnRomInfo pce_dsaberRomDesc[] = {
	{ "dragon saber - after story of dragon spirit (japan).pce", 0x080000, 0x3219849c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dsaber)
STD_ROM_FN(pce_dsaber)

struct BurnDriver BurnDrvpce_dsaber = {
	"pce_dsaber", NULL, NULL, NULL, "1991",
	"Dragon Saber - After Story of Dragon Spirit\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dsaberRomInfo, pce_dsaberRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dragon Saber - After Story of Dragon Spirit (Alt)

static struct BurnRomInfo pce_dsaber1RomDesc[] = {
	{ "dragon saber - after story of dragon spirit (japan) [a].pce", 0x080000, 0xc89ce75a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dsaber1)
STD_ROM_FN(pce_dsaber1)

struct BurnDriver BurnDrvpce_dsaber1 = {
	"pce_dsaber1", "pce_dsaber", NULL, NULL, "1991",
	"Dragon Saber - After Story of Dragon Spirit (Alt)\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dsaber1RomInfo, pce_dsaber1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dragon Spirit

static struct BurnRomInfo pce_dspiritRomDesc[] = {
	{ "dragon spirit (japan).pce", 0x040000, 0x01a76935, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dspirit)
STD_ROM_FN(pce_dspirit)

struct BurnDriver BurnDrvpce_dspirit = {
	"pce_dspirit", NULL, NULL, NULL, "1988",
	"Dragon Spirit\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dspiritRomInfo, pce_dspiritRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Drop Rock Hora Hora

static struct BurnRomInfo pce_droprockRomDesc[] = {
	{ "drop rock hora hora (japan).pce", 0x040000, 0x67ec5ec4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_droprock)
STD_ROM_FN(pce_droprock)

struct BurnDriver BurnDrvpce_droprock = {
	"pce_droprock", NULL, NULL, NULL, "1990",
	"Drop Rock Hora Hora\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_droprockRomInfo, pce_droprockRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Drop Rock Hora Hora (Alt)

static struct BurnRomInfo pce_droprock1RomDesc[] = {
	{ "drop rock hora hora (japan) [a].pce", 0x040000, 0x8e81fcac, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_droprock1)
STD_ROM_FN(pce_droprock1)

struct BurnDriver BurnDrvpce_droprock1 = {
	"pce_droprock1", "pce_droprock", NULL, NULL, "1990",
	"Drop Rock Hora Hora (Alt)\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_droprock1RomInfo, pce_droprock1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dungeon Explorer

static struct BurnRomInfo pce_dungexplRomDesc[] = {
	{ "dungeon explorer (japan).pce", 0x060000, 0x1b1a80a2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_dungexpl)
STD_ROM_FN(pce_dungexpl)

struct BurnDriver BurnDrvpce_dungexpl = {
	"pce_dungexpl", NULL, NULL, NULL, "1989",
	"Dungeon Explorer\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_dungexplRomInfo, pce_dungexplRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Energy

static struct BurnRomInfo pce_energyRomDesc[] = {
	{ "energy (japan).pce", 0x040000, 0xca68ff21, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_energy)
STD_ROM_FN(pce_energy)

struct BurnDriver BurnDrvpce_energy = {
	"pce_energy", NULL, NULL, NULL, "1989",
	"Energy\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_energyRomInfo, pce_energyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F-1 Dream

static struct BurnRomInfo pce_f1dreamRomDesc[] = {
	{ "f-1 dream (japan).pce", 0x040000, 0xd50ff730, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1dream)
STD_ROM_FN(pce_f1dream)

struct BurnDriver BurnDrvpce_f1dream = {
	"pce_f1dream", NULL, NULL, NULL, "1989",
	"F-1 Dream\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1dreamRomInfo, pce_f1dreamRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F-1 Pilot - You're King of Kings

static struct BurnRomInfo pce_f1pilotRomDesc[] = {
	{ "f-1 pilot - you're king of kings (japan).pce", 0x060000, 0x09048174, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1pilot)
STD_ROM_FN(pce_f1pilot)

struct BurnDriver BurnDrvpce_f1pilot = {
	"pce_f1pilot", NULL, NULL, NULL, "1989",
	"F-1 Pilot - You're King of Kings\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1pilotRomInfo, pce_f1pilotRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F1 Circus '91 - World Championship

static struct BurnRomInfo pce_f1circ91RomDesc[] = {
	{ "f1 circus '91 - world championship (japan).pce", 0x080000, 0xd7cfd70f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1circ91)
STD_ROM_FN(pce_f1circ91)

struct BurnDriver BurnDrvpce_f1circ91 = {
	"pce_f1circ91", NULL, NULL, NULL, "1991",
	"F1 Circus '91 - World Championship\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1circ91RomInfo, pce_f1circ91RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F1 Circus '92 - The Speed of Sound

static struct BurnRomInfo pce_f1circ92RomDesc[] = {
	{ "f1 circus '92 - the speed of sound (japan).pce", 0x0c0000, 0xb268f2a2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1circ92)
STD_ROM_FN(pce_f1circ92)

struct BurnDriver BurnDrvpce_f1circ92 = {
	"pce_f1circ92", NULL, NULL, NULL, "1992",
	"F1 Circus '92 - The Speed of Sound\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1circ92RomInfo, pce_f1circ92RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F1 Circus

static struct BurnRomInfo pce_f1circusRomDesc[] = {
	{ "f1 circus (japan).pce", 0x080000, 0xe14dee08, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1circus)
STD_ROM_FN(pce_f1circus)

struct BurnDriver BurnDrvpce_f1circus = {
	"pce_f1circus", NULL, NULL, NULL, "1990",
	"F1 Circus\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1circusRomInfo, pce_f1circusRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F1 Circus (Alt)

static struct BurnRomInfo pce_f1circus1RomDesc[] = {
	{ "f1 circus (japan) [a].pce", 0x080000, 0x79705779, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1circus1)
STD_ROM_FN(pce_f1circus1)

struct BurnDriver BurnDrvpce_f1circus1 = {
	"pce_f1circus1", "pce_f1circus", NULL, NULL, "1990",
	"F1 Circus (Alt)\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1circus1RomInfo, pce_f1circus1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// F1 Triple Battle

static struct BurnRomInfo pce_f1tbRomDesc[] = {
	{ "f1 triple battle (japan).pce", 0x060000, 0x13bf0409, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_f1tb)
STD_ROM_FN(pce_f1tb)

struct BurnDriver BurnDrvpce_f1tb = {
	"pce_f1tb", NULL, NULL, NULL, "1989",
	"F1 Triple Battle\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_f1tbRomInfo, pce_f1tbRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fantasy Zone

static struct BurnRomInfo pce_fantzoneRomDesc[] = {
	{ "fantasy zone (japan).pce", 0x040000, 0x72cb0f9d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fantzone)
STD_ROM_FN(pce_fantzone)

struct BurnDriver BurnDrvpce_fantzone = {
	"pce_fantzone", NULL, NULL, NULL, "1988",
	"Fantasy Zone\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fantzoneRomInfo, pce_fantzoneRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fighting Run

static struct BurnRomInfo pce_fightrunRomDesc[] = {
	{ "fighting run (japan).pce", 0x080000, 0x1828d2e5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fightrun)
STD_ROM_FN(pce_fightrun)

struct BurnDriver BurnDrvpce_fightrun = {
	"pce_fightrun", NULL, NULL, NULL, "1991",
	"Fighting Run\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fightrunRomInfo, pce_fightrunRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Final Blaster

static struct BurnRomInfo pce_finlblstRomDesc[] = {
	{ "final blaster (japan).pce", 0x060000, 0xc90971ba, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_finlblst)
STD_ROM_FN(pce_finlblst)

struct BurnDriver BurnDrvpce_finlblst = {
	"pce_finlblst", NULL, NULL, NULL, "1990",
	"Final Blaster\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_finlblstRomInfo, pce_finlblstRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Final Lap Twin

static struct BurnRomInfo pce_finallapRomDesc[] = {
	{ "final lap twin (japan).pce", 0x060000, 0xc8c084e3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_finallap)
STD_ROM_FN(pce_finallap)

struct BurnDriver BurnDrvpce_finallap = {
	"pce_finallap", NULL, NULL, NULL, "1989",
	"Final Lap Twin\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_finallapRomInfo, pce_finallapRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Final Match Tennis

static struct BurnRomInfo pce_finalmtRomDesc[] = {
	{ "final match tennis (japan).pce", 0x040000, 0x560d2305, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_finalmt)
STD_ROM_FN(pce_finalmt)

struct BurnDriver BurnDrvpce_finalmt = {
	"pce_finalmt", NULL, NULL, NULL, "1991",
	"Final Match Tennis\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_finalmtRomInfo, pce_finalmtRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Final Soldier

static struct BurnRomInfo pce_finalsolRomDesc[] = {
	{ "final soldier (japan).pce", 0x080000, 0xaf2dd2af, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_finalsol)
STD_ROM_FN(pce_finalsol)

struct BurnDriver BurnDrvpce_finalsol = {
	"pce_finalsol", NULL, NULL, NULL, "1991",
	"Final Soldier\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_finalsolRomInfo, pce_finalsolRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Final Soldier (Special Version)

static struct BurnRomInfo pce_finalsolsRomDesc[] = {
	{ "final soldier (special version) (japan).pce", 0x080000, 0x02a578c5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_finalsols)
STD_ROM_FN(pce_finalsols)

struct BurnDriver BurnDrvpce_finalsols = {
	"pce_finalsols", "pce_finalsol", NULL, NULL, "19??",
	"Final Soldier (Special Version)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_finalsolsRomInfo, pce_finalsolsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fire Pro Wrestling - Combination Tag

static struct BurnRomInfo pce_fireprowRomDesc[] = {
	{ "fire pro wrestling - combination tag (japan).pce", 0x060000, 0x90ed6575, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fireprow)
STD_ROM_FN(pce_fireprow)

struct BurnDriver BurnDrvpce_fireprow = {
	"pce_fireprow", NULL, NULL, NULL, "1989",
	"Fire Pro Wrestling - Combination Tag\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fireprowRomInfo, pce_fireprowRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fire Pro Wrestling 2 - 2nd Bout

static struct BurnRomInfo pce_fireprw2RomDesc[] = {
	{ "fire pro wrestling 2 - 2nd bout (japan).pce", 0x080000, 0xe88987bb, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fireprw2)
STD_ROM_FN(pce_fireprw2)

struct BurnDriver BurnDrvpce_fireprw2 = {
	"pce_fireprw2", NULL, NULL, NULL, "1991",
	"Fire Pro Wrestling 2 - 2nd Bout\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fireprw2RomInfo, pce_fireprw2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fire Pro Wrestling 3 - Legend Bout

static struct BurnRomInfo pce_fireprw3RomDesc[] = {
	{ "fire pro wrestling 3 - legend bout (japan).pce", 0x100000, 0x534e8808, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fireprw3)
STD_ROM_FN(pce_fireprw3)

struct BurnDriver BurnDrvpce_fireprw3 = {
	"pce_fireprw3", NULL, NULL, NULL, "1992",
	"Fire Pro Wrestling 3 - Legend Bout\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fireprw3RomInfo, pce_fireprw3RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Formation Soccer - Human Cup '90

static struct BurnRomInfo pce_fsoccr90RomDesc[] = {
	{ "formation soccer - human cup '90 (japan).pce", 0x040000, 0x85a1e7b6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fsoccr90)
STD_ROM_FN(pce_fsoccr90)

struct BurnDriver BurnDrvpce_fsoccr90 = {
	"pce_fsoccr90", NULL, NULL, NULL, "1990",
	"Formation Soccer - Human Cup '90\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fsoccr90RomInfo, pce_fsoccr90RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Formation Soccer - On J. League

static struct BurnRomInfo pce_fsoccerRomDesc[] = {
	{ "formation soccer - on j. league (japan).pce", 0x080000, 0x7146027c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_fsoccer)
STD_ROM_FN(pce_fsoccer)

struct BurnDriver BurnDrvpce_fsoccer = {
	"pce_fsoccer", NULL, NULL, NULL, "1994",
	"Formation Soccer - On J. League\0", NULL, "Human", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_fsoccerRomInfo, pce_fsoccerRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fushigi no Yume no Alice

static struct BurnRomInfo pce_aliceRomDesc[] = {
	{ "fushigi no yume no alice (japan).pce", 0x060000, 0x12c4e6fd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_alice)
STD_ROM_FN(pce_alice)

struct BurnDriver BurnDrvpce_alice = {
	"pce_alice", NULL, NULL, NULL, "1990",
	"Fushigi no Yume no Alice\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_aliceRomInfo, pce_aliceRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gai Flame

static struct BurnRomInfo pce_gaiflameRomDesc[] = {
	{ "gai flame (japan).pce", 0x060000, 0x95f90dec, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gaiflame)
STD_ROM_FN(pce_gaiflame)

struct BurnDriver BurnDrvpce_gaiflame = {
	"pce_gaiflame", NULL, NULL, NULL, "1990",
	"Gai Flame\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gaiflameRomInfo, pce_gaiflameRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gaia no Monshou

static struct BurnRomInfo pce_gaiamonsRomDesc[] = {
	{ "gaia no monshou (japan).pce", 0x040000, 0x6fd6827c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gaiamons)
STD_ROM_FN(pce_gaiamons)

struct BurnDriver BurnDrvpce_gaiamons = {
	"pce_gaiamons", NULL, NULL, NULL, "1988",
	"Gaia no Monshou\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gaiamonsRomInfo, pce_gaiamonsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Galaga '88

static struct BurnRomInfo pce_galaga88RomDesc[] = {
	{ "galaga '88 (japan).pce", 0x040000, 0x1a8393c6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_galaga88)
STD_ROM_FN(pce_galaga88)

struct BurnDriver BurnDrvpce_galaga88 = {
	"pce_galaga88", NULL, NULL, NULL, "1988",
	"Galaga '88\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_galaga88RomInfo, pce_galaga88RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ganbare! Golf Boys

static struct BurnRomInfo pce_ganbgolfRomDesc[] = {
	{ "ganbare! golf boys (japan).pce", 0x040000, 0x27a4d11a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ganbgolf)
STD_ROM_FN(pce_ganbgolf)

struct BurnDriver BurnDrvpce_ganbgolf = {
	"pce_ganbgolf", NULL, NULL, NULL, "1989",
	"Ganbare! Golf Boys\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ganbgolfRomInfo, pce_ganbgolfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gekisha Boy

static struct BurnRomInfo pce_gekisboyRomDesc[] = {
	{ "gekisha boy (japan).pce", 0x080000, 0xe8702d51, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gekisboy)
STD_ROM_FN(pce_gekisboy)

struct BurnDriver BurnDrvpce_gekisboy = {
	"pce_gekisboy", NULL, NULL, NULL, "1992",
	"Gekisha Boy\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gekisboyRomInfo, pce_gekisboyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Genji Tsuushin Agedama

static struct BurnRomInfo pce_genjitsuRomDesc[] = {
	{ "genji tsuushin agedama (japan).pce", 0x080000, 0xad450dfc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_genjitsu)
STD_ROM_FN(pce_genjitsu)

struct BurnDriver BurnDrvpce_genjitsu = {
	"pce_genjitsu", NULL, NULL, NULL, "1991",
	"Genji Tsuushin Agedama\0", NULL, "NEC Home Electronics", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_genjitsuRomInfo, pce_genjitsuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Genpei Toumaden

static struct BurnRomInfo pce_genpeiRomDesc[] = {
	{ "genpei toumaden (japan).pce", 0x080000, 0xb926c682, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_genpei)
STD_ROM_FN(pce_genpei)

struct BurnDriver BurnDrvpce_genpei = {
	"pce_genpei", NULL, NULL, NULL, "1990",
	"Genpei Toumaden\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_genpeiRomInfo, pce_genpeiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Genpei Toumaden ni no Maki

static struct BurnRomInfo pce_genpemakRomDesc[] = {
	{ "genpei toumaden ni no maki (japan).pce", 0x080000, 0x8793758c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_genpemak)
STD_ROM_FN(pce_genpemak)

struct BurnDriver BurnDrvpce_genpemak = {
	"pce_genpemak", NULL, NULL, NULL, "1992",
	"Genpei Toumaden ni no Maki\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_genpemakRomInfo, pce_genpemakRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gokuraku! Chuka Taisen

static struct BurnRomInfo pce_chukataiRomDesc[] = {
	{ "gokuraku! chuuka taisen (japan).pce", 0x060000, 0xe749a22c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_chukatai)
STD_ROM_FN(pce_chukatai)

struct BurnDriver BurnDrvpce_chukatai = {
	"pce_chukatai", NULL, NULL, NULL, "1992",
	"Gokuraku! Chuka Taisen\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_chukataiRomInfo, pce_chukataiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gomola Speed

static struct BurnRomInfo pce_gomolaRomDesc[] = {
	{ "gomola speed (japan).pce", 0x060000, 0x9a353afd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gomola)
STD_ROM_FN(pce_gomola)

struct BurnDriver BurnDrvpce_gomola = {
	"pce_gomola", NULL, NULL, NULL, "1990",
	"Gomola Speed\0", NULL, "UPL", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gomolaRomInfo, pce_gomolaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gradius

static struct BurnRomInfo pce_gradiusRomDesc[] = {
	{ "gradius (japan).pce", 0x040000, 0x0517da65, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gradius)
STD_ROM_FN(pce_gradius)

struct BurnDriver BurnDrvpce_gradius = {
	"pce_gradius", NULL, NULL, NULL, "1991",
	"Gradius\0", NULL, "Konami", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gradiusRomInfo, pce_gradiusRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// GunHed

static struct BurnRomInfo pce_gunhedRomDesc[] = {
	{ "gunhed (japan).pce", 0x060000, 0xa17d4d7e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gunhed)
STD_ROM_FN(pce_gunhed)

struct BurnDriver BurnDrvpce_gunhed = {
	"pce_gunhed", NULL, NULL, NULL, "1989",
	"GunHed\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gunhedRomInfo, pce_gunhedRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// GunHed - Hudson GunHed Taikai

static struct BurnRomInfo pce_gunhedhtRomDesc[] = {
	{ "gunhed - hudson gunhed taikai (japan).pce", 0x040000, 0x57f183ae, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gunhedht)
STD_ROM_FN(pce_gunhedht)

struct BurnDriver BurnDrvpce_gunhedht = {
	"pce_gunhedht", NULL, NULL, NULL, "1989",
	"GunHed - Hudson GunHed Taikai\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gunhedhtRomInfo, pce_gunhedhtRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hana Taaka Daka!?

static struct BurnRomInfo pce_hanatakaRomDesc[] = {
	{ "hana taaka daka! (japan).pce", 0x080000, 0xba4d0dd4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_hanataka)
STD_ROM_FN(pce_hanataka)

struct BurnDriver BurnDrvpce_hanataka = {
	"pce_hanataka", NULL, NULL, NULL, "1991",
	"Hana Taaka Daka!?\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_hanatakaRomInfo, pce_hanatakaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hanii in the Sky

static struct BurnRomInfo pce_haniiskyRomDesc[] = {
	{ "hanii in the sky (japan).pce", 0x040000, 0xbf3e2cc7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_haniisky)
STD_ROM_FN(pce_haniisky)

struct BurnDriver BurnDrvpce_haniisky = {
	"pce_haniisky", NULL, NULL, NULL, "1989",
	"Hanii in the Sky\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_haniiskyRomInfo, pce_haniiskyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hanii on the Road

static struct BurnRomInfo pce_haniirodRomDesc[] = {
	{ "hanii on the road (japan).pce", 0x060000, 0x9897fa86, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_haniirod)
STD_ROM_FN(pce_haniirod)

struct BurnDriver BurnDrvpce_haniirod = {
	"pce_haniirod", NULL, NULL, NULL, "1990",
	"Hanii on the Road\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_haniirodRomInfo, pce_haniirodRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hatris

static struct BurnRomInfo pce_hatrisRomDesc[] = {
	{ "hatris (japan).pce", 0x020000, 0x44e7df53, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_hatris)
STD_ROM_FN(pce_hatris)

struct BurnDriver BurnDrvpce_hatris = {
	"pce_hatris", NULL, NULL, NULL, "1991",
	"Hatris\0", NULL, "Tengen", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_hatrisRomInfo, pce_hatrisRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Heavy Unit

static struct BurnRomInfo pce_hvyunitRomDesc[] = {
	{ "heavy unit (japan).pce", 0x060000, 0xeb923de5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_hvyunit)
STD_ROM_FN(pce_hvyunit)

struct BurnDriver BurnDrvpce_hvyunit = {
	"pce_hvyunit", NULL, NULL, NULL, "1989",
	"Heavy Unit\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_hvyunitRomInfo, pce_hvyunitRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hisou Kihei - Xserd

static struct BurnRomInfo pce_xserdRomDesc[] = {
	{ "hisou kihei - xserd (japan).pce", 0x060000, 0x1cab1ee6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_xserd)
STD_ROM_FN(pce_xserd)

struct BurnDriverD BurnDrvpce_xserd = {
	"pce_xserd", NULL, NULL, NULL, "1990",
	"Hisou Kihei - Xserd\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_xserdRomInfo, pce_xserdRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hit the Ice - VHL - The Official Video Hockey League

static struct BurnRomInfo pce_hiticeRomDesc[] = {
	{ "hit the ice - vhl the official video hockey league (japan).pce", 0x060000, 0x7acb60c8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_hitice)
STD_ROM_FN(pce_hitice)

struct BurnDriver BurnDrvpce_hitice = {
	"pce_hitice", NULL, NULL, NULL, "1991",
	"Hit the Ice - VHL - The Official Video Hockey League\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_hiticeRomInfo, pce_hiticeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Honoo no Toukyuuji - Dodge Danpei

static struct BurnRomInfo pce_ddanpeiRomDesc[] = {
	{ "honoo no toukyuuji dodge danpei (japan).pce", 0x080000, 0xb01ee703, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ddanpei)
STD_ROM_FN(pce_ddanpei)

struct BurnDriver BurnDrvpce_ddanpei = {
	"pce_ddanpei", NULL, NULL, NULL, "1992",
	"Honoo no Toukyuuji - Dodge Danpei\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ddanpeiRomInfo, pce_ddanpeiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Idol Hanafuda Fan Club

static struct BurnRomInfo pce_idolhanaRomDesc[] = {
	{ "idol hanafuda fan club (japan).pce", 0x080000, 0x9ec6fc6c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_idolhana)
STD_ROM_FN(pce_idolhana)

struct BurnDriver BurnDrvpce_idolhana = {
	"pce_idolhana", NULL, NULL, NULL, "1991",
	"Idol Hanafuda Fan Club\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_idolhanaRomInfo, pce_idolhanaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Image Fight

static struct BurnRomInfo pce_imagefgtRomDesc[] = {
	{ "image fight (japan).pce", 0x080000, 0xa80c565f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_imagefgt)
STD_ROM_FN(pce_imagefgt)

struct BurnDriver BurnDrvpce_imagefgt = {
	"pce_imagefgt", NULL, NULL, NULL, "1990",
	"Image Fight\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_imagefgtRomInfo, pce_imagefgtRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// J. League Greatest Eleven

static struct BurnRomInfo pce_jleag11RomDesc[] = {
	{ "j. league greatest eleven (japan).pce", 0x080000, 0x0ad97b04, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_jleag11)
STD_ROM_FN(pce_jleag11)

struct BurnDriver BurnDrvpce_jleag11 = {
	"pce_jleag11", NULL, NULL, NULL, "1993",
	"J. League Greatest Eleven\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_jleag11RomInfo, pce_jleag11RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jack Nicklaus' Greatest 18 Holes of Major Championship Golf

static struct BurnRomInfo pce_nicklausRomDesc[] = {
	{ "jack nicklaus' greatest 18 holes of major championship golf (japan).pce", 0x040000, 0xea751e82, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nicklaus)
STD_ROM_FN(pce_nicklaus)

struct BurnDriver BurnDrvpce_nicklaus = {
	"pce_nicklaus", NULL, NULL, NULL, "1989",
	"Jack Nicklaus' Greatest 18 Holes of Major Championship Golf\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nicklausRomInfo, pce_nicklausRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jackie Chan

static struct BurnRomInfo pce_jchanRomDesc[] = {
	{ "jackie chan (japan).pce", 0x080000, 0xc6fa6373, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_jchan)
STD_ROM_FN(pce_jchan)

struct BurnDriver BurnDrvpce_jchan = {
	"pce_jchan", NULL, NULL, NULL, "1991",
	"Jackie Chan\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_jchanRomInfo, pce_jchanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jigoku Meguri

static struct BurnRomInfo pce_jigomeguRomDesc[] = {
	{ "jigoku meguri (japan).pce", 0x060000, 0xcc7d3eeb, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_jigomegu)
STD_ROM_FN(pce_jigomegu)

struct BurnDriver BurnDrvpce_jigomegu = {
	"pce_jigomegu", NULL, NULL, NULL, "1990",
	"Jigoku Meguri\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_jigomeguRomInfo, pce_jigomeguRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jinmu Denshou

static struct BurnRomInfo pce_jinmuRomDesc[] = {
	{ "jinmu denshou (japan).pce", 0x080000, 0xc150637a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_jinmu)
STD_ROM_FN(pce_jinmu)

struct BurnDriver BurnDrvpce_jinmu = {
	"pce_jinmu", NULL, NULL, NULL, "1989",
	"Jinmu Denshou\0", NULL, "Big Club", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_jinmuRomInfo, pce_jinmuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jinmu Denshou (Alt)

static struct BurnRomInfo pce_jinmu1RomDesc[] = {
	{ "jinmu denshou (japan) [a].pce", 0x080000, 0x84240ef9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_jinmu1)
STD_ROM_FN(pce_jinmu1)

struct BurnDriver BurnDrvpce_jinmu1 = {
	"pce_jinmu1", "pce_jinmu", NULL, NULL, "1989",
	"Jinmu Denshou (Alt)\0", NULL, "Big Club", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_jinmu1RomInfo, pce_jinmu1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Juuouki

static struct BurnRomInfo pce_juuoukiRomDesc[] = {
	{ "juuouki (japan).pce", 0x080000, 0xc8c7d63e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_juuouki)
STD_ROM_FN(pce_juuouki)

struct BurnDriver BurnDrvpce_juuouki = {
	"pce_juuouki", NULL, NULL, NULL, "1989",
	"Juuouki\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_juuoukiRomInfo, pce_juuoukiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Juuouki (Alt)

static struct BurnRomInfo pce_juuouki1RomDesc[] = {
	{ "juuouki (japan) [a].pce", 0x080000, 0x6a628982, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_juuouki1)
STD_ROM_FN(pce_juuouki1)

struct BurnDriver BurnDrvpce_juuouki1 = {
	"pce_juuouki1", "pce_juuouki", NULL, NULL, "1989",
	"Juuouki (Alt)\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_juuouki1RomInfo, pce_juuouki1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kaizou Choujin Shubibinman

static struct BurnRomInfo pce_shubibiRomDesc[] = {
	{ "kaizou choujin shubibinman (japan).pce", 0x040000, 0xa9084d6e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shubibi)
STD_ROM_FN(pce_shubibi)

struct BurnDriver BurnDrvpce_shubibi = {
	"pce_shubibi", NULL, NULL, NULL, "1989",
	"Kaizou Choujin Shubibinman\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shubibiRomInfo, pce_shubibiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kaizou Choujin Shubibinman 2 - Aratanaru Teki

static struct BurnRomInfo pce_shubibi2RomDesc[] = {
	{ "kaizou choujin shubibinman 2 - aratanaru teki (japan).pce", 0x080000, 0x109ba474, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shubibi2)
STD_ROM_FN(pce_shubibi2)

struct BurnDriver BurnDrvpce_shubibi2 = {
	"pce_shubibi2", NULL, NULL, NULL, "1991",
	"Kaizou Choujin Shubibinman 2 - Aratanaru Teki\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shubibi2RomInfo, pce_shubibi2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kato Chan & Ken Chan

static struct BurnRomInfo pce_katochanRomDesc[] = {
	{ "kato chan & ken chan (japan).pce", 0x040000, 0x6069c5e7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_katochan)
STD_ROM_FN(pce_katochan)

struct BurnDriver BurnDrvpce_katochan = {
	"pce_katochan", NULL, NULL, NULL, "1987",
	"Kato Chan & Ken Chan\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_katochanRomInfo, pce_katochanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kattobi! Takuhai Kun

static struct BurnRomInfo pce_kattobiRomDesc[] = {
	{ "kattobi! takuhai kun (japan).pce", 0x060000, 0x4f2844b0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kattobi)
STD_ROM_FN(pce_kattobi)

struct BurnDriver BurnDrvpce_kattobi = {
	"pce_kattobi", NULL, NULL, NULL, "1990",
	"Kattobi! Takuhai Kun\0", NULL, "Tonkin House", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kattobiRomInfo, pce_kattobiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kickball

static struct BurnRomInfo pce_kickballRomDesc[] = {
	{ "kickball (japan).pce", 0x060000, 0x7e3c367b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kickball)
STD_ROM_FN(pce_kickball)

struct BurnDriver BurnDrvpce_kickball = {
	"pce_kickball", NULL, NULL, NULL, "1990",
	"Kickball\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kickballRomInfo, pce_kickballRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kiki KaiKai

static struct BurnRomInfo pce_kikikaiRomDesc[] = {
	{ "kiki kaikai (japan).pce", 0x060000, 0xc0cb5add, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kikikai)
STD_ROM_FN(pce_kikikai)

struct BurnDriver BurnDrvpce_kikikai = {
	"pce_kikikai", NULL, NULL, NULL, "1990",
	"Kiki KaiKai\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kikikaiRomInfo, pce_kikikaiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// King of Casino

static struct BurnRomInfo pce_kingcasnRomDesc[] = {
	{ "king of casino (japan).pce", 0x040000, 0xbf52788e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kingcasn)
STD_ROM_FN(pce_kingcasn)

struct BurnDriver BurnDrvpce_kingcasn = {
	"pce_kingcasn", NULL, NULL, NULL, "1990",
	"King of Casino\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kingcasnRomInfo, pce_kingcasnRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Klax

static struct BurnRomInfo pce_klaxRomDesc[] = {
	{ "klax (japan).pce", 0x040000, 0xc74ffbc9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_klax)
STD_ROM_FN(pce_klax)

struct BurnDriver BurnDrvpce_klax = {
	"pce_klax", NULL, NULL, NULL, "1990",
	"Klax\0", NULL, "Tengen", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_klaxRomInfo, pce_klaxRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Knight Rider Special

static struct BurnRomInfo pce_knightrsRomDesc[] = {
	{ "knight rider special (japan).pce", 0x040000, 0xc614116c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_knightrs)
STD_ROM_FN(pce_knightrs)

struct BurnDriver BurnDrvpce_knightrs = {
	"pce_knightrs", NULL, NULL, NULL, "1989",
	"Knight Rider Special\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_knightrsRomInfo, pce_knightrsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kore Ga Pro Yakyuu '89

static struct BurnRomInfo pce_proyak89RomDesc[] = {
	{ "kore ga pro yakyuu '89 (japan).pce", 0x040000, 0x44f60137, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_proyak89)
STD_ROM_FN(pce_proyak89)

struct BurnDriver BurnDrvpce_proyak89 = {
	"pce_proyak89", NULL, NULL, NULL, "1989",
	"Kore Ga Pro Yakyuu '89\0", NULL, "Intec", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_proyak89RomInfo, pce_proyak89RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kore Ga Pro Yakyuu '90

static struct BurnRomInfo pce_proyak90RomDesc[] = {
	{ "kore ga pro yakyuu '90 (japan).pce", 0x040000, 0x1772b229, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_proyak90)
STD_ROM_FN(pce_proyak90)

struct BurnDriver BurnDrvpce_proyak90 = {
	"pce_proyak90", NULL, NULL, NULL, "1990",
	"Kore Ga Pro Yakyuu '90\0", NULL, "Intec", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_proyak90RomInfo, pce_proyak90RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// The Kung Fu

static struct BurnRomInfo pce_kungfuRomDesc[] = {
	{ "kung fu, the (japan).pce", 0x040000, 0xb552c906, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kungfu)
STD_ROM_FN(pce_kungfu)

struct BurnDriver BurnDrvpce_kungfu = {
	"pce_kungfu", NULL, NULL, NULL, "1987",
	"The Kung Fu\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kungfuRomInfo, pce_kungfuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kyuukyoku Mahjong - Idol Graphics

static struct BurnRomInfo pce_kyukyomjRomDesc[] = {
	{ "kyuukyoku mahjong - idol graphics (japan).pce", 0x080000, 0x02dde03e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kyukyomj)
STD_ROM_FN(pce_kyukyomj)

struct BurnDriver BurnDrvpce_kyukyomj = {
	"pce_kyukyomj", NULL, NULL, NULL, "1992",
	"Kyuukyoku Mahjong - Idol Graphics\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kyukyomjRomInfo, pce_kyukyomjRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kyuukyoku Mahjong II

static struct BurnRomInfo pce_kyukyom2RomDesc[] = {
	{ "kyuukyoku mahjong ii (japan).pce", 0x080000, 0xe5b6b3e5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_kyukyom2)
STD_ROM_FN(pce_kyukyom2)

struct BurnDriver BurnDrvpce_kyukyom2 = {
	"pce_kyukyom2", NULL, NULL, NULL, "1993",
	"Kyuukyoku Mahjong II\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_kyukyom2RomInfo, pce_kyukyom2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Kyuukyoku Tiger

static struct BurnRomInfo pce_ktigerRomDesc[] = {
	{ "kyuukyoku tiger (japan).pce", 0x040000, 0x09509315, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ktiger)
STD_ROM_FN(pce_ktiger)

struct BurnDriver BurnDrvpce_ktiger = {
	"pce_ktiger", NULL, NULL, NULL, "1989",
	"Kyuukyoku Tiger\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ktigerRomInfo, pce_ktigerRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Lady Sword

static struct BurnRomInfo pce_ladyswrdRomDesc[] = {
	{ "lady sword (japan).pce", 0x100000, 0xc6f764ec, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ladyswrd)
STD_ROM_FN(pce_ladyswrd)

struct BurnDriver BurnDrvpce_ladyswrd = {
	"pce_ladyswrd", NULL, NULL, NULL, "19??",
	"Lady Sword\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ladyswrdRomInfo, pce_ladyswrdRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Lady Sword (Alt)

static struct BurnRomInfo pce_ladyswrd1RomDesc[] = {
	{ "lady sword (japan) [a].pce", 0x100000, 0xeb833d15, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ladyswrd1)
STD_ROM_FN(pce_ladyswrd1)

struct BurnDriver BurnDrvpce_ladyswrd1 = {
	"pce_ladyswrd1", "pce_ladyswrd", NULL, NULL, "19??",
	"Lady Sword (Alt)\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ladyswrd1RomInfo, pce_ladyswrd1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Legend of Hero Tonma

static struct BurnRomInfo pce_lohtRomDesc[] = {
	{ "legend of hero tonma (japan).pce", 0x080000, 0xc28b0d8a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_loht)
STD_ROM_FN(pce_loht)

struct BurnDriver BurnDrvpce_loht = {
	"pce_loht", NULL, NULL, NULL, "1991",
	"Legend of Hero Tonma\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_lohtRomInfo, pce_lohtRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Lode Runner - Lost Labyrinth

static struct BurnRomInfo pce_ldrunRomDesc[] = {
	{ "lode runner - lost labyrinth (japan).pce", 0x040000, 0xe6ee1468, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ldrun)
STD_ROM_FN(pce_ldrun)

struct BurnDriver BurnDrvpce_ldrun = {
	"pce_ldrun", NULL, NULL, NULL, "1990",
	"Lode Runner - Lost Labyrinth\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ldrunRomInfo, pce_ldrunRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Märchen Maze

static struct BurnRomInfo pce_marchenRomDesc[] = {
	{ "maerchen maze (japan).pce", 0x040000, 0xa15a1f37, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_marchen)
STD_ROM_FN(pce_marchen)

struct BurnDriver BurnDrvpce_marchen = {
	"pce_marchen", NULL, NULL, NULL, "1990",
	"Marchen Maze\0", NULL, "Namcot", "PC Engine",
	L"M\u00E4rchen Maze\0", NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_marchenRomInfo, pce_marchenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Magical Chase

static struct BurnRomInfo pce_magchaseRomDesc[] = {
	{ "magical chase (japan).pce", 0x080000, 0xdd0ebf8c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_magchase)
STD_ROM_FN(pce_magchase)

struct BurnDriver BurnDrvpce_magchase = {
	"pce_magchase", NULL, NULL, NULL, "1991",
	"Magical Chase\0", NULL, "Palsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_magchaseRomInfo, pce_magchaseRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mahjong Gakuen - Touma Soushirou Toujou

static struct BurnRomInfo pce_mjgakuenRomDesc[] = {
	{ "mahjong gakuen - touma soushirou toujou (japan).pce", 0x080000, 0xf5b90d55, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mjgakuen)
STD_ROM_FN(pce_mjgakuen)

struct BurnDriver BurnDrvpce_mjgakuen = {
	"pce_mjgakuen", NULL, NULL, NULL, "1990",
	"Mahjong Gakuen - Touma Soushirou Toujou\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mjgakuenRomInfo, pce_mjgakuenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mahjong Gakuen Mild - Touma Soushirou Toujou

static struct BurnRomInfo pce_mjgakmldRomDesc[] = {
	{ "mahjong gakuen mild - touma soushirou toujou (japan).pce", 0x080000, 0xf4148600, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mjgakmld)
STD_ROM_FN(pce_mjgakmld)

struct BurnDriver BurnDrvpce_mjgakmld = {
	"pce_mjgakmld", NULL, NULL, NULL, "1990",
	"Mahjong Gakuen Mild - Touma Soushirou Toujou\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mjgakmldRomInfo, pce_mjgakmldRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mahjong Gakuen Mild - Touma Soushirou Toujou (Alt)

static struct BurnRomInfo pce_mjgakmld1RomDesc[] = {
	{ "mahjong gakuen mild - touma soushirou toujou (japan) [a].pce", 0x080000, 0x3e4d432a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mjgakmld1)
STD_ROM_FN(pce_mjgakmld1)

struct BurnDriver BurnDrvpce_mjgakmld1 = {
	"pce_mjgakmld1", "pce_mjgakmld", NULL, NULL, "1990",
	"Mahjong Gakuen Mild - Touma Soushirou Toujou (Alt)\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mjgakmld1RomInfo, pce_mjgakmld1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mahjong Gokuu Special

static struct BurnRomInfo pce_mjgokuspRomDesc[] = {
	{ "mahjong gokuu special (japan).pce", 0x060000, 0xf8861456, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mjgokusp)
STD_ROM_FN(pce_mjgokusp)

struct BurnDriver BurnDrvpce_mjgokusp = {
	"pce_mjgokusp", NULL, NULL, NULL, "1990",
	"Mahjong Gokuu Special\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mjgokuspRomInfo, pce_mjgokuspRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mahjong Haou Den - Kaiser's Quest

static struct BurnRomInfo pce_mjkaiserRomDesc[] = {
	{ "mahjong haou den - kaiser's quest (japan).pce", 0x080000, 0xdf10c895, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mjkaiser)
STD_ROM_FN(pce_mjkaiser)

struct BurnDriver BurnDrvpce_mjkaiser = {
	"pce_mjkaiser", NULL, NULL, NULL, "1992",
	"Mahjong Haou Den - Kaiser's Quest\0", NULL, "UPL", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mjkaiserRomInfo, pce_mjkaiserRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mahjong Shikyaku Retsuden - Mahjong Wars

static struct BurnRomInfo pce_mjwarsRomDesc[] = {
	{ "mahjong shikyaku retsuden - mahjong wars (japan).pce", 0x040000, 0x6c34aaea, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mjwars)
STD_ROM_FN(pce_mjwars)

struct BurnDriver BurnDrvpce_mjwars = {
	"pce_mjwars", NULL, NULL, NULL, "1990",
	"Mahjong Shikyaku Retsuden - Mahjong Wars\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mjwarsRomInfo, pce_mjwarsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Maison Ikkoku

static struct BurnRomInfo pce_mikkokuRomDesc[] = {
	{ "maison ikkoku (japan).pce", 0x040000, 0x5c78fee1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mikkoku)
STD_ROM_FN(pce_mikkoku)

struct BurnDriver BurnDrvpce_mikkoku = {
	"pce_mikkoku", NULL, NULL, NULL, "1989",
	"Maison Ikkoku\0", NULL, "Micro Cabin", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mikkokuRomInfo, pce_mikkokuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Majin Eiyuu Den Wataru

static struct BurnRomInfo pce_wataruRomDesc[] = {
	{ "majin eiyuu den wataru (japan).pce", 0x040000, 0x2f8935aa, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wataru)
STD_ROM_FN(pce_wataru)

struct BurnDriver BurnDrvpce_wataru = {
	"pce_wataru", NULL, NULL, NULL, "1988",
	"Majin Eiyuu Den Wataru\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wataruRomInfo, pce_wataruRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Makai Hakken Den Shada

static struct BurnRomInfo pce_makaihakRomDesc[] = {
	{ "makai hakken den shada (japan).pce", 0x040000, 0xbe62eef5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_makaihak)
STD_ROM_FN(pce_makaihak)

struct BurnDriver BurnDrvpce_makaihak = {
	"pce_makaihak", NULL, NULL, NULL, "1989",
	"Makai Hakken Den Shada\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_makaihakRomInfo, pce_makaihakRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Makai Prince Dorabocchan

static struct BurnRomInfo pce_makaipriRomDesc[] = {
	{ "makai prince dorabocchan (japan).pce", 0x060000, 0xb101b333, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_makaipri)
STD_ROM_FN(pce_makaipri)

struct BurnDriver BurnDrvpce_makaipri = {
	"pce_makaipri", NULL, NULL, NULL, "1990",
	"Makai Prince Dorabocchan\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_makaipriRomInfo, pce_makaipriRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Makyou Densetsu

static struct BurnRomInfo pce_makyodenRomDesc[] = {
	{ "makyou densetsu (japan).pce", 0x040000, 0xd4c5af46, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_makyoden)
STD_ROM_FN(pce_makyoden)

struct BurnDriver BurnDrvpce_makyoden = {
	"pce_makyoden", NULL, NULL, NULL, "1988",
	"Makyou Densetsu\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_makyodenRomInfo, pce_makyodenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Maniac Pro Wres - Asu e no Tatakai

static struct BurnRomInfo pce_maniacpwRomDesc[] = {
	{ "maniac puroresu - asu e no tatakai (japan).pce", 0x080000, 0x99f2865c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_maniacpw)
STD_ROM_FN(pce_maniacpw)

struct BurnDriver BurnDrvpce_maniacpw = {
	"pce_maniacpw", NULL, NULL, NULL, "1990",
	"Maniac Pro Wres - Asu e no Tatakai\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_maniacpwRomInfo, pce_maniacpwRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mesopotamia

static struct BurnRomInfo pce_mesopotRomDesc[] = {
	{ "mesopotamia (japan).pce", 0x080000, 0xe87190f1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mesopot)
STD_ROM_FN(pce_mesopot)

struct BurnDriver BurnDrvpce_mesopot = {
	"pce_mesopot", NULL, NULL, NULL, "1991",
	"Mesopotamia\0", NULL, "Atlus", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mesopotRomInfo, pce_mesopotRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Metal Stoker

static struct BurnRomInfo pce_metlstokRomDesc[] = {
	{ "metal stoker (japan).pce", 0x080000, 0x25a02bee, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_metlstok)
STD_ROM_FN(pce_metlstok)

struct BurnDriver BurnDrvpce_metlstok = {
	"pce_metlstok", NULL, NULL, NULL, "1991",
	"Metal Stoker\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_metlstokRomInfo, pce_metlstokRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mizubaku Dai Bouken

static struct BurnRomInfo pce_mizubakuRomDesc[] = {
	{ "mizubaku dai bouken (japan).pce", 0x080000, 0xb2ef558d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mizubaku)
STD_ROM_FN(pce_mizubaku)

struct BurnDriver BurnDrvpce_mizubaku = {
	"pce_mizubaku", NULL, NULL, NULL, "1992",
	"Mizubaku Dai Bouken\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mizubakuRomInfo, pce_mizubakuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Momotarou Densetsu Gaiden Dai 1 Shuu

static struct BurnRomInfo pce_momogdnRomDesc[] = {
	{ "momotarou densetsu gaiden dai 1 shuu (japan).pce", 0x080000, 0xf860455c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_momogdn)
STD_ROM_FN(pce_momogdn)

struct BurnDriver BurnDrvpce_momogdn = {
	"pce_momogdn", NULL, NULL, NULL, "1992",
	"Momotarou Densetsu Gaiden Dai 1 Shuu\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_momogdnRomInfo, pce_momogdnRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Momotarou Densetsu II

static struct BurnRomInfo pce_momo2RomDesc[] = {
	{ "momotarou densetsu ii (japan).pce", 0x0c0000, 0xd9e1549a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_momo2)
STD_ROM_FN(pce_momo2)

struct BurnDriver BurnDrvpce_momo2 = {
	"pce_momo2", NULL, NULL, NULL, "1990",
	"Momotarou Densetsu II\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_momo2RomInfo, pce_momo2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Momotarou Densetsu Turbo

static struct BurnRomInfo pce_momotrboRomDesc[] = {
	{ "momotarou densetsu turbo (japan).pce", 0x060000, 0x625221a6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_momotrbo)
STD_ROM_FN(pce_momotrbo)

struct BurnDriver BurnDrvpce_momotrbo = {
	"pce_momotrbo", NULL, NULL, NULL, "1990",
	"Momotarou Densetsu Turbo\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_momotrboRomInfo, pce_momotrboRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Momotarou Katsugeki

static struct BurnRomInfo pce_momoktsgRomDesc[] = {
	{ "momotarou katsugeki (japan).pce", 0x080000, 0x345f43e9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_momoktsg)
STD_ROM_FN(pce_momoktsg)

struct BurnDriver BurnDrvpce_momoktsg = {
	"pce_momoktsg", NULL, NULL, NULL, "1990",
	"Momotarou Katsugeki\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_momoktsgRomInfo, pce_momoktsgRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Monster Pro Wres

static struct BurnRomInfo pce_mnstprowRomDesc[] = {
	{ "monster puroresu (japan).pce", 0x080000, 0xf2e46d25, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mnstprow)
STD_ROM_FN(pce_mnstprow)

struct BurnDriver BurnDrvpce_mnstprow = {
	"pce_mnstprow", NULL, NULL, NULL, "1991",
	"Monster Pro Wres\0", NULL, "ASK", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mnstprowRomInfo, pce_mnstprowRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Morita Shougi PC

static struct BurnRomInfo pce_moritashRomDesc[] = {
	{ "morita shougi pc (japan).pce", 0x080000, 0x2546efe0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_moritash)
STD_ROM_FN(pce_moritash)

struct BurnDriver BurnDrvpce_moritash = {
	"pce_moritash", NULL, NULL, NULL, "1991",
	"Morita Shougi PC\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_moritashRomInfo, pce_moritashRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Moto Roader

static struct BurnRomInfo pce_motoroadRomDesc[] = {
	{ "moto roader (japan).pce", 0x040000, 0x428f36cd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_motoroad)
STD_ROM_FN(pce_motoroad)

struct BurnDriver BurnDrvpce_motoroad = {
	"pce_motoroad", NULL, NULL, NULL, "1989",
	"Moto Roader\0", NULL, "NCS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_motoroadRomInfo, pce_motoroadRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Moto Roader II

static struct BurnRomInfo pce_motorod2RomDesc[] = {
	{ "moto roader ii (japan).pce", 0x060000, 0x0b7f6e5f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_motorod2)
STD_ROM_FN(pce_motorod2)

struct BurnDriver BurnDrvpce_motorod2 = {
	"pce_motorod2", NULL, NULL, NULL, "1991",
	"Moto Roader II\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_motorod2RomInfo, pce_motorod2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Moto Roader II (Alt)

static struct BurnRomInfo pce_motorod2aRomDesc[] = {
	{ "moto roader ii (japan) [a].pce", 0x060000, 0x4ba525ba, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_motorod2a)
STD_ROM_FN(pce_motorod2a)

struct BurnDriver BurnDrvpce_motorod2a = {
	"pce_motorod2a", "pce_motorod2", NULL, NULL, "1991",
	"Moto Roader II (Alt)\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_motorod2aRomInfo, pce_motorod2aRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mr. Heli no Daibouken

static struct BurnRomInfo pce_mrheliRomDesc[] = {
	{ "mr. heli no daibouken (japan).pce", 0x080000, 0x2cb92290, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mrheli)
STD_ROM_FN(pce_mrheli)

struct BurnDriver BurnDrvpce_mrheli = {
	"pce_mrheli", NULL, NULL, NULL, "1989",
	"Mr. Heli no Daibouken\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mrheliRomInfo, pce_mrheliRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Mr. Heli no Daibouken (Alt)

static struct BurnRomInfo pce_mrheli1RomDesc[] = {
	{ "mr. heli no daibouken (japan) [a].pce", 0x080000, 0xac0cd796, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mrheli1)
STD_ROM_FN(pce_mrheli1)

struct BurnDriver BurnDrvpce_mrheli1 = {
	"pce_mrheli1", "pce_mrheli", NULL, NULL, "1989",
	"Mr. Heli no Daibouken (Alt)\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_mrheli1RomInfo, pce_mrheli1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Narazumono Sentai Butai - Bloody Wolf

static struct BurnRomInfo pce_blodwolfRomDesc[] = {
	{ "narazumono sentai butai - bloody wolf (japan).pce", 0x080000, 0xb01f70c2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_blodwolf)
STD_ROM_FN(pce_blodwolf)

struct BurnDriver BurnDrvpce_blodwolf = {
	"pce_blodwolf", NULL, NULL, NULL, "1989",
	"Narazumono Sentai Butai - Bloody Wolf\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_blodwolfRomInfo, pce_blodwolfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Naxat Open

static struct BurnRomInfo pce_naxopenRomDesc[] = {
	{ "naxat open (japan).pce", 0x060000, 0x60ecae22, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_naxopen)
STD_ROM_FN(pce_naxopen)

struct BurnDriver BurnDrvpce_naxopen = {
	"pce_naxopen", NULL, NULL, NULL, "1989",
	"Naxat Open\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_naxopenRomInfo, pce_naxopenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Naxat Stadium

static struct BurnRomInfo pce_naxstadRomDesc[] = {
	{ "naxat stadium (japan).pce", 0x080000, 0x20a7d128, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_naxstad)
STD_ROM_FN(pce_naxstad)

struct BurnDriver BurnDrvpce_naxstad = {
	"pce_naxstad", NULL, NULL, NULL, "1990",
	"Naxat Stadium\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_naxstadRomInfo, pce_naxstadRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Nazo no Masquerade

static struct BurnRomInfo pce_nazomasqRomDesc[] = {
	{ "nazo no mascarade (japan).pce", 0x060000, 0x0441d85a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nazomasq)
STD_ROM_FN(pce_nazomasq)

struct BurnDriver BurnDrvpce_nazomasq = {
	"pce_nazomasq", NULL, NULL, NULL, "1990",
	"Nazo no Masquerade\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nazomasqRomInfo, pce_nazomasqRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Necromancer

static struct BurnRomInfo pce_necromcrRomDesc[] = {
	{ "necromancer (japan).pce", 0x040000, 0x53109ae6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_necromcr)
STD_ROM_FN(pce_necromcr)

struct BurnDriver BurnDrvpce_necromcr = {
	"pce_necromcr", NULL, NULL, NULL, "1988",
	"Necromancer\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_necromcrRomInfo, pce_necromcrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Necros no Yousai

static struct BurnRomInfo pce_necrosRomDesc[] = {
	{ "necros no yousai (japan).pce", 0x080000, 0xfb0fdcfe, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_necros)
STD_ROM_FN(pce_necros)

struct BurnDriver BurnDrvpce_necros = {
	"pce_necros", NULL, NULL, NULL, "1990",
	"Necros no Yousai\0", NULL, "ASK", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_necrosRomInfo, pce_necrosRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Nectaris

static struct BurnRomInfo pce_nectarisRomDesc[] = {
	{ "nectaris (japan).pce", 0x060000, 0x0243453b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nectaris)
STD_ROM_FN(pce_nectaris)

struct BurnDriver BurnDrvpce_nectaris = {
	"pce_nectaris", NULL, NULL, NULL, "1990",
	"Nectaris\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nectarisRomInfo, pce_nectarisRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Nekketsu Koukou Dodgeball Bu - PC Bangai Hen

static struct BurnRomInfo pce_nekdodgeRomDesc[] = {
	{ "nekketsu koukou dodgeball bu - pc bangai hen (japan).pce", 0x040000, 0x65fdb863, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nekdodge)
STD_ROM_FN(pce_nekdodge)

struct BurnDriver BurnDrvpce_nekdodge = {
	"pce_nekdodge", NULL, NULL, NULL, "1990",
	"Nekketsu Koukou Dodgeball Bu - PC Bangai Hen\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nekdodgeRomInfo, pce_nekdodgeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Nekketsu Koukou Dodgeball Bu - Soccer PC Hen

static struct BurnRomInfo pce_neksoccrRomDesc[] = {
	{ "nekketsu koukou dodgeball bu - soccer pc hen (japan).pce", 0x080000, 0xf2285c6d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_neksoccr)
STD_ROM_FN(pce_neksoccr)

struct BurnDriver BurnDrvpce_neksoccr = {
	"pce_neksoccr", NULL, NULL, NULL, "1992",
	"Nekketsu Koukou Dodgeball Bu - Soccer PC Hen\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_neksoccrRomInfo, pce_neksoccrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Neutopia

static struct BurnRomInfo pce_neutopiaRomDesc[] = {
	{ "neutopia (japan).pce", 0x060000, 0x9c49ef11, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_neutopia)
STD_ROM_FN(pce_neutopia)

struct BurnDriver BurnDrvpce_neutopia = {
	"pce_neutopia", NULL, NULL, NULL, "1989",
	"Neutopia\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_neutopiaRomInfo, pce_neutopiaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Neutopia II

static struct BurnRomInfo pce_neutopi2RomDesc[] = {
	{ "neutopia ii (japan).pce", 0x0c0000, 0x2b94aedc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_neutopi2)
STD_ROM_FN(pce_neutopi2)

struct BurnDriver BurnDrvpce_neutopi2 = {
	"pce_neutopi2", NULL, NULL, NULL, "1991",
	"Neutopia II\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_neutopi2RomInfo, pce_neutopi2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// The New Zealand Story

static struct BurnRomInfo pce_tnzsRomDesc[] = {
	{ "new zealand story, the (japan).pce", 0x060000, 0x8e4d75a8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tnzs)
STD_ROM_FN(pce_tnzs)

struct BurnDriver BurnDrvpce_tnzs = {
	"pce_tnzs", NULL, NULL, NULL, "1990",
	"The New Zealand Story\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tnzsRomInfo, pce_tnzsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// NHK Taiga Drama - Taiheiki

static struct BurnRomInfo pce_nhktaidrRomDesc[] = {
	{ "nhk taiga drama - taiheiki (japan).pce", 0x080000, 0xa32430d5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nhktaidr)
STD_ROM_FN(pce_nhktaidr)

struct BurnDriver BurnDrvpce_nhktaidr = {
	"pce_nhktaidr", NULL, NULL, NULL, "1992",
	"NHK Taiga Drama - Taiheiki\0", NULL, "NHK Enterprise", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nhktaidrRomInfo, pce_nhktaidrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Niko Niko, Pun

static struct BurnRomInfo pce_nikopunRomDesc[] = {
	{ "niko niko pun (japan).pce", 0x080000, 0x82def9ee, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nikopun)
STD_ROM_FN(pce_nikopun)

struct BurnDriverD BurnDrvpce_nikopun = {
	"pce_nikopun", NULL, NULL, NULL, "1991",
	"Niko Niko, Pun\0", "Locks up in-game?", "NHK Enterprise", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nikopunRomInfo, pce_nikopunRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ninja Ryukenden

static struct BurnRomInfo pce_nryukendRomDesc[] = {
	{ "ninja ryuuken den (japan).pce", 0x080000, 0x67573bac, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nryukend)
STD_ROM_FN(pce_nryukend)

struct BurnDriver BurnDrvpce_nryukend = {
	"pce_nryukend", NULL, NULL, NULL, "1992",
	"Ninja Ryukenden\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nryukendRomInfo, pce_nryukendRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// The Ninja Warriors

static struct BurnRomInfo pce_ninjawarRomDesc[] = {
	{ "ninja warriors, the (japan).pce", 0x060000, 0x96e0cd9d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ninjawar)
STD_ROM_FN(pce_ninjawar)

struct BurnDriver BurnDrvpce_ninjawar = {
	"pce_ninjawar", NULL, NULL, NULL, "1989",
	"The Ninja Warriors\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ninjawarRomInfo, pce_ninjawarRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Obocchama-kun

static struct BurnRomInfo pce_obocchaRomDesc[] = {
	{ "obocchama kun (japan).pce", 0x080000, 0x4d3b0bc9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_oboccha)
STD_ROM_FN(pce_oboccha)

struct BurnDriver BurnDrvpce_oboccha = {
	"pce_oboccha", NULL, NULL, NULL, "1991",
	"Obocchama-kun\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_obocchaRomInfo, pce_obocchaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Operation Wolf

static struct BurnRomInfo pce_opwolfRomDesc[] = {
	{ "operation wolf (japan).pce", 0x080000, 0xff898f87, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_opwolf)
STD_ROM_FN(pce_opwolf)

struct BurnDriver BurnDrvpce_opwolf = {
	"pce_opwolf", NULL, NULL, NULL, "1990",
	"Operation Wolf\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_opwolfRomInfo, pce_opwolfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ordyne

static struct BurnRomInfo pce_ordyneRomDesc[] = {
	{ "ordyne (japan).pce", 0x080000, 0x8c565cb6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ordyne)
STD_ROM_FN(pce_ordyne)

struct BurnDriver BurnDrvpce_ordyne = {
	"pce_ordyne", NULL, NULL, NULL, "1989",
	"Ordyne\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ordyneRomInfo, pce_ordyneRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Out Live

static struct BurnRomInfo pce_outliveRomDesc[] = {
	{ "out live (japan).pce", 0x040000, 0x5cdb3f5b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_outlive)
STD_ROM_FN(pce_outlive)

struct BurnDriver BurnDrvpce_outlive = {
	"pce_outlive", NULL, NULL, NULL, "1989",
	"Out Live\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_outliveRomInfo, pce_outliveRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Out Run

static struct BurnRomInfo pce_outrunRomDesc[] = {
	{ "out run (japan).pce", 0x080000, 0xe203f223, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_outrun)
STD_ROM_FN(pce_outrun)

struct BurnDriver BurnDrvpce_outrun = {
	"pce_outrun", NULL, NULL, NULL, "1990",
	"Out Run\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_outrunRomInfo, pce_outrunRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Override

static struct BurnRomInfo pce_overrideRomDesc[] = {
	{ "override (japan).pce", 0x040000, 0xb74ec562, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_override)
STD_ROM_FN(pce_override)

struct BurnDriver BurnDrvpce_override = {
	"pce_override", NULL, NULL, NULL, "1991",
	"Override\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_overrideRomInfo, pce_overrideRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// P-47 - The Freedom Fighter

static struct BurnRomInfo pce_p47RomDesc[] = {
	{ "p-47 - the freedom fighter (japan).pce", 0x040000, 0x7632db90, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_p47)
STD_ROM_FN(pce_p47)

struct BurnDriver BurnDrvpce_p47 = {
	"pce_p47", NULL, NULL, NULL, "1989",
	"P-47 - The Freedom Fighter\0", NULL, "Aicom", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_p47RomInfo, pce_p47RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Pac-land

static struct BurnRomInfo pce_paclandRomDesc[] = {
	{ "pac-land (japan).pce", 0x040000, 0x14fad3ba, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pacland)
STD_ROM_FN(pce_pacland)

struct BurnDriver BurnDrvpce_pacland = {
	"pce_pacland", NULL, NULL, NULL, "1989",
	"Pac-land\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_paclandRomInfo, pce_paclandRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Pachio Kun - Juuban Shoubu

static struct BurnRomInfo pce_pachikunRomDesc[] = {
	{ "pachio kun - juuban shoubu (japan).pce", 0x080000, 0x4148fd7c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pachikun)
STD_ROM_FN(pce_pachikun)

struct BurnDriver BurnDrvpce_pachikun = {
	"pce_pachikun", NULL, NULL, NULL, "1992",
	"Pachio Kun - Juuban Shoubu\0", NULL, "Coconuts Japan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pachikunRomInfo, pce_pachikunRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Paranoia

static struct BurnRomInfo pce_paranoiaRomDesc[] = {
	{ "paranoia (japan).pce", 0x040000, 0x9893e0e6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_paranoia)
STD_ROM_FN(pce_paranoia)

struct BurnDriver BurnDrvpce_paranoia = {
	"pce_paranoia", NULL, NULL, NULL, "1990",
	"Paranoia\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_paranoiaRomInfo, pce_paranoiaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Parasol Stars - The Story of Bubble Bobble III

static struct BurnRomInfo pce_parasolRomDesc[] = {
	{ "parasol stars - the story of bubble bobble iii (japan).pce", 0x060000, 0x51e86451, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_parasol)
STD_ROM_FN(pce_parasol)

struct BurnDriver BurnDrvpce_parasol = {
	"pce_parasol", NULL, NULL, NULL, "1991",
	"Parasol Stars - The Story of Bubble Bobble III\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_parasolRomInfo, pce_parasolRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Parodius da! - Shinwa Kara Owarai He

static struct BurnRomInfo pce_parodiusRomDesc[] = {
	{ "parodius da! - shinwa kara owarai he (japan).pce", 0x100000, 0x647718f9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_parodius)
STD_ROM_FN(pce_parodius)

struct BurnDriver BurnDrvpce_parodius = {
	"pce_parodius", NULL, NULL, NULL, "1992",
	"Parodius da! - Shinwa Kara Owarai He\0", NULL, "Konami", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_parodiusRomInfo, pce_parodiusRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Denjin - Punkic Cyborgs

static struct BurnRomInfo pce_pcdenjRomDesc[] = {
	{ "pc denjin - punkic cyborgs (japan).pce", 0x080000, 0x740491c2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcdenj)
STD_ROM_FN(pce_pcdenj)

struct BurnDriverD BurnDrvpce_pcdenj = {
	"pce_pcdenj", NULL, NULL, NULL, "1992",
	"PC Denjin - Punkic Cyborgs\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcdenjRomInfo, pce_pcdenjRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Denjin - Punkic Cyborgs (Alt)

static struct BurnRomInfo pce_pcdenjaRomDesc[] = {
	{ "pc denjin - punkic cyborgs (japan) [a].pce", 0x080000, 0x8fb4f228, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcdenja)
STD_ROM_FN(pce_pcdenja)

struct BurnDriverD BurnDrvpce_pcdenja = {
	"pce_pcdenja", "pce_pcdenj", NULL, NULL, "1992",
	"PC Denjin - Punkic Cyborgs (Alt)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcdenjaRomInfo, pce_pcdenjaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Genjin - Pithecanthropus Computerurus

static struct BurnRomInfo pce_pcgenjRomDesc[] = {
	{ "pc genjin - pithecanthropus computerurus (japan).pce", 0x060000, 0x2cb5cd55, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcgenj)
STD_ROM_FN(pce_pcgenj)

struct BurnDriver BurnDrvpce_pcgenj = {
	"pce_pcgenj", NULL, NULL, NULL, "1989",
	"PC Genjin - Pithecanthropus Computerurus\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcgenjRomInfo, pce_pcgenjRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Genjin - Pithecanthropus Computerurus (Alt)

static struct BurnRomInfo pce_pcgenjaRomDesc[] = {
	{ "pc genjin - pithecanthropus computerurus (japan) [a].pce", 0x060000, 0x67b35e6e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcgenja)
STD_ROM_FN(pce_pcgenja)

struct BurnDriver BurnDrvpce_pcgenja = {
	"pce_pcgenja", "pce_pcgenj", NULL, NULL, "1989",
	"PC Genjin - Pithecanthropus Computerurus (Alt)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcgenjaRomInfo, pce_pcgenjaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Genjin 2 - Pithecanthropus Computerurus

static struct BurnRomInfo pce_pcgenj2RomDesc[] = {
	{ "pc genjin 2 - pithecanthropus computerurus (japan).pce", 0x080000, 0x3028f7ca, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcgenj2)
STD_ROM_FN(pce_pcgenj2)

struct BurnDriver BurnDrvpce_pcgenj2 = {
	"pce_pcgenj2", NULL, NULL, NULL, "1991",
	"PC Genjin 2 - Pithecanthropus Computerurus\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcgenj2RomInfo, pce_pcgenj2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Genjin 3 - Pithecanthropus Computerurus

static struct BurnRomInfo pce_pcgenj3RomDesc[] = {
	{ "pc genjin 3 - pithecanthropus computerurus (japan).pce", 0x100000, 0xa170b60e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcgenj3)
STD_ROM_FN(pce_pcgenj3)

struct BurnDriver BurnDrvpce_pcgenj3 = {
	"pce_pcgenj3", NULL, NULL, NULL, "1993",
	"PC Genjin 3 - Pithecanthropus Computerurus\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcgenj3RomInfo, pce_pcgenj3RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Genjin 3 - Pithecanthropus Computerurus (Taikenban)

static struct BurnRomInfo pce_pcgenj3tRomDesc[] = {
	{ "pc genjin 3 - pithecanthropus computerurus (taikenban) (japan).pce", 0x0c0000, 0x6f6ed301, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcgenj3t)
STD_ROM_FN(pce_pcgenj3t)

struct BurnDriver BurnDrvpce_pcgenj3t = {
	"pce_pcgenj3t", NULL, NULL, NULL, "1993",
	"PC Genjin 3 - Pithecanthropus Computerurus (Taikenban)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcgenj3tRomInfo, pce_pcgenj3tRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC Pachi-slot

static struct BurnRomInfo pce_pcpachiRomDesc[] = {
	{ "pc pachi-slot (japan).pce", 0x080000, 0x0aa88f33, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pcpachi)
STD_ROM_FN(pce_pcpachi)

struct BurnDriver BurnDrvpce_pcpachi = {
	"pce_pcpachi", NULL, NULL, NULL, "1992",
	"PC Pachi-slot\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pcpachiRomInfo, pce_pcpachiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Populous

static struct BurnRomInfo pce_populousRomDesc[] = {
	{ "populous (japan).pce", 0x080000, 0x083c956a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_populous)
STD_ROM_FN(pce_populous)

struct BurnDriver BurnDrvpce_populous = {
	"pce_populous", NULL, NULL, NULL, "1991",
	"Populous\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_populousRomInfo, pce_populousRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	populousInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Populous (Alt)

static struct BurnRomInfo pce_populous1RomDesc[] = {
	{ "populous (japan) [a].pce", 0x080000, 0x0a9ade99, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_populous1)
STD_ROM_FN(pce_populous1)

struct BurnDriver BurnDrvpce_populous1 = {
	"pce_populous1", "pce_populous", NULL, NULL, "1991",
	"Populous (Alt)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_populous1RomInfo, pce_populous1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	populousInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Drift

static struct BurnRomInfo pce_pdriftRomDesc[] = {
	{ "power drift (japan).pce", 0x080000, 0x25e0f6e9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pdrift)
STD_ROM_FN(pce_pdrift)

struct BurnDriver BurnDrvpce_pdrift = {
	"pce_pdrift", NULL, NULL, NULL, "1990",
	"Power Drift\0", NULL, "Asmik", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pdriftRomInfo, pce_pdriftRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Drift (Alt)

static struct BurnRomInfo pce_pdrift1RomDesc[] = {
	{ "power drift (japan) [a].pce", 0x080000, 0x99e6d988, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pdrift1)
STD_ROM_FN(pce_pdrift1)

struct BurnDriver BurnDrvpce_pdrift1 = {
	"pce_pdrift1", "pce_pdrift", NULL, NULL, "1990",
	"Power Drift (Alt)\0", NULL, "Asmik", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pdrift1RomInfo, pce_pdrift1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Eleven

static struct BurnRomInfo pce_power11RomDesc[] = {
	{ "power eleven (japan).pce", 0x060000, 0x3e647d8b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_power11)
STD_ROM_FN(pce_power11)

struct BurnDriver BurnDrvpce_power11 = {
	"pce_power11", NULL, NULL, NULL, "1991",
	"Power Eleven\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_power11RomInfo, pce_power11RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Gate

static struct BurnRomInfo pce_powergatRomDesc[] = {
	{ "power gate (japan).pce", 0x040000, 0xbe8b6e3b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_powergat)
STD_ROM_FN(pce_powergat)

struct BurnDriver BurnDrvpce_powergat = {
	"pce_powergat", NULL, NULL, NULL, "1991",
	"Power Gate\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_powergatRomInfo, pce_powergatRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Golf

static struct BurnRomInfo pce_pgolfRomDesc[] = {
	{ "power golf (japan).pce", 0x060000, 0xea324f07, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pgolf)
STD_ROM_FN(pce_pgolf)

struct BurnDriver BurnDrvpce_pgolf = {
	"pce_pgolf", NULL, NULL, NULL, "1989",
	"Power Golf\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pgolfRomInfo, pce_pgolfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League '93

static struct BurnRomInfo pce_pleag93RomDesc[] = {
	{ "power league '93 (japan).pce", 0x0c0000, 0x7d3e6f33, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleag93)
STD_ROM_FN(pce_pleag93)

struct BurnDriver BurnDrvpce_pleag93 = {
	"pce_pleag93", NULL, NULL, NULL, "1993",
	"Power League '93\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleag93RomInfo, pce_pleag93RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League (All Star Version)

static struct BurnRomInfo pce_pleagasRomDesc[] = {
	{ "power league (all star version) (japan).pce", 0x040000, 0x04a85769, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleagas)
STD_ROM_FN(pce_pleagas)

struct BurnDriver BurnDrvpce_pleagas = {
	"pce_pleagas", NULL, NULL, NULL, "19??",
	"Power League (All Star Version)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleagasRomInfo, pce_pleagasRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League

static struct BurnRomInfo pce_pleagueRomDesc[] = {
	{ "power league (japan).pce", 0x040000, 0x69180984, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleague)
STD_ROM_FN(pce_pleague)

struct BurnDriver BurnDrvpce_pleague = {
	"pce_pleague", NULL, NULL, NULL, "1988",
	"Power League\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleagueRomInfo, pce_pleagueRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League II

static struct BurnRomInfo pce_pleag2RomDesc[] = {
	{ "power league ii (japan).pce", 0x060000, 0xc5fdfa89, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleag2)
STD_ROM_FN(pce_pleag2)

struct BurnDriver BurnDrvpce_pleag2 = {
	"pce_pleag2", NULL, NULL, NULL, "1989",
	"Power League II\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleag2RomInfo, pce_pleag2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League III

static struct BurnRomInfo pce_pleag3RomDesc[] = {
	{ "power league iii (japan).pce", 0x060000, 0x8aa4b220, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleag3)
STD_ROM_FN(pce_pleag3)

struct BurnDriver BurnDrvpce_pleag3 = {
	"pce_pleag3", NULL, NULL, NULL, "1990",
	"Power League III\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleag3RomInfo, pce_pleag3RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League IV

static struct BurnRomInfo pce_pleag4RomDesc[] = {
	{ "power league iv (japan).pce", 0x080000, 0x30cc3563, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleag4)
STD_ROM_FN(pce_pleag4)

struct BurnDriver BurnDrvpce_pleag4 = {
	"pce_pleag4", NULL, NULL, NULL, "1991",
	"Power League IV\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleag4RomInfo, pce_pleag4RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power League V

static struct BurnRomInfo pce_pleag5RomDesc[] = {
	{ "power league v (japan).pce", 0x0c0000, 0x8b61e029, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_pleag5)
STD_ROM_FN(pce_pleag5)

struct BurnDriver BurnDrvpce_pleag5 = {
	"pce_pleag5", NULL, NULL, NULL, "1992",
	"Power League V\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_pleag5RomInfo, pce_pleag5RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Sports

static struct BurnRomInfo pce_psportsRomDesc[] = {
	{ "power sports (japan).pce", 0x080000, 0x29eec024, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_psports)
STD_ROM_FN(pce_psports)

struct BurnDriver BurnDrvpce_psports = {
	"pce_psports", NULL, NULL, NULL, "1992",
	"Power Sports\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_psportsRomInfo, pce_psportsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Tennis

static struct BurnRomInfo pce_ptennisRomDesc[] = {
	{ "power tennis (japan).pce", 0x080000, 0x8def5aa1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ptennis)
STD_ROM_FN(pce_ptennis)

struct BurnDriverD BurnDrvpce_ptennis = {
	"pce_ptennis", NULL, NULL, NULL, "1993",
	"Power Tennis\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ptennisRomInfo, pce_ptennisRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Pro Tennis World Court

static struct BurnRomInfo pce_ptennwcRomDesc[] = {
	{ "pro tennis world court (japan).pce", 0x040000, 0x11a36745, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ptennwc)
STD_ROM_FN(pce_ptennwc)

struct BurnDriver BurnDrvpce_ptennwc = {
	"pce_ptennwc", NULL, NULL, NULL, "1988",
	"Pro Tennis World Court\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ptennwcRomInfo, pce_ptennwcRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Pro Yakyuu World Stadium '91

static struct BurnRomInfo pce_proyak91RomDesc[] = {
	{ "pro yakyuu world stadium '91 (japan).pce", 0x040000, 0x66b167a9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_proyak91)
STD_ROM_FN(pce_proyak91)

struct BurnDriver BurnDrvpce_proyak91 = {
	"pce_proyak91", NULL, NULL, NULL, "1991",
	"Pro Yakyuu World Stadium '91\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_proyak91RomInfo, pce_proyak91RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Pro Yakyuu World Stadium

static struct BurnRomInfo pce_proyakRomDesc[] = {
	{ "pro yakyuu world stadium (japan).pce", 0x040000, 0x34e089a9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_proyak)
STD_ROM_FN(pce_proyak)

struct BurnDriver BurnDrvpce_proyak = {
	"pce_proyak", NULL, NULL, NULL, "1988",
	"Pro Yakyuu World Stadium\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_proyakRomInfo, pce_proyakRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Psycho Chaser

static struct BurnRomInfo pce_psychasRomDesc[] = {
	{ "psycho chaser (japan).pce", 0x040000, 0x03883ee8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_psychas)
STD_ROM_FN(pce_psychas)

struct BurnDriver BurnDrvpce_psychas = {
	"pce_psychas", NULL, NULL, NULL, "1990",
	"Psycho Chaser\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_psychasRomInfo, pce_psychasRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Puzzle Boy

static struct BurnRomInfo pce_puzzlboyRomDesc[] = {
	{ "puzzle boy (japan).pce", 0x040000, 0xfaa6e187, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_puzzlboy)
STD_ROM_FN(pce_puzzlboy)

struct BurnDriver BurnDrvpce_puzzlboy = {
	"pce_puzzlboy", NULL, NULL, NULL, "1991",
	"Puzzle Boy\0", NULL, "Nihon Telenet", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_puzzlboyRomInfo, pce_puzzlboyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Puzznic

static struct BurnRomInfo pce_puzznicRomDesc[] = {
	{ "puzznic (japan).pce", 0x040000, 0x965c95b3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_puzznic)
STD_ROM_FN(pce_puzznic)

struct BurnDriver BurnDrvpce_puzznic = {
	"pce_puzznic", NULL, NULL, NULL, "1990",
	"Puzznic\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_puzznicRomInfo, pce_puzznicRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Quiz Toukou Shashin

static struct BurnRomInfo pce_quiztsRomDesc[] = {
	{ "quiz toukou shashin (japan).pce", 0x100000, 0xf2e6856d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_quizts)
STD_ROM_FN(pce_quizts)

struct BurnDriver BurnDrvpce_quizts = {
	"pce_quizts", NULL, NULL, NULL, "19??",
	"Quiz Toukou Shashin\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_quiztsRomInfo, pce_quiztsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// R-Type Part-1

static struct BurnRomInfo pce_rtypep1RomDesc[] = {
	{ "r-type part-1 (japan).pce", 0x040000, 0xcec3d28a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_rtypep1)
STD_ROM_FN(pce_rtypep1)

struct BurnDriver BurnDrvpce_rtypep1 = {
	"pce_rtypep1", NULL, NULL, NULL, "1988",
	"R-Type Part-1\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_rtypep1RomInfo, pce_rtypep1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// R-Type Part-2

static struct BurnRomInfo pce_rtypep2RomDesc[] = {
	{ "r-type part-2 (japan).pce", 0x040000, 0xf207ecae, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_rtypep2)
STD_ROM_FN(pce_rtypep2)

struct BurnDriver BurnDrvpce_rtypep2 = {
	"pce_rtypep2", NULL, NULL, NULL, "1988",
	"R-Type Part-2\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_rtypep2RomInfo, pce_rtypep2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// R-Type Part-2 v1.1

static struct BurnRomInfo pce_rtypep2v11RomDesc[] = {
	{ "r-type part-2 v1.1 (japan).pce", 0x040000, 0x417b961d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_rtypep2v11)
STD_ROM_FN(pce_rtypep2v11)

struct BurnDriver BurnDrvpce_rtypep2v11 = {
	"pce_rtypep2v11", "pce_rtypep2", NULL, NULL, "1988",
	"R-Type Part-2 (v1.1)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_rtypep2v11RomInfo, pce_rtypep2v11RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Rabio Lepus Special

static struct BurnRomInfo pce_rabiolepRomDesc[] = {
	{ "rabio lepus special (japan).pce", 0x060000, 0xd8373de6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_rabiolep)
STD_ROM_FN(pce_rabiolep)

struct BurnDriver BurnDrvpce_rabiolep = {
	"pce_rabiolep", NULL, NULL, NULL, "1990",
	"Rabio Lepus Special\0", NULL, "Video System", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_rabiolepRomInfo, pce_rabiolepRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Racing Damashii

static struct BurnRomInfo pce_racindamRomDesc[] = {
	{ "racing damashii (japan).pce", 0x080000, 0x3e79734c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_racindam)
STD_ROM_FN(pce_racindam)

struct BurnDriver BurnDrvpce_racindam = {
	"pce_racindam", NULL, NULL, NULL, "1991",
	"Racing Damashii\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_racindamRomInfo, pce_racindamRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Raiden

static struct BurnRomInfo pce_raidenRomDesc[] = {
	{ "raiden (japan).pce", 0x0c0000, 0x850829f2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_raiden)
STD_ROM_FN(pce_raiden)

struct BurnDriver BurnDrvpce_raiden = {
	"pce_raiden", NULL, NULL, NULL, "1991",
	"Raiden\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_raidenRomInfo, pce_raidenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Rastan Saga II

static struct BurnRomInfo pce_rastan2RomDesc[] = {
	{ "rastan saga ii (japan).pce", 0x060000, 0x00c38e69, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_rastan2)
STD_ROM_FN(pce_rastan2)

struct BurnDriver BurnDrvpce_rastan2 = {
	"pce_rastan2", NULL, NULL, NULL, "1990",
	"Rastan Saga II\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_rastan2RomInfo, pce_rastan2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Rock-on

static struct BurnRomInfo pce_rockonRomDesc[] = {
	{ "rock-on (japan).pce", 0x060000, 0x2fd65312, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_rockon)
STD_ROM_FN(pce_rockon)

struct BurnDriver BurnDrvpce_rockon = {
	"pce_rockon", NULL, NULL, NULL, "1989",
	"Rock-on\0", NULL, "Big Club", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_rockonRomInfo, pce_rockonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ryuukyuu

static struct BurnRomInfo pce_ryukyuRomDesc[] = {
	{ "ryukyu (japan).pce", 0x040000, 0x91e6896f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_ryukyu)
STD_ROM_FN(pce_ryukyu)

struct BurnDriver BurnDrvpce_ryukyu = {
	"pce_ryukyu", NULL, NULL, NULL, "1990",
	"Ryuukyuu\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_ryukyuRomInfo, pce_ryukyuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sadakichi 7 Series - Hideyoshi no Ougon

static struct BurnRomInfo pce_sadaki7RomDesc[] = {
	{ "sadakichi 7 series - hideyoshi no ougon (japan).pce", 0x040000, 0xf999356f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sadaki7)
STD_ROM_FN(pce_sadaki7)

struct BurnDriver BurnDrvpce_sadaki7 = {
	"pce_sadaki7", NULL, NULL, NULL, "1988",
	"Sadakichi 7 Series - Hideyoshi no Ougon\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sadaki7RomInfo, pce_sadaki7RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Saigo no Nindou - Ninja Spirit

static struct BurnRomInfo pce_saigoninRomDesc[] = {
	{ "saigo no nindou - ninja spirit (japan).pce", 0x080000, 0x0590a156, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_saigonin)
STD_ROM_FN(pce_saigonin)

struct BurnDriver BurnDrvpce_saigonin = {
	"pce_saigonin", NULL, NULL, NULL, "1990",
	"Saigo no Nindou - Ninja Spirit\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_saigoninRomInfo, pce_saigoninRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Salamander

static struct BurnRomInfo pce_salamandRomDesc[] = {
	{ "salamander (japan).pce", 0x040000, 0xfaecce20, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_salamand)
STD_ROM_FN(pce_salamand)

struct BurnDriver BurnDrvpce_salamand = {
	"pce_salamand", NULL, NULL, NULL, "1991",
	"Salamander\0", NULL, "Konami", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_salamandRomInfo, pce_salamandRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sekigahara

static struct BurnRomInfo pce_sekigahaRomDesc[] = {
	{ "sekigahara (japan).pce", 0x080000, 0x2e955051, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sekigaha)
STD_ROM_FN(pce_sekigaha)

struct BurnDriver BurnDrvpce_sekigaha = {
	"pce_sekigaha", NULL, NULL, NULL, "1990",
	"Sekigahara\0", NULL, "Tonkin House", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sekigahaRomInfo, pce_sekigahaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sengoku Mahjong

static struct BurnRomInfo pce_sengokmjRomDesc[] = {
	{ "sengoku mahjong (japan).pce", 0x040000, 0x90e6bf49, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sengokmj)
STD_ROM_FN(pce_sengokmj)

struct BurnDriver BurnDrvpce_sengokmj = {
	"pce_sengokmj", NULL, NULL, NULL, "1988",
	"Sengoku Mahjong\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sengokmjRomInfo, pce_sengokmjRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Shanghai

static struct BurnRomInfo pce_shanghaiRomDesc[] = {
	{ "shanghai (japan).pce", 0x020000, 0x6923d736, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shanghai)
STD_ROM_FN(pce_shanghai)

struct BurnDriver BurnDrvpce_shanghai = {
	"pce_shanghai", NULL, NULL, NULL, "1987",
	"Shanghai\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shanghaiRomInfo, pce_shanghaiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Shinobi

static struct BurnRomInfo pce_shinobiRomDesc[] = {
	{ "shinobi (japan).pce", 0x060000, 0xbc655cf3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shinobi)
STD_ROM_FN(pce_shinobi)

struct BurnDriver BurnDrvpce_shinobi = {
	"pce_shinobi", NULL, NULL, NULL, "1989",
	"Shinobi\0", NULL, "Asmik", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shinobiRomInfo, pce_shinobiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Shiryou Sensen

static struct BurnRomInfo pce_shiryoRomDesc[] = {
	{ "shiryou sensen (japan).pce", 0x040000, 0x469a0fdf, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shiryo)
STD_ROM_FN(pce_shiryo)

struct BurnDriver BurnDrvpce_shiryo = {
	"pce_shiryo", NULL, NULL, NULL, "1989",
	"Shiryou Sensen\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shiryoRomInfo, pce_shiryoRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Shougi Shodan Icchokusen

static struct BurnRomInfo pce_shogisiRomDesc[] = {
	{ "shougi shodan icchokusen (japan).pce", 0x040000, 0x23ec8970, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shogisi)
STD_ROM_FN(pce_shogisi)

struct BurnDriver BurnDrvpce_shogisi = {
	"pce_shogisi", NULL, NULL, NULL, "1990",
	"Shougi Shodan Icchokusen\0", NULL, "Home Data", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shogisiRomInfo, pce_shogisiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Shougi Shoshinsha Muyou

static struct BurnRomInfo pce_shogismRomDesc[] = {
	{ "shougi shoshinsha muyou (japan).pce", 0x040000, 0x457f2bc4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shogism)
STD_ROM_FN(pce_shogism)

struct BurnDriver BurnDrvpce_shogism = {
	"pce_shogism", NULL, NULL, NULL, "1991",
	"Shougi Shoshinsha Muyou\0", NULL, "Home Data", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shogismRomInfo, pce_shogismRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sidearms - Hyper Dyne

static struct BurnRomInfo pce_sidearmsRomDesc[] = {
	{ "sidearms - hyper dyne (japan).pce", 0x040000, 0xe5e7b8b7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sidearms)
STD_ROM_FN(pce_sidearms)

struct BurnDriver BurnDrvpce_sidearms = {
	"pce_sidearms", NULL, NULL, NULL, "1989",
	"Sidearms - Hyper Dyne\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sidearmsRomInfo, pce_sidearmsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 242, 4, 3
};


// Silent Debuggers

static struct BurnRomInfo pce_silentdRomDesc[] = {
	{ "silent debuggers (japan).pce", 0x080000, 0x616ea179, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_silentd)
STD_ROM_FN(pce_silentd)

struct BurnDriver BurnDrvpce_silentd = {
	"pce_silentd", NULL, NULL, NULL, "1991",
	"Silent Debuggers\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_silentdRomInfo, pce_silentdRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sindibad Chitei no Dai Makyuu

static struct BurnRomInfo pce_sindibadRomDesc[] = {
	{ "sindibad chitei no dai makyuu (japan).pce", 0x060000, 0xb5c4eebd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sindibad)
STD_ROM_FN(pce_sindibad)

struct BurnDriver BurnDrvpce_sindibad = {
	"pce_sindibad", NULL, NULL, NULL, "1990",
	"Sindibad Chitei no Dai Makyuu\0", NULL, "IGS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sindibadRomInfo, pce_sindibadRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Skweek

static struct BurnRomInfo pce_skweekRomDesc[] = {
	{ "skweek (japan).pce", 0x040000, 0x4d539c9f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_skweek)
STD_ROM_FN(pce_skweek)

struct BurnDriver BurnDrvpce_skweek = {
	"pce_skweek", NULL, NULL, NULL, "1991",
	"Skweek\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_skweekRomInfo, pce_skweekRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Soldier Blade

static struct BurnRomInfo pce_soldbladRomDesc[] = {
	{ "soldier blade (japan).pce", 0x080000, 0x8420b12b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_soldblad)
STD_ROM_FN(pce_soldblad)

struct BurnDriver BurnDrvpce_soldblad = {
	"pce_soldblad", NULL, NULL, NULL, "1992",
	"Soldier Blade\0", "Hangs at first boss", "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_soldbladRomInfo, pce_soldbladRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Soldier Blade Special - Caravan Stage

static struct BurnRomInfo pce_soldblasRomDesc[] = {
	{ "soldier blade special - caravan stage (japan).pce", 0x080000, 0xf39f38ed, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_soldblas)
STD_ROM_FN(pce_soldblas)

struct BurnDriver BurnDrvpce_soldblas = {
	"pce_soldblas", NULL, NULL, NULL, "19??",
	"Soldier Blade Special - Caravan Stage\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_soldblasRomInfo, pce_soldblasRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Son Son II

static struct BurnRomInfo pce_sonson2RomDesc[] = {
	{ "son son ii (japan).pce", 0x040000, 0xd7921df2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sonson2)
STD_ROM_FN(pce_sonson2)

struct BurnDriver BurnDrvpce_sonson2 = {
	"pce_sonson2", NULL, NULL, NULL, "1989",
	"Son Son II\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sonson2RomInfo, pce_sonson2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sokoban World

static struct BurnRomInfo pce_sokobanRomDesc[] = {
	{ "soukoban world (japan).pce", 0x020000, 0xfb37ddc4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sokoban)
STD_ROM_FN(pce_sokoban)

struct BurnDriver BurnDrvpce_sokoban = {
	"pce_sokoban", NULL, NULL, NULL, "1990",
	"Sokoban World\0", NULL, "Media Rings Corporation", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sokobanRomInfo, pce_sokobanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Space Harrier

static struct BurnRomInfo pce_sharrierRomDesc[] = {
	{ "space harrier (japan).pce", 0x080000, 0x64580427, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sharrier)
STD_ROM_FN(pce_sharrier)

struct BurnDriver BurnDrvpce_sharrier = {
	"pce_sharrier", NULL, NULL, NULL, "1988",
	"Space Harrier\0", NULL, "NEC", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sharrierRomInfo, pce_sharrierRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Space Invaders - Fukkatsu no Hi

static struct BurnRomInfo pce_spaceinvRomDesc[] = {
	{ "space invaders - fukkatsu no hi (japan).pce", 0x040000, 0x99496db3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_spaceinv)
STD_ROM_FN(pce_spaceinv)

struct BurnDriver BurnDrvpce_spaceinv = {
	"pce_spaceinv", NULL, NULL, NULL, "1990",
	"Space Invaders - Fukkatsu no Hi\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_spaceinvRomInfo, pce_spaceinvRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Special Criminal Investigation

static struct BurnRomInfo pce_sciRomDesc[] = {
	{ "special criminal investigation (japan).pce", 0x080000, 0x09a0bfcc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sci)
STD_ROM_FN(pce_sci)

struct BurnDriver BurnDrvpce_sci = {
	"pce_sci", NULL, NULL, NULL, "1991",
	"Special Criminal Investigation\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sciRomInfo, pce_sciRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Spin Pair

static struct BurnRomInfo pce_spinpairRomDesc[] = {
	{ "spin pair (japan).pce", 0x040000, 0x1c6ff459, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_spinpair)
STD_ROM_FN(pce_spinpair)

struct BurnDriver BurnDrvpce_spinpair = {
	"pce_spinpair", NULL, NULL, NULL, "1990",
	"Spin Pair\0", NULL, "Media Rings Corporation", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_spinpairRomInfo, pce_spinpairRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Spiral Wave

static struct BurnRomInfo pce_spirwaveRomDesc[] = {
	{ "spiral wave (japan).pce", 0x080000, 0xa5290dd0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_spirwave)
STD_ROM_FN(pce_spirwave)

struct BurnDriver BurnDrvpce_spirwave = {
	"pce_spirwave", NULL, NULL, NULL, "1991",
	"Spiral Wave\0", NULL, "Media Rings Corporation", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_spirwaveRomInfo, pce_spirwaveRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Splatterhouse

static struct BurnRomInfo pce_splatthRomDesc[] = {
	{ "splatterhouse (japan).pce", 0x080000, 0x6b319457, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_splatth)
STD_ROM_FN(pce_splatth)

struct BurnDriver BurnDrvpce_splatth = {
	"pce_splatth", NULL, NULL, NULL, "1990",
	"Splatterhouse\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_splatthRomInfo, pce_splatthRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Stratego

static struct BurnRomInfo pce_strategoRomDesc[] = {
	{ "stratego (japan).pce", 0x040000, 0x727f4656, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_stratego)
STD_ROM_FN(pce_stratego)

struct BurnDriver BurnDrvpce_stratego = {
	"pce_stratego", NULL, NULL, NULL, "1992",
	"Stratego\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_strategoRomInfo, pce_strategoRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Street Fighter II' - Champion Edition

static struct BurnRomInfo pce_sf2ceRomDesc[] = {
	{ "street fighter ii' - champion edition (japan).pce", 0x280000, 0xd15cb6bb, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sf2ce)
STD_ROM_FN(pce_sf2ce)

struct BurnDriver BurnDrvpce_sf2ce = {
	"pce_sf2ce", NULL, NULL, NULL, "1993",
	"Street Fighter II' - Champion Edition\0", NULL, "NEC Home Electronics", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sf2ceRomInfo, pce_sf2ceRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Strip Fighter II

static struct BurnRomInfo pce_stripf2RomDesc[] = {
	{ "strip fighter ii (japan).pce", 0x100000, 0xd6fc51ce, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_stripf2)
STD_ROM_FN(pce_stripf2)

struct BurnDriver BurnDrvpce_stripf2 = {
	"pce_stripf2", NULL, NULL, NULL, "19??",
	"Strip Fighter II\0", NULL, "Game Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_stripf2RomInfo, pce_stripf2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Metal Crusher

static struct BurnRomInfo pce_smcrushRomDesc[] = {
	{ "super metal crusher (japan).pce", 0x040000, 0x56488b36, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_smcrush)
STD_ROM_FN(pce_smcrush)

struct BurnDriver BurnDrvpce_smcrush = {
	"pce_smcrush", NULL, NULL, NULL, "1991",
	"Super Metal Crusher\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_smcrushRomInfo, pce_smcrushRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Momotarou Dentetsu

static struct BurnRomInfo pce_smomoRomDesc[] = {
	{ "super momotarou dentetsu (japan).pce", 0x060000, 0x3eb5304a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_smomo)
STD_ROM_FN(pce_smomo)

struct BurnDriver BurnDrvpce_smomo = {
	"pce_smomo", NULL, NULL, NULL, "1989",
	"Super Momotarou Dentetsu\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_smomoRomInfo, pce_smomoRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Momotarou Dentetsu II

static struct BurnRomInfo pce_smomo2RomDesc[] = {
	{ "super momotarou dentetsu ii (japan).pce", 0x0c0000, 0x2bc023fc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_smomo2)
STD_ROM_FN(pce_smomo2)

struct BurnDriver BurnDrvpce_smomo2 = {
	"pce_smomo2", NULL, NULL, NULL, "1991",
	"Super Momotarou Dentetsu II\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_smomo2RomInfo, pce_smomo2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Star Soldier

static struct BurnRomInfo pce_sssoldrRomDesc[] = {
	{ "super star soldier (japan).pce", 0x080000, 0x5d0e3105, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sssoldr)
STD_ROM_FN(pce_sssoldr)

struct BurnDriver BurnDrvpce_sssoldr = {
	"pce_sssoldr", NULL, NULL, NULL, "1990",
	"Super Star Soldier\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sssoldrRomInfo, pce_sssoldrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Volleyball

static struct BurnRomInfo pce_svolleyRomDesc[] = {
	{ "super volleyball (japan).pce", 0x040000, 0xce2e4f9f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_svolley)
STD_ROM_FN(pce_svolley)

struct BurnDriver BurnDrvpce_svolley = {
	"pce_svolley", NULL, NULL, NULL, "1990",
	"Super Volleyball\0", NULL, "Video System", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_svolleyRomInfo, pce_svolleyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Susanoo Densetsu

static struct BurnRomInfo pce_susanoRomDesc[] = {
	{ "susanoo densetsu (japan).pce", 0x080000, 0xcf73d8fc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_susano)
STD_ROM_FN(pce_susano)

struct BurnDriver BurnDrvpce_susano = {
	"pce_susano", NULL, NULL, NULL, "1989",
	"Susanoo Densetsu\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_susanoRomInfo, pce_susanoRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Taito Chase H.Q.

static struct BurnRomInfo pce_chasehqRomDesc[] = {
	{ "taito chase h.q. (japan).pce", 0x060000, 0x6f4fd790, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_chasehq)
STD_ROM_FN(pce_chasehq)

struct BurnDriver BurnDrvpce_chasehq = {
	"pce_chasehq", NULL, NULL, NULL, "1990",
	"Taito Chase H.Q.\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_chasehqRomInfo, pce_chasehqRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Takahashi Meijin no Shin Boukenjima

static struct BurnRomInfo pce_takameibRomDesc[] = {
	{ "takahashi meijin no shin boukenjima (japan).pce", 0x080000, 0xe415ea19, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_takameib)
STD_ROM_FN(pce_takameib)

struct BurnDriver BurnDrvpce_takameib = {
	"pce_takameib", NULL, NULL, NULL, "1992",
	"Takahashi Meijin no Shin Boukenjima\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_takameibRomInfo, pce_takameibRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Takeda Shingen

static struct BurnRomInfo pce_shingenRomDesc[] = {
	{ "takeda shingen (japan).pce", 0x040000, 0xf022be13, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shingen)
STD_ROM_FN(pce_shingen)

struct BurnDriver BurnDrvpce_shingen = {
	"pce_shingen", NULL, NULL, NULL, "1989",
	"Takeda Shingen\0", NULL, "Aicom", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shingenRomInfo, pce_shingenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Takeda Shingen (Alt)

static struct BurnRomInfo pce_shingen1RomDesc[] = {
	{ "takeda shingen (japan) [a].pce", 0x040000, 0xdf7af71c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_shingen1)
STD_ROM_FN(pce_shingen1)

struct BurnDriver BurnDrvpce_shingen1 = {
	"pce_shingen1", "pce_shingen", NULL, NULL, "1989",
	"Takeda Shingen (Alt)\0", NULL, "Aicom", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_shingen1RomInfo, pce_shingen1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tatsujin

static struct BurnRomInfo pce_tatsujinRomDesc[] = {
	{ "tatsujin (japan).pce", 0x080000, 0xa6088275, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tatsujin)
STD_ROM_FN(pce_tatsujin)

struct BurnDriver BurnDrvpce_tatsujin = {
	"pce_tatsujin", NULL, NULL, NULL, "1992",
	"Tatsujin\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tatsujinRomInfo, pce_tatsujinRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tatsujin (Prototype)

static struct BurnRomInfo pce_tatsujinpRomDesc[] = {
	{ "tatsujin (japan) (proto).pce", 0x080000, 0xc1b26659, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tatsujinp)
STD_ROM_FN(pce_tatsujinp)

struct BurnDriver BurnDrvpce_tatsujinp = {
	"pce_tatsujinp", "pce_tatsujin", NULL, NULL, "1992",
	"Tatsujin (Prototype)\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tatsujinpRomInfo, pce_tatsujinpRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tatsu No Ko Fighter

static struct BurnRomInfo pce_tatsunokRomDesc[] = {
	{ "tatsunoko fighter (japan).pce", 0x040000, 0xeeb6dd43, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tatsunok)
STD_ROM_FN(pce_tatsunok)

struct BurnDriver BurnDrvpce_tatsunok = {
	"pce_tatsunok", NULL, NULL, NULL, "1989",
	"Tatsu No Ko Fighter\0", NULL, "Tonkin House", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tatsunokRomInfo, pce_tatsunokRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tennokoe Bank

static struct BurnRomInfo pce_tennokoeRomDesc[] = {
	{ "tennokoe bank (japan).pce", 0x020000, 0x3b3808bd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tennokoe)
STD_ROM_FN(pce_tennokoe)

struct BurnDriverD BurnDrvpce_tennokoe = {
	"pce_tennokoe", NULL, NULL, NULL, "1991",
	"Tennokoe Bank\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tennokoeRomInfo, pce_tennokoeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tenseiryuu - Saint Dragon

static struct BurnRomInfo pce_sdragonRomDesc[] = {
	{ "tenseiryuu - saint dragon (japan).pce", 0x060000, 0x2e278ccb, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_sdragon)
STD_ROM_FN(pce_sdragon)

struct BurnDriver BurnDrvpce_sdragon = {
	"pce_sdragon", NULL, NULL, NULL, "1990",
	"Tenseiryuu - Saint Dragon\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_sdragonRomInfo, pce_sdragonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Terra Cresta II - Mandoraa no Gyakushuu

static struct BurnRomInfo pce_terracr2RomDesc[] = {
	{ "terra cresta ii - mandoraa no gyakushuu (japan).pce", 0x080000, 0x1b2d0077, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_terracr2)
STD_ROM_FN(pce_terracr2)

struct BurnDriver BurnDrvpce_terracr2 = {
	"pce_terracr2", NULL, NULL, NULL, "1992",
	"Terra Cresta II - Mandoraa no Gyakushuu\0", NULL, "Nihon Bussan", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_terracr2RomInfo, pce_terracr2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Thunder Blade

static struct BurnRomInfo pce_tbladeRomDesc[] = {
	{ "thunder blade (japan).pce", 0x080000, 0xddc3e809, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tblade)
STD_ROM_FN(pce_tblade)

struct BurnDriver BurnDrvpce_tblade = {
	"pce_tblade", NULL, NULL, NULL, "1990",
	"Thunder Blade\0", NULL, "NEC Avenue", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tbladeRomInfo, pce_tbladeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Time Cruise II

static struct BurnRomInfo pce_timcrus2RomDesc[] = {
	{ "time cruise ii (japan).pce", 0x080000, 0xcfec1d6a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_timcrus2)
STD_ROM_FN(pce_timcrus2)

struct BurnDriver BurnDrvpce_timcrus2 = {
	"pce_timcrus2", NULL, NULL, NULL, "1991",
	"Time Cruise II\0", NULL, "Face", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_timcrus2RomInfo, pce_timcrus2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Titan

static struct BurnRomInfo pce_titanRomDesc[] = {
	{ "titan (japan).pce", 0x040000, 0xd20f382f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_titan)
STD_ROM_FN(pce_titan)

struct BurnDriver BurnDrvpce_titan = {
	"pce_titan", NULL, NULL, NULL, "1991",
	"Titan\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_titanRomInfo, pce_titanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Toilet Kids

static struct BurnRomInfo pce_toiletkRomDesc[] = {
	{ "toilet kids (japan).pce", 0x080000, 0x53b7784b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_toiletk)
STD_ROM_FN(pce_toiletk)

struct BurnDriver BurnDrvpce_toiletk = {
	"pce_toiletk", NULL, NULL, NULL, "1992",
	"Toilet Kids\0", NULL, "Media Rings Corporation", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_toiletkRomInfo, pce_toiletkRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tora e no Michi

static struct BurnRomInfo pce_toramichRomDesc[] = {
	{ "tora e no michi (japan).pce", 0x060000, 0x82ae3b16, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_toramich)
STD_ROM_FN(pce_toramich)

struct BurnDriver BurnDrvpce_toramich = {
	"pce_toramich", NULL, NULL, NULL, "1990",
	"Tora e no Michi\0", NULL, "Victor Entertainment", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_toramichRomInfo, pce_toramichRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Toshi Tensou Keikaku - Eternal City

static struct BurnRomInfo pce_etercityRomDesc[] = {
	{ "toshi tensou keikaku - eternal city (japan).pce", 0x060000, 0xb18d102d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_etercity)
STD_ROM_FN(pce_etercity)

struct BurnDriver BurnDrvpce_etercity = {
	"pce_etercity", NULL, NULL, NULL, "1991",
	"Toshi Tensou Keikaku - Eternal City\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_etercityRomInfo, pce_etercityRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// The Tower of Druaga

static struct BurnRomInfo pce_druagaRomDesc[] = {
	{ "tower of druaga, the (japan).pce", 0x080000, 0x72e00bc4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_druaga)
STD_ROM_FN(pce_druaga)

struct BurnDriver BurnDrvpce_druaga = {
	"pce_druaga", NULL, NULL, NULL, "1992",
	"The Tower of Druaga\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_druagaRomInfo, pce_druagaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Toy Shop Boys

static struct BurnRomInfo pce_toyshopbRomDesc[] = {
	{ "toy shop boys (japan).pce", 0x040000, 0x97c5ee9a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_toyshopb)
STD_ROM_FN(pce_toyshopb)

struct BurnDriver BurnDrvpce_toyshopb = {
	"pce_toyshopb", NULL, NULL, NULL, "1990",
	"Toy Shop Boys\0", NULL, "Victor", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_toyshopbRomInfo, pce_toyshopbRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tricky

static struct BurnRomInfo pce_trickyRomDesc[] = {
	{ "tricky (japan).pce", 0x040000, 0x3aea2f8f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tricky)
STD_ROM_FN(pce_tricky)

struct BurnDriver BurnDrvpce_tricky = {
	"pce_tricky", NULL, NULL, NULL, "1991",
	"Tricky\0", NULL, "IGS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_trickyRomInfo, pce_trickyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tsuppari Oozumou - Heisei Ban

static struct BurnRomInfo pce_tsuppariRomDesc[] = {
	{ "tsuppari oozumou - heisei ban (japan).pce", 0x040000, 0x61a6e210, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tsuppari)
STD_ROM_FN(pce_tsuppari)

struct BurnDriver BurnDrvpce_tsuppari = {
	"pce_tsuppari", NULL, NULL, NULL, "1993",
	"Tsuppari Oozumou - Heisei Ban\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tsuppariRomInfo, pce_tsuppariRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tsuru Teruhito no Jissen Kabushiki Bai Bai Game

static struct BurnRomInfo pce_baibaiRomDesc[] = {
	{ "tsuru teruhito no jissen kabushiki bai bai game (japan).pce", 0x040000, 0xf70112e5, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_baibai)
STD_ROM_FN(pce_baibai)

struct BurnDriver BurnDrvpce_baibai = {
	"pce_baibai", NULL, NULL, NULL, "1989",
	"Tsuru Teruhito no Jissen Kabushiki Bai Bai Game\0", NULL, "Intec", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_baibaiRomInfo, pce_baibaiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TV Sports Basketball

static struct BurnRomInfo pce_tvbasketRomDesc[] = {
	{ "tv sports basketball (japan).pce", 0x080000, 0x10b60601, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tvbasket)
STD_ROM_FN(pce_tvbasket)

struct BurnDriver BurnDrvpce_tvbasket = {
	"pce_tvbasket", NULL, NULL, NULL, "1993",
	"TV Sports Basketball\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tvbasketRomInfo, pce_tvbasketRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TV Sports Football

static struct BurnRomInfo pce_tvfootblRomDesc[] = {
	{ "tv sports football (japan).pce", 0x060000, 0x968d908a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tvfootbl)
STD_ROM_FN(pce_tvfootbl)

struct BurnDriver BurnDrvpce_tvfootbl = {
	"pce_tvfootbl", NULL, NULL, NULL, "1991",
	"TV Sports Football\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tvfootblRomInfo, pce_tvfootblRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TV Sports Hockey

static struct BurnRomInfo pce_tvhockeyRomDesc[] = {
	{ "tv sports hockey (japan).pce", 0x060000, 0xe7529890, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tvhockey)
STD_ROM_FN(pce_tvhockey)

struct BurnDriver BurnDrvpce_tvhockey = {
	"pce_tvhockey", NULL, NULL, NULL, "1993",
	"TV Sports Hockey\0", NULL, "Victor Interactive Software", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tvhockeyRomInfo, pce_tvhockeyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// USA Pro Basketball

static struct BurnRomInfo pce_usaprobsRomDesc[] = {
	{ "usa pro basketball (japan).pce", 0x040000, 0x1cad4b7f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_usaprobs)
STD_ROM_FN(pce_usaprobs)

struct BurnDriver BurnDrvpce_usaprobs = {
	"pce_usaprobs", NULL, NULL, NULL, "1989",
	"USA Pro Basketball\0", NULL, "Aicom", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_usaprobsRomInfo, pce_usaprobsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Veigues - Tactical Gladiator

static struct BurnRomInfo pce_veiguesRomDesc[] = {
	{ "veigues - tactical gladiator (japan).pce", 0x060000, 0x04188c5c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_veigues)
STD_ROM_FN(pce_veigues)

struct BurnDriver BurnDrvpce_veigues = {
	"pce_veigues", NULL, NULL, NULL, "1990",
	"Veigues - Tactical Gladiator\0", NULL, "Victor Entertainment", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_veiguesRomInfo, pce_veiguesRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Victory Run

static struct BurnRomInfo pce_victoryrRomDesc[] = {
	{ "victory run (japan).pce", 0x040000, 0x03e28cff, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_victoryr)
STD_ROM_FN(pce_victoryr)

struct BurnDriver BurnDrvpce_victoryr = {
	"pce_victoryr", NULL, NULL, NULL, "1987",
	"Victory Run\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_victoryrRomInfo, pce_victoryrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Vigilante

static struct BurnRomInfo pce_vigilantRomDesc[] = {
	{ "vigilante (japan).pce", 0x060000, 0xe4124fe0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_vigilant)
STD_ROM_FN(pce_vigilant)

struct BurnDriver BurnDrvpce_vigilant = {
	"pce_vigilant", NULL, NULL, NULL, "1989",
	"Vigilante\0", NULL, "Irem", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_vigilantRomInfo, pce_vigilantRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Violent Soldier

static struct BurnRomInfo pce_violentsRomDesc[] = {
	{ "violent soldier (japan).pce", 0x060000, 0x1bc36b36, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_violents)
STD_ROM_FN(pce_violents)

struct BurnDriver BurnDrvpce_violents = {
	"pce_violents", NULL, NULL, NULL, "1990",
	"Violent Soldier\0", NULL, "IGS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_violentsRomInfo, pce_violentsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Volfied

static struct BurnRomInfo pce_volfiedRomDesc[] = {
	{ "volfied (japan).pce", 0x060000, 0xad226f30, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_volfied)
STD_ROM_FN(pce_volfied)

struct BurnDriver BurnDrvpce_volfied = {
	"pce_volfied", NULL, NULL, NULL, "1989",
	"Volfied\0", NULL, "Taito", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_volfiedRomInfo, pce_volfiedRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// W-ring - The Double Rings

static struct BurnRomInfo pce_wringRomDesc[] = {
	{ "w-ring - the double rings (japan).pce", 0x060000, 0xbe990010, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wring)
STD_ROM_FN(pce_wring)

struct BurnDriver BurnDrvpce_wring = {
	"pce_wring", NULL, NULL, NULL, "1990",
	"W-ring - The Double Rings\0", NULL, "Naxat", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wringRomInfo, pce_wringRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Wai Wai Mahjong - Yukaina Janyuu Tachi

static struct BurnRomInfo pce_waiwaimjRomDesc[] = {
	{ "wai wai mahjong - yukaina janyuu tachi (japan).pce", 0x040000, 0xa2a0776e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_waiwaimj)
STD_ROM_FN(pce_waiwaimj)

struct BurnDriver BurnDrvpce_waiwaimj = {
	"pce_waiwaimj", NULL, NULL, NULL, "1989",
	"Wai Wai Mahjong - Yukaina Janyuu Tachi\0", NULL, "Video System", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_waiwaimjRomInfo, pce_waiwaimjRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Walkuere no Densetsu

static struct BurnRomInfo pce_valkyrieRomDesc[] = {
	{ "walkuere no densetsu (japan).pce", 0x080000, 0xa3303978, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_valkyrie)
STD_ROM_FN(pce_valkyrie)

struct BurnDriver BurnDrvpce_valkyrie = {
	"pce_valkyrie", NULL, NULL, NULL, "1990",
	"Valkyrie no Densetsu\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_valkyrieRomInfo, pce_valkyrieRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Wallaby!! - Usagi no Kuni no Kangaroo Race

static struct BurnRomInfo pce_wallabyRomDesc[] = {
	{ "wallaby!! - usagi no kuni no kangaroo race (japan).pce", 0x060000, 0x0112d0c7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wallaby)
STD_ROM_FN(pce_wallaby)

struct BurnDriver BurnDrvpce_wallaby = {
	"pce_wallaby", NULL, NULL, NULL, "1990",
	"Wallaby!! - Usagi no Kuni no Kangaroo Race\0", NULL, "Masiya", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wallabyRomInfo, pce_wallabyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Winning Shot

static struct BurnRomInfo pce_winshotRomDesc[] = {
	{ "winning shot (japan).pce", 0x040000, 0x9b5ebc58, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_winshot)
STD_ROM_FN(pce_winshot)

struct BurnDriver BurnDrvpce_winshot = {
	"pce_winshot", NULL, NULL, NULL, "1989",
	"Winning Shot\0", NULL, "Data East", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_winshotRomInfo, pce_winshotRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Wonder Momo

static struct BurnRomInfo pce_wondermRomDesc[] = {
	{ "wonder momo (japan).pce", 0x040000, 0x59d07314, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wonderm)
STD_ROM_FN(pce_wonderm)

struct BurnDriver BurnDrvpce_wonderm = {
	"pce_wonderm", NULL, NULL, NULL, "1989",
	"Wonder Momo\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wondermRomInfo, pce_wondermRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	wondermomoInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// World Beach Volley

static struct BurnRomInfo pce_wbeachRomDesc[] = {
	{ "world beach volley (japan).pce", 0x040000, 0xbe850530, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wbeach)
STD_ROM_FN(pce_wbeach)

struct BurnDriver BurnDrvpce_wbeach = {
	"pce_wbeach", NULL, NULL, NULL, "1990",
	"World Beach Volley\0", NULL, "IGS", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wbeachRomInfo, pce_wbeachRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// World Circuit

static struct BurnRomInfo pce_wcircuitRomDesc[] = {
	{ "world circuit (japan).pce", 0x040000, 0xb3eeea2e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wcircuit)
STD_ROM_FN(pce_wcircuit)

struct BurnDriver BurnDrvpce_wcircuit = {
	"pce_wcircuit", NULL, NULL, NULL, "1991",
	"World Circuit\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wcircuitRomInfo, pce_wcircuitRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// World Jockey

static struct BurnRomInfo pce_wjockeyRomDesc[] = {
	{ "world jockey (japan).pce", 0x040000, 0xa9ab2954, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_wjockey)
STD_ROM_FN(pce_wjockey)

struct BurnDriver BurnDrvpce_wjockey = {
	"pce_wjockey", NULL, NULL, NULL, "1991",
	"World Jockey\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_wjockeyRomInfo, pce_wjockeyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Xevious - Fardraut Densetsu

static struct BurnRomInfo pce_xeviousRomDesc[] = {
	{ "xevious - fardraut densetsu (japan).pce", 0x040000, 0xf8f85eec, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_xevious)
STD_ROM_FN(pce_xevious)

struct BurnDriver BurnDrvpce_xevious = {
	"pce_xevious", NULL, NULL, NULL, "1990",
	"Xevious - Fardraut Densetsu\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_xeviousRomInfo, pce_xeviousRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Youkai Douchuuki

static struct BurnRomInfo pce_youkaidRomDesc[] = {
	{ "youkai douchuuki (japan).pce", 0x040000, 0xf131b706, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_youkaid)
STD_ROM_FN(pce_youkaid)

struct BurnDriver BurnDrvpce_youkaid = {
	"pce_youkaid", NULL, NULL, NULL, "1988",
	"Youkai Douchuuki\0", NULL, "Namcot", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_youkaidRomInfo, pce_youkaidRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Yuu Yuu Jinsei - Victory Life

static struct BurnRomInfo pce_yuyuRomDesc[] = {
	{ "yuu yuu jinsei - victory life (japan).pce", 0x040000, 0xc0905ca9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_yuyu)
STD_ROM_FN(pce_yuyu)

struct BurnDriver BurnDrvpce_yuyu = {
	"pce_yuyu", NULL, NULL, NULL, "1988",
	"Yuu Yuu Jinsei - Victory Life\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_yuyuRomInfo, pce_yuyuRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Zero 4 Champ

static struct BurnRomInfo pce_zero4caRomDesc[] = {
	{ "zero 4 champ (japan).pce", 0x080000, 0xee156721, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_zero4ca)
STD_ROM_FN(pce_zero4ca)

struct BurnDriver BurnDrvpce_zero4ca = {
	"pce_zero4ca", "pce_zero4c", NULL, NULL, "1991",
	"Zero 4 Champ\0", NULL, "Media Rings Corporation", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_zero4caRomInfo, pce_zero4caRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Zero 4 Champ (v1.5)

static struct BurnRomInfo pce_zero4cRomDesc[] = {
	{ "zero 4 champ (japan) (v1.5).pce", 0x080000, 0xb77f2e2f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_zero4c)
STD_ROM_FN(pce_zero4c)

struct BurnDriver BurnDrvpce_zero4c = {
	"pce_zero4c", NULL, NULL, NULL, "1991",
	"Zero 4 Champ (v1.5)\0", NULL, "Media Rings Corporation", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_zero4cRomInfo, pce_zero4cRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Zipang

static struct BurnRomInfo pce_zipangRomDesc[] = {
	{ "zipang (japan).pce", 0x040000, 0x67aab7a1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_zipang)
STD_ROM_FN(pce_zipang)

struct BurnDriver BurnDrvpce_zipang = {
	"pce_zipang", NULL, NULL, NULL, "1990",
	"Zipang\0", NULL, "Pack-In-Video", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_zipangRomInfo, pce_zipangRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// CD-Rom System Card (v1.0)

static struct BurnRomInfo pce_cdsysbRomDesc[] = {
	{ "[cd] cd-rom system (japan) (v1.0).pce", 0x040000, 0x3f9f95a4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cdsysb)
STD_ROM_FN(pce_cdsysb)

struct BurnDriverD BurnDrvpce_cdsysb = {
	"pce_cdsysb", "pce_cdsys", NULL, NULL, "19??",
	"CD-Rom System Card (v1.0)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cdsysbRomInfo, pce_cdsysbRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// CD-Rom System Card (v2.0)

static struct BurnRomInfo pce_cdsysaRomDesc[] = {
	{ "[cd] cd-rom system (japan) (v2.0).pce", 0x040000, 0x52520bc6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cdsysa)
STD_ROM_FN(pce_cdsysa)

struct BurnDriverD BurnDrvpce_cdsysa = {
	"pce_cdsysa", "pce_cdsys", NULL, NULL, "19??",
	"CD-Rom System Card (v2.0)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_CLONE, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cdsysaRomInfo, pce_cdsysaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// CD-Rom System Card (v2.1)

static struct BurnRomInfo pce_cdsysRomDesc[] = {
	{ "[cd] cd-rom system (japan) (v2.1).pce", 0x040000, 0x283b74e0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cdsys)
STD_ROM_FN(pce_cdsys)

struct BurnDriverD BurnDrvpce_cdsys = {
	"pce_cdsys", NULL, NULL, NULL, "19??",
	"CD-Rom System Card (v2.1)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cdsysRomInfo, pce_cdsysRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Games Express CD Card

static struct BurnRomInfo pce_gecdRomDesc[] = {
	{ "[cd] games express cd card (japan).pce", 0x008000, 0x51a12d90, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_gecd)
STD_ROM_FN(pce_gecd)

struct BurnDriverD BurnDrvpce_gecd = {
	"pce_gecd", NULL, NULL, NULL, "19??",
	"Games Express CD Card\0", NULL, "Games Express", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_gecdRomInfo, pce_gecdRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super CD-Rom System Card (v3.0)

static struct BurnRomInfo pce_scdsysRomDesc[] = {
	{ "[cd] super cd-rom system (japan) (v3.0).pce", 0x040000, 0x6d9a73ef, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_scdsys)
STD_ROM_FN(pce_scdsys)

struct BurnDriverD BurnDrvpce_scdsys = {
	"pce_scdsys", NULL, NULL, NULL, "19??",
	"Super CD-Rom System Card (v3.0)\0", NULL, "Hudson", "PC Engine",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_scdsysRomInfo, pce_scdsysRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Aero Blasters

static struct BurnRomInfo tg_aeroblstRomDesc[] = {
	{ "aero blasters (usa).pce", 0x080000, 0xb03e0b32, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_aeroblst)
STD_ROM_FN(tg_aeroblst)

struct BurnDriver BurnDrvtg_aeroblst = {
	"tg_aeroblst", NULL, NULL, NULL, "1990",
	"Aero Blasters\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_aeroblstRomInfo, tg_aeroblstRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Air Zonk

static struct BurnRomInfo tg_airzonkRomDesc[] = {
	{ "air zonk (usa).pce", 0x080000, 0x933d5bcc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_airzonk)
STD_ROM_FN(tg_airzonk)

struct BurnDriverD BurnDrvtg_airzonk = {
	"tg_airzonk", NULL, NULL, NULL, "1992",
	"Air Zonk\0", NULL, "Hudson Soft", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_airzonkRomInfo, tg_airzonkRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Alien Crush

static struct BurnRomInfo tg_acrushRomDesc[] = {
	{ "alien crush (usa).pce", 0x040000, 0xea488494, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_acrush)
STD_ROM_FN(tg_acrush)

struct BurnDriver BurnDrvtg_acrush = {
	"tg_acrush", NULL, NULL, NULL, "1989",
	"Alien Crush\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_acrushRomInfo, tg_acrushRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ballistix

static struct BurnRomInfo tg_ballistxRomDesc[] = {
	{ "ballistix (usa).pce", 0x040000, 0x420fa189, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_ballistx)
STD_ROM_FN(tg_ballistx)

struct BurnDriver BurnDrvtg_ballistx = {
	"tg_ballistx", NULL, NULL, NULL, "1992",
	"Ballistix\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_ballistxRomInfo, tg_ballistxRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Battle Royale

static struct BurnRomInfo tg_batlroylRomDesc[] = {
	{ "battle royale (usa).pce", 0x080000, 0xe70b01af, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_batlroyl)
STD_ROM_FN(tg_batlroyl)

struct BurnDriver BurnDrvtg_batlroyl = {
	"tg_batlroyl", NULL, NULL, NULL, "1990",
	"Battle Royale\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_batlroylRomInfo, tg_batlroylRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Blazing Lazers

static struct BurnRomInfo tg_blazlazrRomDesc[] = {
	{ "blazing lazers (usa).pce", 0x060000, 0xb4a1b0f6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_blazlazr)
STD_ROM_FN(tg_blazlazr)

struct BurnDriver BurnDrvtg_blazlazr = {
	"tg_blazlazr", NULL, NULL, NULL, "1989",
	"Blazing Lazers\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_blazlazrRomInfo, tg_blazlazrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bloody Wolf

static struct BurnRomInfo tg_blodwolfRomDesc[] = {
	{ "bloody wolf (usa).pce", 0x080000, 0x37baf6bc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_blodwolf)
STD_ROM_FN(tg_blodwolf)

struct BurnDriver BurnDrvtg_blodwolf = {
	"tg_blodwolf", NULL, NULL, NULL, "1990",
	"Bloody Wolf\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_blodwolfRomInfo, tg_blodwolfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman '93

static struct BurnRomInfo tg_bombmn93RomDesc[] = {
	{ "bomberman '93 (usa).pce", 0x080000, 0x56171c1c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_bombmn93)
STD_ROM_FN(tg_bombmn93)

struct BurnDriver BurnDrvtg_bombmn93 = {
	"tg_bombmn93", NULL, NULL, NULL, "1990",
	"Bomberman '93\0", NULL, "Hudson Soft", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_bombmn93RomInfo, tg_bombmn93RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bomberman

static struct BurnRomInfo tg_bombmanRomDesc[] = {
	{ "bomberman (usa).pce", 0x040000, 0x5f6f3c2a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_bombman)
STD_ROM_FN(tg_bombman)

struct BurnDriver BurnDrvtg_bombman = {
	"tg_bombman", NULL, NULL, NULL, "1991",
	"Bomberman\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_bombmanRomInfo, tg_bombmanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bonk III - Bonk's Big Adventure

static struct BurnRomInfo tg_bonk3RomDesc[] = {
	{ "bonk iii - bonk's big adventure (usa).pce", 0x100000, 0x5a3f76d8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_bonk3)
STD_ROM_FN(tg_bonk3)

struct BurnDriver BurnDrvtg_bonk3 = {
	"tg_bonk3", NULL, NULL, NULL, "1993",
	"Bonk III - Bonk's Big Adventure\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_bonk3RomInfo, tg_bonk3RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bonk's Adventure

static struct BurnRomInfo tg_bonkRomDesc[] = {
	{ "bonk's adventure (usa).pce", 0x060000, 0x599ead9b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_bonk)
STD_ROM_FN(tg_bonk)

struct BurnDriver BurnDrvtg_bonk = {
	"tg_bonk", NULL, NULL, NULL, "1990",
	"Bonk's Adventure\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_bonkRomInfo, tg_bonkRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bonk's Revenge

static struct BurnRomInfo tg_bonk2RomDesc[] = {
	{ "bonk's revenge (usa).pce", 0x080000, 0x14250f9a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_bonk2)
STD_ROM_FN(tg_bonk2)

struct BurnDriver BurnDrvtg_bonk2 = {
	"tg_bonk2", NULL, NULL, NULL, "1991",
	"Bonk's Revenge\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_bonk2RomInfo, tg_bonk2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Boxyboy

static struct BurnRomInfo tg_boxyboyRomDesc[] = {
	{ "boxyboy (usa).pce", 0x020000, 0x605be213, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_boxyboy)
STD_ROM_FN(tg_boxyboy)

struct BurnDriver BurnDrvtg_boxyboy = {
	"tg_boxyboy", NULL, NULL, NULL, "1990",
	"Boxyboy\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_boxyboyRomInfo, tg_boxyboyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Bravoman

static struct BurnRomInfo tg_bravomanRomDesc[] = {
	{ "bravoman (usa).pce", 0x080000, 0xcca08b02, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_bravoman)
STD_ROM_FN(tg_bravoman)

struct BurnDriver BurnDrvtg_bravoman = {
	"tg_bravoman", NULL, NULL, NULL, "1990",
	"Bravoman\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_bravomanRomInfo, tg_bravomanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cadash

static struct BurnRomInfo tg_cadashRomDesc[] = {
	{ "cadash (usa).pce", 0x080000, 0xbb0b3aef, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_cadash)
STD_ROM_FN(tg_cadash)

struct BurnDriver BurnDrvtg_cadash = {
	"tg_cadash", NULL, NULL, NULL, "1991",
	"Cadash\0", "Bad graphics", "Working Designs", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_cadashRomInfo, tg_cadashRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Champions Forever Boxing

static struct BurnRomInfo tg_forevboxRomDesc[] = {
	{ "champions forever boxing (usa).pce", 0x080000, 0x15ee889a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_forevbox)
STD_ROM_FN(tg_forevbox)

struct BurnDriver BurnDrvtg_forevbox = {
	"tg_forevbox", NULL, NULL, NULL, "1991",
	"Champions Forever Boxing\0", "Bad sound", "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_forevboxRomInfo, tg_forevboxRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Chew Man Fu

static struct BurnRomInfo tg_chewmanRomDesc[] = {
	{ "chew man fu (usa).pce", 0x040000, 0x8cd13e9a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_chewman)
STD_ROM_FN(tg_chewman)

struct BurnDriver BurnDrvtg_chewman = {
	"tg_chewman", NULL, NULL, NULL, "1990",
	"Chew Man Fu\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_chewmanRomInfo, tg_chewmanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// China Warrior

static struct BurnRomInfo tg_chinawarRomDesc[] = {
	{ "china warrior (usa).pce", 0x040000, 0xa2ee361d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_chinawar)
STD_ROM_FN(tg_chinawar)

struct BurnDriver BurnDrvtg_chinawar = {
	"tg_chinawar", NULL, NULL, NULL, "1989",
	"China Warrior\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_chinawarRomInfo, tg_chinawarRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cratermaze

static struct BurnRomInfo tg_cratermzRomDesc[] = {
	{ "cratermaze (usa).pce", 0x040000, 0x9033e83a, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_cratermz)
STD_ROM_FN(tg_cratermz)

struct BurnDriver BurnDrvtg_cratermz = {
	"tg_cratermz", NULL, NULL, NULL, "1990",
	"Cratermaze\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_cratermzRomInfo, tg_cratermzRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Cyber Core

static struct BurnRomInfo tg_cybrcoreRomDesc[] = {
	{ "cyber core (usa).pce", 0x060000, 0x4cfb6e3e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_cybrcore)
STD_ROM_FN(tg_cybrcore)

struct BurnDriver BurnDrvtg_cybrcore = {
	"tg_cybrcore", NULL, NULL, NULL, "1990",
	"Cyber Core\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_cybrcoreRomInfo, tg_cybrcoreRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Darkwing Duck

static struct BurnRomInfo tg_darkwingRomDesc[] = {
	{ "darkwing duck (usa).pce", 0x080000, 0x4ac97606, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_darkwing)
STD_ROM_FN(tg_darkwing)

struct BurnDriver BurnDrvtg_darkwing = {
	"tg_darkwing", NULL, NULL, NULL, "1992",
	"Darkwing Duck\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_darkwingRomInfo, tg_darkwingRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Davis Cup Tennis

static struct BurnRomInfo tg_daviscupRomDesc[] = {
	{ "davis cup tennis (usa).pce", 0x080000, 0x9edab596, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_daviscup)
STD_ROM_FN(tg_daviscup)

struct BurnDriver BurnDrvtg_daviscup = {
	"tg_daviscup", NULL, NULL, NULL, "1991",
	"Davis Cup Tennis\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_daviscupRomInfo, tg_daviscupRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dead Moon

static struct BurnRomInfo tg_deadmoonRomDesc[] = {
	{ "dead moon (usa).pce", 0x080000, 0xf5d98b0b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_deadmoon)
STD_ROM_FN(tg_deadmoon)

struct BurnDriver BurnDrvtg_deadmoon = {
	"tg_deadmoon", NULL, NULL, NULL, "1992",
	"Dead Moon\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_deadmoonRomInfo, tg_deadmoonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Deep Blue

static struct BurnRomInfo tg_deepblueRomDesc[] = {
	{ "deep blue (usa).pce", 0x040000, 0x16b40b44, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_deepblue)
STD_ROM_FN(tg_deepblue)

struct BurnDriver BurnDrvtg_deepblue = {
	"tg_deepblue", NULL, NULL, NULL, "1989",
	"Deep Blue\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_deepblueRomInfo, tg_deepblueRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Devil's Crush - Naxat Pinball

static struct BurnRomInfo tg_devlcrshRomDesc[] = {
	{ "devil's crush - naxat pinball (usa).pce", 0x060000, 0x157b4492, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_devlcrsh)
STD_ROM_FN(tg_devlcrsh)

struct BurnDriver BurnDrvtg_devlcrsh = {
	"tg_devlcrsh", NULL, NULL, NULL, "1990",
	"Devil's Crush - Naxat Pinball\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_devlcrshRomInfo, tg_devlcrshRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Double Dungeons - W

static struct BurnRomInfo tg_ddungwRomDesc[] = {
	{ "double dungeons - w (usa).pce", 0x040000, 0x4a1a8c60, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_ddungw)
STD_ROM_FN(tg_ddungw)

struct BurnDriver BurnDrvtg_ddungw = {
	"tg_ddungw", NULL, NULL, NULL, "1990",
	"Double Dungeons - W\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_ddungwRomInfo, tg_ddungwRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dragon Spirit

static struct BurnRomInfo tg_dspiritRomDesc[] = {
	{ "dragon spirit (usa).pce", 0x040000, 0x086f148c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_dspirit)
STD_ROM_FN(tg_dspirit)

struct BurnDriver BurnDrvtg_dspirit = {
	"tg_dspirit", NULL, NULL, NULL, "1989",
	"Dragon Spirit\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_dspiritRomInfo, tg_dspiritRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dragon's Curse

static struct BurnRomInfo tg_dragcrseRomDesc[] = {
	{ "dragon's curse (usa).pce", 0x040000, 0x7d2c4b09, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_dragcrse)
STD_ROM_FN(tg_dragcrse)

struct BurnDriver BurnDrvtg_dragcrse = {
	"tg_dragcrse", NULL, NULL, NULL, "1990",
	"Dragon's Curse\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_dragcrseRomInfo, tg_dragcrseRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Drop.Off

static struct BurnRomInfo tg_dropoffRomDesc[] = {
	{ "drop.off (usa).pce", 0x040000, 0xfea27b32, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_dropoff)
STD_ROM_FN(tg_dropoff)

struct BurnDriver BurnDrvtg_dropoff = {
	"tg_dropoff", NULL, NULL, NULL, "1990",
	"Drop.Off\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_dropoffRomInfo, tg_dropoffRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dungeon Explorer

static struct BurnRomInfo tg_dungexplRomDesc[] = {
	{ "dungeon explorer (usa).pce", 0x060000, 0x4ff01515, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_dungexpl)
STD_ROM_FN(tg_dungexpl)

struct BurnDriver BurnDrvtg_dungexpl = {
	"tg_dungexpl", NULL, NULL, NULL, "1989",
	"Dungeon Explorer\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_dungexplRomInfo, tg_dungexplRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Falcon

static struct BurnRomInfo tg_falconRomDesc[] = {
	{ "falcon (usa).pce", 0x080000, 0x0bc0a12b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_falcon)
STD_ROM_FN(tg_falcon)

struct BurnDriver BurnDrvtg_falcon = {
	"tg_falcon", NULL, NULL, NULL, "1992",
	"Falcon\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_falconRomInfo, tg_falconRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Fantasy Zone

static struct BurnRomInfo tg_fantzoneRomDesc[] = {
	{ "fantasy zone (usa).pce", 0x040000, 0xe8c3573d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_fantzone)
STD_ROM_FN(tg_fantzone)

struct BurnDriver BurnDrvtg_fantzone = {
	"tg_fantzone", NULL, NULL, NULL, "1989",
	"Fantasy Zone\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_fantzoneRomInfo, tg_fantzoneRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Final Lap Twin

static struct BurnRomInfo tg_finallapRomDesc[] = {
	{ "final lap twin (usa).pce", 0x060000, 0x26408ea3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_finallap)
STD_ROM_FN(tg_finallap)

struct BurnDriver BurnDrvtg_finallap = {
	"tg_finallap", NULL, NULL, NULL, "1990",
	"Final Lap Twin\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_finallapRomInfo, tg_finallapRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Galaga '90

static struct BurnRomInfo tg_galaga90RomDesc[] = {
	{ "galaga '90 (usa).pce", 0x040000, 0x2909dec6, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_galaga90)
STD_ROM_FN(tg_galaga90)

struct BurnDriver BurnDrvtg_galaga90 = {
	"tg_galaga90", NULL, NULL, NULL, "1989",
	"Galaga '90\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_galaga90RomInfo, tg_galaga90RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ghost Manor

static struct BurnRomInfo tg_ghostmanRomDesc[] = {
	{ "ghost manor (usa).pce", 0x080000, 0x2db4c1fd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_ghostman)
STD_ROM_FN(tg_ghostman)

struct BurnDriver BurnDrvtg_ghostman = {
	"tg_ghostman", NULL, NULL, NULL, "1992",
	"Ghost Manor\0", "game randomly locks up", "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_ghostmanRomInfo, tg_ghostmanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Gunboat

static struct BurnRomInfo tg_gunboatRomDesc[] = {
	{ "gunboat (usa).pce", 0x080000, 0xf370b58e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_gunboat)
STD_ROM_FN(tg_gunboat)

struct BurnDriver BurnDrvtg_gunboat = {
	"tg_gunboat", NULL, NULL, NULL, "1992",
	"Gunboat\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_gunboatRomInfo, tg_gunboatRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Hit the Ice - VHL - The Official Video Hockey League

static struct BurnRomInfo tg_hiticeRomDesc[] = {
	{ "hit the ice - vhl the official video hockey league (usa).pce", 0x060000, 0x8b29c3aa, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_hitice)
STD_ROM_FN(tg_hitice)

struct BurnDriver BurnDrvtg_hitice = {
	"tg_hitice", NULL, NULL, NULL, "1992",
	"Hit the Ice - VHL - The Official Video Hockey League\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_hiticeRomInfo, tg_hiticeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Impossamole

static struct BurnRomInfo tg_impossamRomDesc[] = {
	{ "impossamole (usa).pce", 0x080000, 0xe2470f5f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_impossam)
STD_ROM_FN(tg_impossam)

struct BurnDriver BurnDrvtg_impossam = {
	"tg_impossam", NULL, NULL, NULL, "1991",
	"Impossamole\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_impossamRomInfo, tg_impossamRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// J.J. & Jeff

static struct BurnRomInfo tg_jjnjeffRomDesc[] = {
	{ "j.j. & jeff (usa).pce", 0x040000, 0xe01c5127, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_jjnjeff)
STD_ROM_FN(tg_jjnjeff)

struct BurnDriver BurnDrvtg_jjnjeff = {
	"tg_jjnjeff", NULL, NULL, NULL, "1990",
	"J.J. & Jeff\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_jjnjeffRomInfo, tg_jjnjeffRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jack Nicklaus' Turbo Golf

static struct BurnRomInfo tg_nicklausRomDesc[] = {
	{ "jack nicklaus' turbo golf (usa).pce", 0x040000, 0x83384572, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_nicklaus)
STD_ROM_FN(tg_nicklaus)

struct BurnDriver BurnDrvtg_nicklaus = {
	"tg_nicklaus", NULL, NULL, NULL, "1990",
	"Jack Nicklaus' Turbo Golf\0", NULL, "Accolade", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_nicklausRomInfo, tg_nicklausRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Jackie Chan's Action Kung Fu

static struct BurnRomInfo tg_jchanRomDesc[] = {
	{ "jackie chan's action kung fu (usa).pce", 0x080000, 0x9d2f6193, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_jchan)
STD_ROM_FN(tg_jchan)

struct BurnDriver BurnDrvtg_jchan = {
	"tg_jchan", NULL, NULL, NULL, "1992",
	"Jackie Chan's Action Kung Fu\0", NULL, "Hudson Soft", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_jchanRomInfo, tg_jchanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Keith Courage in Alpha Zones

static struct BurnRomInfo tg_keithcorRomDesc[] = {
	{ "keith courage in alpha zones (usa).pce", 0x040000, 0x474d7a72, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_keithcor)
STD_ROM_FN(tg_keithcor)

struct BurnDriver BurnDrvtg_keithcor = {
	"tg_keithcor", NULL, NULL, NULL, "1989",
	"Keith Courage in Alpha Zones\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_keithcorRomInfo, tg_keithcorRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// King of Casino

static struct BurnRomInfo tg_kingcasnRomDesc[] = {
	{ "king of casino (usa).pce", 0x040000, 0x2f2e2240, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_kingcasn)
STD_ROM_FN(tg_kingcasn)

struct BurnDriver BurnDrvtg_kingcasn = {
	"tg_kingcasn", NULL, NULL, NULL, "1990",
	"King of Casino\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_kingcasnRomInfo, tg_kingcasnRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Klax

static struct BurnRomInfo tg_klaxRomDesc[] = {
	{ "klax (usa).pce", 0x040000, 0x0f1b59b4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_klax)
STD_ROM_FN(tg_klax)

struct BurnDriver BurnDrvtg_klax = {
	"tg_klax", NULL, NULL, NULL, "1990",
	"Klax\0", NULL, "Tengen", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_klaxRomInfo, tg_klaxRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Legend of Hero Tonma

static struct BurnRomInfo tg_lohtRomDesc[] = {
	{ "legend of hero tonma (usa).pce", 0x080000, 0x3c131486, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_loht)
STD_ROM_FN(tg_loht)

struct BurnDriver BurnDrvtg_loht = {
	"tg_loht", NULL, NULL, NULL, "1991",
	"Legend of Hero Tonma\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_lohtRomInfo, tg_lohtRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// The Legendary Axe II

static struct BurnRomInfo tg_legaxe2RomDesc[] = {
	{ "legendary axe ii, the (usa).pce", 0x040000, 0x220ebf91, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_legaxe2)
STD_ROM_FN(tg_legaxe2)

struct BurnDriver BurnDrvtg_legaxe2 = {
	"tg_legaxe2", NULL, NULL, NULL, "1990",
	"The Legendary Axe II\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_legaxe2RomInfo, tg_legaxe2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// The Legendary Axe

static struct BurnRomInfo tg_legaxeRomDesc[] = {
	{ "legendary axe, the (usa).pce", 0x040000, 0x2d211007, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_legaxe)
STD_ROM_FN(tg_legaxe)

struct BurnDriver BurnDrvtg_legaxe = {
	"tg_legaxe", NULL, NULL, NULL, "1989",
	"The Legendary Axe\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_legaxeRomInfo, tg_legaxeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Magical Chase

static struct BurnRomInfo tg_magchaseRomDesc[] = {
	{ "magical chase (usa).pce", 0x080000, 0x95cd2979, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_magchase)
STD_ROM_FN(tg_magchase)

struct BurnDriver BurnDrvtg_magchase = {
	"tg_magchase", NULL, NULL, NULL, "1991",
	"Magical Chase\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_magchaseRomInfo, tg_magchaseRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Military Madness

static struct BurnRomInfo tg_miltrymdRomDesc[] = {
	{ "military madness (usa).pce", 0x060000, 0x93f316f7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_miltrymd)
STD_ROM_FN(tg_miltrymd)

struct BurnDriver BurnDrvtg_miltrymd = {
	"tg_miltrymd", NULL, NULL, NULL, "1989",
	"Military Madness\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_miltrymdRomInfo, tg_miltrymdRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Moto Roader

static struct BurnRomInfo tg_motoroadRomDesc[] = {
	{ "moto roader (usa).pce", 0x040000, 0xe2b0d544, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_motoroad)
STD_ROM_FN(tg_motoroad)

struct BurnDriver BurnDrvtg_motoroad = {
	"tg_motoroad", NULL, NULL, NULL, "1989",
	"Moto Roader\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_motoroadRomInfo, tg_motoroadRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Neutopia

static struct BurnRomInfo tg_neutopiaRomDesc[] = {
	{ "neutopia (usa).pce", 0x060000, 0xa9a94e1b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_neutopia)
STD_ROM_FN(tg_neutopia)

struct BurnDriver BurnDrvtg_neutopia = {
	"tg_neutopia", NULL, NULL, NULL, "1990",
	"Neutopia\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_neutopiaRomInfo, tg_neutopiaRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Neutopia II

static struct BurnRomInfo tg_neutopi2RomDesc[] = {
	{ "neutopia ii (usa).pce", 0x0c0000, 0xc4ed4307, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_neutopi2)
STD_ROM_FN(tg_neutopi2)

struct BurnDriver BurnDrvtg_neutopi2 = {
	"tg_neutopi2", NULL, NULL, NULL, "1992",
	"Neutopia II\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_neutopi2RomInfo, tg_neutopi2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// New Adventure Island

static struct BurnRomInfo tg_advislndRomDesc[] = {
	{ "new adventure island (usa).pce", 0x080000, 0x756a1802, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_advislnd)
STD_ROM_FN(tg_advislnd)

struct BurnDriver BurnDrvtg_advislnd = {
	"tg_advislnd", NULL, NULL, NULL, "1992",
	"New Adventure Island\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_advislndRomInfo, tg_advislndRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Night Creatures

static struct BurnRomInfo tg_nightcrRomDesc[] = {
	{ "night creatures (usa).pce", 0x080000, 0xc159761b, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_nightcr)
STD_ROM_FN(tg_nightcr)

struct BurnDriver BurnDrvtg_nightcr = {
	"tg_nightcr", NULL, NULL, NULL, "1992",
	"Night Creatures\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_nightcrRomInfo, tg_nightcrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ninja Spirit

static struct BurnRomInfo tg_nspiritRomDesc[] = {
	{ "ninja spirit (usa).pce", 0x080000, 0xde8af1c1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_nspirit)
STD_ROM_FN(tg_nspirit)

struct BurnDriver BurnDrvtg_nspirit = {
	"tg_nspirit", NULL, NULL, NULL, "1990",
	"Ninja Spirit\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_nspiritRomInfo, tg_nspiritRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Order of the Griffon

static struct BurnRomInfo tg_griffonRomDesc[] = {
	{ "order of the griffon (usa).pce", 0x080000, 0xfae0fc60, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_griffon)
STD_ROM_FN(tg_griffon)

struct BurnDriver BurnDrvtg_griffon = {
	"tg_griffon", NULL, NULL, NULL, "1992",
	"Order of the Griffon\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_griffonRomInfo, tg_griffonRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Ordyne

static struct BurnRomInfo tg_ordyneRomDesc[] = {
	{ "ordyne (usa).pce", 0x080000, 0xe7bf2a74, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_ordyne)
STD_ROM_FN(tg_ordyne)

struct BurnDriver BurnDrvtg_ordyne = {
	"tg_ordyne", NULL, NULL, NULL, "1989",
	"Ordyne\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_ordyneRomInfo, tg_ordyneRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Pac-Land

static struct BurnRomInfo tg_paclandRomDesc[] = {
	{ "pac-land (usa).pce", 0x040000, 0xd6e30ccd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_pacland)
STD_ROM_FN(tg_pacland)

struct BurnDriver BurnDrvtg_pacland = {
	"tg_pacland", NULL, NULL, NULL, "1990",
	"Pac-Land\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_paclandRomInfo, tg_paclandRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Panza Kick Boxing

static struct BurnRomInfo tg_panzakbRomDesc[] = {
	{ "panza kick boxing (usa).pce", 0x080000, 0xa980e0e9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_panzakb)
STD_ROM_FN(tg_panzakb)

struct BurnDriver BurnDrvtg_panzakb = {
	"tg_panzakb", NULL, NULL, NULL, "1990",
	"Panza Kick Boxing\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_panzakbRomInfo, tg_panzakbRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Parasol Stars - The Story of Bubble Bobble III

static struct BurnRomInfo tg_parasolRomDesc[] = {
	{ "parasol stars - the story of bubble bobble iii (usa).pce", 0x060000, 0xe6458212, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_parasol)
STD_ROM_FN(tg_parasol)

struct BurnDriver BurnDrvtg_parasol = {
	"tg_parasol", NULL, NULL, NULL, "1991",
	"Parasol Stars - The Story of Bubble Bobble III\0", NULL, "Working Designs", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_parasolRomInfo, tg_parasolRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Power Golf

static struct BurnRomInfo tg_pgolfRomDesc[] = {
	{ "power golf (usa).pce", 0x060000, 0xed1d3843, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_pgolf)
STD_ROM_FN(tg_pgolf)

struct BurnDriver BurnDrvtg_pgolf = {
	"tg_pgolf", NULL, NULL, NULL, "1989",
	"Power Golf\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_pgolfRomInfo, tg_pgolfRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Psychosis

static struct BurnRomInfo tg_psychosRomDesc[] = {
	{ "psychosis (usa).pce", 0x040000, 0x6cc10824, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_psychos)
STD_ROM_FN(tg_psychos)

struct BurnDriver BurnDrvtg_psychos = {
	"tg_psychos", NULL, NULL, NULL, "1990",
	"Psychosis\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_psychosRomInfo, tg_psychosRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// R-Type

static struct BurnRomInfo tg_rtypeRomDesc[] = {
	{ "r-type (usa).pce", 0x080000, 0x91ce5156, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_rtype)
STD_ROM_FN(tg_rtype)

struct BurnDriver BurnDrvtg_rtype = {
	"tg_rtype", NULL, NULL, NULL, "1989",
	"R-Type\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_rtypeRomInfo, tg_rtypeRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// R-Type - Chris Covell's Unfinished SGX Hack
// https://www.chrismcovell.com/creations.html#courrtype

static struct BurnRomInfo sgx_rtypeuhRomDesc[] = {
	{ "r-type (unfinished hack).sgx", 0x080000, 0xcdc9bb74, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_rtypeuh)
STD_ROM_FN(sgx_rtypeuh)

struct BurnDriver BurnDrvsgx_rtypeuh = {
	"sgx_rtypeuh", NULL, NULL, NULL, "2019",
	"R-Type - Chris Covell's Unfinished SGX Hack\0", NULL, "NEC", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_MISC, 0,
	SgxGetZipName, sgx_rtypeuhRomInfo, sgx_rtypeuhRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// RTA2 - Homebrew conversion of RTA2, bonus game present on Revivel Chase CD
// https://www.gamopat-forum.com/t86439-rt2a-sur-supergrafx

static struct BurnRomInfo sgx_rta2RomDesc[] = {
	{ "rta2.sgx", 0x028200, 0x4a4db3da, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_rta2)
STD_ROM_FN(sgx_rta2)

struct BurnDriver BurnDrvsgx_rta2 = {
	"sgx_rta2", NULL, NULL, NULL, "2016",
	"RTA2 - Homebrew conversion of RTA2\0", NULL, "REVIVAL GAMES", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_MISC, 0,
	SgxGetZipName, sgx_rta2RomInfo, sgx_rta2RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Raiden

static struct BurnRomInfo tg_raidenRomDesc[] = {
	{ "raiden (usa).pce", 0x0c0000, 0xbc59c31e, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_raiden)
STD_ROM_FN(tg_raiden)

struct BurnDriver BurnDrvtg_raiden = {
	"tg_raiden", NULL, NULL, NULL, "1990",
	"Raiden\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_raidenRomInfo, tg_raidenRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Samurai-Ghost

static struct BurnRomInfo tg_samuraigRomDesc[] = {
	{ "samurai-ghost (usa).pce", 0x080000, 0x77a924b7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_samuraig)
STD_ROM_FN(tg_samuraig)

struct BurnDriver BurnDrvtg_samuraig = {
	"tg_samuraig", NULL, NULL, NULL, "1992",
	"Samurai-Ghost\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_samuraigRomInfo, tg_samuraigRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Shockman

static struct BurnRomInfo tg_shockmanRomDesc[] = {
	{ "shockman (usa).pce", 0x080000, 0x2774462c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_shockman)
STD_ROM_FN(tg_shockman)

struct BurnDriver BurnDrvtg_shockman = {
	"tg_shockman", NULL, NULL, NULL, "1992",
	"Shockman\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_shockmanRomInfo, tg_shockmanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sidearms - Hyper Dyne

static struct BurnRomInfo tg_sidearmsRomDesc[] = {
	{ "sidearms - hyper dyne (usa).pce", 0x040000, 0xd1993c9f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_sidearms)
STD_ROM_FN(tg_sidearms)

struct BurnDriver BurnDrvtg_sidearms = {
	"tg_sidearms", NULL, NULL, NULL, "1989",
	"Sidearms - Hyper Dyne\0", NULL, "Radiance Software", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_sidearmsRomInfo, tg_sidearmsRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 242, 4, 3
};


// Silent Debuggers

static struct BurnRomInfo tg_silentdRomDesc[] = {
	{ "silent debuggers (usa).pce", 0x080000, 0xfa7e5d66, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_silentd)
STD_ROM_FN(tg_silentd)

struct BurnDriver BurnDrvtg_silentd = {
	"tg_silentd", NULL, NULL, NULL, "1991",
	"Silent Debuggers\0", NULL, "Hudson Soft", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_silentdRomInfo, tg_silentdRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sinistron

static struct BurnRomInfo tg_sinistrnRomDesc[] = {
	{ "sinistron (usa).pce", 0x060000, 0x4f6e2dbd, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_sinistrn)
STD_ROM_FN(tg_sinistrn)

struct BurnDriver BurnDrvtg_sinistrn = {
	"tg_sinistrn", NULL, NULL, NULL, "1991",
	"Sinistron\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_sinistrnRomInfo, tg_sinistrnRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Soldier Blade

static struct BurnRomInfo tg_soldbladRomDesc[] = {
	{ "soldier blade (usa).pce", 0x080000, 0x4bb68b13, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_soldblad)
STD_ROM_FN(tg_soldblad)

struct BurnDriver BurnDrvtg_soldblad = {
	"tg_soldblad", NULL, NULL, NULL, "1992",
	"Soldier Blade\0", "Hangs at first boss", "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_soldbladRomInfo, tg_soldbladRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Somer Assault

static struct BurnRomInfo tg_somerassRomDesc[] = {
	{ "somer assault (usa).pce", 0x080000, 0x8fcaf2e9, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_somerass)
STD_ROM_FN(tg_somerass)

struct BurnDriver BurnDrvtg_somerass = {
	"tg_somerass", NULL, NULL, NULL, "1992",
	"Somer Assault\0", NULL, "Atlus", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_somerassRomInfo, tg_somerassRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Sonic Spike - World Championship Beach Volleyball

static struct BurnRomInfo tg_wbeachRomDesc[] = {
	{ "sonic spike - world championship beach volleyball (usa).pce", 0x040000, 0xf74e5eb3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_wbeach)
STD_ROM_FN(tg_wbeach)

struct BurnDriver BurnDrvtg_wbeach = {
	"tg_wbeach", NULL, NULL, NULL, "1990",
	"Sonic Spike - World Championship Beach Volleyball\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_wbeachRomInfo, tg_wbeachRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Space Harrier

static struct BurnRomInfo tg_sharrierRomDesc[] = {
	{ "space harrier (usa).pce", 0x080000, 0x43b05eb8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_sharrier)
STD_ROM_FN(tg_sharrier)

struct BurnDriver BurnDrvtg_sharrier = {
	"tg_sharrier", NULL, NULL, NULL, "1989",
	"Space Harrier\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_sharrierRomInfo, tg_sharrierRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Splatterhouse

static struct BurnRomInfo tg_splatthRomDesc[] = {
	{ "splatterhouse (usa).pce", 0x080000, 0xd00ca74f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_splatth)
STD_ROM_FN(tg_splatth)

struct BurnDriver BurnDrvtg_splatth = {
	"tg_splatth", NULL, NULL, NULL, "1990",
	"Splatterhouse\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_splatthRomInfo, tg_splatthRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Star Soldier

static struct BurnRomInfo tg_sssoldrRomDesc[] = {
	{ "super star soldier (usa).pce", 0x080000, 0xdb29486f, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_sssoldr)
STD_ROM_FN(tg_sssoldr)

struct BurnDriver BurnDrvtg_sssoldr = {
	"tg_sssoldr", NULL, NULL, NULL, "1990",
	"Super Star Soldier\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_sssoldrRomInfo, tg_sssoldrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Super Volleyball

static struct BurnRomInfo tg_svolleyRomDesc[] = {
	{ "super volleyball (usa).pce", 0x040000, 0x245040b3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_svolley)
STD_ROM_FN(tg_svolley)

struct BurnDriver BurnDrvtg_svolley = {
	"tg_svolley", NULL, NULL, NULL, "1990",
	"Super Volleyball\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_svolleyRomInfo, tg_svolleyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Taito Chase H.Q.

static struct BurnRomInfo tg_chasehqRomDesc[] = {
	{ "taito chase h.q. (usa).pce", 0x060000, 0x9298254c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_chasehq)
STD_ROM_FN(tg_chasehq)

struct BurnDriver BurnDrvtg_chasehq = {
	"tg_chasehq", NULL, NULL, NULL, "1992",
	"Taito Chase H.Q.\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_chasehqRomInfo, tg_chasehqRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Takin' It to the Hoop

static struct BurnRomInfo tg_taknhoopRomDesc[] = {
	{ "takin' it to the hoop (usa).pce", 0x040000, 0xe9d51797, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_taknhoop)
STD_ROM_FN(tg_taknhoop)

struct BurnDriver BurnDrvtg_taknhoop = {
	"tg_taknhoop", NULL, NULL, NULL, "1989",
	"Takin' It to the Hoop\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_taknhoopRomInfo, tg_taknhoopRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TaleSpin

static struct BurnRomInfo tg_talespinRomDesc[] = {
	{ "talespin (usa).pce", 0x080000, 0xbae9cecc, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_talespin)
STD_ROM_FN(tg_talespin)

struct BurnDriver BurnDrvtg_talespin = {
	"tg_talespin", NULL, NULL, NULL, "1991",
	"TaleSpin\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_talespinRomInfo, tg_talespinRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tiger Road

static struct BurnRomInfo tg_tigerrodRomDesc[] = {
	{ "tiger road (usa).pce", 0x060000, 0x985d492d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_tigerrod)
STD_ROM_FN(tg_tigerrod)

struct BurnDriver BurnDrvtg_tigerrod = {
	"tg_tigerrod", NULL, NULL, NULL, "1990",
	"Tiger Road\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_tigerrodRomInfo, tg_tigerrodRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Time Cruise

static struct BurnRomInfo tg_timcrusRomDesc[] = {
	{ "time cruise (usa).pce", 0x080000, 0x02c39660, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_timcrus)
STD_ROM_FN(tg_timcrus)

struct BurnDriver BurnDrvtg_timcrus = {
	"tg_timcrus", NULL, NULL, NULL, "1992",
	"Time Cruise\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_timcrusRomInfo, tg_timcrusRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Timeball

static struct BurnRomInfo tg_timeballRomDesc[] = {
	{ "timeball (usa).pce", 0x020000, 0x5d395019, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_timeball)
STD_ROM_FN(tg_timeball)

struct BurnDriver BurnDrvtg_timeball = {
	"tg_timeball", NULL, NULL, NULL, "1990",
	"Timeball\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_timeballRomInfo, tg_timeballRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Tricky Kick

static struct BurnRomInfo tg_trickyRomDesc[] = {
	{ "tricky kick (usa).pce", 0x040000, 0x48e6fd34, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_tricky)
STD_ROM_FN(tg_tricky)

struct BurnDriver BurnDrvtg_tricky = {
	"tg_tricky", NULL, NULL, NULL, "1990",
	"Tricky Kick\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_trickyRomInfo, tg_trickyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Turrican

static struct BurnRomInfo tg_turricanRomDesc[] = {
	{ "turrican (usa).pce", 0x040000, 0xeb045edf, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_turrican)
STD_ROM_FN(tg_turrican)

struct BurnDriver BurnDrvtg_turrican = {
	"tg_turrican", NULL, NULL, NULL, "1991",
	"Turrican\0", NULL, "Ballistic", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_turricanRomInfo, tg_turricanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TV Sports Basketball

static struct BurnRomInfo tg_tvbasketRomDesc[] = {
	{ "tv sports basketball (usa).pce", 0x080000, 0xea54d653, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_tvbasket)
STD_ROM_FN(tg_tvbasket)

struct BurnDriver BurnDrvtg_tvbasket = {
	"tg_tvbasket", NULL, NULL, NULL, "1991",
	"TV Sports Basketball\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_tvbasketRomInfo, tg_tvbasketRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TV Sports Football

static struct BurnRomInfo tg_tvfootblRomDesc[] = {
	{ "tv sports football (usa).pce", 0x060000, 0x5e25b557, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_tvfootbl)
STD_ROM_FN(tg_tvfootbl)

struct BurnDriver BurnDrvtg_tvfootbl = {
	"tg_tvfootbl", NULL, NULL, NULL, "1990",
	"TV Sports Football\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_tvfootblRomInfo, tg_tvfootblRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// TV Sports Hockey

static struct BurnRomInfo tg_tvhockeyRomDesc[] = {
	{ "tv sports hockey (usa).pce", 0x060000, 0x97fe5bcf, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_tvhockey)
STD_ROM_FN(tg_tvhockey)

struct BurnDriver BurnDrvtg_tvhockey = {
	"tg_tvhockey", NULL, NULL, NULL, "1991",
	"TV Sports Hockey\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_tvhockeyRomInfo, tg_tvhockeyRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Veigues - Tactical Gladiator

static struct BurnRomInfo tg_veiguesRomDesc[] = {
	{ "veigues - tactical gladiator (usa).pce", 0x060000, 0x99d14fb7, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_veigues)
STD_ROM_FN(tg_veigues)

struct BurnDriver BurnDrvtg_veigues = {
	"tg_veigues", NULL, NULL, NULL, "1990",
	"Veigues - Tactical Gladiator\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_veiguesRomInfo, tg_veiguesRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Victory Run

static struct BurnRomInfo tg_victoryrRomDesc[] = {
	{ "victory run (usa).pce", 0x040000, 0x85cbd045, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_victoryr)
STD_ROM_FN(tg_victoryr)

struct BurnDriver BurnDrvtg_victoryr = {
	"tg_victoryr", NULL, NULL, NULL, "1989",
	"Victory Run\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_victoryrRomInfo, tg_victoryrRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Vigilante

static struct BurnRomInfo tg_vigilantRomDesc[] = {
	{ "vigilante (usa).pce", 0x060000, 0x79d49a0d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_vigilant)
STD_ROM_FN(tg_vigilant)

struct BurnDriver BurnDrvtg_vigilant = {
	"tg_vigilant", NULL, NULL, NULL, "1989",
	"Vigilante\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_vigilantRomInfo, tg_vigilantRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// World Class Baseball

static struct BurnRomInfo tg_wcbaseblRomDesc[] = {
	{ "world class baseball (usa).pce", 0x040000, 0x4186d0c0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_wcbasebl)
STD_ROM_FN(tg_wcbasebl)

struct BurnDriver BurnDrvtg_wcbasebl = {
	"tg_wcbasebl", NULL, NULL, NULL, "1989",
	"World Class Baseball\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_wcbaseblRomInfo, tg_wcbaseblRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// World Court Tennis

static struct BurnRomInfo tg_wctennisRomDesc[] = {
	{ "world court tennis (usa).pce", 0x040000, 0xa4457df0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_wctennis)
STD_ROM_FN(tg_wctennis)

struct BurnDriver BurnDrvtg_wctennis = {
	"tg_wctennis", NULL, NULL, NULL, "1989",
	"World Court Tennis\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_wctennisRomInfo, tg_wctennisRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// World Sports Competition

static struct BurnRomInfo tg_wscompRomDesc[] = {
	{ "world sports competition (usa).pce", 0x080000, 0x4b93f0ac, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_wscomp)
STD_ROM_FN(tg_wscomp)

struct BurnDriver BurnDrvtg_wscomp = {
	"tg_wscomp", NULL, NULL, NULL, "1992",
	"World Sports Competition\0", NULL, "TTI", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_wscompRomInfo, tg_wscompRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Yo, Bro

static struct BurnRomInfo tg_yobroRomDesc[] = {
	{ "yo, bro (usa).pce", 0x080000, 0x3ca7db48, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_yobro)
STD_ROM_FN(tg_yobro)

struct BurnDriver BurnDrvtg_yobro = {
	"tg_yobro", NULL, NULL, NULL, "1991",
	"Yo, Bro\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_yobroRomInfo, tg_yobroRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Turbografx CD Super System Card (v3.0)

static struct BurnRomInfo tg_scdsysRomDesc[] = {
	{ "[cd] turbografx cd super system card (usa) (v3.0).pce", 0x040000, 0x2b5b75fe, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_scdsys)
STD_ROM_FN(tg_scdsys)

struct BurnDriverD BurnDrvtg_scdsys = {
	"tg_scdsys", NULL, NULL, NULL, "19??",
	"Turbografx CD Super System Card (v3.0)\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_scdsysRomInfo, tg_scdsysRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Turbografx CD System Card (v2.0)

static struct BurnRomInfo tg_cdsysRomDesc[] = {
	{ "[cd] turbografx cd system card (usa) (v2.0).pce", 0x040000, 0xff2a5ec3, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(tg_cdsys)
STD_ROM_FN(tg_cdsys)

struct BurnDriverD BurnDrvtg_cdsys = {
	"tg_cdsys", NULL, NULL, NULL, "19??",
	"Turbografx CD System Card (v2.0)\0", NULL, "NEC", "TurboGrafx 16",
	NULL, NULL, NULL, NULL,
	0, 5, HARDWARE_PCENGINE_TG16, GBF_MISC, 0,
	TgGetZipName, tg_cdsysRomInfo, tg_cdsysRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	TG16Init, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// 1941 - Counter Attack

static struct BurnRomInfo sgx_1941RomDesc[] = {
	{ "1941 - counter attack (japan).pce", 0x100000, 0x8c4588e2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_1941)
STD_ROM_FN(sgx_1941)

struct BurnDriver BurnDrvsgx_1941 = {
	"sgx_1941", NULL, NULL, NULL, "1991",
	"1941 - Counter Attack\0", NULL, "Hudson", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_MISC, 0,
	SgxGetZipName, sgx_1941RomInfo, sgx_1941RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Aldynes

static struct BurnRomInfo sgx_aldynesRomDesc[] = {
	{ "aldynes (japan).pce", 0x100000, 0x4c2126b0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_aldynes)
STD_ROM_FN(sgx_aldynes)

struct BurnDriver BurnDrvsgx_aldynes = {
	"sgx_aldynes", NULL, NULL, NULL, "1991",
	"Aldynes\0", NULL, "Hudson", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_MISC, 0,
	SgxGetZipName, sgx_aldynesRomInfo, sgx_aldynesRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Battle Ace

static struct BurnRomInfo sgx_battlaceRomDesc[] = {
	{ "battle ace (japan).pce", 0x080000, 0x3b13af61, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_battlace)
STD_ROM_FN(sgx_battlace)

struct BurnDriver BurnDrvsgx_battlace = {
	"sgx_battlace", NULL, NULL, NULL, "1989",
	"Battle Ace\0", NULL, "Hudson", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_MISC, 0,
	SgxGetZipName, sgx_battlaceRomInfo, sgx_battlaceRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Dai Makaimura

static struct BurnRomInfo sgx_daimakaiRomDesc[] = {
	{ "daimakai mura (japan).pce", 0x100000, 0xb486a8ed, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_daimakai)
STD_ROM_FN(sgx_daimakai)

struct BurnDriver BurnDrvsgx_daimakai = {
	"sgx_daimakai", NULL, NULL, NULL, "1990",
	"Dai Makaimura\0", NULL, "NEC Avenue", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_RUNGUN, 0,
	SgxGetZipName, sgx_daimakaiRomInfo, sgx_daimakaiRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Dai Makaimura (Alt)

static struct BurnRomInfo sgx_daimakai1RomDesc[] = {
	{ "daimakai mura (japan)[a].pce", 0x100200, 0x8e961f63, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_daimakai1)
STD_ROM_FN(sgx_daimakai1)

struct BurnDriver BurnDrvsgx_daimakai1 = {
	"sgx_daimakai1", "sgx_daimakai", NULL, NULL, "1990",
	"Dai Makaimura (Alt)\0", NULL, "NEC Avenue", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_SGX, GBF_RUNGUN, 0,
	SgxGetZipName, sgx_daimakai1RomInfo, sgx_daimakai1RomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Dai Makaimura (Chris Covell's Debug Menu Hack)

static struct BurnRomInfo sgx_daimakaidRomDesc[] = {
	{ "daimakai mura (japan)[debug].pce", 0x100000, 0xd6722c04, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_daimakaid)
STD_ROM_FN(sgx_daimakaid)

struct BurnDriver BurnDrvsgx_daimakaid = {
	"sgx_daimakaid", "sgx_daimakai", NULL, NULL, "1990",
	"Dai Makaimura (Chris Covell's Debug Menu Hack)\0", NULL, "NEC Avenue", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 5, HARDWARE_PCENGINE_SGX, GBF_RUNGUN, 0,
	SgxGetZipName, sgx_daimakaidRomInfo, sgx_daimakaidRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Madou Ou Granzort

static struct BurnRomInfo sgx_granzortRomDesc[] = {
	{ "madou ou granzort (japan).pce", 0x080000, 0x1f041166, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(sgx_granzort)
STD_ROM_FN(sgx_granzort)

struct BurnDriver BurnDrvsgx_granzort = {
	"sgx_granzort", NULL, NULL, NULL, "1990",
	"Madou Ou Granzort\0", NULL, "Hudson", "SuperGrafx",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_SGX, GBF_MISC, 0,
	SgxGetZipName, sgx_granzortRomInfo, sgx_granzortRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	SGXInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Aetherbyte Reflectron

static struct BurnRomInfo pce_reflectronRomDesc[] = {
	{ "reflectron.pce", 0x040000, 0x6a3727e2, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_reflectron)
STD_ROM_FN(pce_reflectron)

struct BurnDriver BurnDrvpce_reflectron = {
	"pce_reflectron", NULL, NULL, NULL, "2013",
	"Reflectron\0", NULL, "Aetherbyte", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_reflectronRomInfo, pce_reflectronRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Aetherbyte Santatlantean

static struct BurnRomInfo pce_santatlanteanRomDesc[] = {
	{ "Santatlantean.pce", 0x080200, 0xe6b38af1, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_santatlantean)
STD_ROM_FN(pce_santatlantean)

struct BurnDriver BurnDrvpce_santatlantean = {
	"pce_santatlantean", NULL, NULL, NULL, "2014",
	"Santatlantean\0", NULL, "Aetherbyte", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_santatlanteanRomInfo, pce_santatlanteanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Contra (NES Mod Version 3.0)

static struct BurnRomInfo pce_contranesRomDesc[] = {
	{ "Contra.pce", 0x80000, 0xAAF5AEB4, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_contranes)
STD_ROM_FN(pce_contranes)

struct BurnDriver BurnDrvpce_contranes = {
	"pce_contranes", NULL, NULL, NULL, "1988",
	"Contra (NES Mod Version 3.0)\0", NULL, "Konami", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_contranesRomInfo, pce_contranesRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// PC-Engine CPU Timing Test by Chris Covell (http://www.chrismcovell.com/CPUTest/)

static struct BurnRomInfo pce_cputestRomDesc[] = {
	{ "CPU_Test_10.pce", 0x8000, 0x46D79BBE, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cputest)
STD_ROM_FN(pce_cputest)

struct BurnDriverD BurnDrvpce_cputest = {
	"pce_cputest", NULL, NULL, NULL, "2019",
	"PC-Engine CPU Timing Test by Chris Covell\0", NULL, "Homebrew", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_cputestRomInfo, pce_cputestRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Atlantean

static struct BurnRomInfo pce_atlanteanRomDesc[] = {
	{ "atlantean.pce", 0x080200, 0xef596649, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_atlantean)
STD_ROM_FN(pce_atlantean)

struct BurnDriver BurnDrvpce_atlantean = {
	"pce_atlantean", NULL, NULL, NULL, "2014",
	"Atlantean\0", NULL, "Aetherbyte", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 1, HARDWARE_PCENGINE_PCENGINE, GBF_HORSHOOT, 0,
	PceGetZipName, pce_atlanteanRomInfo, pce_atlanteanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// City Hunter (Hack, English)
// https://www.romhacking.net/translations/4517/
static struct BurnRomInfo pce_cityhunteRomDesc[] = {
	{ "city hunter (english translation).pce", 0x060200, 0xdb435a9d, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_cityhunte)
STD_ROM_FN(pce_cityhunte)

struct BurnDriver BurnDrvpce_cityhunte = {
	"pce_cityhunte", "pce_cityhunt", NULL, NULL, "2019",
	"City Hunter (Hack, English)\0", NULL, "Sunsoft", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 1, HARDWARE_PCENGINE_PCENGINE, GBF_RUNGUN | GBF_PLATFORM, 0,
	PceGetZipName, pce_cityhunteRomInfo, pce_cityhunteRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};


// Maison Ikkoku (Hack, English)
// https://www.romhacking.net/translations/724/
static struct BurnRomInfo pce_mikkokueRomDesc[] = {
	{ "maison ikkoku (english translation).pce", 0x080200, 0xb5ed56d8, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_mikkokue)
STD_ROM_FN(pce_mikkokue)

struct BurnDriver BurnDrvpce_mikkokue = {
	"pce_mikkokue", "pce_mikkoku", NULL, NULL, "2008",
	"Maison Ikkoku (Hack, English)\0", NULL, "Micro Cabin", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE, 1, HARDWARE_PCENGINE_PCENGINE, GBF_RPG, 0,
	PceGetZipName, pce_mikkokueRomInfo, pce_mikkokueRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Nantettatte Engine

static struct BurnRomInfo pce_nantetRomDesc[] = {
	{ "Nantettatte Engine.pce", 0x040000, 0x3974fb41, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_nantet)
STD_ROM_FN(pce_nantet)

struct BurnDriver BurnDrvpce_nantet = {
	"pce_nantet", NULL, NULL, NULL, "2017",
	"Nantettatte Engine\0", NULL, "Atherbyte", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_nantetRomInfo, pce_nantetRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Tongueman's Logic

static struct BurnRomInfo pce_tonguemanRomDesc[] = {
	{ "Tongueman's Logic (FINAL 1.0).pce", 0x080000, 0xfe451c22, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_tongueman)
STD_ROM_FN(pce_tongueman)

struct BurnDriver BurnDrvpce_tongueman = {
	"pce_tongueman", NULL, NULL, NULL, "2007",
	"Tongueman's Logic\0", NULL, "Chris Covell", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_tonguemanRomInfo, pce_tonguemanRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// HuZERO

static struct BurnRomInfo pce_huzeroRomDesc[] = {
	{ "HuZERO_by_Chris_Covell.pce", 0x040000, 0x2871c4c0, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_huzero)
STD_ROM_FN(pce_huzero)

struct BurnDriver BurnDrvpce_huzero = {
	"pce_huzero", NULL, NULL, NULL, "2014",
	"HuZERO\0", NULL, "Chris Covell", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_huzeroRomInfo, pce_huzeroRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};

// Off the Wall (Prototype)

static struct BurnRomInfo pce_offthewallRomDesc[] = {
	{ "Off the Wall [Proto 1].pce", 0x080200, 0x40f04a7c, BRF_PRG | BRF_ESS },
};

STD_ROM_PICK(pce_offthewall)
STD_ROM_FN(pce_offthewall)

struct BurnDriver BurnDrvpce_offthewall = {
	"pce_offthewall", NULL, NULL, NULL, "1992",
	"Off the Wall (Prototype)\0", NULL, "Tengen/Atari", "PC Engine",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 5, HARDWARE_PCENGINE_PCENGINE, GBF_MISC, 0,
	PceGetZipName, pce_offthewallRomInfo, pce_offthewallRomName, NULL, NULL, NULL, NULL, pceInputInfo, pceDIPInfo,
	PCEInit, PCEExit, PCEFrame, PCEDraw, PCEScan,
	&PCEPaletteRecalc, 0x400, 512, 240, 4, 3
};
