static char colors_rcsid[]="colors.c,v 1.2 1994/11/28 16:54:42 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  colors.c,v
 * Revision 1.2  1994/11/28  16:54:42  kerce
 * *** empty log message ***
 *
 * Revision 1.2  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 **********************************************************/

#include "globals.h"

extern Widget toplevel;

typedef struct _colortype {
  int num_colors;
  struct _color_list {
    char *name;
    int pixel;
  }color_list[MAX_COLORS];
}COLORTYPE;

static char            runningcolor[64];
static char            idlecolor[64];
static char            suspendedcolor[64];
static char            suscompcolor[64];
static char            alarmcolor[64];
static int             max_hierarchy_colors;
static Colormap        colormap;
static COLORTYPE       colortype;

static XColor          ecol,ccol;

/***********************************************************
 * initcolors - Gets colormap and all known colors for the
 *              server
 */
void initcolors()
{

  runningcolor[0]  =0;
  idlecolor[0]     =0;
  suspendedcolor[0]=0;
  suscompcolor[0]  =0;
  alarmcolor[0]    =0;

  /*
   * Check the $HOME/.Xdefaults for the default colors for
   * the state of the queues
   */
    if(XGetDefault(XtDisplay(toplevel),"qmon","running"))
      sprintf(runningcolor,  "%s",XGetDefault(XtDisplay(toplevel),"qmon","running"));
    if(XGetDefault(XtDisplay(toplevel),"qmon","idle"))
      sprintf(idlecolor,     "%s",XGetDefault(XtDisplay(toplevel),"qmon","idle"));
    if(XGetDefault(XtDisplay(toplevel),"qmon","suspended"))
      sprintf(suspendedcolor,"%s",XGetDefault(XtDisplay(toplevel),"qmon","suspended"));
    if(XGetDefault(XtDisplay(toplevel),"qmon","suscomp"))
      sprintf(suscompcolor,  "%s",XGetDefault(XtDisplay(toplevel),"qmon","suscomp"));
    if(XGetDefault(XtDisplay(toplevel),"qmon","alarm"))
      sprintf(alarmcolor,    "%s",XGetDefault(XtDisplay(toplevel),"qmon","alarm"));

  /*
   * If they weren't in the $HOME/.Xdefaults then use our colors
   */
    if(!strlen(runningcolor))
      sprintf(runningcolor,"%s",DEFAULTRUNNINGCOLOR);
    if(!strlen(idlecolor))
      sprintf(idlecolor,"%s",DEFAULTIDLECOLOR);
    if(!strlen(suspendedcolor))
      sprintf(suspendedcolor,"%s",DEFAULTSUSPENDEDCOLOR);
    if(!strlen(suscompcolor))
      sprintf(suscompcolor,"%s",DEFAULTSUSCOMPCOLOR);
    if(!strlen(alarmcolor))
      sprintf(alarmcolor,"%s",DEFAULTALARMCOLOR);

  colormap=DefaultColormap(XtDisplay(toplevel),getscr());
}


/***********************************************************
 * getpixelval - Returns the pixel value for colorname
 */
Pixel getpixelval(char *colorname)
{
  int             ii;

  for(ii=0;ii<colortype.num_colors;ii++) {
    if(!strcasecmp(colorname,colortype.color_list[ii].name))
      return colortype.color_list[ii].pixel;
  }
  if(XAllocNamedColor(XtDisplay(toplevel),colormap,colorname,&ecol,&ccol)) {
    colortype.color_list[ii].name=(char *)malloc(strlen(colorname)+1);
    sprintf(colortype.color_list[ii].name,"%s",colorname);
    colortype.color_list[ii].pixel=ecol.pixel;
    colortype.num_colors++;
    return ecol.pixel;
  }
  fprintf(stderr,"%s color not found\n",colorname);
  return(0);
}


/***********************************************************
 * getrunningcolor - Returns string name of the color that
 *                   that represents a running queue
 */
char *getrunningcolor()
{
  return runningcolor;
}


/***********************************************************
 * getidlecolor - Returns string name of the color that
 *                that represents an idle queue
 */
char *getidlecolor()
{
  return idlecolor;
}


/***********************************************************
 * getsuspendedcolor - Returns string name of the color that
 *                     that represents a suspended queue
 */
char *getsuspendedcolor()
{
  return suspendedcolor;
}


/***********************************************************
 * getsuscompcolor - Returns string name of the color that
 *                   that represents a queue with an suscomp
 *                   status
 */
char *getsuscompcolor()
{
  return suscompcolor;
}


/***********************************************************
 * getalarmcolor - Returns string name of the color that
 *                 that represents an alarm
 */
char *getalarmcolor()
{
  return alarmcolor;
}


/***********************************************************
 * defaultforeground - Returns foreground color of a widget
 */
Pixel defaultforeground(Widget w)
{
  Arg       args[1];
  int       ii;
  Pixel     fg;

  ii=0;
  XtSetArg(args[ii],XtNforeground,&fg); ii++;
  XtGetValues(w,args,ii);
  return fg;
}


/***********************************************************
 * defaultbackground - Returns background color of a widget
 */
Pixel defaultbackground(Widget w)
{
  Arg       args[1];
  int       ii;
  Pixel     bg;

  ii=0;
  XtSetArg(args[ii],XtNbackground,&bg); ii++;
  XtGetValues(w,args,ii);
  return bg;
}


