static char dqs_c_qconf_rcsid[]="$Id: dqs_c_qconf.c,v 1.3 1999/07/21 19:44:20 green Exp $";

/*----------------------------------------------------
 * dqs_c_qconf.c Tom Green Mon Jan 31 10:42:37 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_c_qconf.c,v $
 * Revision 1.3  1999/07/21 19:44:20  green
 * clear the HANDOFF_ERROR bit with the "-cq" option
 *
 * Revision 1.2  1998/10/14 18:13:55  kerce
 * In the qmon_OPT handler of dqs_c_qconf(), test for the ALARM state in
 * the same way it is handled in qstat.c.  Patch contributed by Russell
 * Schwausch of Intel.
 *
 * Revision 1.1.1.1  1998/08/18 14:39:10  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:31  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.24  1996/11/20 23:03:16  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.23  1996/06/27  01:55:42  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.22  1996/04/12  13:56:32  nrl
 * Fixed type for Dprint in dc_OPT found by Ron lee
 *
 * Revision 3.21  1996/03/22  04:19:55  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.20  1996/03/19  23:27:12  nrl
 * added capability to clean up consumable resources whenthey
 * get out of sync with reality
 *
 * Revision 3.19  1996/03/14  03:16:07  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.18  1996/02/19  19:02:00  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.17  1996/02/07  13:07:46  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.16  1995/09/29  19:23:33  nrl
 * cleared the "sorted" flag anytime a queue is added, deleted or modified.
 *
 * Revision 3.15  1995/03/05  03:47:08  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.14  1995/02/24  23:36:14  nrl
 * Changed all Host lookups to use dqs_locate_host subroutine,
 * and changed that routine to look for the "registered host name"
 *
 * Revision 3.13  1995/02/09  22:44:09  nrl
 * Added "-mq" modify queue option
 *
 * Revision 3.12  1995/02/09  12:49:07  nrl
 * Added "delete complex" and "modify complex"
 *
 * Revision 3.11  1994/11/14  13:57:32  green
 * deleting a user from an ACL printed out that it was adding the user -
 * fixed
 *
 * Revision 3.10  1994/06/15  15:29:00  green
 * support for using DQS trusted host list for dshd
 *
 * 	passing of Host_head -n dqs_c_dqs_execd.c
 * 	time stamp Host_head on deletion in dqs_c_qconf.c
 * 	ck trusted host list in dqs_dshd.c
 * 	grab Host_head at startup in dqs_execd.c
 * 	rebuild Host_head/Host_hash in dqs_execd_rebuild_host_hash.c
 * 	dqs_free_hash in dqs_hash.c
 * 	grab new Host_head in dqs_load_avg.c
 * 	error log/printing in dsh.c
 *
 * Bug in my syslog code(or certain vendors required nullifying use
 * of syslogd until I can track it down...
 *
 * Revision 3.9  1994/06/12  17:21:01  green
 * added some additional sanity checking on cq_OPT
 *
 * Revision 3.8  1994/06/12  16:52:36  green
 * "qconf -cq" now unlinks offending jobs and syncs disk state
 *
 * Revision 3.7  1994/06/04  17:45:06  green
 * fixed bug in "qconf -dh host_list"
 *
 * added additional error logging
 *
 * Revision 3.6  1994/03/26  22:22:53  green
 * yanked "qty.eq.??" out of dqs_job_exit.c:dqs_build_complex_str()
 *
 * modified dqs_c_qconf.c:dqs_c_qconf() to show "none" on NULL complex
 * strings passed in on qmon_OPT
 *
 * Revision 3.5  1994/03/26  15:29:15  green
 * allowed for "qconf -sq [dest_id_list]" vs "qconf -sq dest_id_list"
 *
 * write generic queue configuration in common_dir
 *
 * Revision 3.4  1994/03/26  14:01:38  green
 * added additional logging
 *
 * Revision 3.3  1994/03/24  16:00:02  green
 * wasn't checking for NULL complexes in dqs_c_qconf.c:dqs_c_qmon() -
 * causing core dumps if no complexes were defined.
 *
 * Revision 3.2  1994/03/17  21:23:02  green
 * added a "complex" field to "qconf -qmon"
 *
 * removed the "UNKNOWN group" warning from dqs_utility.c as it was
 * causing confusion and was only a trivial warning anyway...
 *
 * Revision 3.1  1994/03/17  15:40:04  green
 * added support for "qconf -qmon"
 *
 * Revision 3.0  1994/03/07  04:13:20  green
 * 3.0 freeze
 *
 * Revision 1.5  1994/02/28  15:57:25  green
 * forgot to check credentials on some "qconf" options - fixed
 *
 * had hard coded "ibm11.scri.fsu.edu" and "localhost" into dqs_setup.c - removed
 *
 * Revision 1.4  1994/02/28  13:47:44  green
 * fixed incoorect addressing of request_list->who in dqs_c_qconf.c
 * should have been request_list->user
 *
 * enabled comments in "resolve_file"
 *
 * dqs_execd now uses me.default_cell rather than conf.default_cell
 * to allow use of "dqs_execd -cell cell_name" and $DQS_CELL
 *
 * Revision 1.3  1994/02/09  19:48:00  green
 * syncing source with docs
 *
 * Revision 1.2  1994/02/02  20:22:07  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:37  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
void dqs_c_qconf(sfd,request_head)
     int           sfd;
     dqs_list_type **request_head;
     
     /* 
	dqs_c_qconf is used solely by the qmaster and provides services
	provides services to requests forwarded by the qconf ancillary.
     */
     
{
  
  int                status;
  int                i;
  int                free_queue_ptr=FALSE;
  char               *cp;
  string             str;
  dqs_hash_type      *hashel_ptr;
  dqs_list_type      *lp;
  dqs_list_type      *listel_ptr;
  dqs_list_type      listel;
  dqs_list_type      listel2;
  dqs_list_type      *request_list;
  dqs_list_type      *reply_head=NULL;
  dqs_queue_type     *queue_ptr;
  dqs_list_type      *complex_ptr;
  dqs_list_type	*consumable_ptr;
  dqs_job_type       *deleted_job;
  struct hostent *hp;
  
  struct sockaddr_in cli_addr;
  
  DENTER((DQS_EVENT,"dqs_c_qconf"));
  
  reply_head=NULL;
  request_list= *request_head;
  
  DTRACE;
  
  while (request_list)
    {
      DPRINTF((DQS_EVENT,"------------------------------------------------------"));
      bzero((char *)&listel,sizeof(listel));
      switch(request_list->int0) 
	{
	  /*------------------------------------------------------*/
	case ac_OPT:
	  DPRINTF((DQS_EVENT,"===>ac_OPT: adding complex >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s adding a complex requires manager privileges",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0041 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=dqs_string_insert(NULL,request_list->str0);
	  listel.chain=request_list->chain;
	  request_list->chain=NULL;
	  status=dqs_add_complex(&listel);
	  dqs_show_complex_list(&listel);
	  if (status<0)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s the complex \"%s\" already exists",
		      (*request_head)->user,request_list->str0);
	      WARNING((DQS_EVENT,"DQS_ERROR_0042 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  sprintf(str,"the complex \"%s\" has been added by %s",listel.str0,
		  (*request_head)->user);
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0043 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case acons_OPT:
	  DPRINTF((DQS_EVENT,"===>ac_OPT: adding consumable >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user)){
	    listel.status=DQS_NAK;
	    sprintf(str,"error: %s adding a consumable requires manager privileges",
		    (*request_head)->user);
	    WARNING((DQS_EVENT,"DQS_ERROR_0044 %s",str));
	    listel.str0=dqs_string_insert(NULL,str);
	    reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	    request_list=request_list->next;
	    bzero((char *)&listel,sizeof(listel));
	    continue;
	  }
	  listel.str0=dqs_string_insert(NULL,request_list->str0);
	  listel.chain=request_list->chain;
	  request_list->chain=NULL;
	  status=dqs_add_consumable(&listel);
	  dqs_show_consumable_list(&listel);
	  if (status<0)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s the consumable \"%s\" already exists",
		      (*request_head)->user,request_list->str0);
	      WARNING((DQS_EVENT,"DQS_ERROR_0045 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  sprintf(str,"the consumable \"%s\" has been added by %s",listel.str0,
		  (*request_head)->user);
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0046 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case ah_OPT:
	  DPRINTF((DQS_EVENT,"===>ah_OPT: adding host %s",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s adding a host requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0047 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  status=dqs_add_host(request_list->str0);
	  if (status<0)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s the host \"%s\" already exists",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0048 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  if (status>0)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s invalid host name \"%s\"",(*request_head)->user,
		      request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0049 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=request_list->str0;
	  request_list->str0=NULL;
	  sprintf(str,"the host \"%s\" has been added by %s",listel.str0,
		  (*request_head)->user);
	  dqs_write_list_to_disk(NULL,HOST_FILE,Host_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0050 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case am_OPT:
	  DPRINTF((DQS_EVENT,"===>am_OPT: adding manager %s",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s adding a manager requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0051 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_locate_manager(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s \"%s\" is already a manager",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0052 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  if (!getpwnam(request_list->str0)) 
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s invalid username \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0053 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=request_list->str0;
	  request_list->str0=NULL;
	  sprintf(str,"the manager \"%s\" has been added by %s",listel.str0,
		  (*request_head)->user);
	  dqs_hash_add(listel.str0,Man_hash);
	  Man_head=dqs_insert(DQS_STR0,ASCENDING,Man_head,&listel);
	  dqs_write_list_to_disk(NULL,MAN_FILE,Man_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0054 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case ao_OPT:
	  DPRINTF((DQS_EVENT,"===>ao_OPT: adding operator \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s adding an operator requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0055 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_locate_operator(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s -  \"%s\" is already an operator",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0056 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  if (!getpwnam(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s invalid username \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0057 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=request_list->str0;
	  request_list->str0=NULL;
	  sprintf(str,"the operator \"%s\" has been added by %s",
		  listel.str0,(*request_head)->user);
	  dqs_hash_add(listel.str0,Op_hash);
	  Op_head=dqs_insert(DQS_STR0,ASCENDING,Op_head,&listel);
	  dqs_write_list_to_disk(NULL,OP_FILE,Op_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0058 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case aq_OPT:
	  DPRINTF((DQS_EVENT,"===>aq_OPT: adding queue >%s<",request_list->queue->qname));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s adding a queue requires manager privileges",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0059 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  request_list->queue->state=(UNKNOWN|DISABLED|RUNNING);
	  status=dqs_add_queue(request_list->queue);
	  bzero((char *)&listel,sizeof(listel));
	  if (status<0)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s the queue \"%s\" already exists",
		      (*request_head)->user,request_list->queue->qname);
	      WARNING((DQS_EVENT,"DQS_ERROR_0060 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	    }
	  else if (status>0)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s invalid hostname associated with queue",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0061 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	    }
	  else
	    {
	      listel.status=DQS_ACK;
	      sprintf(str,"the queue \"%s\" has been added by %s and set to DISABLED",
		      request_list->queue->qname,(*request_head)->user);
	      INFO((DQS_EVENT,"DQS_ERROR_0062 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      request_list->queue=NULL;
	    }
	  
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  dqs_update_queue_state();
	  sorted= FALSE;
	  continue;
	  
	  /*------------------------------------------------------*/
	case au_OPT:
	  DPRINTF((DQS_EVENT,"===>au_OPT: adding acl \"%s - %s %s\"",
		   request_list->str0,request_list->str1,request_list->str2));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_operator((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s adding an acl requires operator privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0063 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_locate_acl(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s \"%s\" is already in list \"%s\"",
		      (*request_head)->user,request_list->str1,request_list->str2);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0064 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  if (!getpwnam(request_list->str1))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s invalid username \"%s\"",
		      (*request_head)->user,request_list->str1);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0065 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=request_list->str0;
	  request_list->str0=NULL;
	  listel.str1=request_list->str1;
	  request_list->str1=NULL;
	  listel.str2=request_list->str2;
	  request_list->str2=NULL;
	  sprintf(str,"the user \"%s\" has been added to acl list \"%s\" by %s",
		  listel.str1,listel.str2,(*request_head)->user);
	  dqs_hash_add(listel.str0,Acl_hash);
	  Acl_head=dqs_insert(DQS_STR0,ASCENDING,Acl_head,&listel);
	  dqs_write_list_to_disk(NULL,ACL_FILE,Acl_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0066 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case cq_OPT:
	  DPRINTF((DQS_EVENT,"===>cq_OPT: cleaning queue >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s - cleaning a queue requires manager privileges",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0067 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.status=DQS_ACK;
	  queue_ptr=dqs_locate_queue(request_list->str0);
	  if (!queue_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the queue \"%s\"",
		      (*request_head)->user,request_list->str0);
	      WARNING((DQS_EVENT,"DQS_ERROR_0068 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	    }
	  else
	    {
	      CLEARBIT(SUBORDINATED,queue_ptr->state);
	      CLEARBIT(HANDOFF_ERROR,queue_ptr->state);
	      listel.status=DQS_ACK;
	      sprintf(str,"error: %s cleaned the queue \"%s\"",
		      (*request_head)->user,request_list->str0);
	      ERROR((DQS_EVENT,"DQS_ERROR_0069 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      queue_ptr->qty_active=0;
	      lp=queue_ptr->job_list;
	      while (lp)
		{
		  sprintf(str,"%s/%d",JOB_DIR,lp->int0);
		  ERROR((DQS_EVENT,"DQS_ERROR_0070 \tunlinking \"%s\"",str));
		  if (str[0])
		    unlink(str);
		  deleted_job= dqs_locate_job(lp->str0);
		  if(deleted_job){
		    dqs_hash_del(lp->str0,Job_hash);
		    Job_head=dqs_del_str0(Job_head,lp->str0);
		  }
		  lp=lp->next;
		}
	      queue_ptr->job_list=dqs_free_list(queue_ptr->job_list);
	      dqs_write_queue_to_disk(queue_ptr);
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case dc_OPT:
	  DPRINTF((DQS_EVENT,"===>dc_OPT: deleting complex \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting a complex requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0071 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  DTRACE
	    bzero((char *)&listel,sizeof(listel));
	  complex_ptr=dqs_locate_complex(request_list->str0);
	  if (!complex_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the complex \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0072 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  dqs_hash_del(request_list->str0,Complex_hash);
          Complex_head=dqs_del_str0(Complex_head,request_list->str0);
          if (me.who==QMASTER)
	    dqs_write_list_to_disk(NULL,COMPLEX_FILE,Complex_head,ALL);
	  
	  sprintf(str,"The complex \"%s\" has been deleted",request_list->str0);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0073 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  /*------------------------------------------------------*/
	case dcons_OPT:
	  DPRINTF((DQS_EVENT,"===>dq_OPT: deleting consumable \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting a consumable requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0074 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  DTRACE
	    bzero((char *)&listel,sizeof(listel));
	  consumable_ptr=dqs_locate_consumable(request_list->str0);
	  if (!consumable_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the consumable \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0075 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  dqs_hash_del(request_list->str0,Consumable_hash);
	  Consumable_head=dqs_del_str0(Consumable_head,request_list->str0);
	  if (me.who==QMASTER)
	    dqs_write_list_to_disk(NULL,CONSUMABLE_FILE,Consumable_head,ALL);
	  
	  sprintf(str,"The consumable \"%s\" has been deleted",request_list->str0);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0076 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  /*------------------------------------------------------*/
	  
	case dh_OPT:
	  DPRINTF((DQS_EVENT,"===>dh_OPT: deleting host \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting a host requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0077 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  bzero((char *)&listel,sizeof(listel));
	  hp=gethostbyname(request_list->str0);
	  
	  if (!hp)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s invalid host name \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0078 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  if (!dqs_locate_host(hp->h_name))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the host \"%s\"",
		      (*request_head)->user,hp->h_name);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0079 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  if (!dqs_strcasecmp(hp->h_name,me.qualified_hostname))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot delete the qmaster host name \"%s\"",
		      (*request_head)->user,hp->h_name);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0080 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  listel_ptr=Queue_head;
	  while (listel_ptr)
	    {
	      if (!dqs_strcasecmp(request_list->str0,listel_ptr->queue->qhostname))
		{
		  listel.status=DQS_NAK;
		  sprintf(str,"error: %s warning the host \"%s\" - has an active queue \"%s\"",
			  (*request_head)->user,request_list->str0,listel_ptr->queue->qhostname);
		  listel.str0=dqs_string_insert(NULL,str);
		  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
		  /*			 request_list=request_list->next; */
		  WARNING((DQS_EVENT,"DQS_ERROR_0081 %s",str));
		  bzero((char *)&listel,sizeof(listel));
		  /*			 continue; */
		}
	      listel_ptr=listel_ptr->next;
	    }
	  sprintf(str,"the host \"%s\" has been deleted by %s",
		  request_list->str0,(*request_head)->user);
	  
	  
	  dqs_hash_del(hp->h_name,Host_hash);
	  
	  if (hp->h_aliases)
	    for(i=0;hp->h_aliases[i];i++)
	      {
		INFO((DQS_EVENT,"DQS_ERROR_0082 deleting \"%s\"  Host_has as an alias for \"%s\"",
		      hp->h_aliases[i],request_list->str0));
		dqs_hash_del(hp->h_aliases[i],Host_hash);
	      }
	  
	  Host_head=dqs_del_str0(Host_head,request_list->str0);
	  if (Host_head)
	    Host_head->int0=dqs_get_gmt();
	  dqs_write_list_to_disk(NULL,HOST_FILE,Host_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0083 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case dm_OPT:
	  DPRINTF((DQS_EVENT,"===>dm_OPT: deleting manager \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting a manager requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0084 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the manager \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0085 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  sprintf(str,"the manager \"%s\" has been deleted by %s",
		  request_list->str0,(*request_head)->user);
	  dqs_hash_del(request_list->str0,Man_hash); 
	  Man_head=dqs_del_str0(Man_head,request_list->str0);
	  dqs_write_list_to_disk(NULL,MAN_FILE,Man_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0086 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case do_OPT:
	  DPRINTF((DQS_EVENT,"===>do_OPT: deleting operator \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting an operator requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0087 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_operator(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the operator \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0088 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  sprintf(str,"the operator \"%s\" has been deleted by %s",
		  request_list->str0,(*request_head)->user);
	  dqs_hash_del(request_list->str0,Op_hash);
	  Op_head=dqs_del_str0(Op_head,request_list->str0);
	  dqs_write_list_to_disk(NULL,OP_FILE,Op_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0089 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case dq_OPT:
	  DPRINTF((DQS_EVENT,"===>dq_OPT: deleting queue \"%s\"",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting an queue requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0090 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  DTRACE
	    bzero((char *)&listel,sizeof(listel));
	  queue_ptr=dqs_locate_queue(request_list->str0);
	  if (!queue_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the queue \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0091 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  if (queue_ptr->qty_active)
	    {
	      sprintf(str,"the queue \"%s\" has been deleted by %s\nwarning: it had %d active jobs",
		      request_list->str0,(*request_head)->user,queue_ptr->qty_active);
	    }
	  else
	    {
	      sprintf(str,"the queue \"%s\" has been deleted by %s",
		      request_list->str0,(*request_head)->user);
	    }
	  dqs_hash_del(request_list->str0,Queue_hash);
	  Queue_head=dqs_del_str0(Queue_head,request_list->str0);
	  sorted= FALSE;
	  sprintf(str,"%s/%s",QUEUE_DIR,request_list->str0);
	  unlink(str);
	  sprintf(str,"The queue \"%s\" has been deleted",request_list->str0);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0092 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case du_OPT:
	  DPRINTF((DQS_EVENT,"===>du_OPT: deleting acl \"%s - %s %s\"",
		   request_list->str0,request_list->str1,request_list->str2));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_operator((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s deleting acl requires operator privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0093 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  if (!dqs_locate_acl(request_list->str0))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s  \"%s %s\" is not in acl lists",
		      (*request_head)->user,request_list->str1,request_list->str2);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0094 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  sprintf(str,"the user \"%s\" has been deleted from the acl list \"%s\" by %s",
		  request_list->str1,request_list->str2,(*request_head)->user);
	  dqs_hash_del(request_list->str0,Acl_hash);
	  Acl_head=dqs_del_str0(Acl_head,request_list->str0);
	  dqs_write_list_to_disk(NULL,ACL_FILE,Acl_head,ALL);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0095 %s",str));
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case gc_OPT:
	  DPRINTF((DQS_EVENT,"===>gc_OPT: get complex"));
	  
	  complex_ptr=dqs_locate_complex(request_list->str0);
	  if (!complex_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate the complex \"%s\"",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      WARNING((DQS_EVENT,"DQS_ERROR_0096 %s",str));
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,complex_ptr->str0);
	  listel.chain=dqs_replicate_list(complex_ptr->chain,ALL);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case gcons_OPT:
	  DPRINTF((DQS_EVENT,"===>gcons_OPT: get consumable"));
	  
	  consumable_ptr=dqs_locate_consumable(request_list->str0);
	  if (!consumable_ptr){
	    listel.status=DQS_NAK;
	    sprintf(str,"error: %s cannot locate the consumable \"%s\"",
		    (*request_head)->user,request_list->str0);
	    listel.str0=dqs_string_insert(NULL,str);
	    reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	    request_list=request_list->next;
	    WARNING((DQS_EVENT,"DQS_ERROR_0097 %s",str));
	    bzero((char *)&listel,sizeof(listel));
	    continue;
	  }
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,consumable_ptr->str0);
	  listel.chain=dqs_replicate_list(consumable_ptr->chain,ALL);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case kq_OPT:/*???*/
	  DPRINTF((DQS_EVENT,"===>kq_OPT: killing queue >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s killing a queue requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      WARNING((DQS_EVENT,"DQS_ERROR_0098 %s",str));
	      continue;
	    }
	  listel.status=DQS_NAK;
	  sprintf(str,"error: \"-kq %s\" is not implemented yet",
		  request_list->str0);
	  listel.str0=dqs_string_insert(NULL,str);
	  WARNING((DQS_EVENT,"DQS_ERROR_0099 %s",str));
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case kqs_OPT:/*???*/
	  DPRINTF((DQS_EVENT,"===>kq_OPT: killing queues >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s killing a queue requires manager privileges",
		      (*request_head)->user);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      WARNING((DQS_EVENT,"DQS_ERROR_0100 %s",str));
	      continue;
	    }
	  listel.status=DQS_NAK;
	  sprintf(str,"error: %s \"-kq %s\" is not implemented yet",
		  (*request_head)->user,request_list->str0);
	  listel.str0=dqs_string_insert(NULL,str);
	  WARNING((DQS_EVENT,"DQS_ERROR_0101 %s",str));
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case mc_OPT:   /*   Modify Complex  */
	  
	  DPRINTF((DQS_EVENT,"===>ac_OPT: Modifying Complex >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s modifying a complex requires manager privileges",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0102 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=dqs_string_insert(NULL,request_list->str0);
	  listel.chain=request_list->chain;
	  request_list->chain=NULL;
	  
	  if (dqs_replace_complex(&listel) )
            {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s the complex hash \"%s\" is trashed",
		      (*request_head)->user,request_list->str0);
	      WARNING((DQS_EVENT,"DQS_ERROR_0103 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
            }
	  
	  sprintf(str,"the complex \"%s\" has been modified by %s",listel.str0,
		  (*request_head)->user);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0104 %s",str));                  
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  /*------------------------------------------------------*/
	  
	case mconf_OPT:/*???*/
	  DPRINTF((DQS_EVENT,"===>mc_OPT: killing queues >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_NAK;
	  sprintf(str,"error: %s \"qconf -mconf %s\" is not implemented yet",
		  (*request_head)->user,request_list->str0);
	  listel.str0=dqs_string_insert(NULL,str);
	  WARNING((DQS_EVENT,"DQS_ERROR_0105 %s",str));
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case mcons_OPT:   /*   Modify Consumable  */
	  
	  DPRINTF((DQS_EVENT,"===>ac_OPT: Modifying consumable >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s modifying a consumable requires manager privileges",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0106 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  listel.str0=dqs_string_insert(NULL,request_list->str0);
	  listel.chain=request_list->chain;
	  request_list->chain=NULL;
	  
	  if (dqs_replace_consumable(&listel) )
            {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s the consumable hash \"%s\" is trashed",
		      (*request_head)->user,request_list->str0);
	      WARNING((DQS_EVENT,"DQS_ERROR_0107 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
            }
	  
	  sprintf(str,"the consumable \"%s\" has been modified by %s",listel.str0,
		  (*request_head)->user);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0108 %s",str));                  
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case mq_OPT:
	  
	  DPRINTF((DQS_EVENT,"===>mc_OPT: modifying queue >%s<",request_list->str0));
	  
	  bzero((char *)&listel,sizeof(listel));
	  if (dqs_manager((*request_head)->user))
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s modifying a queue requires manager privileges",
		      (*request_head)->user);
	      WARNING((DQS_EVENT,"DQS_ERROR_0109 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  if (dqs_modify_queue(request_list->queue) )
            {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: cannot modify queue \"%s\" is trashed",
		      request_list->queue->qname);
	      WARNING((DQS_EVENT,"DQS_ERROR_0110 %s",str));
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
            }
	  sorted= FALSE;             
	  sprintf(str,"the queue \"%s\" has been modified by %s",
		  request_list->queue->qname, (*request_head)->user);
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  INFO((DQS_EVENT,"DQS_ERROR_0111 %s",str));                  
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	  
	case qmon_OPT:
	  DPRINTF((DQS_EVENT,"===>qmon_OPT: "));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  
	  listel_ptr=Queue_head;
	  while (listel_ptr)
	    {
	      cp=NULL;
	      if (listel_ptr->queue->complex_list)
		{
		  lp=dqs_locate_complex(listel_ptr->queue->complex_list->str0);
		  cp=dqs_build_qcomplex_str(lp);
		}
	      else
		cp=dqs_build_qcomplex_str(NULL);
	      bzero((char *)&listel2,sizeof(listel2));
	      listel2.status=DQS_ACK;
	      bzero((char *)str,sizeof(str));
	      if (listel_ptr->queue->load_avg>=listel_ptr->queue->load_alarm)
		{
		  SETBIT(ALARM,listel_ptr->queue->state);
		}
	      sprintf(str,"###:%d:%s:%s:%d:%d:%d:%s:",listel_ptr->queue->seq_no,
		      listel_ptr->queue->hostname,listel_ptr->queue->qname,
		      listel_ptr->queue->load_avg,listel_ptr->queue->qty,
		      listel_ptr->queue->qty_active,cp);
	      dqs_get_states(str,listel_ptr->queue->state);
	      strcat(str,":");
	      listel2.str0=dqs_string_insert(NULL,str);
	      listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel2);
	      dqs_free(cp);
	      listel_ptr=listel_ptr->next;
	    }		    
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case sc_OPT:
	  DPRINTF((DQS_EVENT,"===>sc_OPT: looking for complex >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel_ptr=dqs_locate_complex(request_list->str0);
	  if (!listel_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate complex %s",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      WARNING((DQS_EVENT,"DQS_ERROR_0112 %s",str));
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  else
	    {
	      sprintf(str,"complex \"%s\"",request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      listel.chain=dqs_replicate_list(listel_ptr->chain,ALL);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      dqs_showlist(&listel,DQS_STDERR|DQS_STR0|DQS_INT0|DQS_CHAIN,4);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  /*------------------------------------------------------*/
	case scl_OPT:
	  DPRINTF((DQS_EVENT,"===>scl_OPT: show complex list names"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"complex list names:");
	  listel_ptr=Complex_head;
	  while (listel_ptr)
	    {
	      bzero((char *)&listel2,sizeof(listel2));
	      listel2.str0=dqs_string_insert(NULL,listel_ptr->str0);
	      listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel2);
	      listel_ptr=listel_ptr->next;
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case sconf_OPT:
	  DPRINTF((DQS_EVENT,"===>sconf_OPT: showing conf"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.conf=dqs_replicate_conf(&conf);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case scons_OPT:
	  DPRINTF((DQS_EVENT,"===>sc_OPT: looking for consumable >%s<",request_list->str0));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel_ptr=dqs_locate_consumable(request_list->str0);
	  if (!listel_ptr)
	    {
	      listel.status=DQS_NAK;
	      sprintf(str,"error: %s cannot locate consumable %s",
		      (*request_head)->user,request_list->str0);
	      listel.str0=dqs_string_insert(NULL,str);
	      WARNING((DQS_EVENT,"DQS_ERROR_0113 %s",str));
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  else
	    {   
	      sprintf(str,"consumable \"%s\"\n available=%d\n consume_by=%d\n current=%d\n",
		      request_list->str0,listel_ptr->chain->int0,
		      listel_ptr->chain->int1, listel_ptr->chain->int2);
	      listel.str0=dqs_string_insert(NULL,str);
	      reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	      request_list=request_list->next;
	      bzero((char *)&listel,sizeof(listel));
	      continue;
	    }
	  
	  /*------------------------------------------------------*/
	case sconsl_OPT:
	  DPRINTF((DQS_EVENT,"===>scl_OPT: show consumable list names"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  
	  listel.str0=dqs_string_insert(NULL,"consumbable names:");
	  listel_ptr=Consumable_head;
	  while (listel_ptr)
	    {
	      bzero((char *)&listel2,sizeof(listel2));
	      listel2.str0=dqs_string_insert(NULL,listel_ptr->str0);
	      listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel2);
	      listel_ptr=listel_ptr->next;
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  
	  /*------------------------------------------------------*/
	case sh_OPT:
	  DPRINTF((DQS_EVENT,"===>sh_OPT: show host list"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"host list:");
	  listel.chain=dqs_replicate_list(Host_head,ALL);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case sm_OPT:
	  DPRINTF((DQS_EVENT,"===>sm_OPT: show manager list"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"manager list:");
	  listel.chain=dqs_replicate_list(Man_head,ALL);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case so_OPT:
	  DPRINTF((DQS_EVENT,"===>so_OPT: show operator list"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"operator list:");
	  listel.chain=dqs_replicate_list(Op_head,ALL);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case sq_OPT:
	  DPRINTF((DQS_EVENT,"===>sq_OPT: show queue"));
	  if (request_list->str0)
	    {
	      queue_ptr=dqs_locate_queue(request_list->str0);
	      if (!queue_ptr)
		{
		  listel.status=DQS_NAK;
		  sprintf(str,"error: %s cannot locate the queue \"%s\"",
			  (*request_head)->user,request_list->str0);
		  listel.str0=dqs_string_insert(NULL,str);
		  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
		  request_list=request_list->next;
		  WARNING((DQS_EVENT,"DQS_ERROR_0114 %s",str));
		  bzero((char *)&listel,sizeof(listel));
		  continue;
		}
	    }
	  else
	    {
	      queue_ptr=dqs_read_in_qconf(NULL,GENERIC_QUEUE);
	      if (!queue_ptr)
		{
		  dqs_write_generic_qconf(NULL,GENERIC_QUEUE);
		  queue_ptr=dqs_read_in_qconf(NULL,GENERIC_QUEUE);
		}
	      if (!queue_ptr)
		{
		  CRITICAL((DQS_EVENT,"DQS_ERROR_0115 terminal error: dqs_read_in_qconf() failed"));
		  DEXITE;
		  abort();
		}
	      free_queue_ptr=TRUE;
	    }
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.queue=dqs_replicate_queue(queue_ptr);
	  if (free_queue_ptr)
	    {
	      queue_ptr=dqs_free_queue(queue_ptr);
	      free_queue_ptr=FALSE;
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case sql_OPT:
	  DPRINTF((DQS_EVENT,"===>sql_OPT: show queue list names"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"queue list names:");
	  listel_ptr=Queue_head;
	  while (listel_ptr)
	    {
	      bzero((char *)&listel2,sizeof(listel2));
	      listel2.str0=dqs_string_insert(NULL,listel_ptr->str0);
	      listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel2);
	      listel_ptr=listel_ptr->next;
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case su_OPT:
	  DPRINTF((DQS_EVENT,"===>su_OPT: show user list"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"user names:");
	  listel_ptr=Acl_head;
	  while (listel_ptr)
	    {
	      if (!strcmp(request_list->str0,listel_ptr->str2))
		{
		  bzero((char *)&listel2,sizeof(listel2));
		  bzero((char *)str,sizeof(str));
		  sprintf(str,"%s\t%s",listel_ptr->str2,listel_ptr->str1);
		  listel2.str0=dqs_string_insert(NULL,str);
		  listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel2);
		}
	      listel_ptr=listel_ptr->next;
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	case sul_OPT:
	  DPRINTF((DQS_EVENT,"===>sul_OPT: show user list names"));
	  bzero((char *)&listel,sizeof(listel));
	  listel.status=DQS_ACK;
	  listel.str0=dqs_string_insert(NULL,"acl list names:");
	  listel_ptr=Acl_head;
	  while (listel_ptr)
	    {
	      bzero((char *)&listel2,sizeof(listel2));
	      listel2.str0=dqs_string_insert(NULL,listel_ptr->str2);
	      listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel2);
	      listel_ptr=listel_ptr->next;
	    }
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  continue;
	  
	  /*------------------------------------------------------*/
	default:
	  WARNING((DQS_EVENT,"DQS_ERROR_0116 error: %s CASE unknown list type %d",
		   (*request_head)->user,request_list->type));
	  listel.status=DQS_NAK;
	  listel.str0=dqs_string_insert(NULL,str);
	  reply_head=dqs_insert(DQS_STR0,TAIL,reply_head,&listel);
	  request_list=request_list->next;
	  bzero((char *)&listel,sizeof(listel));
	  break;
	}
      
    }
  
  *request_head=dqs_free_list(*request_head);
  
  if ((dqs_send_list(NULL,NULL,sfd,reply_head))<0)
    {
      reply_head=dqs_free_list(reply_head);
      DEXITE;
      return;
    }
  dqs_close_sfd(sfd);
  
  reply_head=dqs_free_list(reply_head);
  
  DEXIT;
  return;
  
}
