﻿// Copyright 2014-2017 ClassicalSharp | Licensed under BSD-3
#if SURVIVAL_TEST
using System;
using System.Drawing;
using ClassicalSharp.GraphicsAPI;
using ClassicalSharp.Mode;
#if ANDROID
using Android.Graphics;
#endif

namespace ClassicalSharp.Gui.Widgets {
	public class SurvivalHotbarWidget : HotbarWidget {
		
		TextAtlas posAtlas;
		Font font;
		public SurvivalHotbarWidget(Game game) : base(game) {
		}
		
		// TODO: scaling
		public override void Init() {
			base.Init();
			font = new Font(game.FontName, 16);
			posAtlas = new TextAtlas(game, 16);
			posAtlas.Pack("0123456789", font, "f");
			Events.ChatFontChanged += ChatFontChanged;
		}
		
		void ChatFontChanged(object nill, EventArgs e) { Recreate(); }
		
		public override void Render(double delta) {
			base.Render(delta);
			DrawCounts();
			DrawHearts();
		}
		
		public override void Dispose() {
			font.Dispose();
			posAtlas.Dispose();
			Events.ChatFontChanged -= ChatFontChanged;
		}
		
		
		void DrawCounts() {
			SurvivalGameMode surv = (SurvivalGameMode)game.Mode;
			VertexP3fT2fC4b[] vertices = game.ModelCache.vertices;
			int index = 0;
			posAtlas.tex.Y = (short)(Y + (Height - barHeight));
			
			int offset = game.Inventory.Offset;
			for (int i = 0; i < Inventory.BlocksPerRow; i++) {
				int x = (int)(X + (elemSize + borderSize) * i);
				posAtlas.curX = x;
				if (surv.invCount[offset + i] > 1)
					posAtlas.AddInt(surv.invCount[offset + i], vertices, ref index);
			}

			game.Graphics.BindTexture(posAtlas.tex.ID);
			game.Graphics.UpdateDynamicVb_IndexedTris(game.ModelCache.vb, game.ModelCache.vertices, index);
		}
		
		void DrawHearts() {
			Model.ModelCache cache = game.ModelCache;
			int index = 0, health = game.LocalPlayer.Health;
			int inner = (int)(7 * game.GuiHotbarScale);
			int middle = (int)(8 * game.GuiHotbarScale);
			int outer = (int)(9 * game.GuiHotbarScale);
			
			int selBlockSize = (int)(23 * game.GuiHotbarScale);
			int offset = middle - inner;
			int y = Y + (Height - selBlockSize - outer);
			
			for (int heart = 0; heart < 10; heart++) {
				Texture tex = new Texture(0, X + middle * heart, y, outer, outer, backRec);
				IGraphicsApi.Make2DQuad(ref tex, PackedCol.White, cache.vertices, ref index);
				if (health <= 0) continue;
				
				TextureRec rec = (health >= 2) ? fullRec : halfRec;
				tex = new Texture(0, X + middle * heart + offset, y + offset, inner, inner, rec);
				IGraphicsApi.Make2DQuad(ref tex, PackedCol.White, cache.vertices, ref index);
				health -= 2;
			}
			
			game.Graphics.BindTexture(game.Gui.IconsTex);
			game.Graphics.UpdateDynamicVb_IndexedTris(cache.vb, cache.vertices, index);
		}
		
		static TextureRec backRec = new TextureRec(16 / 256f, 0 / 256f, 9 / 256f, 9 / 256f);
		static TextureRec fullRec = new TextureRec(53 / 256f, 1 / 256f, 7 / 256f, 7 / 256f);
		static TextureRec halfRec = new TextureRec(62 / 256f, 1 / 256f, 7 / 256f, 7 / 256f);
	}
}
#endif