/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

/*
 * Copyright 1997 by Yu Mingjian.          All Rights Reserved
 * Distributed under the terms of the GNU General Public License (GPL)
 *
 * Permission to retain, use, modify, copy, and distribute Chinput1.0
 * in source or binary and its documentation (hereafter, the Software)
 * for noncommercial purpose is hereby granted to you without a fee,
 * provided that this entire copyright and permission notice appear in
 * all such copies, that no charge be associated with such copies,
 * that distribution of derivative works (including value-added
 * distributions such as with additional input dictionaries or fonts)
 * include clarification that such added or derived parts are not from
 * the original Software, and that the names of the author(s) not be
 * used to endorse or promote such works. The author(s) of the software
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE AUTHOR(S) OF THE SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR(S) OF THE SOFTWARE BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Yu Mingjian, Institute of High Energy Physics, Academia Sinica
 * 
 */

#include "all.h"
#include "symbol.h"

chinput_symbol *chinput_corner;

#define STRBUFLEN 64

int proc_reply(char c, char *buf)
{
        // very special....
        if(flag_corner && flag_punct)
                return set_reply_corner_punct(c, buf);
        else if(flag_corner && !flag_punct)
                return set_reply_corner(c, buf);
        else if(!flag_corner && flag_punct) 
                return set_reply_punct(c, buf);
        else //if(!flag_corner && !flag_punct)
                return set_reply(c, buf);
}

void HZprocXIM(XKeyEvent *kev, char *buf, int *charcount)
{
        char strbuf[STRBUFLEN];
        KeySym keysym;
        int count;

        memset(strbuf, 0, STRBUFLEN);
        count = XLookupString(kev, strbuf, STRBUFLEN, &keysym, NULL);
        if(HZServer.encoding == HZSERVER_ENCODING_GB)
                chinput_corner = chinput_corner_gb;
        else if(HZServer.encoding == HZSERVER_ENCODING_BIG5)
                chinput_corner = chinput_corner_big5;

	*charcount = proc_reply(strbuf[0], buf);

}

void HZprocMessage(XClientMessageEvent *ev)
{

	int i;
        XClientMessageEvent event;

        char *s = event.data.b;

        char buf[20];
	char tbuf[20];
        int charcount;

	/* check lock status */
	if(HZServer.lockw != None &&
	   ev->window != HZServer.lockw)
		return;

	/* check map status */
	if(map_mode == 0){
                event.type=ClientMessage;
                event.window=ev->window;
                event.message_type=hz_output_atom;
                event.format=32;
                event.data.b[0] = 1;
                event.data.l[1] = ev->data.l[0];
                event.data.l[2] = ev->data.l[1];
                event.data.l[3] = ev->data.l[2];
                if(HZServer.lockw != None)
                        XSendEvent(display, HZServer.lockw,
                                False, 0, (XEvent *)&event);
                else
                        XSendEvent(display, ev->window,
                              False, 0, (XEvent *)&event);
		return;
		
	}
	if(HZServer.encoding == HZSERVER_ENCODING_GB)
		chinput_corner = chinput_corner_gb;
	else if(HZServer.encoding == HZSERVER_ENCODING_GB)
		chinput_corner = chinput_corner_big5;

        if(flag_corner && flag_punct) 
		charcount = set_reply_corner_punct(ev->data.l[0], buf);
	else if(flag_corner && !flag_punct)
		charcount = set_reply_corner(ev->data.l[0], buf);
	else if(!flag_corner && flag_punct)
		charcount = set_reply_punct(ev->data.l[0], buf);
	else //if(!flag_corner && !flag_punct)
		charcount = set_reply(ev->data.l[0], buf);

        if(charcount == 0) return;
        if(charcount == 1) {
                event.type=ClientMessage;
                event.window=ev->window;
                event.message_type=hz_output_atom;
                event.format=32;
		/* b[0] --> charcount
		   l[1] --> keysym
		   l[2] --> keystatus
		   l[3] --> keycode
		*/
                event.data.b[0] = charcount;
                event.data.l[1] = ev->data.l[0];
		event.data.l[2] = ev->data.l[1];
		event.data.l[3] = ev->data.l[2];
	        if(HZServer.lockw != None)
        	        XSendEvent(display, HZServer.lockw,
                	        False, 0, (XEvent *)&event);
        	else
                	XSendEvent(display, ev->window, 
				False, 0, (XEvent *)&event);
        }else {
		/* in case of buffer overflow */
                /* b[0] --> charcount
                   b[1...] --> buffer
                */
                if(charcount > 18) charcount = 18;

		if((HZServer.encoding == HZSERVER_ENCODING_GB && 
		    flag_encoding == HZSERVER_ENCODING_BIG5 &&
		    flag_lock == LOCK_NONE) ||
		   (HZServer.encoding == HZSERVER_ENCODING_GB &&
                    flag_encoding == HZSERVER_ENCODING_GB &&
                    flag_lock == LOCK_BIG5)){
			//filter to big5 encoding
			gbstring_big5string(buf, tbuf, charcount);
			strncpy(buf, tbuf, charcount);
		} else 
		if((HZServer.encoding== HZSERVER_ENCODING_BIG5 && 
		    flag_encoding == HZSERVER_ENCODING_GB &&
		    flag_lock == LOCK_NONE) ||
		   (HZServer.encoding== HZSERVER_ENCODING_BIG5 &&
		    flag_encoding == HZSERVER_ENCODING_BIG5 &&
		    flag_lock == LOCK_GB)){
			//filter to gb encoding
                        big5string_gbstring(buf, tbuf, charcount);
                        strncpy(buf, tbuf, charcount);
                }

		for(i=0; i<charcount; i+=2){
                	event.type=ClientMessage;
                	event.window=ev->window;
                	event.message_type=hz_output_atom;
                	event.format=32;
                	event.data.b[0] = 2;
                	strncpy(s+1, &(buf[i]), 2);
             		if(HZServer.lockw != None)
                        	XSendEvent(display, 
					HZServer.lockw,
                                	False, 0, (XEvent *)&event);
                	else
                        	XSendEvent(display, ev->window, 
                                	False, 0, (XEvent *)&event);
		}
/*
                event.type=ClientMessage;
                event.window=ev->window;
                event.message_type=hz_output_atom;
                event.format=32;
                event.data.b[0] = charcount;
                strncpy(s+1, &(buf[0]), charcount);
                if(HZServer.lockw != None)
                        XSendEvent(display, 
                                HZServer.lockw,
                                False, 0, (XEvent *)&event);
                else
                        XSendEvent(display, ev->window, 
                                False, 0, (XEvent *)&event);
*/
        }
}

int set_reply_corner_punct(char c, char *buf)
{
	int item;
   
	//if have choices, turn the page
	if(flag_found && (c == ',' || c =='.')) {
		set_reply(c, buf);
		return 0;
	}

	item = in_table(c);
	if(item != -1){
		if(chinput_corner[item].num == 1){
			strcpy(buf, chinput_corner[item].s);
                	return strlen(buf);
		} else {
			strncpy(buf, (char *)(chinput_corner[item].s + 
				chinput_corner[item].cur*2), 2);
			buf[2] = '\0';
			chinput_corner[item].cur ++;
			if(chinput_corner[item].cur == chinput_corner[item].num)
				chinput_corner[item].cur = 0;
			return 2;
		}
        } else {
		return set_reply(c, buf);
        }
}

int set_reply_corner(char c, char *buf)
{
        int item;

        item = in_alnum(c);
        if(item != -1){
        	strcpy(buf, chinput_corner[item].s);
        	return strlen(buf);
	} else {
		return set_reply(c, buf);
        }
}

int set_reply_punct(char c, char *buf)
{
        int item;
   
	//if have choices, turn the page
	if(flag_found && (c == ',' || c =='.' || c == '\'')) {
		set_reply(c, buf);
		return 0;
	}

        item = in_punct(c);
        if(item != -1){
        	if(chinput_corner[item].num == 1){
			strcpy(buf, chinput_corner[item].s);
        		return strlen(buf);
		} else {
			strncpy(buf, (char *)(chinput_corner[item].s + 
				chinput_corner[item].cur*2), 2);
			buf[2] = '\0';
			chinput_corner[item].cur ++;
			if(chinput_corner[item].cur == chinput_corner[item].num)
				chinput_corner[item].cur = 0;
			return 2;
		}
	} else {
		return set_reply(c, buf);
	}
}

int set_reply(char ch, char *buf)
{
/*
	if(cur_inputmethod == HZSERVER_INPUT_METHOD_GB_ZNPY)
		return set_reply_znpy(ch, buf);
	else if(cur_inputmethod == HZSERVER_INPUT_METHOD_BIG5_HSU)
		return set_reply_hsu(ch, buf);

	else
*/
		return set_reply_default(ch, buf);
}

int set_reply_default(char ch, char *buf)
{
	int n;
	int charcount;
        char mbuf[256];
	Boolean flag_znpy;

        bzero(mbuf, 256);

	flag_znpy = False;

	if(!strcmp(chinputime[cur_inputmethod].namegb, "ƴ")){
        	IMM_GetInputDisplay (chinput_imm, mbuf, sizeof (mbuf));
		flag_znpy = True;
	}

	//see if 'v' before filtering
	if(flag_znpy && flag_english == True 
		&& ch != ' ' && ch != 0x08){//append char
		buf[0] = ch;
		buf[1] = '\0';
		strcat(input_buf, buf);
		charcount =  0;
	} else if(flag_znpy && flag_english == True 
		&& ch == 0x08){	//delete char
		int num;
		num = strlen(input_buf);
		if(num > 1){
			input_buf[num-1] = '\0';
			charcount = 0;
		} else {
			flag_english = False;
			input_buf[0] = '\0';
			charcount = 0;
		}
	} else if(flag_znpy && strlen(mbuf) == 0 && ch == 'v'){	//start editing
		flag_english = True;
		input_buf[0] = 'v';
		input_buf[1] = '\0';
		charcount = 0;
	} else if(flag_znpy && flag_english == True && ch == ' '){	//commit string
		flag_english = False;
		strcpy(buf, input_buf+1);
		bzero(input_buf, 80);
		charcount = strlen(buf) + 1;
	} else {
		if(flag_znpy && strlen(mbuf) != 0){
			if(ch == '['){
				flag_single = 1;
				return 0;
			} else if(ch == ']'){
				flag_single = 2;
				return 0;
			}
		}
		n = IMM_KeyFilter(chinput_imm, ch, buf, &charcount);
		switch(n){
			case 0:
      				buf[0] = ch;
       				buf[1] = '\0';
				charcount = 1;
				break;
			case 1:
				charcount = 0;
				break;
			case 2:
				buf[charcount] = '\0';
				break;
		}		
	}	
	if(charcount == 0) flag_refresh = 0;

	if(dmode == HZSERVER_DMODE_ROOT)
		HZrootFlush();
	else if(dmode == HZSERVER_DMODE_OVERSPOT)
		HZoverspotFlush();
	else if(dmode == HZSERVER_DMODE_ONSPOT)
		HZonspotFlush();
	else if(dmode == HZSERVER_DMODE_OFFSPOT)
		HZoffspotFlush();

	return charcount;
}

int in_table(char c)
{
	int i;

	for(i=0; i<N_SYMBOL; i++)
		if(chinput_corner[i].c == c) return i;
	return -1;
}

int in_alnum(char c)
{
	if(isalnum(c)){
		int item;
                item = in_table(c);
                return item;
	} else {
		return -1;
	}
}
 
int in_punct(char c)
{
	if(ispunct(c)){
		int item;
		item = in_table(c);
		return item;
	} else {
		return -1;
	}
}

