/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

/*************************************************************

  XIM Implementation by Yu Mingjian(justiny@turbolinux.com.cn)

**************************************************************/


#include "all.h"

//InputModule *inmd=&HZServer.cxtermInput.InputMd;
Boolean xim_use_trigger = False;    /* Static Event Flow is default */
Boolean xim_use_offkey = False;    /* Register OFF Key for Dynamic Event Flow */
Boolean xim_use_tcp = False;       /* Using TCP/IP Transport or not */
Boolean xim_use_local = False;     /* Using Unix domain Tranport or not */
long filter_mask = KeyPressMask;
//static XIMS this_xims;

char *imname = DEFAULT_IMNAME;
XIMStyles *input_styles, *styles2;
XIMTriggerKeys *on_keys, *trigger2;
XIMEncodings *encodings, *encoding2;
char transport[80];

/* Supported Inputstyles */
//Chinput now support all input styles. It will adjust the input style
//automatically according to the client request.

//GTK
//global command line settings for gtk base applications
//--xim-preedit=[none|nothing|area|position|callbacks]
//--xim-status=[none|nothing|area|callbacks]
//Only OverTheSpot and Root implemented

//QT-1.44-i18n
//global command line setting for qt based applications
//-inputstyle [overthespot|offthespot|root]
//OVERTHESPOT: XIMPreeditPosition | XIMStatusNothing;
//OFFTHESPOT:  XIMPreeditArea | XIMStatusArea;
//ROOT:        XIMPreeditNothing | XIMStatusNothing;


// Motif's Style Selection
//global X resource
//*preeditType: [OverTheSpot|OffTheSpot|Root|OnTheSpot]
//OVERTHESPOT: XIMPreeditPosition, XIMStatusArea|XIMStatusNothing|XIMStatusNone
//OFFTHESPOT:  XIMPreeditArea, XIMStatusArea|XIMStatusNothing|XIMStatusNone
//ROOT:        XIMPreeditNothing, XIMStatusNothing|XIMStatusNone
//ONTHESPOT:   XIMPreeditCallbacks, XIMStatusArea|XIMStatusNothing|XIMStatusNone

// LessTif-0.90.1 - i18ned
//OVERSPOT:    XIMPreeditPosition XIMStatusArea
//OFFTHESPOT:  XIMPreeditArea, XIMStatusArea
//ROOT:        XIMPreeditNothing, XIMStatusNothing


//Java, awt part based on Motif
//global X resource
//*preeditType: [OverTheSpot|OffTheSpot|Root|OnTheSpot]
//ONTHESPOT:   XIMPreeditCallbacks, XIMStatusArea|XIMStatusNothing
//ROOT:        XIMXIMPreeditNothing, XIMStatusNothing (fallback)

//tcltk-8.0-jp -ized.
//OVERTHESPOT: XIMPreeditPosition, [XIMStatusArea|XIMStatusNothing]
//OFFTHESPOT:  XIMPreeditArea, XIMStatusArea
//ROOT:        XIMPreeditNothing, XIMStatusNothing


//rxvt's Style Selection
//rxvt -im Chinput -km [gb|big5] -pt [OverTheSpot|OffTheSpot|Root]
//OverTheSpot: XIMPreeditPosition,  XIMStatusNothing
//OffTheSpot:  XIMPreeditArea,  XIMStatusArea
//Root:        XIMPreeditNothing,  XIMStatusNothing

//Netscape's style
//in Netscape.ad
//*inputMethod: Chinput
//*preeditType: OverTheSpot(default)
//Root:	       XIMPreeditPosition,  XIMStatusNothing
//OverTheSpot: XIMPreeditPosition, XIMStatusArea	(the default)


//Mozilla's styles
//OnTheSpot, OverTheSpot, Root
//Chosen from (preedit)
//	GDK_IM_PREEDIT_CALLBACKS, GDK_IM_PREEDIT_POSITION, GDK_IM_PREEDIT_NOTHING, GDK_IM_PREEDIT_NONE
//and (stauts)
//	GDK_IM_STATUS_CALLBACKS, GDK_IM_STATUS_NOTHING, GDK_IM_STATUS_NONE
//in ~/.mozilla/$profile/pref.js:
//user_pref("xim.input_policy", "per-widget");	//per-widget | per-shell
//user_pref("xim.input_style", "on-the-spot");	//on-the-spot|over-the-spot|root
//overwrite by
//user_pref("xim.preedit.input_style", "callbacks")//callbacks|position|nothing|none
//user_pref("xim.status.input_style", "callbacks")//callbacks|nothing|none
//Mozilla's status area can be specified in resource file
//	*OverTheSpotConversion.modeLocation: bottomleft
//mozilla has some bugs:
//(1). When URL input area lost focus and reget focus, input style changed
//(2). In callbacks|callbacks style, if candidate window popup, the candidate
//     window and the status window will try to map to another's top


/* Other applications */
//lyx-1.0.3
//Combination: of XIMPreeditPosition,XIMPreeditNothing
//            and XIMStatusArea,XIMStatusNothing

//xfig  i18n patched
//command line
//-inputStyle [OffTheSpot|OverTheSpot|Root]


//all of the input styles Chinput supports
static XIMStyle Styles[] = {
        XIMPreeditCallbacks|XIMStatusCallbacks,		//OnTheSpot
        XIMPreeditCallbacks|XIMStatusArea,		//OnTheSpot
        XIMPreeditCallbacks|XIMStatusNothing,		//OnTheSpot
        XIMPreeditPosition|XIMStatusArea,		//OverTheSpot
        XIMPreeditPosition|XIMStatusNothing,		//OverTheSpot
        XIMPreeditPosition|XIMStatusNone,		//OverTheSpot
        XIMPreeditArea|XIMStatusArea,			//OffTheSpot
        XIMPreeditArea|XIMStatusNothing,		//OffTheSpot
        XIMPreeditArea|XIMStatusNone,			//OffTheSpot
        XIMPreeditNothing|XIMStatusNothing,		//Root
        XIMPreeditNothing|XIMStatusNone,		//Root
	0
};

/* Trigger Keys List */
static XIMTriggerKey Trigger_Keys[] = {
    	{XK_space, ShiftMask, ShiftMask},
    	{0L, 0L, 0L}
};

/* Supported Encodings */
static XIMEncoding chEncodings[] = {
    	"COMPOUND_TEXT",
    	NULL
};

#define STRBUFLEN 64

Boolean IsForwardKey(XIMS ims, IMForwardEventStruct *call_data)
{
	char strbuf[STRBUFLEN];
	KeySym keysym;
	XKeyEvent *kev;

        last_icid = call_data->icid;
        last_connectid = call_data->connect_id;

	memset(strbuf, 0, STRBUFLEN);
	kev = (XKeyEvent*)&call_data->event;
	XLookupString(kev, strbuf, STRBUFLEN, &keysym, NULL);

	//control-space/alt-space will NOT be forwarded
	if( (kev->state & ControlMask) && (kev->state & Mod1Mask) &&
		(keysym == XK_space) ) return False;
        if( (kev->state & ControlMask) && (kev->state & Mod1Mask) &&
		(keysym == XK_s || keysym == XK_S) ) return False;
	if( (kev->state & ControlMask) && (keysym == XK_space) ) return False;
	if( (kev->state & Mod1Mask) && (keysym == XK_space) ) return False;

	//Function Keys will NOT be forwarded
	if(keysym >= XK_F1 && keysym <= XK_F12 && map_mode == 1) return False;

	//if the input window not mapped, forward back
	if(map_mode == 0) return True;

	//switch input methods circularly
	if(keysym == XK_Shift_L && (kev->state & ControlMask)) return False;
	if(keysym == XK_Control_L && (kev->state & ShiftMask)) return False;

	//switch punctuation or corner mode
	if(keysym == XK_space && (kev->state & ShiftMask)) return False;
	if(keysym == XK_period && (kev->state & ControlMask)) return False;

	//all keys with modifier will be forwarded
	if( (kev->state & ControlMask) || (kev->state & Mod1Mask) ) return True;

	//backspace not forwarded
	if( 	keysym == XK_BackSpace  ||
		keysym == XK_Linefeed	||
		keysym == XK_Return	||
		keysym == XK_Delete ) return False;
	
	//normal keys
	if( (keysym >= 0x20 && keysym <= 0xff) )return False;
	
	//all others
	return True;
}

Boolean IsControlKey(XIMS ims, IMForwardEventStruct *call_data)
{
        char strbuf[STRBUFLEN];
        KeySym keysym;
        XKeyEvent *kev;

        memset(strbuf, 0, STRBUFLEN);
        kev = (XKeyEvent*)&call_data->event;
        XLookupString(kev, strbuf, STRBUFLEN, &keysym, NULL);

        //control-space will act as control key
        if( (kev->state & ControlMask) && (kev->state & Mod1Mask) &&
		(keysym == XK_space) ) return True;
        if( (kev->state & ControlMask) && (kev->state & Mod1Mask) &&
		(keysym == XK_s || keysym == XK_S) ) return True;
        if( (kev->state & ControlMask) && (keysym == XK_space) ) return True;
        if( (kev->state & Mod1Mask) && (keysym == XK_space) ) return True;

	//switch input methods circularly
	if(keysym == XK_Shift_L && (kev->state & ControlMask)) return True;
	if(keysym == XK_Control_L && (kev->state & ShiftMask)) return True;

        //switch corner or punctuation mode
        if(keysym == XK_space && (kev->state & ShiftMask)) return True;
        if(keysym == XK_period && (kev->state & ControlMask)) return True;

        //all others
        return False;
}

void ProcessControlKey(XIMS ims, IMForwardEventStruct *call_data)
{
        char strbuf[STRBUFLEN];
        KeySym keysym;
        XKeyEvent *kev;

        memset(strbuf, 0, STRBUFLEN);
        kev = (XKeyEvent*)&call_data->event;
        XLookupString(kev, strbuf, STRBUFLEN, &keysym, NULL);

	if((kev->state & ControlMask) && (kev->state & Mod1Mask) &&
		(keysym == XK_space) ){
		HZprocAutoHide();
        } else if( (kev->state & ControlMask) && (keysym == XK_space) ){
		HZprocToggleWindow();
        } else if( (kev->state & Mod1Mask) && (keysym == XK_space) ){
		HZprocSwitchMode();
	} else if( ((kev->state & ControlMask) && (keysym == XK_Shift_L)) ||
		   ((kev->state & ShiftMask) && (keysym == XK_Control_L))){
		HZprocCirculateInputMethod();
	} else if( (kev->state & ControlMask) && (kev->state & Mod1Mask) &&
		(keysym == XK_s || keysym == XK_S) ) {
	} else if( (keysym == XK_space) && (kev->state & ShiftMask)){
		flag_corner = !flag_corner;
		proc_qj(flag_corner);
	} else if( (keysym == XK_period) && (kev->state & ControlMask)){
		flag_punct = !flag_punct;
		proc_punct(flag_punct);
	}
}

Boolean ChinputOpenHandler(XIMS ims, IMOpenStruct *call_data)
{
	//printf("lang:%s\n", call_data->lang.name);
	//printf("connect id:0x%x\n", call_data->connect_id);
	if(call_data->connect_id > MAX_CONNECT - 1) //FIXME
		return True;
	if(!strncmp(call_data->lang.name, "zh_TW", 5))
		xim_connect[call_data->connect_id] = HZSERVER_ENCODING_BIG5;
	else
		xim_connect[call_data->connect_id] = HZSERVER_ENCODING_GB;

	//should map window?
	return True;
}

Boolean ChinputCloseHandler(XIMS ims, IMCloseStruct *call_data)
{
	//should unmap window?
	return True;
}

Boolean ChinputCreateICHandler(XIMS ims, IMChangeICStruct *call_data)
{
	CreateIC(call_data);
	return True;
}

Boolean ChinputDestroyICHandler(XIMS ims, IMChangeICStruct *call_data)
{
	DestroyIC(call_data);
	return True;
}

Boolean ChinputGetICValuesHandler(XIMS ims, IMChangeICStruct *call_data)
{
	GetIC(call_data);
	return True;
}

Boolean ChinputSetICValuesHandler(XIMS ims, IMChangeICStruct *call_data)
{
	SetIC(call_data);
	return True;
}

Boolean ChinputFocusIn(XIMS ims, IMChangeFocusStruct *call_data)
{
	return HZprocFocusIn(call_data);
}

Boolean ChinputFocusOut(XIMS ims, IMChangeFocusStruct *call_data)
{
	return HZprocFocusOut(call_data);
}

Boolean ChinputResetIC(XIMS ims, IMResetICStruct *call_data)
{
	return HZprocResetIC(call_data);
}


Boolean ChinputForwardEventHandler(XIMS ims, IMForwardEventStruct *call_data)
{
	/* Lookup KeyPress Events only */
	if (call_data->event.type != KeyPress) {
        	//fprintf(stderr, "bogus event type, ignored\n");
        	return True;
    	}

	if(flag_automode == True) HZprocSetCurrentIC(call_data);

    	if(IsForwardKey(ims, call_data)){
        	IMForwardEventStruct forward_ev = *((IMForwardEventStruct *)call_data);
        	IMForwardEvent(ims, (XPointer)&forward_ev);
    	} else if(IsControlKey(ims, call_data)) {
		ProcessControlKey(ims, call_data);
    	} else if(dmode == HZSERVER_DMODE_HW){
		IMForwardEventStruct forward_ev = *((IMForwardEventStruct *)call_data);
                IMForwardEvent(ims, (XPointer)&forward_ev);
	} else {
		int len;
		char *clist[1];
		char convtext[256];
		char tbuf[256];
        	XTextProperty tp;
        	Display *dpy = ims->core.display;

		//see if the key is v

		//real conversion
		HZprocXIM((XKeyEvent *)&call_data->event, convtext, &len);
		
		if(len == 0) return False;
		if(len == 1){
        		IMForwardEventStruct forward_ev = *((IMForwardEventStruct *)call_data);
        		IMForwardEvent(ims, (XPointer)&forward_ev);
			return False;
		}
                //if(len > 18) len = 18;
		if(flag_single == 1) {
			convtext[2] = '\0';
			len = 2;
		} else if(flag_single == 2 && len > 2){
			convtext[0] = convtext[2];
			convtext[1] = convtext[3];
			convtext[2] = '\0';
			len = 2;
		}
		//reset
		flag_single = 0;

		flag_encoding = FindEnc(call_data);

                if((HZServer.encoding == HZSERVER_ENCODING_GB && 
	    	    flag_encoding == HZSERVER_ENCODING_BIG5 &&
		    flag_lock == LOCK_NONE) || 
		   (HZServer.encoding == HZSERVER_ENCODING_GB &&
		    flag_encoding == HZSERVER_ENCODING_GB &&
		    flag_lock == LOCK_BIG5)){
                        //filter to big5 encoding
                        gbstring_big5string(convtext, tbuf, len);
                	strncpy(convtext, tbuf, len);
                } else if((HZServer.encoding == HZSERVER_ENCODING_BIG5 && 
		    	flag_encoding == HZSERVER_ENCODING_GB &&
		    	flag_lock == LOCK_NONE) ||
		   	(HZServer.encoding == HZSERVER_ENCODING_BIG5 &&
			flag_encoding == HZSERVER_ENCODING_BIG5 &&
                    	flag_lock == LOCK_GB)){
                        //filter to gb encoding
                        big5string_gbstring(convtext, tbuf, len);
                	strncpy(convtext, tbuf, len);
                }
		convtext[len] = 0;
		clist[0] = convtext;

		if(flag_encoding == HZSERVER_ENCODING_GB)
			setlocale(LC_CTYPE, LOCALE_GB);
		else
			setlocale(LC_CTYPE, LOCALE_BIG5);

        	XmbTextListToTextProperty(dpy, clist, 1,
                                  XCompoundTextStyle,
                                  &tp);

        	((IMCommitStruct*)call_data)->flag |= XimLookupChars;
        	((IMCommitStruct*)call_data)->commit_string = (char *)tp.value;
#if 0
        	fprintf(stderr, "commiting string...(%s)\n", tp.value);
#endif

        	IMCommitString(ims, (XPointer)call_data);

		//It is very important to flush the display of preedit area.
		//or else the display is incorrect.
		if(dmode == HZSERVER_DMODE_ONSPOT){
			HZonspotFlush();
			XUnmapWindow(display, window2);
		}

#if 0
        	XmbTextPropertyToTextList(dpy, &tp, &list_return, &count_return);
        	fprintf(stderr, "converted back: %s\n", *list_return);
#endif
        	XFree(tp.value);
        	//fprintf(stderr, "survived so far..\n");


		//hide window
		if(dmode == HZSERVER_DMODE_OVERSPOT){
			if(hmode == HZSERVER_HMODE_AUTO){
				XUnmapWindow(display, window1);
				XUnmapWindow(display, window2);
			} else {
				XUnmapWindow(display, window2);
			}
		} else if(dmode == HZSERVER_DMODE_ONSPOT){
			HZonspotClear();
		}
		flag_found = 0;
    	}
       	//return IMPreeditEnd(ims, (XPointer)call_data);
    	return True;
}

//simulate keyboard input
//Warning: this maybe dangerous
//If you closed the application, Chinput may exit with core

void ForwardString(char *text, int len)
{
        IMCommitStruct cms;
        XTextProperty tp;
        char *clist[1];
	char tbuf[20];
        char *convtext = text;
        Display *display = this_xims->core.display;

	if(!last_icid) return;

	flag_encoding = FindEncByID(last_icid);
	text[len] = '\0';

        if((HZServer.encoding == HZSERVER_ENCODING_GB && 
	    flag_encoding == HZSERVER_ENCODING_BIG5 &&
	    flag_lock == LOCK_NONE) ||
	   (HZServer.encoding == HZSERVER_ENCODING_GB &&                                    flag_encoding == HZSERVER_ENCODING_GB &&
	    flag_lock == LOCK_BIG5)){
                //filter to big5 encoding
                gbstring_big5string(convtext, tbuf, len);
                strncpy(convtext, tbuf, len);
        } else 
	if((HZServer.encoding == HZSERVER_ENCODING_BIG5 && 
	    flag_encoding == HZSERVER_ENCODING_GB &&
	    flag_lock == LOCK_NONE) ||
	   (HZServer.encoding == HZSERVER_ENCODING_BIG5 &&
	    flag_encoding == HZSERVER_ENCODING_BIG5 &&
            flag_lock == LOCK_GB)){
                //filter to gb encoding
                big5string_gbstring(convtext, tbuf, len);
                strncpy(convtext, tbuf, len);
        }
        convtext[len] = 0;
        clist[0] = convtext;

	if(flag_encoding == HZSERVER_ENCODING_GB)
		setlocale(LC_CTYPE, LOCALE_GB);
	else
		setlocale(LC_CTYPE, LOCALE_BIG5);

        XmbTextListToTextProperty(display, clist, 1,
        	XCompoundTextStyle, &tp);

        memset(&cms, 0, sizeof(cms));
        cms.major_code = XIM_COMMIT;
        cms.icid = last_icid;
        cms.connect_id = last_connectid;
        cms.flag = XimLookupChars;
        cms.commit_string = (char *)tp.value;
        IMCommitString(this_xims, (XPointer)&cms);
        XFree(tp.value);
}

int ForwardEvent(unsigned long keysym, Boolean f_shift,
	Boolean f_control, Boolean f_alt)
{
	IMForwardEventStruct fe;
        XEvent xkp;
	//if(!last_icid) return 0;
	//create event
        xkp.type                = KeyPress;
        xkp.xkey.type           = KeyPress;
        xkp.xkey.display        = display;
        xkp.xkey.serial         = 0L;
        xkp.xkey.send_event     = True;
        xkp.xkey.display        = display;
        xkp.xkey.x = xkp.xkey.y = xkp.xkey.x_root = xkp.xkey.y_root = 0;
        xkp.xkey.time           = get_time();
        xkp.xkey.same_screen    = True;
        xkp.xkey.subwindow      = None;
        xkp.xkey.window         = window3;
        xkp.xkey.root           = DefaultRootWindow(display);
        xkp.xkey.keycode        = XKeysymToKeycode(display, keysym);
        xkp.xkey.state          = (f_shift ? ShiftMask : 0) |
				  (f_control ? ControlMask : 0) |
				  (f_alt ? Mod1Mask : 0);

        memset(&fe, 0, sizeof(fe));
        fe.major_code 		= XIM_FORWARD_EVENT;
        fe.icid 		= last_icid;
        fe.connect_id 		= last_connectid;
	fe.sync_bit 		= 1;
	fe.serial_number 	= 0L;
	memcpy(&(fe.event), &xkp, sizeof(fe.event));
	IMForwardEvent(this_xims, (XPointer)&fe);

	fe.serial_number 	= 1L;
        xkp.xkey.type           = KeyRelease;
        xkp.xkey.time           = get_time();
	memcpy(&(fe.event), &xkp, sizeof(fe.event));
	IMForwardEvent(this_xims, (XPointer)&fe);

	return 1;
}


Boolean ChinputTriggerNotifyHandler(XIMS ims, IMTriggerNotifyStruct *call_data)
{
	if (call_data->flag == 0) { /* on key */
	/* Here, the start of preediting is notified from IMlibrary, which
	   is the only way to start preediting in case of Dynamic Event
	   Flow, because ON key is mandatary for Dynamic Event Flow. */
		return True;
	} else if (xim_use_offkey && call_data->flag == 1) {    /* off key */
	/* Here, the end of preediting is notified from the IMlibrary, which
	   happens only if OFF key, which is optional for Dynamic Event Flow,
	   has been registered by IMOpenIM or IMSetIMValues, otherwise,
	   the end of preediting must be notified from the IMserver to the
	   IMlibrary. */
		return True;
	} else {
		/* never happens */
		return False;
	}
}

Boolean ChinputPreeditStartReplyHandler(XIMS ims, IMPreeditCBStruct *call_data)
{
	return True;
}

Boolean ChinputPreeditCaretReplyHandler(XIMS ims, IMPreeditCBStruct *call_data)
{
	return True;
}

Boolean ChinputStrConversionHandler(XIMS ims, IMStrConvCBStruct *call_data)
{
	return True;
}


Boolean ChinputProtoHandler(XIMS ims, IMProtocol *call_data)
{
	switch (call_data->major_code) {
	case XIM_OPEN: 	
		return ChinputOpenHandler(ims, (IMOpenStruct *)call_data);
	case XIM_CLOSE:	
		return ChinputCloseHandler(ims, (IMCloseStruct *)call_data);
	case XIM_CREATE_IC:
		return ChinputCreateICHandler(ims, (IMChangeICStruct *)call_data);
	case XIM_DESTROY_IC:
		return ChinputDestroyICHandler(ims, (IMChangeICStruct *)call_data);
	case XIM_SET_IC_VALUES: 
		return ChinputSetICValuesHandler(ims, (IMChangeICStruct *)call_data);
	case XIM_GET_IC_VALUES: 
		return ChinputGetICValuesHandler(ims, (IMChangeICStruct *)call_data);
	case XIM_FORWARD_EVENT: 
		return ChinputForwardEventHandler(ims, (IMForwardEventStruct *)call_data);
	case XIM_SET_IC_FOCUS:
		return ChinputFocusIn(ims, (IMChangeFocusStruct *)call_data);
	case XIM_UNSET_IC_FOCUS:
		return ChinputFocusOut(ims, (IMChangeFocusStruct *)call_data);
	case XIM_RESET_IC: 	
		return ChinputResetIC(ims, (IMResetICStruct *)call_data);
	case XIM_TRIGGER_NOTIFY:
		return ChinputTriggerNotifyHandler(ims, (IMTriggerNotifyStruct *)call_data);
	case XIM_PREEDIT_START_REPLY: 
		return ChinputPreeditStartReplyHandler(ims, (IMPreeditCBStruct *)call_data);
	case XIM_PREEDIT_CARET_REPLY:
		return ChinputPreeditCaretReplyHandler(ims, (IMPreeditCBStruct *)call_data);
	case XIM_STR_CONVERSION_REPLY:

		return ChinputStrConversionHandler(ims, (IMStrConvCBStruct *)call_data);
	default: 
		printf("Unknown major code.\n");
		break;
	}
	return True;
}

//entry for Chinput
void HZinitXIM(void)
{
	if ((input_styles = (XIMStyles *)malloc(sizeof(XIMStyles))) == NULL) {
        	fprintf(stderr, "Can't allocate\n");
        	return;
    	}
    	input_styles->count_styles = sizeof(Styles)/sizeof(XIMStyle) - 1;
    	input_styles->supported_styles = Styles;

    	if ((on_keys=(XIMTriggerKeys *)malloc(sizeof(XIMTriggerKeys)))==NULL) {
		fprintf(stderr, "Can't allocate\n");
        	return;
    	}
    	on_keys->count_keys = sizeof(Trigger_Keys)/sizeof(XIMTriggerKey) - 1;
    	on_keys->keylist = Trigger_Keys;

    	if ((encodings = (XIMEncodings *)malloc(sizeof(XIMEncodings)))==NULL) {
        	fprintf(stderr, "Can't allocate\n");
        	return;
    	}
    	encodings->count_encodings = sizeof(chEncodings)/sizeof(XIMEncoding)-1;
    	encodings->supported_encodings = chEncodings;

    	if (xim_use_local) {
        	char hostname[64];
        	char *address = "/tmp/.ximsock";
        	gethostname(hostname, 64);
        	sprintf(transport, "local/%s:%s", hostname, address);
    	} else if (xim_use_tcp) {
        	char hostname[64];
        	int port_number = 9010;
        	gethostname(hostname, 64);
        	sprintf(transport, "tcp/%s:%d", hostname, port_number);
    	} else {
        	strcpy(transport, "X/");
    	}

	this_xims = IMOpenIM(display,
		IMServerWindow, 	window1,	//input window
		IMModifiers, 		"Xi18n",	//X11R6 protocol
		IMServerName, 		imname,		//XIM server name
		IMLocale, 		imlocale,	//XIM server locale
		IMServerTransport, 	transport,	//Comm. protocol
		IMInputStyles, 		input_styles,	//faked styles
		IMEncodingList, 	encodings,
		IMProtocolHandler, 	ChinputProtoHandler,
		IMFilterEventMask, 	filter_mask,
		NULL);
	if(this_xims == (XIMS)NULL){
        	fprintf(stderr, "Can't Open Input Method Service:\n");
        	fprintf(stderr, "\tInput Method Name :%s\n", imname);
        	fprintf(stderr, "\tTranport Address:%s\n", transport);
        	return;
	}
/*
	if(xim_use_trigger) {
        	if (xim_use_offkey)
			IMSetIMValues(this_xims,
				IMOnKeysList, 	on_keys,
				IMOffKeysList, 	on_keys,
				NULL);
		else
			IMSetIMValues(this_xims,
				IMOnKeysList, 	on_keys,
				NULL);
	}
*/
}

