/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef tabproject_h
#define tabproject_h

#include "tabbase.h"

class EffectWidget;
class QComboBox;
class QSpinBox;
class QTextEdit;
class TextStyleWidget;


/** The "project" side tab-page.
 */
class TabProject: public TabBase
{
   typedef TabBase Inherited;
   Q_OBJECT

public:
   TabProject(KoverArtist::Project* project, QWidget* parent = 0);
   virtual ~TabProject();

   /** Set the focus to the title edit. */
   virtual void setFocusTitle();

public slots:
   /** Update the widget. */
   virtual void updateContents();

protected slots:
   /** The number of discs was changed. */
   virtual void discsChanged();

   /** Select the idx-th case. */
   virtual void caseSelected(int idx);

   /** Setup the cases combobox. */
   virtual void setupCasesComboBox();

   /** The user changed the title. */
   virtual void titleChanged();

   /** The user changed the sub-title. */
   virtual void subTitleChanged();

private:
   TabProject(const TabProject&);
   TabProject& operator=(const TabProject&);

protected:
   QComboBox *mCboCase;
   QSpinBox *mSpbDiscs;
   TextStyleWidget *mTswTitle, *mTswSubTitle;
   QTextEdit *mEdtTitle, *mEdtSubTitle;
   EffectWidget *mEffTitle;
};

#endif /*tabproject_h*/
