/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef tabdisc_h
#define tabdisc_h

#include "tabbase.h"

class QLineEdit;
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QTextEdit;
namespace KoverArtist { class Disc; }


/** The disc side tab-pages.
 */
class TabDisc: public TabBase
{
   typedef TabBase Inherited;
   Q_OBJECT

public:
   TabDisc(KoverArtist::Project* project, QWidget* parent = 0);
   virtual ~TabDisc();

   /** Get/set the @ref KoverArtist::Disc disc that edited. */
   KoverArtist::Disc* disc() { return mDisc; }
   const KoverArtist::Disc* disc() const { return mDisc; }
   virtual void setDisc(KoverArtist::Disc* disc);

public slots:
   /** Update the widget. */
   virtual void updateContents();

protected slots:
   /** The user selected an item in the list-widget. */
   virtual void itemSelected(QListWidgetItem*);

   /** The user changed the title of the disc. */
   virtual void titleChanged();

   /** The current entry is edited in the entry line-edit. */
   virtual void entryTextEdited(const QString& text);

   /** The user finished editing in the entry line-edit. */
   virtual void entryTextEditFinished();

   /** An entry button was clicked. */
   virtual void newEntry();
   virtual void removeEntry();
   virtual void upEntry();
   virtual void downEntry();

private:
   TabDisc(const TabDisc&);
   TabDisc& operator=(const TabDisc&);

protected:
   KoverArtist::Disc *mDisc;
   QTextEdit *mEdtTitle;
   QLineEdit *mEdtEntry;
   QPushButton *mBtnNew, *mBtnChange, *mBtnRemove, *mBtnUp, *mBtnDown;
   QListWidget *mLstEntries;
};

#endif /*tabdisc_h*/
