/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "case.h"
#include "config.h"
#include "log.h"
#include "mainwindow.h"

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kmessagebox.h>
#include <kurl.h>


int main(int argc, char **argv)
{
   KAboutData about("koverartist", "koverartist", ki18n("KoverArtist"), VERSION,
                    ki18n("A program for cd/dvd cover creation"),
                    KAboutData::License_GPL_V2, ki18n("(C) 2006-2011 Stefan Taferner"),
                    KLocalizedString(),
                    "http://kde-apps.org/content/show.php/KoverArtist?content=38195",
                    "taferner@kde.org"
                   );
   about.addAuthor(ki18n("Stefan Taferner"), ki18n("author"), "taferner@kde.org");

   KCmdLineOptions options;
   options.add("debug", ki18n("Enable debug log output"));
   options.add("trace", ki18n("Enable debug and trace log output"));
   options.add("+[URL]", ki18n("Project to open"));

   KCmdLineArgs::init(argc, argv, &about);
   KCmdLineArgs::addCmdLineOptions(options);
   KApplication app;
   MainWindow *win;

   KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

   if (args->isSet("trace"))
      Logger::setMinLogLevel(LOG_TRACE);
   else if (args->isSet("debug"))
      Logger::setMinLogLevel(LOG_DEBUG);

//    logInfo("PWD: %1").arg(getenv("PWD"));

   if (!KoverArtist::Case::loadCases())
   {
      // The program must terminate here. There is no builtin case, so continuing without cases
      // will result in a crash later on.
      
      KMessageBox::error(0, i18n("Error while loading the case definitions"),
                         i18n("Error")+" - KoverArtist");
      return 1;
   }

   if (args->count() <= 0)
   {
      win = new MainWindow;
      win->show();
   }
   else
   {
      for (int i=0; i<args->count(); ++i)
      {
         win = new MainWindow;
         win->show();
         win->load(args->url(i));
      }
   }

   return app.exec();
}
