
/*
 * WD1003 / ATA Disk Controller register definitions.
 */

/* offsets of registers in the 'regular' register region */
#define wd_data                 0       /* data register (R/W - 16 bits) */
#define wd_error                1       /* error register (R) */
#define wd_seccnt               2       /* sector count (R/W) */
#define wd_sector               3       /* first sector number (R/W) */
#define wd_cyl_lo               4       /* cylinder address, low byte (R/W) */
#define wd_cyl_hi               5       /* cylinder address, high byte (R/W) */
#define wd_sdh                  6       /* sector size/drive/head (R/W) */
#define wd_command              7       /* command register (W) */
#define wd_lba_lo               3       /* lba address, low byte (RW) */
#define wd_lba_mi               4       /* lba address, middle byte (RW) */
#define wd_lba_hi               5       /* lba address, high byte (RW) */

/* "shadow" registers; these may or may not overlap regular registers */
#define wd_status               8       /* immediate status (R) */
#define wd_features             9       /* features (W) */

/* control port */
#define wd_control         (0x1018 >> 2)

/* data port offset */
#define dport_offset       (0x2000 >> 2)

/* gayle registers */
#define gayle_idebase      (0x0000 >> 2) /* A1200 */
#define gayle_idebase2     (0x2020 >> 2) /* A4000 */
#define gayle_intreq       (0x9000 >> 2) /* A1200 */
#define gayle_intreq2      (0x3020 >> 2) /* A4000 */
#define gayle_intena       (0xa000 >> 2)

#define gayle_idedetect      2055

/* offsets of registers in the auxiliary register region */
#define wd_aux_ctlr             0       /* fixed disk controller control (W) */
#define  WDCTL_HOB               0x80   /* read previous content */
#define  WDCTL_4BIT              0x08   /* use four head bits (wd1003) */
#define  WDCTL_RST               0x04   /* reset the controller */
#define  WDCTL_IDS               0x02   /* disable controller interrupts */

/* Status bits. */
#define WDCS_BSY                0x80    /* busy */
#define WDCS_DRDY               0x40    /* drive ready */
#define WDCS_DWF                0x20    /* drive write fault */
#define WDCS_DSC                0x10    /* drive seek complete */
#define WDCS_DRQ                0x08    /* data request */
#define WDCS_CORR               0x04    /* corrected data */
#define WDCS_IDX                0x02    /* index */
#define WDCS_ERR                0x01    /* error */

/* Error bits. */
#define WDCE_BBK                0x80    /* bad block detected */
#define WDCE_CRC                0x80    /* CRC error (Ultra DMA only) */
#define WDCE_UNC                0x40    /* uncorrectable data error */
#define WDCE_MC                 0x20    /* media changed */
#define WDCE_IDNF               0x10    /* id not found */
#define WDCE_MCR                0x08    /* media chagne requested */
#define WDCE_ABRT               0x04    /* aborted command */
#define WDCE_TK0NF              0x02    /* track 0 not found */
#define WDCE_AMNF               0x01    /* address mark not found */

/* Commands for Disk Controller. */
#define WDCC_NOP                0x00    /* Always fail with "aborted command" */
#define WDCC_RECAL              0x10    /* Recalibrate */
#define WDCC_READ               0x20    /* disk read code */
#define WDCC_WRITE              0x30    /* disk write code */
#define WDCC_EXEC_DRIVE_DIAGS   0x90    /* execute device diagnostic */
#define WDCC_IDP                0x91    /* initialize drive parameters */
#define WDCC_READMULTI          0xc4    /* read multiple */
#define WDCC_WRITEMULTI         0xc5    /* write multiple */
#define WDCC_SETMULTI           0xc6    /* set multiple mode */
#define WDCC_READDMA            0xc8    /* read with DMA */
#define WDCC_WRITEDMA           0xca    /* write with DMA */
#define WDCC_ACKMC              0xdb    /* acknowledge media change */
#define WDCC_FLUSHCACHE         0xe7    /* Flush cache */
#define WDCC_FLUSHCACHE_EXT     0xea    /* Flush cache ext */
#define WDCC_IDENTIFY           0xec    /* read parameters from controller */

/* Big Drive support */
#define WDCC_READ_EXT           0x24    /* read 48-bit addressing */
#define WDCC_WRITE_EXT          0x34    /* write 48-bit addressing */
#define WDCC_READMULTI_EXT      0x29    /* read multiple 48-bit addressing */
#define WDCC_WRITEMULTI_EXT     0x39    /* write multiple 48-bit addressing */
#define WDCC_READDMA_EXT        0x25    /* read 48-bit addressing with DMA */
#define WDCC_WRITEDMA_EXT       0x35    /* write 48-bit addressing with DMA */

