 /* 
  * UAE - The Un*x Amiga Emulator
  * 
  * Miscellaneous machine dependent support functions and definitions
  *
  * Copyright 1996 Bernd Schmidt
  */


#include "sysconfig.h"
#include "sysdeps.h"

#include "config.h"
#include "options.h"
#include "machdep/m68k.h"
#include "events.h"

#include <time.h>

/* XXX? */
struct flag_struct regflags;

static struct timeval next;
int frame_started, frame_started_slow;

void real_check_frame_started(void)
{
	struct timeval tv;

	gettimeofday(&tv, NULL);
	if (timercmp(&tv,&next,>=))
		frame_started = 1;

	frame_started_slow = 0;
}

/* This function is called at the start of a frame
 * and starts a timer that indicates when the next
 * frame is supposed to start
 */
void next_frame(int hz)
{
	static double then;
	static int count;
	static int lasthz;

	struct timeval tv, incr;
	double now, dt, frame;

	gettimeofday(&tv, NULL);
	now = tv.tv_sec + tv.tv_usec * 1e-6;

	frame = 1.0 / hz;
	if (hz != lasthz) {
		lasthz = hz;
		dt = 0.0;
		count = 0;
		then = now;
	} else {
		dt = now - then;
		++count;
		if (dt >= frame * count) {
			frame = frame * (count+1) - dt;
			if (frame < 0)
				frame = 0;
		}

		if (count >= 300*hz) {
			then = (now + then)/2;
			count /= 2;
		}
	}

	timerclear(&incr);
	incr.tv_usec = frame * 1e6;

	if (incr.tv_usec) {
		timeradd(&tv, &incr, &next);
		frame_started = 0;
	} else
		frame_started = 1;
}

void machdep_init(void)
{
	frame_started = 1;
}
