/* LANCE Hardware */

#define LE_CSR0         0x0000          /* Control and status register */
#define LE_CSR1         0x0001          /* low address of init block */
#define LE_CSR2         0x0002          /* high address of init block */
#define LE_CSR3         0x0003          /* Bus master and control */

/* Control and status register 0 (csr0) */
#define LE_C0_ERR       0x8000          /* error summary */
#define LE_C0_BABL      0x4000          /* transmitter timeout error */
#define LE_C0_CERR      0x2000          /* collision */
#define LE_C0_MISS      0x1000          /* missed a packet */
#define LE_C0_MERR      0x0800          /* memory error */
#define LE_C0_RINT      0x0400          /* receiver interrupt */
#define LE_C0_TINT      0x0200          /* transmitter interrupt */
#define LE_C0_IDON      0x0100          /* initialization done */
#define LE_C0_INTR      0x0080          /* interrupt condition */
#define LE_C0_INEA      0x0040          /* interrupt enable */
#define LE_C0_RXON      0x0020          /* receiver on */
#define LE_C0_TXON      0x0010          /* transmitter on */
#define LE_C0_TDMD      0x0008          /* transmit demand */
#define LE_C0_STOP      0x0004          /* disable all external activity */
#define LE_C0_STRT      0x0002          /* enable external activity */
#define LE_C0_INIT      0x0001          /* begin initialization */
#define LE_C0_BITS \
    "\20\20ERR\17BABL\16CERR\15MISS\14MERR\13RINT\
\12TINT\11IDON\10INTR\07INEA\06RXON\05TXON\04TDMD\03STOP\02STRT\01INIT"

/* Control and status register 3 (csr3) */
#define LE_C3_BABLM     0x4000          /* babble mask */
#define LE_C3_MISSM     0x1000          /* missed frame mask */
#define LE_C3_MERRM     0x0800          /* memory error mask */
#define LE_C3_RINTM     0x0400          /* receive interrupt mask */
#define LE_C3_TINTM     0x0200          /* transmit interrupt mask */
#define LE_C3_IDONM     0x0100          /* initialization done mask */
#define LE_C3_DXSUFLO   0x0040          /* disable tx stop on underflow */
#define LE_C3_LAPPEN    0x0020          /* look ahead packet processing enbl */
#define LE_C3_DXMT2PD   0x0010          /* disable tx two part deferral */
#define LE_C3_EMBA      0x0008          /* enable modified backoff algorithm */
#define LE_C3_BSWP      0x0004          /* byte swap */
#define LE_C3_ACON      0x0002          /* ALE control, eh? */
#define LE_C3_BCON      0x0001          /* byte control */

#define PORTSEL_AUI     0
#define PORTSEL_10T     1
#define PORTSEL_GPSI    2
#define PORTSEL_MII     3
#define PORTSEL_MASK    3



struct lermd {
	uae_u16		rmd0;
#if BYTE_ORDER == BIG_ENDIAN
	uae_u8		rmd1_bits;
	uae_u8		rmd1_hadr;
#else
	uae_u8		rmd1_hadr;
	uae_u8		rmd1_bits;
#endif
	uae_s16		rmd2;
	uae_u16		rmd3;
};

/* Receive message descriptor 1 (rmd1_bits) */
#define LE_R1_OWN       0x80            /* LANCE owns the packet */
#define LE_R1_ERR       0x40            /* error summary */
#define LE_R1_FRAM      0x20            /* framing error */
#define LE_R1_OFLO      0x10            /* overflow error */
#define LE_R1_CRC       0x08            /* CRC error */
#define LE_R1_BUFF      0x04            /* buffer error */
#define LE_R1_STP       0x02            /* start of packet */
#define LE_R1_ENP       0x01            /* end of packet */
#define LE_R1_BITS \
    "\20\10OWN\7ERR\6FRAM\5OFLO\4CRC\3BUFF\2STP\1ENP"

struct letmd {
	uae_u16		tmd0;
#if BYTE_ORDER == BIG_ENDIAN
	uae_u8		tmd1_bits;
	uae_u8		tmd1_hadr;
#else
	uae_u8		tmd1_hadr;
	uae_u8		tmd1_bits;
#endif
	uae_s16		tmd2;
	uae_u16		tmd3;
};

/* Transmit message descriptor 1 (tmd1_bits) */
#define LE_T1_OWN       0x80            /* LANCE owns the packet */
#define LE_T1_ERR       0x40            /* error summary */
#define LE_T1_MORE      0x10            /* multiple collisions */
#define LE_T1_ONE       0x08            /* single collision */
#define LE_T1_DEF       0x04            /* deferred transmit */
#define LE_T1_STP       0x02            /* start of packet */
#define LE_T1_ENP       0x01            /* end of packet */
#define LE_T1_BITS \
    "\20\10OWN\7ERR\6RES\5MORE\4ONE\3DEF\2STP\1ENP"

/* Transmit message descriptor 3 (tmd3) */
#define LE_T3_BUFF      0x8000          /* buffer error */
#define LE_T3_UFLO      0x4000          /* underflow error */
#define LE_T3_LCOL      0x1000          /* late collision */
#define LE_T3_LCAR      0x0800          /* loss of carrier */
#define LE_T3_RTRY      0x0400          /* retry error */
#define LE_T3_TDR_MASK  0x03ff          /* time domain reflectometry counter */
#define LE_XMD2_ONES    0xf000
#define LE_T3_BITS \
    "\20\20BUFF\17UFLO\16RES\15LCOL\14LCAR\13RTRY"

struct leinit {
	uae_u16		init_mode;
	uae_u16		init_padr[3];
	uae_u16		init_ladrf[4];
	uae_u16		init_rdra;
	uae_u16		init_rlen;
	uae_u16		init_tdra;
	uae_u16		init_tlen;
	uae_u16		pad0[4];
};

/* Initialization block (mode) */
#define LE_MODE_PROM    0x8000          /* promiscuous mode */
/*                      0x7f80             reserved, must be zero */
/* 0x4000 - 0x0080 are not available on LANCE 7990 */
#define LE_MODE_DRCVBC  0x4000          /* disable receive brodcast */
#define LE_MODE_DRCVPA  0x2000          /* disable physical address detection */
#define LE_MODE_DLNKTST 0x1000          /* disable link status */
#define LE_MODE_DAPC    0x0800          /* disable automatic polarity correction
 */
#define LE_MODE_MENDECL 0x0400          /* MENDEC loopback mode */
#define LE_MODE_LRTTSEL 0x0200          /* lower receive threshold /
                                           transmit mode selection */
#define LE_MODE_PSEL1   0x0100          /* port selection bit1 */
#define LE_MODE_PSEL0   0x0080          /* port selection bit0 */
#define LE_MODE_INTL    0x0040          /* internal loopback */
#define LE_MODE_DRTY    0x0020          /* disable retry */
#define LE_MODE_COLL    0x0010          /* force a collision */
#define LE_MODE_DTCR    0x0008          /* disable transmit CRC */
#define LE_MODE_LOOP    0x0004          /* loopback mode */
#define LE_MODE_DTX     0x0002          /* disable transmitter */
#define LE_MODE_DRX     0x0001          /* disable receiver */
#define LE_MODE_NORMAL  0               /* none of the above */

/*
 * Chip ID (CSR88 IDL, CSR89 IDU) values for various AMD PCnet parts.
 */
#define CHIPID_MANFID(x)        (((x) >> 1) & 0x3ff)
#define CHIPID_PARTID(x)        (((x) >> 12) & 0xffff)
#define CHIPID_VER(x)           (((x) >> 28) & 0x7)

#define PARTID_Am79c960         0x0003
#define PARTID_Am79c961         0x2260
#define PARTID_Am79c961A        0x2261
#define PARTID_Am79c965         0x2430  /* yes, these... */
#define PARTID_Am79c970         0x2430  /* ...are the same */
#define PARTID_Am79c970A        0x2621
#define PARTID_Am79c971         0x2623
#define PARTID_Am79c972         0x2624
#define PARTID_Am79c973         0x2625
#define PARTID_Am79c978         0x2626
#define PARTID_Am79c975         0x2627
#define PARTID_Am79c976         0x2628

void lance_install(void);
void add_lance(const char *);
int lance_tick(void);

