/* 68040/68060 MMU */

#define MMU_TEST_PTEST		1
#define MMU_TEST_NO_BUSERR	8

#define MMU_PAGE_8KB	1
#define MMU_PAGE_4KB	0

#define MMU_TTR_LOGICAL_BASE				0xff000000
#define MMU_TTR_LOGICAL_MASK				0x00ff0000
#define MMU_TTR_BIT_ENABLED					(1 << 15)
#define MMU_TTR_BIT_SFIELD_ENABLED			(1 << 14)
#define MMU_TTR_BIT_SFIELD_SUPER			(1 << 13)
#define MMU_TTR_SFIELD_SHIFT				13
#define MMU_TTR_UX_MASK						((1 << 9) | (1 << 8))
#define MMU_TTR_UX_SHIFT					8
#define MMU_TTR_CACHE_MASK				((1 << 6) | (1 << 5))
#define MMU_TTR_CACHE_SHIFT						5
#define MMU_TTR_BIT_WRITE_PROTECT				(1 << 2)

#define MMU_UDT_MASK	3
#define MMU_PDT_MASK	3

#define MMU_DES_WP			4
#define MMU_DES_USED		8

/* page descriptors only */
#define MMU_DES_MODIFIED	16
#define MMU_DES_SUPER		(1 << 7)
#define MMU_DES_GLOBAL		(1 << 10)

#define MMU_ROOT_PTR_ADDR_MASK				0xfffffe00
#define MMU_PTR_PAGE_ADDR_MASK_8			0xffffff80
#define MMU_PTR_PAGE_ADDR_MASK_4			0xffffff00

#define MMU_PAGE_INDIRECT_MASK				0xfffffffc
#define MMU_PAGE_ADDR_MASK_8				0xffffe000
#define MMU_PAGE_ADDR_MASK_4				0xfffff000
#define MMU_PAGE_UR_MASK_8					((1 << 12) | (1 << 11))
#define MMU_PAGE_UR_MASK_4					(1 << 11)
#define MMU_PAGE_UR_SHIFT					11

#define MMU_MMUSR_ADDR_MASK	0xfffff000
#define MMU_MMUSR_B			(1 << 11)
#define MMU_MMUSR_G			(1 << 10)
#define MMU_MMUSR_U1		(1 << 9)
#define MMU_MMUSR_U0		(1 << 8)
#define MMU_MMUSR_S			(1 << 7)
#define MMU_MMUSR_CM		(1 << 6) | ( 1 << 5)
#define MMU_MMUSR_M			(1 << 4)
#define MMU_MMUSR_W			(1 << 2)
#define MMU_MMUSR_R			(1 << 1)
#define MMU_MMUSR_T			(1 << 0)

/* special status word */
#define SSW4_CP         0x8000
#define SSW4_CU         0x4000
#define SSW4_CT         0x2000
#define SSW4_CM         0x1000
#define SSW4_MA         0x0800
#define SSW4_ATC        0x0400
#define SSW4_LK         0x0200
#define SSW4_RW         0x0100
#define SSW4_WBSV       0x0080  /* really in WB status, not SSW */

#define SSW4_SZSHFT     5
#define SSW4_SZMASK     0x0060

#define SSW4_SZLW       0x0000
#define SSW4_SZB        0x0020
#define SSW4_SZW        0x0040
#define SSW4_SZLN       0x0060
#define SSW4_TTMASK     0x0018
#define SSW4_TTNOR      0x0000
#define SSW4_TTM16      0x0008
#define SSW4_TMMASK     0x0007
#define SSW4_TMDCP      0x0000
#define SSW4_TMUD       0x0001
#define SSW4_TMUC       0x0002
#define SSW4_TMKD       0x0005
#define SSW4_TMKC       0x0006

/* Fault Status Long Word */
#define FSLW_MA         0x08000000
#define FSLW_LK         0x02000000
#define FSLW_RW         0x01800000
#define FSLW_RW_R       0x01000000
#define FSLW_RW_W       0x00800000
#define FSLW_SIZE       0x00600000
#define FLSW_TT         0x00180000
#define FLSW_TT1        0x00100000
#define FLSW_TT0        0x00080000
#define FSLW_TM         0x00070000
#define FSLW_TM_SV      0x00040000
#define FSLW_IO         0x00008000
#define FSLW_PBE        0x00004000
#define FSLW_SBE        0x00002000
#define FSLW_PTA        0x00001000
#define FSLW_PTB        0x00000800
#define FSLW_IL         0x00000400
#define FSLW_PF         0x00000200
#define FSLW_SP         0x00000100
#define FSLW_WP         0x00000080
#define FSLW_TWE        0x00000040
#define FSLW_RE         0x00000020
#define FSLW_WE         0x00000010
#define FSLW_TTR        0x00000008
#define FSLW_BPE        0x00000004
#define FSLW_SEE        0x00000001


struct mmu_atc_line	{
	uaecptr		log;
	unsigned		v;
	unsigned		g;
	unsigned		s;
	unsigned		m;
	unsigned		w;
	unsigned		r;
	unsigned		fc2;   /* super-bit only */
	uaecptr		phys;
};

extern int mmu_berr;

#define TTR_I0	4
#define TTR_I1	5
#define TTR_D0	6
#define TTR_D1	7

typedef enum {
	NO_MATCH, OK_MATCH,
	NO_READ, NO_WRITE, NO_SUPER,
	OK_UPDATE
} mmu_rc_t;

void mmu_make_transparent_region(uaecptr baseaddr, uae_u32 size, int fc);

void mmu_set_tc(uae_u16 tc);
void mmu_set_root_pointer(int regno, uae_u32 val);
void mmu_set_ttr(int regno, uae_u32 val);

STATIC_INLINE void mmu_set_mmusr(uae_u32 val)
{
	regs.mmusr = val;
}


#define phys_get_long(addr)	longget_1(addr)
#define phys_get_word(addr)	wordget_1(addr)
#define phys_get_byte(addr)	byteget_1(addr)
#define phys_put_long(addr,l)	longput_1(addr,l)
#define phys_put_word(addr,w)	wordput_1(addr,w)
#define phys_put_byte(addr,b)	byteput_1(addr,b)

void mmu_init(void);
void mmu_dump_atc(void);
void mmu_dump_tables(void);
void mmu_change_fc(void) REGPARAM;

uae_u32 mmu_get_ilong(uaecptr addr) REGPARAM;
uae_u16 mmu_get_iword(uaecptr addr) REGPARAM;
uae_u8 mmu_get_ibyte(uaecptr addr) REGPARAM;
uae_u32 mmu_get_long(uaecptr addr) REGPARAM;
uae_u16 mmu_get_word(uaecptr addr) REGPARAM;
uae_u8 mmu_get_byte(uaecptr addr) REGPARAM;
void mmu_put_long(uaecptr addr, uae_u32 l) REGPARAM;
void mmu_put_word(uaecptr addr, uae_u16 w) REGPARAM;
void mmu_put_byte(uaecptr addr, uae_u16 b) REGPARAM;

uae_u8 *get_real_address(uaecptr addr) REGPARAM;
uae_u8 *get_real_iaddress(uaecptr addr) REGPARAM;
int valid_address(uaecptr addr, uae_u32 size) REGPARAM;
uae_u32 sfc_get_long(uaecptr addr) REGPARAM;
uae_u16 sfc_get_word(uaecptr addr) REGPARAM;
uae_u8 sfc_get_byte(uaecptr addr) REGPARAM;
void dfc_put_long(uaecptr addr, uae_u32 l) REGPARAM;
void dfc_put_word(uaecptr addr, uae_u16 w) REGPARAM;
void dfc_put_byte(uaecptr addr, uae_u16 b) REGPARAM;

