#include <sys/endian.h>

#if BYTE_ORDER == LITTLE_ENDIAN
#define w(x,n) ((n)-1-(x))
#else
#define w(x,n) (x)
#endif
#define h16(x) (((x) & 0xffff0000) >> 16)
#define l16(x) (((x) & 0xffff) << 16)

STATIC_INLINE double to_single (uae_u32 value)
{
    union {
        float f;
        uae_u32 u;
    } val;

    val.u = value;
    return val.f;
}

STATIC_INLINE uae_u32 from_single (double src)
{
    union {
        float f;
        uae_u32 u;
    } val;

    val.f = src;
    return val.u;
}

STATIC_INLINE double to_double(uae_u32 wrd1, uae_u32 wrd2)
{
    union {
        double d;
        uae_u32 u[2];
    } val;

    val.u[w(0,2)] = wrd1;
    val.u[w(1,2)] = wrd2;
    return val.d;
}

STATIC_INLINE void from_double(double src, uae_u32 * wrd1, uae_u32 * wrd2)
{
    union {
        double d;
        uae_u32 u[2];
    } val;

    val.d = src;
    *wrd1 = val.u[w(0,2)];
    *wrd2 = val.u[w(1,2)];
}

STATIC_INLINE long double to_exten(uae_u32 wrd1, uae_u32 wrd2, uae_u32 wrd3)
{
    union {
        long double d;
        uae_u32 u[3];
    } val;

    val.u[w(0,3)] = h16(wrd1);
    val.u[w(1,3)] = wrd2;
    val.u[w(2,3)] = wrd3;
    return val.d;
}

STATIC_INLINE void from_exten(long double src, uae_u32 * wrd1, uae_u32 * wrd2, uae_u32 *wrd3)
{
    union {
        long double d;
        uae_u32 u[3];
    } val;

    val.d = src;
    *wrd1 = l16(val.u[w(0,3)]);
    *wrd2 = val.u[w(1,3)];
    *wrd3 = val.u[w(2,3)];
}

#undef w
#undef h16
#undef l16
