/******************************************************************************/
/* Copyright (c) 2008 Patrick Mahoney <pat@polycrystal.org>.		      */
/* All rights reserved.							      */
/* 									      */
/* Redistribution and use in source and binary forms, with or without	      */
/* modification, are permitted provided that the following conditions	      */
/* are met:								      */
/* 1. Redistributions of source code must retain the above copyright	      */
/*    notice, this list of conditions and the following disclaimer.	      */
/* 2. Redistributions in binary form must reproduce the above copyright	      */
/*    notice, this list of conditions and the following disclaimer in the     */
/*    documentation and/or other materials provided with the distribution.    */
/* 3. Neither the name of the author nor the names of contributors	      */
/*    may be used to endorse or promote products derived from this software   */
/*    without specific prior written permission.			      */
/* 									      */
/* THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND    */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE      */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE */
/* ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE   */
/* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL */
/* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS    */
/* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)      */
/* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT */
/* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     */
/* SUCH DAMAGE.								      */
/******************************************************************************/
/*  Modified by Don Hayford, Feb 2009
 */

#ifndef JPEG_MANGLE_H
#define JPEG_MANGLE_H

#include <stdlib.h>

typedef enum {FALSE, TRUE} bool;

typedef enum {
	JPEG_MANGLE_ERROR_NOT_JPEG,
	JPEG_MANGLE_ERROR_HUFFMAN_DEFINED,
	JPEG_MANGLE_ERROR_NOT_FOUND
} JpegMangleError;

extern bool jpeg_mangle_get_huffman_offset(unsigned char *, size_t, size_t *);
extern const unsigned char * jpeg_mangle_get_default_huffman_tables(void);
extern size_t jpeg_mangle_get_sizeof_default_huffman_tables(void);

#endif /* JPEG_MANGLE_H */
