#ifndef _SCHEMA_SELECTION_PAGE_H_
#define _SCHEMA_SELECTION_PAGE_H_

#include "grtui/wizard_schema_filter_page.h"

class SchemaSelectionPage : public WizardSchemaFilterPage
{
public:
  SchemaSelectionPage(WizardForm *form, const char *name= "pickSchemata")
    : WizardSchemaFilterPage(form, name), _dbplugin(0)
  {
    set_short_title(_("Select Schemata"));
    set_title(_("Select Schemata to Reverse Engineer"));
    
    add(&_missing_label, false, true);
    _missing_label.show(false);
  }

  virtual void leave(bool advancing)
  {
    if (advancing)
    {
      grt::StringListRef list(_form->grtm()->get_grt());
      std::vector<std::string> selection= _check_list.get_selection();

      for (std::vector<std::string>::const_iterator iter= _schemas.begin();
           iter != _schemas.end(); ++iter)
        if (std::find(selection.begin(),selection.end(),*iter) == selection.end())
          list.insert(*iter);
      values().set("unSelectedSchemata", list);
    }
    WizardSchemaFilterPage::leave(advancing);
  }

  virtual void enter(bool advancing)
  {
    if (advancing)
    {
      _schemas.clear();
      grt::ListRef<db_Schema> schemata(_dbplugin->model_catalog()->schemata());
      GRTLIST_FOREACH(db_Schema, schemata, schema)
        _schemas.push_back((*schema)->name());

      WizardSchemaFilterPage::enter(advancing);
      
      for (std::vector<std::string>::const_iterator iter= _schemas.begin();
           iter != _schemas.end(); ++iter)
        _check_list.set_selected(*iter, true);    
    }
  }
  
  void set_db_plugin(Db_plugin *pl)
  {
    _dbplugin= pl;
  }
  
private:
  std::vector<std::string> _schemas;
  Db_plugin *_dbplugin;
  mforms::Label _missing_label;
};


#endif /* _SCHEMA_SELECTION_PAGE_H_ */
