/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_TREENODEVIEW_H_
#define _STUB_TREENODEVIEW_H_

#include "stub_view.h"
#include "stub_treenode.h"

namespace mforms {
namespace stub {


class TreeNodeViewImpl : public ViewImpl
{
private:
  TreeNodeImpl *_root;

  TreeNodeViewImpl(TreeNodeView *self, mforms::TreeOptions opts)
      : ViewImpl(self)
  {
    _root = new TreeNodeImpl();

    self->set_data(this);
  }

  int add_column(TreeColumnType type, const std::string &name, int initial_width, bool editable)
  {
    return 0;
  }

  void end_columns()
  {
  }

  static bool __stdcall create(TreeNodeView *self, mforms::TreeOptions opt)
  {
    TreeNodeViewImpl *ptree_node_view = new TreeNodeViewImpl(self, opt);
    return true;
  }

  static int __stdcall add_column(TreeNodeView *self, TreeColumnType type, const std::string &name, int width, bool editable)
  {
    return 0;
  }
  static void __stdcall end_columns(TreeNodeView *self)
  {
  }
  static void __stdcall clear(TreeNodeView *self)
  {
  }
  static TreeSelectionMode __stdcall get_selection_mode(TreeNodeView *self)
  {
    return TreeSelectSingle;
  }
  static void __stdcall set_selection_mode(TreeNodeView *self, TreeSelectionMode mode)
  {
  }
  static TreeNodeRef __stdcall get_selected_node(TreeNodeView *self)
  {
    return TreeNodeRef();
  }
  static TreeNodeRef __stdcall root_node(TreeNodeView *self)
  {
    TreeNodeViewImpl *ptree_node_view = self->get_data<TreeNodeViewImpl>();
    return ptree_node_view->root_node();
  }

  TreeNodeRef root_node()
  {
    return mforms::TreeNodeRef(_root);
  }

  static std::list<TreeNodeRef> __stdcall get_selection(TreeNodeView *self)
  {
    return std::list<TreeNodeRef>();
  }

  static void __stdcall set_selected(TreeNodeView* self, TreeNodeRef node, bool flag)
  {
  }

  static void __stdcall set_allow_sorting(TreeNodeView *self, bool)
  {
  }

  static void __stdcall freeze_refresh(TreeNodeView *self, bool)
  {
  }

  static int __stdcall row_for_node(TreeNodeView *self, TreeNodeRef node)
  {
    return 0;
  }

  static TreeNodeRef __stdcall node_at_row(TreeNodeView *self, int row)
  {
    return self->root_node();
  }

  static void __stdcall set_row_height(TreeNodeView *self, int height)
  {
  }

  static void __stdcall clear_selection(TreeNodeView *self)
  {
  }

  static TreeNodeRef  __stdcall node_with_tag(TreeNodeView *self, const std::string &tag)
  {
      return self->root_node();
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_treenodeview_impl.create= &TreeNodeViewImpl::create;
    f->_treenodeview_impl.add_column= &TreeNodeViewImpl::add_column;
    f->_treenodeview_impl.end_columns= &TreeNodeViewImpl::end_columns;
    f->_treenodeview_impl.clear= &TreeNodeViewImpl::clear;
    f->_treenodeview_impl.get_selected_node= &TreeNodeViewImpl::get_selected_node;
    f->_treenodeview_impl.set_selected= &TreeNodeViewImpl::set_selected;
    f->_treenodeview_impl.get_selection= &TreeNodeViewImpl::get_selection;
    f->_treenodeview_impl.set_allow_sorting = &TreeNodeViewImpl::set_allow_sorting;
    f->_treenodeview_impl.freeze_refresh = &TreeNodeViewImpl::freeze_refresh;
    f->_treenodeview_impl.set_selection_mode = &TreeNodeViewImpl::set_selection_mode;
    f->_treenodeview_impl.get_selection_mode = &TreeNodeViewImpl::get_selection_mode;
    f->_treenodeview_impl.root_node = &TreeNodeViewImpl::root_node;
    f->_treenodeview_impl.node_at_row = &TreeNodeViewImpl::node_at_row;
    f->_treenodeview_impl.row_for_node = &TreeNodeViewImpl::row_for_node;
    f->_treenodeview_impl.set_row_height = &TreeNodeViewImpl::set_row_height;
    f->_treenodeview_impl.clear_selection = &TreeNodeViewImpl::clear_selection;
    f->_treenodeview_impl.node_with_tag = &TreeNodeViewImpl::node_with_tag;
  }
};

  
}
}

#endif
