using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MySQL.Utilities;
using MySQL.GUI.Workbench.Properties;

namespace MySQL.GUI.Workbench
{
  public partial class WorkbenchSplashScreen : Form, ISplashScreen
  {
    protected bool closeOnClick = false;
    private const int CS_DROPSHADOW = 0x00020000;

    public WorkbenchSplashScreen()
    {
      InitializeComponent();
      
      string revision = Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.Revision);
      string releaseType = Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.ReleaseType);

      versionLabel.Text = String.Format("{0} {1}",
        Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.Version),
        Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.Configuration));

      if(releaseType.Length == 0)
        revisionLabel.Text = String.Format("Revision {0}", revision);
      else
        revisionLabel.Text = String.Format("Revision {0} {1}", revision, releaseType);

      BackgroundImage = Resources.wb_splashscreen_oss;
    }

    public WorkbenchSplashScreen(bool CloseOnClick) : this()
    {
      closeOnClick = CloseOnClick;
    }

    public void SetSplashScreenStatusInfo(string NewStatusInfo)
    {
      //
    }

    private void WorkbenchSplashScreen_Click(object sender, EventArgs e)
    {
      if (closeOnClick)
        Close();
    }

    private void WorkbenchSplashScreen_KeyPress(object sender, KeyPressEventArgs e)
    {
      if (e.KeyChar == 3)
      {
        // Ctrl+C pressed.
        Clipboard.SetText(
          String.Format("{0} ({1})", versionLabel.Text, revisionLabel.Text));
        e.Handled = true;
      }
    }

    protected override CreateParams CreateParams
    {
      get
      {
        CreateParams p = base.CreateParams;
        p.ClassStyle |= CS_DROPSHADOW;
        return p;
      }
    }
  }
}
