using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using MySQL.Utilities.Properties;

namespace MySQL.Utilities
{
  public enum MySQLTaskStatusLabelState { TaskOpen, TaskCompleted, TaskError, TaskDisabled };

  public partial class MySQLTaskStatusLabel : UserControl
  {
    #region Member Variables

    private MySQLTaskStatusLabelState taskState = MySQLTaskStatusLabelState.TaskDisabled;

    #endregion

    #region Constructor

    public MySQLTaskStatusLabel()
    {
      InitializeComponent();

      TaskState = MySQLTaskStatusLabelState.TaskOpen;
    }

    #endregion

    #region Properties

    [Category("Appearance")]
    [EditorBrowsable(EditorBrowsableState.Always)]
    [Browsable(true)]
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
    [Bindable(true)]
    [Description("The caption of the label.")]
    public override string Text
    {
      get { return taskLabel.Text; }
      set { taskLabel.Text = value; }
    }

    [Bindable(true), Category("Behavior"),
    Description("The state of the task.")]
    public MySQLTaskStatusLabelState TaskState
    {
      get { return taskState; }
      set
      {
        if (taskState != value)
        {
          switch (value)
          {
            case MySQLTaskStatusLabelState.TaskOpen:
              taskPictureBox.Image = Resources.task_unchecked;
              break;
            case MySQLTaskStatusLabelState.TaskCompleted:
              taskPictureBox.Image = Resources.task_checked;
              break;
            case MySQLTaskStatusLabelState.TaskError:
              taskPictureBox.Image = Resources.task_error;
              break;
            default:
              taskPictureBox.Image = Resources.task_disabled;
              break;
          }
          taskState = value;
        }
      }
    }

    #endregion
  }
}
