/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#import <Cocoa/Cocoa.h>

namespace grt
{
  class BaseListRef;
  class Module;
}
namespace bec
{
  class GRTManager;
  class BaseEditor;
}

//! Base class for editor plugins. Must return the view to be docked in the main window
//! in dockableView.
@interface WBPluginEditorBase : NSViewController {
  NSSize mMinumumSize;
  bec::GRTManager *_grtm; // must be assigned by subnodes

  IBOutlet NSButton *mApplyButton;
  IBOutlet NSButton *mRevertButton;
}

- (bec::GRTManager*)grtManager; 

- (id)identifier;
- (NSString*)title;
- (NSImage*)titleIcon;
- (void)updateTitle:(NSString*)title;

- (void)reinitWithArguments:(const grt::BaseListRef&)args;

- (void)refresh;

- (void)setCompactMode:(BOOL)flag;
- (BOOL)enableLiveChangeButtons;

- (void)setMinimumSize:(NSSize)size;
- (NSSize)minimumSize;

- (bec::BaseEditor*)editorBE;

- (BOOL)matchesIdentifierForClosingEditor:(NSString*)identifier;

- (void)pluginDidShow:(id)sender;
- (BOOL)pluginWillClose:(id)sender;

- (void)applyLiveChanges:(id)sender;
- (void)revertLiveChanges:(id)sender;

- (void)setupEditorOnHost: (NSView*)host withSyntaxSupport: (BOOL)syntaxCheck;

@end
