/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef _EOL_FORMAT_DIALOG_H_
#define _EOL_FORMAT_DIALOG_H_


#include <mforms/form.h>
#include "wbpublic_public_interface.h"
#include "base/string_utilities.h"

namespace mforms {
  class Selector;
  class Button;
}

class WBPUBLICBACKEND_PUBLIC_FUNC EolFormatDialog : public mforms::Form
{
public:
  EolFormatDialog(const std::string &title, const std::string &message, base::EolHelpers::Eol_format default_eol_format= base::EolHelpers::default_eol_format());

public:
  bool run();

public:
  base::EolHelpers::Eol_format eol_format();

private:
  mforms::Selector* _eol_format_selector;
  mforms::Button* _ok_btn;
  mforms::Button* _cancel_btn;
};


#endif /* _EOL_FORMAT_DIALOG_H_ */
