# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

from .host_scan_agent_configuration import HostScanAgentConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostScanAgentConfigurationOCI(HostScanAgentConfiguration):
    """
    Agent configuration options for the OCI host scan agent
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostScanAgentConfigurationOCI object with values from keyword arguments. The default value of the :py:attr:`~oci.vulnerability_scanning.models.HostScanAgentConfigurationOCI.vendor` attribute
        of this class is ``OCI`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vendor:
            The value to assign to the vendor property of this HostScanAgentConfigurationOCI.
            Allowed values for this property are: "OCI"
        :type vendor: str

        :param cis_benchmark_settings:
            The value to assign to the cis_benchmark_settings property of this HostScanAgentConfigurationOCI.
        :type cis_benchmark_settings: oci.vulnerability_scanning.models.HostCisBenchmarkSettings

        :param endpoint_protection_settings:
            The value to assign to the endpoint_protection_settings property of this HostScanAgentConfigurationOCI.
        :type endpoint_protection_settings: oci.vulnerability_scanning.models.HostEndpointProtectionSettings

        """
        self.swagger_types = {
            'vendor': 'str',
            'cis_benchmark_settings': 'HostCisBenchmarkSettings',
            'endpoint_protection_settings': 'HostEndpointProtectionSettings'
        }

        self.attribute_map = {
            'vendor': 'vendor',
            'cis_benchmark_settings': 'cisBenchmarkSettings',
            'endpoint_protection_settings': 'endpointProtectionSettings'
        }

        self._vendor = None
        self._cis_benchmark_settings = None
        self._endpoint_protection_settings = None
        self._vendor = 'OCI'

    @property
    def cis_benchmark_settings(self):
        """
        Gets the cis_benchmark_settings of this HostScanAgentConfigurationOCI.

        :return: The cis_benchmark_settings of this HostScanAgentConfigurationOCI.
        :rtype: oci.vulnerability_scanning.models.HostCisBenchmarkSettings
        """
        return self._cis_benchmark_settings

    @cis_benchmark_settings.setter
    def cis_benchmark_settings(self, cis_benchmark_settings):
        """
        Sets the cis_benchmark_settings of this HostScanAgentConfigurationOCI.

        :param cis_benchmark_settings: The cis_benchmark_settings of this HostScanAgentConfigurationOCI.
        :type: oci.vulnerability_scanning.models.HostCisBenchmarkSettings
        """
        self._cis_benchmark_settings = cis_benchmark_settings

    @property
    def endpoint_protection_settings(self):
        """
        Gets the endpoint_protection_settings of this HostScanAgentConfigurationOCI.

        :return: The endpoint_protection_settings of this HostScanAgentConfigurationOCI.
        :rtype: oci.vulnerability_scanning.models.HostEndpointProtectionSettings
        """
        return self._endpoint_protection_settings

    @endpoint_protection_settings.setter
    def endpoint_protection_settings(self, endpoint_protection_settings):
        """
        Sets the endpoint_protection_settings of this HostScanAgentConfigurationOCI.

        :param endpoint_protection_settings: The endpoint_protection_settings of this HostScanAgentConfigurationOCI.
        :type: oci.vulnerability_scanning.models.HostEndpointProtectionSettings
        """
        self._endpoint_protection_settings = endpoint_protection_settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
