/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DictionaryImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.TableImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbInterpretedCode;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;

class DbImpl
implements Db {
    static final I18NHelper local = I18NHelper.getInstance(DbImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbImpl.class);
    private Ndb ndb;
    private int errorBufferSize = 300;
    private ByteBuffer errorBuffer = ByteBuffer.allocateDirect(this.errorBufferSize);
    private static final int COORDINATED_TRANSACTION_ID_SIZE = 44;
    private ByteBuffer coordinatedTransactionIdBuffer = ByteBuffer.allocateDirect(44);
    private ByteBuffer partitionKeyScratchBuffer = ByteBuffer.allocateDirect(10000);
    private BufferManager bufferManager = new BufferManager();
    private NdbDictionary.Dictionary ndbDictionary;
    private DictionaryImpl dictionary;
    private ClusterConnectionImpl clusterConnection;
    private boolean closing = false;
    private ClusterTransaction clusterTransaction;
    private int numberOfIndexBoundCreated;
    private int numberOfIndexBoundDeleted;
    private int numberOfInterpretedCodeCreated;
    private int numberOfInterpretedCodeDeleted;
    private int numberOfNdbScanFilterCreated;
    private int numberOfNdbScanFilterDeleted;
    private int numberOfScanOptionsCreated;
    private int numberOfScanOptionsDeleted;
    private int autoIncrementBatchSize;
    private long autoIncrementStep;
    private long autoIncrementStart;

    public DbImpl(ClusterConnectionImpl clusterConnectionImpl, Ndb ndb, int n) {
        this.clusterConnection = clusterConnectionImpl;
        this.ndb = ndb;
        int n2 = ndb.init(n);
        this.handleError(n2, ndb);
        this.ndbDictionary = ndb.getDictionary();
        this.handleError(this.ndbDictionary, ndb);
        this.dictionary = new DictionaryImpl(this.ndbDictionary, clusterConnectionImpl);
    }

    protected void assertOpen(String string) {
        if (this.closing || this.ndb == null) {
            throw new ClusterJUserException(local.message("ERR_Db_Is_Closing", (Object)string));
        }
    }

    protected void closing() {
        this.closing = true;
    }

    @Override
    public void close() {
        if (this.numberOfIndexBoundCreated != this.numberOfIndexBoundDeleted) {
            logger.warn("numberOfIndexBoundCreated " + this.numberOfIndexBoundCreated + " != numberOfIndexBoundDeleted " + this.numberOfIndexBoundDeleted);
        }
        if (this.numberOfInterpretedCodeCreated != this.numberOfInterpretedCodeDeleted) {
            logger.warn("numberOfInterpretedCodeCreated " + this.numberOfInterpretedCodeCreated + " != numberOfInterpretedCodeDeleted " + this.numberOfInterpretedCodeDeleted);
        }
        if (this.numberOfNdbScanFilterCreated != this.numberOfNdbScanFilterDeleted) {
            logger.warn("numberOfNdbScanFilterCreated " + this.numberOfNdbScanFilterCreated + " != numberOfNdbScanFilterDeleted " + this.numberOfNdbScanFilterDeleted);
        }
        if (this.numberOfScanOptionsCreated != this.numberOfScanOptionsDeleted) {
            logger.warn("numberOfScanOptionsCreated " + this.numberOfScanOptionsCreated + " != numberOfScanOptionsDeleted " + this.numberOfScanOptionsDeleted);
        }
        if (this.clusterTransaction != null) {
            if (this.clusterTransaction.isEnlisted()) {
                throw new ClusterJUserException(local.message("ERR_Cannot_close_active_transaction"));
            }
            this.clusterTransaction.close();
            this.clusterTransaction = null;
        }
        if (this.ndb != null) {
            Ndb.delete(this.ndb);
            this.ndb = null;
        }
        this.clusterConnection.close(this);
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }

    @Override
    public ClusterTransaction startTransaction(String string) {
        this.assertOpen("startTransaction");
        this.clusterTransaction = new ClusterTransactionImpl(this.clusterConnection, this, this.ndbDictionary, string);
        return this.clusterTransaction;
    }

    protected void handleError(int n, Ndb ndb) {
        if (n == 0) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(n, ndbErrorConst, string);
    }

    protected void handleError(Object object, Ndb ndb) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    @Override
    public boolean isRetriable(ClusterJDatastoreException clusterJDatastoreException) {
        return Utility.isRetriable(clusterJDatastoreException);
    }

    public String getNdbErrorDetail(NdbErrorConst ndbErrorConst) {
        return this.ndb.getNdbErrorDetail(ndbErrorConst, this.errorBuffer, this.errorBuffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbTransaction enlist(String string, List<KeyPart> list) {
        if (list == null || list.size() <= 0) {
            throw new ClusterJFatalInternalException(local.message("ERR_Key_Parts_Must_Not_Be_Null_Or_Zero_Length", (Object)string));
        }
        int n = list.size();
        NdbTransaction ndbTransaction = null;
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string);
        this.handleError(tableConst, this.ndb);
        Ndb.Key_part_ptrArray key_part_ptrArray = null;
        if (n == 1) {
            ByteBuffer byteBuffer = list.get((int)0).buffer;
            int n2 = list.get((int)0).length;
            ndbTransaction = this.ndb.startTransaction(tableConst, byteBuffer, n2);
            if (ndbTransaction == null) {
                logger.warn(local.message("ERR_Transaction_Start_Failed", string, byteBuffer.position(), byteBuffer.limit(), byteBuffer.capacity(), n2));
            }
            this.handleError(ndbTransaction, this.ndb);
            return ndbTransaction;
        }
        key_part_ptrArray = Ndb.Key_part_ptrArray.create(n + 1);
        try {
            Ndb.Key_part_ptr key_part_ptr;
            for (int i = 0; i < n; ++i) {
                key_part_ptr = key_part_ptrArray.at(i);
                key_part_ptr.ptr(list.get((int)i).buffer);
                key_part_ptr.len(list.get((int)i).length);
            }
            key_part_ptr = key_part_ptrArray.at(n);
            key_part_ptr.ptr(null);
            key_part_ptr.len(0);
            ndbTransaction = this.ndb.startTransaction(tableConst, key_part_ptrArray, this.partitionKeyScratchBuffer, this.partitionKeyScratchBuffer.capacity());
            this.handleError(ndbTransaction, this.ndb);
            NdbTransaction ndbTransaction2 = ndbTransaction;
            return ndbTransaction2;
        }
        finally {
            Ndb.Key_part_ptrArray.delete(key_part_ptrArray);
        }
    }

    public NdbTransaction enlist(String string, int n) {
        NdbTransaction ndbTransaction = null;
        if (string == null) {
            ndbTransaction = this.ndb.startTransaction(null, null, 0);
        } else {
            NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string);
            ndbTransaction = this.ndb.startTransaction(tableConst, n);
        }
        this.handleError(ndbTransaction, this.ndb);
        return ndbTransaction;
    }

    public ByteBuffer getCoordinatedTransactionIdBuffer() {
        return this.coordinatedTransactionIdBuffer;
    }

    public NdbTransaction joinTransaction(String string) {
        if (logger.isDetailEnabled()) {
            logger.detail("CoordinatedTransactionId: " + string);
        }
        throw new ClusterJFatalInternalException("Not Implemented");
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public NdbRecordOperationImpl newNdbRecordOperationImpl(Table table) {
        return this.clusterConnection.newNdbRecordOperationImpl(this, table);
    }

    public NdbIndexScanOperation.IndexBound createIndexBound() {
        ++this.numberOfIndexBoundCreated;
        return NdbIndexScanOperation.IndexBound.create();
    }

    public void delete(NdbIndexScanOperation.IndexBound indexBound) {
        ++this.numberOfIndexBoundDeleted;
        NdbIndexScanOperation.IndexBound.delete(indexBound);
    }

    public NdbInterpretedCode createInterpretedCode(NdbDictionary.TableConst tableConst, int n) {
        ++this.numberOfInterpretedCodeCreated;
        return NdbInterpretedCode.create(tableConst, null, n);
    }

    public void delete(NdbInterpretedCode ndbInterpretedCode) {
        ++this.numberOfInterpretedCodeDeleted;
        NdbInterpretedCode.delete(ndbInterpretedCode);
    }

    public NdbScanFilter createScanFilter(NdbInterpretedCode ndbInterpretedCode) {
        ++this.numberOfNdbScanFilterCreated;
        return NdbScanFilter.create(ndbInterpretedCode);
    }

    public void delete(NdbScanFilter ndbScanFilter) {
        ++this.numberOfNdbScanFilterDeleted;
        NdbScanFilter.delete(ndbScanFilter);
    }

    public NdbScanOperation.ScanOptions createScanOptions() {
        ++this.numberOfScanOptionsCreated;
        return NdbScanOperation.ScanOptions.create();
    }

    public void delete(NdbScanOperation.ScanOptions scanOptions) {
        ++this.numberOfScanOptionsDeleted;
        NdbScanOperation.ScanOptions.delete(scanOptions);
    }

    public long getAutoincrementValue(Table table) {
        long[] lArray = new long[]{0L, this.autoIncrementBatchSize, this.autoIncrementStep, this.autoIncrementStart};
        int n = this.ndb.getAutoIncrementValue(((TableImpl)table).ndbTable, lArray, this.autoIncrementBatchSize, this.autoIncrementStep, this.autoIncrementStart);
        this.handleError(n, this.ndb);
        long l = lArray[0];
        if (logger.isDetailEnabled()) {
            logger.detail("getAutoIncrementValue(...batchSize: " + this.autoIncrementBatchSize + " step: " + this.autoIncrementStep + " start: " + this.autoIncrementStart + ") returned " + l);
        }
        return l;
    }

    public void initializeAutoIncrement(long[] lArray) {
        this.autoIncrementBatchSize = (int)lArray[0];
        this.autoIncrementStep = lArray[1];
        this.autoIncrementStart = lArray[2];
    }

    public class BufferManager {
        public static final int STRING_BYTE_BUFFER_INITIAL_SIZE = 1000;
        private int stringByteBufferCurrentSize = 1000;
        ByteBuffer stringByteBuffer = null;
        CharBuffer stringCharBuffer = null;
        public static final int STRING_STORAGE_BUFFER_INITIAL_SIZE = 500;
        private ByteBuffer stringStorageBuffer = ByteBuffer.allocateDirect(500);
        private static final int RESULT_DATA_BUFFER_INITIAL_SIZE = 8000;
        private ByteBuffer resultDataBuffer = ByteBuffer.allocateDirect(8000);

        public void guaranteeStringStorageBufferSize(int n) {
            if (n > this.stringStorageBuffer.capacity()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(local.message("MSG_Reallocated_Byte_Buffer", "string storage", this.stringStorageBuffer.capacity(), n));
                }
                this.stringStorageBuffer = ByteBuffer.allocateDirect(n);
            }
            this.stringStorageBuffer.limit(this.stringStorageBuffer.capacity());
        }

        public ByteBuffer copyStringToByteBuffer(CharSequence charSequence) {
            if (charSequence == null) {
                this.stringByteBuffer.limit(0);
                return this.stringByteBuffer;
            }
            int n = charSequence.length() * 2;
            this.guaranteeStringByteBufferSize(n);
            this.stringCharBuffer.append(charSequence);
            this.stringByteBuffer.limit(this.stringCharBuffer.position() * 2);
            return this.stringByteBuffer;
        }

        public void clearStringStorageBuffer() {
            this.stringStorageBuffer.clear();
        }

        public ByteBuffer getStringStorageBuffer(int n) {
            this.guaranteeStringStorageBufferSize(n);
            return this.stringStorageBuffer;
        }

        public ByteBuffer getStringByteBuffer(int n) {
            this.guaranteeStringByteBufferSize(n);
            return this.stringByteBuffer;
        }

        protected void guaranteeStringByteBufferSize(int n) {
            if (n > this.stringByteBufferCurrentSize) {
                this.stringByteBufferCurrentSize = n;
                this.stringByteBuffer = ByteBuffer.allocateDirect(this.stringByteBufferCurrentSize);
                this.stringCharBuffer = this.stringByteBuffer.asCharBuffer();
            }
            if (this.stringByteBuffer == null) {
                this.stringByteBuffer = ByteBuffer.allocateDirect(this.stringByteBufferCurrentSize);
                this.stringCharBuffer = this.stringByteBuffer.asCharBuffer();
            } else {
                this.stringByteBuffer.clear();
                this.stringCharBuffer.clear();
            }
        }

        public CharBuffer getStringCharBuffer() {
            return this.stringCharBuffer;
        }

        public ByteBuffer getResultDataBuffer(int n) {
            if (n > this.resultDataBuffer.capacity()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(local.message("MSG_Reallocated_Byte_Buffer", "result data", this.resultDataBuffer.capacity(), n));
                }
                this.resultDataBuffer = ByteBuffer.allocateDirect(n);
            }
            this.resultDataBuffer.clear();
            return this.resultDataBuffer;
        }
    }
}

