/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.IdBase;
import testsuite.clusterj.model.YearTypes;

public class QueryYearTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return YearTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllYearTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanYear();
        this.hashIndexScanYear();
        this.bothIndexScanYear();
        this.noneIndexScanYear();
        this.failOnError();
    }

    public void btreeIndexScanYear() {
        this.equalQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(8), 8);
        this.greaterEqualQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_not_null_btree", "idx_year_not_null_btree", this.getYear(4), this.getYear(6), 5);
        this.equalQuery("year_null_btree", "idx_year_null_btree", this.getYear(8), 8);
        this.greaterEqualQuery("year_null_btree", "idx_year_null_btree", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_null_btree", "idx_year_null_btree", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_null_btree", "idx_year_null_btree", this.getYear(4), this.getYear(6), 5);
    }

    public void hashIndexScanYear() {
        this.equalQuery("year_not_null_hash", "idx_year_not_null_hash", this.getYear(8), 8);
        this.greaterEqualQuery("year_not_null_hash", "none", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_not_null_hash", "none", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_not_null_hash", "none", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_not_null_hash", "none", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_not_null_hash", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_not_null_hash", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_not_null_hash", "none", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_not_null_hash", "none", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_not_null_hash", "none", this.getYear(4), this.getYear(6), 5);
        this.equalQuery("year_null_hash", "idx_year_null_hash", this.getYear(8), 8);
        this.greaterEqualQuery("year_null_hash", "none", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_null_hash", "none", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_null_hash", "none", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_null_hash", "none", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_null_hash", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_null_hash", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_null_hash", "none", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_null_hash", "none", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_null_hash", "none", this.getYear(4), this.getYear(6), 5);
    }

    public void bothIndexScanYear() {
        this.equalQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(8), 8);
        this.greaterEqualQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_not_null_both", "idx_year_not_null_both", this.getYear(4), this.getYear(6), 5);
        this.equalQuery("year_null_both", "idx_year_null_both", this.getYear(8), 8);
        this.greaterEqualQuery("year_null_both", "idx_year_null_both", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_null_both", "idx_year_null_both", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_null_both", "idx_year_null_both", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_null_both", "idx_year_null_both", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_null_both", "idx_year_null_both", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_null_both", "idx_year_null_both", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_null_both", "idx_year_null_both", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_null_both", "idx_year_null_both", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_null_both", "idx_year_null_both", this.getYear(4), this.getYear(6), 5);
    }

    public void noneIndexScanYear() {
        this.equalQuery("year_not_null_none", "none", this.getYear(8), 8);
        this.greaterEqualQuery("year_not_null_none", "none", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_not_null_none", "none", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_not_null_none", "none", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_not_null_none", "none", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_not_null_none", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_not_null_none", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_not_null_none", "none", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_not_null_none", "none", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_not_null_none", "none", this.getYear(4), this.getYear(6), 5);
        this.equalQuery("year_null_none", "none", this.getYear(8), 8);
        this.greaterEqualQuery("year_null_none", "none", this.getYear(7), 7, 8, 9);
        this.greaterThanQuery("year_null_none", "none", this.getYear(6), 7, 8, 9);
        this.lessEqualQuery("year_null_none", "none", this.getYear(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("year_null_none", "none", this.getYear(4), 3, 2, 1, 0);
        this.betweenQuery("year_null_none", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("year_null_none", "none", this.getYear(4), this.getYear(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("year_null_none", "none", this.getYear(4), this.getYear(6), 5, 6);
        this.greaterEqualAndLessThanQuery("year_null_none", "none", this.getYear(4), this.getYear(6), 4, 5);
        this.greaterThanAndLessThanQuery("year_null_none", "none", this.getYear(4), this.getYear(6), 5);
    }

    private void createAllYearTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            YearTypes yearTypes = (YearTypes)this.session.newInstance(YearTypes.class);
            yearTypes.setId(i);
            yearTypes.setYear_not_null_hash(this.getYear(i));
            yearTypes.setYear_not_null_btree(this.getYear(i));
            yearTypes.setYear_not_null_both(this.getYear(i));
            yearTypes.setYear_not_null_none(this.getYear(i));
            yearTypes.setYear_null_hash(this.getYear(i));
            yearTypes.setYear_null_btree(this.getYear(i));
            yearTypes.setYear_null_both(this.getYear(i));
            yearTypes.setYear_null_none(this.getYear(i));
            this.instances.add(yearTypes);
        }
    }

    protected Short getYear(int n) {
        return (short)(2000 + n);
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        if (idBase instanceof YearTypes) {
            YearTypes yearTypes = (YearTypes)idBase;
        }
    }

    public static String toString(IdBase idBase) {
        YearTypes yearTypes = (YearTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("YearTypes id: ");
        stringBuffer.append(yearTypes.getId());
        stringBuffer.append("; year_not_null_both: ");
        stringBuffer.append(yearTypes.getYear_not_null_both());
        stringBuffer.append("; year_not_null_btree: ");
        stringBuffer.append(yearTypes.getYear_not_null_btree());
        stringBuffer.append("; year_not_null_hash: ");
        stringBuffer.append(yearTypes.getYear_not_null_hash());
        stringBuffer.append("; year_not_null_none: ");
        stringBuffer.append(yearTypes.getYear_not_null_none());
        stringBuffer.append("; year_null_both: ");
        stringBuffer.append(yearTypes.getYear_null_both().toString());
        stringBuffer.append("; year_null_btree: ");
        stringBuffer.append(yearTypes.getYear_null_btree().toString());
        stringBuffer.append("; year_null_hash: ");
        stringBuffer.append(yearTypes.getYear_null_hash().toString());
        stringBuffer.append("; year_null_none: ");
        stringBuffer.append(yearTypes.getYear_null_none().toString());
        return stringBuffer.toString();
    }
}

