/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.NdbRecordBlobImpl;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NdbRecordOperationImpl
implements Operation {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordOperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordOperationImpl.class);
    protected ClusterTransactionImpl clusterTransaction = null;
    protected NdbOperationConst ndbOperation = null;
    protected NdbRecordImpl ndbRecordKeys = null;
    protected NdbRecordImpl ndbRecordValues = null;
    byte[] mask;
    ByteBuffer keyBuffer = null;
    ByteBuffer valueBuffer = null;
    protected NdbRecordBlobImpl[] blobs = null;
    protected List<NdbRecordBlobImpl> activeBlobs = new ArrayList<NdbRecordBlobImpl>();
    protected int keyBufferSize;
    protected int valueBufferSize;
    protected DbImpl.BufferManager bufferManager;
    protected String tableName;
    protected Table storeTable;
    protected Column[] storeColumns;
    int numberOfColumns;
    protected DbImpl db;
    protected boolean autoIncrement = false;
    protected int autoIncrementColumnId = 0;

    public NdbRecordOperationImpl(ClusterConnectionImpl clusterConnectionImpl, Db db, Table table) {
        this.db = (DbImpl)db;
        this.storeTable = table;
        Column column = table.getAutoIncrementColumn();
        if (column != null) {
            this.autoIncrement = true;
            this.autoIncrementColumnId = column.getColumnId();
        }
        logger.detail("autoIncrement for " + table.getName() + " is: " + this.autoIncrement);
        this.tableName = table.getName();
        this.ndbRecordKeys = this.ndbRecordValues = clusterConnectionImpl.getCachedNdbRecordImpl(table);
        this.valueBufferSize = this.ndbRecordValues.getBufferSize();
        this.keyBufferSize = this.ndbRecordKeys.getBufferSize();
        this.keyBuffer = this.valueBuffer = this.ndbRecordValues.newBuffer();
        this.storeColumns = this.ndbRecordValues.storeColumns;
        this.numberOfColumns = this.storeColumns.length;
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.bufferManager = ((DbImpl)db).getBufferManager();
        this.resetMask();
    }

    public NdbRecordOperationImpl(ClusterTransactionImpl clusterTransactionImpl, Table table) {
        this.clusterTransaction = clusterTransactionImpl;
        this.db = clusterTransactionImpl.db;
        this.bufferManager = clusterTransactionImpl.getBufferManager();
        this.storeTable = table;
        Column column = table.getAutoIncrementColumn();
        if (column != null) {
            this.autoIncrement = true;
            this.autoIncrementColumnId = column.getColumnId();
        }
        logger.detail("autoIncrement for " + table.getName() + " is: " + this.autoIncrement);
        this.tableName = table.getName();
        this.ndbRecordValues = clusterTransactionImpl.getCachedNdbRecordImpl(table);
        this.valueBufferSize = this.ndbRecordValues.getBufferSize();
        this.valueBuffer = this.ndbRecordValues.newBuffer();
        this.storeColumns = this.ndbRecordValues.storeColumns;
        this.numberOfColumns = this.ndbRecordValues.getNumberOfColumns();
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.resetMask();
    }

    public NdbRecordOperationImpl(NdbRecordOperationImpl ndbRecordOperationImpl) {
        this.ndbRecordValues = ndbRecordOperationImpl.ndbRecordValues;
        this.valueBufferSize = ndbRecordOperationImpl.valueBufferSize;
        this.ndbRecordKeys = this.ndbRecordValues;
        this.keyBufferSize = this.ndbRecordKeys.bufferSize;
        this.keyBuffer = this.valueBuffer = ndbRecordOperationImpl.valueBuffer;
        this.bufferManager = ndbRecordOperationImpl.bufferManager;
        this.tableName = ndbRecordOperationImpl.tableName;
        this.storeColumns = ndbRecordOperationImpl.ndbRecordValues.storeColumns;
        this.numberOfColumns = this.storeColumns.length;
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        for (int i = 0; i < ndbRecordOperationImpl.blobs.length; ++i) {
            if (ndbRecordOperationImpl.blobs[i] == null) continue;
            this.blobs[i] = new NdbRecordBlobImpl(this, ndbRecordOperationImpl.blobs[i]);
        }
        this.resetMask();
    }

    public void release() {
        if (logger.isDetailEnabled()) {
            logger.detail("NdbRecordOperationImpl.release");
        }
        this.ndbRecordValues = null;
        this.ndbRecordKeys = null;
        this.valueBuffer = null;
        this.keyBuffer = null;
        this.bufferManager = null;
        if (this.blobs != null) {
            for (int i = 0; i < this.blobs.length; ++i) {
                if (this.blobs[i] == null) continue;
                this.blobs[i].release();
                this.blobs[i] = null;
            }
            this.blobs = null;
        }
    }

    public NdbOperationConst insert(ClusterTransactionImpl clusterTransactionImpl) {
        if (this.autoIncrement && !this.isModified(this.autoIncrementColumnId)) {
            long l = this.db.getAutoincrementValue(this.storeTable);
            if (logger.isDebugEnabled()) {
                logger.debug("insert for " + this.storeTable.getName() + " autoincrement value: " + l);
            }
            this.ndbRecordValues.setAutoIncrementValue(this.valueBuffer, l);
            this.columnSet(this.autoIncrementColumnId);
        }
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.insertTuple(this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        clusterTransactionImpl.addOperationToCheck(this);
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.activeBlobs) {
            ndbRecordBlobImpl.setNdbBlob();
            ndbRecordBlobImpl.setValue();
        }
        return this.ndbOperation;
    }

    public NdbOperationConst delete(ClusterTransactionImpl clusterTransactionImpl) {
        this.keyBuffer.limit(this.keyBufferSize);
        this.keyBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.deleteTuple(this.ndbRecordKeys.getNdbRecord(), this.keyBuffer, this.mask, null);
        return this.ndbOperation;
    }

    public void update(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.updateTuple(this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        clusterTransactionImpl.addOperationToCheck(this);
        this.activeBlobs.clear();
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.blobs) {
            if (ndbRecordBlobImpl == null || !this.isColumnSet(ndbRecordBlobImpl.getColumnId())) continue;
            this.activeBlobs.add(ndbRecordBlobImpl);
            ndbRecordBlobImpl.setNdbBlob();
            ndbRecordBlobImpl.setValue();
        }
        if (!this.activeBlobs.isEmpty()) {
            clusterTransactionImpl.executeNoCommit();
        }
    }

    public void write(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.writeTuple(this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        clusterTransactionImpl.addOperationToCheck(this);
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.activeBlobs) {
            ndbRecordBlobImpl.setNdbBlob();
            ndbRecordBlobImpl.setValue();
        }
    }

    public void load(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.readTuple(this.ndbRecordKeys.getNdbRecord(), this.keyBuffer, this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.activeBlobs) {
            ndbRecordBlobImpl.setNdbBlob();
        }
    }

    protected void resetMask() {
        this.mask = new byte[1 + this.numberOfColumns / 8];
    }

    public void allocateValueBuffer() {
        this.valueBuffer = this.ndbRecordValues.newBuffer();
    }

    protected void activateBlobs() {
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.activeBlobs) {
            ndbRecordBlobImpl.setNdbBlob();
        }
    }

    @Override
    public void equalBigInteger(Column column, BigInteger bigInteger) {
        int n = this.ndbRecordKeys.setBigInteger(this.keyBuffer, column, bigInteger);
        this.columnSet(n);
    }

    @Override
    public void equalBoolean(Column column, boolean bl) {
        byte by = bl ? (byte)1 : 0;
        this.equalByte(column, by);
    }

    @Override
    public void equalByte(Column column, byte by) {
        int n = this.ndbRecordKeys.setByte(this.keyBuffer, column, by);
        this.columnSet(n);
    }

    @Override
    public void equalBytes(Column column, byte[] byArray) {
        int n = this.ndbRecordKeys.setBytes(this.keyBuffer, column, byArray);
        this.columnSet(n);
    }

    @Override
    public void equalDecimal(Column column, BigDecimal bigDecimal) {
        int n = this.ndbRecordKeys.setDecimal(this.keyBuffer, column, bigDecimal);
        this.columnSet(n);
    }

    @Override
    public void equalDouble(Column column, double d) {
        int n = this.ndbRecordKeys.setDouble(this.keyBuffer, column, d);
        this.columnSet(n);
    }

    @Override
    public void equalFloat(Column column, float f) {
        int n = this.ndbRecordKeys.setFloat(this.keyBuffer, column, f);
        this.columnSet(n);
    }

    @Override
    public void equalInt(Column column, int n) {
        int n2 = this.ndbRecordKeys.setInt(this.keyBuffer, column, n);
        this.columnSet(n2);
    }

    @Override
    public void equalLong(Column column, long l) {
        int n = this.ndbRecordKeys.setLong(this.keyBuffer, column, l);
        this.columnSet(n);
    }

    @Override
    public void equalShort(Column column, short s) {
        int n = this.ndbRecordKeys.setShort(this.keyBuffer, column, s);
        this.columnSet(n);
    }

    @Override
    public void equalString(Column column, String string) {
        int n = this.ndbRecordKeys.setString(this.keyBuffer, this.bufferManager, column, string);
        this.columnSet(n);
    }

    @Override
    public void getBlob(Column column) {
        this.getBlobHandle(column);
    }

    @Override
    public Blob getBlobHandle(Column column) {
        int n;
        NdbRecordBlobImpl ndbRecordBlobImpl;
        if (logger.isDetailEnabled()) {
            logger.detail("column: " + column.getName());
        }
        if ((ndbRecordBlobImpl = this.blobs[n = column.getColumnId()]) == null) {
            if (logger.isDetailEnabled()) {
                logger.detail("column: " + column.getName() + " was null; activating.");
            }
            this.columnSet(n);
            this.blobs[n] = ndbRecordBlobImpl = new NdbRecordBlobImpl(this, column);
            this.activeBlobs.add(ndbRecordBlobImpl);
        }
        return ndbRecordBlobImpl;
    }

    @Override
    public void getValue(Column column) {
        int n = column.getColumnId();
        this.columnSet(n);
    }

    @Override
    public void postExecuteCallback(Runnable runnable) {
        this.clusterTransaction.postExecuteCallback(runnable);
    }

    @Override
    public ResultData resultData() {
        return this.resultData(true);
    }

    @Override
    public ResultData resultData(boolean bl) {
        NdbRecordResultDataImpl ndbRecordResultDataImpl = new NdbRecordResultDataImpl(this);
        if (bl) {
            this.clusterTransaction.executeNoCommit(false, true);
        }
        return ndbRecordResultDataImpl;
    }

    @Override
    public void setBigInteger(Column column, BigInteger bigInteger) {
        if (bigInteger == null) {
            this.setNull(column);
        } else {
            int n = this.ndbRecordValues.setBigInteger(this.valueBuffer, column, bigInteger);
            this.columnSet(n);
        }
    }

    public void setBigInteger(int n, BigInteger bigInteger) {
        this.setBigInteger(this.storeColumns[n], bigInteger);
    }

    @Override
    public void setBoolean(Column column, Boolean bl) {
        byte by = bl != false ? (byte)1 : 0;
        this.setByte(column, by);
    }

    public void setBoolean(int n, boolean bl) {
        this.setBoolean(this.storeColumns[n], (Boolean)bl);
    }

    @Override
    public void setByte(Column column, byte by) {
        int n = this.ndbRecordValues.setByte(this.valueBuffer, column, by);
        this.columnSet(n);
    }

    public void setByte(int n, byte by) {
        this.setByte(this.storeColumns[n], by);
    }

    @Override
    public void setBytes(Column column, byte[] byArray) {
        if (logger.isDetailEnabled()) {
            logger.detail("NdbRecordOperationImpl.setBytes for: " + column.getName() + " value: " + Utility.dumpBytes(byArray));
        }
        if (byArray == null) {
            this.setNull(column);
        } else {
            int n = this.ndbRecordValues.setBytes(this.valueBuffer, column, byArray);
            this.columnSet(n);
        }
    }

    public void setBytes(int n, byte[] byArray) {
        this.setBytes(this.storeColumns[n], byArray);
    }

    @Override
    public void setDecimal(Column column, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setNull(column);
        } else {
            int n = this.ndbRecordValues.setDecimal(this.valueBuffer, column, bigDecimal);
            this.columnSet(n);
        }
    }

    public void setDecimal(int n, BigDecimal bigDecimal) {
        this.setDecimal(this.storeColumns[n], bigDecimal);
    }

    @Override
    public void setDouble(Column column, Double d) {
        int n = this.ndbRecordValues.setDouble(this.valueBuffer, column, d);
        this.columnSet(n);
    }

    public void setDouble(int n, double d) {
        this.setDouble(this.storeColumns[n], (Double)d);
    }

    @Override
    public void setFloat(Column column, Float f) {
        int n = this.ndbRecordValues.setFloat(this.valueBuffer, column, f.floatValue());
        this.columnSet(n);
    }

    public void setFloat(int n, float f) {
        this.setFloat(this.storeColumns[n], Float.valueOf(f));
    }

    @Override
    public void setInt(Column column, Integer n) {
        int n2 = this.ndbRecordValues.setInt(this.valueBuffer, column, n);
        this.columnSet(n2);
    }

    public void setInt(int n, int n2) {
        this.setInt(this.storeColumns[n], (Integer)n2);
    }

    @Override
    public void setLong(Column column, long l) {
        int n = this.ndbRecordValues.setLong(this.valueBuffer, column, l);
        this.columnSet(n);
    }

    public void setLong(int n, long l) {
        this.setLong(this.storeColumns[n], l);
    }

    @Override
    public void setNull(Column column) {
        int n = this.ndbRecordValues.setNull(this.valueBuffer, column);
        this.columnSet(n);
    }

    public void setNull(int n) {
        this.setNull(this.storeColumns[n]);
    }

    @Override
    public void setShort(Column column, Short s) {
        int n = this.ndbRecordValues.setShort(this.valueBuffer, column, s);
        this.columnSet(n);
    }

    public void setShort(int n, short s) {
        this.setShort(this.storeColumns[n], (Short)s);
    }

    public void setObjectBoolean(int n, Boolean bl) {
        Column column = this.storeColumns[n];
        if (bl == null) {
            this.setNull(column);
        } else {
            this.setBoolean(column, bl);
        }
    }

    public void setObjectByte(int n, Byte by) {
        Column column = this.storeColumns[n];
        if (by == null) {
            this.setNull(column);
        } else {
            this.setByte(column, (byte)by);
        }
    }

    public void setObjectDouble(int n, Double d) {
        Column column = this.storeColumns[n];
        if (d == null) {
            this.setNull(column);
        } else {
            this.setDouble(column, d);
        }
    }

    public void setObjectFloat(int n, Float f) {
        Column column = this.storeColumns[n];
        if (f == null) {
            this.setNull(column);
        } else {
            this.setFloat(column, f);
        }
    }

    public void setObjectInt(int n, Integer n2) {
        Column column = this.storeColumns[n];
        if (n2 == null) {
            this.setNull(column);
        } else {
            this.setInt(column, n2);
        }
    }

    public void setObjectLong(int n, Long l) {
        Column column = this.storeColumns[n];
        if (l == null) {
            this.setNull(column);
        } else {
            this.setLong(column, (long)l);
        }
    }

    public void setObjectShort(int n, Short s) {
        Column column = this.storeColumns[n];
        if (s == null) {
            this.setNull(column);
        } else {
            this.setShort(column, s);
        }
    }

    @Override
    public void setString(Column column, String string) {
        if (string == null) {
            this.setNull(column);
        } else {
            int n = this.ndbRecordValues.setString(this.valueBuffer, this.bufferManager, column, string);
            this.columnSet(n);
        }
    }

    public void setString(int n, String string) {
        this.setString(this.storeColumns[n], string);
    }

    @Override
    public int errorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    protected static void handleError(int n, NdbOperationConst ndbOperationConst) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbOperationConst.getNdbError());
    }

    protected static void handleError(Object object, NdbOperationConst ndbOperationConst) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperationConst.getNdbError());
    }

    protected static void handleError(Object object, NdbDictionary.Dictionary dictionary) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, dictionary.getNdbError());
    }

    public NdbBlob getNdbBlob(Column column) {
        if (this.ndbOperation == null) {
            throw new ClusterJFatalInternalException("NdbRecordOperationImpl.getNdbBlob with no ndbOperation.");
        }
        NdbBlob ndbBlob = this.ndbOperation.getBlobHandle(column.getColumnId());
        NdbRecordOperationImpl.handleError((Object)ndbBlob, this.ndbOperation);
        return ndbBlob;
    }

    public void activateBlobColumns() {
        for (Column column : this.storeColumns) {
            if (!column.isLob()) continue;
            this.getBlobHandle(column);
        }
    }

    protected void columnSet(int n) {
        int n2 = n / 8;
        int n3 = n - n2 * 8;
        int n4 = n2;
        this.mask[n4] = (byte)(this.mask[n4] | NdbRecordImpl.BIT_IN_BYTE_MASK[n3]);
    }

    protected boolean isColumnSet(int n) {
        int n2 = n / 8;
        int n3 = n - n2 * 8;
        byte by = NdbRecordImpl.BIT_IN_BYTE_MASK[n3];
        return (this.mask[n2] & by) == by;
    }

    public NdbRecordImpl getValueNdbRecord() {
        return this.ndbRecordValues;
    }

    public boolean getBoolean(int n) {
        return this.ndbRecordValues.getBoolean(this.valueBuffer, n);
    }

    public boolean getBoolean(Column column) {
        return this.ndbRecordValues.getBoolean(this.valueBuffer, column.getColumnId());
    }

    public boolean[] getBooleans(int n) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getBooleans(int)"));
    }

    public boolean[] getBooleans(Column column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getBooleans(Column)"));
    }

    public byte getByte(int n) {
        return this.ndbRecordValues.getByte(this.valueBuffer, n);
    }

    public byte getByte(Column column) {
        return this.ndbRecordValues.getByte(this.valueBuffer, column.getColumnId());
    }

    public short getShort(int n) {
        return this.ndbRecordValues.getShort(this.valueBuffer, n);
    }

    public short getShort(Column column) {
        return this.ndbRecordValues.getShort(this.valueBuffer, column.getColumnId());
    }

    public int getInt(int n) {
        return this.ndbRecordValues.getInt(this.valueBuffer, n);
    }

    public int getInt(Column column) {
        return this.getInt(column.getColumnId());
    }

    public long getLong(int n) {
        return this.ndbRecordValues.getLong(this.valueBuffer, n);
    }

    public float getFloat(int n) {
        return this.ndbRecordValues.getFloat(this.valueBuffer, n);
    }

    public float getFloat(Column column) {
        return this.getFloat(column.getColumnId());
    }

    public double getDouble(int n) {
        return this.ndbRecordValues.getDouble(this.valueBuffer, n);
    }

    public double getDouble(Column column) {
        return this.getDouble(column.getColumnId());
    }

    public String getString(int n) {
        return this.ndbRecordValues.getString(this.valueBuffer, n, this.bufferManager);
    }

    public String getString(Column column) {
        return this.ndbRecordValues.getString(this.valueBuffer, column.getColumnId(), this.bufferManager);
    }

    public byte[] getBytes(int n) {
        return this.ndbRecordValues.getBytes(this.valueBuffer, n);
    }

    public byte[] getBytes(Column column) {
        return this.ndbRecordValues.getBytes(this.valueBuffer, column);
    }

    public Object getObject(int n) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getObject(int)"));
    }

    public Object getObject(Column column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getObject(Column)"));
    }

    public boolean wasNull(Column column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.wasNull(Column)"));
    }

    public Boolean getObjectBoolean(int n) {
        return this.ndbRecordValues.getObjectBoolean(this.valueBuffer, n);
    }

    public Boolean getObjectBoolean(Column column) {
        return this.ndbRecordValues.getObjectBoolean(this.valueBuffer, column.getColumnId());
    }

    public Byte getObjectByte(int n) {
        return this.ndbRecordValues.getObjectByte(this.valueBuffer, n);
    }

    public Byte getObjectByte(Column column) {
        return this.ndbRecordValues.getObjectByte(this.valueBuffer, column.getColumnId());
    }

    public Float getObjectFloat(int n) {
        return this.ndbRecordValues.getObjectFloat(this.valueBuffer, n);
    }

    public Float getObjectFloat(Column column) {
        return this.ndbRecordValues.getObjectFloat(this.valueBuffer, column.getColumnId());
    }

    public Double getObjectDouble(int n) {
        return this.ndbRecordValues.getObjectDouble(this.valueBuffer, n);
    }

    public Double getObjectDouble(Column column) {
        return this.ndbRecordValues.getObjectDouble(this.valueBuffer, column.getColumnId());
    }

    public Integer getObjectInteger(int n) {
        return this.ndbRecordValues.getObjectInteger(this.valueBuffer, n);
    }

    public Integer getObjectInteger(Column column) {
        return this.ndbRecordValues.getObjectInteger(this.valueBuffer, column.getColumnId());
    }

    public Long getObjectLong(int n) {
        return this.ndbRecordValues.getObjectLong(this.valueBuffer, n);
    }

    public Long getObjectLong(Column column) {
        return this.ndbRecordValues.getObjectLong(this.valueBuffer, column.getColumnId());
    }

    public Short getObjectShort(int n) {
        return this.ndbRecordValues.getObjectShort(this.valueBuffer, n);
    }

    public Short getObjectShort(Column column) {
        return this.ndbRecordValues.getObjectShort(this.valueBuffer, column.getColumnId());
    }

    public BigInteger getBigInteger(int n) {
        return this.ndbRecordValues.getBigInteger(this.valueBuffer, n);
    }

    public BigInteger getBigInteger(Column column) {
        return this.ndbRecordValues.getBigInteger(this.valueBuffer, column);
    }

    public BigDecimal getDecimal(int n) {
        return this.ndbRecordValues.getDecimal(this.valueBuffer, n);
    }

    public BigDecimal getDecimal(Column column) {
        return this.ndbRecordValues.getDecimal(this.valueBuffer, column);
    }

    @Override
    public void beginDefinition() {
    }

    @Override
    public void endDefinition() {
    }

    @Override
    public void freeResourcesAfterExecute() {
    }

    public String dumpValues() {
        return this.ndbRecordValues.dumpValues(this.valueBuffer, this.mask);
    }

    public String dumpKeys() {
        return this.ndbRecordKeys.dumpValues(this.keyBuffer, null);
    }

    public boolean isModified(int n) {
        return this.ndbRecordValues.isPresent(this.mask, n);
    }

    public boolean isNull(int n) {
        return this.ndbRecordValues.isNull(this.valueBuffer, n);
    }

    public void markModified(int n) {
        this.ndbRecordValues.markPresent(this.mask, n);
    }

    public void resetModified() {
        this.mask = new byte[1 + this.numberOfColumns / 8];
    }

    public NdbRecordBlobImpl getBlobHandle(int n) {
        return (NdbRecordBlobImpl)this.getBlobHandle(this.storeColumns[n]);
    }

    @Override
    public int getErrorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    @Override
    public int getClassification() {
        return this.ndbOperation.getNdbError().classification();
    }

    @Override
    public int getMysqlCode() {
        return this.ndbOperation.getNdbError().mysql_code();
    }

    @Override
    public int getStatus() {
        return this.ndbOperation.getNdbError().status();
    }

    public String toString() {
        return this.tableName;
    }

    public void loadBlobValues() {
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.activeBlobs) {
            ndbRecordBlobImpl.readData();
        }
    }

    public NdbRecordOperationImpl transformNdbRecordOperationImpl() {
        this.keyBuffer = this.valueBuffer;
        this.resetModified();
        return this;
    }
}

