/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.DynamicObjectDelegate;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.StateManager;
import com.mysql.clusterj.core.StoreManager;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class InvocationHandlerImpl<T>
implements InvocationHandler,
StateManager,
ValueHandler,
DynamicObjectDelegate {
    static final I18NHelper local = I18NHelper.getInstance(InvocationHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(InvocationHandlerImpl.class);
    protected Object[] properties;
    protected int numberOfFields;
    protected Map<String, Class<?>> typemap = new HashMap();
    protected DomainTypeHandlerImpl<T> domainTypeHandler;
    BitSet modifiedFields;
    boolean modified = false;
    private Object proxy;
    private CacheManager objectManager;
    private Boolean found = null;

    public InvocationHandlerImpl(DomainTypeHandlerImpl<T> domainTypeHandlerImpl) {
        this.domainTypeHandler = domainTypeHandlerImpl;
        this.numberOfFields = domainTypeHandlerImpl.getNumberOfFields();
        this.properties = new Object[this.numberOfFields];
        this.modifiedFields = new BitSet(this.numberOfFields);
        domainTypeHandlerImpl.initializePrimitiveFields(this);
    }

    @Override
    public void release() {
        this.properties = null;
        this.typemap = null;
        this.domainTypeHandler = null;
        this.proxy = null;
        this.objectManager = null;
    }

    @Override
    public void setProxy(Object object) {
        this.proxy = object;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.objectManager = cacheManager;
        this.resetModified();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        int n;
        String string = method.getName();
        if (logger.isDetailEnabled()) {
            logger.detail("invoke with Method: " + method.getName());
        }
        String string2 = string.substring(3, 4);
        String string3 = string.substring(4);
        String string4 = string2.toLowerCase() + string3;
        if (string.startsWith("get")) {
            if (logger.isDetailEnabled()) {
                logger.detail("Property name: " + string4);
            }
            int n2 = this.domainTypeHandler.getFieldNumber(string4);
            if (logger.isDetailEnabled()) {
                logger.detail(string + ": Returning field number " + n2 + " value: " + this.properties[n2]);
            }
            return this.properties[n2];
        }
        if (string.startsWith("set")) {
            if (logger.isDetailEnabled()) {
                logger.detail("Property name: " + string4);
            }
            n = this.domainTypeHandler.getFieldNumber(string4);
            if (!this.modified && this.objectManager != null) {
                this.modified = true;
                this.objectManager.markModified(this);
                if (logger.isDetailEnabled()) {
                    logger.detail("modifying " + this);
                }
            }
        } else {
            if ("toString".equals(string)) {
                return this.domainTypeHandler.getDomainClass().getName() + this.pkToString(this.domainTypeHandler);
            }
            if ("hashCode".equals(string)) {
                return this.hashCode();
            }
            throw new ClusterJUserException(local.message("ERR_Method_Name", (Object)string));
        }
        this.modifiedFields.set(n);
        this.properties[n] = objectArray[0];
        return null;
    }

    @Override
    public void markModified(int n) {
        this.modifiedFields.set(n);
    }

    @Override
    public String pkToString(DomainTypeHandler<?> domainTypeHandler) {
        StringBuffer stringBuffer = new StringBuffer(" key: [");
        int[] nArray = domainTypeHandler.getKeyFieldNumbers();
        String string = "";
        for (int n : nArray) {
            stringBuffer.append(string);
            stringBuffer.append(this.properties[n]);
            string = ";";
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public void resetModified() {
        this.modified = false;
        this.modifiedFields.clear();
    }

    @Override
    public boolean isNull(int n) {
        return this.properties[n] == null;
    }

    public BigInteger bigIntegerValue(int n) {
        return (BigInteger)this.properties[n];
    }

    public boolean booleanValue(int n) {
        return (Boolean)this.properties[n];
    }

    public boolean[] booleansValue(int n) {
        return (boolean[])this.properties[n];
    }

    public byte[] bytesValue(int n) {
        return (byte[])this.properties[n];
    }

    public byte byteValue(int n) {
        return (Byte)this.properties[n];
    }

    public Byte objectByteValue(int n) {
        return (Byte)this.properties[n];
    }

    public java.util.Date javaUtilDateValue(int n) {
        return (java.util.Date)this.properties[n];
    }

    public Date javaSqlDateValue(int n) {
        return (Date)this.properties[n];
    }

    public Time javaSqlTimeValue(int n) {
        return (Time)this.properties[n];
    }

    public Timestamp javaSqlTimestampValue(int n) {
        return (Timestamp)this.properties[n];
    }

    public BigDecimal decimalValue(int n) {
        return (BigDecimal)this.properties[n];
    }

    public double doubleValue(int n) {
        return (Double)this.properties[n];
    }

    public float floatValue(int n) {
        return ((Float)this.properties[n]).floatValue();
    }

    public int intValue(int n) {
        if (logger.isDetailEnabled()) {
            logger.detail("intValue: Returning field number " + n + " value: " + this.properties[n]);
        }
        return (Integer)this.properties[n];
    }

    public Integer objectIntValue(int n) {
        return (Integer)this.properties[n];
    }

    public long longValue(int n) {
        return (Long)this.properties[n];
    }

    public short shortValue(int n) {
        return (Short)this.properties[n];
    }

    public String stringValue(int n) {
        if (logger.isDetailEnabled()) {
            logger.detail("stringValue: Returning field number " + n + " value: " + this.properties[n]);
        }
        return (String)this.properties[n];
    }

    public void setValue(int n, Object object) {
        if (logger.isDetailEnabled()) {
            logger.detail("setValue: Setting field number " + n + " to value " + object);
        }
        this.properties[n] = object;
    }

    @Override
    public void flush(StoreManager storeManager) {
    }

    @Override
    public boolean isModified(int n) {
        return this.modifiedFields.get(n);
    }

    @Override
    public BigInteger getBigInteger(int n) {
        return this.bigIntegerValue(n);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.booleanValue(n);
    }

    @Override
    public boolean[] getBooleans(int n) {
        return this.booleansValue(n);
    }

    @Override
    public Boolean getObjectBoolean(int n) {
        return this.booleanValue(n);
    }

    @Override
    public byte getByte(int n) {
        return this.byteValue(n);
    }

    @Override
    public byte[] getBytes(int n) {
        return this.bytesValue(n);
    }

    @Override
    public short getShort(int n) {
        return this.shortValue(n);
    }

    @Override
    public int getInt(int n) {
        return this.intValue(n);
    }

    @Override
    public long getLong(int n) {
        return this.longValue(n);
    }

    @Override
    public float getFloat(int n) {
        return this.floatValue(n);
    }

    @Override
    public double getDouble(int n) {
        return this.doubleValue(n);
    }

    @Override
    public byte[] getLobBytes(int n) {
        return this.bytesValue(n);
    }

    @Override
    public String getLobString(int n) {
        return this.stringValue(n);
    }

    @Override
    public Byte getObjectByte(int n) {
        return (Byte)this.properties[n];
    }

    @Override
    public Short getObjectShort(int n) {
        return (Short)this.properties[n];
    }

    @Override
    public Integer getObjectInt(int n) {
        return (Integer)this.properties[n];
    }

    @Override
    public Long getObjectLong(int n) {
        return (Long)this.properties[n];
    }

    @Override
    public Float getObjectFloat(int n) {
        return (Float)this.properties[n];
    }

    @Override
    public Double getObjectDouble(int n) {
        return (Double)this.properties[n];
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        return (BigDecimal)this.properties[n];
    }

    @Override
    public String getString(int n) {
        return (String)this.properties[n];
    }

    @Override
    public Date getJavaSqlDate(int n) {
        return (Date)this.properties[n];
    }

    @Override
    public java.util.Date getJavaUtilDate(int n) {
        return (java.util.Date)this.properties[n];
    }

    @Override
    public Time getJavaSqlTime(int n) {
        return (Time)this.properties[n];
    }

    @Override
    public Timestamp getJavaSqlTimestamp(int n) {
        return (Timestamp)this.properties[n];
    }

    @Override
    public void setBigInteger(int n, BigInteger bigInteger) {
        this.properties[n] = bigInteger;
    }

    @Override
    public void setBoolean(int n, boolean bl) {
        this.properties[n] = bl;
    }

    @Override
    public void setBooleans(int n, boolean[] blArray) {
        this.properties[n] = blArray;
    }

    @Override
    public void setByte(int n, byte by) {
        this.properties[n] = by;
    }

    @Override
    public void setBytes(int n, byte[] byArray) {
        this.properties[n] = byArray;
    }

    @Override
    public void setLobBytes(int n, byte[] byArray) {
        this.properties[n] = byArray;
    }

    @Override
    public void setLobString(int n, String string) {
        this.properties[n] = string;
    }

    @Override
    public void setShort(int n, short s) {
        this.properties[n] = s;
    }

    @Override
    public void setInt(int n, int n2) {
        this.properties[n] = n2;
    }

    @Override
    public void setLong(int n, long l) {
        this.properties[n] = l;
    }

    @Override
    public void setFloat(int n, float f) {
        this.properties[n] = Float.valueOf(f);
    }

    @Override
    public void setDouble(int n, double d) {
        this.properties[n] = d;
    }

    @Override
    public void setObjectBoolean(int n, Boolean bl) {
        this.properties[n] = bl;
    }

    @Override
    public void setObjectByte(int n, Byte by) {
        this.properties[n] = by;
    }

    @Override
    public void setObjectShort(int n, Short s) {
        this.properties[n] = s;
    }

    @Override
    public void setObjectInt(int n, Integer n2) {
        this.properties[n] = n2;
    }

    @Override
    public void setObjectLong(int n, Long l) {
        this.properties[n] = l;
    }

    @Override
    public void setObjectFloat(int n, Float f) {
        this.properties[n] = f;
    }

    @Override
    public void setObjectDouble(int n, Double d) {
        this.properties[n] = d;
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.properties[n] = bigDecimal;
    }

    @Override
    public void setString(int n, String string) {
        this.properties[n] = string;
    }

    @Override
    public void setObject(int n, Object object) {
        this.properties[n] = object;
    }

    @Override
    public void setJavaSqlDate(int n, Date date) {
        this.properties[n] = date;
    }

    @Override
    public void setJavaUtilDate(int n, java.util.Date date) {
        this.properties[n] = date;
    }

    @Override
    public void setJavaSqlTime(int n, Time time) {
        this.properties[n] = time;
    }

    @Override
    public void setJavaSqlTimestamp(int n, Timestamp timestamp) {
        this.properties[n] = timestamp;
    }

    @Override
    public Object get(int n) {
        return this.properties[n];
    }

    @Override
    public void set(int n, Object object) {
        this.modifiedFields.set(n);
        this.properties[n] = object;
    }

    @Override
    public ColumnMetadata[] columnMetadata() {
        return this.domainTypeHandler.columnMetadata();
    }

    @Override
    public void found(Boolean bl) {
        this.found = bl;
    }

    @Override
    public Boolean found() {
        return this.found;
    }
}

