/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.OperationImpl;
import com.mysql.clusterj.tie.ScanFilterImpl;
import com.mysql.clusterj.tie.ScanResultDataImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

class ScanOperationImpl
extends OperationImpl
implements ScanOperation {
    private NdbScanOperation ndbScanOperation;
    private Query.Ordering ordering = null;

    ScanOperationImpl(Table table, NdbScanOperation ndbScanOperation, ClusterTransactionImpl clusterTransactionImpl) {
        super(table, ndbScanOperation, clusterTransactionImpl);
        this.ndbScanOperation = ndbScanOperation;
    }

    @Override
    public void close() {
        this.ndbScanOperation.close(true, true);
    }

    @Override
    public void deleteCurrentTuple() {
        int n = this.ndbScanOperation.deleteCurrentTuple();
        this.handleError(n, this.ndbScanOperation);
    }

    @Override
    public ScanFilter getScanFilter(QueryExecutionContext queryExecutionContext) {
        NdbScanFilter ndbScanFilter = NdbScanFilter.create(this.ndbScanOperation);
        ScanOperationImpl.handleError(ndbScanFilter, this.ndbScanOperation);
        ScanFilterImpl scanFilterImpl = new ScanFilterImpl(ndbScanFilter);
        queryExecutionContext.addFilter(scanFilterImpl);
        return scanFilterImpl;
    }

    @Override
    public int nextResult(boolean bl) {
        int n = this.ndbScanOperation.nextResult(bl, false);
        this.clusterTransaction.handleError(n);
        return n;
    }

    @Override
    public ResultData resultData() {
        return this.resultData(true, 0L, Long.MAX_VALUE);
    }

    @Override
    public ResultData resultData(boolean bl, long l, long l2) {
        ScanResultDataImpl scanResultDataImpl = new ScanResultDataImpl(this.ndbScanOperation, this.storeColumns, this.maximumColumnId, this.bufferSize, this.offsets, this.lengths, this.maximumColumnLength, this.bufferManager, l, l2);
        this.clusterTransaction.executeNoCommit(false, true);
        return scanResultDataImpl;
    }

    @Override
    protected void handleError(int n, NdbOperation ndbOperation) {
        if (n == 0) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndbOperation.getNdbError();
        if (ndbErrorConst != null) {
            Utility.throwError(n, ndbErrorConst);
        } else {
            this.clusterTransaction.handleError(n);
        }
    }

    @Override
    public void setOrdering(Query.Ordering ordering) {
        this.ordering = ordering;
    }
}

