/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.AllPrimitives;
import testsuite.clusterj.model.Dn2id;
import testsuite.clusterj.model.Employee;
import testsuite.clusterj.model.IdBase;

public abstract class AbstractClusterJModelTest
extends AbstractClusterJTest {
    protected static TimeZone localSystemTimeZone = TimeZone.getDefault();
    protected static final long ONE_SECOND = 1000L;
    protected static final long ONE_MINUTE = 60000L;
    protected static final long ONE_HOUR = 3600000L;
    protected static final long TEN_HOURS = 36000000L;
    protected static final long ONE_DAY = 86400000L;
    String[] a1values = new String[]{"dc=abc", "dc=prs", "dc=xyz"};
    protected List<Employee> employees;
    protected List<Dn2id> dn2ids;
    protected static Object[] dn2idPK = AbstractClusterJModelTest.setupDn2idPK();
    protected List<IdBase> instances = new ArrayList<IdBase>();
    private List<Object[]> expected = null;
    ColumnDescriptor[] columnDescriptors = this.getColumnDescriptors();
    protected ClassLoader loader;

    protected static long getMillisFor(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(10, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    protected static long getMillisFor(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    protected static long getMillisFor(int n, int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, n + 1);
        calendar.set(10, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    protected boolean getCleanupAfterTest() {
        return true;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.setAutoCommit(connection, false);
        if (this.getModelClass() != null && this.getCleanupAfterTest()) {
            this.addTearDownClasses(this.getModelClass());
        }
    }

    protected static void resetLocalSystemDefaultTimeZone(Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select @@global.time_zone, @@global.system_time_zone, @@session.time_zone");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            connection.commit();
            string = "SYSTEM".equalsIgnoreCase(string) ? string2 : "GMT" + string;
            localSystemTimeZone = TimeZone.getTimeZone(string);
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("setServerTimeZone failed", sQLException);
        }
    }

    @Override
    protected void setAutoCommit(Connection connection, boolean bl) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("setAutoCommit failed", sQLException);
        }
    }

    protected void createEmployeeInstances(int n) {
        this.employees = new ArrayList<Employee>(n);
        for (int i = 0; i < n; ++i) {
            Employee employee = (Employee)this.session.newInstance(Employee.class);
            employee.setId(i);
            employee.setName("Employee number " + i);
            employee.setAge(i);
            employee.setMagic(i);
            this.employees.add(employee);
        }
    }

    protected void consistencyCheck(Employee employee) {
        int n;
        int n2;
        String string;
        int n3 = employee.getId();
        String string2 = "Employee number " + n3;
        if (!string2.equals(string = employee.getName())) {
            this.error("Employee " + n3 + " name mismatch; expected length: " + string2.length() + "'" + string2 + "'; actual length: " + string.length() + "'" + string + "'");
        }
        if ((n2 = employee.getAge().intValue()) != n3) {
            this.error("Employee " + n3 + " age mismatch; expected " + n3 + "'; actual '" + n2);
        }
        if ((n = employee.getMagic()) != n3) {
            this.error("Employee " + n3 + " magic mismatch; expected " + n3 + "'; actual '" + n);
        }
    }

    protected <T> void consistencyCheck(Iterable<T> iterable) {
        for (T t : iterable) {
            if (t instanceof Employee) {
                this.consistencyCheck((Employee)t);
                continue;
            }
            if (!(t instanceof Dn2id)) continue;
            this.consistencyCheck((Dn2id)t);
        }
    }

    protected void createDn2idInstances(int n) {
        this.dn2ids = new ArrayList<Dn2id>();
        for (int i = 0; i < n; ++i) {
            Dn2id dn2id = (Dn2id)this.session.newInstance(Dn2id.class);
            dn2id.setEid(i);
            dn2id.setObjectClasses("testObject");
            dn2id.setA0("dc=com");
            dn2id.setA1(this.getA1for(n, i));
            dn2id.setA2("ou=people");
            dn2id.setA3(this.getA3for(i));
            dn2id.setA4("");
            dn2id.setA5("");
            dn2id.setA6("");
            dn2id.setA7("");
            dn2id.setA8("");
            dn2id.setA9("");
            dn2id.setA10("");
            dn2id.setA11("");
            dn2id.setA12("");
            dn2id.setA13("");
            dn2id.setA14("");
            dn2id.setA15("");
            this.dn2ids.add(dn2id);
        }
    }

    protected void consistencyCheck(Dn2id dn2id) {
        String string;
        long l = dn2id.getEid();
        String string2 = this.getA3for(l);
        if (!string2.equals(string = dn2id.getA3())) {
            this.error("Dn2id " + l + " a3 mismatch; expected '" + string2 + "'; actual '" + string + "'");
        }
    }

    protected List<Object[]> getExpected() {
        return this.expected;
    }

    protected String getTableName() {
        return null;
    }

    protected int getNumberOfInstances() {
        return 0;
    }

    protected ColumnDescriptor[] getColumnDescriptors() {
        return null;
    }

    Class<? extends IdBase> getModelClass() {
        return null;
    }

    protected Object getColumnValue(int n, int n2) {
        return null;
    }

    protected void writeJDBCreadNDB() {
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> list = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        list = this.readFromNDB(this.columnDescriptors);
        this.verify("writeJDBCreadNDB", this.getExpected(), list);
    }

    protected void writeJDBCreadJDBC() {
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> list = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        list = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeJDBCreadJDBC", this.getExpected(), list);
    }

    protected void writeNDBreadNDB() {
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> list = null;
        this.writeToNDB(this.columnDescriptors, this.instances);
        list = this.readFromNDB(this.columnDescriptors);
        this.verify("writeNDBreadNDB", this.getExpected(), list);
    }

    protected void writeNDBreadJDBC() {
        this.generateInstances(this.getColumnDescriptors());
        this.removeAll(this.getModelClass());
        List<Object[]> list = null;
        this.writeToNDB(this.columnDescriptors, this.instances);
        list = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeNDBreadJDBC", this.getExpected(), list);
    }

    private String dumpListOfObjectArray(List<Object[]> list) {
        StringBuffer stringBuffer = new StringBuffer(list.size() + " rows\n");
        for (Object[] objectArray : list) {
            stringBuffer.append("Id: ");
            for (Object object : objectArray) {
                stringBuffer.append(object);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    protected void queryAndVerifyResults(String string, ColumnDescriptor[] columnDescriptorArray, String string2, Object[] objectArray, int ... nArray) {
        List<Object[]> list = this.queryJDBC(columnDescriptorArray, string2, objectArray);
        this.verifyQueryResults(string, list, nArray);
    }

    protected List<Object[]> queryJDBC(ColumnDescriptor[] columnDescriptorArray, String string, Object[] objectArray) {
        this.getConnection();
        String string2 = this.getTableName();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        StringBuffer stringBuffer = new StringBuffer("SELECT id");
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            stringBuffer.append(", ");
            stringBuffer.append(columnDescriptor.getColumnName());
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(string2);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string);
        String string3 = stringBuffer.toString();
        if (this.debug) {
            System.out.println(string3);
        }
        PreparedStatement preparedStatement = null;
        try {
            int sQLException = 1;
            preparedStatement = connection.prepareStatement(string3);
            for (Object object : objectArray) {
                preparedStatement.setObject(sQLException++, object);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object[] objectArray2 = new Object[columnDescriptorArray.length + 1];
                int n = 1;
                objectArray2[0] = resultSet.getInt(1);
                for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                    objectArray2[n] = columnDescriptor.getResultSetValue(resultSet, n + 1);
                    ++n;
                }
                arrayList.add(objectArray2);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to read " + string2, sQLException);
        }
        if (this.debug) {
            System.out.println("readFromJDBC: " + this.dumpObjectArray(arrayList));
        }
        return arrayList;
    }

    private String dumpObjectArray(List<Object[]> list) {
        StringBuffer stringBuffer = new StringBuffer(list.size() + " rows\n");
        for (Object[] objectArray : list) {
            stringBuffer.append("Id: ");
            for (Object object : objectArray) {
                stringBuffer.append(object);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    protected void verifyQueryResults(String string, List<Object[]> list, int ... nArray) {
        this.errorIfNotEqual(string + " mismatch in number of results.", nArray.length, list.size());
        for (Object[] objectArray : list) {
            int n = (Integer)objectArray[0];
            if (Arrays.binarySearch(nArray, n) >= 0) continue;
            this.error(string + " result " + n + " not expected.");
        }
    }

    protected void verify(String string, List<Object[]> list, List<Object[]> list2) {
        if (list.size() != list2.size()) {
            this.error(string + " failure on size of results: expected: " + list.size() + " actual: " + list2.size());
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = list.get(i);
            Object[] objectArray2 = list2.get(i);
            this.errorIfNotEqual(string + " got failure on id for row " + i, i, objectArray2[0]);
            for (int j = 1; j < objectArray.length; ++j) {
                this.errorIfNotEqual(string + " got failure to match column data for row " + i + " column " + j, objectArray[j], objectArray2[j]);
            }
        }
    }

    protected void generateInstances(ColumnDescriptor[] columnDescriptorArray) {
        Class<? extends IdBase> clazz = this.getModelClass();
        this.expected = new ArrayList<Object[]>();
        this.instances = new ArrayList<IdBase>();
        IdBase idBase = null;
        int n = this.getNumberOfInstances();
        for (int i = 0; i < n; ++i) {
            idBase = this.getNewInstance(clazz);
            idBase.setId(i);
            int n2 = 0;
            for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                Object object = this.getColumnValue(i, n2);
                if (this.debug) {
                    System.out.println("generateInstances set field " + columnDescriptor.getColumnName() + " to value " + object);
                }
                columnDescriptor.setFieldValue(idBase, object);
                Object object2 = columnDescriptor.getFieldValue(idBase);
                this.errorIfNotEqual("generateInstances value mismatch for " + columnDescriptor.getColumnName(), AbstractClusterJModelTest.dump(object), AbstractClusterJModelTest.dump(object2));
                ++n2;
            }
            this.instances.add(idBase);
            Object[] objectArray = this.createRow(columnDescriptorArray, idBase);
            this.expected.add(objectArray);
        }
        if (this.debug) {
            System.out.println("Created " + this.instances.size() + " instances of " + clazz.getName());
        }
    }

    protected IdBase getNewInstance(Class<? extends IdBase> clazz) {
        IdBase idBase = (IdBase)this.session.newInstance(clazz);
        return idBase;
    }

    protected void writeToJDBC(ColumnDescriptor[] columnDescriptorArray, List<IdBase> list) {
        String string = this.getTableName();
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(string);
        stringBuffer.append(" (id");
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            stringBuffer.append(", ");
            stringBuffer.append(columnDescriptor.getColumnName());
        }
        stringBuffer.append(") VALUES (?");
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            stringBuffer.append(", ?");
        }
        stringBuffer.append(")");
        String string2 = stringBuffer.toString();
        if (this.debug) {
            System.out.println(string2);
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(string2);
            if (this.debug) {
                System.out.println(preparedStatement.toString());
            }
            for (n = 0; n < list.size(); ++n) {
                IdBase idBase = list.get(n);
                preparedStatement.setInt(1, idBase.getId());
                int n2 = 2;
                for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                    Object object = columnDescriptor.getFieldValue(idBase);
                    columnDescriptor.setPreparedStatementValue(preparedStatement, n2++, object);
                    if (!this.debug) continue;
                    System.out.println("writeToJDBC set column: " + columnDescriptor.getColumnName() + " to value: " + object);
                }
                preparedStatement.execute();
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to insert " + string + " at instance " + n, sQLException);
        }
    }

    protected void writeToNDB(ColumnDescriptor[] columnDescriptorArray, List<IdBase> list) {
        this.session.currentTransaction().begin();
        this.session.makePersistentAll(list);
        this.session.currentTransaction().commit();
    }

    protected List<Object[]> readFromNDB(ColumnDescriptor[] columnDescriptorArray) {
        Class<? extends IdBase> clazz = this.getModelClass();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        this.session.currentTransaction().begin();
        for (int i = 0; i < this.getNumberOfInstances(); ++i) {
            IdBase idBase = (IdBase)this.session.find(clazz, (Object)i);
            if (idBase == null) continue;
            Object[] objectArray = this.createRow(columnDescriptorArray, idBase);
            arrayList.add(objectArray);
        }
        this.session.currentTransaction().commit();
        if (this.debug) {
            System.out.println("readFromNDB: " + this.dumpListOfObjectArray(arrayList));
        }
        return arrayList;
    }

    private Object[] createRow(ColumnDescriptor[] columnDescriptorArray, IdBase idBase) {
        Object[] objectArray = new Object[columnDescriptorArray.length + 1];
        objectArray[0] = idBase.getId();
        int n = 1;
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            objectArray[n++] = columnDescriptor.getFieldValue(idBase);
        }
        return objectArray;
    }

    protected List<Object[]> readFromJDBC(ColumnDescriptor[] columnDescriptorArray) {
        String string = this.getTableName();
        ArrayList<Object[]> arrayList = new ArrayList();
        TreeSet<Object[]> treeSet = new TreeSet<Object[]>(new Comparator<Object[]>(){

            @Override
            public int compare(Object[] objectArray, Object[] objectArray2) {
                return (Integer)objectArray[0] - (Integer)objectArray2[0];
            }
        });
        StringBuffer stringBuffer = new StringBuffer("SELECT id");
        for (ColumnDescriptor sQLException : columnDescriptorArray) {
            stringBuffer.append(", ");
            stringBuffer.append(sQLException.getColumnName());
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        if (this.debug) {
            System.out.println(string2);
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object[] objectArray = new Object[columnDescriptorArray.length + 1];
                int n2 = 1;
                objectArray[0] = resultSet.getInt(1);
                for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                    objectArray[n2] = columnDescriptor.getResultSetValue(resultSet, n2 + 1);
                    ++n2;
                }
                ++n;
                treeSet.add(objectArray);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to read " + string + " at instance " + n, sQLException);
        }
        arrayList = new ArrayList<Object[]>(treeSet);
        if (this.debug) {
            System.out.println("readFromJDBC: " + this.dumpListOfObjectArray(arrayList));
        }
        return arrayList;
    }

    protected <T> T proxyFor(Class<T> clazz) {
        InvocationHandler invocationHandler = new InvocationHandler(){
            private Map<String, Object> values = new HashMap<String, Object>();

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                String string = method.getName();
                String string2 = string.substring(3);
                String string3 = string.substring(0, 3);
                if ("get".equals(string3)) {
                    return this.values.get(string2);
                }
                if ("set".equals(string3)) {
                    this.values.put(string2, objectArray[0]);
                    return null;
                }
                throw new RuntimeException("Not a get/set method: " + string);
            }
        };
        Object object = Proxy.newProxyInstance(this.loader, new Class[]{clazz}, invocationHandler);
        return (T)object;
    }

    protected String getA1for(int n, int n2) {
        int n3 = 1 + n / this.a1values.length;
        return this.a1values[n2 / n3];
    }

    protected String getA3for(long l) {
        return "employeenumber=100000" + l;
    }

    protected void createAllPrimitivesInstances(int n) {
        this.createAllPrimitivesInstances(this.session, n);
    }

    protected void createAllPrimitivesInstances(Session session, int n) {
        for (int i = 0; i < n; ++i) {
            AllPrimitives allPrimitives = this.createAllPrimitiveInstance(session, i);
            this.instances.add(allPrimitives);
        }
    }

    protected AllPrimitives createAllPrimitiveInstance(Session session, int n) {
        AllPrimitives allPrimitives = (AllPrimitives)session.newInstance(AllPrimitives.class, (Object)n);
        this.initialize(allPrimitives, n);
        return allPrimitives;
    }

    protected void initialize(AllPrimitives allPrimitives, int n) {
        allPrimitives.setInt_not_null_hash(n);
        allPrimitives.setInt_not_null_btree(n);
        allPrimitives.setInt_not_null_both(n);
        allPrimitives.setInt_not_null_none(n);
        allPrimitives.setInt_null_hash(n);
        allPrimitives.setInt_null_btree(n);
        allPrimitives.setInt_null_both(n);
        allPrimitives.setInt_null_none(n);
        allPrimitives.setLong_not_null_hash(n);
        allPrimitives.setLong_not_null_btree(n);
        allPrimitives.setLong_not_null_both(n);
        allPrimitives.setLong_not_null_none(n);
        allPrimitives.setLong_null_hash(Long.valueOf(n));
        allPrimitives.setLong_null_btree(Long.valueOf(n));
        allPrimitives.setLong_null_both(Long.valueOf(n));
        allPrimitives.setLong_null_none(Long.valueOf(n));
        allPrimitives.setByte_not_null_hash((byte)n);
        allPrimitives.setByte_not_null_btree((byte)n);
        allPrimitives.setByte_not_null_both((byte)n);
        allPrimitives.setByte_not_null_none((byte)n);
        allPrimitives.setByte_null_hash((byte)n);
        allPrimitives.setByte_null_btree((byte)n);
        allPrimitives.setByte_null_both((byte)n);
        allPrimitives.setByte_null_none((byte)n);
        allPrimitives.setShort_not_null_hash((short)n);
        allPrimitives.setShort_not_null_btree((short)n);
        allPrimitives.setShort_not_null_both((short)n);
        allPrimitives.setShort_not_null_none((short)n);
        allPrimitives.setShort_null_hash((short)n);
        allPrimitives.setShort_null_btree((short)n);
        allPrimitives.setShort_null_both((short)n);
        allPrimitives.setShort_null_none((short)n);
    }

    protected static Object[] setupDn2idPK() {
        Object[] objectArray = new Object[16];
        objectArray[0] = "dc=com";
        objectArray[1] = "dc=example";
        objectArray[2] = "ou=people";
        objectArray[4] = "";
        objectArray[5] = "";
        objectArray[6] = "";
        objectArray[7] = "";
        objectArray[8] = "";
        objectArray[9] = "";
        objectArray[10] = "";
        objectArray[11] = "";
        objectArray[12] = "";
        objectArray[13] = "";
        objectArray[14] = "";
        objectArray[15] = "";
        return objectArray;
    }

    protected static interface InstanceHandler {
        public void setFieldValue(IdBase var1, Object var2);

        public Object getResultSetValue(ResultSet var1, int var2) throws SQLException;

        public Object getFieldValue(IdBase var1);

        public void setPreparedStatementValue(PreparedStatement var1, int var2, Object var3) throws SQLException;
    }

    protected static class ColumnDescriptor {
        private String columnName;
        protected InstanceHandler instanceHandler;

        public String getColumnName() {
            return this.columnName;
        }

        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return this.instanceHandler.getResultSetValue(resultSet, n);
        }

        public Object getFieldValue(IdBase idBase) {
            return this.instanceHandler.getFieldValue(idBase);
        }

        public void setFieldValue(IdBase idBase, Object object) {
            this.instanceHandler.setFieldValue(idBase, object);
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            this.instanceHandler.setPreparedStatementValue(preparedStatement, n, object);
        }

        public ColumnDescriptor(String string, InstanceHandler instanceHandler) {
            this.columnName = string;
            this.instanceHandler = instanceHandler;
        }
    }
}

