/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class AbstractClusterJTest
extends TestCase {
    static final Logger logger = LoggerFactoryService.getFactory().getInstance("com.mysql.clusterj.test");
    protected static final String JDBC_DRIVER_NAME = "jdbc.driverName";
    protected static final String JDBC_URL = "jdbc.url";
    protected static Connection connection;
    protected static String jdbcDriverName;
    protected static String jdbcPassword;
    protected static String jdbcURL;
    protected static String jdbcUsername;
    protected static Properties props;
    protected static List<String> schemaDefinition;
    protected static boolean schemaInitialized;
    String PROPS_FILE_NAME = System.getProperty("clusterj.properties", "clusterj.properties");
    protected Session session;
    protected SessionFactory sessionFactory;
    protected Transaction tx;
    protected StringBuffer errorMessages;
    private Collection<Class<?>> tearDownClasses = new LinkedList();
    private Collection<Object> tearDownInstances = new LinkedList<Object>();
    private String NL = "\n";
    protected boolean debug = this.getDebug();

    protected boolean getDebug() {
        return false;
    }

    protected void addTearDownClasses(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.tearDownClasses.add(clazz);
        }
    }

    protected void createSessionFactory() {
        if (this.sessionFactory == null) {
            this.loadProperties();
            Properties properties = this.modifyProperties();
            if (this.debug) {
                System.out.println("createSessionFactory props: " + properties);
            }
            this.sessionFactory = ClusterJHelper.getSessionFactory((Map)properties);
            this.loadSchema();
        }
    }

    protected Properties modifyProperties() {
        return props;
    }

    public void createSession() {
        if (this.session != null && !this.session.isClosed()) {
            this.tx = this.session.currentTransaction();
            if (this.tx.isActive()) {
                this.tx.commit();
            }
            this.session.close();
        }
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
    }

    protected void dumpSystemProperties() {
        Properties properties = System.getProperties();
        ArrayList<Map.Entry<Object, Object>> arrayList = new ArrayList<Map.Entry<Object, Object>>(properties.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> entry, Map.Entry<Object, Object> entry2) {
                return ((String)entry.getKey()).compareToIgnoreCase((String)entry2.getKey());
            }
        });
        for (Map.Entry entry : arrayList) {
            System.out.println("key: " + entry.getKey() + "; value: " + entry.getValue());
        }
    }

    protected void error(String string) {
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
    }

    protected void error(String string, Exception exception) {
        String string2 = string + " " + exception.getClass().getName() + ":" + exception.getMessage();
        this.error(string2);
        if (this.getDebug()) {
            exception.printStackTrace();
        }
    }

    protected void errorIfNotEqual(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
        this.errorMessages.append("Expected: " + (object == null ? "null" : object.toString()) + " actual: " + (object2 == null ? "null" : object2.toString()) + this.NL);
    }

    protected void errorIfNotEqual(String string, int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return;
        }
        if (nArray.length == nArray2.length) {
            int n;
            for (n = 0; n < nArray.length && nArray[n] == nArray2[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
        this.errorMessages.append("Expected: " + (nArray == null ? "null" : Arrays.toString(nArray)) + " actual: " + (nArray2 == null ? "null" : Arrays.toString(nArray2)) + this.NL);
    }

    protected void errorIfEqual(String string, Object object, Object object2) {
        if (object == null && object2 != null) {
            return;
        }
        if (object != null && !object.equals(object2)) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
        this.errorMessages.append("Error value: " + (object == null ? "null" : object.toString()));
    }

    protected void failOnError() {
        if (this.errorMessages != null) {
            AbstractClusterJTest.fail((String)this.errorMessages.toString());
        }
    }

    protected void closeConnection() {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Caught SQLException during close.", sQLException);
        }
        finally {
            connection = null;
        }
    }

    protected void getConnection(Properties properties) {
        Properties properties2 = new Properties();
        properties2.put("user", jdbcUsername);
        properties2.put("password", jdbcPassword);
        properties2.putAll((Map<?, ?>)properties);
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                connection = null;
            }
            if (this.debug) {
                System.out.println("Getting new connection with properties " + properties2);
            }
            connection = DriverManager.getConnection(jdbcURL, properties2);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new ClusterJException("Exception getting connection to " + jdbcURL + "; username " + jdbcUsername, (Throwable)sQLException);
        }
    }

    protected Connection getConnection() {
        if (connection == null) {
            try {
                Class.forName(jdbcDriverName, true, Thread.currentThread().getContextClassLoader());
                connection = DriverManager.getConnection(jdbcURL, jdbcUsername, jdbcPassword);
            }
            catch (SQLException sQLException) {
                throw new ClusterJException("Exception getting connection to " + jdbcURL + "; username " + jdbcUsername, (Throwable)sQLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClusterJException("Exception loading JDBC driver." + jdbcDriverName, (Throwable)classNotFoundException);
            }
        }
        return connection;
    }

    protected void getConnection(String string) {
        this.loadProperties(string);
        this.loadDriver();
        String string2 = props.getProperty(JDBC_URL);
        try {
            connection = DriverManager.getConnection(string2);
            this.setAutoCommit(connection, false);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Could not get Connection: " + string2, sQLException);
        }
    }

    protected void loadDriver() {
        String string = props.getProperty(JDBC_DRIVER_NAME);
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Class not found: " + string, classNotFoundException);
        }
    }

    protected void setAutoCommit(Connection connection, boolean bl) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("setAutoCommit failed", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSQL(String string) {
        Statement statement = null;
        try {
            boolean bl = connection.getAutoCommit();
            if (!bl) {
                connection.setAutoCommit(true);
            }
            statement = connection.createStatement();
            statement.execute(string);
            if (!bl) {
                connection.setAutoCommit(bl);
            }
        }
        catch (SQLException sQLException) {
            this.error("Caught " + sQLException.getClass() + " trying: " + string);
            if (statement == null) {
                this.error(this.analyzeWarnings(connection));
            } else {
                this.error(this.analyzeWarnings(statement));
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    this.error("Error closing statement " + string);
                }
            }
        }
    }

    protected String analyzeWarnings(Connection connection) {
        SQLWarning sQLWarning = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            sQLWarning = connection.getWarnings();
            this.analyzeWarnings(sQLWarning, stringBuilder);
        }
        catch (SQLException sQLException) {
            stringBuilder.append("Error getting warnings from connection:\n");
            stringBuilder.append(sQLException.getMessage());
        }
        return stringBuilder.toString();
    }

    protected String analyzeWarnings(Statement statement) {
        SQLWarning sQLWarning = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            sQLWarning = statement.getWarnings();
            this.analyzeWarnings(sQLWarning, stringBuilder);
        }
        catch (SQLException sQLException) {
            stringBuilder.append("Error getting warnings from statement:\n");
            stringBuilder.append(sQLException.getMessage());
        }
        return stringBuilder.toString();
    }

    protected StringBuilder analyzeWarnings(SQLWarning sQLWarning, StringBuilder stringBuilder) {
        if (sQLWarning != null) {
            stringBuilder.append(sQLWarning.getMessage());
            stringBuilder.append("\n");
            this.analyzeWarnings(sQLWarning.getNextWarning(), stringBuilder);
        }
        return stringBuilder;
    }

    Properties getProperties(String string) {
        Properties properties = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            properties = new Properties();
            properties.load(fileInputStream);
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (properties == null) {
            try {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string);
                properties = new Properties();
                properties.load(inputStream);
                return properties;
            }
            catch (IOException iOException) {
                AbstractClusterJTest.fail((String)("Could not create ConnectionFactory " + iOException));
            }
            catch (NullPointerException nullPointerException) {
                AbstractClusterJTest.fail((String)("Missing properties file " + string));
            }
        }
        return null;
    }

    protected void initializeErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new StringBuffer();
            this.errorMessages.append(this.NL);
        }
    }

    protected void initializeJDBC() {
        this.loadProperties();
        this.getConnection();
    }

    protected void initializeSchema() {
        this.getConnection();
        Iterator<String> iterator = schemaDefinition.iterator();
        iterator.next();
        iterator.next();
        String string = null;
        try {
            while (iterator.hasNext()) {
                string = iterator.next();
                if (this.debug) {
                    System.out.println("Executing statement " + string + ";");
                }
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                preparedStatement.execute();
                preparedStatement.close();
            }
            schemaInitialized = true;
            System.out.println("Successfully initialized schema.");
        }
        catch (SQLException sQLException) {
            this.resetSchema();
            throw new ClusterJException("initializeSchema threw exception on " + string, (Throwable)sQLException);
        }
    }

    protected void loadProperties() {
        this.loadProperties(this.PROPS_FILE_NAME);
    }

    protected void loadProperties(String string) {
        props = this.getProperties(string);
        jdbcDriverName = props.getProperty("com.mysql.clusterj.jdbc.driver");
        jdbcURL = props.getProperty("com.mysql.clusterj.jdbc.url");
        jdbcUsername = props.getProperty("com.mysql.clusterj.jdbc.username");
        jdbcPassword = props.getProperty("com.mysql.clusterj.jdbc.password");
        if (jdbcPassword == null) {
            jdbcPassword = "";
        }
    }

    protected void loadSchema() {
        this.initializeJDBC();
        if (!schemaInitialized) {
            this.loadSchemaDefinition();
            if (!this.testSchema()) {
                this.initializeSchema();
            }
        }
    }

    protected void loadSchemaDefinition() {
        InputStream inputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema.sql");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string.contains("#")) continue;
                int n = string.indexOf(";");
                if (n != -1) {
                    stringBuffer.append(string.substring(0, n));
                    schemaDefinition.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            throw new ClusterJException("Exception reading schema.sql.", (Throwable)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void localSetUp() {
    }

    protected void localTearDown() {
    }

    protected final void setUp() throws Exception {
        this.localSetUp();
    }

    protected final void tearDown() throws Exception {
        this.localTearDown();
        if (this.session != null && !this.session.isClosed()) {
            if (this.tx == null) {
                this.tx = this.session.currentTransaction();
            }
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            if (!this.tearDownClasses.isEmpty() | !this.tearDownInstances.isEmpty()) {
                this.tx.begin();
                for (Class<?> object : this.tearDownClasses) {
                    this.session.deletePersistentAll(object);
                }
                for (Object object : this.tearDownInstances) {
                    this.session.deletePersistent(object);
                }
                this.tx.commit();
                this.session.close();
                this.session = null;
            }
        }
        this.session = null;
        this.sessionFactory = null;
    }

    protected void removeAll(Class<?> clazz) {
        this.sessionFactory.getSession();
        this.session.currentTransaction().begin();
        this.session.deletePersistentAll(clazz);
        this.session.currentTransaction().commit();
    }

    protected boolean testSchema() {
        try {
            Statement statement = connection.createStatement();
            statement.execute(schemaDefinition.get(1));
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            if (this.debug) {
                sQLException.printStackTrace();
            }
            System.out.println("Test schema failed (normal) " + schemaDefinition.get(1));
            return false;
        }
    }

    protected boolean resetSchema() {
        try {
            Statement statement = connection.createStatement();
            statement.execute(schemaDefinition.get(0));
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            System.out.println("Test schema failed (normal) " + schemaDefinition.get(0));
            return false;
        }
    }

    protected static String dump(String string) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append((int)c);
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected String dump(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            stringBuffer.append(AbstractClusterJTest.dump(string));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static String dumpBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("byte[");
        stringBuffer.append(byArray.length);
        stringBuffer.append("]: [");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String dump(Object object) {
        if (object instanceof byte[]) {
            return AbstractClusterJTest.dumpBytes((byte[])object);
        }
        return object.toString();
    }

    static {
        schemaDefinition = new ArrayList<String>();
        schemaInitialized = false;
    }

    public static class MyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static List<Throwable> uncaughtExceptions = new ArrayList<Throwable>();

        public List<Throwable> getUncaughtExceptions() {
            return uncaughtExceptions;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            uncaughtExceptions.add(throwable);
        }
    }
}

