/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainTypeHandlerFactoryImpl
implements DomainTypeHandlerFactory {
    static final I18NHelper local = I18NHelper.getInstance(DomainTypeHandlerFactoryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DomainTypeHandlerFactoryImpl.class);
    protected static List<DomainTypeHandlerFactory> domainTypeHandlerFactories;
    protected static StringBuffer domainTypeHandlerFactoryErrorMessages;

    @Override
    public <T> DomainTypeHandler<T> createDomainTypeHandler(Class<T> domainClass, Dictionary dictionary, ValueHandlerFactory valueHandlerFactory) {
        DomainTypeHandler<T> handler = null;
        StringBuffer errorMessages = new StringBuffer();
        for (DomainTypeHandlerFactory factory : domainTypeHandlerFactories) {
            try {
                errorMessages.append("Trying factory ");
                errorMessages.append(factory.toString());
                errorMessages.append("\n");
                handler = factory.createDomainTypeHandler(domainClass, dictionary, valueHandlerFactory);
                if (handler == null) continue;
                return handler;
            }
            catch (Exception ex) {
                errorMessages.append("Caught exception: ");
                errorMessages.append(ex.toString());
                errorMessages.append("\n");
            }
        }
        try {
            errorMessages.append("Trying standard factory com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl.\n");
            handler = new DomainTypeHandlerImpl<T>(domainClass, dictionary, valueHandlerFactory);
            DomainTypeHandlerImpl<T> i$ = handler;
            return i$;
        }
        catch (ClusterJException e) {
            errorMessages.append(e.toString());
            throw e;
        }
        catch (Exception e) {
            errorMessages.append(e.toString());
            throw new ClusterJUserException(errorMessages.toString(), e);
        }
        finally {
            String tableName;
            if (handler == null && (tableName = DomainTypeHandlerImpl.getTableName(domainClass)) != null) {
                logger.info(local.message("MSG_Removing_Schema", (Object)tableName, (Object)domainClass.getName()));
                dictionary.removeCachedTable(tableName);
            }
        }
    }

    static {
        domainTypeHandlerFactoryErrorMessages = new StringBuffer();
        domainTypeHandlerFactories = ClusterJHelper.getServiceInstances(DomainTypeHandlerFactory.class, Thread.currentThread().getContextClassLoader(), domainTypeHandlerFactoryErrorMessages);
        logger.info("Found " + domainTypeHandlerFactories.size() + " DomainTypeHandlerFactories");
        for (DomainTypeHandlerFactory factory : domainTypeHandlerFactories) {
            logger.info(factory.toString());
        }
    }
}

