/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.VarbinaryPK;

public class VarbinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<VarbinaryPK> instances = new ArrayList<VarbinaryPK>();

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(VarbinaryPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(VarbinaryPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] key = this.getPK(i);
            VarbinaryPK result = (VarbinaryPK)this.session.find(VarbinaryPK.class, (Object)key);
            this.verify(result, i, false);
        }
    }

    protected void update() {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            VarbinaryPK instance = this.createInstance(i);
            instance.setName(this.getValue(this.NUMBER_OF_INSTANCES - i));
            this.session.updatePersistent((Object)instance);
            this.verify(instance, i, true);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            byte[] key = this.getPK(i);
            VarbinaryPK instance = (VarbinaryPK)this.session.find(VarbinaryPK.class, (Object)key);
            this.verify(instance, i, true);
        }
    }

    protected void delete() {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            VarbinaryPK instance = this.createInstance(i);
            this.session.deletePersistent((Object)instance);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            byte[] key = this.getPK(i);
            VarbinaryPK instance = (VarbinaryPK)this.session.find(VarbinaryPK.class, (Object)key);
            this.errorIfNotEqual("Failed to delete instance: " + i, null, instance);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            VarbinaryPK instance = this.createInstance(i);
            if (this.getDebug()) {
                System.out.println(this.toString(instance));
            }
            this.instances.add(instance);
        }
    }

    protected VarbinaryPK createInstance(int index) {
        VarbinaryPK instance = (VarbinaryPK)this.session.newInstance(VarbinaryPK.class);
        instance.setId(this.getPK(index));
        instance.setNumber(index);
        instance.setName(this.getValue(index));
        return instance;
    }

    protected String toString(VarbinaryPK instance) {
        StringBuffer result = new StringBuffer();
        result.append("VarbinaryPK[");
        result.append(this.toString(instance.getId()));
        result.append("]: ");
        result.append(instance.getNumber());
        result.append(", \"");
        result.append(instance.getName());
        result.append("\".");
        return result.toString();
    }

    protected byte[] getPK(int index) {
        return new byte[]{0, (byte)(index / 256), (byte)(index % 256)};
    }

    protected String getValue(int index) {
        return "Value " + index;
    }

    protected void verify(VarbinaryPK instance, int index, boolean updated) {
        this.errorIfNotEqual("id failed", this.toString(this.getPK(index)), this.toString(instance.getId()));
        this.errorIfNotEqual("number failed", index, instance.getNumber());
        if (updated) {
            this.errorIfNotEqual("Value failed", this.getValue(this.NUMBER_OF_INSTANCES - index), instance.getName());
        } else {
            this.errorIfNotEqual("Value failed", this.getValue(index), instance.getName());
        }
    }

    private String toString(byte[] id) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            builder.append(String.valueOf(id[i]));
            builder.append('-');
        }
        return builder.toString();
    }
}

