/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.List;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.Employee;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMultipleParameterTest
extends AbstractQueryTest {
    @Override
    public Class<?> getInstanceType() {
        return Employee.class;
    }

    @Override
    void createInstances(int number) {
        this.createEmployeeInstances(10);
        this.instances.addAll(this.employees);
    }

    public void test() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        PredicateOperand param1 = dobj.param("param1");
        PredicateOperand param2 = dobj.param("param2");
        PredicateOperand propertyMagic = dobj.get("magic");
        PredicateOperand propertyId = dobj.get("id");
        dobj.where(propertyMagic.equal(param1).and(propertyId.between(param1, param2)));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("param1", (Object)4);
        query.setParameter("param2", (Object)5);
        List result = query.getResultList();
        this.errorIfNotEqual("Wrong size of result", 1, result.size());
        if (result.size() == 1) {
            this.errorIfNotEqual("Wrong result", 4, ((Employee)result.get(0)).getId());
        }
        this.failOnError();
    }

    public void testNegative() {
        try {
            QueryBuilder builder = this.session.getQueryBuilder();
            QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
            PredicateOperand param1 = dobj.param("param1");
            PredicateOperand param2 = dobj.param("param2");
            PredicateOperand propertyAge = dobj.get("magic");
            PredicateOperand propertyMagic = dobj.get("name");
            dobj.where(propertyAge.equal(param1).and(propertyMagic.between(param1, param2)));
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }
}

