/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.AllPrimitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLimitsTest
extends AbstractQueryTest {
    @Override
    public Class<?> getInstanceType() {
        return AllPrimitives.class;
    }

    @Override
    void createInstances(int number) {
        this.createAllPrimitivesInstances(10);
    }

    public void test() {
        this.setLimits(1L, 2L);
        this.inQuery("int_not_null_both", new Object[]{4, 6, 9}, "idx_int_not_null_both", 6, 9);
        this.setLimits(1L, 2L);
        this.inQuery("int_not_null_btree", new Object[]{4, 6, 9}, "idx_int_not_null_btree", 6, 9);
        this.setLimits(1L, 0L);
        this.equalQuery("int_not_null_btree", "idx_int_not_null_btree", 8, new int[0]);
        this.setLimits(1L, Long.MAX_VALUE);
        this.greaterEqualQuery("int_not_null_btree", "idx_int_not_null_btree", 7, 8, 9);
        this.setLimits(1L, 2L);
        this.greaterThanQuery("int_not_null_btree", "idx_int_not_null_btree", 6, 8, 9);
        this.setLimits(2L, 2L);
        this.lessEqualQuery("int_not_null_btree", "idx_int_not_null_btree", 4, 2, 3);
        this.setLimits(1L, 2L);
        this.lessThanQuery("int_not_null_btree", "idx_int_not_null_btree", 4, 1, 2);
        this.setLimits(1L, 2L);
        this.betweenQuery("int_not_null_btree", "idx_int_not_null_btree", 4, 6, 5, 6);
        this.setLimits(0L, 3L);
        this.equalQuery("int_not_null_hash", "idx_int_not_null_hash", 8, 8);
        this.setLimits(1L, 2L);
        this.equalQuery("int_not_null_both", "idx_int_not_null_both", 8, new int[0]);
        this.setLimits(1L, 2L);
        this.greaterEqualQuery("int_not_null_both", "idx_int_not_null_both", 7, 8, 9);
        this.setLimits(1L, 2L);
        this.greaterThanQuery("int_not_null_both", "idx_int_not_null_both", 6, 8, 9);
        this.setLimits(1L, 2L);
        this.lessEqualQuery("int_not_null_both", "idx_int_not_null_both", 4, 1, 2);
        this.setLimits(1L, 2L);
        this.lessThanQuery("int_not_null_both", "idx_int_not_null_both", 4, 1, 2);
        this.setLimits(1L, 2L);
        this.betweenQuery("int_not_null_both", "idx_int_not_null_both", 4, 6, 5, 6);
        this.setLimits(1L, 2L);
        this.equalQuery("int_not_null_none", "none", 8, new int[0]);
        this.setLimits(0L, 0L);
        this.equalQuery("int_not_null_none", "none", 8, new int[0]);
        this.setLimits(1L, 0L);
        this.equalQuery("int_not_null_none", "none", 8, new int[0]);
        this.failOnError();
    }

    public void testNegative() {
        if (this.session.currentTransaction().isActive()) {
            this.session.currentTransaction().rollback();
        }
        try {
            this.setLimits(-1L, 1L);
            this.equalQuery("int_not_null_none", "none", 8, new int[0]);
            this.error("Bad limit (-1, 1) should fail.");
        }
        catch (ClusterJUserException ex) {
            // empty catch block
        }
        if (this.session.currentTransaction().isActive()) {
            this.session.currentTransaction().rollback();
        }
        try {
            this.setLimits(1L, -1L);
            this.equalQuery("int_not_null_none", "none", 8, new int[0]);
            this.error("Bad limit (1, -1) should fail.");
        }
        catch (ClusterJUserException ex) {
            // empty catch block
        }
        if (this.session.currentTransaction().isActive()) {
            this.session.currentTransaction().rollback();
        }
        try {
            this.setLimits(0L, 1L);
            this.deleteEqualQuery("int_not_null_none", "none", 8, 1);
            this.error("Bad limit for delete should fail.");
        }
        catch (ClusterJUserException ex) {
            // empty catch block
        }
        if (this.session.currentTransaction().isActive()) {
            this.session.currentTransaction().rollback();
        }
        try {
            this.setLimits(1L, 1L);
            this.deleteEqualQuery("int_not_null_none", "none", 8, 1);
            this.error("Bad limit for delete should fail.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
        this.failOnError();
    }
}

