/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.IdBase;
import testsuite.clusterj.model.StringTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLikeTest
extends AbstractQueryTest {
    static String[] strings = new String[]{"Alabama", "Arkansas", "Delaware", "New Jersey", "New York", "Pennsylvania", "Rhode Island", "Texax", "Virginia", "Wyoming"};

    @Override
    public Class<?> getInstanceType() {
        return StringTypes.class;
    }

    @Override
    void createInstances(int number) {
        this.createAllStringTypesInstances(number);
    }

    public void test() {
        this.btreeIndexScanString();
        this.hashIndexScanString();
        this.bothIndexScanString();
        this.noneIndexScanString();
        this.failOnError();
    }

    public void btreeIndexScanString() {
        this.likeQuery("string_not_null_btree", "none", "%", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.likeQuery("string_not_null_btree", "none", "_", new int[0]);
        this.likeQuery("string_not_null_btree", "none", "_____", 7);
        this.likeQuery("string_not_null_btree", "none", "%York", 4);
        this.likeQuery("string_not_null_btree", "none", "New York", 4);
        this.likeQuery("string_not_null_btree", "none", "New Yor_", 4);
        this.likeQuery("string_not_null_btree", "none", "New%", 3, 4);
        this.greaterEqualAndLikeQuery("string_not_null_btree", "idx_string_not_null_btree", this.getString(4), "%", 4, 5, 6, 7, 8, 9);
        this.greaterEqualAndLikeQuery("string_not_null_btree", "idx_string_not_null_btree", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_btree", "idx_string_not_null_btree", this.getString(4), "%e%", 5, 6, 7);
    }

    public void hashIndexScanString() {
        this.greaterEqualAndLikeQuery("string_not_null_hash", "none", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_hash", "none", this.getString(4), "%e%", 5, 6, 7);
    }

    public void bothIndexScanString() {
        this.greaterEqualAndLikeQuery("string_not_null_both", "idx_string_not_null_both", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_both", "idx_string_not_null_both", this.getString(4), "%e%", 5, 6, 7);
    }

    public void noneIndexScanString() {
        this.greaterEqualAndLikeQuery("string_not_null_none", "none", this.getString(4), "%enns%", 5);
        this.greaterThanAndLikeQuery("string_not_null_none", "none", this.getString(4), "%e%", 5, 6, 7);
    }

    private void createAllStringTypesInstances(int number) {
        for (int i = 0; i < number; ++i) {
            StringTypes instance = (StringTypes)this.session.newInstance(StringTypes.class);
            instance.setId(i);
            instance.setString_not_null_hash(this.getString(i));
            instance.setString_not_null_btree(this.getString(i));
            instance.setString_not_null_both(this.getString(i));
            instance.setString_not_null_none(this.getString(i));
            instance.setString_null_hash(this.getString(i));
            instance.setString_null_btree(this.getString(i));
            instance.setString_null_both(this.getString(i));
            instance.setString_null_none(this.getString(i));
            this.instances.add(instance);
        }
    }

    protected String getString(int number) {
        return strings[number];
    }

    @Override
    protected void printResultInstance(IdBase instance) {
        if (instance instanceof StringTypes) {
            StringTypes stringTypes = (StringTypes)instance;
        }
    }

    public static String toString(IdBase idBase) {
        StringTypes instance = (StringTypes)idBase;
        StringBuffer buffer = new StringBuffer("StringTypes id: ");
        buffer.append(instance.getId());
        buffer.append("; string_not_null_both: ");
        buffer.append(instance.getString_not_null_both());
        buffer.append("; string_not_null_btree: ");
        buffer.append(instance.getString_not_null_btree());
        buffer.append("; string_not_null_hash: ");
        buffer.append(instance.getString_not_null_hash());
        buffer.append("; string_not_null_none: ");
        buffer.append(instance.getString_not_null_none());
        buffer.append("; string_null_both: ");
        buffer.append(instance.getString_null_both().toString());
        buffer.append("; string_null_btree: ");
        buffer.append(instance.getString_null_btree().toString());
        buffer.append("; string_null_hash: ");
        buffer.append(instance.getString_null_hash().toString());
        buffer.append("; string_null_none: ");
        buffer.append(instance.getString_null_none().toString());
        return buffer.toString();
    }
}

