/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.Map;
import java.util.Properties;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class DefaultConnectValuesTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 1;

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(1);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    protected Properties modifyProperties() {
        Properties modifiedProperties = new Properties();
        modifiedProperties.putAll((Map<?, ?>)props);
        modifiedProperties.remove("com.mysql.clusterj.connect.delay");
        modifiedProperties.remove("com.mysql.clusterj.connect.retries");
        modifiedProperties.remove("com.mysql.clusterj.connect.timeout.after");
        modifiedProperties.remove("com.mysql.clusterj.connect.timeout.before");
        modifiedProperties.remove("com.mysql.clusterj.connect.verbose");
        modifiedProperties.remove("com.mysql.clusterj.database");
        modifiedProperties.remove("com.mysql.clusterj.max.transactions");
        return modifiedProperties;
    }

    public void testFind() {
        int i;
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int count = 0;
        for (i = 0; i < 1; ++i) {
            this.session.makePersistent(this.employees.get(i));
            ++count;
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 1; ++i) {
            Employee e = (Employee)this.session.find(Employee.class, (Object)i);
            this.consistencyCheck(e);
            int actualId = e.getId();
            if (actualId == i) continue;
            this.error("Expected Employee.id " + i + " but got " + actualId);
        }
        this.tx.commit();
        this.failOnError();
    }
}

